/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master.postactions;

import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.kernel.master.BuildUtils;
import com.dataiku.dip.dataflow.kernel.master.postactions.PostJobAction;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class RemoveIntermediatePartitionedModelVersions
extends PostJobAction {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.jobs.postactions.partitionedmodels.cleaning");

    public RemoveIntermediatePartitionedModelVersions(String projectKey, String jobId) {
        super(projectKey, jobId);
    }

    @Override
    public void run() throws Exception {
        logger.debug((Object)("Executing post-action " + this.getClass().getSimpleName()));
        File jobDefFile = FlowJobUtils.jobDefFile(false, this.projectKey, this.jobId);
        if (!jobDefFile.isFile()) {
            logger.info((Object)"No job.def file to read, skipping");
            return;
        }
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        SavedModelsDAO savedModelsDAO = (SavedModelsDAO)SpringUtils.getBean(SavedModelsDAO.class);
        JobDef jobDef = (JobDef)JSON.parseFile((File)jobDefFile, JobDef.class);
        HashSet<SavedModel> candidateSavedModelsToClean = new HashSet<SavedModel>();
        for (JobDef.JobOutput output : jobDef.outputs) {
            FlowComputable.FCType outputType;
            boolean isPartitionedModel;
            boolean bl = isPartitionedModel = !StringUtils.isBlank((String)output.targetPartition) && !StringUtils.equals((String)output.targetPartition, (String)"NP");
            if (!isPartitionedModel) continue;
            try (Transaction t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);){
                outputType = BuildUtils.detectOutputType(output);
            }
            if (outputType != FlowComputable.FCType.SAVED_MODEL) continue;
            t = transactionService.retrieveOrBeginRead(IsolationLevel.YOLO);
            try {
                SavedModel sm = (SavedModel)savedModelsDAO.getMandatory(output.targetDatasetProjectKey, output.targetDataset);
                if (!sm.isPartitioned()) continue;
                if (!sm.cleanTemporaryVersionsPostJob) {
                    logger.info((Object)("Not cleaning temporary versions for Saved Model " + sm.id));
                    continue;
                }
                logger.info((Object)("Registering Saved Model " + sm.id + " for cleaning temporary versions"));
                candidateSavedModelsToClean.add(sm);
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        if (candidateSavedModelsToClean.isEmpty()) {
            logger.trace((Object)"Nothing to clean, done");
            return;
        }
        PredictionSMMgmtService predictionSMMgmtService = (PredictionSMMgmtService)SpringUtils.getBean(PredictionSMMgmtService.class);
        for (SavedModel sm : candidateSavedModelsToClean) {
            predictionSMMgmtService.cleanTemporaryVersionsForPartitionedSavedModels(sm, this.jobId);
        }
    }
}

