/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.JobRunCodes;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.fs.AbstractFSLikeDatasetHandler;
import com.dataiku.dip.datasets.fs.BlobLikeFSProvider;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.FSLikeFSProvider;
import com.dataiku.dip.datasets.fs.FsProviderToReadWriteFSTransferer;
import com.dataiku.dip.datasets.fs.FsToFsProviderTransferer;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.input.utils.CountingProcessorOutput;
import com.dataiku.dip.partitioning.FileBucket;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractFSDatasetHandler
extends AbstractFSLikeDatasetHandler {
    private String isSingleFile;
    private FSProvider provider;
    List<FSPath> rootEnumerationCache;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.fsbased");

    public AbstractFSDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
    }

    public FSProvider getProvider() throws IOException, CodedException, DKUSecurityException {
        if (this.provider == null) {
            FSProviderAndPath built = this.buildOneProvider();
            this.provider = built.provider;
            this.isSingleFile = built.path;
        }
        return this.provider;
    }

    public FSProviderAndPath buildOneProvider() throws IOException, CodedException, DKUSecurityException {
        logger.debug((Object)("Building FS provider for dataset handler: " + this.getDataset().getFullName()));
        FSProviderAndPath providerAndPath = this.getProviderInternal(null);
        logger.debug((Object)"FS Provider built");
        FSProvider created = providerAndPath.provider;
        if (!this.dataset.isManaged() || DKUApp.getParams().getBoolParam("dku.datasets.managed.forceSingleFileCheck", false)) {
            String foundSingleFile;
            FSPathOrDirectory rootStatus;
            try {
                logger.debug((Object)"Checking single-file status: stating root");
                rootStatus = created.stat("");
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to check dataset root", (Throwable)e);
                try {
                    created.close();
                }
                catch (Exception e2) {
                    logger.warn((Object)"Failed to close fs-provider for testing single-file-ness", (Throwable)e2);
                }
                throw e;
            }
            if (rootStatus != null && !rootStatus.isDirectory) {
                Pair pathAndFileName = PathUtils.splitBasename((String)providerAndPath.path);
                foundSingleFile = (String)pathAndFileName.second;
                logger.debug((Object)"Found single file, reopening");
                try {
                    created.close();
                }
                catch (Exception e) {
                    throw new IOException("Failed to close fs-provider for testing single-file-ness", e);
                }
                created = this.getProviderInternal((String)((String)pathAndFileName.first)).provider;
                logger.debug((Object)"Single-file provider reopened");
            } else {
                foundSingleFile = null;
            }
            return new FSProviderAndPath(created, foundSingleFile);
        }
        return new FSProviderAndPath(created, null);
    }

    public void closeProvider() throws IOException {
        if (this.provider != null) {
            try {
                this.provider.close();
            }
            finally {
                this.provider = null;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closeProvider();
    }

    public abstract FSProviderAndPath getProviderInternal(@Nullable String var1) throws IOException, CodedException, DKUSecurityException;

    @Override
    public boolean isManaged() {
        return this.dataset.isManaged();
    }

    @Override
    public String suggestName() throws CodedException, DKUSecurityException {
        assert (this.dataset.getParams() instanceof AbstractFSConfig);
        String path = ((AbstractFSConfig)this.dataset.getParams()).path;
        if (path == null || path.length() == 0) {
            return null;
        }
        if ("/".equals(path)) {
            return "root";
        }
        return DatasetHandlerFactory.nameFromFileName((String)DKUtils.lastElement((Object[])path.split("/")));
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        this.throwNotSupportedIfRepeating();
        if (partition instanceof FilePartition) {
            return this.getSplitForPartitions(Lists.newArrayList((Object[])new FilePartition[]{(FilePartition)partition}));
        }
        InputFilter filter = new InputFilter().withSelectedPartition(partition);
        FilePartitioner.ResolvedFilesFilterResult res = this.getRequiredFiles(filter);
        return this.getSplitForPartitions(res.matchingFilePartitions);
    }

    public boolean matchesPartitioningScheme(String path) throws IOException {
        if (!this.dataset.getPartitioningSchema().isPartitioned()) {
            return true;
        }
        FSPath pathObj = new FSPath(path);
        try {
            return new FilePartitioner(this.dataset.getPartitioningSchema()).getPartitionsFromFiles(Lists.newArrayList((Object[])new FSPath[]{pathObj})).size() == 1;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        if (this.dataset.getParamsAs(AbstractFSConfig.class).variablesExpansionLoopConfig.isEnabled()) {
            FilterResultWithSplits ret = new FilterResultWithSplits();
            ret.setNeedsRefilter(true);
            ret.withSplit((InputSplit)this.getGlobalSplit());
            return ret;
        }
        FilePartitioner.ResolvedFilesFilterResult filtered = this.getRequiredFiles(filter);
        FilterResultWithSplits ret = new FilterResultWithSplits();
        for (Partition partition : filtered.matchingFilePartitions) {
            ret.withSplit(this.getPartitionSplit(partition)).withMatchingPartition(partition);
        }
        return ret;
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        List<FSPath> paths = this.enumerateFilesystem();
        FilePartitioner partitioner = new FilePartitioner(this.dataset.getPartitioningSchema());
        return new ArrayList<Partition>(partitioner.getPartitionsFromFiles(paths));
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        for (Partition _p : this.listPartitions()) {
            if (!_p.id().equals(p.id())) continue;
            return true;
        }
        return false;
    }

    public FilePartitioner.ResolvedFilesFilterResult getRequiredFiles(InputFilter filter) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        List<Object> paths;
        this.throwNotSupportedIfRepeating();
        FilePartitioner partitioner = new FilePartitioner(this.dataset.getPartitioningSchema());
        List<String> prefixes = partitioner.getPrefixesForFilter(filter);
        if (prefixes != null) {
            paths = Lists.newArrayList();
            for (String prefix : prefixes) {
                try {
                    paths.addAll(this.enumerateFilesystem(prefix, this.getEnumerationSettings()));
                }
                catch (DataStoreIOException e) {
                    if (FSProviderCodes.ERR_FSPROVIDER_PATH_DOES_NOT_EXIST.equals((Object)e.getCode()) && this.dataset.getPartitioningSchema().isPartitioned() && this.dataset.getPartitioningSchema().considerMissingRequestedPartitionsAsEmpty) {
                        logger.warn((Object)("Considering missing partition from prefix:" + prefix + "as empty"));
                        continue;
                    }
                    throw e;
                }
                catch (FileNotFoundException e) {
                    if (this.dataset.getPartitioningSchema().isPartitioned() && this.dataset.getPartitioningSchema().considerMissingRequestedPartitionsAsEmpty) {
                        logger.warn((Object)("Considering missing partition from prefix:" + prefix + "as empty"));
                        continue;
                    }
                    throw e;
                }
            }
        } else {
            logger.info((Object)"Enumerate FS");
            paths = this.enumerateFilesystem();
            logger.info((Object)"Enumerate done");
        }
        List<FilePartition> partitions = partitioner.getPartitionsFromFiles((List<FSPath>)paths);
        FilePartitioner.ResolvedFilesFilterResult filtered = partitioner.filterPartitionList(partitions, filter);
        return filtered;
    }

    public FilePartitioner.ResolvedFilesFilterResult getRequiredFiles(Partition partition) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        this.throwNotSupportedIfRepeating();
        if (FilePartitioner.isSchemeRepresentableAsFolder(this.dataset.getPartitioningSchema())) {
            ArrayList paths = this.enumeratePartition(partition, this.getEnumerationSettings());
            if (paths == null) {
                paths = Lists.newArrayList();
            }
            FilePartitioner partitioner = new FilePartitioner(this.dataset.getPartitioningSchema());
            FilePartitioner.ResolvedFilesFilterResult result = new FilePartitioner.ResolvedFilesFilterResult();
            result.matchingFilePartitions = partitioner.getPartitionsFromFiles(paths);
            return result;
        }
        InputFilter filter = new InputFilter();
        filter.setPartitionsClause((List)Lists.newArrayList((Object[])new Partition[]{partition}));
        return this.getRequiredFiles(filter);
    }

    public StreamsInputSplit getSplitForBucket(FilePartition fp, FileBucket bucket) throws IOException {
        return new BucketSplit(fp, bucket);
    }

    public StreamsInputSplit getSplitForFile(FilePartition fp, FSPath p) throws IOException {
        return new PathSplit(fp, p);
    }

    public StreamsInputSplit getGlobalSplit() throws Exception {
        return (StreamsInputSplit)this.getSingleSplit();
    }

    public StreamsInputSplit getSplitForPartitions(List<FilePartition> partitions) throws IOException {
        this.throwNotSupportedIfRepeating();
        PathsSplit split = new PathsSplit();
        for (FilePartition fp : partitions) {
            split.addPaths(fp);
        }
        return split;
    }

    public StreamsInputSplit getSplitForPartition(FilePartition partition) throws IOException {
        this.throwNotSupportedIfRepeating();
        PathsSplit split = new PathsSplit();
        split.addPaths(partition);
        return split;
    }

    public List<FSPath> enumerateFilesystem() throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (this.dataset.getParamsAs(AbstractFSConfig.class).variablesExpansionLoopConfig.isEnabled()) {
            this.invalidateRootEnumerationCache();
        }
        if (this.rootEnumerationCache == null) {
            this.rootEnumerationCache = this.enumerateFilesystem("", this.getEnumerationSettings());
        }
        return this.rootEnumerationCache;
    }

    protected void invalidateRootEnumerationCache() {
        this.rootEnumerationCache = null;
    }

    @Override
    public InputSplit getSampleSplit() throws Exception {
        FSPath path;
        block11: {
            AbstractFSConfig params = (AbstractFSConfig)this.dataset.getParams();
            String previewPath = PathUtils.slashes((String)params.previewFile, (Boolean)true, (Boolean)false, (boolean)true, null);
            if (!this.isSingleFile() && StringUtils.isNotBlank((String)previewPath)) {
                this.throwNotSupportedIfRepeating();
                if (!params.filesSelectionRules.includes(previewPath.substring(1))) {
                    throw new IllegalArgumentException("Preview file path " + previewPath + " is excluded by file selection rules");
                }
                try {
                    List<FSPath> fsPaths = this.enumerateFilesystem(previewPath, this.getEnumerationSettings());
                    if (fsPaths.isEmpty()) {
                        logger.info((Object)("Preview file " + previewPath + " not found"));
                        path = null;
                        break block11;
                    }
                    if (fsPaths.size() == 1) {
                        path = fsPaths.get(0);
                        if (path.getSize() == 0L) {
                            logger.info((Object)("Preview file " + previewPath + " found but empty"));
                        }
                        break block11;
                    }
                    path = null;
                    for (FSPath p : fsPaths) {
                        if (p.getSize() <= 0L) continue;
                        path = fsPaths.get(0);
                        break;
                    }
                    String warning = "Several files found under preview file path " + previewPath;
                    if (path == null) {
                        warning = warning + ", all of them empty";
                    }
                    logger.warn((Object)warning);
                }
                catch (FileNotFoundException e404) {
                    logger.info((Object)("Preview file " + previewPath + " not found"));
                    path = null;
                }
            } else {
                path = this.getFirstNonEmptyPath();
            }
        }
        if (path == null) {
            return null;
        }
        return new PathSplit(null, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputSplit getSingleSplit() throws Exception {
        AbstractFSConfig ac = this.dataset.getParamsAs(AbstractFSConfig.class);
        if (ac.variablesExpansionLoopConfig.isEnabled()) {
            ArrayList<GlobalSplit> loopIterations = new ArrayList<GlobalSplit>();
            for (JsonObject jo : new VariablesExpansionLoopItemsIterable(this.authCtx, this.dataset.getProjectKey(), ac.variablesExpansionLoopConfig)) {
                try {
                    DynamicLevelsStack.pushLevel(jo);
                    loopIterations.add(new GlobalSplit());
                }
                finally {
                    DynamicLevelsStack.popLevel();
                }
            }
            return new MultiGlobalSplit(loopIterations);
        }
        return new GlobalSplit();
    }

    @Nullable
    public List<FSPath> enumeratePartition(Partition partition, FSEnumerationSettings enumerationSettings) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        String prefix = this.dataset.getPartitioningSchema() != null && FilePartitioner.isSchemeRepresentableAsFolder(this.dataset.getPartitioningSchema()) ? FilePartitioner.computePartitionRelPathAsFolder(partition, this.dataset.getPartitioningSchema()) : "";
        List<FSPath> paths = this.enumerateFilesystem(prefix, enumerationSettings);
        if (paths == null || paths.isEmpty()) {
            if (this.dataset.getPartitioningSchema().isPartitioned() && this.dataset.getPartitioningSchema().considerMissingRequestedPartitionsAsEmpty) {
                logger.warn((Object)("Considering missing partition " + String.valueOf(partition) + " as empty"));
                return new ArrayList<FSPath>();
            }
            logger.warn((Object)("Enumeration of partition " + String.valueOf(partition) + " did not return anything"));
            return null;
        }
        ArrayList<FSPath> partitionPaths = new ArrayList<FSPath>();
        if (this.dataset.getPartitioningSchema() != null && FilePartitioner.isSchemeRepresentableAsFolder(this.dataset.getPartitioningSchema())) {
            partitionPaths.addAll(paths);
        } else {
            FilePartitioner partitioner = new FilePartitioner(this.dataset.getPartitioningSchema());
            List<FilePartition> partitions = partitioner.getPartitionsFromFiles(paths);
            for (FilePartition candidate : partitions) {
                if (!candidate.id().equals(partition.id())) continue;
                for (FileBucket fb : candidate.buckets) {
                    partitionPaths.addAll(fb.paths);
                }
            }
        }
        return partitionPaths;
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        this.clearAllData();
    }

    @Override
    public long getRecords() throws Exception {
        CountingProcessorOutput counting = new CountingProcessorOutput();
        UniversalSingleThreadPusher.push(this.authCtx, this.dataset, (ProcessorOutput)counting, (ColumnFactory)new StreamColumnFactory(), (RowFactory)new StreamRowFactory());
        return counting.getCount();
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        CountingProcessorOutput counting = new CountingProcessorOutput();
        StreamableDatasetSelection selection = StreamableDatasetSelection.full();
        selection.withSelectedPartitions(Lists.newArrayList((Object[])new Partition[]{p}));
        UniversalSingleThreadPusher.push(this.authCtx, this.dataset, selection, (ProcessorOutput)counting, (ColumnFactory)new StreamColumnFactory(), (RowFactory)new StreamRowFactory());
        return counting.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetReadiness getReadiness(Partition partition, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        String markerFile = this.dataset.getParams() instanceof AbstractFSConfig ? ((AbstractFSConfig)this.dataset.getParams()).markerFile : null;
        try {
            if (StringUtils.isBlank((String)markerFile)) {
                if (this.dataset.getParams().isNotReadyIfEmpty() && this.isEmpty(partition)) {
                    logger.info((Object)("Checking whether partition " + partition.id() + " is empty"));
                    return DatasetReadiness.notReady((Throwable)new CodedIOException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_PARTITION_EMPTY, "Input partition " + partition.id() + " of dataset " + this.dataset.getFullName() + " is empty"));
                }
                AbstractFSConfig afc = this.dataset.getParamsAs(AbstractFSConfig.class);
                if (!afc.variablesExpansionLoopConfig.isEnabled()) {
                    FSEnumerationSettings enumerationSettings = this.getEnumerationSettings();
                    enumerationSettings.forReadinessComputation = true;
                    logger.debug((Object)("getReadiness: will enumerate partition " + String.valueOf(partition)));
                    List<FSPath> partitionPaths = this.enumeratePartition(partition, enumerationSettings);
                    logger.debugV("getReadiness: enumerated partition, found %d paths, computing hash", new Object[]{partitionPaths == null ? 0 : partitionPaths.size()});
                    return this.getReadinessForPaths(partitionPaths);
                }
                ArrayList<FSPath> partitionPaths = new ArrayList<FSPath>();
                for (JsonObject jo : new VariablesExpansionLoopItemsIterable(this.authCtx, this.dataset.getProjectKey(), afc.variablesExpansionLoopConfig)) {
                    try {
                        DynamicLevelsStack.pushLevel(jo);
                        FSEnumerationSettings enumerationSettings = this.getEnumerationSettings();
                        enumerationSettings.forReadinessComputation = true;
                        logger.debug((Object)("getReadiness: will enumerate partition " + String.valueOf(partition) + " for loop iteration"));
                        List<FSPath> iterationPaths = this.enumeratePartition(partition, enumerationSettings);
                        logger.debugV("getReadiness: enumerated partition, found %d paths", new Object[]{iterationPaths == null ? 0 : iterationPaths.size()});
                        if (iterationPaths == null) continue;
                        partitionPaths.addAll(iterationPaths);
                    }
                    finally {
                        DynamicLevelsStack.popLevel();
                    }
                }
                logger.debugV("getReadiness: enumerated partition for loop, found %d paths, computing hash", new Object[]{partitionPaths == null ? 0 : partitionPaths.size()});
                return this.getReadinessForPaths(partitionPaths);
            }
            FSEnumerationSettings enumerationSettings = this.getEnumerationSettings();
            enumerationSettings.forReadinessComputation = true;
            return this.getReadinessForPaths(this.enumerateFilesystem(markerFile, enumerationSettings));
        }
        catch (Exception e) {
            return DatasetReadiness.error(e);
        }
    }

    private DatasetReadiness getReadinessForPaths(@Nullable List<FSPath> paths) {
        if (paths == null || paths.isEmpty()) {
            logger.warn((Object)("No paths returned for dataset " + this.getDataset().getFullName()));
            return DatasetReadiness.notReady((Throwable)new CodedIOException((InfoMessage.MessageCode)JobRunCodes.ERR_JOB_INPUT_DATASET_NOT_READY_NO_FILES, "No files found in dataset"));
        }
        StringBuilder identifier = new StringBuilder();
        for (FSPath p : paths) {
            identifier.append(p.path()).append('=').append(p.getSize()).append('@').append(p.getLastModified());
        }
        return DatasetReadiness.ready(DKUtils.md5Base64((String)identifier.toString()));
    }

    protected boolean isEmpty(Partition p) throws Exception {
        CountingProcessorOutput counting = new CountingProcessorOutput();
        StreamableDatasetSelection selection = StreamableDatasetSelection.head100K();
        selection.withSelectedPartitions(Lists.newArrayList((Object[])new Partition[]{p}));
        selection.maxRecords = 2L;
        UniversalSingleThreadPusher.push(this.authCtx, this.dataset, selection, (ProcessorOutput)counting, (ColumnFactory)new StreamColumnFactory(), (RowFactory)new StreamRowFactory());
        return counting.getCount() == 0L;
    }

    public abstract FSEnumerationSettings getEnumerationSettings();

    public FSPath getFirstNonEmptyPath() throws Exception {
        logger.info((Object)"Finding first non empty path in dataset");
        if (this.isSingleFile()) {
            FSPathOrDirectory status = this.getProvider().stat("/" + this.getSingleFile());
            return status != null && status.getSize() > 0L ? status : null;
        }
        JsonObject jo = VariablesExpansionLoopItemsIterable.firstIterationOnlyFailIfNone(this.authCtx, this.dataset.getProjectKey(), this.dataset.getParamsAs(AbstractFSConfig.class).variablesExpansionLoopConfig, "Driving dataset is empty, cannot find file for preview");
        try (AutoCloseable ignored = DynamicLevelsStack.withLevel(jo);){
            FSEnumerationSettings enumerationSettings = this.getEnumerationSettings();
            enumerationSettings.firstNonEmpty = true;
            FSEnumerationResult enumerationResult = this.getProvider().enumerateRecursive("/", enumerationSettings);
            if (!enumerationResult.isSuccessful() || !enumerationResult.enumerationPrefixExists()) {
                FSPath fSPath = null;
                return fSPath;
            }
            ArrayList paths = Lists.newArrayList((Iterable)enumerationResult.getPaths());
            if (!paths.isEmpty()) {
                FSPath fSPath = (FSPath)paths.get(0);
                return fSPath;
            }
            FSPath fSPath = null;
            return fSPath;
        }
    }

    protected abstract List<FSPath> enumerateFilesystem(String var1, FSEnumerationSettings var2) throws IOException, InterruptedException, DKUSecurityException, CodedException;

    public abstract EnrichedInputStream getStream(FSPath var1, FilePartition var2) throws IOException, InterruptedException, DKUSecurityException, CodedException;

    public abstract String getInformationalRootPath() throws IOException, DKUSecurityException, CodedException;

    public boolean isSingleFile() throws IOException, DKUSecurityException, CodedException {
        return this.getSingleFile() != null;
    }

    public String getSingleFile() throws IOException, DKUSecurityException, CodedException {
        this.getProvider();
        return this.isSingleFile;
    }

    public String getPartitionRelPath(Partition targetPartition) throws IOException {
        return FilePartitioner.getRelPath(targetPartition, this.dataset.getPartitioningSchema());
    }

    public String getPartitionSplitFilePath(Partition targetPartition, int splitId, String extension) throws IOException {
        return FilePartitioner.getSplitFileRelPath(targetPartition, this.dataset.getPartitioningSchema(), splitId, extension);
    }

    public String getPartitionPath(Partition targetPartition) throws IOException, DKUSecurityException, CodedException {
        this.throwNotSupportedIfRepeating();
        return this.getInformationalRootPath() + FilePartitioner.getRelPath(targetPartition, this.dataset.getPartitioningSchema());
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        if (this.dataset.getFormatType() != null && this.dataset.getFormatType().equals(ParquetFormatMeta.META.getType())) {
            logger.info((Object)"Parquet -> Not parallel-writable");
            return false;
        }
        return this.getMeta().isParallelWritable(this.dataset.getModel().readWriteOptions);
    }

    @Override
    public boolean outputHandlesClear() {
        return false;
    }

    public long transferToZip(ZipWriteFS zipWriteFS, RelFile to) throws IOException, DKUSecurityException, CodedException {
        this.throwNotSupportedIfRepeating();
        return new FsProviderToReadWriteFSTransferer(this.getProvider(), (ReadWriteFS)zipWriteFS).transfer(this.getSingleFile(), to.toString());
    }

    public long transferFrom(File from) throws IOException, DKUSecurityException, CodedException {
        this.throwNotSupportedIfRepeating();
        try (LocalFSProvider fromProvider = LocalFSProvider.makeFSProviderOnRoot(from.getAbsolutePath());){
            long l = new FsToFsProviderTransferer(fromProvider, this.getProvider()).transfer("", "");
            return l;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkClearIsNotDangerous() throws IOException {
        boolean allowed;
        AbstractFSConfig params = this.dataset.getParamsAs(AbstractFSConfig.class);
        String datasetPath = params.path;
        String connectionName = StringUtils.defaultIfBlank((String)params.connection, (String)"no_connection");
        if (!this.dataset.isManaged()) {
            allowed = ApplicationConfigurator.getParams().getBoolParam("dku.datasets.external." + connectionName + ".allowClear", false);
            try {
                DSSConnection conn = ConnectionsDAO.get().getConnection(this.authCtx, connectionName);
                if (conn != null && conn instanceof FSProviderizableConnection) {
                    Params p = ConnectionUtils.getParamsFromProperties((FSProviderizableConnection)((Object)conn));
                    allowed = p.getBoolParam("dku.connection.externalDatasets.allowClear", allowed);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!allowed) throw new CodedIOException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Clearing external (i.e., non-managed) datasets in connection " + connectionName + " is forbidden. Do you want to use a managed dataset instead?");
            logger.warnV("Clearing dataset %s on external FS connection %s, dataset connection path %s", new Object[]{this.getDataset().getName(), connectionName, params.path});
        }
        if (!StringUtils.isBlank((String)datasetPath) && !"/".equals(datasetPath)) return;
        if (this.dataset.isManaged()) {
            allowed = ApplicationConfigurator.getParams().getBoolParam("dku.datasets.managed.allowClearRoot", true);
            if (!(allowed &= ApplicationConfigurator.getParams().getBoolParam("dku.datasets.managed." + connectionName + ".allowClearRoot", false))) throw new CodedIOException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Placing a managed dataset at the root of a connection is not permitted");
            logger.warnV("Clearing dataset %s on external FS connection %s root path!", new Object[]{this.getDataset().getName(), connectionName});
            return;
        } else {
            allowed = ApplicationConfigurator.getParams().getBoolParam("dku.datasets.external.allowClearRoot", true);
            if (!(allowed &= ApplicationConfigurator.getParams().getBoolParam("dku.datasets.external." + connectionName + ".allowClearRoot", false))) throw new CodedIOException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Clearing external dataset at root of connection " + connectionName + " is forbidden");
            logger.warnV("Clearing dataset %s on managed FS connection %s root path!", new Object[]{this.getDataset().getName(), connectionName});
        }
    }

    protected void clearPartitionPath(FSProvider provider, String partitionPath) throws IOException, CodedException, DKUSecurityException {
        this.checkClearIsNotDangerous();
        this.throwNotSupportedIfRepeating();
        if (provider instanceof BlobLikeFSProvider) {
            provider.deleteRecursive(partitionPath);
        } else if (provider.stat(partitionPath) != null) {
            provider.deleteRecursive(partitionPath);
        }
    }

    protected void clearPartitionPaths(FSProvider provider, List<FSPath> paths) throws IOException, DKUSecurityException, CodedException {
        block7: {
            this.checkClearIsNotDangerous();
            this.throwNotSupportedIfRepeating();
            if (paths == null) break block7;
            if (this.isManaged()) {
                for (FSPath path : paths) {
                    provider.deleteRecursive(path.path());
                }
            } else if (this.isSingleFile()) {
                for (FSPath path : paths) {
                    this.getProvider().write(path.path()).close();
                }
            } else {
                for (FSPath path : paths) {
                    provider.deleteRecursive(path.path());
                }
            }
        }
    }

    protected void clearOrEmptyPartitionPath(FSLikeFSProvider provider, String partitionPath) throws IOException, CodedException, DKUSecurityException {
        this.checkClearIsNotDangerous();
        this.throwNotSupportedIfRepeating();
        if (this.isManaged()) {
            if (provider.stat(partitionPath) != null) {
                provider.deleteRecursive(partitionPath);
            }
        } else {
            provider.makeEmpty(partitionPath);
        }
    }

    protected void clearOrEmptyPartitionPaths(FSLikeFSProvider provider, List<FSPath> paths) throws IOException, CodedException, DKUSecurityException {
        block2: {
            block3: {
                this.checkClearIsNotDangerous();
                this.throwNotSupportedIfRepeating();
                if (paths == null) break block2;
                if (!this.isManaged()) break block3;
                for (FSPath path : paths) {
                    provider.deleteRecursive(path.path());
                }
                break block2;
            }
            if (paths.isEmpty()) break block2;
            for (FSPath path : paths) {
                provider.deleteRecursive(path.path());
            }
        }
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    protected void printLocationInfo() {
    }

    public long getLengthIfSmallerThan(Partition partition, long sizeLimit) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        this.throwNotSupportedIfRepeating();
        this.printLocationInfo();
        logger.info((Object)("Estimating size of partition in dataset =" + (partition == null ? "ALL" : partition.id())));
        if (this.isSingleFile()) {
            FSPathOrDirectory file = this.getProvider().stat(this.getSingleFile());
            return file != null ? file.getSize() : 0L;
        }
        String prefix = "";
        if (partition != null && !"ALL".equals(partition.id()) && this.dataset.getPartitioningSchema() != null && FilePartitioner.isSchemeRepresentableAsFolder(this.dataset.getPartitioningSchema())) {
            prefix = this.getPartitionRelPath(partition);
        }
        FSEnumerationSettings enumerationSettings = this.getEnumerationSettings();
        enumerationSettings.totalSizeLimit = sizeLimit;
        FSEnumerationResult enumerationResult = this.getProvider().enumerateRecursive(prefix, enumerationSettings);
        if (!enumerationResult.isSuccessful()) {
            return 0L;
        }
        if (!enumerationResult.enumerationPrefixExists()) {
            throw new FileNotFoundException("Nothing at path " + prefix);
        }
        long totalSize = 0L;
        for (FSPath path : enumerationResult.getPaths()) {
            totalSize += path.getSize();
        }
        return totalSize;
    }

    protected void throwNotSupportedIfRepeating() {
        if (this.dataset.getParamsAs(AbstractFSConfig.class).variablesExpansionLoopConfig.isEnabled()) {
            throw new IllegalArgumentException("This capability is not supported on repeating datasets");
        }
    }

    public static class FSProviderAndPath {
        public final FSProvider provider;
        public final String path;

        public FSProviderAndPath(FSProvider provider, String path) {
            this.path = path;
            this.provider = provider;
        }
    }

    public static class AbstractFSConfig
    implements DatasetHandler.DatasetParams {
        private static final long serialVersionUID = -1L;
        public String connection;
        public String path;
        public boolean notReadyIfEmpty;
        public String markerFile;
        public String previewFile;
        public String sheetName;
        public FilesSelectionRules filesSelectionRules = new FilesSelectionRules();
        public VariablesExpansionLoopConfig variablesExpansionLoopConfig = new VariablesExpansionLoopConfig();

        @Override
        public String getConnection() {
            return this.connection;
        }

        @Override
        public boolean isNotReadyIfEmpty() {
            return this.notReadyIfEmpty;
        }

        public void expandVariables(VariablesContext vc) {
            this.path = vc.expandAllowUnresolved(this.path);
        }
    }

    class BucketSplit
    extends StreamsInputSplit
    implements FSDatasetUtils.PathsBasedSplit {
        FileBucket bucket;
        FilePartition partition;
        int curIdx = 0;

        public BucketSplit(FilePartition partition, FileBucket bucket) {
            this.bucket = bucket;
            this.partition = partition;
        }

        public EnrichedInputStream nextStream() throws IOException, InterruptedException, DKUSecurityException, CodedException {
            if (this.curIdx >= this.bucket.paths.size()) {
                return null;
            }
            return AbstractFSDatasetHandler.this.getStream(this.bucket.paths.get(this.curIdx++), this.partition);
        }

        public String getDesc() {
            return "bucket-" + this.bucket.toString();
        }

        public void reset() {
            this.curIdx = 0;
        }

        @Override
        public List<FSPath> getPaths() {
            return this.bucket.paths;
        }

        @Override
        public EnrichedInputStream getStreamForPath(FSPath p) throws IOException, InterruptedException, DKUSecurityException, CodedException {
            return AbstractFSDatasetHandler.this.getStream(p, this.partition);
        }
    }

    class PathSplit
    extends StreamsInputSplit
    implements FSDatasetUtils.PathsBasedSplit {
        FSPath p;
        FilePartition partition;
        boolean called;

        public PathSplit(FilePartition partition, FSPath p) {
            this.partition = partition;
            this.p = p;
        }

        public EnrichedInputStream nextStream() throws IOException, InterruptedException, DKUSecurityException, CodedException {
            if (this.called) {
                return null;
            }
            this.called = true;
            return AbstractFSDatasetHandler.this.getStream(this.p, this.partition);
        }

        public String getDesc() {
            return "file-" + this.p.path();
        }

        public void reset() {
            this.called = false;
        }

        @Override
        public List<FSPath> getPaths() {
            return Lists.newArrayList((Object[])new FSPath[]{this.p});
        }

        @Override
        public EnrichedInputStream getStreamForPath(FSPath p) throws IOException, InterruptedException, DKUSecurityException, CodedException {
            return AbstractFSDatasetHandler.this.getStream(p, this.partition);
        }
    }

    class PathsSplit
    extends StreamsInputSplit
    implements FSDatasetUtils.PathsBasedSplit {
        private final List<FSPath> paths = new ArrayList<FSPath>();
        private final List<FilePartition> partitions = new ArrayList<FilePartition>();
        private int curIdx = 0;

        void addPaths(FilePartition partition) {
            List<FSPath> list = partition.getAllPaths();
            this.paths.addAll(list);
            for (int i = 0; i < list.size(); ++i) {
                this.partitions.add(partition);
            }
        }

        public EnrichedInputStream nextStream() throws IOException, InterruptedException, DKUSecurityException, CodedException {
            if (this.curIdx >= this.paths.size()) {
                return null;
            }
            int idx = this.curIdx++;
            return AbstractFSDatasetHandler.this.getStream(this.paths.get(idx), this.partitions.get(idx));
        }

        public String getDesc() {
            return Joiner.on((char)',').join(this.paths);
        }

        public void reset() {
            this.curIdx = 0;
        }

        @Override
        public List<FSPath> getPaths() {
            return this.paths;
        }

        private FilePartition getPartitionIfAny(FSPath fs) {
            for (int i = 0; i < this.paths.size(); ++i) {
                if (!this.paths.get(i).path().equals(fs.path())) continue;
                return this.partitions.get(i);
            }
            return null;
        }

        @Override
        public EnrichedInputStream getStreamForPath(FSPath p) throws IOException, InterruptedException, DKUSecurityException, CodedException {
            FilePartition fp = this.getPartitionIfAny(p);
            return AbstractFSDatasetHandler.this.getStream(p, fp);
        }
    }

    class GlobalSplit
    extends StreamsInputSplit
    implements FSDatasetUtils.PathsBasedSplit {
        List<FSPath> paths = new ArrayList<FSPath>();
        int curIdx = 0;

        public GlobalSplit() throws IOException, InterruptedException, DKUSecurityException, CodedException {
            this.paths = AbstractFSDatasetHandler.this.enumerateFilesystem();
        }

        public EnrichedInputStream nextStream() throws IOException, InterruptedException, DKUSecurityException, CodedException {
            if (this.curIdx >= this.paths.size()) {
                return null;
            }
            return AbstractFSDatasetHandler.this.getStream(this.paths.get(this.curIdx++), null);
        }

        public String getDesc() {
            return AbstractFSDatasetHandler.this.toString();
        }

        public void reset() {
            this.curIdx = 0;
        }

        @Override
        public List<FSPath> getPaths() {
            return this.paths;
        }

        @Override
        public EnrichedInputStream getStreamForPath(FSPath p) throws IOException, InterruptedException, DKUSecurityException, CodedException {
            return AbstractFSDatasetHandler.this.getStream(p, null);
        }
    }

    class MultiGlobalSplit
    extends StreamsInputSplit
    implements FSDatasetUtils.PathsBasedSplit {
        private List<? extends StreamsInputSplit> subsplits;
        int curSplit = 0;

        public MultiGlobalSplit(List<? extends StreamsInputSplit> subsplits) throws IOException, InterruptedException, DKUSecurityException, CodedException {
            this.subsplits = subsplits;
        }

        public EnrichedInputStream nextStream() throws IOException, InterruptedException, DKUSecurityException, CodedException {
            while (this.curSplit < this.subsplits.size()) {
                EnrichedInputStream nextFromCurrentSplit = this.subsplits.get(this.curSplit).nextStream();
                if (nextFromCurrentSplit != null) {
                    return nextFromCurrentSplit;
                }
                assert (this.curSplit < this.subsplits.size());
                ++this.curSplit;
            }
            return null;
        }

        public String getDesc() {
            return AbstractFSDatasetHandler.this.toString();
        }

        public void reset() {
            for (StreamsInputSplit streamsInputSplit : this.subsplits) {
                streamsInputSplit.reset();
            }
            this.curSplit = 0;
        }

        @Override
        public List<FSPath> getPaths() {
            ArrayList<FSPath> ret = new ArrayList<FSPath>();
            for (StreamsInputSplit streamsInputSplit : this.subsplits) {
                List<FSPath> thisSplitPaths = ((FSDatasetUtils.PathsBasedSplit)streamsInputSplit).getPaths();
                ret.addAll(thisSplitPaths);
            }
            return ret;
        }

        @Override
        public EnrichedInputStream getStreamForPath(FSPath p) throws IOException, InterruptedException, DKUSecurityException, CodedException {
            return AbstractFSDatasetHandler.this.getStream(p, null);
        }
    }

    public static class AbstractMetastoreAwareFSConfig
    extends AbstractFSConfig {
        private static final long serialVersionUID = -1L;
        public boolean metastoreSynchronizationEnabled = true;
        public String metastoreDatabaseName;
        public String metastoreTableName;

        @Override
        public void expandVariables(VariablesContext vc) {
            super.expandVariables(vc);
            this.metastoreDatabaseName = vc.expandAllowUnresolved(this.metastoreDatabaseName);
            this.metastoreTableName = vc.expandAllowUnresolved(this.metastoreTableName);
        }
    }
}

