/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.iceberg;

import com.dataiku.dip.datasets.iceberg.IcebergValueConverter;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.ExactValueDimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundPredicate;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IcebergFilterConverter {
    private final IcebergValueConverter valueConverter = new IcebergValueConverter();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.iceberg.filter");

    public Expression toIcebergFilter(List<Partition> partitions, Schema icebergSchema) {
        List partitionFilters = partitions.stream().map(p -> this.toIcebergFilter((Partition)p, icebergSchema)).collect(Collectors.toList());
        if (partitionFilters.size() == 1) {
            return (Expression)partitionFilters.get(0);
        }
        Expression filter = Expressions.or((Expression)((Expression)partitionFilters.get(0)), (Expression)((Expression)partitionFilters.get(1)));
        for (int i = 2; i < partitionFilters.size(); ++i) {
            filter = Expressions.or((Expression)filter, (Expression)((Expression)partitionFilters.get(i)));
        }
        return filter;
    }

    public Expression toIcebergFilter(Partition partition, Schema icebergSchema) {
        PartitioningScheme scheme = partition.getScheme();
        if (scheme == null) {
            return Expressions.alwaysTrue();
        }
        ArrayList<UnboundPredicate> clauses = new ArrayList<UnboundPredicate>();
        for (Map.Entry e : partition.getDimensionValues().entrySet()) {
            String name = (String)e.getKey();
            DimensionValue value = (DimensionValue)e.getValue();
            Type type = icebergSchema.findType(name);
            if (type == null) {
                throw new IllegalArgumentException("Dimension " + name + " not present in iceberg schema");
            }
            if (value instanceof ExactValueDimensionValue) {
                Object lit = this.valueConverter.toIcebergLiteralValue(value, type);
                logger.info((Object)("Add clause : " + name + " = " + String.valueOf(lit) + " ( " + (lit == null ? "" : lit.getClass().getCanonicalName())));
                clauses.add(Expressions.equal((String)name, (Object)lit));
                continue;
            }
            if (value instanceof TimeDimensionValue) {
                TimeDimensionValue timeDimensionValue = (TimeDimensionValue)value;
                TimeDimensionValue nextTimeDimensionValue = timeDimensionValue.nextPeriod();
                Object startIcebergLiteralValue = this.valueConverter.toIcebergLiteralValue((DimensionValue)timeDimensionValue, type);
                Object endIcebergLiteralValue = this.valueConverter.toIcebergLiteralValue((DimensionValue)nextTimeDimensionValue, type);
                clauses.add(Expressions.greaterThanOrEqual((String)name, (Object)startIcebergLiteralValue));
                clauses.add(Expressions.lessThan((String)name, (Object)endIcebergLiteralValue));
                continue;
            }
            throw new IllegalArgumentException("Unknown dimension value type: " + value.getClass().getCanonicalName());
        }
        if (clauses.isEmpty()) {
            throw new IllegalStateException("No partitioning clauses found");
        }
        if (clauses.size() == 1) {
            return (Expression)clauses.get(0);
        }
        Expression ret = Expressions.and((Expression)((Expression)clauses.get(0)), (Expression)((Expression)clauses.get(1)));
        for (int i = 2; i < clauses.size(); ++i) {
            ret = Expressions.and((Expression)ret, (Expression)((Expression)clauses.get(i)));
        }
        return ret;
    }
}

