/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.iceberg;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.iceberg.IcebergUtils;
import com.dataiku.dip.datasets.iceberg.IcebergValueConverter;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.iceberg.AppendFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionKey;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.GenericRecord;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.InternalRecordWrapper;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.parquet.GenericParquetWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DataWriter;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.parquet.Parquet;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class IcebergOutputWriter
extends OutputWriter {
    private final Table table;
    private final int targetSplit;
    private final Schema icebergSchema;
    private final Partition partition;
    private final IcebergUtils.ActionRunner icebergActionRunner;
    private final IcebergValueConverter converter;
    private final long targetFileSize;
    private ColumnFactory cf;
    private OutputFile file;
    private DataWriter<GenericRecord> dataWriter;
    private long pendingRowsFootprint = 0L;
    private AppendFiles appendFiles;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.iceberg.writer");

    public IcebergOutputWriter(Table table, int targetSplit, Partition partition, IcebergUtils.ActionRunner icebergActionRunner) {
        this.table = table;
        this.targetSplit = targetSplit;
        this.icebergSchema = table.schema();
        this.partition = partition;
        this.icebergActionRunner = icebergActionRunner;
        this.converter = new IcebergValueConverter();
        this.targetFileSize = this.getLongPropFromTable(table, "write.target-file-size-bytes", 500000000L);
    }

    private long getLongPropFromTable(Table table, String name, long defaultValue) {
        String value = (String)table.properties().get(name);
        if (StringUtils.isNotBlank((String)value)) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                logger.warn((Object)("Can't parse property " + name + " as long: value is " + value + ". Error: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        return defaultValue;
    }

    public void init(ColumnFactory cf) throws Exception {
        PrivilegedExceptionAction<Void> action = () -> {
            this.cf = cf;
            this.appendFiles = this.table.newAppend();
            this.openNewWriter();
            return null;
        };
        this.icebergActionRunner.doAs(action);
    }

    private void openNewWriter() throws IOException {
        String filepath = this.table.location() + "/split-" + this.targetSplit + "-" + UUID.randomUUID().toString();
        this.file = this.table.io().newOutputFile(filepath);
        logger.info((Object)("Write iceberg data to " + this.file.location()));
        Parquet.DataWriteBuilder writerBuilder = Parquet.writeData((OutputFile)this.file).schema(this.icebergSchema).createWriterFunc(GenericParquetWriter::create).overwrite().withSpec(this.table.spec());
        if (this.table.spec().isPartitioned()) {
            GenericRecord partitionRecord = GenericRecord.create((Schema)this.table.spec().schema());
            for (Map.Entry e : this.partition.getDimensionValues().entrySet()) {
                String name = (String)e.getKey();
                DimensionValue dimensionValue = (DimensionValue)e.getValue();
                Type type = this.icebergSchema.findType(name);
                if (type == null) {
                    throw new IllegalArgumentException("Dimension " + name + " not present in iceberg schema");
                }
                partitionRecord.setField(name, this.converter.toIcebergValue(dimensionValue, type));
            }
            InternalRecordWrapper wrapper = new InternalRecordWrapper(this.table.spec().schema().asStruct());
            PartitionKey partitionKey = new PartitionKey(this.table.spec(), this.table.schema());
            partitionKey.partition((StructLike)wrapper.wrap((StructLike)partitionRecord));
            logger.info((Object)("write with iceberg partition " + String.valueOf(partitionKey) + " in spec " + String.valueOf(this.table.spec())));
            this.dataWriter = writerBuilder.withPartition((StructLike)partitionKey).build();
        } else {
            this.dataWriter = writerBuilder.build();
        }
    }

    public void emitRow(Row row) throws Exception {
        PrivilegedExceptionAction<Void> action = () -> {
            GenericRecord record = GenericRecord.create((Schema)this.icebergSchema);
            long rowFootprint = 0L;
            for (Types.NestedField nestedField : this.icebergSchema.columns()) {
                String value = row.get(this.cf.column(nestedField.name()));
                if (value == null) continue;
                rowFootprint += (long)(2 * value.length());
                Object icebergValue = this.converter.toIcebergValue(value, nestedField.type());
                record.setField(nestedField.name(), icebergValue);
            }
            if (this.partition != null && !this.partition.isAll() && !this.partition.isNP()) {
                for (Map.Entry entry : this.partition.getDimensionValues().entrySet()) {
                    String name = (String)entry.getKey();
                    DimensionValue dimensionValue = (DimensionValue)entry.getValue();
                    Type type = this.icebergSchema.findType(name);
                    if (type == null) {
                        throw new IllegalArgumentException("Dimension " + name + " not present in iceberg schema");
                    }
                    record.setField(name, this.converter.toIcebergValue(dimensionValue, type));
                }
            }
            this.dataWriter.write((Object)record);
            this.pendingRowsFootprint += rowFootprint;
            if (this.pendingRowsFootprint > this.targetFileSize) {
                this.flush();
                this.openNewWriter();
                this.pendingRowsFootprint = 0L;
            }
            return null;
        };
        this.icebergActionRunner.doAs(action);
    }

    private void flush() throws IOException {
        this.dataWriter.close();
        this.appendFiles.appendFile(this.dataWriter.toDataFile());
    }

    public void lastRowEmitted() throws Exception {
        PrivilegedExceptionAction<Void> action = () -> {
            if (this.pendingRowsFootprint > 0L) {
                this.flush();
            } else {
                this.dataWriter.close();
            }
            IcebergUtils.commitWithRetry(this.appendFiles);
            return null;
        };
        this.icebergActionRunner.doAs(action);
    }

    public void cancel() throws Exception {
        PrivilegedExceptionAction<Void> action = () -> {
            if (this.dataWriter != null) {
                this.dataWriter.close();
            }
            return null;
        };
        this.icebergActionRunner.doAs(action);
    }

    public long writtenBytes() throws IOException {
        return 0L;
    }
}

