/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.iceberg;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.iceberg.IcebergUtils;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.mutable.MutableInt;

public class IcebergSchemaConverter {
    public com.dataiku.dip.coremodel.Schema convert(Schema icebergSchema) {
        com.dataiku.dip.coremodel.Schema ret = new com.dataiku.dip.coremodel.Schema();
        for (Types.NestedField column : icebergSchema.columns()) {
            ret.addColumn(this.convert(column));
        }
        return ret;
    }

    private SchemaColumn convert(Types.NestedField column) {
        if (column.type().typeId() == IcebergUtils.getTimestampNanoTypeId()) {
            if (((Types.TimestampNanoType)column.type()).shouldAdjustToUTC()) {
                return new SchemaColumn(column.name(), Type.DATE);
            }
            return new SchemaColumn(column.name(), Type.DATETIMENOTZ);
        }
        switch (column.type().typeId()) {
            case BOOLEAN: {
                return new SchemaColumn(column.name(), Type.BOOLEAN);
            }
            case INTEGER: {
                return new SchemaColumn(column.name(), Type.INT);
            }
            case LONG: {
                return new SchemaColumn(column.name(), Type.BIGINT);
            }
            case FLOAT: {
                return new SchemaColumn(column.name(), Type.FLOAT);
            }
            case DOUBLE: 
            case DECIMAL: {
                return new SchemaColumn(column.name(), Type.DOUBLE);
            }
            case FIXED: 
            case STRING: {
                return new SchemaColumn(column.name(), Type.STRING);
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)column.type()).shouldAdjustToUTC()) {
                    return new SchemaColumn(column.name(), Type.DATE);
                }
                return new SchemaColumn(column.name(), Type.DATETIMENOTZ);
            }
            case DATE: {
                return new SchemaColumn(column.name(), Type.DATEONLY);
            }
            case LIST: {
                Types.ListType listType = (Types.ListType)column.type();
                SchemaColumn ret = new SchemaColumn(column.name(), Type.ARRAY);
                ret.arrayContent = this.convert(Types.NestedField.optional((int)0, (String)"element", (com.dataiku.dss.shadelib.org.apache.iceberg.types.Type)listType.elementType()));
                return ret;
            }
            case MAP: {
                Types.MapType mapType = (Types.MapType)column.type();
                SchemaColumn ret = new SchemaColumn(column.name(), Type.MAP);
                ret.mapKeys = this.convert(Types.NestedField.optional((int)0, (String)"key", (com.dataiku.dss.shadelib.org.apache.iceberg.types.Type)mapType.keyType()));
                ret.mapValues = this.convert(Types.NestedField.optional((int)0, (String)"value", (com.dataiku.dss.shadelib.org.apache.iceberg.types.Type)mapType.valueType()));
                return ret;
            }
            case STRUCT: {
                Types.StructType structType = (Types.StructType)column.type();
                SchemaColumn ret = new SchemaColumn(column.name(), Type.OBJECT);
                ret.objectFields = this.convert((Schema)structType.asSchema()).columns;
                return ret;
            }
        }
        return new SchemaColumn(column.name(), Type.STRING);
    }

    public SchemaCompatibility isCompatible(com.dataiku.dip.coremodel.Schema dssSchema, Schema icebergSchema) {
        return this.isCompatible(dssSchema.columns, icebergSchema.columns(), "root");
    }

    private SchemaCompatibility isCompatible(List<SchemaColumn> dssColumns, List<Types.NestedField> icebergColumns, String position) {
        if (dssColumns.size() != icebergColumns.size()) {
            return SchemaCompatibility.nok("Differing number of columns at " + position + " : " + dssColumns.size() + " in DSS, " + icebergColumns.size() + " in Iceberg");
        }
        HashMap dssColumnsMap = Maps.newHashMap();
        dssColumns.stream().forEach(sc -> dssColumnsMap.put(sc.getName(), sc));
        HashMap icebergColumnsMap = Maps.newHashMap();
        icebergColumns.stream().forEach(nf -> icebergColumnsMap.put(nf.name(), nf));
        Sets.SetView dssNotIceberg = Sets.difference(dssColumnsMap.keySet(), icebergColumnsMap.keySet());
        Sets.SetView icebergNotDSS = Sets.difference(icebergColumnsMap.keySet(), dssColumnsMap.keySet());
        if (!dssNotIceberg.isEmpty()) {
            return SchemaCompatibility.nok("Columns in DSS but not in Iceberg : " + dssNotIceberg.stream().collect(Collectors.joining(", ")));
        }
        if (!icebergNotDSS.isEmpty()) {
            return SchemaCompatibility.nok("Columns in Iceberg but not in DSS : " + icebergNotDSS.stream().collect(Collectors.joining(", ")));
        }
        for (Map.Entry e : dssColumnsMap.entrySet()) {
            String name = (String)e.getKey();
            SchemaCompatibility fieldCompat = this.isCompatible((SchemaColumn)e.getValue(), (Types.NestedField)icebergColumnsMap.get(e.getKey()), position + "->" + name);
            if (fieldCompat.ok) continue;
            return fieldCompat;
        }
        return SchemaCompatibility.ok();
    }

    private SchemaCompatibility isCompatible(SchemaColumn dssColumn, Types.NestedField icebergColumn, String position) {
        SchemaColumn convertedIcebergColumn = this.convert(icebergColumn);
        if (!dssColumn.getType().isCompatibleWith(convertedIcebergColumn.getType())) {
            return SchemaCompatibility.nok("Incompatible type at " + position + " : " + String.valueOf(dssColumn.getType()) + " (DSS) vs " + String.valueOf(icebergColumn.type().typeId()) + " (Iceberg)");
        }
        switch (dssColumn.getType()) {
            case ARRAY: {
                SchemaCompatibility elementCompat = this.isCompatible(dssColumn.arrayContent, Types.NestedField.optional((int)0, (String)"element", (com.dataiku.dss.shadelib.org.apache.iceberg.types.Type)icebergColumn.type().asListType().elementType()), position + "->[]");
                if (elementCompat.ok) break;
                return elementCompat;
            }
            case MAP: {
                SchemaCompatibility keyCompat = this.isCompatible(dssColumn.mapKeys, Types.NestedField.optional((int)0, (String)"key", (com.dataiku.dss.shadelib.org.apache.iceberg.types.Type)icebergColumn.type().asMapType().keyType()), position + "->[key]");
                if (!keyCompat.ok) {
                    return keyCompat;
                }
                SchemaCompatibility valueCompat = this.isCompatible(dssColumn.mapValues, Types.NestedField.optional((int)0, (String)"value", (com.dataiku.dss.shadelib.org.apache.iceberg.types.Type)icebergColumn.type().asMapType().valueType()), position + "->[value]");
                if (valueCompat.ok) break;
                return valueCompat;
            }
            case OBJECT: {
                SchemaCompatibility fieldsCompat = this.isCompatible(dssColumn.objectFields, icebergColumn.type().asStructType().asSchema().columns(), position);
                if (fieldsCompat.ok) break;
                return fieldsCompat;
            }
        }
        return SchemaCompatibility.ok();
    }

    public Schema convert(com.dataiku.dip.coremodel.Schema dssSchema) {
        ArrayList<Types.NestedField> icebergColumns = new ArrayList<Types.NestedField>();
        MutableInt colCounter = new MutableInt(0);
        for (SchemaColumn dssColumn : dssSchema.columns) {
            icebergColumns.add(this.convert(dssColumn, colCounter));
        }
        return new Schema(icebergColumns);
    }

    private Types.NestedField convert(SchemaColumn column, MutableInt colCounter) {
        int colIdx = colCounter.intValue();
        colCounter.increment();
        return Types.NestedField.optional((int)colIdx, (String)column.getName(), (com.dataiku.dss.shadelib.org.apache.iceberg.types.Type)this.convertType(column, colCounter));
    }

    private com.dataiku.dss.shadelib.org.apache.iceberg.types.Type convertType(SchemaColumn column, MutableInt colCounter) {
        switch (column.getType()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: {
                return Types.IntegerType.get();
            }
            case BIGINT: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case STRING: {
                return Types.StringType.get();
            }
            case DATE: {
                return Types.TimestampType.withZone();
            }
            case DATETIMENOTZ: {
                return Types.TimestampType.withoutZone();
            }
            case DATEONLY: {
                return Types.DateType.get();
            }
            case ARRAY: {
                int elementId = colCounter.intValue();
                colCounter.increment();
                return Types.ListType.ofOptional((int)elementId, (com.dataiku.dss.shadelib.org.apache.iceberg.types.Type)this.convertType(column.arrayContent, colCounter));
            }
            case MAP: {
                int keyId = colCounter.intValue();
                colCounter.increment();
                int valueId = colCounter.intValue();
                colCounter.increment();
                return Types.MapType.ofOptional((int)keyId, (int)valueId, (com.dataiku.dss.shadelib.org.apache.iceberg.types.Type)this.convertType(column.mapKeys, colCounter), (com.dataiku.dss.shadelib.org.apache.iceberg.types.Type)this.convertType(column.mapValues, colCounter));
            }
            case OBJECT: {
                ArrayList<Types.NestedField> structFields = new ArrayList<Types.NestedField>();
                for (SchemaColumn sc : column.objectFields) {
                    structFields.add(this.convert(sc, colCounter));
                }
                return Types.StructType.of(structFields);
            }
        }
        return Types.StringType.get();
    }

    public static class SchemaCompatibility {
        public boolean ok;
        public String reason;

        public static SchemaCompatibility ok() {
            SchemaCompatibility ret = new SchemaCompatibility();
            ret.ok = true;
            return ret;
        }

        public static SchemaCompatibility nok(String reason) {
            SchemaCompatibility ret = new SchemaCompatibility();
            ret.ok = false;
            ret.reason = reason;
            return ret;
        }
    }
}

