/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.JdbcConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SQLDriverLoader;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.metrics.probes.BasicStatsDatasetProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSQLDatasetTestHandler
implements DatasetTestHandler {
    @Autowired
    protected DatasetsDAO dao;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    private ReadOnlyJobsInternalDB jobsDatabaseService;
    protected final Dataset dataset;
    protected final AuthCtx authCtx;
    protected DatasetHandler dh;
    protected final AbstractSQLDatasetHandler.AbstractSQLConfig config;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    public AbstractSQLDatasetTestHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler dh) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.dh = dh;
        this.config = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(dataset.getProjectKey());
    }

    @Override
    public void close() throws IOException {
        if (this.dh != null) {
            try {
                this.dh.close();
            }
            finally {
                this.dh = null;
            }
        }
    }

    public List<String> listPartitions() throws Exception {
        try (DatasetHandler dh2 = DatasetHandlerFactory.build(this.authCtx, this.dataset);){
            ArrayList<String> ret = new ArrayList<String>();
            for (Partition p : dh2.listPartitions()) {
                ret.add(p.id());
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
    }

    @Nonnull
    protected ConnRet checkConfigDriverAndConnection(SQLDatasetTestResult ret) throws CodedException, CodedSQLException {
        SQLConnectionProvider.SQLConnectionWrapper jdbcConn;
        SQLConnectionProvider.SQLConnectionData cd = null;
        try {
            cd = ((AbstractSQLDatasetHandler)this.dh).makeConnData();
        }
        catch (Exception e) {
            logger.error((Object)"Configuration error", (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Invalid settings", (Throwable)e);
        }
        ret.catalogAware = cd.getDialect().isCatalogAware();
        if (cd.getConnection() instanceof JdbcConnection) {
            ret.catalogAware |= ((JdbcConnection)cd.getConnection()).params.supportsBrowsingCatalogs;
        }
        ret.schemaAware = cd.getDialect().isSchemaAware();
        Params p = cd.getConnection().getDkuPropertiesAsParams();
        ret.canFetchCatalogs = p.getBoolParam("dku.connection.sql.allowCatalogAndSchemaDropdownInput", true);
        ret.canFetchSchemas = p.getBoolParam("dku.connection.sql.allowCatalogAndSchemaDropdownInput", true);
        String driverClass = cd.getDriver(this.authCtx, this.dataset.getProjectKey());
        if (driverClass != null) {
            try {
                SQLDriverLoader.loadDriver(driverClass, cd.getJarsDirectory(), cd.getJarsFallThroughPackages(), cd.getJarsNonFallThroughPackages());
            }
            catch (CodedSQLException e) {
                logger.error((Object)"Driver error", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"Driver error", (Throwable)e);
                throw new CodedException((InfoMessage.MessageCode)SQLCodes.ERR_SQL_CANNOT_LOAD_DRIVER, "Failed to load JDBC driver (" + driverClass + ")", (Throwable)e);
            }
        }
        try {
            jdbcConn = SQLConnectionProvider.newConnection(cd, this.authCtx, this.dataset.getProjectKey());
        }
        catch (Exception e) {
            logger.error((Object)"Connection error", (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)SQLCodes.ERR_SQL_DB_UNREACHABLE, "Failed to connect to database", (Throwable)e);
        }
        ret.connectionOK = true;
        return new ConnRet(cd, jdbcConn);
    }

    public SQLSparkIntegrationCheckResult checkSparkIntegration() throws Exception {
        AbstractSQLConnection conn = null;
        try {
            conn = ((AbstractSQLDatasetHandler)this.dh).getDSSConnection();
        }
        catch (Exception e) {
            logger.error((Object)"Configuration error", (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Invalid settings", (Throwable)e);
        }
        SQLSparkIntegrationCheckResult ret = new SQLSparkIntegrationCheckResult();
        if (!conn.detailsReadableBy(this.authCtx)) {
            ret.canHaveSparkIntegration.withFatal((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Details of connection aren't readable by user, direct access is disabled in Spark");
        }
        ret.canHaveSparkIntegration.mergeFrom(conn.canHaveSparkIntegration());
        if (!conn.getParams().sendDriverJarsToSpark) {
            ret.canHaveSparkIntegration.withWarning((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "The driver for the connection needs to be passed manually to Spark");
        }
        ret.canHaveSparkIntegration.mergeFrom(((AbstractSQLDatasetHandler)this.dh).resolvedAbstractConfig.canHaveSparkIntegration(null));
        ret.canHaveSparkIntegration.summarize();
        SparkSettings sparkSettings = new ClusterSelector().selectForProject(this.authCtx, this.dataset.getProjectKey()).getSparkSettings();
        ret.sparkVersion = SparkSubmitHelper.getSparkVersion(sparkSettings);
        ret.canBePartitionedOn = ret.sparkVersion.startsWith("3.") ? this.dataset.getSchema().getColumns().stream().filter(sc -> sc.getType().isNumeric() || sc.getType().isTemporal()).map(sc -> sc.getName()).collect(Collectors.toList()) : this.dataset.getSchema().getColumns().stream().filter(sc -> sc.getType().isNumeric()).map(sc -> sc.getName()).collect(Collectors.toList());
        List<ReadOnlyJobsInternalDB.MetricDataPoint> metricDataPoints = this.jobsDatabaseService.getLastMetrics(this.dataset.getLoc(), this.dataset.getPartitioningSchema().isPartitioned() ? "ALL" : "NP");
        for (ReadOnlyJobsInternalDB.MetricDataPoint metricDataPoint : metricDataPoints) {
            if (!(metricDataPoint.metric instanceof BasicStatsDatasetProbeType.BasicStatsDatasetMetric)) continue;
            BasicStatsDatasetProbeType.BasicStatsDatasetMetric metric = (BasicStatsDatasetProbeType.BasicStatsDatasetMetric)metricDataPoint.metric;
            if (metric.metricType == BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MIN) {
                ret.columnMinMetrics.put(metric.column, this.tryRoundMetricValue(metricDataPoint.value, metricDataPoint.type, false));
            }
            if (metric.metricType != BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MAX) continue;
            ret.columnMaxMetrics.put(metric.column, this.tryRoundMetricValue(metricDataPoint.value, metricDataPoint.type, true));
        }
        return ret;
    }

    private String tryRoundMetricValue(String value, Type type, boolean roundUp) {
        if (type != null && type.isNumeric()) {
            try {
                long l = Long.parseLong(value);
                return Long.toString(l);
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to read " + value + " as integral"));
                try {
                    double d = Double.parseDouble(value);
                    long l = (long)(roundUp ? Math.ceil(d) : Math.floor(d));
                    return Long.toString(l);
                }
                catch (Exception e2) {
                    logger.warn((Object)("Unable to round " + value));
                    return value;
                }
            }
        }
        return value;
    }

    public static abstract class SQLDatasetTestResult {
        public boolean connectionOK;
        public SerializedError connectionError;
        public boolean catalogAware;
        public boolean schemaAware;
        public boolean canFetchCatalogs = true;
        public boolean canFetchSchemas = true;
        public boolean testedConnectionOnly = false;
        public SerializedMemTableSimple preview;
        public String previewErrorMsg;
        public SchemaDetection.SchemaDetectionResult schemaDetection;
    }

    static class ConnRet
    implements AutoCloseable {
        @Nonnull
        public final SQLConnectionProvider.SQLConnectionData cd;
        @Nonnull
        public final SQLConnectionProvider.SQLConnectionWrapper jdbcConn;

        public ConnRet(@Nonnull SQLConnectionProvider.SQLConnectionData cd, @Nonnull SQLConnectionProvider.SQLConnectionWrapper jdbcConn) {
            this.cd = cd;
            this.jdbcConn = jdbcConn;
        }

        @Override
        public void close() throws Exception {
            this.jdbcConn.close();
        }
    }

    public static class SQLSparkIntegrationCheckResult {
        public InfoMessage.InfoMessages canHaveSparkIntegration = new InfoMessage.InfoMessages();
        public String sparkVersion = "2.x";
        public List<String> canBePartitionedOn = Lists.newArrayList();
        public Map<String, String> columnMaxMetrics = Maps.newHashMap();
        public Map<String, String> columnMinMetrics = Maps.newHashMap();
    }
}

