/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.statsdb;

import com.dataiku.dip.activity.DSSUsageStatsInternalDB;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.statsdb.StatsDBDatasetMeta;
import com.dataiku.dip.datasets.statsdb.StatsDBDatasetParams;
import com.dataiku.dip.datasets.statsdb.StatsDBDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class StatsDBDatasetHandler
implements RowOrientedDatasetHandler {
    @Autowired
    private DSSUsageStatsInternalDB statsDbService;
    @Autowired
    protected ReadOnlyJobsInternalDB jobsDatabaseAccessService;
    private final StatsDBDatasetParams params;
    private final Dataset dataset;
    public static final StatsDBDatasetMeta META = new StatsDBDatasetMeta();
    private static final Logger logger = Logger.getLogger((String)"dku.datasets.statsdb");

    public StatsDBDatasetHandler(Dataset dataset) {
        this.dataset = dataset;
        this.params = dataset.getParamsAs(StatsDBDatasetParams.class);
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return META;
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new StatsDBDatasetTestHandler(this);
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException {
    }

    @Override
    public String suggestName() {
        if (this.params.view == null) {
            return null;
        }
        switch (this.params.view) {
            case CLUSTER_TASKS: {
                return "dss_cluster_tasks";
            }
            case COMMITS: {
                return "dss_commits";
            }
            case JOBS: {
                return "dss_jobs";
            }
            case SCENARIO_RUNS: {
                return "dss_scenario_runs";
            }
            case FLOW_ACTIONS: {
                return "dss_flow_actions";
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return true;
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return false;
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public void createManaged() throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot manage a Stats dataset");
    }

    @Override
    public void clearAllData() throws Exception {
        logger.warn((Object)"Cannot manage a Stats dataset");
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        logger.warn((Object)"Cannot manage a Stats dataset");
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        logger.warn((Object)"Cannot manage a Stats dataset");
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot write on a Stats dataset");
    }

    @Override
    public boolean outputHandlesClear() {
        return true;
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        return this.getRecords();
    }

    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        return DatasetReadiness.ready(null);
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        return new FilterResultWithSplits().withMatchingPartition(new Partition(null)).withSplit((InputSplit)this.getSingleSplit());
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        if (this.params.view == StatsDBDatasetParams.View.CLUSTER_TASKS) {
            return new ClusterTasksSplit();
        }
        if (this.params.view == StatsDBDatasetParams.View.COMMITS) {
            return new CommitsTasksSplit();
        }
        if (this.params.view == StatsDBDatasetParams.View.JOBS) {
            return new JobsSplit();
        }
        if (this.params.view == StatsDBDatasetParams.View.SCENARIO_RUNS) {
            return new ScenarioRunsSplit();
        }
        if (this.params.view == StatsDBDatasetParams.View.FLOW_ACTIONS) {
            return new FlowActionsSplit();
        }
        throw new IllegalArgumentException("Unknown view type for the jobs db" + String.valueOf((Object)this.params.view));
    }

    @Override
    public long getRecords() throws Exception {
        throw new NotImplementedException();
    }

    public static Schema getSchema(StatsDBDatasetParams.View view) {
        ArrayList columns = Lists.newArrayList();
        if (view == StatsDBDatasetParams.View.CLUSTER_TASKS) {
            columns.addAll(Arrays.asList(DSSUsageStatsInternalDB.getConnectionTasksColumnsForInternalStatsDataset()));
        } else if (view == StatsDBDatasetParams.View.COMMITS) {
            columns.addAll(Arrays.asList(DSSUsageStatsInternalDB.getCommitStatsColumnsForInternalStatsDataset()));
        } else if (view == StatsDBDatasetParams.View.JOBS) {
            columns.addAll(Arrays.asList(ReadOnlyJobsInternalDB.getJobsViewColumnsForInternalStatsDataset()));
        } else if (view == StatsDBDatasetParams.View.SCENARIO_RUNS) {
            columns.addAll(Arrays.asList(ReadOnlyJobsInternalDB.getScenarioRunsViewColumnsForInternalStatsDataset()));
        } else if (view == StatsDBDatasetParams.View.FLOW_ACTIONS) {
            columns.addAll(Arrays.asList(ReadOnlyJobsInternalDB.getFlowActionsViewColumnsForInternalStatsDataset()));
        } else {
            throw new NotImplementedException();
        }
        return new Schema((List)columns, false);
    }

    class ClusterTasksSplit
    extends RowsInputSplit {
        ClusterTasksSplit() {
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            return StatsDBDatasetHandler.this.statsDbService.pushLastConnectionTasks(out, cf, rf, limit, StatsDBDatasetHandler.this.params.clusterTasks.projectKey, StatsDBDatasetHandler.this.params.clusterTasks.connection);
        }

        public String getDesc() {
            return "StatsDB_clusterTasks";
        }
    }

    class CommitsTasksSplit
    extends RowsInputSplit {
        CommitsTasksSplit() {
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            return StatsDBDatasetHandler.this.statsDbService.pushCommits(out, cf, rf, limit, StatsDBDatasetHandler.this.params.commits.projectKey);
        }

        public String getDesc() {
            return "StatsDB_commits";
        }
    }

    class JobsSplit
    extends RowsInputSplit {
        JobsSplit() {
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            return StatsDBDatasetHandler.this.jobsDatabaseAccessService.pushJobs(out, cf, rf, limit, listener, StatsDBDatasetHandler.this.params.jobs.projectKey);
        }

        public String getDesc() {
            return "StatsDB_jobs";
        }
    }

    class ScenarioRunsSplit
    extends RowsInputSplit {
        ScenarioRunsSplit() {
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            return StatsDBDatasetHandler.this.jobsDatabaseAccessService.pushScenarioRuns(out, cf, rf, limit, listener, StatsDBDatasetHandler.this.params.scenarioRuns.projectKey);
        }

        public String getDesc() {
            return "StatsDB_scenarioruns";
        }
    }

    class FlowActionsSplit
    extends RowsInputSplit {
        FlowActionsSplit() {
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            return StatsDBDatasetHandler.this.jobsDatabaseAccessService.pushFlowActions(out, cf, rf, limit, listener, StatsDBDatasetHandler.this.params.flowActions.projectKey, StatsDBDatasetHandler.this.params.orderByDate);
        }

        public String getDesc() {
            return "StatsDB_flowactions";
        }
    }
}

