/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.datamodel.actual;

import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.List;
import javax.annotation.Nonnull;

@UIModel
public enum DeploymentHealth {
    UNKNOWN(0),
    HEALTHY(1),
    OUT_OF_SYNC(2),
    WARNING(3),
    UNHEALTHY(4),
    ERROR(5),
    DISABLED(6);

    private Integer severity;

    private DeploymentHealth(int severity) {
        this.severity = severity;
    }

    @Nonnull
    public static DeploymentHealth getWithHighestSeverity(@Nonnull List<DeploymentHealth> healths) {
        if (healths.isEmpty()) {
            throw ErrorContext.iae((String)"An empty collection provided for calculation of DeploymentHealth of the highest severity");
        }
        DeploymentHealth severestHealth = UNKNOWN;
        for (DeploymentHealth health : healths) {
            severestHealth = severestHealth.getSeverer(health);
        }
        return severestHealth;
    }

    public boolean isSevererThan(@Nonnull DeploymentHealth other) {
        return this.severity > other.severity;
    }

    public DeploymentHealth getSeverer(@Nonnull DeploymentHealth other) {
        return this.isSevererThan(other) ? this : other;
    }

    public Integer getSeverity() {
        return this.severity;
    }
}

