/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.deployments.actions.updates;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentHeavyStatus;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentAction;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentUpdate;
import com.dataiku.dip.deployer.common.deployments.actions.FullDeploymentUpdate;
import com.dataiku.dip.deployer.common.deployments.actions.updates.exceptions.DeploymentUpdateNotFoundException;
import com.dataiku.dip.deployer.common.deployments.actions.updates.exceptions.DeploymentUpdateReadException;
import com.dataiku.dip.deployer.common.exceptions.DeploymentInfraTypeException;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.stereotype.Service;

@Service
public class FileBasedDeploymentUpdateDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.updates.dao");

    protected File getUpdateDir(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment, long startTimestamp) {
        return DKUApp.getFile((File)this.getUpdatesParentDir(infra, deployment), (String[])new String[]{String.valueOf(startTimestamp)});
    }

    protected File getUpdateFile(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment, long startTimestamp) {
        return DKUApp.getFile((File)this.getUpdateDir(infra, deployment, startTimestamp), (String[])new String[]{"update.json"});
    }

    protected File getUpdateFile(DeploymentUpdate update) {
        return this.getUpdateFile(update.getInfra(), update.getDeployment(), update.getStartTimestamp());
    }

    protected File getUpdateLogsFile(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment, long startTimestamp) {
        return DKUApp.getFile((File)this.getUpdateDir(infra, deployment, startTimestamp), (String[])new String[]{"deployment.log"});
    }

    protected File getUpdateHeavyStatusFile(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment, long startTimestamp) {
        return DKUApp.getFile((File)this.getUpdateDir(infra, deployment, startTimestamp), (String[])new String[]{"heavy-status.json"});
    }

    protected File getUpdatesParentDir(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment) {
        String parentDirName;
        AbstractDeploymentInfra.InfraType.BaseType baseInfraType = infra.getInfraType().baseType;
        if (baseInfraType == AbstractDeploymentInfra.InfraType.BaseType.API) {
            parentDirName = "api-deployer";
        } else if (baseInfraType == AbstractDeploymentInfra.InfraType.BaseType.PROJECT) {
            parentDirName = "project-deployer";
        } else {
            throw new DeploymentInfraTypeException(baseInfraType);
        }
        return DKUApp.getFile((String[])new String[]{parentDirName, "last-updates", infra.id, deployment.id});
    }

    protected void save(DeploymentUpdate update, File updateFile) throws IOException {
        JSON.prettyToFile((Object)update, (File)updateFile);
        logger.infoV("Stored deployment update at '%s'", new Object[]{updateFile.getAbsolutePath()});
    }

    @Nonnull
    private DeploymentUpdate get(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment, long timestamp, boolean includesAdminInfo) throws IOException {
        File file = this.getUpdateFile(infra, deployment, timestamp);
        DeploymentUpdate update = (DeploymentUpdate)JSON.parseFile((File)file, DeploymentUpdate.class);
        return includesAdminInfo ? update : update.withoutAdminInfo();
    }

    protected DeploymentUpdate getMandatory(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment, long timestamp, boolean includesAdminInfo) throws DeploymentUpdateNotFoundException, DeploymentUpdateReadException {
        File file = this.getUpdateFile(infra, deployment, timestamp);
        String path = file.getAbsolutePath();
        if (!file.isFile()) {
            throw new DeploymentUpdateNotFoundException("Deployment update file not found: " + path);
        }
        try {
            return this.get(infra, deployment, timestamp, includesAdminInfo);
        }
        catch (IOException e) {
            throw new DeploymentUpdateReadException("Unable to read deployment update file: " + path, e);
        }
    }

    @Nullable
    private DeploymentUpdate getOrNull(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment, long timestamp, boolean includesAdminInfo) {
        try {
            return this.get(infra, deployment, timestamp, includesAdminInfo);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<String> getLogs(AbstractDeploymentInfra infra, AbstractDeployment deployment, long timestamp) throws IOException {
        File logFile = this.getUpdateLogsFile(infra, deployment, timestamp);
        String path = logFile.getAbsolutePath();
        if (!logFile.isFile()) {
            logger.warnV("Deployment update logs file not found: '%s'", new Object[]{path});
            return Collections.emptyList();
        }
        try {
            List<String> lines = Files.readAllLines(logFile.toPath());
            logger.infoV("Successfully read %d log lines from: '%s'", new Object[]{lines.size(), path});
            return lines;
        }
        catch (IOException e) {
            logger.warnV((Throwable)e, "Error reading deployment update logs from: '%s'", new Object[]{path});
            throw e;
        }
    }

    public void saveHeavyStatus(AbstractDeploymentInfra infra, AbstractDeployment deployment, long timestamp, AbstractDeploymentHeavyStatus heavyStatus) {
        File file = this.getUpdateHeavyStatusFile(infra, deployment, timestamp);
        String absPath = file.getAbsolutePath();
        if (heavyStatus == null) {
            logger.warnV("Deployment heavy status is a null and cannot be stored at '%s'", new Object[]{absPath});
            return;
        }
        try {
            JSON.prettyToFile((Object)heavyStatus, (File)file);
            logger.infoV("Successfully stored deployment heavy status at '%s'", new Object[]{absPath});
        }
        catch (IOException e) {
            logger.warnV((Throwable)e, "Exception while storing deployment heavy status at '%s'", new Object[]{absPath});
        }
    }

    @Nullable
    private AbstractDeploymentHeavyStatus getHeavyStatus(AbstractDeploymentInfra infra, AbstractDeployment deployment, long timestamp) throws IOException {
        File statusFile = this.getUpdateHeavyStatusFile(infra, deployment, timestamp);
        String path = statusFile.getAbsolutePath();
        if (!statusFile.isFile()) {
            logger.warnV("Deployment update's heavy status file not found: '%s'", new Object[]{path});
            return null;
        }
        try {
            AbstractDeploymentHeavyStatus status = (AbstractDeploymentHeavyStatus)JSON.parseFile((File)statusFile, AbstractDeploymentHeavyStatus.class);
            logger.infoV("Successfully read heavy status from from: '%s'", new Object[]{path});
            return status;
        }
        catch (IOException e) {
            logger.warnV((Throwable)e, "Error reading deployment update's heavy status from '%s'", new Object[]{path});
            throw e;
        }
    }

    protected FullDeploymentUpdate getFullMandatory(AbstractDeploymentInfra infra, AbstractDeployment deployment, long timestamp, boolean includesAdminInfo) throws IOException {
        DeploymentUpdate update = this.getMandatory(infra, deployment, timestamp, includesAdminInfo);
        if (update == null) {
            return null;
        }
        List<String> logs = this.getLogs(infra, deployment, timestamp);
        AbstractDeploymentHeavyStatus heavyStatus = this.getHeavyStatus(infra, deployment, timestamp);
        FullDeploymentUpdate heavyUpdate = new FullDeploymentUpdate(update, logs, heavyStatus);
        return includesAdminInfo ? heavyUpdate : heavyUpdate.withoutAdminInfo();
    }

    @Nullable
    protected List<File> listDirs(File parentDir) {
        if (!parentDir.isDirectory()) {
            logger.warnV("Last deployment updates parent directory doesn't exist: '%s'", new Object[]{parentDir.getAbsolutePath()});
            return null;
        }
        File[] subDirs = parentDir.listFiles(File::isDirectory);
        if (subDirs == null) {
            return null;
        }
        Arrays.sort(subDirs, Comparator.comparing(File::getName));
        return List.of(subDirs);
    }

    @Nullable
    protected List<File> listDirs(AbstractDeploymentInfra infra, AbstractDeployment deployment) {
        File parentDir = this.getUpdatesParentDir(infra, deployment);
        return this.listDirs(parentDir);
    }

    public List<DeploymentUpdate> list(AbstractDeploymentInfra infra, AbstractDeployment deployment, boolean includesAdminInfo) {
        List<File> files = this.listDirs(infra, deployment);
        if (files == null) {
            return List.of();
        }
        return files.stream().map(File::getName).filter(s -> s.matches("\\d+")).map(id -> this.getOrNull(infra, deployment, Long.parseLong(id), includesAdminInfo)).filter(Objects::nonNull).sorted(Comparator.comparingLong(DeploymentAction::getStartTimestamp).reversed()).toList();
    }

    public List<DeploymentUpdate.Head> listHeads(AbstractDeploymentInfra infra, AbstractDeployment deployment) {
        return this.list(infra, deployment, false).stream().map(DeploymentUpdate::asHead).toList();
    }

    protected void deleteParentDir(AbstractDeploymentInfra infra, AbstractDeployment deployment) throws IOException {
        File lastUpdatesDir = this.getUpdatesParentDir(infra, deployment);
        if (lastUpdatesDir.exists()) {
            DKUFileUtils.forceDelete((File)lastUpdatesDir);
        }
    }

    protected void deleteUpdateDir(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment, long startTimestamp) {
        File updateDir = this.getUpdateDir(infra, deployment, startTimestamp);
        this.deleteUpdateDir(updateDir);
    }

    protected void deleteUpdateDir(@Nonnull File updateDir) {
        String absPath = updateDir.getAbsolutePath();
        if (!updateDir.isDirectory()) {
            logger.debugV("No update directory to delete at '%s'", new Object[]{absPath});
            return;
        }
        try {
            DKUFileUtils.deleteDirectory((File)updateDir);
            logger.infoV("Deleted deployment update directory at '%s'", new Object[]{absPath});
        }
        catch (IOException e) {
            logger.warnV((Throwable)e, "Exception while deleting deployment update at '%s'", new Object[]{absPath});
        }
    }

    protected void deleteAllUpdates(@Nonnull AbstractDeploymentInfra infra, @Nonnull AbstractDeployment deployment) {
        String absPath = this.getUpdatesParentDir(infra, deployment).getAbsolutePath();
        try {
            this.deleteParentDir(infra, deployment);
            logger.infoV("Deleted all deployment update directories at '%s'", new Object[]{absPath});
        }
        catch (IOException e) {
            logger.warnV((Throwable)e, "Exception while deleting all deployment update directories at '%s'", new Object[]{absPath});
        }
    }
}

