/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.docextraction.StructuredContentDTO;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.docextraction.common.chunks.TextFirstExtractionChunk;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

@PolyJSON(value={@Mapping(type="document", value=Document.class), @Mapping(type="section", value=Section.class), @Mapping(type="slide", value=Slide.class), @Mapping(type="text", value=Text.class), @Mapping(type="image", value=Image.class), @Mapping(type="table", value=Table.class)})
public abstract class Content {
    public List<Integer> pages;
    public List<Content> content;
    public PageRange pageRange;
    public Content collapsedSubTree;

    protected static List<Content> mergeNonSectionItems(List<Content> items, boolean useSeparatedChunksForImages) {
        ArrayList<Content> result = new ArrayList<Content>();
        ArrayList<Object> textsToMerge = new ArrayList<Object>();
        PageRange currentPageRange = new PageRange();
        for (Content item : items) {
            if (item instanceof Section || useSeparatedChunksForImages && item instanceof Image) {
                if (!textsToMerge.isEmpty()) {
                    Text text = new Text(String.join((CharSequence)"", textsToMerge));
                    text.pageRange = currentPageRange;
                    currentPageRange = new PageRange();
                    result.add(text);
                    textsToMerge.clear();
                }
                result.add(item);
                continue;
            }
            if (item.pageRange != null) {
                currentPageRange.mergeWith(item.pageRange);
            }
            if (!textsToMerge.isEmpty() && !((String)textsToMerge.get(textsToMerge.size() - 1)).endsWith("\n")) {
                textsToMerge.add("\n" + item.toText());
                continue;
            }
            textsToMerge.add(item.toText());
        }
        if (!textsToMerge.isEmpty()) {
            Text lastTxt = new Text(String.join((CharSequence)"", textsToMerge));
            lastTxt.pageRange = currentPageRange;
            result.add(lastTxt);
        }
        return result;
    }

    private static void copyPageFields(Content fromContent, Content toContent) {
        if (fromContent.pageRange != null) {
            toContent.pageRange = new PageRange(fromContent.pageRange.start, fromContent.pageRange.end);
        }
        if (fromContent.pages != null) {
            toContent.pages = new ArrayList<Integer>(fromContent.pages);
        }
    }

    protected PageRange flattenToText(StringBuilder sb) {
        if (StringUtils.isNotBlank((String)this.toText())) {
            sb.append(this.toText()).append("\n");
        }
        return this.pageRange;
    }

    public void flattenContentDeeperThanMaxSectionDepth(int maxSectionDepth) {
    }

    protected List<TextFirstExtractionChunk> flattenTreeAndMergeContinuousSectionContent(List<String> currentOutline, boolean useSeparatedChunksForImages) {
        return Collections.singletonList(TextFirstExtractionChunk.build(this.toText(), currentOutline, null, this.pageRange));
    }

    public List<TextFirstExtractionChunk> flattenTreeAndMergeContinuousSectionContent(boolean useSeparatedChunksForImages) {
        return this.flattenTreeAndMergeContinuousSectionContent(Collections.emptyList(), useSeparatedChunksForImages);
    }

    public abstract String getType();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Content other = (Content)obj;
        return Objects.equals(this.content, other.content) && Objects.equals(this.pages, other.pages) && this.equalsFields(other);
    }

    protected Content deepCopy() {
        Content copy = this.cloneWithoutChildren();
        if (this.content != null) {
            copy.content = new ArrayList<Content>();
            for (Content child : this.content) {
                copy.content.add(child.deepCopy());
            }
        }
        return copy;
    }

    public int hashCode() {
        int hash = Objects.hash(this.getType(), this.pages, this.pageRange);
        if (this.content != null) {
            for (Content child : this.content) {
                hash = 31 * hash + Objects.hashCode(child);
            }
        }
        return hash;
    }

    protected abstract boolean equalsFields(Content var1);

    @NotNull
    protected abstract String toText();

    protected abstract Content cloneWithoutChildren();

    public Content copyWithImmediateNonSectionChildren() {
        Content copy = this.cloneWithoutChildren();
        if (this.content == null || this.content.isEmpty()) {
            return copy;
        }
        copy.content = new ArrayList<Content>();
        for (Content child : this.content) {
            if (child instanceof Section) continue;
            copy.content.add(child.cloneWithoutChildren());
        }
        return copy;
    }

    public void addChild(Content child) {
        if (this.content == null) {
            this.content = new ArrayList<Content>();
        }
        this.content.add(child);
    }

    public StructuredContentDTO toDTO(boolean forExtractContentRecipe) {
        StructuredContentDTO dto;
        switch (this.getType()) {
            case "document": {
                dto = new StructuredContentDTO.Document();
                break;
            }
            case "section": {
                dto = new StructuredContentDTO.Section(((Section)this).level, this.toText());
                break;
            }
            case "slide": {
                dto = new StructuredContentDTO.Slide(((Slide)this).level, this.toText());
                break;
            }
            case "text": {
                dto = new StructuredContentDTO.Text(this.toText());
                break;
            }
            case "table": {
                dto = new StructuredContentDTO.Table(this.toText());
                break;
            }
            case "image": {
                Image image = (Image)this;
                dto = new StructuredContentDTO.Image(image.mimeType, image.description, image.resolution, image.height, image.width, image.caption);
                if (forExtractContentRecipe) {
                    InputRefs.SingleImageRef singleImageRef = image.imageRef;
                    if (!(singleImageRef instanceof InputRefs.SingleManagedFolderImageRef)) break;
                    InputRefs.SingleManagedFolderImageRef ref = (InputRefs.SingleManagedFolderImageRef)singleImageRef;
                    ((StructuredContentDTO.Image)dto).image = ref.path;
                    break;
                }
                ((StructuredContentDTO.Image)dto).imageRef = image.imageRef;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown StructuredContent type: " + this.getClass().getName());
            }
        }
        dto.pageRange = this.pageRange;
        if (this.content != null) {
            dto.content = new ArrayList<StructuredContentDTO>();
            dto.content = this.content.stream().map(child -> child.toDTO(forExtractContentRecipe)).toList();
        }
        return dto;
    }

    public static class PageRange {
        public Integer start;
        public Integer end;

        public PageRange() {
        }

        public PageRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public void mergeWith(PageRange other) {
            if (other == null) {
                return;
            }
            if (other.start != null) {
                this.start = this.start != null ? Integer.valueOf(Math.min(this.start, other.start)) : other.start;
            }
            if (other.end != null) {
                this.end = this.end != null ? Integer.valueOf(Math.max(this.end, other.end)) : other.end;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PageRange)) {
                return false;
            }
            PageRange otherPageRange = (PageRange)o;
            return Objects.equals(this.start, otherPageRange.start) && Objects.equals(this.end, otherPageRange.end);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }
    }

    public static class Section
    extends Content {
        public Integer level;
        public String title;

        public Section() {
        }

        public Section(Integer level, String title) {
            this.level = level;
            this.title = title;
        }

        @Override
        public String getType() {
            return "section";
        }

        @Override
        protected boolean equalsFields(Content other) {
            if (!(other instanceof Section)) {
                return false;
            }
            Section section = (Section)other;
            return Objects.equals(section.title, this.title) && Objects.equals(section.level, this.level);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.level, this.title);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        @NotNull
        protected String toText() {
            return this.title == null ? "" : this.title;
        }

        @Override
        protected Content cloneWithoutChildren() {
            Section section = new Section(this.level, this.title);
            Content.copyPageFields(this, section);
            return section;
        }

        @Override
        public void flattenContentDeeperThanMaxSectionDepth(int maxSectionDepth) {
            ArrayList<Content> newChildren = new ArrayList<Content>();
            if (this.level != null && this.level == maxSectionDepth) {
                this.collapsedSubTree = this.deepCopy();
            }
            for (Content child : this.content) {
                if (child instanceof Section) {
                    Section childSection = (Section)child;
                    if (childSection.level != null && childSection.level > maxSectionDepth) {
                        StringBuilder sb = new StringBuilder();
                        PageRange pageRange = child.flattenToText(sb);
                        Text text = new Text(sb.toString());
                        text.pageRange = pageRange;
                        newChildren.add(text);
                        continue;
                    }
                }
                if (child == null) continue;
                child.flattenContentDeeperThanMaxSectionDepth(maxSectionDepth);
                newChildren.add(child);
            }
            this.content = newChildren;
        }

        @Override
        protected List<TextFirstExtractionChunk> flattenTreeAndMergeContinuousSectionContent(List<String> currentOutline, boolean useSeparatedChunksForImages) {
            ArrayList<String> deeperOutline = new ArrayList<String>(currentOutline);
            if (!Objects.equals(this.getType(), "slide") && this.title != null) {
                deeperOutline.add(this.title);
            }
            if (this.content == null || this.content.isEmpty()) {
                if (StringUtils.isNotBlank((String)this.title)) {
                    return Collections.singletonList(TextFirstExtractionChunk.build("", deeperOutline, this.cloneWithoutChildren(), this.pageRange));
                }
                return Collections.emptyList();
            }
            ArrayList<TextFirstExtractionChunk> list = new ArrayList<TextFirstExtractionChunk>();
            List<Content> mergedItems = Section.mergeNonSectionItems(this.content, useSeparatedChunksForImages);
            if (!Objects.equals(this.getType(), "document") && !Objects.equals(this.getType(), "slide") && mergedItems.stream().allMatch(mergedItem -> mergedItem instanceof Section)) {
                list.add(TextFirstExtractionChunk.build("", deeperOutline, this.copyWithImmediateNonSectionChildren(), this.pageRange));
            }
            for (Content child : mergedItems) {
                if (child instanceof Text) {
                    Text text = (Text)child;
                    if (this.collapsedSubTree != null) {
                        list.add(TextFirstExtractionChunk.build(text.toText(), deeperOutline, this.collapsedSubTree, text.pageRange));
                    } else {
                        list.add(TextFirstExtractionChunk.build(text.toText(), deeperOutline, this.copyWithImmediateNonSectionChildren(), text.pageRange));
                    }
                } else if (child instanceof Image) {
                    Image image = (Image)child;
                    list.add(TextFirstExtractionChunk.buildForImage(image.toText(), deeperOutline, this.copyWithImmediateNonSectionChildren(), image.pageRange, image.caption, image.imageRef));
                }
                if (!(child instanceof Section)) continue;
                Section childSection = (Section)child;
                list.addAll(childSection.flattenTreeAndMergeContinuousSectionContent(deeperOutline, useSeparatedChunksForImages));
            }
            return list;
        }

        @Override
        protected PageRange flattenToText(StringBuilder sb) {
            sb.append(this.toText()).append("\n");
            if (this.content != null) {
                for (Content child : this.content) {
                    PageRange pageRange = child.flattenToText(sb);
                    if (this.pageRange == null) {
                        this.pageRange = pageRange;
                        continue;
                    }
                    this.pageRange.mergeWith(pageRange);
                }
            }
            return this.pageRange;
        }
    }

    public static class Image
    extends Content {
        public InputRefs.SingleImageRef imageRef;
        public String mimeType;
        public String description;
        public Integer resolution;
        public Long height;
        public Long width;
        public String caption;
        public ImageClassificationData classificationData;

        @Override
        public String getType() {
            return "image";
        }

        @Override
        protected boolean equalsFields(Content other) {
            if (!(other instanceof Image)) {
                return false;
            }
            Image image = (Image)other;
            return Objects.equals(image.mimeType, this.mimeType) && Objects.equals(image.description, this.description) && Objects.equals(image.resolution, this.resolution) && Objects.equals(image.height, this.height) && Objects.equals(image.width, this.width) && Objects.equals(image.caption, this.caption);
        }

        @Override
        @NotNull
        public String toText() {
            return this.description == null ? "" : this.description;
        }

        @Override
        protected Content cloneWithoutChildren() {
            Image image = new Image();
            image.imageRef = this.imageRef;
            image.description = this.description;
            image.resolution = this.resolution;
            image.height = this.height;
            image.width = this.width;
            image.caption = this.caption;
            Content.copyPageFields(this, image);
            return image;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.imageRef, this.mimeType, this.description, this.resolution, this.height, this.width, this.caption);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        protected List<TextFirstExtractionChunk> flattenTreeAndMergeContinuousSectionContent(List<String> currentOutline, boolean useSeparatedChunksForImages) {
            return Collections.singletonList(TextFirstExtractionChunk.buildForImage(this.toText(), currentOutline, null, this.pageRange, this.caption, this.imageRef));
        }

        public static class ImageClassificationData {
            public String className;
            public double confidence;
        }
    }

    public static class Text
    extends Content {
        public String text;

        public Text() {
        }

        public Text(String text) {
            this.text = text;
        }

        @Override
        public String getType() {
            return "text";
        }

        @Override
        @NotNull
        public String toText() {
            return this.text == null ? "" : this.text;
        }

        @Override
        public Content cloneWithoutChildren() {
            Text clone = new Text(this.text);
            Content.copyPageFields(this, clone);
            return clone;
        }

        @Override
        protected boolean equalsFields(Content other) {
            if (!(other instanceof Text)) {
                return false;
            }
            Text textNode = (Text)other;
            return Objects.equals(textNode.text, this.text);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.text);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    public static class Slide
    extends Section {
        public Slide() {
        }

        public Slide(Integer level, String title) {
            this.level = level;
            this.title = title;
        }

        @Override
        public String getType() {
            return "slide";
        }

        @Override
        protected boolean equalsFields(Content other) {
            if (!(other instanceof Slide)) {
                return false;
            }
            Slide slide = (Slide)other;
            return Objects.equals(slide.title, this.title) && Objects.equals(slide.level, this.level);
        }

        @Override
        protected Content cloneWithoutChildren() {
            Slide slide = new Slide(this.level, this.title);
            Content.copyPageFields(this, slide);
            return slide;
        }
    }

    public static class Table
    extends Content {
        public String text;

        @Override
        public String getType() {
            return "table";
        }

        @Override
        @NotNull
        public String toText() {
            return this.text == null ? "" : this.text;
        }

        @Override
        public Content cloneWithoutChildren() {
            Table table = new Table();
            table.text = this.text;
            Content.copyPageFields(this, table);
            return table;
        }

        @Override
        protected boolean equalsFields(Content other) {
            if (!(other instanceof Table)) {
                return false;
            }
            Table table = (Table)other;
            return Objects.equals(table.text, this.text);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.text);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    public static class Document
    extends Section {
        public Document() {
            this.level = 0;
        }

        @Override
        public String getType() {
            return "document";
        }

        @Override
        protected boolean equalsFields(Content other) {
            if (!(other instanceof Document)) {
                return false;
            }
            Document document = (Document)other;
            return Objects.equals(document.level, this.level) && Objects.equals(document.title, this.title);
        }
    }
}

