/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.resampling;

import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.j2ts.annotations.UIModel;

@UIModel
public class ResamplerSettings
extends ImmutableValueObject {
    public int nUnits;
    public TimeUnit timeUnit;
    public InterpolationMethod interpolationMethod = InterpolationMethod.LINEAR;
    public double interpolationConstantValue = 0.0;
    public ExtrapolationMethod extrapolationMethod = ExtrapolationMethod.NO_EXTRAPOLATION;
    public double extrapolationConstantValue = 0.0;
    public BoundaryDateMode startDateMode = BoundaryDateMode.AUTO;
    public String customStartDate = "";
    public BoundaryDateMode endDateMode = BoundaryDateMode.AUTO;
    public String customEndDate = "";
    public DayOfWeek timeUnitEndOfWeek = DayOfWeek.SUNDAY;
    public EndOfQuarter timeUnitEndOfQuarter = EndOfQuarter.MAR_JUN_SEP_DEC;
    public EndOfHalfYear timeUnitEndOfHalfYear = EndOfHalfYear.JUN_DEC;
    public EndOfYear timeUnitEndOfYear = EndOfYear.DECEMBER;
    public int timeUnitMonthlyAlignment = 31;
    public DuplicateTimestampsHandlingMethod duplicateTimestampsHandlingMethod = DuplicateTimestampsHandlingMethod.FAIL_IF_CONFLICTING;

    public ResamplerSettings(int nUnits, TimeUnit timeUnit) {
        this.nUnits = nUnits;
        this.timeUnit = timeUnit;
    }

    private ResamplerSettings() {
    }

    public static enum InterpolationMethod {
        NEAREST,
        PREVIOUS,
        NEXT,
        LINEAR,
        QUADRATIC,
        CUBIC,
        CONSTANT,
        STAIRCASE;

    }

    public static enum ExtrapolationMethod {
        PREVIOUS_NEXT,
        NO_EXTRAPOLATION,
        CONSTANT,
        LINEAR,
        QUADRATIC,
        CUBIC;

    }

    public static enum BoundaryDateMode {
        AUTO,
        CUSTOM;

    }

    public static enum DayOfWeek {
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY,
        SUNDAY;

    }

    public static enum EndOfQuarter {
        JAN_APR_JUL_OCT,
        FEB_MAY_AUG_NOV,
        MAR_JUN_SEP_DEC;

    }

    public static enum EndOfHalfYear {
        JAN_JUL,
        FEB_AUG,
        MAR_SEP,
        APR_OCT,
        MAY_NOV,
        JUN_DEC;

    }

    public static enum EndOfYear {
        JANUARY,
        FEBRUARY,
        MARCH,
        APRIL,
        MAY,
        JUNE,
        JULY,
        AUGUST,
        SEPTEMBER,
        OCTOBER,
        NOVEMBER,
        DECEMBER;

    }

    public static enum DuplicateTimestampsHandlingMethod {
        FAIL_IF_CONFLICTING,
        DROP_IF_CONFLICTING,
        MEAN_MODE;

    }

    public static enum TimeUnit {
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        BUSINESS_DAY,
        DAY,
        WEEK,
        MONTH,
        QUARTER,
        HALF_YEAR,
        YEAR;

    }
}

