/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.bivariate_header;

import com.dataiku.dip.eda.compute.computations.common.Count;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.CrossGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.Abstract2DPivotCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithHighlight;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.GroupingHelpers;
import com.dataiku.dip.utils.ImmutableValueObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class BivariateHistogramCard
extends Abstract2DPivotCard
implements CardWithHighlight {
    public static final String TYPE = "bivariate_histogram";
    @Nullable
    Filter highlightFilter;

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<GroupedComputation, GroupedComputation.GroupedComputationResult>(){

            @Override
            public GroupedComputation getComputationPlan() {
                Grouping xAxis = GroupingHelpers.handleCustomizableVariableGrouping(BivariateHistogramCard.this.xColumn, BivariateHistogramCard.this.xBinningMode, BivariateHistogramCard.this.maxValuesX, BivariateHistogramCard.this.groupWithOthersX, BivariateHistogramCard.this.xCustomBinningBoundaries, true);
                Grouping yAxis = GroupingHelpers.handleCustomizableVariableGrouping(BivariateHistogramCard.this.yColumn, BivariateHistogramCard.this.yBinningMode, BivariateHistogramCard.this.maxValuesY, BivariateHistogramCard.this.groupWithOthersY, BivariateHistogramCard.this.yCustomBinningBoundaries, true);
                ArrayList<Grouping> subsets = new ArrayList<Grouping>();
                subsets.add(SubsetGrouping.all());
                if (BivariateHistogramCard.this.highlightFilter != null) {
                    subsets.add(new SubsetGrouping(BivariateHistogramCard.this.highlightFilter));
                }
                return new GroupedComputation(new Count(), new CrossGrouping(new UnionGrouping(subsets), xAxis, yAxis));
            }

            @Override
            protected CardResult buildFromFullyAvailableResult(GroupedComputation.GroupedComputationResult result) {
                List<Filter> xVals = result.groups.asCross().groups.get(1).listFilters();
                List<Filter> yVals = result.groups.asCross().groups.get(2).listFilters();
                long[] counts = new long[xVals.size() * yVals.size()];
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = result.results.get((int)i).as(Count.CountResult.class).count;
                }
                long[] highlightedCounts = null;
                if (BivariateHistogramCard.this.highlightFilter != null) {
                    highlightedCounts = new long[xVals.size() * yVals.size()];
                    for (int i = 0; i < highlightedCounts.length; ++i) {
                        highlightedCounts[i] = result.results.get((int)(counts.length + i)).as(Count.CountResult.class).count;
                    }
                }
                BivariateHistogramData histogramData = new BivariateHistogramData(xVals, yVals, counts, highlightedCounts);
                return new BivariateHistogramCardResult(histogramData);
            }
        };
    }

    @Override
    public void setHighlightFilter(Filter filter) {
        this.highlightFilter = filter;
    }

    public static class BivariateHistogramCardResult
    extends CardResult {
        public BivariateHistogramData histogram;

        public BivariateHistogramCardResult(BivariateHistogramData histogramData) {
            this.histogram = histogramData;
        }

        private BivariateHistogramCardResult() {
        }
    }

    public static class BivariateHistogramData
    extends ImmutableValueObject {
        public List<Filter> xBins;
        public List<Filter> yBins;
        public long[] counts;
        @Nullable
        public long[] highlightedCounts;

        public BivariateHistogramData(List<Filter> xBins, List<Filter> yBins, long[] counts, @Nullable long[] highlightedCounts) {
            this.xBins = xBins;
            this.yBins = yBins;
            this.counts = counts;
            this.highlightedCounts = highlightedCounts;
        }

        private BivariateHistogramData() {
        }
    }
}

