/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.compute.distributions.Beta;
import com.dataiku.dip.eda.compute.distributions.Binomial;
import com.dataiku.dip.eda.compute.distributions.Distribution;
import com.dataiku.dip.eda.compute.distributions.Exponential;
import com.dataiku.dip.eda.compute.distributions.Laplace;
import com.dataiku.dip.eda.compute.distributions.LogNormal;
import com.dataiku.dip.eda.compute.distributions.Normal;
import com.dataiku.dip.eda.compute.distributions.NormalMixture;
import com.dataiku.dip.eda.compute.distributions.Pareto;
import com.dataiku.dip.eda.compute.distributions.Poisson;
import com.dataiku.dip.eda.compute.distributions.Triangular;
import com.dataiku.dip.eda.compute.distributions.Weibull;
import com.dataiku.dip.eda.worksheets.cards.FitDistributionCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FitDistributionSuggester
implements Suggester {
    private static final Map<Class<? extends Distribution>, String> DISTRIBUTION_NAMES = new HashMap<Class<? extends Distribution>, String>();

    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.size() != 1) {
            return Collections.emptyList();
        }
        SniffedVariable sniffedVariable = sniffedVariables.get(0);
        if (!sniffedVariable.isLikelyNumerical()) {
            return Collections.emptyList();
        }
        List<FitDistributionCard.RequestedDistribution> distributions = sniffedVariable.getGoodDistributionFits().stream().map(FitDistributionCard.RequestedDistribution::new).collect(Collectors.toList());
        if (distributions.isEmpty()) {
            return Collections.emptyList();
        }
        Variable variable = Suggester.toContinuousVariable(sniffedVariable);
        FitDistributionCard card = new FitDistributionCard(variable, distributions);
        String cardName = this.getFitDistributionsCardName(distributions);
        SuggestCards.SuggestedCard suggestion = new SuggestCards.SuggestedCard(cardName, card);
        return Collections.singletonList(suggestion);
    }

    private String getFitDistributionsCardName(List<FitDistributionCard.RequestedDistribution> distributions) {
        if (distributions.size() > 1) {
            return "Fit distributions";
        }
        Distribution distribution = distributions.get((int)0).distribution;
        String distributionName = DISTRIBUTION_NAMES.getOrDefault(((Object)((Object)distribution)).getClass(), "unknown");
        return String.format("Fit %s distribution", distributionName);
    }

    static {
        DISTRIBUTION_NAMES.put(Normal.class, "normal");
        DISTRIBUTION_NAMES.put(NormalMixture.class, "normal mixture");
        DISTRIBUTION_NAMES.put(Triangular.class, "triangular");
        DISTRIBUTION_NAMES.put(Exponential.class, "exponential");
        DISTRIBUTION_NAMES.put(LogNormal.class, "log normal");
        DISTRIBUTION_NAMES.put(Weibull.class, "Weibull");
        DISTRIBUTION_NAMES.put(Poisson.class, "Poisson");
        DISTRIBUTION_NAMES.put(Binomial.class, "binomial");
        DISTRIBUTION_NAMES.put(Beta.class, "beta");
        DISTRIBUTION_NAMES.put(Laplace.class, "Laplace");
        DISTRIBUTION_NAMES.put(Pareto.class, "Pareto");
    }
}

