/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortForwardUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dip.expose.portforward");

    public static abstract class SinglePortForwarderThread
    extends Thread {
        protected final String objectId;
        private final File tmpDir;
        private final SinglePortForwardListener listener;
        private final ExpositionLoggingCallbacks loggingCallbacks;
        private volatile boolean keepLooping = true;

        public SinglePortForwarderThread(String executionId, String objectId, File tmpDir, SinglePortForwardListener listener, ExpositionLoggingCallbacks loggingCallbacks, String parentName) {
            this.objectId = objectId;
            this.tmpDir = tmpDir;
            this.listener = listener;
            this.loggingCallbacks = loggingCallbacks;
            String objectShortId = objectId.replace(parentName, "");
            this.setName("K8SPFForwarder-" + executionId + "-Pod-" + objectShortId + "-" + this.getId());
        }

        public void kill() {
            this.keepLooping = false;
            this.interrupt();
        }

        protected abstract int getTargetPort();

        protected abstract int getForwardPort() throws IOException;

        protected abstract String getObjectDesc();

        protected abstract ProcessBuilder getKubectlProcessBuilder(int var1) throws IOException, InterruptedException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long pollInterval = KubernetesExecUtils.getWebappsPollingPeriodInMillis();
            this.loggingCallbacks.logLine("Start forwarding port " + this.getTargetPort() + " for " + this.getObjectDesc());
            while (this.keepLooping) {
                if (!this.listener.objectIsKnown(this.objectId)) {
                    this.keepLooping = false;
                    logger.warn((Object)"Parent doesn't know this port forwarder thread anymore, stopping");
                    break;
                }
                RegularProcess portForwardProcess = null;
                DKUtils.ExecOutputConsumer portForwardEoc = null;
                Integer forwardPort = null;
                try {
                    forwardPort = this.getForwardPort();
                    this.listener.forward(this.objectId, forwardPort);
                    ProcessBuilder portForwardProcessBuilder = this.getKubectlProcessBuilder(forwardPort);
                    portForwardProcessBuilder.directory(this.tmpDir);
                    this.loggingCallbacks.logLine("Start forwarding to port with " + Joiner.on((String)" ").join(portForwardProcessBuilder.command()));
                    portForwardProcess = new RegularProcess(portForwardProcessBuilder, this.tmpDir);
                    portForwardProcess.start();
                    this.listener.setForwardPid(this.objectId, portForwardProcess.getWorkingPid());
                    final RegularProcess currentPortForwardProcess = portForwardProcess;
                    DKUtils.TagSniffingLineSubscription redFlagSniffer = new DKUtils.TagSniffingLineSubscription(Pattern.compile(".*portforward.go.*error copying from remote stream to local connection.*broken pipe.*")){

                        protected void handleTag(String line, Matcher matcher) {
                            super.handleTag(line, matcher);
                            if (this.hasFoundTag()) {
                                try {
                                    loggingCallbacks.logLine("Broken pipe spotted, killing port-forward to spawn a fresh one");
                                    currentPortForwardProcess.evilKill();
                                }
                                catch (IOException e) {
                                    loggingCallbacks.logLine("Failed to kill port-forward, ignoring: " + e.getMessage());
                                }
                            }
                        }
                    };
                    DKUtils.TagSniffingLineSubscription notreadyinsideFlagSniffer = new DKUtils.TagSniffingLineSubscription(Pattern.compile(".*failed to connect to [^ ]* inside namespace.*connect: connection refused.*")){

                        protected void handleTag(String line, Matcher matcher) {
                            super.handleTag(line, matcher);
                            if (this.hasFoundTag()) {
                                try {
                                    loggingCallbacks.logLine("Port forward target seems not ready, killing port-forward to spawn a fresh one");
                                    currentPortForwardProcess.evilKill();
                                }
                                catch (IOException e) {
                                    loggingCallbacks.logLine("Failed to kill port-forward, ignoring: " + e.getMessage());
                                }
                            }
                        }
                    };
                    portForwardEoc = new DKUtils.ExecOutputConsumer().withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.loggingCallbacks.getSmartLogTailBuilder())).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.loggingCallbacks.getSmartLogTailBuilder())).withOutputConsumer((DKUtils.ExecSubscription)this.loggingCallbacks.getExpositionLog()).withErrorConsumer((DKUtils.ExecSubscription)this.loggingCallbacks.getExpositionLog()).withOutputConsumer((DKUtils.ExecSubscription)redFlagSniffer).withErrorConsumer((DKUtils.ExecSubscription)redFlagSniffer).withOutputConsumer((DKUtils.ExecSubscription)notreadyinsideFlagSniffer).withErrorConsumer((DKUtils.ExecSubscription)notreadyinsideFlagSniffer).withTimestamps(true).withLineContext("[pf-" + this.getTargetPort() + "] ");
                    portForwardEoc.start(portForwardProcess.getInputStream(), portForwardProcess.getErrorStream(), null);
                    int rv = portForwardProcess.waitFor();
                    this.loggingCallbacks.logLine("Port forwarding returned " + rv);
                    portForwardEoc.finish();
                    portForwardProcess = null;
                    portForwardEoc = null;
                }
                catch (InterruptedException e) {
                    if (!this.keepLooping) {
                        logger.info((Object)"Interrupted port forwarding, killing kubectl sub-process");
                    } else {
                        logger.warn((Object)"Port forwarding failed", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Port forwarding failed", (Throwable)e);
                }
                finally {
                    try {
                        this.listener.unforward(this.objectId, forwardPort);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Port forwarding cleanup failed", (Throwable)e);
                    }
                    try {
                        if (portForwardProcess != null) {
                            portForwardProcess.evilKill();
                        }
                        if (portForwardEoc != null) {
                            portForwardEoc.finish();
                        }
                    }
                    catch (Exception e2) {
                        logger.warn((Object)"Failed to stop kubectl port forwarder", (Throwable)e2);
                    }
                }
                this.listener.notifyChange();
                try {
                    Thread.sleep(pollInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn((Object)"Interrupted in port forwarder loop", (Throwable)e);
                }
            }
        }
    }

    public static interface SinglePortForwardListener {
        public void forward(String var1, int var2) throws Exception;

        public void unforward(String var1, Integer var2) throws Exception;

        public void notifyChange();

        public boolean objectIsKnown(String var1);

        public void setForwardPid(String var1, int var2) throws IOException;
    }

    public static interface ExpositionLoggingCallbacks {
        public void logLine(String var1);

        public DKUtils.SmartLogTailBuilder getSmartLogTailBuilder();

        public DKUtils.LineSubscriptionAttacher getExpositionLog();
    }
}

