/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.avro;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.formats.JSONUtils;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.formats.avro.SchemaConverter;
import com.dataiku.dip.formats.avro.StringBuilderPool;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AvroDSSRowReader
implements DatumReader<Row> {
    private static final Logger logger = Logger.getLogger((String)"dku.input.avro");
    private final StringBuilderPool stringBuilderPool = new StringBuilderPool();
    private final SchemaColumn anonymousStringColumn = new SchemaColumn("anonymous", Type.STRING);
    ByteBuffer reusableByteBuffer = null;
    BaseEncoding base64encoder = BaseEncoding.base64();
    private RowFactory rowFactory;
    private Map<String, ColumnInfos> columnMappings;
    private List<SchemaColumn> schemaColumns;
    private Schema writerSchema;
    private ColumnFactory columnFactory;
    private AvroFormatConfig params;
    private static final DateTimeFormatter dateFormatter = Date.CANONICAL_FORMATTER;
    private static final DateTimeFormatter dateOnlyFormatter = ISODateTimeFormat.date().withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter datetimeNoTzFormatter = DatetimeNoTz.CANONICAL_FORMATTER;

    private static void appendEscapedKeyAcceptsNull(boolean first, StringBuilder sb, String key) {
        if (sb != null) {
            if (first) {
                sb.append('\"');
            } else {
                sb.append(",\"");
            }
            JSONUtils.escapeJSONString(key, sb);
            sb.append("\":");
        }
    }

    private static void appendAcceptsNull(StringBuilder sb, char v) {
        if (sb != null) {
            sb.append(v);
        }
    }

    public void initialize(ColumnFactory columnFactory, RowFactory rowFactory, com.dataiku.dip.coremodel.Schema dssSchema, AvroFormatConfig params) {
        this.columnFactory = (ColumnFactory)Preconditions.checkNotNull((Object)columnFactory);
        this.schemaColumns = ((com.dataiku.dip.coremodel.Schema)Preconditions.checkNotNull((Object)dssSchema)).getColumns();
        this.rowFactory = (RowFactory)Preconditions.checkNotNull((Object)rowFactory);
        this.params = params;
        for (SchemaColumn sc : dssSchema.getColumns()) {
            columnFactory.column(sc.getName());
        }
    }

    private void initMapping() {
        if (this.columnMappings == null) {
            this.columnMappings = new HashMap<String, ColumnInfos>();
            for (Schema.Field field : this.writerSchema.getFields()) {
                SchemaColumn matchingSchemaColumn = null;
                for (SchemaColumn sc : this.schemaColumns) {
                    if (!sc.getName().equals(field.name())) continue;
                    matchingSchemaColumn = sc;
                    break;
                }
                if (matchingSchemaColumn == null) continue;
                Column columnHandle = this.columnFactory.column(field.name());
                ColumnInfos infos = new ColumnInfos(columnHandle, matchingSchemaColumn);
                this.columnMappings.put(field.name(), infos);
            }
        }
    }

    public void setSchema(Schema schema) {
        SchemaConverter.convertSchema(schema);
        this.writerSchema = (Schema)Preconditions.checkNotNull((Object)schema);
    }

    public Row read(Row row, Decoder in) throws IOException {
        try {
            this.initMapping();
            return this.readDSSRow(in);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to deserialize a row from Avro", (Throwable)e);
            throw e;
        }
    }

    private Row readDSSRow(Decoder decoder) throws IOException {
        Row row = this.rowFactory.row();
        for (Schema.Field field : this.writerSchema.getFields()) {
            StringBuilderPool.StringBuilderHandle sbh = this.stringBuilderPool.allocate();
            try {
                StringBuilder buffer = sbh.get();
                ColumnInfos infos = this.columnMappings.get(field.name());
                if (infos != null) {
                    this.readField(buffer, decoder, field.schema(), infos.schemaColumn, 0);
                    String cell = buffer.toString();
                    row.put(infos.dssColumnHandle, cell);
                    continue;
                }
                this.readField(null, decoder, field.schema(), null, 0);
            }
            finally {
                if (sbh == null) continue;
                sbh.close();
            }
        }
        return row;
    }

    private boolean readField(StringBuilder sb, Decoder decoder, Schema field, SchemaColumn dssCol, int depth) throws IOException {
        boolean wasNull;
        if (dssCol != null && dssCol.getType() == Type.STRING && field.getType() != Schema.Type.STRING) {
            boolean isRoot;
            String data = null;
            boolean bl = isRoot = depth == 0;
            if (sb != null) {
                try (StringBuilderPool.StringBuilderHandle sbh = this.stringBuilderPool.allocate();){
                    StringBuilder outputBuilder = sbh.get();
                    wasNull = this.readFieldRec(outputBuilder, decoder, field, null, 0);
                    if (!wasNull) {
                        data = outputBuilder.toString();
                    }
                }
                if (data == null) {
                    if (!isRoot) {
                        sb.append("null");
                    }
                } else if (isRoot) {
                    sb.append(data);
                } else {
                    AvroDSSRowReader.appendAsJSONString(sb, data);
                }
            } else {
                wasNull = this.readFieldRec(null, decoder, field, null, depth);
            }
        } else {
            wasNull = this.readFieldRec(sb, decoder, field, dssCol, depth);
        }
        return wasNull;
    }

    private boolean readFieldRec(StringBuilder outputBuilder, Decoder decoder, Schema field, SchemaColumn dssCol, int depth) throws IOException {
        boolean wasNull = false;
        switch (field.getType()) {
            case RECORD: {
                this.readRecord(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case ENUM: {
                this.readEnum(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case ARRAY: {
                this.readArray(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case MAP: {
                this.readMap(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case UNION: {
                int resolvedTypeIndex = decoder.readIndex();
                Schema resolvedType = (Schema)field.getTypes().get(resolvedTypeIndex);
                wasNull = this.readFieldRec(outputBuilder, decoder, resolvedType, dssCol, depth);
                break;
            }
            case FIXED: {
                this.readFixed(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case STRING: {
                this.readString(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case BYTES: {
                this.readBytes(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case INT: {
                this.readInt(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case LONG: {
                this.readLong(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case FLOAT: {
                this.readFloat(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case DOUBLE: {
                this.readDouble(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case BOOLEAN: {
                this.readBoolean(outputBuilder, decoder, field, dssCol, depth);
                break;
            }
            case NULL: {
                this.readNull(outputBuilder, decoder, field, dssCol, depth);
                wasNull = true;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Avro type : " + String.valueOf(field.getType()));
            }
        }
        return wasNull;
    }

    private void readString(StringBuilder sb, Decoder decoder, Schema field, SchemaColumn dssCol, int depth) throws IOException {
        if (sb != null) {
            boolean quoteString;
            String str = decoder.readString();
            boolean bl = quoteString = depth > 0;
            if (dssCol != null) {
                switch (dssCol.getType()) {
                    case DATE: {
                        break;
                    }
                    case STRING: {
                        break;
                    }
                    case SMALLINT: 
                    case BIGINT: 
                    case TINYINT: 
                    case INT: {
                        try {
                            if (StringUtils.isBlank((String)str)) {
                                str = "";
                                break;
                            }
                            Long.parseLong(str);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("Unable to cast Avro string into DSS " + String.valueOf(dssCol.getType()) + " : " + str);
                        }
                    }
                    case DOUBLE: 
                    case FLOAT: {
                        try {
                            if (StringUtils.isBlank((String)str)) {
                                str = "";
                                break;
                            }
                            Double.parseDouble(str);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("Unable to cast Avro string into DSS " + String.valueOf(dssCol.getType()) + " : " + str);
                        }
                    }
                    default: {
                        throw new RuntimeException("Unable to read Avro string as " + String.valueOf(dssCol.getType()));
                    }
                }
            }
            if (quoteString) {
                AvroDSSRowReader.appendAsJSONString(sb, str);
            } else {
                sb.append(str);
            }
        } else {
            decoder.skipString();
        }
    }

    private void readNull(StringBuilder sb, Decoder decoder, Schema field, SchemaColumn columnInfos, int depth) throws IOException {
        decoder.readNull();
        if (depth > 0 && sb != null) {
            sb.append("null");
        }
    }

    private void readBoolean(StringBuilder sb, Decoder decoder, Schema field, SchemaColumn columnInfos, int depth) throws IOException {
        boolean v = decoder.readBoolean();
        if (sb != null) {
            if (columnInfos == null) {
                sb.append(v ? "true" : "false");
            } else {
                switch (columnInfos.getType()) {
                    case STRING: 
                    case BOOLEAN: {
                        sb.append(v ? "true" : "false");
                        break;
                    }
                    case SMALLINT: 
                    case BIGINT: 
                    case TINYINT: 
                    case INT: {
                        sb.append(v ? "1" : "0");
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported conversion from Avro float to DSS " + String.valueOf(columnInfos.getType()));
                    }
                }
            }
        }
    }

    private void readDouble(StringBuilder sb, Decoder decoder, Schema field, SchemaColumn columnInfos, int depth) throws IOException {
        double v = decoder.readDouble();
        if (sb != null) {
            if (columnInfos == null) {
                sb.append(v);
            } else {
                switch (columnInfos.getType()) {
                    case STRING: 
                    case DOUBLE: 
                    case FLOAT: {
                        sb.append(v);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported conversion from Avro float to DSS " + String.valueOf(columnInfos.getType()));
                    }
                }
            }
        }
    }

    private void readFloat(StringBuilder sb, Decoder decoder, Schema field, SchemaColumn columnInfos, int depth) throws IOException {
        float v = decoder.readFloat();
        if (sb != null) {
            if (columnInfos == null) {
                sb.append(v);
            } else {
                switch (columnInfos.getType()) {
                    case STRING: 
                    case DOUBLE: 
                    case FLOAT: {
                        sb.append(v);
                        break;
                    }
                    case SMALLINT: 
                    case BIGINT: 
                    case TINYINT: 
                    case INT: {
                        sb.append((long)v);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported conversion from Avro float to DSS " + String.valueOf(columnInfos.getType()));
                    }
                }
            }
        }
    }

    private void readArray(StringBuilder outputBuilder, Decoder in, Schema field, SchemaColumn dssCol, int depth) throws IOException {
        SchemaColumn valueSchemaColumn;
        Schema arrayContentType = field.getElementType();
        if (dssCol == null) {
            valueSchemaColumn = null;
        } else if (dssCol.getType() == Type.ARRAY) {
            valueSchemaColumn = dssCol.arrayContent;
        } else {
            throw new RuntimeException("Unable to convert Avro array to DSS " + String.valueOf(dssCol.getType()));
        }
        AvroDSSRowReader.appendAcceptsNull(outputBuilder, '[');
        boolean notFirst = false;
        long l = in.readArrayStart();
        while (l != 0L) {
            for (long i = 0L; i < l; ++i) {
                if (notFirst) {
                    AvroDSSRowReader.appendAcceptsNull(outputBuilder, ',');
                } else {
                    notFirst = true;
                }
                this.readField(outputBuilder, in, arrayContentType, valueSchemaColumn, depth + 1);
            }
            l = in.arrayNext();
        }
        AvroDSSRowReader.appendAcceptsNull(outputBuilder, ']');
    }

    private void readMap(StringBuilder outputBuilder, Decoder in, Schema field, SchemaColumn dssCol, int depth) throws IOException {
        SchemaColumn valueSchemaColumn;
        Schema valueType = field.getValueType();
        if (dssCol == null) {
            valueSchemaColumn = null;
        } else if (dssCol.getType() == Type.OBJECT) {
            valueSchemaColumn = null;
        } else if (dssCol.getType() == Type.MAP) {
            valueSchemaColumn = dssCol.mapValues;
            if (dssCol.mapKeys.getType() != Type.STRING) {
                throw new RuntimeException("Non-string map keys are not allowed: " + String.valueOf(dssCol.mapKeys));
            }
        } else {
            throw new RuntimeException("Conversion between Avro map ->" + String.valueOf(dssCol.getType()) + " is not allowed");
        }
        AvroDSSRowReader.appendAcceptsNull(outputBuilder, '{');
        boolean first = true;
        long l = in.readMapStart();
        while (l != 0L) {
            for (long i = 0L; i < l; ++i) {
                String key = in.readString();
                if (dssCol != null && dssCol.getType() == Type.OBJECT) {
                    SchemaColumn currentDssField = null;
                    for (SchemaColumn dssField : dssCol.objectFields) {
                        if (!dssField.getName().equals(key)) continue;
                        currentDssField = dssField;
                        break;
                    }
                    if (currentDssField == null) {
                        this.readField(null, in, valueType, null, depth + 1);
                        continue;
                    }
                    AvroDSSRowReader.appendEscapedKeyAcceptsNull(first, outputBuilder, key);
                    first = false;
                    this.readField(outputBuilder, in, valueType, currentDssField, depth + 1);
                    continue;
                }
                AvroDSSRowReader.appendEscapedKeyAcceptsNull(first, outputBuilder, key);
                first = false;
                this.readField(outputBuilder, in, valueType, valueSchemaColumn, depth + 1);
            }
            l = in.mapNext();
        }
        AvroDSSRowReader.appendAcceptsNull(outputBuilder, '}');
    }

    private void readBytes(StringBuilder sb, Decoder decoder, Schema field, SchemaColumn columnInfos, int depth) throws IOException {
        if (sb == null) {
            decoder.skipBytes();
        } else {
            this.reusableByteBuffer = decoder.readBytes(this.reusableByteBuffer);
            this.reusableByteBuffer.clear();
            byte[] bytes = new byte[this.reusableByteBuffer.remaining()];
            this.reusableByteBuffer.get(bytes);
            sb.append(this.base64encoder.encode(bytes));
        }
    }

    private void readFixed(StringBuilder sb, Decoder decoder, Schema field, SchemaColumn columnInfos, int depth) throws IOException {
        if (sb == null) {
            decoder.skipFixed(field.getFixedSize());
        } else {
            byte[] buffer = new byte[field.getFixedSize()];
            decoder.readFixed(buffer);
            sb.append(this.base64encoder.encode(buffer));
        }
    }

    private void readLong(StringBuilder sb, Decoder decoder, Schema field, SchemaColumn dssCol, int depth) throws IOException {
        long val = decoder.readLong();
        if (sb != null) {
            if (dssCol != null && dssCol.getType().isNumeric()) {
                sb.append(val);
            } else if (field.getLogicalType() != null && "timestamp-millis".equalsIgnoreCase(field.getLogicalType().getName())) {
                String s = dateFormatter.print(val) + "Z";
                if (depth > 0) {
                    AvroDSSRowReader.appendAsJSONString(sb, s);
                } else {
                    sb.append(s);
                }
            } else if (field.getLogicalType() != null && "local-timestamp-millis".equalsIgnoreCase(field.getLogicalType().getName())) {
                String s = datetimeNoTzFormatter.print(val);
                if (depth > 0) {
                    AvroDSSRowReader.appendAsJSONString(sb, s);
                } else {
                    sb.append(s);
                }
            } else {
                sb.append(val);
            }
        }
    }

    private void readInt(StringBuilder sb, Decoder decoder, Schema field, SchemaColumn dssCol, int depth) throws IOException {
        int val = decoder.readInt();
        if (sb != null) {
            if (dssCol != null && dssCol.getType().isNumeric()) {
                sb.append(val);
            } else if (field.getLogicalType() != null && "date".equalsIgnoreCase(field.getLogicalType().getName())) {
                LocalDate date = LocalDate.ofEpochDay(val);
                String s = dateOnlyFormatter.print((ReadableInstant)new DateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0, DateTimeZone.UTC));
                if (depth > 0) {
                    AvroDSSRowReader.appendAsJSONString(sb, s);
                } else {
                    sb.append(s);
                }
            } else {
                sb.append(val);
            }
        }
    }

    private static void appendAsJSONString(StringBuilder sb, String s) {
        sb.append('\"');
        JSONUtils.escapeJSONString(s, sb);
        sb.append('\"');
    }

    private void readEnum(StringBuilder sb, Decoder decoder, Schema field, SchemaColumn dssCol, int depth) throws IOException {
        int enumIdx = decoder.readEnum();
        if (sb != null) {
            boolean quote = depth > 0;
            String val = (String)field.getEnumSymbols().get(enumIdx);
            if (dssCol != null) {
                switch (dssCol.getType()) {
                    case STRING: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unable to cast Avro enum to DSS " + String.valueOf(dssCol.getType()));
                    }
                }
            }
            if (quote) {
                AvroDSSRowReader.appendAsJSONString(sb, val);
            } else {
                sb.append(val);
            }
        }
    }

    private void readRecord(StringBuilder sb, Decoder in, Schema field, SchemaColumn dssCol, int depth) throws IOException {
        if (dssCol != null && dssCol.getType() == Type.OBJECT) {
            AvroDSSRowReader.appendAcceptsNull(sb, '{');
            boolean first = true;
            for (Schema.Field f : field.getFields()) {
                boolean found = false;
                for (SchemaColumn dssField : dssCol.objectFields) {
                    if (!dssField.getName().equals(f.name())) continue;
                    if (this.params.representsNullFields) {
                        AvroDSSRowReader.appendEscapedKeyAcceptsNull(first, sb, f.name());
                        this.readField(sb, in, f.schema(), dssField, depth + 1);
                        first = false;
                    } else {
                        try (StringBuilderPool.StringBuilderHandle sbh = this.stringBuilderPool.allocate();){
                            StringBuilder tmpBuffer = sbh.get();
                            boolean wasNull = this.readField(tmpBuffer, in, f.schema(), dssField, depth + 1);
                            if (!wasNull && sb != null) {
                                AvroDSSRowReader.appendEscapedKeyAcceptsNull(first, sb, f.name());
                                sb.append((CharSequence)tmpBuffer);
                                first = false;
                            }
                        }
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                this.readField(null, in, f.schema(), this.anonymousStringColumn, depth + 1);
            }
            AvroDSSRowReader.appendAcceptsNull(sb, '}');
        } else if (dssCol == null || dssCol.getType() == Type.MAP) {
            boolean first = true;
            SchemaColumn valueSchemaColumn = null;
            if (dssCol != null && dssCol.getType() == Type.MAP) {
                if (dssCol.getType() == Type.MAP) {
                    valueSchemaColumn = dssCol.mapValues;
                }
                if (dssCol.mapKeys.getType() != Type.STRING) {
                    throw new RuntimeException("Map keys must be string in an Avro file, not " + String.valueOf(dssCol.mapKeys.getType()));
                }
            }
            AvroDSSRowReader.appendAcceptsNull(sb, '{');
            for (Schema.Field f : field.getFields()) {
                String keyName = f.name();
                if (this.params.representsNullFields || sb == null) {
                    AvroDSSRowReader.appendEscapedKeyAcceptsNull(first, sb, keyName);
                    this.readField(sb, in, f.schema(), valueSchemaColumn, depth + 1);
                    first = false;
                    continue;
                }
                StringBuilderPool.StringBuilderHandle sbh = this.stringBuilderPool.allocate();
                try {
                    StringBuilder tmpBuffer = sbh.get();
                    boolean wasNull = this.readField(tmpBuffer, in, f.schema(), valueSchemaColumn, depth + 1);
                    if (wasNull) continue;
                    AvroDSSRowReader.appendEscapedKeyAcceptsNull(first, sb, keyName);
                    sb.append((CharSequence)tmpBuffer);
                    first = false;
                }
                finally {
                    if (sbh == null) continue;
                    sbh.close();
                }
            }
            AvroDSSRowReader.appendAcceptsNull(sb, '}');
        } else {
            throw new RuntimeException("Unable to cast an Avro record to DSS type: " + String.valueOf(dssCol.getType()));
        }
    }

    private static class ColumnInfos {
        final Column dssColumnHandle;
        final SchemaColumn schemaColumn;

        private ColumnInfos(Column dssColumnHandle, SchemaColumn schemaColumn) {
            this.dssColumnHandle = dssColumnHandle;
            this.schemaColumn = schemaColumn;
        }
    }
}

