/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.hive.HiveCodes;
import com.dataiku.dip.hive.HiveLogParser;
import com.dataiku.dip.hive.HiveProgressListener;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.InheritableNDC;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.hproxy.utils.HiveEMRUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class HiveExecutor {
    public static final String HIVE_BIN_PARAM = "hadoop.hive.hiveBinary";
    public static final String HIVE_CONF_PARAM = "hadoop.hive.hiveConfigFolder";
    private static Logger logger = Logger.getLogger((String)"dku.flow.hive");

    protected static void buildHiveArgs(List<String> cmd, Params appParams) {
        if (appParams.hasParam(HIVE_BIN_PARAM)) {
            cmd.add(appParams.getNonEmptyMandParam(HIVE_BIN_PARAM));
        } else {
            cmd.add("hive");
        }
        if (appParams.hasParam(HIVE_CONF_PARAM)) {
            cmd.add("--config");
            cmd.add(appParams.getNonEmptyMandParam(HIVE_CONF_PARAM));
        }
        for (String s : appParams.getAll().keySet()) {
            if (!s.startsWith("mapred.") && !s.startsWith("hive.")) continue;
            cmd.add("--hiveconf");
            cmd.add(s + "=" + appParams.getParam(s));
        }
    }

    protected static Map<String, String> buildHiveEnv(Map<String, String> extraEnv) {
        HashMap ret = Maps.newHashMap(extraEnv);
        ret.putAll(DKUtils.getEnvironment());
        if (HadoopLoader.isKerberosLoginEnabled()) {
            HadoopLoader.addTicketCacheEnvVar(ret);
        }
        return ret;
    }

    public static DKUtils.ExecKiller runInTempEnv(String initScriptData, String scriptData, File tmpFolder, String tmpFileName, HiveProgressListener listener, List<SimpleKeyValue> extraConf, boolean useGlobalMetastore, Map<String, String> extraEnv) throws Exception {
        Params appParams = ApplicationConfigurator.getParams();
        ArrayList<String> cmd = new ArrayList<String>();
        File tmpInit = DKUFileUtils.getWithin((File)tmpFolder, (String[])new String[]{tmpFileName + ".init.sql"});
        FileUtils.write((File)tmpInit, (CharSequence)initScriptData);
        File tmpData = DKUFileUtils.getWithin((File)tmpFolder, (String[])new String[]{tmpFileName + ".exec.sql"});
        FileUtils.write((File)tmpData, (CharSequence)scriptData);
        final AutoDelete derbyTempFolder = new AutoDelete(Files.createTempDirectory(tmpFolder.toPath(), "metastore", new FileAttribute[0]).toFile());
        File metastoreFolder = DKUFileUtils.getWithin((File)derbyTempFolder, (String[])new String[]{"db_" + tmpFileName});
        logger.info((Object)("Dumping init script in " + String.valueOf(tmpInit)));
        logger.info((Object)("Dumping Hive script in " + String.valueOf(tmpData)));
        HiveExecutor.buildHiveArgs(cmd, appParams);
        if (useGlobalMetastore) {
            cmd.add("--hiveconf");
            cmd.add("hive.stats.autogather=true");
        } else {
            cmd.add("--hiveconf");
            cmd.add("hive.stats.autogather=false");
            cmd.add("--hiveconf");
            cmd.add("hive.metastore.uris=");
            for (String c2 : HiveEMRUtils.metastoreClientFactoryClassVariants()) {
                cmd.add("--hiveconf");
                cmd.add((String)c2 + "=org.apache.hadoop.hive.ql.metadata.SessionHiveMetaStoreClientFactory");
            }
            cmd.add("--hiveconf");
            cmd.add("javax.jdo.option.ConnectionDriverName=org.apache.derby.jdbc.EmbeddedDriver");
            cmd.add("--hiveconf");
            cmd.add("javax.jdo.option.ConnectionURL=jdbc:derby:" + metastoreFolder.getCanonicalPath() + ";create=true");
            cmd.add("--hiveconf");
            cmd.add("javax.jdo.option.ConnectionUserName=");
            cmd.add("--hiveconf");
            cmd.add("javax.jdo.option.ConnectionPassword=");
            cmd.add("--hiveconf");
            cmd.add("datanucleus.autoCreateSchema=true");
            cmd.add("--hiveconf");
            cmd.add("datanucleus.fixedDataStore=false");
            cmd.add("--hiveconf");
            cmd.add("datanucleus.schema.autoCreateAll=true");
            cmd.add("--hiveconf");
            cmd.add("hive.metastore.schema.verification=false");
            cmd.add("--hiveconf");
            cmd.add("hive.support.concurrency=false");
            cmd.add("--hiveconf");
            cmd.add("hive.txn.manager=org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager");
            cmd.add("--hiveconf");
            cmd.add("hive.metastore.pre.event.listeners=");
        }
        cmd.add("--hiveconf");
        cmd.add("fs.hdfs.impl.disable.cache=false");
        for (SimpleKeyValue extra : extraConf) {
            cmd.add("--hiveconf");
            String valueStr = extra.value != null ? extra.value : "";
            cmd.add(extra.key + "=" + valueStr);
        }
        cmd.add("-i");
        cmd.add(tmpInit.getAbsolutePath());
        cmd.add("-f");
        cmd.add(tmpData.getAbsolutePath());
        logger.info((Object)("Executing Hive command: " + StringUtils.join(cmd, (String)" ")));
        logger.info((Object)("with extra env: " + JSON.log(extraEnv)));
        logger.info((Object)("with extra conf: " + JSON.log(extraConf)));
        InheritableNDC.pushAll((Stack)NDC.cloneStack());
        final HiveLogParser hiveLogParser = new HiveLogParser(listener);
        DKUtils.ExecBuilder execBuilder = new DKUtils.ExecBuilder().withArgs(cmd).withEnv(HiveExecutor.buildHiveEnv(extraEnv)).withCwd(tmpFolder).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)hiveLogParser).withCompletionHandler(new DKUtils.ExecCompletionHandler(){

            public void init(DKUtils.ExecBuilder builder) {
            }

            public void handle(int rv) throws IOException {
                if (rv != 0) {
                    String decimalError = hiveLogParser.getLastDecimalError();
                    if (StringUtils.isNotBlank((String)decimalError)) {
                        throw new IOException("Failed to execute Hive script because of DECIMAL(,) type conversions, consider using Hive CLI (global) or Hiveserver2 modes");
                    }
                    HiveCodes lastExplainableError = hiveLogParser.getLastExplainableError();
                    if (lastExplainableError != null) {
                        throw new CodedRuntimeException((InfoMessage.MessageCode)lastExplainableError, "Failed to execute Hive script");
                    }
                    throw new IOException("Failed to execute Hive script, please check job logs (return code " + rv + ")");
                }
            }
        }).withCleanuper(new DKUtils.ExecCleanuper(){

            public void cleanup() {
                derbyTempFolder.close();
            }
        });
        DKUtils.ExecKiller killer = execBuilder.makeNiceThenEvilKiller();
        execBuilder.exec();
        return killer;
    }

    private HiveExecutor() {
    }
}

