/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.managedfolder;

import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;

public interface ManagedFolderSelectedFiles {
    public String describeForLogging();

    public FSEnumerationResult listFiles(FSProvider var1) throws CodedException, IOException, DKUSecurityException;

    public static ManagedFolderSelectedFiles wholeFolder(final String path) {
        return new ManagedFolderSelectedFiles(){

            @Override
            public String describeForLogging() {
                return "all files";
            }

            @Override
            public FSEnumerationResult listFiles(FSProvider fsProvider) throws CodedException, IOException, DKUSecurityException {
                return fsProvider.enumerateRecursive(path, new FSEnumerationSettings());
            }
        };
    }

    public static ManagedFolderSelectedFiles childFilesAndSubFolders(final List<String> paths) {
        return new ManagedFolderSelectedFiles(){

            @Override
            public String describeForLogging() {
                return paths.size() + " files and/or folders";
            }

            @Override
            public FSEnumerationResult listFiles(FSProvider fsProvider) throws CodedException, IOException, DKUSecurityException {
                Stream.Builder<FSPathOrDirectory> fsPaths = Stream.builder();
                for (String path : paths) {
                    try {
                        FSPathOrDirectory stat = fsProvider.stat(path);
                        if (stat == null) {
                            throw new FileNotFoundException("File does not exist with path: " + path);
                        }
                        if (stat.isDirectory) {
                            FSEnumerationResult enumerationResult = fsProvider.enumerateRecursive(path, new FSEnumerationSettings());
                            if (!enumerationResult.isSuccessful()) {
                                return enumerationResult;
                            }
                            enumerationResult.getPaths().forEach(fsPaths::add);
                            continue;
                        }
                        fsPaths.add(stat);
                    }
                    catch (CodedException | DKUSecurityException | IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        return new AbstractFSEnumerationResult(e);
                    }
                }
                return new AbstractFSEnumerationResult(fsPaths.build().toList());
            }
        };
    }
}

