/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class HiveMetricsEngine
extends JdbcEngine
implements MetricsQueryBuilder.MetricsQueryBuilderEngine {
    @Autowired
    private HiveServer2ConnectionPoolService hiveServer2ConnectionPoolService;
    private final JdbcEngine.HiveMetricsEngineConfig config;
    private final String filter;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.hive.metrics");

    public HiveMetricsEngine(MetricsEngineRun engineRun, Dataset dataset, Partition partition, JdbcEngine.HiveMetricsEngineConfig config) {
        super(dataset, partition);
        this.config = config;
        this.filter = ((HiveMetricsEngineRun)engineRun).filter;
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, DKUSecurityException {
        String database = HiveSchemaHandler.getResolvedHiveDatabaseFromDataset(this.dataset);
        logger.info((Object)("Hive metrics engine on database : " + database));
        List<SimpleKeyValue> hiveconf = new HiveConfHelper().getResolvedHiveRuntimeConf(authCtx, this.dataset.getProjectKey(), this.config.extraConf);
        HiveConnection datasetConnection = HiveConfigurator.configureConnectionForDatabase(authCtx, database == null ? "" : database, hiveconf, this.hiveServer2ConnectionPoolService);
        this.connectionData = datasetConnection.getConnectionData_NT(authCtx, this.dataset.getProjectKey());
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        MetricsQueryBuilder builder = new MetricsQueryBuilder();
        return builder.buildQuery(authCtx, this, computations, alreadyComputed, this.filter);
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult rs2, List<MetricComputation> computations) throws Exception {
        HashMap metricsValues = Maps.newHashMap();
        for (int i = 0; i < computations.size(); ++i) {
            MetricComputation computation = computations.get(i);
            MetricsQueryBuilder.MetricsQueryBuilderAggregation computer = (MetricsQueryBuilder.MetricsQueryBuilderAggregation)((Object)computation.computer);
            metricsValues.put(computation.metric, computer.getAggregate(rs2, computation));
        }
        return metricsValues;
    }

    public static class HiveMetricsEngineRun
    extends MetricsEngineRun {
        public String filter;
        private boolean neverMergeable = false;

        public HiveMetricsEngineRun() {
            super(MetricsEngineDesc.HiveMetricsEngine);
        }

        public HiveMetricsEngineRun(double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.HiveMetricsEngine, cost, computations, pass);
        }

        public HiveMetricsEngineRun withFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public HiveMetricsEngineRun neverMergeable() {
            this.neverMergeable = true;
            return this;
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new HiveMetricsEngineRun(cost, computations, this.pass).withFilter(this.filter);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            int maxComputationCount = DKUApp.getParams().getIntParam("dku.metricsEngine.hive.maxMetricsPerRun", Integer.valueOf(500));
            return super.canMergeWith(other) && !this.neverMergeable && other instanceof HiveMetricsEngineRun && StringUtils.equals((String)this.filter, (String)((HiveMetricsEngineRun)other).filter) && !((HiveMetricsEngineRun)other).neverMergeable && this.countAfterMergeStaysBelow(other, maxComputationCount);
        }
    }
}

