/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.notifications;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.notifications.NotificationsRouter;
import com.dataiku.dip.plugins.PluginStoreService;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.controllers.WebSocketController;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.AdminMessageBannerChangedEvent;
import com.dataiku.dip.server.notifications.backend.PluginChangedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.server.notifications.backend.UsersEvent;
import com.dataiku.dip.server.notifications.frontend.JobStatusUpdatedLightEvent;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TrackingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FrontendMessengerNotificationsRouter
implements NotificationsRouter {
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private EnrichmentService enrichmentService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TrackingService trackingService;
    @Autowired
    private RequestsService requestsService;
    @Autowired
    private PluginStoreService pluginsStoreService;
    private GeneralSettingsDAO.NotificationsSettings.GlobalDispatchPolicy logInAndOutDispatchPolicy;
    private GeneralSettingsDAO.NotificationsSettings.ProjectDispatchPolicy taskStartAndStopDispatchPolicy;
    private Map<String, UserSettingsService.UserSettings> userSettings;
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.frontend");

    private void readGeneralSettings() {
        try (Transaction t = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsDAO.read();
            this.logInAndOutDispatchPolicy = settings.notifications.notifyOnUserConnection;
            this.taskStartAndStopDispatchPolicy = settings.notifications.notifyOnTaskStartAndStop;
        }
        catch (IOException e1) {
            logger.error((Object)"Failed to read settings", (Throwable)e1);
        }
    }

    private void readUserSettings() {
        try (Transaction t = this.transactionService.beginRead();){
            this.userSettings = this.userSettingsService.getForAllUsers();
        }
        catch (IOException e1) {
            logger.error((Object)"Failed to read user settings", (Throwable)e1);
            this.userSettings = new HashMap<String, UserSettingsService.UserSettings>();
        }
    }

    private UserSettingsService.FrontendNotificationsSettings getUserFrontendNotificationSettings(PublicUser user) {
        return Optional.ofNullable(this.userSettings.get(user.login)).map(settings -> settings.frontendNotifications).orElseGet(UserSettingsService.FrontendNotificationsSettings::new);
    }

    @Override
    public void init() {
        WebSocketController wsController = WebSocketController.getInstance();
        this.readGeneralSettings();
        this.pubSub.subscribe("general-settings-changed", evt -> this.readGeneralSettings());
        this.readUserSettings();
        this.pubSub.subscribe("user-settings-changed", evt -> this.readUserSettings());
        DSSEventListener logInAndOutListener = evt -> {
            if (this.logInAndOutDispatchPolicy != GeneralSettingsDAO.NotificationsSettings.GlobalDispatchPolicy.ALL) {
                return;
            }
            Set<String> notifiedUsers = this.userSettings.entrySet().stream().filter(entry -> ((UserSettingsService.UserSettings)entry.getValue()).frontendNotifications.loginLogout).map(Map.Entry::getKey).collect(Collectors.toSet());
            notifiedUsers.remove(evt.getUserLogin());
            try {
                wsController.broadcastToUsers(evt, notifiedUsers);
            }
            catch (Exception e) {
                logger.info((Object)"Failed to broadcast login event", (Throwable)e);
            }
        };
        this.pubSub.subscribe("login", logInAndOutListener);
        this.pubSub.subscribe("logout", logInAndOutListener);
        this.pubSub.subscribe("interest-added", evt -> {
            if (!evt.star) {
                return;
            }
            Set<PublicUser> users = this.trackingService.getUsersOnProject(evt.projectKey);
            HashSet<String> filteredUsers = new HashSet<String>();
            for (PublicUser user : users) {
                if (user.login.equals(evt.getUserLogin()) || !this.getUserFrontendNotificationSettings((PublicUser)user).watchStar) continue;
                filteredUsers.add(user.login);
            }
            wsController.broadcastToUsersOnProject(evt, evt.projectKey, filteredUsers);
        });
        DSSEventListener toUser = evt -> {
            logger.info((Object)("dispatch " + evt.getName()));
            wsController.broadcastToUser(evt, evt.getUserLogin());
        };
        this.pubSub.subscribe("export-state-change", toUser);
        this.pubSub.subscribe("discussions-unread-full-ids-changed", toUser);
        this.pubSub.subscribe("mltask-state-change", evt -> {
            if (!evt.isRunning) {
                this.handleTaskEvent((ProjectEvent)evt, wsController);
            }
        });
        this.pubSub.subscribe("job-state-change", evt -> {
            switch (evt.state) {
                case NOT_STARTED: 
                case WAITING_CONFIRMATION: 
                case PAUSED: {
                    return;
                }
            }
            if (StringUtils.isNotBlank((String)evt.initiator)) {
                try (Transaction t = this.transactionService.beginRead();){
                    PublicUser user = this.usersService.getPublicUser(evt.initiator);
                    if (user != null) {
                        evt.initiatorDisplayName = user.displayName;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to enrich job-state-changed event with initiator's displayName. " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
            this.handleTaskEvent((ProjectEvent)evt, wsController);
        });
        this.pubSub.subscribe("job-status-updated", evt -> this.handleTaskEvent(JobStatusUpdatedLightEvent.fromJobStatusUpdatedEvent(evt), wsController));
        this.pubSub.subscribe("job-activity-started", evt -> this.handleTaskEvent((ProjectEvent)evt, wsController));
        this.pubSub.subscribe("job-activity-done", evt -> this.handleTaskEvent((ProjectEvent)evt, wsController));
        this.pubSub.subscribe("continuous-activity-state-change", evt -> {
            if (StringUtils.isNotBlank((String)evt.initiator)) {
                try (Transaction t = this.transactionService.beginRead();){
                    PublicUser user = this.usersService.getPublicUser(evt.initiator);
                    if (user != null) {
                        evt.initiatorDisplayName = user.displayName;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to enrich job-state-changed event with initiator's displayName. " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
            this.handleTaskEvent((ProjectEvent)evt, wsController);
        });
        this.pubSub.subscribe("scenario-state-change", evt -> {
            switch (evt.state) {
                case NOT_STARTED: {
                    return;
                }
            }
            this.handleTaskEvent((ProjectEvent)evt, wsController);
        });
        this.pubSub.subscribe("scenario-run-failed-check-logs", evt -> this.handleTaskEvent((ProjectEvent)evt, wsController));
        DSSEventListener timelineEventListener = evt -> {
            if (evt.item.action == TaggableObjectChangedEvent.ActionType.EDIT_COLLABORATIVE_METADATA && JsonUtils.getArrayDefault(evt.item.details, "doneTasks").getAsJsonArray().isEmpty()) {
                return;
            }
            String initiator = evt.getUserLogin();
            HashSet<String> users = new HashSet<String>();
            Set<String> watchingUsers = this.interestsService.getEffectiveWatchingUsers_NT(evt.item.objectType, evt.item.projectKey, evt.item.objectId, evt.item.user, evt.item.workspaceKey);
            for (PublicUser user : this.trackingService.getUsersOnProject(evt.getProjectKey())) {
                if (user.login.equals(initiator)) continue;
                UserSettingsService.FrontendNotificationsSettings fnSettings = this.getUserFrontendNotificationSettings(user);
                if (evt.item.action != TaggableObjectChangedEvent.ActionType.EDIT_COLLABORATIVE_METADATA && (!fnSettings.watchedObjectsEditions || !watchingUsers.contains(user.login)) && (!fnSettings.objectOnProjectCreatedDeleted || !evt.item.action.isCreation() && !evt.item.action.isDeletion()) && !fnSettings.anyObjectOnProjectEdited) continue;
                users.add(user.login);
            }
            if (users.isEmpty()) {
                return;
            }
            try (Transaction t = this.transactionService.beginRead();){
                this.enrichmentService.enrich(evt.item);
            }
            catch (Exception e) {
                logger.info((Object)"Error when preprocessing timeline event", (Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending frontend timeline event " + JSON.log((Object)evt) + " to " + JSON.log(users)));
            }
            wsController.broadcastToUsers(evt, users);
        };
        this.pubSub.subscribe("timeline-item", timelineEventListener);
        this.pubSub.subscribe("discussion-mention", evt -> {
            try (Transaction t = this.transactionService.beginRead();){
                this.enrichmentService.enrich((EnrichmentService.Enrichable)evt);
            }
            wsController.broadcastToUser(evt, evt.getUserLogin());
        });
        this.pubSub.subscribe("commit-mention", evt -> wsController.broadcastToUser(evt, evt.getUserLogin()));
        this.pubSub.subscribe("discussion-ack", evt -> {
            logger.info((Object)("Send discussion ack to front {projectKey: " + evt.projectKey + ", discussion: " + evt.discussionId + "}"));
            try (Transaction t = this.transactionService.beginRead();){
                this.enrichmentService.enrich((EnrichmentService.Enrichable)evt);
            }
            wsController.broadcastToProjectOrWorkspaceUsers(evt, evt.getProjectKey(), evt.getWorkspaceKey());
        });
        this.pubSub.subscribe("discussion-reply", evt -> {
            try (Transaction t = this.transactionService.beginRead();){
                this.enrichmentService.enrich((EnrichmentService.Enrichable)evt);
                evt.mentionedUsers = this.usersService.getMentions(evt.text);
            }
            wsController.broadcastToProjectOrWorkspaceUsers(evt, evt.getProjectKey(), evt.getWorkspaceKey());
        });
        this.pubSub.subscribe("discussion-update", evt -> {
            logger.info((Object)("Send discussion update to front {projectKey: " + evt.projectKey + ", discussion: " + evt.discussionId + "}"));
            try (Transaction t = this.transactionService.beginRead();){
                this.enrichmentService.enrich((EnrichmentService.Enrichable)evt);
            }
            wsController.broadcastToProjectOrWorkspaceUsers(evt, evt.getProjectKey(), evt.getWorkspaceKey());
        });
        this.pubSub.subscribe("discussion-delete", evt -> {
            logger.info((Object)("Send discussion deleted to front {projectKey: " + evt.projectKey + ", discussion: " + evt.discussionId + "}"));
            try (Transaction t = this.transactionService.beginRead();){
                this.enrichmentService.enrich((EnrichmentService.Enrichable)evt);
            }
            wsController.broadcastToProjectOrWorkspaceUsers(evt, evt.getProjectKey(), evt.getWorkspaceKey());
        });
        this.pubSub.subscribe("discussion-close", evt -> {
            logger.info((Object)("Send discussion closed to front {projectKey: " + evt.projectKey + ", discussion: " + evt.discussionId + "}"));
            try (Transaction t = this.transactionService.beginRead();){
                this.enrichmentService.enrich((EnrichmentService.Enrichable)evt);
            }
            wsController.broadcastToProjectOrWorkspaceUsers(evt, evt.getProjectKey(), evt.getWorkspaceKey());
        });
        this.pubSub.subscribe("access-request", evt -> {
            logger.info((Object)("Send access request to {projectKey: " + evt.getProjectKey() + "}"));
            try (Transaction ignored = this.transactionService.beginRead();){
                this.enrichmentService.enrich((EnrichmentService.Enrichable)evt);
            }
            List<String> targetUsers = this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), evt.getRequest().objectProjectKey, true);
            wsController.broadcastToUsers(evt, targetUsers);
        });
        this.pubSub.subscribe("instance-access-request", evt -> {
            PublicUser pu = this.usersService.getPublicUser(evt.getUserLogin());
            if (pu != null) {
                evt.getDetails().addProperty("userDisplayName", pu.displayName);
            }
            List<String> targetUsers = this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), null);
            wsController.broadcastToUsers(evt, targetUsers);
        });
        this.pubSub.subscribe("profile-upgrade-request", evt -> {
            PublicUser pu = this.usersService.getPublicUser(evt.getUserLogin());
            if (pu != null) {
                evt.getDetails().addProperty("userDisplayName", pu.displayName);
            }
            List<String> targetUsers = this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), null);
            wsController.broadcastToUsers(evt, targetUsers);
        });
        this.pubSub.subscribe("plugin-request", evt -> {
            logger.info((Object)("Send plugin request for {plugin: " + evt.getObjectId() + "}"));
            PublicUser pu = this.usersService.getPublicUser(evt.getUserLogin());
            if (pu != null) {
                evt.getDetails().addProperty("userDisplayName", pu.displayName);
            }
            this.pluginsStoreService.getStorePluginDesc(evt.getObjectId()).ifPresent(storePlugin -> evt.getDetails().addProperty("objectDisplayName", storePlugin.meta.label));
            List<String> targetUsers = this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), null);
            wsController.broadcastToUsers(evt, targetUsers);
        });
        this.pubSub.subscribe("code-env-request", evt -> {
            logger.info((Object)("Send code env request for {code env: " + evt.getObjectId() + "}"));
            PublicUser pu = this.usersService.getPublicUser(evt.getUserLogin());
            if (pu != null) {
                evt.getDetails().addProperty("userDisplayName", pu.displayName);
            }
            wsController.broadcastToUsers(evt, this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), null));
        });
        this.pubSub.subscribe("plugin-request-granted", evt -> {
            UsersService.UIUser user;
            logger.info((Object)("Send plugin granted for {plugin: " + evt.getObjectId() + "}"));
            PublicUser pu = this.usersService.getPublicUser(evt.getUserLogin());
            if (pu != null) {
                evt.getDetails().addProperty("userDisplayName", pu.displayName);
            }
            this.pluginsStoreService.getStorePluginDesc(evt.getObjectId()).ifPresent(storePlugin -> evt.getDetails().addProperty("objectDisplayName", storePlugin.meta.label));
            try (Transaction tx = this.transactionService.beginRead();){
                user = this.usersService.getUserOrNull_NoLeak(evt.getUserLogin());
            }
            if (user != null && user.enabled.booleanValue()) {
                wsController.broadcastToUser(evt, evt.getUserLogin());
            }
        });
        this.pubSub.subscribe("code-env-request-granted", evt -> {
            logger.info((Object)("Send code env granted for {code env: " + evt.getObjectId() + "}"));
            PublicUser pu = this.usersService.getPublicUser(evt.getUserLogin());
            if (pu != null) {
                evt.getDetails().addProperty("userDisplayName", pu.displayName);
                evt.getDetails().addProperty("objectDisplayName", evt.getTargetName());
            }
            wsController.broadcastToUser(evt, evt.getUserLogin());
        });
        this.pubSub.subscribe("profile-upgrade-approved", evt -> {
            PublicUser pu = this.usersService.getPublicUser(evt.getUserLogin());
            if (pu != null) {
                evt.getDetails().addProperty("userDisplayName", pu.displayName);
            }
            wsController.broadcastToUser(evt, evt.getUserLogin());
        });
        this.pubSub.subscribe("access-granted", evt -> {
            logger.info((Object)("Send access granted to {projectKey: " + evt.getProjectKey() + "}"));
            try (Transaction ignored = this.transactionService.beginRead();){
                this.enrichmentService.enrich((EnrichmentService.Enrichable)evt);
            }
            wsController.broadcastToUser(evt, evt.getUserLogin());
        });
        this.pubSub.subscribe("update-pending-requests", evt -> wsController.broadcastToUser(evt, evt.getUserLogin()));
        this.pubSub.subscribe("plugin-changed", evt -> {
            if (evt.action == PluginChangedEvent.ActionType.INSTALLED) {
                try {
                    wsController.broadcastToAllButUsers(evt, Collections.emptySet());
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to broadcast plugin change event", (Throwable)e);
                }
            }
        });
        this.pubSub.subscribe("general-settings-changed", evt -> {
            if (!JSON.jsonEquals((Object)evt.previousSettings.personalHomePages.alertBanner, (Object)evt.newSettings.personalHomePages.alertBanner)) {
                logger.info((Object)"Alert Banner setting changed, sending message to connected frontends");
                AdminMessageBannerChangedEvent adminMessageBannerChangedEvent = new AdminMessageBannerChangedEvent(evt.newSettings.personalHomePages.alertBanner);
                try {
                    wsController.broadcastToAllButUsers((DSSEvent)adminMessageBannerChangedEvent, Collections.emptySet());
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to broadcast Alert banner setting change event", (Throwable)e);
                }
            }
        });
    }

    private void handleTaskEvent(ProjectEvent evt, WebSocketController wsController) {
        try {
            GeneralSettingsDAO.NotificationsSettings.ProjectDispatchPolicy policy = this.taskStartAndStopDispatchPolicy;
            switch (policy) {
                case ALL_WITH_ACCESS_TO_PROJECT: {
                    wsController.broadcastToProjectUsers(evt, evt.getProjectKey());
                    break;
                }
                case ALL_BROWSING_PROJECT: {
                    wsController.broadcastToAllOnProject(evt, evt.getProjectKey());
                    break;
                }
                case INITIATOR: {
                    if (evt instanceof UsersEvent) {
                        for (String userLogin : ((UsersEvent)((Object)evt)).getUsersLogin()) {
                            wsController.broadcastToUser(evt, userLogin);
                        }
                        break;
                    }
                    wsController.broadcastToUser(evt, ((UserEvent)((Object)evt)).getUserLogin());
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to broadcast event", (Throwable)e);
        }
    }
}

