/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.notifications;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.notifications.NotificationsRouter;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.ProjectCreatedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeletedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.backend.UserChangedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceObjectChangedEvent;
import com.dataiku.dip.server.notifications.backend.WorkspaceTimelineItemEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelineItem;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelinesInternalDB;
import com.dataiku.dip.timelines.workspace.WorkspaceTimelinesService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimelineNotificationsRouter
implements NotificationsRouter {
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TimelinesInternalDB timelinesDB;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private EnrichmentService enrichmentService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private WorkspaceTimelinesInternalDB workspaceTimelinesDB;
    @Autowired
    private WorkspaceTimelinesService workspaceTimelinesService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private WorkspacesService workspacesService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.notifications.timeline");

    @Override
    @PostConstruct
    public void init() {
        logger.debug((Object)"Init timelines router");
        this.pubSub.subscribe("object-change", (DSSEventListener)new DSSEventListener<TaggableObjectChangedEvent>(){

            public void on(TaggableObjectChangedEvent evt) {
                logger.debug((Object)("TimelinesService notified of object changed (" + String.valueOf((Object)evt.action) + "): " + evt.projectKey + "." + evt.objectId + "." + evt.workspaceKey + " (" + String.valueOf((Object)evt.objectType) + ")"));
                if (evt.action == TaggableObjectChangedEvent.ActionType.PROJECT_DELETE) {
                    return;
                }
                try {
                    TimelineItem ti;
                    if (evt.action == TaggableObjectChangedEvent.ActionType.DATASET_RENAME || evt.action == TaggableObjectChangedEvent.ActionType.RECIPE_RENAME) {
                        logger.info((Object)("Rename " + String.valueOf((Object)evt.objectType) + ": " + evt.objectId + " -> " + evt.newObjectId));
                        TimelineNotificationsRouter.this.timelinesDB.deleteObject(evt.objectType, evt.projectKey, evt.newObjectId);
                        TimelineNotificationsRouter.this.timelinesDB.changeObjectId(evt.projectKey, evt.objectType, evt.objectId, evt.newObjectId);
                        ti = new TimelineItem(evt.user, evt.action, evt.projectKey, evt.objectType, evt.newObjectId, evt.workspaceKey).withDetails(evt.details);
                    } else if (evt.action == TaggableObjectChangedEvent.ActionType.DATASET_DELETE || evt.action == TaggableObjectChangedEvent.ActionType.RECIPE_DELETE) {
                        TimelineNotificationsRouter.this.timelinesDB.changeObjectId(evt.projectKey, evt.objectType, evt.objectId, evt.objectId + " (deleted)");
                        ti = new TimelineItem(evt.user, evt.action, evt.projectKey, evt.objectType, evt.objectId + " (deleted)", evt.workspaceKey).withDetails(evt.details);
                    } else {
                        if (evt.action.isCreation() && evt.action != TaggableObjectChangedEvent.ActionType.PROJECT_CREATE) {
                            TimelineNotificationsRouter.this.timelinesDB.deleteObject(evt.objectType, evt.projectKey, evt.objectId);
                        }
                        ti = new TimelineItem(evt.user, evt.action, evt.projectKey, evt.objectType, evt.objectId, evt.workspaceKey).withDetails(evt.details);
                    }
                    try (Transaction t = TimelineNotificationsRouter.this.transactionService.beginRead();){
                        TimelineNotificationsRouter.this.enrichmentService.enrich(ti);
                    }
                    TimelineNotificationsRouter.this.timelinesService.push(ti);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to store event to timeline", (Throwable)e);
                }
            }
        });
        this.pubSub.subscribe("workspace-item-changed", evt -> {
            logger.debugV("TimelinesService notified of workspace item changed: %s", new Object[]{evt});
            try {
                WorkspaceTimelineItem ti = new WorkspaceTimelineItem(evt.user, TimelineNotificationsRouter.toAction(evt.action), evt.workspaceKey, evt.objectType, evt.objectProjectKey, evt.objectId);
                try (Transaction ignored = this.transactionService.beginRead();){
                    this.enrichmentService.enrich(ti);
                }
                this.workspaceTimelinesService.push(ti);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to store event to timeline", (Throwable)e);
            }
        });
        this.pubSub.subscribe("workspace-link-changed", evt -> {
            logger.debugV("TimelinesService notified of workspace link changed: %s", new Object[]{evt});
            try {
                WorkspaceTimelineItem ti = new WorkspaceTimelineItem(evt.user, TimelineNotificationsRouter.toAction(evt.action), evt.workspaceKey, ITaggingService.TaggableType.WORKSPACE_LINK, "$$$WORKSPACES$$$", evt.linkUrl);
                ti.details.addProperty("objectDisplayName", evt.linkName);
                try (Transaction ignored = this.transactionService.beginRead();){
                    this.enrichmentService.enrich(ti);
                }
                this.workspaceTimelinesService.push(ti);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to store event to timeline", (Throwable)e);
            }
        });
        this.pubSub.subscribe("workspace-story-changed", evt -> {
            logger.debugV("TimelinesService notified of workspace story changed: %s", new Object[]{evt});
            try {
                WorkspaceTimelineItem ti = new WorkspaceTimelineItem(evt.user, TimelineNotificationsRouter.toAction(evt.action), evt.workspaceKey, ITaggingService.TaggableType.WORKSPACE_STORY, "$$$WORKSPACES$$$", evt.id);
                ti.details.addProperty("objectDisplayName", evt.title);
                try (Transaction ignored = this.transactionService.beginRead();){
                    this.enrichmentService.enrich(ti);
                }
                this.workspaceTimelinesService.push(ti);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to store event to timeline", (Throwable)e);
            }
        });
        this.pubSub.subscribe("workspace-created", evt -> {
            logger.debugV("TimelinesService notified of workspace created: %s", new Object[]{evt});
            WorkspaceTimelineItem ti = new WorkspaceTimelineItem(evt.getUserLogin(), WorkspaceTimelineItem.WorkspaceActionType.WORKSPACE_CREATE, evt.getWorkspaceKey());
            JsonObject details = new JsonObject();
            details.addProperty("objectDisplayName", evt.workspaceDisplayName);
            ti.withDetails(details);
            try {
                this.workspaceTimelinesDB.createWorkspace(evt.workspaceKey);
                this.workspaceTimelinesService.push(ti);
                this.pubSub.publish(new WorkspaceTimelineItemEvent(ti));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to store event to timeline", (Throwable)e);
            }
        });
        this.pubSub.subscribe("workspace-deleted", evt -> {
            logger.debugV("TimelinesService notified of workspace deleted: %s", new Object[]{evt});
            this.workspaceTimelinesDB.deleteForWorkspace(evt.workspaceKey);
        });
        this.pubSub.subscribe("workspace-membership-changed", evt -> {
            WorkspaceTimelineItem ti;
            logger.debugV("TimelinesService notified of workspace created: %s", new Object[]{evt});
            switch (evt.action) {
                case ADDED: {
                    ti = new WorkspaceTimelineItem(evt.getUserLogin(), WorkspaceTimelineItem.WorkspaceActionType.WORKSPACE_USER_ADD, evt.getWorkspaceKey());
                    break;
                }
                case REMOVED: {
                    ti = new WorkspaceTimelineItem(evt.getUserLogin(), WorkspaceTimelineItem.WorkspaceActionType.WORKSPACE_USER_REMOVE, evt.getWorkspaceKey());
                    break;
                }
                default: {
                    return;
                }
            }
            JsonObject details = new JsonObject();
            if (evt.user != null) {
                PublicUser publicUser = this.usersService.getPublicUser(evt.user);
                details.addProperty("workspaceUser", evt.user);
                details.addProperty("workspaceMembership", "user");
                details.addProperty("workspaceUserDisplayName", publicUser != null ? publicUser.displayName : evt.user);
            } else {
                details.addProperty("workspaceGroup", evt.group);
                details.addProperty("workspaceMembership", "group");
            }
            ti.withDetails(details);
            try {
                this.workspaceTimelinesService.push(ti);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to store event to timeline", (Throwable)e);
            }
        });
        this.pubSub.subscribe("workspace-invitation-changed", evt -> {
            WorkspaceTimelineItem ti;
            logger.debugV("TimelinesService notified of workspace email invitation changed: %s", new Object[]{evt});
            switch (evt.getAction()) {
                case CREATED: {
                    ti = new WorkspaceTimelineItem(evt.getUserLogin(), WorkspaceTimelineItem.WorkspaceActionType.WORKSPACE_USER_INVITATION_ADD, evt.getWorkspaceKey());
                    break;
                }
                case DELETED: {
                    ti = new WorkspaceTimelineItem(evt.getUserLogin(), WorkspaceTimelineItem.WorkspaceActionType.WORKSPACE_USER_INVITATION_REMOVE, evt.getWorkspaceKey());
                    break;
                }
                default: {
                    return;
                }
            }
            JsonObject details = new JsonObject();
            details.addProperty("workspaceUserEmail", evt.getEmails().get(0));
            ti.withDetails(details);
            try {
                this.workspaceTimelinesService.push(ti);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to store event to timeline", (Throwable)e);
            }
        });
        this.pubSub.subscribe("project-deleted", (DSSEventListener)new DSSEventListener<ProjectDeletedEvent>(){

            public void on(ProjectDeletedEvent evt) {
                TimelineNotificationsRouter.this.timelinesDB.deleteForProject(evt.projectKey);
            }
        });
        this.pubSub.subscribe("project-created", (DSSEventListener)new DSSEventListener<ProjectCreatedEvent>(){

            public void on(ProjectCreatedEvent evt) {
                try {
                    TimelineNotificationsRouter.this.timelinesDB.createProject(evt.projectKey);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to create project timeline", (Throwable)e);
                }
            }
        });
        this.pubSub.subscribe("workspace-created", evt -> {
            try {
                this.workspaceTimelinesDB.createWorkspace(evt.workspaceKey);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to create workspace timeline", (Throwable)e);
            }
        });
        this.pubSub.subscribe("user-edited", (DSSEventListener)new DSSEventListener<UserChangedEvent>(){

            public void on(UserChangedEvent evt) {
                if (evt.action == UserChangedEvent.ActionType.DELETED) {
                    try {
                        List<SerializedProject> projects;
                        try (Transaction t = TimelineNotificationsRouter.this.transactionService.beginRead();){
                            projects = TimelineNotificationsRouter.this.projectsService.listAllUnsafe();
                        }
                        ArrayList<String> projectKeys = new ArrayList<String>(projects.size());
                        for (SerializedProject project : projects) {
                            projectKeys.add(project.projectKey);
                        }
                        TimelineNotificationsRouter.this.timelinesDB.flagDeletedUser(projectKeys, evt.getUserLogin());
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to delete user from timelines", (Throwable)e);
                    }
                }
            }
        });
        logger.debug((Object)"Done init timelines router");
    }

    private static WorkspaceTimelineItem.WorkspaceActionType toAction(WorkspaceObjectChangedEvent.ActionCategory action) {
        switch (action) {
            case ADDED: {
                return WorkspaceTimelineItem.WorkspaceActionType.WORKSPACE_OBJECT_ADD;
            }
            case REMOVED: {
                return WorkspaceTimelineItem.WorkspaceActionType.WORKSPACE_OBJECT_REMOVE;
            }
            case DELETED: {
                return WorkspaceTimelineItem.WorkspaceActionType.WORKSPACE_OBJECT_DELETE;
            }
        }
        return WorkspaceTimelineItem.WorkspaceActionType.WORKSPACE_UNKNOWN;
    }
}

