/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.model;

import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.ColumnWithType;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.pivot.frontend.model.ChartType;
import com.dataiku.dip.pivot.frontend.model.ChartVariant;
import com.dataiku.dip.pivot.frontend.model.DigitGrouping;
import com.dataiku.dip.pivot.frontend.model.DimensionDef;
import com.dataiku.dip.pivot.frontend.model.GenericNumberFormattingOptions;
import com.dataiku.dip.pivot.frontend.model.HierarchyDef;
import com.dataiku.dip.pivot.frontend.model.MeasureDef;
import com.dataiku.dip.pivot.frontend.model.Multiplier;
import com.dataiku.dip.pivot.frontend.model.NADimensionDef;
import com.dataiku.dip.pivot.frontend.model.NumberFormattingOptions;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;

@UIModel
public class ChartDef {
    @Nullable
    public String id;
    public ChartType type;
    public ChartVariant variant;
    public String webAppType;
    public String name;
    public boolean userEditedName;
    @Nullable
    public Boolean displayWithECharts;
    @Nullable
    public Boolean displayWithEChartsByDefault;
    public List<DimensionDef> genericDimension0;
    public List<DimensionDef> genericDimension1;
    public List<DimensionDef> facetDimension;
    public List<DimensionDef> animationDimension;
    public List<MeasureDef> genericMeasures;
    public List<HierarchyDef> genericHierarchyDimension;
    public List<HierarchyDef> yHierarchyDimension;
    public List<HierarchyDef> xHierarchyDimension;
    public List<HierarchyDef> groupHierarchyDimension;
    public List<HierarchyDef> boxplotBreakdownHierarchyDimension;
    public List<DimensionDef> xDimension = new ArrayList<DimensionDef>();
    public List<DimensionDef> yDimension = new ArrayList<DimensionDef>();
    public List<NADimensionDef> uaXDimension = new ArrayList<NADimensionDef>();
    public List<NADimensionDef> uaYDimension = new ArrayList<NADimensionDef>();
    public List<NADimensionPair> uaDimensionPair = Arrays.asList(new NADimensionPair());
    public List<Unaggregated> uaSize = new ArrayList<Unaggregated>();
    public List<Unaggregated> uaColor = new ArrayList<Unaggregated>();
    public List<Unaggregated> uaShape = new ArrayList<Unaggregated>();
    public List<Unaggregated> uaTooltip = new ArrayList<Unaggregated>();
    public List<DimensionDef> groupDimension = new ArrayList<DimensionDef>();
    public List<MeasureDef> xMeasure = new ArrayList<MeasureDef>();
    public List<MeasureDef> yMeasure = new ArrayList<MeasureDef>();
    public List<MeasureDef> colorMeasure = new ArrayList<MeasureDef>();
    public List<MeasureDef> sizeMeasure = new ArrayList<MeasureDef>();
    public List<Unaggregated> geometry = new ArrayList<Unaggregated>();
    public List<GeometryLayer> geoLayers = Arrays.asList(new GeometryLayer());
    public List<MeasureDef> tooltipMeasures = new ArrayList<MeasureDef>();
    public List<DimensionDef> boxplotBreakdownDim = new ArrayList<DimensionDef>();
    public List<Unaggregated> boxplotValue = new ArrayList<Unaggregated>();
    public List<ChartFilter> filters;
    public AxisFormattingOptions xAxisFormatting;
    public List<AxisFormattingOptions> yAxesFormatting = new ArrayList<AxisFormattingOptions>();
    public AxisFormattingOptions radialAxisFormatting;
    public boolean smoothing;
    public int strokeWidth = 2;
    public float fillOpacity = 0.5f;
    public TooltipOptions tooltipOptions = new TooltipOptions();
    public int hexbinRadius;
    public int hexbinNumber;
    public HexbinRadiusMode hexbinRadiusMode;
    public ValuesInChartDisplayOptions valuesInChartDisplayOptions;
    @Nullable
    public StackedColumnsOptions stackedColumnsOptions = new StackedColumnsOptions();
    public int chartHeight;
    public boolean singleXAxis;
    public boolean multiTooltips;
    public int animationFrameDuration;
    public boolean animationRepeat = true;
    public ColorMode colorMode;
    public ColorOptions colorOptions = new ColorOptions();
    @Nullable
    public ColorGroup[] colorGroups;
    public BubblesOptions bubblesOptions = new BubblesOptions();
    public ComputeMode computeMode = ComputeMode.NORMAL;
    public XAxisMode xAxisMode = XAxisMode.NORMAL;
    public YAxisMode yAxisMode = YAxisMode.NORMAL;
    public PieOptions pieOptions = new PieOptions();
    public DrilldownOptions drilldownOptions = new DrilldownOptions();
    public ScatterZoomOptions scatterZoomOptions = new ScatterZoomOptions();
    public WaterfallOptions waterfallOptions = new WaterfallOptions();
    public LinesZoomOptions linesZoomOptions = new LinesZoomOptions();
    public ScatterOptions scatterOptions = new ScatterOptions();
    public ScatterMPOptions scatterMPOptions = new ScatterMPOptions();
    public MapOptions mapOptions = new MapOptions();
    public MapGridOptions mapGridOptions = new MapGridOptions();
    public RadarOptions radarOptions = new RadarOptions();
    public SankeyOptions sankeyOptions = new SankeyOptions();
    public GaugeOptions gaugeOptions = new GaugeOptions();
    public String thumbnailData;
    public boolean useLiveProcessingIfAvailable = true;
    public LegendPlacement legendPlacement = LegendPlacement.OUTER_RIGHT;
    @Nullable
    public TextFormattingOptions legendFormatting;
    public JsonObject webAppConfig;
    public PivotTableOptions pivotTableOptions;
    public ReferenceLine[] referenceLines;
    public GridlinesOptions gridlinesOptions;

    private static double[] toDoubleArray(JsonArray jsonArray) {
        double[] result = new double[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonElement element = jsonArray.get(i);
            if (element == null || element.isJsonNull()) continue;
            result[i] = element.getAsDouble();
        }
        return result;
    }

    public boolean isNewChartEmpty() {
        return "New chart".equals(this.name) && CollectionUtils.isEmpty(this.genericDimension0) && CollectionUtils.isEmpty(this.genericMeasures);
    }

    public String getChartDisplayName() {
        switch (this.type) {
            case grouped_columns: {
                return "Vertical bars";
            }
            case stacked_bars: {
                if (this.variant == ChartVariant.normal) {
                    return "Horizontal stacked bars";
                }
                if (this.variant != ChartVariant.stacked_100) break;
                return "Horizontal stacked bars 100%";
            }
            case stacked_columns: {
                if (this.variant == ChartVariant.normal) {
                    return "Vertical stacked bars";
                }
                if (this.variant != ChartVariant.stacked_100) break;
                return "Vertical stacked bars 100%";
            }
            case multi_columns_lines: {
                return "Mix";
            }
            case lines: {
                return "Lines";
            }
            case stacked_area: {
                if (this.variant == ChartVariant.normal) {
                    return "Stacked areas";
                }
                if (this.variant != ChartVariant.stacked_100) break;
                return "Stacked areas 100%";
            }
            case pivot_table: {
                return "Pivot table";
            }
            case scatter: {
                return "Scatter plot";
            }
            case scatter_multiple_pairs: {
                return "Scatter multi-pair";
            }
            case grouped_xy: {
                return "Grouped bubbles";
            }
            case binned_xy: {
                if (this.variant == ChartVariant.normal) {
                    return "Binned bubbles";
                }
                if (this.variant == ChartVariant.binned_xy_rect) {
                    return "Binned rectangles";
                }
                if (this.variant != ChartVariant.binned_xy_hex) break;
                return "Binned hexagons";
            }
            case density_2d: {
                return "2D distribution";
            }
            case treemap: {
                return "Treemap";
            }
            case kpi: {
                return "KPIs";
            }
            case radar: {
                return "Radar";
            }
            case gauge: {
                return "Gauge";
            }
            case sankey: {
                return "Sankey";
            }
            case scatter_map: {
                return "Scatter map";
            }
            case density_heat_map: {
                return "Density map";
            }
            case geom_map: {
                return "Geometry map";
            }
            case admin_map: {
                if (this.variant == ChartVariant.normal) {
                    return "Administrative map (bubbles)";
                }
                if (this.variant != ChartVariant.filled_map) break;
                return "Administrative map (filled)";
            }
            case grid_map: {
                return "Grid map";
            }
            case boxplots: {
                return "Boxplot";
            }
            case pie: {
                if (this.variant == ChartVariant.normal) {
                    return "Pie";
                }
                if (this.variant != ChartVariant.donut) break;
                return "Donut";
            }
            case lift: {
                return "Lift chart";
            }
            default: {
                throw new IllegalStateException("Unsupported graph type");
            }
        }
        return "Unknown";
    }

    public static class NADimensionPair {
        @Nullable
        public String id;
        public List<NADimensionDef> uaXDimension = new ArrayList<NADimensionDef>();
        public List<NADimensionDef> uaYDimension = new ArrayList<NADimensionDef>();
    }

    public static class GeometryLayer {
        public List<Geometry> geometry = new ArrayList<Geometry>();
        public ColorOptions colorOptions = new ColorOptions();
        public List<Unaggregated> uaColor = new ArrayList<Unaggregated>();
    }

    public static class TooltipOptions {
        public boolean display = true;
    }

    public static class StackedColumnsOptions {
        public StackedColumnsTotalsDisplayInChartOptions totalsInChartDisplayOptions = new StackedColumnsTotalsDisplayInChartOptions();
    }

    public static class ColorOptions
    extends SimpleColorOptions {
        public ContinuousColorScaleMode ccScaleMode = ContinuousColorScaleMode.NORMAL;
        public PaletteType paletteType = PaletteType.CONTINUOUS;
        public QuantizationMode quantizationMode;
        public int numQuantizeSteps = 5;
        public double paletteMiddleValue = 0.0;
        public double heatDensityMapIntensity = 0.5;
        public double heatDensityMapRadius = 0.5;

        public static enum ContinuousColorScaleMode {
            NORMAL,
            LOG,
            SQRT,
            SQUARE;

        }

        public static enum PaletteType {
            CONTINUOUS,
            DIVERGING;

        }

        public static enum QuantizationMode {
            NONE,
            LINEAR,
            QUANTILES;

        }
    }

    public static class BubblesOptions {
        public double defaultRadius = 5.0;
        public BubbleShape singleShape;
    }

    public static enum ComputeMode {
        NORMAL,
        INDICE_100,
        CUMULATIVE,
        DIFFERENCE,
        LOG_SCALE,
        PERCENTAGE,
        AVG_RATIO;

    }

    public static enum XAxisMode {
        NORMAL,
        LOG,
        PERCENTAGE_STACK;

    }

    public static enum YAxisMode {
        NORMAL,
        CUMULATIVE,
        DIFFERENCE;

    }

    public static class PieOptions {
        public double donutHoleSize = 50.0;
    }

    public static class DrilldownOptions {
        public boolean displayBreadcrumb = true;
    }

    public static class ScatterZoomOptions
    extends ZoomOptions {
        public double[] scale = new double[2];
        public double[] translate = new double[2];
        @Nullable
        public double[] xRange = null;
        @Nullable
        public double[] yRange = null;
        @Nullable
        public double chartWidth;

        public ScatterZoomOptions() {
            this.translate[0] = 0.0;
            this.translate[1] = 0.0;
            this.scale[0] = 1.0;
            this.scale[1] = 1.0;
        }

        public static void registerJsonAdapter() {
            JSON.registerAdapter(ScatterZoomOptions.class, (elt, type, ctx) -> {
                JsonElement chartWidth;
                JsonElement yRange;
                JsonElement xRange;
                JsonElement translate;
                JsonElement scale;
                JsonElement persisted;
                JsonObject obj = elt.getAsJsonObject();
                ScatterZoomOptions options = new ScatterZoomOptions();
                JsonElement enabled = obj.get("enabled");
                if (enabled != null && !enabled.isJsonNull()) {
                    options.enabled = enabled.getAsBoolean();
                }
                if ((persisted = obj.get("persisted")) != null && !persisted.isJsonNull()) {
                    options.persisted = persisted.getAsBoolean();
                }
                if ((scale = obj.get("scale")) != null && !scale.isJsonNull()) {
                    if (scale.isJsonArray()) {
                        options.scale = ChartDef.toDoubleArray((JsonArray)scale);
                    } else {
                        double scaleValue;
                        options.scale[0] = scaleValue = scale.getAsDouble();
                        options.scale[1] = scaleValue;
                    }
                }
                if ((translate = obj.get("translate")) != null && !translate.isJsonNull()) {
                    options.translate = ChartDef.toDoubleArray(translate.getAsJsonArray());
                }
                if ((xRange = obj.get("xRange")) != null && !xRange.isJsonNull()) {
                    options.xRange = ChartDef.toDoubleArray(xRange.getAsJsonArray());
                }
                if ((yRange = obj.get("yRange")) != null && !yRange.isJsonNull()) {
                    options.yRange = ChartDef.toDoubleArray(yRange.getAsJsonArray());
                }
                if ((chartWidth = obj.get("chartWidth")) != null && !chartWidth.isJsonNull()) {
                    options.chartWidth = chartWidth.getAsDouble();
                }
                return options;
            });
        }
    }

    public static class WaterfallOptions {
        public TotalBarDisplayModes totalBarDisplayMode = TotalBarDisplayModes.RIGHT;
        public boolean useSemanticWatertfallColors = true;
        @Nullable
        public String totalBarLabel = "";
    }

    public static class LinesZoomOptions
    extends ZoomOptions {
        @Nullable
        public double[] displayInterval;
        public boolean displayBrush = true;
    }

    public static class ScatterOptions {
        public boolean equalScales;
        public boolean identityLine;
        public ConnectPointsOptions connectPoints = new ConnectPointsOptions();
        public boolean optimizeRendering;
        public Regression regression = new Regression();
        public double numberOfRecords = 1000000.0;
    }

    public static class ScatterMPOptions {
        public ConnectPointsOptions connectPoints = new ConnectPointsOptions();
        public boolean optimizeRendering;
        public SimpleColorOptions pairColorOptions = new SimpleColorOptions();
        public double numberOfRecords = 1000000.0;
    }

    public static class MapOptions {
        public String tilesLayer = "cartodb-positron";
        public boolean lockSquareGrid;
    }

    public static class MapGridOptions {
        public double gridLonDeg = 0.6;
        public double gridLatDeg = 0.6;
    }

    public static class RadarOptions {
        public boolean filled = false;
        public PolygonSources polygonsSource = PolygonSources.MEASURES;
        public LineStyle lineStyle = new LineStyle();

        public static class LineStyle {
            public float width = 2.0f;
            public LineStyleTypes type = LineStyleTypes.SOLID;
        }
    }

    public static class SankeyOptions {
        public float curveness = 0.5f;
        public LinkColorVariants linkColorVariant = LinkColorVariants.GRADIENT;
        public TextFormattingOptions nodeLabelFormatting;
    }

    public static class GaugeOptions {
        @Nullable
        public DynamicMeasure min;
        @Nullable
        public DynamicMeasure max;
        public Target[] targets;
        @Nullable
        public Range[] ranges;
        @Nullable
        public Axis axis;
        public boolean displayPointer = false;
        public String pointerColor;

        public static class Axis {
            @Nullable
            public AxisTicksConfig ticksConfig = new AxisTicksConfig();
            public AxisValuesFormattingOptions axisValuesFormatting;
            public Integer thickness = 30;
            public boolean customRanges;
        }

        public static class Range
        extends DynamicMeasure {
            public String color;
        }

        public static class Target
        extends DynamicMeasure {
            public String prefix;
            public String suffix;
            public Multiplier multiplier;
            @Nullable
            public ReferenceLinesNumberFormattingOptions numberFormatting;
            public LineFormatting lineFormatting = new LineFormatting();
            @Nullable
            public boolean displayValue = false;
            public TextFormattingOptions valueFormatting;
        }
    }

    static enum LegendPlacement {
        SIDEBAR,
        INNER_TOP_RIGHT,
        INNER_TOP_LEFT,
        INNER_BOTTOM_RIGHT,
        INNER_BOTTOM_LEFT,
        OUTER_TOP,
        OUTER_RIGHT,
        OUTER_BOTTOM,
        OUTER_LEFT;

    }

    public static class GridlinesOptions {
        public GridlinesOption vertical;
        public GridlinesOption horizontal;
    }

    public static class GridlinesOption {
        public boolean show;
        @Nullable
        public GridlinesAxis displayAxis;
        public LineFormatting lineFormatting;
    }

    public static class GridlinesAxis {
        public GridlinesAxisType type;
        @Nullable
        public String axisId;
    }

    public static enum GridlinesAxisType {
        LEFT_Y_AXIS,
        RIGHT_Y_AXIS,
        LEFT_AND_RIGHT_Y_AXIS,
        CUSTOM_Y_AXIS;

    }

    public static class LineFormatting {
        @Nullable
        public ChartLineType type;
        @Nullable
        public String color = "#000";
        public int size = 1;
    }

    public static class ReferenceLine
    extends DynamicMeasure {
        public String prefix;
        public String suffix;
        public ReferenceLineMultiplier multiplier;
        @Nullable
        public ReferenceLinesNumberFormattingOptions numberFormatting;
        public ReferenceLinePosition labelPosition = ReferenceLinePosition.INSIDE_START_TOP;
        public LineFormatting lineFormatting;
        public ReferenceLineAxisInfo axis = new ReferenceLineAxisInfo();
        public boolean displayValue = false;
        public TextFormattingOptions valueFormatting;
    }

    public static class DynamicMeasure {
        public ValueType sourceType;
        public DynamicValue aggregatedColumn;
        public DynamicValue datasetColumn;
        public DynamicValue customAggregation;
        @Nullable
        Aggregation.Function aggregation;
        double percentile;
        boolean isCustomPercentile;
        public double constantValue;
        public double constantDateValue;
        double defaultConstantValue;
        public boolean ignoreExistingFilters = false;
    }

    public static class ReferenceLinesNumberFormattingOptions
    extends GenericNumberFormattingOptions<ReferenceLineMultiplier> {
    }

    public static class ReferenceLineAxisInfo {
        public ReferenceLineAxis type = ReferenceLineAxis.LEFT_Y_AXIS;
        @Nullable
        public String axisId;
    }

    public static enum ValueType {
        Constant,
        AggregatedColumn,
        DatasetColumn,
        CustomAggregation;

    }

    public static enum ReferenceLineMultiplier {
        Inherit,
        Auto,
        None,
        Thousands,
        Millions,
        Millions_alt,
        Billions,
        Billions_alt;

    }

    public static enum ReferenceLineAxis {
        LEFT_Y_AXIS,
        RIGHT_Y_AXIS,
        X_AXIS,
        CUSTOM_Y_AXIS;

    }

    public static enum RegressionLinePosition {
        INSIDE_START,
        INSIDE_END;

    }

    public static enum ReferenceLinePosition {
        INSIDE_START_TOP,
        INSIDE_END_TOP,
        INSIDE_START_BOTTOM,
        INSIDE_END_BOTTOM;

    }

    public static enum ChartLineType {
        DASHED,
        FILLED;

    }

    public static class PivotTableOptions {
        public boolean displayEmptyValues;
        public boolean showSidebar = true;
        public PivotTableMeasureDisplayMode measureDisplayMode;
        public PivotTableDisplayTotals displayTotals;
        public PivotTableFormatting tableFormatting;
        public boolean areRowsExpandedByDefault = true;
        public boolean areColumnExpandedByDefault = true;
        public Map<String, Boolean> rowIdByCustomExpandedStatus = new HashMap<String, Boolean>();
        public Map<String, Boolean> columnIdByCustomExpandedStatus = new HashMap<String, Boolean>();
        public Map<String, Integer> columnIdByCustomWidth = new HashMap<String, Integer>();
    }

    public static class PivotTableFormatting {
        public boolean showRowHeaders = true;
        public boolean showRowMainHeaders = true;
        public TextFormattingOptions rowMainHeaders;
        public TextFormattingOptions rowSubheaders;
        public boolean freezeRowHeaders;
        public boolean showColumnHeaders = true;
        public boolean showColumnMainHeaders = true;
        public TextFormattingOptions columnMainHeaders;
        public TextFormattingOptions columnSubheaders;
        public TextFormattingOptions values;
        public TextFormattingOptions rowHeaders;
        public TextFormattingOptions columnHeaders;
    }

    public static class PivotTableDisplayTotals {
        public PivotTableDisplaySubTotals subTotals;
        public PivotTableDisplayGrandTotals grandTotal;
    }

    public static class PivotTableDisplayGrandTotals {
        public boolean row;
        public boolean column;
    }

    public static class PivotTableDisplaySubTotals {
        public boolean rows;
        public boolean columns;
    }

    public static enum PivotTableMeasureDisplayMode {
        ROWS,
        COLUMNS;

    }

    public static class DynamicValue {
        String column;
        @Nullable
        AxisDef.Type type;
        @Nullable
        TensorType inferredType;
        @Nullable
        Aggregation.Function function;
        double percentile;
    }

    public static enum LinkColorVariants {
        SOURCE,
        GRADIENT,
        TARGET;

    }

    public static enum LineStyleTypes {
        SOLID,
        DASHED,
        DOTTED;

    }

    public static enum PolygonSources {
        MEASURES,
        DIMENSIONS;

    }

    public static enum TotalBarDisplayModes {
        LEFT,
        RIGHT,
        NONE;

    }

    public static class ZoomOptions {
        public boolean enabled = true;
        public boolean persisted = true;
    }

    public static class ConnectPointsOptions {
        public boolean enabled = false;
        @Nullable
        public ConnectPointsSplitOpt splitBy = ConnectPointsSplitOpt.COLOR;
        @Nullable
        public LineFormatting lineFormatting = new LineFormatting();
    }

    public static enum ConnectPointsSplitOpt {
        COLOR,
        SHAPE;

    }

    public static class Regression {
        public boolean show = false;
        public boolean displayFormula = false;
        public RegressionType type = RegressionType.LINEAR;
        public RegressionLinePosition labelPosition = RegressionLinePosition.INSIDE_END;
        public LineFormatting lineFormatting = new LineFormatting();
        public TextFormattingOptions textFormatting = new TextFormattingOptions();
    }

    public static enum RegressionType {
        LINEAR,
        POLYNOMIAL,
        EXPONENTIAL,
        LOGARITHMIC;

    }

    public static enum BubbleShape {
        EMPTY_CIRCLE,
        FILLED_CIRCLE;

    }

    public static class ColorGroup {
        @Nullable
        public ColorGroupModes colorGroupMode = ColorGroupModes.SCALE;
        @Nullable
        public ColorRule[] rules;
        @Nullable
        public DynamicValue[] appliedColumns;
        @Nullable
        public ColorOptions colorOptions = new ColorOptions();
        @Nullable
        public List<MeasureDef> colorMeasure = new ArrayList<MeasureDef>();

        public static enum ColorGroupModes {
            SCALE,
            RULES;

        }
    }

    public static class ColorRule {
        public Mode mode;
        public String styleClass;
        public SimpleColorOptions colorOptions = new SimpleColorOptions();
        public Object conditionValue1;
        public Object conditionValue2;

        public static enum Mode {
            LOWER_THAN,
            LOWER_OR_EQUAL_THAN,
            GREATER_THAN,
            GREATER_OR_EQUAL_THAN,
            DEFINED,
            NOT_DEFINED,
            EQUAL,
            NOT_EQUAL,
            BETWEEN,
            NOT_BETWEEN,
            CONTAINS,
            CONTAINS_INSENSITIVE,
            NOT_CONTAINS,
            NOT_CONTAINS_INSENSITIVE,
            REGEX;

        }
    }

    public static enum ColorMode {
        UNIQUE_SCALE,
        COLOR_GROUPS;

    }

    public static class SimpleColorOptions {
        public String singleColor = "#659a88";
        public double transparency = 0.75;
        public String colorPalette = "default";
        public Palette customPalette = new Palette();
        public Map<String, String> customColors = new HashMap<String, String>();
    }

    public static class Palette {
        public String id = "__dku_custom__";
        public String name = "Custom palette";
        public List<String> colors = new ArrayList<String>();
        public List<Double> values = new ArrayList<Double>();
        boolean fixedValues = false;
    }

    public static enum HexbinRadiusMode {
        ABSOLUTE,
        NUM_HEXAGONS;

    }

    public static class CustomAxisExtent {
        public ExtentEditMode editMode;
        public Float[] manualExtent;
    }

    public static enum ExtentEditMode {
        AUTO,
        MANUAL;

    }

    public static class StackedColumnsTotalsDisplayInChartOptions {
        public TextFormattingOptions textFormatting = new TextFormattingOptions();
        public boolean addDetails;
        @Nullable
        public ValuesInChartPlacementMode placementMode = ValuesInChartPlacementMode.AUTO;
        @Nullable
        public Integer spacing;
        @Nullable
        public List<MeasureDef> additionalMeasures = new ArrayList<MeasureDef>();
    }

    public static class ValuesInChartDisplayOptions {
        @Nullable
        public boolean displayValues;
        @Nullable
        public boolean displayPieLabelsOrValues;
        @Nullable
        public ValuesDisplayMode displayMode;
        @Nullable
        public ValuesInChartOverlappingStrategy overlappingStrategy;
        @Nullable
        public Integer spacing;
        @Nullable
        public ValuesInChartPlacementMode placementMode;
        public TextFormattingOptions textFormatting;
    }

    public static enum ValuesInChartPlacementMode {
        AUTO,
        ABOVE,
        BELOW;

    }

    public static enum ValuesDisplayMode {
        VALUES,
        LABELS,
        VALUES_AND_LABELS,
        VALUES_AND_TOTALS;

    }

    public static enum ValuesInChartOverlappingStrategy {
        AUTO,
        ALL,
        AUTO_WITH_VALUES,
        AUTO_WITH_TOTALS;

    }

    public static class TextFormattingOptions {
        public int fontSize = 11;
        @Nullable
        public String fontColor = "#333";
        @Nullable
        public boolean hasBackground = false;
        @Nullable
        public String backgroundColor;
        @UINullable
        public String fontFamily;

        public void setFontSize(int fontSize) {
            this.fontSize = fontSize;
        }

        public void setFontColor(@Nullable String fontColor) {
            this.fontColor = fontColor;
        }

        public void setHasBackground(boolean hasBackground) {
            this.hasBackground = hasBackground;
        }

        public void setBackgroundColor(@Nullable String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
        }

        public TextFormattingOptions() {
        }

        public TextFormattingOptions(int fontSize) {
            this.fontSize = fontSize;
        }
    }

    public static class AxisValuesFormattingOptions {
        @Nullable
        public NumberFormattingOptions numberFormatting;
        public TextFormattingOptions axisTicksFormatting;
    }

    public static class AxisFormattingOptions {
        @Nullable
        public String id;
        @Nullable
        public Boolean displayAxis;
        public boolean showAxisTitle;
        @Nullable
        public String axisTitle;
        @Nullable
        public TextFormattingOptions axisTitleFormatting;
        public AxisValuesFormattingOptions axisValuesFormatting;
        @Nullable
        public AxisTicksConfig ticksConfig = new AxisTicksConfig();
        @Nullable
        public CustomAxisExtent customExtent = new CustomAxisExtent();
        @Nullable
        public boolean isLogScale;
        @Nullable
        public boolean includeZero = true;
    }

    public static class AxisTicksConfig {
        public AxisTicksConfigMode mode = AxisTicksConfigMode.INTERVAL;
        @Nullable
        public Double number;

        public static enum AxisTicksConfigMode {
            NUMBER,
            INTERVAL;

        }
    }

    public static class Geometry
    extends Unaggregated {
        @Nullable
        public Aggregation.Function aggregationFunction;
    }

    @UIModel
    public static class Unaggregated
    extends ColumnWithType {
        public boolean treatAsAlphanum;
        public String dateMode;
        public String isA;
        public int adminLevel;
        public Multiplier multiplier;
        @Nullable
        public Integer decimalPlaces;
        @Nullable
        public Boolean hideTrailingZeros;
        public DigitGrouping digitGrouping;
        public boolean useParenthesesForNegativeValues;
        public boolean shouldFormatInPercentage;
        public String prefix;
        public String suffix;
        @Nullable
        public String displayLabel;
    }
}

