/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins.presets;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.plugins.presets.LoadedParameterSet;
import com.dataiku.dip.plugins.presets.ParameterSetDesc;
import com.dataiku.dip.plugins.presets.PluginPreset;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PluginParameterSetsService
extends AbstractElementService<ParameterSetDesc, LoadedParameterSet> {
    @Override
    public String getFolderName() {
        return "parameter-sets";
    }

    @Override
    public String getPrefix() {
        return "parameter-set";
    }

    @Override
    public Class<ParameterSetDesc> getDescClass() {
        return ParameterSetDesc.class;
    }

    @Override
    public Class<LoadedParameterSet> getLoadedDescClass() {
        return LoadedParameterSet.class;
    }

    @Override
    protected void removeElement(LoadedParameterSet desc) {
    }

    @Override
    protected String getCodeExtension(LoadedParameterSet desc) {
        return ".txt";
    }

    @Override
    public String makeType(String pluginId, String elementId) {
        return "parameter-set-" + pluginId + "-" + elementId;
    }

    @Override
    protected LoadedParameterSet load(String elementType, String pluginId, String elementId, File file) throws IOException {
        return new LoadedParameterSet(elementId, pluginId, elementType, (ParameterSetDesc)JSON.parseFile((File)file, ParameterSetDesc.class));
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final ParameterSetDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, PluginParameterSetsService.this.getPrefix());
                }
                if (desc.pluginParams != null) {
                    this.genericValidateParams(desc.pluginParams, PluginParameterSetsService.this.getPrefix(), true);
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }

    public PluginPreset findPresetInListOfPresets(String presetName, String parameterSetId, List<PluginPreset> presets) {
        for (PluginPreset preset : presets) {
            LoadedParameterSet parameterSetDesc;
            if (!presetName.equals(preset.name) || (parameterSetDesc = (LoadedParameterSet)this.getOrNull(preset.type)) == null || !parameterSetId.equals(parameterSetDesc.id)) continue;
            return preset;
        }
        return null;
    }
}

