/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.common;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.GenericRecipeCreator;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.WithMessages;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class SingleOutputDatasetRecipeCreator
extends GenericRecipeCreator {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.singleoutput.creator");

    public SingleOutputDatasetRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    public SingleOutputDatasetRecipeCreator(AuthCtx authCtx, RecipeMeta meta, boolean allowPreFilledParams) {
        super(authCtx, meta, allowPreFilledParams);
    }

    protected abstract void setOutputSchema(SerializedRecipe var1, String var2, Dataset var3) throws Exception;

    protected abstract void setOutputSchema(SerializedRecipe var1, String var2, StreamingEndpoint var3) throws Exception;

    @Override
    protected final String makeInitialPayload(SerializedRecipe recipe, JsonObject data) throws Exception {
        SerializedRecipe.RecipeOutput output = recipe.getOutputsForRole("main").get(0);
        DatasetLocUtils.DatasetLoc outputLoc = DatasetLocUtils.resolveSmart(recipe.projectKey, output.ref);
        StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getOrNull(outputLoc);
        if (se != null) {
            return this.makeInitialPayload(recipe, data, se);
        }
        return this.makeInitialPayload(recipe, data, this.datasetAccessService.getMandatory(outputLoc));
    }

    protected abstract String makeInitialPayload(SerializedRecipe var1, JsonObject var2, Dataset var3) throws Exception;

    protected String makeInitialPayload(SerializedRecipe recipe, JsonObject data, StreamingEndpoint outputStreamingEndpoint) throws Exception {
        throw new UnsupportedOperationException("This recipe doesn't work with streaming endpoints");
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe recipe, JsonObject creationData) throws Exception {
        assert (StringUtils.isNotBlank((String)recipe.projectKey));
        assert (this.meta.getType().equals(recipe.type));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)recipe.name), (Object)"Recipe has no name");
        List<SerializedRecipe.RecipeOutput> outputs = recipe.getOutputsForRole("main");
        Preconditions.checkArgument((outputs.size() == 1 ? 1 : 0) != 0, (Object)(this.meta.getType() + " recipes require one output"));
        RecipeCreator.CreationResult ret = new RecipeCreator.CreationResult();
        String outputDatasetName = outputs.get((int)0).ref;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            SingleOutputRecipeCreationSettings settings = (SingleOutputRecipeCreationSettings)JSON.parse((JsonElement)creationData, SingleOutputRecipeCreationSettings.class);
            recipe.name = this.recipeSaveService.transmogrifyName(recipe.projectKey, recipe.name);
            recipe.params = this.makeInitialParams(recipe, creationData);
            if (StringUtils.isBlank((String)settings.zone)) {
                settings.zone = this.flowZonesService.retrieveInputZone(recipe);
            }
            if (settings.outputDatasetSettings != null && StringUtils.isBlank((String)settings.outputDatasetSettings.zone)) {
                settings.outputDatasetSettings.zone = settings.zone;
            }
            this.flowZonesService.attachObjectToZone(settings.zone, recipe.getProjectKey(), recipe);
            String payload = "";
            if (settings.createOutputDataset) {
                Dataset outputDataset = this.mdcService.prepare(this.authCtx, recipe.projectKey, outputDatasetName, settings.outputDatasetSettings);
                SerializedDataset sds = outputDataset.serialize();
                if (settings.outputDatasetSettings != null) {
                    this.flowZonesService.attachObjectToZone(settings.outputDatasetSettings.zone, sds.getProjectKey(), sds);
                }
                logger.info((Object)("Creating dataset " + JSON.prettyLog((Object)sds)));
                DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildFromRecipe(recipe);
                WithMessages<SerializedDataset> createdDataset = this.datasetSaveService.create(recipe.projectKey, sds, dsCtx, this.authCtx);
                ret.messages.mergeFrom(createdDataset.getMessages());
                outputDataset = Dataset.fromSerialized((SerializedDataset)createdDataset.value);
                payload = this.makeInitialPayload(recipe, creationData, outputDataset);
                try {
                    this.setOutputSchema(recipe, payload, outputDataset);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to set the output schema!", (Throwable)e);
                }
                sds = outputDataset.serialize();
                WithMessages<SerializedDataset> saveRet = this.datasetSaveService.saveWithoutEvents(recipe.projectKey, outputDataset.getName(), sds, this.authCtx);
                ret.messages.mergeFrom(saveRet.getMessages());
            } else if (settings.createOutputStreamingEndpoint) {
                StreamingEndpoint se = this.streamingEndpointService.prepare_T(this.authCtx, recipe.projectKey, outputDatasetName, settings.outputStreamingEndpointSettings);
                if (settings.outputStreamingEndpointSettings != null) {
                    this.flowZonesService.attachObjectToZone(settings.outputStreamingEndpointSettings.zone, se.getProjectKey(), se);
                }
                logger.info((Object)("Creating streaming endpoint " + JSON.prettyLog((Object)se)));
                se = this.streamingEndpointService.create_T(this.authCtx, recipe.getProjectKey(), se);
                payload = this.makeInitialPayload(recipe, creationData, se);
                try {
                    this.setOutputSchema(recipe, payload, se);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to set the output schema!", (Throwable)e);
                }
                se = this.streamingEndpointService.saveWithoutEvent((RWTransactionRef)t, recipe.getProjectKey(), se);
                logger.info((Object)("Saved streaming endpoint " + JSON.log((Object)se)));
            } else {
                try {
                    payload = this.makeInitialPayload(recipe, creationData);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to create the initial payload!", (Throwable)e);
                }
            }
            new PDepsFixuper().fixupInPlace(recipe);
            this.checkOutputOwnership_T(recipe);
            SerializedRecipe savedRecipe = this.recipeSaveService.create(recipe.projectKey, recipe, payload);
            this.updateOriginRecipes(savedRecipe, creationData);
            t.commitV("Created %s recipe: %s", new Object[]{recipe.type, recipe.getFullId()});
            ret.id = recipe.name;
            RecipeCreator.CreationResult creationResult = ret;
            return creationResult;
        }
    }

    @Override
    public RecipeCreator.CreationResult copy_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload source, JsonObject copyData) throws Exception {
        RecipeCreator.CreationResult ret = new RecipeCreator.CreationResult();
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            SingleOutputRecipeCopySettings settings = (SingleOutputRecipeCopySettings)JSON.parse((JsonElement)copyData, SingleOutputRecipeCopySettings.class);
            SerializedRecipe.OutputRole mainOutputs = (SerializedRecipe.OutputRole)settings.outputs.get("main");
            Preconditions.checkArgument((mainOutputs != null ? 1 : 0) != 0, (Object)"Recipe main output role is required");
            Preconditions.checkArgument((mainOutputs.items != null && mainOutputs.items.size() == 1 ? 1 : 0) != 0, (Object)"This recipe requires one output");
            SerializedRecipe.RecipeOutput output = ((SerializedRecipe.OutputRole)settings.outputs.get((Object)"main")).items.get(0);
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)output.ref), (Object)"Output name is not specified");
            DatasetLocUtils.DatasetLoc outputLoc = DatasetLocUtils.resolveSmart(projectKey, output.ref);
            if (settings.createOutputDataset) {
                Dataset outputDataset = this.mdcService.prepare(this.authCtx, projectKey, outputLoc.getName(), settings.outputDatasetSettings);
                try {
                    this.setOutputSchema(source.recipe, source.payload, outputDataset);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to set the output schema!", (Throwable)e);
                }
                logger.info((Object)("Creating dataset " + JSON.prettyLog((Object)outputDataset.serialize())));
                DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildFromRecipe(source.recipe);
                dsCtx.setZoneId(settings.zone);
                WithMessages<SerializedDataset> sd = this.datasetSaveService.create(projectKey, outputDataset.serialize(), dsCtx, this.authCtx);
                ret.messages.mergeFrom(sd.messages);
            } else if (settings.createOutputStreamingEndpoint) {
                StreamingEndpoint se = this.streamingEndpointService.prepare_T(this.authCtx, projectKey, outputLoc.getName(), settings.outputStreamingEndpointSettings);
                logger.info((Object)("Creating streaming endpoint " + JSON.prettyLog((Object)se)));
                se = this.streamingEndpointService.create_T(this.authCtx, projectKey, se);
                try {
                    this.setOutputSchema(source.recipe, source.payload, se);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to set the output schema!", (Throwable)e);
                }
                se = this.streamingEndpointService.saveWithoutEvent((RWTransactionRef)t, projectKey, se);
                logger.info((Object)("Saved streaming endpoint " + JSON.log((Object)se)));
            }
            SerializedRecipe copy = this.copyCore((String)projectKey, (SerializedRecipe)source.recipe, (String)source.payload, (JsonObject)copyData).recipe;
            new PDepsFixuper().fixupInPlace(copy);
            this.recipeSaveService.create(projectKey, copy, source.payload);
            t.commitV("Created %s recipe %s", new Object[]{copy.type, copy.name});
            RecipeCreator.CreationResult creationResult = ret.withId(copy.name);
            return creationResult;
        }
    }

    public static class SingleOutputRecipeCreationSettings {
        public boolean createOutputDataset;
        public ManagedDatasetsCreationService.ManagedDatasetCreationSettings outputDatasetSettings;
        public boolean createOutputFolder;
        public ManagedFoldersService.ManagedFolderCreationSettings outputFolderSettings;
        public boolean createOutputStreamingEndpoint;
        public StreamingEndpointService.StreamingEndpointCreationSettings outputStreamingEndpointSettings;
        public String zone;
        public String originDataset;
        public List<String> originRecipes;
    }

    public static class SingleOutputRecipeCopySettings
    extends RecipeCreator.CopySettings {
        public boolean createOutputDataset;
        public ManagedDatasetsCreationService.ManagedDatasetCreationSettings outputDatasetSettings;
        public boolean createOutputFolder;
        public ManagedFoldersService.ManagedFolderCreationSettings outputFolderSettings;
        public boolean createOutputStreamingEndpoint;
        public StreamingEndpointService.StreamingEndpointCreationSettings outputStreamingEndpointSettings;
    }
}

