/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.ksql;

import com.dataiku.dip.recipes.streaming.ksql.KsqlRESTClient;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KsqlExplainer {
    private final KsqlRESTClient client;
    private static Logger logger = Logger.getLogger((String)"dip.flow.ksql.explain");

    public KsqlExplainer(KsqlRESTClient client) {
        this.client = client;
    }

    private KsqlRESTClient.StatementResponse getExplainPlan(String select, boolean isPureSelect) throws IOException {
        KsqlRESTClient.StatementResponses responses;
        try {
            responses = this.client.runStatements("explain create stream `foo__bar` as \n" + select + " ;");
        }
        catch (KsqlRESTClient.KsqlStatementException e1) {
            try {
                responses = this.client.runStatements("explain create table `foo__bar` as  \n" + select + " ;");
            }
            catch (KsqlRESTClient.KsqlStatementException e2) {
                if (isPureSelect) {
                    logger.error((Object)("failed to explain as a CSAS: " + e1.getMessage()), (Throwable)e1);
                    logger.error((Object)("failed to explain as a CTAS: " + e2.getMessage()), (Throwable)e2);
                    throw new IOException("Unable to CSAS or CTAS the statement: " + e1.getMessage() + "\n" + e2.getMessage());
                }
                logger.info((Object)("failed to explain as a CSAS: " + e1.getMessage()));
                logger.info((Object)("failed to explain as a CTAS: " + e2.getMessage()));
                responses = this.client.runStatements("explain " + select + " ;");
            }
        }
        if (responses.size() != 1) {
            throw new IOException("Failed to run explain query, empty response");
        }
        KsqlRESTClient.StatementResponse response = (KsqlRESTClient.StatementResponse)responses.get(0);
        if (response.queryDescription == null) {
            throw new IOException("Unable to perform explain of " + select);
        }
        return response;
    }

    private String prepareSelectForExplain(String select) {
        if ((select = select.trim()).endsWith(";")) {
            select = select.substring(0, select.length() - 1);
        }
        return select;
    }

    public ExplainPlanData explain(String select, boolean isPureSelect) throws IOException {
        select = this.prepareSelectForExplain(select);
        KsqlRESTClient.StatementResponse response = this.getExplainPlan(select, isPureSelect);
        if (response.queryDescription.fields == null) {
            throw new IOException("Explain of " + select + " did not find fields");
        }
        ExplainPlanData data = new ExplainPlanData();
        data.windowType = response.queryDescription.windowType;
        logger.info((Object)("executionPlan=" + response.queryDescription.executionPlan));
        logger.info((Object)("topology=" + response.queryDescription.topology));
        String[] lines = response.queryDescription.topology.split("\n");
        Pattern finalOutputPattern = Pattern.compile("^\\s*\\-\\-> none\\s*$");
        Pattern forEachProcessorPattern = Pattern.compile("^\\s*Processor: KSTREAM\\-FOREACH.*$");
        Pattern sinkPattern = Pattern.compile("^\\s*Sink: KSTREAM\\-SINK.*$");
        Pattern ktableToStreamPattern = Pattern.compile("^\\s*<\\-\\- KTABLE\\-TOSTREAM.*$");
        for (int i = 1; i < lines.length - 1; ++i) {
            if (finalOutputPattern.matcher(lines[i]).matches() && forEachProcessorPattern.matcher(lines[i - 1]).matches() && ktableToStreamPattern.matcher(lines[i + 1]).matches()) {
                logger.info((Object)("Found a ktable at " + i));
                data.isTable = true;
            }
            if (!sinkPattern.matcher(lines[i]).matches() || !ktableToStreamPattern.matcher(lines[i + 1]).matches()) continue;
            logger.info((Object)("Found a ktable at " + i));
            data.isTable = true;
        }
        ArrayList fieldsWithRowKey = Lists.newArrayList(response.queryDescription.fields);
        logger.info((Object)("fieldsWithRowKey=" + JSON.log((Object)fieldsWithRowKey)));
        if (this.client.usesOldStyleRowkeys()) {
            Pattern doubleRowKeyTypePattern;
            String[] explainPlanLines;
            Pattern rowKeyTypePattern = Pattern.compile("^.*Schema.*ROWKEY (\\w+) (PRIMARY )?KEY.*$", 2);
            KsqlRESTClient.KsqlFieldType rowKeyType = null;
            for (String line : explainPlanLines = StringUtils.defaultIfEmpty((String)response.queryDescription.executionPlan, (String)"").split("\n")) {
                Matcher rowKeyTypeMatcher = rowKeyTypePattern.matcher(line);
                if (!rowKeyTypeMatcher.matches()) continue;
                rowKeyType = KsqlRESTClient.KsqlFieldType.valueOf(rowKeyTypeMatcher.group(1).toUpperCase());
                break;
            }
            if (rowKeyType == null) {
                logger.warn((Object)"Unable to find the rowkey type on any of the explain plan lines, using default");
                rowKeyType = KsqlRESTClient.KsqlFieldType.STRING;
            }
            if ((doubleRowKeyTypePattern = Pattern.compile("^.*Schema.*ROWKEY .*ROWKEY .*$", 2)).matcher(explainPlanLines[0]).matches()) {
                throw new IOException("Query selects a column explicitely as rowkey but doesn't use it as key");
            }
            KsqlRESTClient.KsqlField rowKeyFromField = null;
            for (KsqlRESTClient.KsqlField field : fieldsWithRowKey) {
                if ("ROWKEY".equals(field.name)) {
                    field.type = "key";
                    rowKeyFromField = field;
                    continue;
                }
                data.fields.add(field);
            }
            if (rowKeyType != null) {
                rowKeyField = new KsqlRESTClient.KsqlField();
                rowKeyField.name = "ROWKEY";
                rowKeyField.schema = new KsqlRESTClient.KsqlFieldSchema();
                rowKeyField.schema.type = rowKeyType;
                rowKeyField.type = "key";
                data.fields.add(0, rowKeyField);
            } else if (rowKeyFromField != null) {
                data.fields.add(0, rowKeyFromField);
            } else {
                rowKeyField = new KsqlRESTClient.KsqlField();
                rowKeyField.name = "ROWKEY";
                rowKeyField.schema = new KsqlRESTClient.KsqlFieldSchema();
                rowKeyField.schema.type = KsqlRESTClient.KsqlFieldType.STRING;
                rowKeyField.type = "key";
                data.fields.add(0, rowKeyField);
            }
            data.keyName = "ROWKEY";
            data.keyType = rowKeyType;
        } else {
            KsqlRESTClient.KsqlField rowKey = null;
            for (KsqlRESTClient.KsqlField field : fieldsWithRowKey) {
                if (!"key".equalsIgnoreCase(field.type)) continue;
                rowKey = field;
            }
            if (rowKey == null) {
                rowKey = new KsqlRESTClient.KsqlField();
                rowKey.name = "ROWKEY";
                rowKey.schema = new KsqlRESTClient.KsqlFieldSchema();
                rowKey.schema.type = KsqlRESTClient.KsqlFieldType.STRING;
            }
            data.fields.add(rowKey);
            for (KsqlRESTClient.KsqlField field : response.queryDescription.fields) {
                if (StringUtils.equals((String)rowKey.name, (String)field.name)) continue;
                data.fields.add(field);
            }
        }
        return data;
    }

    public static class ExplainPlanData {
        public List<KsqlRESTClient.KsqlField> fields = Lists.newArrayList();
        public boolean isTable;
        public String windowType;
        public String windowSize;
        public String keyName;
        public KsqlRESTClient.KsqlFieldType keyType;

        public ExplainPlanData withWindow(String windowType) {
            this.windowType = windowType;
            return this;
        }

        public ExplainPlanData withKey(String name, KsqlRESTClient.KsqlFieldType type) {
            this.keyName = name;
            this.keyType = type;
            return this;
        }
    }
}

