/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.triggers;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.scheduler.TicketBasedCustomPythonRunner;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.scheduler.triggers.TriggerMeta;
import com.dataiku.dip.scheduler.triggers.TriggerMetaWithSelectableCodeEnv;
import com.dataiku.dip.scheduler.triggers.TriggerParams;
import com.dataiku.dip.scheduler.triggers.TriggerRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.ScenariosBaseService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomPythonTriggerRunner
implements TriggerRunner {
    public static final TriggerMeta META = new TriggerMetaWithSelectableCodeEnv(){

        @Override
        public Class<? extends TriggerParams> paramsClass() {
            return CustomPythonTriggerParams.class;
        }

        @Override
        public String getType() {
            return "custom_python";
        }

        @Override
        public TriggerRunner buildRunner(Scenario scenario, Trigger trigger) {
            return new CustomPythonTriggerRunner(scenario, trigger, trigger.getParamsAs(CustomPythonTriggerParams.class));
        }

        @Override
        public boolean delayIfScenarioAlreadyRuns() {
            return true;
        }

        @Override
        public String getDigest(Trigger trigger) {
            return "Decided by custom code";
        }

        @Override
        public DateTime getExpectedNextRun(Trigger trigger, String stateString) {
            return null;
        }

        @Override
        public CodeEnvModel.EnvLang getEnvLang() {
            return CodeEnvModel.EnvLang.PYTHON;
        }

        @Override
        public int getForcedTriggerLoopDelay(Trigger trigger, String currentState, boolean loopStarting) {
            return trigger.getDelay();
        }
    };
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ScenariosBaseService scenariosBaseService;
    @Autowired
    private InsecureProcessesLaunchService insecureProcessesLaunchService;
    private final CustomPythonTriggerParams params;
    private final Trigger trigger;
    private final Scenario scenario;
    private static Logger logger = Logger.getLogger((String)"dip.scenario.trigger.custom");

    public CustomPythonTriggerRunner(Scenario scenario, Trigger trigger, CustomPythonTriggerParams params) {
        this.trigger = trigger;
        this.params = params;
        this.scenario = scenario;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TriggerFire run(ScenariosTriggerService triggerService, AuthCtx authCtx) throws Exception {
        DSSAuthCtx liu;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.scenariosBaseService.getRunAsUser(this.scenario);
        }
        String stateString = triggerService.getTriggerState(this.scenario, this.trigger);
        TriggerFire triggerFire = new TriggerFire().withScenario(this.scenario).withTrigger(this.trigger);
        File runFolder = ScenarioRunContext.scenarioFolder(this.scenario.getProjectKey(), this.scenario.getId());
        File pythonRunFolder = DKUFileUtils.getWithin((File)runFolder, (String[])new String[]{"custom-trigger-" + this.trigger.getId()});
        try {
            TicketBasedCustomPythonRunner pythonRunner = new TicketBasedCustomPythonRunner(this.apiTicketService, this.insecureProcessesLaunchService, "python_trigger:" + this.scenario.getProjectKey() + "." + this.scenario.getId(), liu, pythonRunFolder, triggerFire, true);
            HashMap extraEnv = Maps.newHashMap();
            extraEnv.put("DKU_TRIGGER", JSON.json((Object)this.trigger));
            extraEnv.put("DKU_CURRENT_PROJECT_KEY", this.scenario.getProjectKey());
            if (stateString != null) {
                extraEnv.put("DKU_TRIGGER_STATE", stateString);
            }
            ReportItem.TriggerFired reportItem = new ReportItem.TriggerFired(new ReportTargetItem.ScenarioTriggerItem(this.scenario.getProjectKey(), this.scenario.getId(), this.trigger.getId()));
            pythonRunner.run(this.params.getCode(), extraEnv, new HashMap<String, String>(), this.scenario.getProjectKey(), null, this.params.envSelection, reportItem, GeneralSettingsDAO.CGrouppableProcessType.PYTHON_SCENARIO);
            TriggerFire triggerFire2 = triggerFire.executedFromExternal ? triggerFire : null;
            return triggerFire2;
        }
        finally {
            try {
                DKUFileUtils.forceDelete((File)pythonRunFolder);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to cleanup run folder", (Throwable)e);
            }
        }
    }

    public static class CustomPythonTriggerParams
    implements TriggerParams,
    ParamsWithSelectableCodeEnv {
        public String code;
        public CodeEnvSelection envSelection = new CodeEnvSelection();

        public String getCode() {
            return this.code;
        }

        public CustomPythonTriggerParams withCode(String code) {
            this.code = code;
            return this;
        }

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.SCENARIO_TRIGGER, object.getProjectKey(), object.getId()));
            }
            return usages;
        }
    }
}

