/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.model;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SecretString;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.GrantType;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.Secret;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.client.ClientInformation;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.client.ClientInformationResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.client.ClientRegistrationErrorResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.client.ClientRegistrationRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.client.ClientRegistrationResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class OAuth2DCRHelper {
    private static final int HTTP_CONNECT_TIMEOUT = 15000;
    private static final int HTTP_READ_TIMEOUT = 15000;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.security.oauth");

    public static OAuth2DCRInfo registerDynamicClient(String registrationEndpoint, String appName, String logoURI, AuthMethod authMethod, Set<DCRGrantType> grantTypes, String redirectionURI, ProxySettings proxy) throws IllegalArgumentException, DKUSecurityException {
        ClientRegistrationResponse response;
        HTTPResponse httpResponse;
        URI parsedRedirectionURI;
        URI parsedRegistrationEndpoint;
        if (StringUtils.isBlank((String)registrationEndpoint)) {
            throw new IllegalArgumentException("Registration endpoint URL can't be empty, please make sure this server supports OAuth DCR");
        }
        try {
            parsedRegistrationEndpoint = new URI(registrationEndpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Registration endpoint URL is invalid, got: " + registrationEndpoint, e);
        }
        if (!parsedRegistrationEndpoint.isAbsolute()) {
            throw new IllegalArgumentException("Registration endpoint URL should be absolute, got: " + String.valueOf(parsedRegistrationEndpoint));
        }
        if (StringUtils.isBlank((String)appName)) {
            throw new IllegalArgumentException("App name can't be empty");
        }
        if (StringUtils.isBlank((String)redirectionURI)) {
            throw new IllegalArgumentException("Redirection URI can't be empty");
        }
        try {
            parsedRedirectionURI = new URI(redirectionURI);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Redirection URI is invalid, got: " + redirectionURI, e);
        }
        if (!parsedRedirectionURI.isAbsolute()) {
            throw new IllegalArgumentException("Redirection URI should be absolute, got: " + String.valueOf(parsedRedirectionURI));
        }
        URI parsedLogoURI = null;
        if (!StringUtils.isBlank((String)logoURI)) {
            try {
                parsedLogoURI = new URI(logoURI);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Logo URI is invalid, got: " + logoURI, e);
            }
            if (!parsedLogoURI.isAbsolute()) {
                throw new IllegalArgumentException("Logo URI should be absolute, got: " + String.valueOf(parsedLogoURI));
            }
        }
        logger.trace(() -> "Starting OAuth DCR at: " + String.valueOf(parsedRegistrationEndpoint));
        ClientMetadata clientMetadata = new ClientMetadata();
        clientMetadata.setRedirectionURI(parsedRedirectionURI);
        clientMetadata.setName(appName);
        if (parsedLogoURI != null) {
            clientMetadata.setLogoURI(parsedLogoURI);
        }
        HashSet<GrantType> nimbusGrantTypes = new HashSet<GrantType>();
        for (DCRGrantType grantType : grantTypes) {
            nimbusGrantTypes.add(grantType.toNimbusType());
        }
        clientMetadata.setGrantTypes(nimbusGrantTypes);
        clientMetadata.setTokenEndpointAuthMethod(authMethod.toNimbusType());
        ClientRegistrationRequest regRequest = new ClientRegistrationRequest(parsedRegistrationEndpoint, clientMetadata, null);
        HTTPRequest httpRequest = regRequest.toHTTPRequest();
        httpRequest.setAccept("application/json");
        ProxyUtils.applyProxySettings((ProxySettings)proxy, (HTTPRequest)httpRequest);
        httpRequest.setConnectTimeout(DKUApp.getParams().getIntParam("dku.connection.oauth.timeoutMs", Integer.valueOf(15000)));
        httpRequest.setReadTimeout(DKUApp.getParams().getIntParam("dku.connection.oauth.timeoutMs", Integer.valueOf(15000)));
        try {
            httpResponse = httpRequest.send();
        }
        catch (IOException e) {
            throw new DKUSecurityException("OAuth DCR failed due to a network error: " + e.getMessage(), (Throwable)e);
        }
        try {
            response = ClientRegistrationResponse.parse((HTTPResponse)httpResponse);
        }
        catch (ParseException e) {
            throw new DKUSecurityException("Failed to parse OAuth DCR response: " + e.getMessage(), (Throwable)e);
        }
        logger.trace(() -> "Got OAuth DCR response: " + JSON.log((Object)response));
        if (!response.indicatesSuccess()) {
            ClientRegistrationErrorResponse errorResponse = (ClientRegistrationErrorResponse)response;
            Object errorCode = errorResponse.getErrorObject().getCode();
            if (errorCode == null) {
                errorCode = "Remote server error: " + httpResponse.getStatusCode() + " " + httpResponse.getStatusMessage();
            }
            String errorMessage = "OAuth DCR failed with error: " + (String)errorCode;
            logger.error((Object)(errorMessage + "\n" + JSON.log((Object)response)));
            if (httpResponse.getStatusCode() >= 400 && httpResponse.getStatusCode() < 500) {
                throw new IllegalArgumentException(errorMessage);
            }
            throw new DKUSecurityException(errorMessage);
        }
        ClientInformationResponse successResponse = (ClientInformationResponse)response;
        ClientInformation clientInfo = successResponse.getClientInformation();
        OAuth2DCRInfo info = new OAuth2DCRInfo(clientInfo);
        logger.info((Object)("OAuth DCR succeeded, got client id: " + info.clientId));
        if (!StringUtils.equals((String)info.appName, (String)appName)) {
            info.addWarning(new InconsistentFieldWarning("app name", appName, info.appName));
        }
        if (!StringUtils.equals((String)info.logoURI, (String)logoURI)) {
            info.addWarning(new InconsistentFieldWarning("logo URI", logoURI, info.logoURI));
        }
        if (info.authMethod != authMethod) {
            String actualAuthMethod = info.authMethod != null ? info.authMethod.toString() : "null";
            info.addWarning(new InconsistentFieldWarning("auth method", authMethod.toString(), actualAuthMethod));
        }
        if (!info.grantTypes.equals(grantTypes)) {
            info.addWarning(new InconsistentFieldWarning("grant types", grantTypes.toString(), info.grantTypes.toString()));
        }
        if (!StringUtils.equals((String)info.redirectionURI, (String)redirectionURI)) {
            info.addWarning(new InconsistentFieldWarning("redirection URI", redirectionURI, info.redirectionURI));
        }
        if (info.hasWarnings()) {
            logger.warn((Object)("The server returned values that are different from what was requested:\n" + info.getWarningsString()));
        }
        return info;
    }

    public static enum DCRGrantType {
        AUTHORIZATION_CODE,
        CLIENT_CREDENTIALS,
        REFRESH_TOKEN;


        public GrantType toNimbusType() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case AUTHORIZATION_CODE -> GrantType.AUTHORIZATION_CODE;
                case CLIENT_CREDENTIALS -> GrantType.CLIENT_CREDENTIALS;
                case REFRESH_TOKEN -> GrantType.REFRESH_TOKEN;
            };
        }

        public static DCRGrantType fromNimbusType(GrantType nimbusGrantType) {
            if (nimbusGrantType == GrantType.AUTHORIZATION_CODE) {
                return AUTHORIZATION_CODE;
            }
            if (nimbusGrantType == GrantType.CLIENT_CREDENTIALS) {
                return CLIENT_CREDENTIALS;
            }
            if (nimbusGrantType == GrantType.REFRESH_TOKEN) {
                return REFRESH_TOKEN;
            }
            throw new IllegalArgumentException("Unsupported grant type " + String.valueOf(nimbusGrantType));
        }
    }

    public static enum AuthMethod {
        CLIENT_SECRET_BASIC,
        CLIENT_SECRET_POST,
        PRIVATE_KEY_JWT,
        NONE;


        public ClientAuthenticationMethod toNimbusType() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case CLIENT_SECRET_BASIC -> ClientAuthenticationMethod.CLIENT_SECRET_BASIC;
                case CLIENT_SECRET_POST -> ClientAuthenticationMethod.CLIENT_SECRET_POST;
                case PRIVATE_KEY_JWT -> ClientAuthenticationMethod.PRIVATE_KEY_JWT;
                case NONE -> ClientAuthenticationMethod.NONE;
            };
        }

        public static AuthMethod fromNimbusType(ClientAuthenticationMethod nimbusAuthMethod) {
            if (nimbusAuthMethod == ClientAuthenticationMethod.CLIENT_SECRET_BASIC) {
                return CLIENT_SECRET_BASIC;
            }
            if (nimbusAuthMethod == ClientAuthenticationMethod.CLIENT_SECRET_POST) {
                return CLIENT_SECRET_POST;
            }
            if (nimbusAuthMethod == ClientAuthenticationMethod.PRIVATE_KEY_JWT) {
                return PRIVATE_KEY_JWT;
            }
            if (nimbusAuthMethod == ClientAuthenticationMethod.NONE) {
                return NONE;
            }
            throw new IllegalArgumentException("Unsupported authentication method: " + String.valueOf(nimbusAuthMethod));
        }
    }

    public static class OAuth2DCRInfo {
        public String clientId;
        public SecretString clientSecret;
        public String appName;
        public String logoURI;
        public AuthMethod authMethod;
        public Set<DCRGrantType> grantTypes = new HashSet<DCRGrantType>();
        public String redirectionURI;
        public List<InconsistentFieldWarning> warnings = new ArrayList<InconsistentFieldWarning>();

        OAuth2DCRInfo(ClientInformation clientInfo) {
            this.clientId = clientInfo.getID().getValue();
            Secret secret = clientInfo.getSecret();
            this.clientSecret = secret != null ? SecretString.buildOrNull((String)secret.getValue()) : SecretString.buildOrNull((String)"");
            ClientMetadata clientMetadata = clientInfo.getMetadata();
            if (clientMetadata.getName() != null) {
                this.appName = clientMetadata.getName();
            }
            if (clientMetadata.getLogoURI() != null) {
                this.logoURI = clientMetadata.getLogoURI().toString();
            }
            if (clientMetadata.getTokenEndpointAuthMethod() != null) {
                this.authMethod = AuthMethod.fromNimbusType(clientMetadata.getTokenEndpointAuthMethod());
            }
            if (clientMetadata.getGrantTypes() != null) {
                for (GrantType grantType : clientMetadata.getGrantTypes()) {
                    this.grantTypes.add(DCRGrantType.fromNimbusType(grantType));
                }
            }
            if (clientMetadata.getRedirectionURI() != null) {
                this.redirectionURI = clientMetadata.getRedirectionURI().toString();
            }
        }

        private void addWarning(InconsistentFieldWarning warning) {
            this.warnings.add(warning);
        }

        private boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }

        private String getWarningsString() {
            return StringUtils.join(this.warnings, (String)"\n");
        }
    }

    public static class InconsistentFieldWarning {
        public String fieldName;
        public String expectedValue;
        public String actualValue;

        InconsistentFieldWarning(String fieldName, String expectedValue, String actualValue) {
            this.fieldName = fieldName;
            this.expectedValue = expectedValue;
            this.actualValue = actualValue;
        }

        public String toString() {
            return this.fieldName + ": expected '" + this.expectedValue + "', actual '" + this.actualValue + "'";
        }
    }
}

