/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.trust;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSStartedEvent;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.sql.queries.DeleteQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.google.common.base.Preconditions;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class TrustInternalDB
extends AbstractDSSDBService
implements ApplicationListener<DSSStartedEvent> {
    private static final int SCHEMA_VERSION = 1;
    private static final String DB_NAME = "trust_db";
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private static final DKULogger logger = DKULogger.getLogger(TrustInternalDB.class);

    public TrustInternalDB() {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 1, false);
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) {
        block8: {
            try {
                if (currentSchemaVersion >= 1) break block8;
                try (Statement st2 = conn.createStatement();){
                    this.createTable("WEBAPP_TRUST_ENTRIES", new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("WEBAPP_ID", Type.STRING), new SchemaColumn("WEBAPP_FINGERPRINT", Type.STRING), new SchemaColumn("TRUSTER_REF", Type.STRING), new SchemaColumn("CREATOR_LOGIN", Type.STRING), new SchemaColumn("CREATED_ON", Type.BIGINT)}, new String[0], st2);
                    this.createNamedIndex("WEBAPP_TRUST_ENTRIES", "WEBAPP_TRUST_ENTRIES_IDX_WID_WHASH", new String[]{"PROJECT_KEY", "WEBAPP_ID", "WEBAPP_FINGERPRINT"}, st2);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to init trust DB", (Throwable)e);
            }
        }
    }

    public void createTrustEntry(TrustEntry entry) throws SQLException {
        logger.info((Object)("Create new entry for webapp " + entry.projectKey + "." + entry.webAppId + " (" + entry.webAppFingerprint + ")"));
        String insertQuery = InsertQueryBuilder.insertInto(this.resolveTable("WEBAPP_TRUST_ENTRIES")).addColumns("PROJECT_KEY", "WEBAPP_ID", "TRUSTER_REF", "WEBAPP_FINGERPRINT", "CREATOR_LOGIN", "CREATED_ON").toSQL(this.getDialect());
        String trusterRef = entry.trusterLogin == null ? "all" : "user:" + entry.trusterLogin;
        try (DSSDBConnection ac = this.acquireConnection();){
            PreparedStatement ps2 = ac.getOrCreatePreparedStatement(insertQuery);
            ps2.setString(1, entry.projectKey);
            ps2.setString(2, entry.webAppId);
            ps2.setString(3, trusterRef);
            ps2.setString(4, entry.webAppFingerprint);
            ps2.setString(5, entry.creatorLogin);
            ps2.setLong(6, entry.createdOn);
            ps2.execute();
            ac.commit();
        }
    }

    public void cleanupOldEntries(long beforeTS) throws SQLException {
        logger.info((Object)"Cleanup old entries");
        SelectQueryBuilder innerQuery = new SelectQueryBuilder();
        innerQuery.from(this.resolveTable("WEBAPP_TRUST_ENTRIES"), "newest");
        innerQuery.where(EBF.col("WEBAPP_TRUST_ENTRIES", "CREATED_ON").lt(EBF.col("newest", "CREATED_ON")));
        innerQuery.where(EBF.col("WEBAPP_TRUST_ENTRIES", "PROJECT_KEY").nullUnsafeEq(EBF.col("newest", "PROJECT_KEY")));
        innerQuery.where(EBF.col("WEBAPP_TRUST_ENTRIES", "WEBAPP_ID").nullUnsafeEq(EBF.col("newest", "WEBAPP_ID")));
        innerQuery.where(EBF.col("WEBAPP_TRUST_ENTRIES", "TRUSTER_REF").nullUnsafeEq(EBF.col("newest", "TRUSTER_REF")));
        String deleteQuery = DeleteQueryBuilder.deleteFrom(this.resolveTable("WEBAPP_TRUST_ENTRIES")).where(EBF.op(QueryUtils.OperatorType.EXISTS, EBF.expr("(" + innerQuery.toSQL(this.getDialect()) + ")"))).where(EBF.col("WEBAPP_TRUST_ENTRIES", "CREATED_ON").lt(EBF.expr("?"))).toSql(this.getDialect());
        try (DSSDBConnection ac = this.acquireConnection();){
            PreparedStatement ps2 = ac.getOrCreatePreparedStatement(deleteQuery);
            ps2.setLong(1, beforeTS);
            ps2.execute();
            ac.commit();
        }
    }

    public void removeEntriesForWebApp(String projectKey, String webAppId) throws SQLException {
        logger.info((Object)("Cleanup entries for webapp " + projectKey + "." + webAppId));
        String deleteQuery = DeleteQueryBuilder.deleteFrom(this.resolveTable("WEBAPP_TRUST_ENTRIES")).withParameterizedEqualWheres("PROJECT_KEY", "WEBAPP_ID").toSql(this.getDialect());
        try (DSSDBConnection ac = this.acquireConnection();){
            PreparedStatement ps2 = ac.getOrCreatePreparedStatement(deleteQuery);
            ps2.setString(1, projectKey);
            ps2.setString(2, webAppId);
            ps2.execute();
            ac.commit();
        }
    }

    public void removeEntriesForProject(String projectKey) throws SQLException {
        logger.info((Object)("Cleanup entries for project " + projectKey));
        String deleteQuery = DeleteQueryBuilder.deleteFrom(this.resolveTable("WEBAPP_TRUST_ENTRIES")).withParameterizedEqualWheres("PROJECT_KEY").toSql(this.getDialect());
        try (DSSDBConnection ac = this.acquireConnection();){
            PreparedStatement ps2 = ac.getOrCreatePreparedStatement(deleteQuery);
            ps2.setString(1, projectKey);
            ps2.execute();
            ac.commit();
        }
    }

    private TrustEntry buildTrustEntryFromResult(ResultSet rs2) throws SQLException {
        String trusterLogin = null;
        String trusterRef = rs2.getString("TRUSTER_REF");
        if (trusterRef.startsWith("user:")) {
            trusterLogin = StringUtils.removeStart((String)trusterRef, (String)"user:");
        }
        return new TrustEntry(rs2.getString("PROJECT_KEY"), rs2.getString("WEBAPP_ID"), rs2.getString("WEBAPP_FINGERPRINT"), trusterLogin, rs2.getString("CREATOR_LOGIN"), rs2.getLong("CREATED_ON"));
    }

    public void copyTrustEntriesForWebApp(String sourceProjectKey, String sourceWebAppId, String targetProjectKey, String targetWebAppId) throws SQLException {
        SelectQueryBuilder selectQuery = new SelectQueryBuilder();
        selectQuery.from(this.resolveTable("WEBAPP_TRUST_ENTRIES"), "WEBAPP_TRUST_ENTRIES");
        selectQuery.select(EBF.expr("?"));
        selectQuery.select(EBF.expr("?"));
        selectQuery.select(EBF.col("WEBAPP_FINGERPRINT"));
        selectQuery.select(EBF.col("TRUSTER_REF"));
        selectQuery.select(EBF.col("CREATOR_LOGIN"));
        selectQuery.select(EBF.col("CREATED_ON"));
        selectQuery.where(EBF.col("PROJECT_KEY").nullUnsafeEq(EBF.expr("?")));
        selectQuery.where(EBF.col("WEBAPP_ID").nullUnsafeEq(EBF.expr("?")));
        String insertQuery = InsertQueryBuilder.insertInto(this.resolveTable("WEBAPP_TRUST_ENTRIES")).addColumns("PROJECT_KEY", "WEBAPP_ID", "WEBAPP_FINGERPRINT", "TRUSTER_REF", "CREATOR_LOGIN", "CREATED_ON").fromQuery(selectQuery).toSQL(this.getDialect());
        try (DSSDBConnection ac = this.acquireConnection();){
            PreparedStatement ps2 = ac.getOrCreatePreparedStatement(insertQuery);
            ps2.setString(1, targetProjectKey);
            ps2.setString(2, targetWebAppId);
            ps2.setString(3, sourceProjectKey);
            ps2.setString(4, sourceWebAppId);
            ps2.execute();
            ac.commit();
        }
    }

    @Nullable
    public TrustEntry lookupTrustRelationship(String projectKey, String webAppId, String webAppFingerprint, @Nullable String userLogin) throws SQLException {
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.resolveTable("WEBAPP_TRUST_ENTRIES"), "WEBAPP_TRUST_ENTRIES");
        sqb.select(EBF.col("PROJECT_KEY"));
        sqb.select(EBF.col("WEBAPP_ID"));
        sqb.select(EBF.col("WEBAPP_FINGERPRINT"));
        sqb.select(EBF.col("TRUSTER_REF"));
        sqb.select(EBF.col("CREATOR_LOGIN"));
        sqb.select(EBF.col("CREATED_ON"));
        sqb.where(EBF.col("PROJECT_KEY").nullUnsafeEq(EBF.expr("?")));
        sqb.where(EBF.col("WEBAPP_ID").nullUnsafeEq(EBF.expr("?")));
        sqb.where(EBF.col("WEBAPP_FINGERPRINT").nullUnsafeEq(EBF.expr("?")));
        sqb.where(EBF.col("TRUSTER_REF").nullUnsafeEq("all").or(EBF.col("TRUSTER_REF").nullUnsafeEq(EBF.expr("?"))));
        sqb.order(EBF.col("TRUSTER_REF"), QueryAst.OrderType.ASC);
        sqb.order(EBF.col("CREATED_ON"), QueryAst.OrderType.DESC);
        sqb.limit(1L);
        try (DSSDBConnection ac = this.acquireConnection();){
            TrustEntry trustEntry;
            block16: {
                ResultSet rs2;
                block14: {
                    TrustEntry trustEntry2;
                    block15: {
                        PreparedStatement ps2 = ac.getOrCreatePreparedStatement(sqb.toSQL(this.getDialect()));
                        ps2.setString(1, projectKey);
                        ps2.setString(2, webAppId);
                        ps2.setString(3, webAppFingerprint);
                        ps2.setString(4, (String)(userLogin == null ? "" : "user:" + userLogin));
                        ps2.execute();
                        rs2 = ps2.getResultSet();
                        try {
                            if (!rs2.next()) break block14;
                            trustEntry2 = this.buildTrustEntryFromResult(rs2);
                            if (rs2 == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs2 != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs2.close();
                    }
                    return trustEntry2;
                }
                trustEntry = null;
                if (rs2 == null) break block16;
                rs2.close();
            }
            return trustEntry;
        }
    }

    public void onApplicationEvent(DSSStartedEvent dssStartedEvent) {
        try {
            this.create();
        }
        catch (CodedSQLException e) {
            logger.error((Object)"Failed to init trust DB", (Throwable)e);
        }
    }

    public static class TrustEntry
    extends ImmutableValueObject {
        private static final Pattern FINGERPRINT_PATTERN = Pattern.compile("^[a-f0-9]{64}$");
        public final String projectKey;
        public final String webAppId;
        public final String webAppFingerprint;
        @Nullable
        public final String trusterLogin;
        public final String creatorLogin;
        public final long createdOn;

        public String checkFingerprint(String fingerprint) {
            Preconditions.checkNotNull((Object)fingerprint);
            if (!FINGERPRINT_PATTERN.matcher(fingerprint).matches()) {
                throw new IllegalArgumentException("Invalid fingerprint: " + fingerprint);
            }
            return fingerprint;
        }

        public TrustEntry(String projectKey, String webAppId, String webAppFingerprint, @Nullable String trusterLogin, String creatorLogin, long createdOn) {
            this.projectKey = (String)Preconditions.checkNotNull((Object)projectKey);
            this.webAppId = (String)Preconditions.checkNotNull((Object)webAppId);
            this.webAppFingerprint = this.checkFingerprint(webAppFingerprint);
            this.creatorLogin = (String)Preconditions.checkNotNull((Object)creatorLogin);
            this.trusterLogin = trusterLogin;
            this.createdOn = createdOn;
        }

        public boolean isWildcard() {
            return this.trusterLogin == null;
        }
    }
}

