/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.trust;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.security.trust.FingerprintService;
import com.dataiku.dip.security.trust.TrustInternalDB;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TaggableObjectCodes;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendsManager;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrustedCodeService {
    @Autowired
    GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    TrustInternalDB trustInternalDB;
    @Autowired
    FingerprintService fingerprintService;
    @Autowired
    PermissionsService permissionsService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    WebAppBackendsManager webAppBackendsManager;

    public TrustedCodeCheckReport trustWebApp_NT(AuthCtx authCtx, String projectKey, String webAppId, boolean trustForEveryBody, String precomputedFingerprint) throws SQLException, IOException, DKUSecurityException {
        TrustedCodeCheckReport report = this.computeWebAppTrustedCodeReport_NT(authCtx, projectKey, webAppId, precomputedFingerprint);
        if (report.trustedCodeStatus == TrustedCodeStatus.NOT_APPLICABLE) {
            throw new UnauthorizedException(report.message, "webapp-trust-impossible").withCode(report.code);
        }
        return this.createTrustEntry(authCtx, projectKey, webAppId, trustForEveryBody, precomputedFingerprint);
    }

    public TrustedCodeCheckReport trustBusinessApplicationWebApp_NT(AuthCtx authCtx, String projectKey, String webAppId, String precomputedFingerprint) throws SQLException, IOException, DKUSecurityException {
        return this.createTrustEntry(authCtx, projectKey, webAppId, true, precomputedFingerprint);
    }

    private TrustedCodeCheckReport createTrustEntry(AuthCtx authCtx, String projectKey, String webAppId, boolean trustForEveryBody, String precomputedFingerprint) throws DKUSecurityException, SQLException, IOException {
        String trusterLogin;
        String currentIdentifier;
        if (trustForEveryBody) {
            currentIdentifier = authCtx.getIdentifier();
            trusterLogin = null;
        } else {
            trusterLogin = currentIdentifier = authCtx.getAssociatedDSSUserMand();
        }
        TrustInternalDB.TrustEntry entry = new TrustInternalDB.TrustEntry(projectKey, webAppId, precomputedFingerprint, trusterLogin, currentIdentifier, System.currentTimeMillis());
        this.trustInternalDB.createTrustEntry(entry);
        return this.computeWebAppTrustedCodeReport_NT(authCtx, projectKey, webAppId, precomputedFingerprint);
    }

    public void copyTrustEntriesForWebApp_NT(String sourceProjectKey, String sourceWebAppId, String targetProjectKey, String targetWebAppId) throws IOException, SQLException {
        TransactionContext.assertNoAttachedTransaction();
        this.trustInternalDB.copyTrustEntriesForWebApp(sourceProjectKey, sourceWebAppId, targetProjectKey, targetWebAppId);
    }

    public TrustedCodeCheckReport autoTrustIfNeededWebApp_NT(AuthCtx authCtx, String projectKey, String webAppId, @Nullable String precomputedFingerprint) throws SQLException, IOException, DKUSecurityException {
        TrustedCodeCheckReport report = this.computeWebAppTrustedCodeReport_NT(authCtx, projectKey, webAppId, precomputedFingerprint);
        if (!report.canAccess && report.canTrust && authCtx.getAssociatedDSSUser() != null) {
            return this.trustWebApp_NT(authCtx, projectKey, webAppId, false, precomputedFingerprint);
        }
        return report;
    }

    @Nullable
    public String precomputeFingerprintIfPossiblyNeeded_T(@Nullable AuthCtx authCtx, String projectKey, String webAppId) throws IOException, DKUSecurityException {
        TransactionContext.assertAttachedTransaction();
        Preconditions.checkNotNull((Object)projectKey);
        Preconditions.checkNotNull((Object)webAppId);
        if (authCtx == null) {
            return null;
        }
        if (authCtx.isAdmin() && this.isWebAppForbiddenForAdmins()) {
            return null;
        }
        GeneralSettingsDAO.WebAppSecuritySettings.TrustedCodePolicy trustedCodePolicy = this.generalSettingsDAO.getUnsafe().webAppSecuritySettings.trustedCodePolicy;
        if (trustedCodePolicy == GeneralSettingsDAO.WebAppSecuritySettings.TrustedCodePolicy.NOBODY) {
            return null;
        }
        if (trustedCodePolicy == GeneralSettingsDAO.WebAppSecuritySettings.TrustedCodePolicy.ADMIN && !authCtx.isAdmin()) {
            return null;
        }
        WebApp webApp = ((WebAppsService)SpringUtils.getBean(WebAppsService.class)).getMandatory(projectKey, webAppId);
        if (webApp.isVirtual) {
            return null;
        }
        WebAppMeta meta = WebAppRegistry.getMeta(webApp.type);
        if (meta.isCustomWebApp()) {
            return null;
        }
        AuthCtx runtimeUser = null;
        WebAppBackend webAppBackend = this.webAppBackendsManager.getBackendOrNull(projectKey, webAppId);
        if (webAppBackend != null) {
            runtimeUser = webAppBackend.getCurrentAuthCtx();
            if (runtimeUser == null) {
                runtimeUser = webAppBackend.buildActualAuthCtx(authCtx, webApp);
            }
        } else {
            runtimeUser = authCtx;
        }
        return this.fingerprintService.computeWebAppFingerprint(webApp, runtimeUser);
    }

    public void checkCanTrust_NT(AuthCtx authCtx, String projectKey, String webAppId, boolean trustForEverybody, @Nullable String precomputedFingerprint) throws SQLException, IOException, DKUSecurityException {
        TrustedCodeCheckReport report = this.computeWebAppTrustedCodeReport_NT(authCtx, projectKey, webAppId, precomputedFingerprint);
        if (trustForEverybody && !report.canTrustForEverybody) {
            throw new UnauthorizedException("You are not allowed to trust this webapp on behalf of everybody", "webapp-trust-forbidden");
        }
        if (!report.canTrust) {
            throw new UnauthorizedException("You are not allowed to trust this webapp", "webapp-trust-forbidden");
        }
    }

    private boolean isWebAppForbiddenForAdmins() {
        return DKUApp.getParams().getBoolParam("dku.security.webapps.forbidViewingByAdmins", false);
    }

    public TrustedCodeCheckReport computeWebAppTrustedCodeReport_NT(@Nullable AuthCtx authCtx, String projectKey, String webAppId) throws IOException, SQLException, DKUSecurityException {
        String fingerprint;
        try (Transaction t = this.transactionService.beginRead();){
            fingerprint = this.precomputeFingerprintIfPossiblyNeeded_T(authCtx, projectKey, webAppId);
        }
        return this.computeWebAppTrustedCodeReport_NT(authCtx, projectKey, webAppId, fingerprint);
    }

    private TrustedCodeCheckReport computeWebAppTrustedCodeReport_NT(@Nullable AuthCtx authCtx, String projectKey, String webAppId, @Nullable String precomputedFingerprint) throws IOException, SQLException, DKUSecurityException {
        boolean canTrustForEverybody;
        boolean canTrust;
        WebApp webApp;
        GeneralSettingsDAO.WebAppSecuritySettings.TrustedCodePolicy trustedCodePolicy;
        TransactionContext.assertNoAttachedTransaction();
        Preconditions.checkNotNull((Object)projectKey);
        Preconditions.checkNotNull((Object)webAppId);
        if (authCtx == null) {
            return new TrustedCodeCheckReport(TrustedCodeStatus.NOT_APPLICABLE, true, false, false, null, "Trusted code policy does not restrict unauthenticated access", null, null, null);
        }
        if (authCtx.isAdmin() && this.isWebAppForbiddenForAdmins()) {
            return new TrustedCodeCheckReport(TrustedCodeStatus.NOT_APPLICABLE, false, false, false, (InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_WEBAPP_ACCESS_DENIED_BY_POLICY, "Access to webapp denied", null, null, null);
        }
        try (Transaction t = this.transactionService.beginRead();){
            trustedCodePolicy = this.generalSettingsDAO.getUnsafe().webAppSecuritySettings.trustedCodePolicy;
            webApp = ((WebAppsService)SpringUtils.getBean(WebAppsService.class)).getOrNull(projectKey, webAppId);
            if (webApp == null) {
                TrustedCodeCheckReport trustedCodeCheckReport = new TrustedCodeCheckReport(TrustedCodeStatus.NOT_APPLICABLE, false, false, false, TaggableObjectCodes.ERR_OBJECT_UNEXPECTED_ERROR, "Webapp does not exist", null, null, null);
                return trustedCodeCheckReport;
            }
            if (webApp.isVirtual) {
                TrustedCodeCheckReport trustedCodeCheckReport = new TrustedCodeCheckReport(TrustedCodeStatus.NOT_APPLICABLE, true, false, false, null, "Trusted code policy does not apply to virtual webapps", null, null, null);
                return trustedCodeCheckReport;
            }
            WebAppMeta meta = WebAppRegistry.getMeta(webApp.type);
            if (meta.isCustomWebApp()) {
                TrustedCodeCheckReport trustedCodeCheckReport = new TrustedCodeCheckReport(TrustedCodeStatus.NOT_APPLICABLE, true, false, false, null, "Trusted code policy does not apply to plugin webapps", null, null, null);
                return trustedCodeCheckReport;
            }
        }
        if (trustedCodePolicy == GeneralSettingsDAO.WebAppSecuritySettings.TrustedCodePolicy.NOBODY) {
            return new TrustedCodeCheckReport(TrustedCodeStatus.NOT_APPLICABLE, true, false, false, null, "Trusted code policy is not enabled", null, null, null);
        }
        if (trustedCodePolicy == GeneralSettingsDAO.WebAppSecuritySettings.TrustedCodePolicy.ADMIN && !authCtx.isAdmin()) {
            return new TrustedCodeCheckReport(TrustedCodeStatus.TRUST_NOT_REQUIRED_BECAUSE_NON_ADMIN, true, false, false, null, "Trusted code policy only applies to admins", null, null, null);
        }
        try (Transaction t = this.transactionService.beginRead();){
            canTrust = this.permissionsService.hasProjectPrivilege(authCtx, webApp.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            canTrustForEverybody = authCtx.isAdmin();
        }
        Preconditions.checkNotNull((Object)precomputedFingerprint);
        TrustInternalDB.TrustEntry trustEntry = this.trustInternalDB.lookupTrustRelationship(projectKey, webAppId, precomputedFingerprint, authCtx.getAssociatedDSSUser());
        if (trustEntry == null) {
            return new TrustedCodeCheckReport(TrustedCodeStatus.NOT_TRUSTED, false, canTrust, canTrustForEverybody, (InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_WEBAPP_ACCESS_DENIED_BY_POLICY, "Webapp is not trusted", null, null, precomputedFingerprint);
        }
        TrustedCodeStatus trustStatus = trustEntry.isWildcard() ? TrustedCodeStatus.TRUSTED_FOR_EVERYBODY : TrustedCodeStatus.TRUSTED_BY_USER;
        return new TrustedCodeCheckReport(trustStatus, true, canTrust, canTrustForEverybody, null, "Webapp is trusted", trustEntry.creatorLogin, trustEntry.createdOn, precomputedFingerprint);
    }

    public static class TrustedCodeCheckReport {
        public final TrustedCodeStatus trustedCodeStatus;
        public final boolean canAccess;
        public final boolean canTrust;
        public final boolean canTrustForEverybody;
        public final InfoMessage.MessageCode code;
        public final String message;
        public final String trustEntryCreatedBy;
        public final Long trustEntryCreatedOn;
        public final String fingerprint;

        TrustedCodeCheckReport(TrustedCodeStatus trustedCodeStatus, boolean canAccess, boolean canTrust, boolean canTrustForEverybody, InfoMessage.MessageCode code, String message, String trustEntryCreatedBy, Long trustEntryCreatedOn, String fingerprint) {
            this.trustedCodeStatus = trustedCodeStatus;
            this.canAccess = canAccess;
            this.canTrust = canTrust;
            this.canTrustForEverybody = canTrustForEverybody;
            this.message = message;
            this.code = code;
            this.trustEntryCreatedBy = trustEntryCreatedBy;
            this.trustEntryCreatedOn = trustEntryCreatedOn;
            this.fingerprint = fingerprint;
        }
    }

    static enum TrustedCodeStatus {
        NOT_TRUSTED,
        NOT_APPLICABLE,
        TRUSTED_BY_USER,
        TRUST_NOT_REQUIRED_BECAUSE_NON_ADMIN,
        TRUSTED_FOR_EVERYBODY;

    }
}

