/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.semanticsearch;

import java.util.List;
import java.util.Map;

public class SemanticSearchFacets {
    public List<Boolean> isInDataCollection = List.of();
    public List<Boolean> partitioned = List.of();
    public List<String> dataSteward = List.of();
    public List<String> projectKey = List.of();
    public List<String> tag = List.of();
    public List<String> datasetType = List.of();
    public List<String> catalog = List.of();
    public List<String> connection = List.of();
    public List<String> connectionType = List.of();
    public List<String> schema = List.of();

    public static SemanticSearchFacets fromLucene(Map<String, List<String>> luceneFacets) {
        SemanticSearchFacets facets = new SemanticSearchFacets();
        luceneFacets.entrySet().stream().filter(e -> e.getValue() != null && !((List)e.getValue()).isEmpty()).filter(e -> FacetKey.FROM_LUCENE.containsKey(e.getKey())).map(e -> Map.entry(FacetKey.FROM_LUCENE.get(e.getKey()), (List)e.getValue())).forEach(e -> {
            switch ((FacetKey)((Object)((Object)e.getKey()))) {
                case IS_IN_DATA_COLLECTION: {
                    facets.isInDataCollection = ((List)e.getValue()).stream().map(SemanticSearchFacets::fromLuceneBoolean).toList();
                    break;
                }
                case PARTITIONED: {
                    facets.partitioned = ((List)e.getValue()).stream().map(SemanticSearchFacets::fromLuceneBoolean).toList();
                    break;
                }
                case DATA_STEWARD: {
                    facets.dataSteward = (List)e.getValue();
                    break;
                }
                case PROJECT_KEY: {
                    facets.projectKey = (List)e.getValue();
                    break;
                }
                case TAG: {
                    facets.tag = (List)e.getValue();
                    break;
                }
                case DATASET_TYPE: {
                    facets.datasetType = (List)e.getValue();
                    break;
                }
                case CATALOG: {
                    facets.catalog = (List)e.getValue();
                    break;
                }
                case SCHEMA: {
                    facets.schema = (List)e.getValue();
                    break;
                }
                case CONNECTION: {
                    facets.connection = (List)e.getValue();
                    break;
                }
                case CONNECTION_TYPE: {
                    facets.connectionType = (List)e.getValue();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported facet key " + String.valueOf(e.getKey()));
                }
            }
        });
        return facets;
    }

    private static boolean fromLuceneBoolean(String value) {
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        throw new IllegalArgumentException("Unexpected value for boolean facet " + value);
    }

    public String toString() {
        return "SemanticSearchFacets{isInDataCollection=" + String.valueOf(this.isInDataCollection) + ", partitioned=" + String.valueOf(this.partitioned) + ", dataSteward=" + this.summarize(this.dataSteward) + ", projectKey=" + this.summarize(this.projectKey) + ", tag=" + this.summarize(this.tag) + ", datasetType=" + this.summarize(this.datasetType) + ", catalog=" + this.summarize(this.catalog) + ", connection=" + this.summarize(this.connection) + ", connectionType=" + this.summarize(this.connectionType) + ", schema=" + this.summarize(this.schema) + "}";
    }

    private String summarize(List<?> list) {
        if (list == null || list.isEmpty()) {
            return "[]";
        }
        if (list.size() <= 3) {
            return list.toString();
        }
        return "[" + String.valueOf(list.get(0)) + ", " + String.valueOf(list.get(1)) + ", " + String.valueOf(list.get(2)) + ", ... (+" + (list.size() - 3) + " more)]";
    }

    private static enum FacetKey {
        IS_IN_DATA_COLLECTION("isInDataCollection"),
        PARTITIONED("partitioned"),
        DATA_STEWARD("dataSteward"),
        PROJECT_KEY("projectKey"),
        TAG("tag"),
        DATASET_TYPE("datasetType"),
        CATALOG("catalog"),
        CONNECTION("connection"),
        CONNECTION_TYPE("connectionType"),
        SCHEMA("schema");

        public final String key;
        private static final Map<String, FacetKey> FROM_LUCENE;

        private FacetKey(String key) {
            this.key = key;
        }

        static {
            FROM_LUCENE = Map.of("isInDataCollection", IS_IN_DATA_COLLECTION, "partitioned", PARTITIONED, "dataSteward", DATA_STEWARD, "projectKey.raw", PROJECT_KEY, "tag.raw", TAG, "type_raw", DATASET_TYPE, "catalog.raw", CATALOG, "connection.raw", CONNECTION, "connectionType", CONNECTION_TYPE, "schema.raw", SCHEMA);
        }
    }
}

