/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.semanticsearch;

import com.dataiku.dip.aigenerations.AISemanticSearchResultRerankingService;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.datacatalog.UIDataCatalog;
import com.dataiku.dip.dataquality.DataQualityDailyStatus;
import com.dataiku.dip.semanticsearch.ItemFacets;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@UIModel
public class SemanticSearchResults {
    public final boolean ok;
    public final String error;
    public final List<AISemanticSearchResultRerankingService.ExplanationSection> explanationSections;
    public final List<Result> results;
    public final LuceneResponseWrapper luceneResults;
    public final AISemanticSearchResultRerankingService.RerankResultsResponse rerankedResults;

    public SemanticSearchResults(LuceneResponseWrapper luceneResults, AISemanticSearchResultRerankingService.RerankResultsResponse rerankResultsResponse, List<SerializedProject> projects, Map<String, UIDataCatalog.DatasetDetails> datasetEnrichments, Map<String, List<String>> tableEnrichments) {
        this.explanationSections = rerankResultsResponse.explanationSections;
        this.results = SemanticSearchResults.buildResults(rerankResultsResponse, projects, datasetEnrichments, tableEnrichments);
        this.luceneResults = luceneResults;
        this.rerankedResults = rerankResultsResponse;
        this.ok = rerankResultsResponse.ok;
        this.error = this.rerankedResults.error;
    }

    public static SemanticSearchResults getEmpty() {
        AISemanticSearchResultRerankingService.RerankResultsResponse rerankResultsResponse = new AISemanticSearchResultRerankingService.RerankResultsResponse();
        rerankResultsResponse.ok = true;
        return new SemanticSearchResults(new LuceneResponseWrapper(), rerankResultsResponse, List.of(), Map.of(), Map.of());
    }

    private static List<Result> buildResults(AISemanticSearchResultRerankingService.RerankResultsResponse rerankResultsResponse, List<SerializedProject> projects, Map<String, UIDataCatalog.DatasetDetails> datasetEnrichments, Map<String, List<String>> tableEnrichments) {
        Map<String, SerializedProject> pMap = projects.stream().collect(Collectors.toMap(p -> p.projectKey, p -> p));
        return rerankResultsResponse.results.stream().filter(r -> r.isRelevant).map(r -> {
            if (r instanceof AISemanticSearchResultRerankingService.RerankedDatasetResult) {
                AISemanticSearchResultRerankingService.RerankedDatasetResult res = (AISemanticSearchResultRerankingService.RerankedDatasetResult)r;
                SerializedProject p = (SerializedProject)pMap.get(res.projectKey);
                String datasetKey = res.projectKey + "." + res.datasetName;
                UIDataCatalog.DatasetDetails enrichment = (UIDataCatalog.DatasetDetails)datasetEnrichments.get(datasetKey);
                return new DatasetResult(res.datasetName, res.projectKey, p == null ? res.projectKey : p.getDisplayName(), res.itemFacets, r.relevance, r.summary, r.usage, enrichment != null ? enrichment.dataQualityStatus : null, enrichment != null ? enrichment.objectAuthorizations : null, enrichment != null ? Long.valueOf(enrichment.lastBuiltOn) : null, enrichment != null ? enrichment.dataCollections : null);
            }
            if (r instanceof AISemanticSearchResultRerankingService.RerankedTableResult) {
                AISemanticSearchResultRerankingService.RerankedTableResult res = (AISemanticSearchResultRerankingService.RerankedTableResult)r;
                List tags = (List)tableEnrichments.get(res.tableId);
                return new TableResult(res.tableId, res.relevance, res.summary, res.usage, res.hit, tags);
            }
            throw new RuntimeException("Failed to build search result");
        }).toList();
    }

    public static class DatasetResult
    extends Result {
        public String type = "dataset";
        public String projectKey;
        public String projectName;
        public ItemFacets facets;
        @UINullable
        public DataQualityDailyStatus dataQualityStatus;
        @UINullable
        public ExposedObjectsService.ObjectAuthorizations objectAuthorizations;
        @UINullable
        public Long lastBuiltOn;
        @UINullable
        public List<TaggableObjectsService.TaggableObjectRefWithName> dataCollections;

        public DatasetResult(String id, String projectKey, String projectName, ItemFacets facets, String relevance, String summary, String usage, DataQualityDailyStatus dataQualityStatus, ExposedObjectsService.ObjectAuthorizations objectAuthorizations, Long lastBuiltOn, List<TaggableObjectsService.TaggableObjectRefWithName> dataCollections) {
            this.id = id;
            this.projectKey = projectKey;
            this.projectName = projectName;
            this.facets = facets;
            this.relevance = relevance;
            this.summary = summary;
            this.usage = usage;
            this.dataQualityStatus = dataQualityStatus;
            this.objectAuthorizations = objectAuthorizations;
            this.lastBuiltOn = lastBuiltOn;
            this.dataCollections = dataCollections;
        }

        public DatasetResult() {
        }
    }

    public static class TableResult
    extends Result {
        public String type = "table";
        public LuceneResponseWrapper.Hit hit;
        @UINullable
        public List<String> tags;

        public TableResult(String id, String relevance, String summary, String usage, LuceneResponseWrapper.Hit hit, List<String> tags) {
            this.id = id;
            this.hit = hit;
            this.relevance = relevance;
            this.summary = summary;
            this.usage = usage;
            this.tags = tags;
        }

        public TableResult() {
        }
    }

    @PolyJSON(value={@Mapping(value=DatasetResult.class, type="dataset"), @Mapping(value=TableResult.class, type="table")})
    public static abstract class Result {
        public String id;
        public String relevance;
        public String summary;
        public String usage;
    }
}

