/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.kernel.master.BuildState;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.fs.FSMovingItem;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFolderSelectedFiles;
import com.dataiku.dip.managedfolder.ManagedFolderSelection;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.partitioning.FileBucket;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.FilePartitioningDetector;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.MimeTypesSecurity;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditTransformer;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.EditableDatasetService;
import com.dataiku.dip.server.datasets.PartitionsDetectionService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.mail.internet.ContentDisposition;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ManagedFoldersController
extends DIPInternalControllerBase {
    @Autowired
    private ManagedFoldersService service;
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private IPermissionsService permService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDBService;
    @Autowired
    private BuildState buildState;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private FutureService futureService;
    private static Logger logger = Logger.getLogger((String)"dku.managedfolders.controller");

    @AuditedCall(value={"msgType", "managedfolder-get", "contextProjectKey", "${projectKey}", "smartId", "${smartId}"}, transformer=SmartIdDecoder.class)
    @RequestMapping(value={"/api/managedfolder/get-for-insight"})
    public void getInsight(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String smartId) throws Exception {
        ManagedFolderForInsight folderForInsight;
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, smartId);
        try (Transaction t = this.transactionService.beginRead();){
            SmartObjectRef ref = this.checkFolderIsViewable(contextProjectKey, loc, req);
            ManagedFolder folder = this.service.getMandatory(ref.getProjectKey(contextProjectKey), ref.objectId);
            folderForInsight = new ManagedFolderForInsight(folder);
            folderForInsight.canDownload = this.permService.hasProjectPrivilege(this.authService.getMandatoryUser(req), contextProjectKey, Privileges.ProjectLevelPrivilegeType.EXPORT_DATASETS_DATA);
            if (folderForInsight.canDownload) {
            } else {
                folderForInsight.params = null;
            }
        }
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)folderForInsight);
    }

    @AuditedCall(value={"msgType", "managedfolder-get", "projectKey", "${projectKey}", "folderId", "${id}"})
    @RequestMapping(value={"/api/managedfolder/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String id) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, id);
            this.projectsService.failIfNoManagedFolderReadUseAccess(authCtx, loc, contextProjectKey);
            ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)this.getSimpleStatus(projectKey, id));
        }
    }

    @AuditedCall(value={"msgType", "managedfolder-get", "projectKey", "${projectKey}", "folderId", "${id}"})
    @RequestMapping(value={"/api/managedfolder/get-with-info"})
    public void getWithInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        ManagedFolderWithStatus managedFolder;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            u = this.authService.getMandatoryUser(req);
            managedFolder = this.getSimpleStatus(projectKey, id);
        }
        InterestsService.TaggableObjectWithUserInterest ret = this.interestsService.getObjectAndUserInterest_NT(u, managedFolder);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "managedfolder-get", "projectKey", "${projectKey}", "folderId", "${id}"})
    @RequestMapping(value={"/api/managedfolder/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        AuthCtx authCtx;
        TaggableObjectsService.TaggableObjectSummary summ = new TaggableObjectsService.TaggableObjectSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            summ.object = this.getSimpleStatus(projectKey, id);
        }
        summ.timeline = this.timelinesService.getObjectTimeline_NT(summ.object.getTaggableType(), projectKey, id, summ.object.creationTag, summ.object.versionTag, 0, 100);
        summ.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summ.object.getTaggableType(), projectKey, id);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)summ);
    }

    @AuditedCall(value={"msgType", "managedfolder-get", "projectKey", "${projectKey}", "folderId", "${id}"})
    @RequestMapping(value={"/api/managedfolder/get-with-status"})
    public void getWithStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        ManagedFolderWithStatus folderWithStatus;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            this.authService.getMandatoryUser(req);
            folderWithStatus = this.getSimpleStatus(projectKey, id);
            folderWithStatus.lastBuild = this.jobsDBService.getLatestBuildForDataset(folderWithStatus.projectKey, folderWithStatus.id);
            folderWithStatus.currentBuildState = this.buildState.getDatasetBuildState(folderWithStatus.projectKey, folderWithStatus.id);
        }
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)folderWithStatus);
    }

    @AuditedCall(value={"msgType", "managedfolder-get", "projectKey", "${projectKey}", "folderId", "${id}"})
    @RequestMapping(value={"/api/managedfolder/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        NavigatorService.ManagedFolderFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, id);
            this.projectsService.failIfNoManagedFolderReadUseAccess(u, loc, contextProjectKey);
            info = this.navigatorService.getManagedFolderFullInfo(loc, contextProjectKey, u);
        }
        this.navigatorService.addInfo_NT(info, u);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    private ManagedFolderWithStatus getSimpleStatus(String projectKey, String id) throws IOException {
        ManagedFolder folder = this.service.getMandatory(projectKey, id);
        ManagedFolderWithStatus folderWithStatus = new ManagedFolderWithStatus(folder);
        ProjectFlowGraph rg = this.graphService.getProjectGraphUnsafe(projectKey);
        FlowComputable computable = rg.getComputable(projectKey + "." + id);
        if (computable != null) {
            logger.info((Object)("Folder " + id + " has ancestors : " + computable.getPredecessors().size()));
            boolean bl = folderWithStatus.buildable = computable.getPredecessors().size() == 1;
            if (folderWithStatus.buildable && computable.getPredecessors().get(0) instanceof FlowRecipe) {
                FlowRecipe recipe = (FlowRecipe)computable.getPredecessors().get(0);
                folderWithStatus.creatingRecipe = new EditableDatasetService.RecipeLink();
                folderWithStatus.creatingRecipe.projectKey = recipe.getProjectKey();
                folderWithStatus.creatingRecipe.name = recipe.getName();
                folderWithStatus.creatingRecipe.type = recipe.getModel().type;
            }
        } else {
            logger.info((Object)("Folder " + id + " has no ancestors"));
            folderWithStatus.buildable = false;
        }
        folderWithStatus.isDirectoryAware = FSProviderFactory.isDirectoryAware(folder.type);
        return folderWithStatus;
    }

    @AuditedCall(value={"msgType", "managedfolders-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/managedfolder/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ManagedFoldersController.writeJSON((HttpServletResponse)resp, this.kernelsManagedFolderService.list(projectKey));
        }
    }

    @AuditedCall(value={"msgType", "managedfolders-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/managedfolder/list-with-accessible"})
    public void listWithAccessible(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        List<ManagedFolder> list;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            list = this.kernelsManagedFolderService.list(projectKey);
            for (DatasetLocUtils.DatasetLoc datasetLoc : this.projectsService.getExposedManagedFolders(projectKey)) {
                ManagedFolder folder = this.service.getOrNull(datasetLoc.getProjectKey(), datasetLoc.getId());
                if (folder == null) continue;
                list.add(folder);
            }
        }
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "managedfolder-list-content", "contextProjectKey", "${projectKey}", "smartId", "${smartId}"}, transformer=SmartIdDecoder.class)
    @RequestMapping(value={"/api/managedfolder/list-fs"}, method={RequestMethod.GET})
    public void listFS(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartId) throws Exception {
        SmartObjectRef ref;
        AuthCtx authCtx;
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, smartId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            ref = this.checkFolderIsViewable(projectKey, loc, req);
        }
        ManagedFolderHandler.ManagedFolderListing listFS = this.kernelsManagedFolderService.handleListFSRequest_NT(authCtx, ref.getProjectKey(projectKey), ref.objectId);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)listFS);
    }

    @AuditedCall(value={"msgType", "managedfolder-browse-path", "projectKey", "${projectKey}", "folderId", "${folderId}", "path", "${path}", "contextProjectKey", "${contextProjectKey}"}, transformer=SmartIdDecoder.class)
    @RequestMapping(value={"/api/managedfolder/browse"}, method={RequestMethod.GET})
    public void browse(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String path, @RequestParam(defaultValue="") String contextProjectKey) throws Exception {
        AuthCtx authCtx;
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, folderId);
        if (StringUtils.isBlank((CharSequence)contextProjectKey)) {
            contextProjectKey = projectKey;
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkFolderIsViewable(contextProjectKey, loc, req);
        }
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)this.service.handleBrowseRequest_NT(projectKey, folderId, path, authCtx));
    }

    @AuditedCall(value={"msgType", "managedfolder-list-content", "contextProjectKey", "${projectKey}", "smartId", "${smartId}"}, transformer=SmartIdDecoder.class)
    @RequestMapping(value={"/api/managedfolder/list-partition-fs"}, method={RequestMethod.GET})
    public void listPartitionFS(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartId, @RequestParam(required=false) String partition) throws Exception {
        SmartObjectRef ref;
        AuthCtx authCtx;
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, smartId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            ref = this.checkFolderIsViewable(projectKey, loc, req);
        }
        ManagedFolderHandler.ManagedFolderListing contents = this.kernelsManagedFolderService.handleListFSRequest_NT(authCtx, ref.getProjectKey(projectKey), ref.objectId, partition, true);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)contents);
    }

    @AuditedCall(value={"msgType", "managedfolder-download", "contextProjectKey", "${contextProjectKey}", "projectKey", "${projectKey}", "folderId", "${obdId}", "path", "${path}"})
    @RequestMapping(value={"/api/managedfolder/download-item"}, method={RequestMethod.GET})
    public void downloadItem(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String obdId, @RequestParam String path) throws Exception {
        AuthCtx authCtx = this.checkAuthorizedToViewAndDownloadNoXSRF(req, contextProjectKey, projectKey, obdId);
        this.kernelsManagedFolderService.handleDownloadRequest_NT(projectKey, obdId, path, resp, authCtx);
    }

    @AuditedCall(value={"msgType", "managedfolder-download-folder", "projectKey", "${projectKey}", "folderId", "${obdId}"})
    @RequestMapping(value={"/api/managedfolder/download-folder"}, method={RequestMethod.GET})
    public void downloadFolder(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String obdId, @RequestParam String path) throws Exception {
        AuthCtx authCtx = this.checkAuthorizedToViewAndDownloadNoXSRF(req, contextProjectKey, projectKey, obdId);
        this.kernelsManagedFolderService.handleDownloadFolderRequest_NT(projectKey, obdId, path, resp, authCtx);
    }

    @AuditedCall(value={"msgType", "managedfolder-start-export", "projectKey", "${projectKey}", "folderId", "${obdId}", "path", "${path}"})
    @RequestMapping(value={"/api/managedfolder/start-export"}, method={RequestMethod.POST})
    public void startExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String obdId, @RequestParam String path) throws Exception {
        AuthCtx authCtx = this.checkAuthorizedToViewAndDownloadNoXSRF(req, contextProjectKey, projectKey, obdId);
        ManagedFolderSelectedFiles selectedFiles = ManagedFolderSelectedFiles.wholeFolder(path);
        FutureResponse<String> fr = this.kernelsManagedFolderService.prepareDownloadZip(projectKey, obdId, selectedFiles, authCtx);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, fr);
    }

    @AuditedCall(value={"msgType", "managedfolder-start-export-selected-files", "projectKey", "${projectKey}", "folderId", "${obdId}", "paths", "${paths}"})
    @RequestMapping(value={"/api/managedfolder/start-export-selected-files"}, method={RequestMethod.POST})
    public void startExportSelectedFiles(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String obdId, @RequestParam List<String> paths) throws Exception {
        AuthCtx authCtx = this.checkAuthorizedToViewAndDownloadNoXSRF(req, contextProjectKey, projectKey, obdId);
        ManagedFolderSelectedFiles selectedFiles = ManagedFolderSelectedFiles.childFilesAndSubFolders(paths);
        FutureResponse<String> fr = this.kernelsManagedFolderService.prepareDownloadZip(projectKey, obdId, selectedFiles, authCtx);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, fr);
    }

    private AuthCtx checkAuthorizedToViewAndDownloadNoXSRF(HttpServletRequest req, String contextProjectKey, String projectKey, String obdId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, obdId);
            this.checkFolderIsViewableAndDownloadable(contextProjectKey, loc, req);
        }
        return authCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/api/managedfolder/download-export"}, method={RequestMethod.GET})
    public void downloadExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String obdId, @RequestParam String exportId) throws Exception {
        String fileName;
        try (Transaction t = this.transactionService.beginRead();){
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, obdId);
            this.checkFolderIsViewableAndDownloadable(contextProjectKey, loc, req);
            ManagedFolder mf = this.service.getMandatoryUnsafe(projectKey, obdId);
            fileName = mf.name;
        }
        File f = KernelsManagedFolderService.getTargetFile(projectKey, obdId, exportId);
        try {
            resp.setStatus(200);
            resp.setContentType("application/zip");
            ContentDisposition contentDisposition = new ContentDisposition();
            contentDisposition.setDisposition("attachment");
            contentDisposition.setParameter("filename", fileName + ".zip");
            resp.setHeader("Content-Disposition", contentDisposition.toString());
            resp.setHeader("Content-Length", "" + f.length());
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));){
                IOUtils.copy((InputStream)bis, (OutputStream)resp.getOutputStream());
            }
        }
        finally {
            DKUFileUtils.forceDelete((File)f);
        }
    }

    @AuditedCall(value={"msgType", "managedfolder-delete-items", "projectKey", "${projectKey}", "folderId", "${odbId}", "paths", "${itemPaths}"})
    @RequestMapping(value={"/api/managedfolder/delete-items"})
    public void deleteItems(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String odbId, @RequestParam String itemPaths) throws Exception {
        AuthCtx authCtx;
        String[] paths = (String[])JSON.parse((String)itemPaths, String[].class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        FutureResponse<KernelsManagedFolderService.FSDeleteResult> delete = this.kernelsManagedFolderService.handleDeleteItemsRequest(projectKey, odbId, paths, authCtx);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, delete);
    }

    @AuditedCall(value={"msgType", "managedfolder-delete-item", "projectKey", "${projectKey}", "folderId", "${odbId}", "path", "${itemPath}", "isDirectory", "${isDirectory}"})
    @RequestMapping(value={"/api/managedfolder/delete-item"}, method={RequestMethod.GET})
    public void deleteItem(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String odbId, @RequestParam String itemPath, @RequestParam boolean isDirectory) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        String[] paths = new String[]{itemPath};
        FSProvider.FSBrowseStrategy strategy = isDirectory ? FSProvider.FSBrowseStrategy.DIRECTORY : FSProvider.FSBrowseStrategy.FILE;
        FutureResponse<KernelsManagedFolderService.FSDeleteResult> delete = this.kernelsManagedFolderService.handleDeleteItemsRequest(projectKey, odbId, paths, authCtx, strategy);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, delete);
    }

    @AuditedCall(value={"msgType", "managedfolder-rename-item", "projectKey", "${projectKey}", "folderId", "${odbId}", "path", "${itemPath}", "isDirectory", "${isDirectory}", "newName", "${newName}"})
    @RequestMapping(value={"/api/managedfolder/rename-item"}, method={RequestMethod.GET})
    public void renameItem(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String odbId, @RequestParam String itemPath, @RequestParam boolean isDirectory, @RequestParam String newName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        FutureResponse<ManagedFoldersService.FSMoveResult> rename = this.service.handleRenameItemRequest(projectKey, odbId, itemPath, isDirectory, newName, authCtx);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)this.futureService.waitForFinalResponse(rename));
    }

    @AuditedCall(value={"msgType", "managedfolder-move-items", "projectKey", "${projectKey}", "folderId", "${odbId}", "items", "${items}"})
    @RequestMapping(value={"/api/managedfolder/move-items"}, method={RequestMethod.POST})
    public void moveItems(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String odbId, @RequestParam String items) throws Exception {
        AuthCtx authCtx;
        FSMovingItem[] itemsToMove = (FSMovingItem[])JSON.parse((String)items, FSMovingItem[].class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        FutureResponse<ManagedFoldersService.FSMoveResult> res = this.service.handleMoveItemsRequest(projectKey, odbId, itemsToMove, authCtx);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, res);
    }

    @AuditInline
    @RequestMapping(value={"/api/managedfolder/save"}, method={RequestMethod.POST})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String data, @RequestParam(required=false) String saveInfo) throws Exception {
        ManagedFolder mf = (ManagedFolder)JSON.parse((String)data, ManagedFolder.class);
        TaggableObjectsService.TaggableObjectSaveInfo si = TaggableObjectsService.TaggableObjectSaveInfo.parse(saveInfo);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, mf.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ManagedFolder ret = this.service.save(mf, false, si.summaryOnly);
            ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)ret);
            if (si.summaryOnly) {
                t.commit("Updated summary for folder: " + mf.projectKey + "." + mf.name + " (id: " + mf.id + ")", 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
            } else {
                t.commit("Saved settings of folder: " + mf.projectKey + "." + mf.name + " (id: " + mf.id + ")");
            }
            this.auditTrailService.generic("managedfolder-save").with("projectKey", mf.projectKey).with("folderId", mf.id).emit();
        }
    }

    @AuditedCall(value={"msgType", "managedfolder-rename", "projectKey", "${projectKey}", "folderId", "${folderId}", "newName", "${newName}"})
    @RequestMapping(value={"/api/managedfolder/rename"}, method={RequestMethod.POST})
    public void rename(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String newName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.service.rename(projectKey, folderId, newName);
            t.commit("Renamed folder to " + newName + " (id: " + folderId + ")");
        }
    }

    @AuditedCall(value={"msgType", "folder-save-meta", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/save-sampling"})
    public void saveSampling(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String data) throws Exception {
        ManagedFolderSelection selection = (ManagedFolderSelection)JSON.parse((String)data, ManagedFolderSelection.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.service.setExploreSettings(projectKey, folderId, selection);
            t.commit("Set sampling settings of " + folderId);
        }
    }

    @AuditedCall(value={"msgType", "managedfolder-create-folder", "projectKey", "${projectKey}", "folderId", "${folderId}", "path", "${path}"})
    @RequestMapping(value={"/api/managedfolder/create-sub-folder"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void createSubFolder(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String path) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.service.handleCreateSubFolderRequest_NT(projectKey, folderId, path, authCtx);
    }

    @AuditedCall(value={"msgType", "managedfolder-upload", "projectKey", "${projectKey}", "folderId", "${odbId}"})
    @RequestMapping(value={"/api/managedfolder/upload-item"}, method={RequestMethod.POST})
    public void uploadItem(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String odbId, @RequestParam String path, @RequestParam(value="file") MultipartFile filePart, @RequestParam boolean forceUpload) throws Exception {
        ManagedFolder mf;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            mf = this.service.getMandatoryUnsafe(projectKey, odbId);
        }
        ManagedFolderHandler.ManagedFolderListingItem uploadedItem = this.kernelsManagedFolderService.handleUploadRequest_NT(projectKey, odbId, filePart.getInputStream(), path, forceUpload, authCtx);
        try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
            ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)handler.browse(uploadedItem.path));
        }
    }

    @AuditedCall(value={"msgType", "managedfolder-preview-item", "contextProjectKey", "${projectKey}", "smartId", "${smartId}", "itemPath", "${itemPath}"}, transformer=SmartIdDecoder.class)
    @RequestMapping(value={"/api/managedfolder/preview-item"}, method={RequestMethod.GET})
    public void previewItem(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String smartId, @RequestParam String itemPath) throws Exception {
        SmartObjectRef ref;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, smartId);
            ref = this.checkFolderIsViewable(contextProjectKey, loc, req);
        }
        ManagedFoldersService.ItemPreview preview = this.service.handlePreviewRequest_NT(ref.getProjectKey(projectKey), ref.objectId, itemPath, user);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)preview);
    }

    @AuditedCall(value={"msgType", "managedfolder-view-content", "contextProjectKey", "${projectKey}", "smartId", "${smartId}", "path", "${itemPath}"}, transformer=SmartIdDecoder.class)
    @RequestMapping(value={"/api/managedfolder/get-item-info"}, method={RequestMethod.GET})
    public void getItemInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String smartId, @RequestParam String itemPath) throws Exception {
        SmartObjectRef ref;
        AuthCtx user;
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, smartId);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            ref = this.checkFolderIsViewable(projectKey, loc, req);
        }
        FSPathOrDirectory itemInfo = this.service.getItemInfo_NT(ref.getProjectKey(projectKey), ref.objectId, itemPath, user);
        if (itemInfo == null) {
            throw new FileNotFoundException("No file found at path " + itemPath);
        }
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)itemInfo);
    }

    @AuditedCall(value={"msgType", "managedfolder-view-content", "contextProjectKey", "${contextProjectKey}", "projectKey", "${projectKey}", "folderId", "${odbId}", "path", "${itemPath}"})
    @RequestMapping(value={"/api/managedfolder/preview-image"}, method={RequestMethod.GET})
    public void previewImage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String contextProjectKey, @RequestParam String projectKey, @RequestParam String odbId, @RequestParam String itemPath, @RequestParam String contentType) throws Exception {
        SmartObjectRef ref;
        AuthCtx authCtx;
        MimeTypesSecurity.failIfNotSafeImageOrPdfType((String)contentType);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
            AnyLoc loc = AnyLoc.resolveSmart(projectKey, odbId);
            ref = this.checkFullFolderIsViewableNoXSRF(contextProjectKey, loc, req);
        }
        this.service.handlePreviewImageRequest_NT(ref.getProjectKey(projectKey), ref.objectId, itemPath, authCtx, contentType, resp);
    }

    @AuditedCall(value={"msgType", "managedfolder-decompress-content", "projectKey", "${projectKey}", "folderId", "${odbId}", "path", "${itemPath}"})
    @RequestMapping(value={"/api/managedfolder/decompress-item"}, method={RequestMethod.GET})
    public void decompress(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String odbId, @RequestParam String itemPath) throws Exception {
        SmartObjectRef ref;
        AuthCtx authCtx;
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, odbId);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            ref = this.checkFolderIsViewable(projectKey, loc, req);
        }
        this.kernelsManagedFolderService.handleDecompressRequest_NT(ref.getProjectKey(projectKey), ref.objectId, itemPath, authCtx);
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)this.service.handleBrowseRequest_NT(ref.getProjectKey(projectKey), ref.objectId, PathUtils.getParent((String)itemPath), authCtx));
    }

    private void checkDataExportEnabled() throws Exception {
        Params params = ApplicationConfigurator.getParams();
        if (params.getBoolParam("dku.exports.disableAllDataExports", false) || params.getBoolParam("dku.exports.disableAllExports", false)) {
            throw new UnauthorizedException("Data exports have been forbidden by your administrator", "data-export-forbidden");
        }
    }

    private SmartObjectRef checkFolderIsViewable(String contextProjectKey, AnyLoc loc, HttpServletRequest req) throws Exception {
        return this.checkFolderPerms(contextProjectKey, loc, req, false, true);
    }

    private SmartObjectRef checkFullFolderIsViewableNoXSRF(String contextProjectKey, AnyLoc loc, HttpServletRequest req) throws Exception {
        return this.checkFolderPerms(contextProjectKey, loc, req, false, false);
    }

    private SmartObjectRef checkFolderIsViewableAndDownloadable(String contextProjectKey, AnyLoc loc, HttpServletRequest req) throws Exception {
        this.checkDataExportEnabled();
        return this.checkFolderPerms(contextProjectKey, loc, req, true, false);
    }

    private SmartObjectRef checkFolderPerms(String contextProjectKey, AnyLoc loc, HttpServletRequest req, boolean needsDownload, boolean hasXSRF) throws Exception {
        SmartObjectRef ref = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.MANAGED_FOLDER, loc.getSmartName(contextProjectKey));
        AuthCtx u = hasXSRF ? this.authService.getMandatoryUser(req) : this.authService.getMandatoryUserNoXSRF(req);
        this.projectsService.failIfNoDashboardReadPermission(u, ref, contextProjectKey);
        if (needsDownload) {
            this.permService.checkProjectPrivileges(u, contextProjectKey, Privileges.ProjectLevelPrivilegeType.EXPORT_DATASETS_DATA);
        }
        return ref;
    }

    @AuditInline
    @RequestMapping(value={"/api/managedfolder/detect-partitioning"})
    public void detectPartitioning(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        ManagedFolder odb;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
            odb = (ManagedFolder)JSON.parse((String)data, ManagedFolder.class);
        }
        ManagedFolderHandler.ManagedFolderListing contents = this.kernelsManagedFolderService.handleListFSRequest_NT(authCtx, odb, Partition.newNP(), false);
        ArrayList paths = Lists.newArrayList();
        for (ManagedFolderHandler.ManagedFolderListingItem item : contents.items) {
            paths.add(new FSPath(item.path, item.size, item.lastModified));
        }
        PartitionsDetectionService.FilePartitioningTestResult ret = new PartitionsDetectionService.FilePartitioningTestResult();
        PartitioningScheme detectedScheme = FilePartitioningDetector.autodetect(paths);
        if (detectedScheme != null) {
            ret.detectedScheme = detectedScheme;
        }
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)ret);
        this.auditTrailService.generic("folder-detect-partitioning").with("projectKey", odb.getProjectKey()).with("folderId", odb.getId()).emit();
    }

    @AuditInline
    @RequestMapping(value={"/api/managedfolder/test-partitioning"})
    public void testPartitioning(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="data") String data) throws Exception {
        ManagedFolder odb;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkReadProjectContentAllowed(this.authService.getMandatoryUser(req));
            odb = (ManagedFolder)JSON.parse((String)data, ManagedFolder.class);
        }
        ManagedFolderHandler.ManagedFolderListing contents = this.kernelsManagedFolderService.handleListFSRequest_NT(authCtx, odb, Partition.newNP(), false);
        ArrayList paths = Lists.newArrayList();
        for (ManagedFolderHandler.ManagedFolderListingItem item : contents.items) {
            paths.add(new FSPath(item.path, item.size, item.lastModified));
        }
        HashSet<String> matchedFilePaths = new HashSet<String>();
        PartitionsDetectionService.FilePartitioningTestResult ret = new PartitionsDetectionService.FilePartitioningTestResult();
        if (odb.partitioning != null) {
            FilePartitioner partitioner = new FilePartitioner(odb.partitioning);
            ret.configuredSchemeContent = new HashMap<String, PartitionsDetectionService.PartitionContent>();
            for (FilePartition fp : partitioner.getPartitionsFromFiles(paths)) {
                PartitionsDetectionService.PartitionContent out = new PartitionsDetectionService.PartitionContent();
                out.id = fp.id();
                out.buckets = fp.buckets.size();
                for (FileBucket fb : fp.buckets) {
                    for (FSPath path : fb.paths) {
                        ++out.nbFiles;
                        out.totalSize += path.getSize();
                        out.filePaths.add(path.path());
                        matchedFilePaths.add(path.path());
                    }
                }
                ret.configuredSchemeContent.put(out.id, out);
            }
        }
        for (FSPath path : paths) {
            if (matchedFilePaths.contains(path.path())) continue;
            ret.unmatchedFilesPaths.add(path.path());
        }
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)ret);
        this.auditTrailService.generic("folder-test-partitioning").with("projectKey", odb.getProjectKey()).with("folderId", odb.getId()).emit();
    }

    @AuditedCall(value={"msgType", "folder-save-meta", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/set-explore-on-single-partition"})
    public void setExploreOnSinglePartition(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam String partitionId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.service.setExploreOnSinglePartition(projectKey, folderId, partitionId);
            t.commit("Set explore sample of " + folderId + "  to partition " + partitionId);
        }
    }

    @AuditedCall(value={"msgType", "folder-read-meta", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/managedfolder/list-partitions-with-name"})
    public void listPartitions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId) throws Exception {
        ManagedFolder folder = null;
        AuthCtx liu = null;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(liu, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            folder = this.service.getMandatory(projectKey, folderId);
        }
        ArrayList list = Lists.newArrayList();
        try (ManagedFolderHandler dh = (ManagedFolderHandler)folder.buildHandler(liu);){
            for (Partition p : PartitioningUtils.sort(dh.listPartitions(), true)) {
                list.add(p.id());
            }
        }
        ManagedFoldersController.writeJSON((HttpServletResponse)resp, (Object)list);
    }

    public static class ManagedFolderForInsight
    extends ManagedFolder {
        public boolean canDownload;

        ManagedFolderForInsight(ManagedFolder other) {
            super(other.projectKey, other.id);
            this.description = other.description;
            this.name = other.name;
            this.contentType = other.contentType;
            this.shortDesc = other.shortDesc;
            this.checklists = other.checklists;
            this.creationTag = other.creationTag;
            this.versionTag = other.versionTag;
            this.tags = other.tags;
            this.partitioning = other.partitioning;
            this.selection = other.selection;
        }
    }

    public static class ManagedFolderWithStatus
    extends ManagedFolder {
        public boolean buildable;
        public boolean canDownload;
        EditableDatasetService.RecipeLink creatingRecipe;
        ReadOnlyJobsInternalDB.DatasetBuild lastBuild;
        BuildState.DatasetBuildState currentBuildState;
        public boolean isDirectoryAware;

        ManagedFolderWithStatus(ManagedFolder other) {
            super(other);
        }
    }

    public static class SmartIdDecoder
    implements AuditTransformer {
        public void transform(AuditObj obj) {
            if (obj.has(new String[]{"smartId", "contextProjectKey"})) {
                AnyLoc loc = AnyLoc.resolveSmart(obj.get().get("contextProjectKey").getAsString(), obj.get().get("smartId").getAsString());
                obj.with("projectKey", loc.getProjectKey());
                obj.with("folderId", loc.getId());
            }
        }
    }
}

