/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.aigenerations.AISemanticSearchQueryAugmentationService;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.semanticsearch.SemanticSearchMessage;
import com.dataiku.dip.semanticsearch.SemanticSearchResults;
import com.dataiku.dip.semanticsearch.SemanticSearchService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.j2ts.annotations.UIModel;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/semantic-search"})
public class SemanticSearchController
extends DIPInternalControllerBase {
    @Autowired
    private SemanticSearchService semanticSearchService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;

    @RequestMapping(value={"/dip-properties"}, method={RequestMethod.GET})
    @ResponseBody
    public SemanticSearchDipProperties getDipProperties() {
        return new SemanticSearchDipProperties(AIFeaturesUtil.SEMANTIC_SEARCH_MAX_QUERY_CHARS);
    }

    @AuditedCall(value={"msgType", "semantic-search-augment-query", "query", "${query}", "conversationId", "${conversationId}"})
    @RequestMapping(value={"/augment-query"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AISemanticSearchQueryAugmentationService.AugmentQueryResponse> augmentQuery(HttpServletRequest req, @RequestParam String query, @RequestParam List<SemanticSearchMessage> previousMessages, @RequestParam String conversationId) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.semanticSearchService.augmentQuery(user, query, previousMessages, conversationId);
    }

    @AuditedCall(value={"msgType", "semantic-search-search", "query", "${query}", "conversationId", "${conversationId}", "extractedKeywords", "${extractedKeywords"})
    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<SemanticSearchResults> search(HttpServletRequest req, @RequestParam String query, @RequestParam String conversationId, @RequestParam AISemanticSearchQueryAugmentationService.KeywordExtractionResponse extractedKeywords) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.semanticSearchService.search(user, query, conversationId, extractedKeywords);
    }

    @UIModel
    public static class SemanticSearchDipProperties {
        public int maxQueryChars;

        public SemanticSearchDipProperties(int maxQueryChars) {
            this.maxQueryChars = maxQueryChars;
        }
    }
}

