/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DatasetReadAPIUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.api.datasets");

    public static FormatDef getFormatDef(String format, JsonObject formatParams) {
        FormatDef ret = new FormatDef();
        if (StringUtils.isBlank((String)format)) {
            throw ErrorContext.iae((String)"Format name is mandatory");
        }
        switch (format) {
            case "tsv-excel-noheader": {
                ret.formatMeta = FormatFactory.getMeta("csv");
                CSVFormatConfig cf = CSVFormatConfig.getStandardTabExcelFormat();
                cf.parseHeaderRow = false;
                ret.params = cf;
                return ret;
            }
            case "tsv-excel-noheader-fast-unsafe": {
                ret.formatMeta = FormatFactory.getMeta("csv");
                CSVFormatConfig cf = CSVFormatConfig.getStandardTabExcelFormat();
                cf.parseHeaderRow = false;
                cf.normalizeDoubles = false;
                cf.writeDataTypeMismatchBehavior = StorageTypeVerifier.DataTypeMismatchBehavior.IGNORE_SILENT;
                ret.params = cf;
                return ret;
            }
            case "tsv-excel-header": {
                ret.formatMeta = FormatFactory.getMeta("csv");
                CSVFormatConfig cf = CSVFormatConfig.getStandardTabExcelFormat();
                cf.parseHeaderRow = true;
                ret.params = cf;
                return ret;
            }
        }
        ret.formatMeta = FormatFactory.getMeta(format);
        if (formatParams != null) {
            logger.info((Object)("Build format params from:" + JSON.logExceptRecursive((Object)formatParams, Collections.singleton("password"))));
            ret.params = (FormatParams)JSON.parse((String)JSON.json((Object)formatParams), ret.formatMeta.paramsClass());
        } else {
            logger.info((Object)("Use default format params for " + format));
            try {
                ret.params = ret.formatMeta.paramsClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new Error("The impossible happened", e);
            }
        }
        return ret;
    }

    public static SamplingParam samplingParamFromString(String sampling) {
        SamplingParam samplingParam;
        if (!StringUtils.isBlank((String)sampling)) {
            samplingParam = (SamplingParam)JSON.parse((String)sampling, SamplingParam.class);
            if (samplingParam.samplingMethod == null) {
                samplingParam.samplingMethod = SamplingParam.SamplingMethod.HEAD_SEQUENTIAL;
            }
        } else {
            samplingParam = SamplingParam.newFull();
        }
        return samplingParam;
    }

    public static List<String> columnsListFromString(String columns) {
        if (!StringUtils.isBlank((String)columns)) {
            Object[] colnames = columns.split(",");
            return Lists.newArrayList((Object[])colnames);
        }
        return null;
    }

    public static JsonObject formatParamsFromString(String formatParams) {
        if (!StringUtils.isBlank((String)formatParams)) {
            return (JsonObject)JSON.parse((String)formatParams, JsonObject.class);
        }
        return null;
    }

    public static class FormatDef {
        public FormatMeta<?, ?> formatMeta;
        public FormatParams params;
    }

    public static class MemoryJSONResult {
        List<String> columns = new ArrayList<String>();
        List<String[]> rows = new ArrayList<String[]>();
    }

    public static class DatasetStreamingRequestSettings {
        public String format;
        public JsonObject formatParams;
        public SamplingParam sampling;
        public List<String> columns;
        public String partitions;
        public String filterExpression;
        public String readSessionId;
    }
}

