/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ClustersIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TicketAuthService authService;

    @AuditedCall(value={"msgType", "read-hadoop-conf"})
    @RequestMapping(value={"/api/tintercom/clusters/read-hadoop-conf"})
    public void readHadoopConf(HttpServletRequest req, HttpServletResponse resp, @RequestParam String confDirPath, @RequestParam String extraResources) throws Exception {
        try (APITicketService.TicketUsage tu = this.authService.getAndUseMandTicket(req);){
            List resources = (List)JSON.parse((String)extraResources, (TypeToken)new TypeToken<List<String>>(){});
            ArrayList cmd = Lists.newArrayList((Object[])new String[]{"hadoop", "com.dataiku.dip.cli.internalcmd.DumpHadoopConfigurationAsTSV"});
            cmd.addAll(resources);
            ArrayList hadoopClassPathChunks = Lists.newArrayList();
            if (StringUtils.isNotBlank((String)System.getenv("HADOOP_CLASSPATH"))) {
                hadoopClassPathChunks.add(System.getenv("HADOOP_CLASSPATH"));
            }
            hadoopClassPathChunks.add(new File(ApplicationConfigurator.getInstallFolder(), "dist/*").getAbsolutePath());
            hadoopClassPathChunks.add(new File(ApplicationConfigurator.getInstallFolder(), "lib/ivy/common-run/*").getAbsolutePath());
            resp.setContentType("text/plain; charset=UTF-8");
            resp.setStatus(200);
            int rv = new DKUtils.ExecBuilder().withArgs((List)cmd).withEnv("HADOOP_CONF_DIR", confDirPath).withEnv("HADOOP_CLASSPATH", Joiner.on((String)":").join((Iterable)hadoopClassPathChunks)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.OutputStreamSubscription((OutputStream)resp.getOutputStream(), true)).exec();
            if (rv != 0) {
                throw new Exception("Hadoop configuration dump tool failed. Return code : " + rv);
            }
        }
    }
}

