/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.server.recipes.WindowQueryGenerator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WindowRecipeService {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    private VariablesService variablesService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.window");

    public WindowRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        WindowRecipePayloadParams params = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty parameters");
        this.expandParams(params, sr.projectKey);
        return params;
    }

    private void expandParams(WindowRecipePayloadParams params, String projectKey) {
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        FilterDescUtils.expand(params.preFilter, vc);
        FilterDescUtils.expand(params.computedColumns, vc);
        FilterDescUtils.expand(params.postFilter, vc);
        for (WindowRecipePayloadParams.WindowValue val : params.values) {
            if (val == null || val.column != null || val.customExpr == null) continue;
            val.customExpr = vc.expand(val.customExpr);
        }
    }

    public String generateSQL(JobActivity activity, SQLDialect dialect, WindowRecipePayloadParams params, boolean forceOutputColumnNameOverride) throws IOException {
        Partition part;
        Dataset outputDS;
        List<Partition> parts;
        Dataset source = activity.getSubgraph().getSingleSourceDataset().getMandatory(this.datasetsDAO);
        List<Partition> sourcePartitions = null;
        PartitioningScheme sourcePartitionScheme = null;
        PartitioningScheme targetPartitionScheme = null;
        if (MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, params.engineParams) && (parts = activity.getSubgraph().getSourcePartitions(activity.getSubgraph().getSingleSourceDataset())) != null && parts.size() > 0 && !parts.get(0).isAll() && !parts.get(0).isNP() && source.getPartitioningSchema().isPartitioned()) {
            sourcePartitions = parts;
            sourcePartitionScheme = source.getPartitioningSchema();
        }
        if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(outputDS = activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO)) && (part = activity.getSubgraph().getTargetPartition(activity.getSubgraph().getSingleTargetDataset())) != null && !part.isNP() && !part.isAll() && outputDS.getPartitioningSchema().isPartitioned()) {
            targetPartitionScheme = outputDS.getPartitioningSchema();
        }
        return this.generateSQL(dialect, params, source, outputDS, sourcePartitionScheme, sourcePartitions, targetPartitionScheme, forceOutputColumnNameOverride);
    }

    public String generateSQLIgnorePartitions(SQLDialect dialect, WindowRecipePayloadParams params, Dataset source, Dataset target, boolean forceOutputColumnNameOverride) throws IOException {
        return this.generateSQL(dialect, params, source, target, null, null, null, forceOutputColumnNameOverride);
    }

    public String generateSQL(SQLDialect dialect, WindowRecipePayloadParams params, Dataset source, Dataset target, PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme, boolean forceOutputColumnNameOverride) throws IOException {
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, params.engineParams);
        WindowQueryGenerator sqlGenerator = new WindowQueryGenerator(params, source, table, target);
        sqlGenerator.setPartitioning(sourcePartitionScheme, sourcePartitions, targetPartitionScheme);
        return sqlGenerator.generateSQL(dialect, forceOutputColumnNameOverride);
    }

    public Schema getOutputSchemaBeforeOverride(Dataset inputDS, WindowRecipePayloadParams params, boolean lowerCaseColumnsNames, SQLDialect dialect) {
        Schema schema = this.getBaseOutputSchema(inputDS, params, dialect);
        if (lowerCaseColumnsNames) {
            SchemaUtils.lowerCase(schema);
        }
        return schema;
    }

    public Schema getOutputSchemaAfterOverride(Dataset inputDS, WindowRecipePayloadParams params, boolean lowerCaseColumnsNames, SQLDialect dialect) {
        Schema schema = this.getOutputSchemaBeforeOverride(inputDS, params, lowerCaseColumnsNames, dialect);
        SchemaUtils.applyOverrides(schema, params.outputColumnNameOverrides, lowerCaseColumnsNames);
        return schema;
    }

    private Schema getBaseOutputSchema(Dataset inputDS, WindowRecipePayloadParams params, SQLDialect dialect) {
        Schema inputSchema = inputDS.getSchema();
        Schema outputSchema = new Schema();
        SchemaUtils.SafeColumnIdentifierSuffixer safeSuffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()), inputDS.getSchema());
        List<WindowRecipePayloadParams.WindowValue> resolvedWindowValues = params.getResolvedWindowValues(inputSchema);
        for (WindowRecipePayloadParams.WindowValue val : resolvedWindowValues) {
            if (val.column == null || !val.value) continue;
            SchemaColumn schemaCol = ExpressionUtils.getSchemaColumn(val.column, inputSchema, params.computedColumns);
            outputSchema.addColumn(schemaCol);
        }
        for (WindowRecipePayloadParams.WindowDesc window : params.windows) {
            Object prefix = StringUtils.isBlank((String)window.prefix) ? "" : window.prefix + "_";
            for (WindowRecipePayloadParams.WindowValue val : resolvedWindowValues) {
                if (val.column != null) {
                    if (!val.hasAnyAggr(false)) continue;
                    SchemaColumn inputSchemaColumn = ExpressionUtils.getSchemaColumn(val.column, inputSchema, params.computedColumns);
                    for (SchemaColumn sc : val.getDerivedColumns(inputSchemaColumn, safeSuffixer, (String)prefix, dialect)) {
                        outputSchema.addColumn(sc);
                    }
                    continue;
                }
                outputSchema.addColumn((String)prefix + val.customName, val.type != null ? val.type : Type.DOUBLE);
            }
            if (params.rank) {
                outputSchema.addColumn((String)prefix + "rank", Type.BIGINT);
            }
            if (params.denseRank) {
                outputSchema.addColumn((String)prefix + "denserank", Type.BIGINT);
            }
            if (params.rowNumber) {
                outputSchema.addColumn((String)prefix + "rownumber", Type.BIGINT);
            }
            if (params.cumeDist) {
                outputSchema.addColumn((String)prefix + "cumedist", Type.DOUBLE);
            }
            if (!params.ntile) continue;
            for (Object ntileValue : (Object)params.getNtileValues()) {
                outputSchema.addColumn((String)prefix + "ntile" + (int)ntileValue, Type.BIGINT);
            }
        }
        return outputSchema;
    }
}

