/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.activity.DSSUsageStatsInternalDB;
import com.dataiku.dip.activity.IDSSUsageStatsInternalDB;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.ProjectTransactionCommitedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.util.TimeRangeSplitter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.LazyHashMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserActivityService {
    @Autowired
    private DSSUsageStatsInternalDB dbService;
    @Autowired
    private PubSubService pubSub;
    LazyHashMap<String, UserCounters> users = new LazyHashMap(UserCounters.class);
    private final ScheduledExecutorService sched = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("UserActivityService-%d").setDaemon(true).build());
    private static DKULogger logger = DKULogger.getLogger((String)"dku.activity.users");

    private void installEventHandlers() {
        this.pubSub.subscribe("project-transaction-commmited", (DSSEventListener)new DSSEventListener<ProjectTransactionCommitedEvent>(){

            public void on(ProjectTransactionCommitedEvent evt) {
                Calendar c2 = Calendar.getInstance();
                c2.set(12, 0);
                c2.set(13, 0);
                c2.set(14, 0);
                try {
                    UserActivityService.this.dbService.storeProjectSave(evt.projectKey, evt.user, c2.getTimeInMillis());
                }
                catch (SQLException e) {
                    logger.warn((Object)"Failed to record project activity", (Throwable)e);
                }
            }
        });
    }

    private void stopAllForUser(String login) {
        UserCounters uc = (UserCounters)this.users.getOrCreate((Object)login);
        uc.global.stop();
        for (UserCounter projectCounter : uc.projects.values()) {
            projectCounter.stop();
        }
        if (logger.isTraceEnabled()) {
            logger.traceV("After stopAll for " + login + " userCounters: " + JSON.log((Object)uc), new Object[0]);
        }
    }

    public synchronized void startUserGlobalTimer(String login) {
        logger.trace(() -> "Starting global timer for " + login);
        this.stopAllForUser(login);
        UserCounters uc = (UserCounters)this.users.getOrCreate((Object)login);
        uc.global.startIfNotStarted();
        if (logger.isTraceEnabled()) {
            logger.traceV("After startGlobal for " + login + " userCounters: " + JSON.log((Object)uc), new Object[0]);
        }
    }

    public synchronized void startUserTimer(String login, String projectKey) {
        logger.trace(() -> "Starting project timer for " + login + " in " + projectKey);
        this.stopAllForUser(login);
        UserCounters uc = (UserCounters)this.users.getOrCreate((Object)login);
        UserCounter projectCounter = (UserCounter)uc.projects.getOrCreate((Object)projectKey);
        projectCounter.startIfNotStarted();
        if (logger.isTraceEnabled()) {
            logger.traceV("After startProject(" + projectKey + ") for " + login + " userCounters: " + JSON.log((Object)uc), new Object[0]);
        }
    }

    public synchronized void stopUserTimers(String login) {
        logger.trace(() -> "Stopping timer for " + login);
        this.stopAllForUser(login);
    }

    private void collectPreviousHoursOfCounter(List<IDSSUsageStatsInternalDB.UserPresenceItem> items, String user, String projectKey, UserCounter counter) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH");
        HashMap<String, Long> keptHours = new HashMap<String, Long>();
        Calendar begOfCurrentHour = Calendar.getInstance();
        begOfCurrentHour.set(12, 59);
        begOfCurrentHour.set(13, 0);
        begOfCurrentHour.set(14, 0);
        for (Map.Entry<String, Long> hour : counter.hours.entrySet()) {
            Date date = sdf.parse(hour.getKey());
            Calendar c2 = Calendar.getInstance();
            c2.setTime(date);
            c2.set(12, 0);
            c2.set(13, 0);
            c2.set(14, 0);
            if (c2.before(begOfCurrentHour)) {
                IDSSUsageStatsInternalDB.UserPresenceItem upi = new IDSSUsageStatsInternalDB.UserPresenceItem();
                upi.user = user;
                upi.hourTimestamp = c2.getTimeInMillis();
                upi.presenceTime = hour.getValue();
                upi.projectKey = projectKey;
                items.add(upi);
                continue;
            }
            keptHours.put(hour.getKey(), hour.getValue());
        }
        counter.hours = keptHours;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushPreviousHours() throws Exception {
        ArrayList<IDSSUsageStatsInternalDB.UserPresenceItem> items = new ArrayList<IDSSUsageStatsInternalDB.UserPresenceItem>();
        UserActivityService userActivityService = this;
        synchronized (userActivityService) {
            logger.trace(() -> "Studying flush of counters: \n " + JSON.log(this.users));
            for (Map.Entry uc : this.users.entrySet()) {
                for (Map.Entry projectCounter : ((UserCounters)uc.getValue()).projects.entrySet()) {
                    ((UserCounter)projectCounter.getValue()).flush();
                    this.collectPreviousHoursOfCounter(items, (String)uc.getKey(), (String)projectCounter.getKey(), (UserCounter)projectCounter.getValue());
                }
                ((UserCounters)uc.getValue()).global.flush();
                this.collectPreviousHoursOfCounter(items, (String)uc.getKey(), null, ((UserCounters)uc.getValue()).global);
            }
            logger.trace(() -> "After flush, counters:\n " + JSON.log(this.users));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Will flush " + JSON.log(items)));
        }
        this.dbService.storeUserPresences(items);
    }

    @PostConstruct
    public void init() {
        logger.debug((Object)"Init users activity service");
        this.installEventHandlers();
        this.sched.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    DKULogger.startCurrentCall();
                    logger.info((Object)"Flushing activity counters");
                    UserActivityService.this.flushPreviousHours();
                    logger.info((Object)"Done flushing activity counters");
                }
                catch (Throwable e) {
                    logger.warn((Object)"Failed to flush previous hours", e);
                }
            }
        }, 90L, 90L, TimeUnit.MINUTES);
        logger.debug((Object)"Done init users activity service");
    }

    public static class UserCounters {
        LazyHashMap<String, UserCounter> projects = new LazyHashMap(UserCounter.class);
        UserCounter global = new UserCounter();
    }

    public static class UserCounter {
        Map<String, Long> hours = new HashMap<String, Long>();
        Long startedOn;

        public void startIfNotStarted() {
            if (this.startedOn == null) {
                this.startedOn = System.currentTimeMillis();
            }
        }

        public void flush() {
            if (this.startedOn != null) {
                long now = System.currentTimeMillis();
                TimeRangeSplitter trs = new TimeRangeSplitter();
                trs.splitByHour(this.startedOn, now, this.hours);
                this.startedOn = now;
            }
        }

        public void stop() {
            if (this.startedOn != null) {
                long now = System.currentTimeMillis();
                TimeRangeSplitter trs = new TimeRangeSplitter();
                trs.splitByHour(this.startedOn, now, this.hours);
                this.startedOn = null;
            }
        }
    }
}

