/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.cleansing;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.meanings.AbstractBasicMeaningsService;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.types.MeaningDetector;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Set;

public class SplitInvalidCells
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<SplitInvalidCells, Parameter> META = new ProcessorMeta<SplitInvalidCells, Parameter>(){

        @Override
        public String getName() {
            return "SplitInvalidCells";
        }

        @Override
        public String getDocPage() {
            return "invalid-split";
        }

        @Override
        public Category getCategory() {
            return Category.CLEANSING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CLEANSING, ProcessorTag.SPLIT});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.SplitInvalidCells.HELP", "This processor takes all values of a column that are invalid for a specific meaning and moves them to another column.\n# Example\nWith the following data:\n<table><tr><th>icol</th></tr><tr><td>42</td></tr><tr><td>Baad</td></table>With parameters:\n\n* Column: icol\n* Column for invalid data : bad_icol\n* Meaning to check: Number\nThe result will be:\n<table><tr><th>icol</th><th>bad_icol</th></tr><tr><td>42</td><td></td></tr><tr><td></td><td>Baad</td></table>");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.SplitInvalidCells.DESCRIPTION", 1.actionVerb("Split") + " invalid cells into another column")).withMNEColParam("column", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.COLUMN", "Column")).withParam("invalidColumn", "string", true, false, this.translate(language, "SHAKER.PROCESSOR.SplitInvalidCells.DESCRIPTION.INVALID_COLUMN", "Column for invalid data")).withParam("type", "type", true, false, this.translate(language, "SHAKER.PROCESSOR.SplitInvalidCells.DESCRIPTION.TYPE", "Meaning to check")).withParam("considerEmptyAsInvalid", "boolean", false, false, this.translate(language, "SHAKER.PROCESSOR.SplitInvalidCells.DESCRIPTION.EMPTY_AS_INVALID", "Consider empty cells as invalid"));
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject ret = new JsonObject();
            try {
                Class.forName("com.dataiku.dip.shaker.types." + parameter.type);
                ret.addProperty("type", parameter.type);
            }
            catch (Exception e) {
                ret.addProperty("udm", Boolean.valueOf(true));
            }
            return ret;
        }

        @Override
        public SplitInvalidCells build(Parameter parameter) throws Exception {
            throw new UnsupportedOperationException("This processor requires a PipelineContext");
        }

        @Override
        public SplitInvalidCells build(Parameter parameter, BaseProcessorsFactory.PipelineContext context) throws Exception {
            if (context == null) {
                return this.build(parameter);
            }
            return new SplitInvalidCells(parameter, context.basicMeaningsService);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            StepParams stepParams = pss.params;
            if (!(stepParams instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter invalidCellsSplitterParams = (Parameter)stepParams;
            if (StringUtils.isBlank((CharSequence)invalidCellsSplitterParams.column) || StringUtils.isBlank((CharSequence)invalidCellsSplitterParams.invalidColumn)) {
                throw new IllegalConfigurationException("Missing columns information for lineage on the invalid cells splitter processor.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                updatedDatasetPairLineage.addFactorizedColumnRelations(invalidCellsSplitterParams.column, invalidCellsSplitterParams.invalidColumn);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    final Parameter parameter;
    final AbstractBasicMeaningsService basicMeaningsService;
    private Column cd;
    private Column invalidCD;
    private MeaningDetector type;

    public SplitInvalidCells(Parameter parameter, AbstractBasicMeaningsService basicMeaningsService) throws Exception {
        this.parameter = parameter;
        this.basicMeaningsService = basicMeaningsService;
    }

    public void postProcess() {
    }

    public void init() throws IOException {
        this.cd = this.getColumnFactory().column(this.parameter.column, Processor.ProcessorRole.INPUT_COLUMN);
        this.invalidCD = this.getColumnFactory().columnAfter(this.parameter.column, this.parameter.invalidColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
        this.type = this.basicMeaningsService.buildSingleDetector(this.parameter.type);
    }

    public void processRow(Row row) throws Exception {
        boolean split;
        String v = row.get(this.cd);
        if (this.parameter.considerEmptyAsInvalid && StringUtils.isEmpty((CharSequence)v)) {
            split = true;
        } else {
            boolean bl = split = v != null && !this.type.validates(v);
        }
        if (split) {
            row.delete(this.cd);
            row.put(this.invalidCD, v);
        }
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String column;
        public String invalidColumn;
        String type;
        public boolean considerEmptyAsInvalid;

        public void validate() throws IllegalArgumentException {
        }
    }
}

