/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.numbers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.numbers.BinnerAlgorithm;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.commons.lang.StringUtils;

public class BinnerProcessor {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "BinnerProcessor";
        }

        @Override
        public String getDocPage() {
            return "binner";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MATH});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.BinnerProcessor.HELP", "Group numbers into bins (intervals). \n\n# Options\n\n**Input columns**\n\nNumber column to transform into bin.\n\n**Binning mode**\n\nChoose from two binning modes:\n\n* **Fixed size intervals:** Define **bin width** to create bins of equal width. For example, ``2`` generates ``...,-2:0, 0:2, 2:4, ....`` \n\n    * In each bin, the lower bound is included and the upper bound is excluded. \n\n    * **Minimum value:** Set a minimum value *N* below which the corresponding bin will be *< N*. This also creates an offset for the bins: with ``width=2`` and ``minimum=0.5``, the generated bins will be ``0.5:2.5, 2.5:4.5, 4.5:6.5, ...``\n\n    * **Maximum value:** Set a maximum value *N* above which the corresponding bin will be *>= N.*\n\n* **Custom, use raw values:** specify non-overlapping intervals to create bins. \n\n    * In each bin, the lower bound is included and the upper bound is excluded. \n\n    * If a bound isn't specified, +/- infinity will be used. \n\n    * The output bin for a value that is out of the ranges will be an empty cell. \n\n**Output column**\n\nPerform the binning in an additional output column or leave it empty to perform the binning in place. \n");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.BinnerProcessor.DESCRIPTION", 1.actionVerb("Discretize") + " (" + 1.actionVerb("bin") + ") numerical values"), null, false);
        }

        @Override
        public Object selfReport(Parameter param) {
            JsonObject out = JSON.toJsonObject((Object)((Object)param), (String[])new String[0]);
            out.remove("input");
            out.remove("output");
            out.remove("bins");
            out.addProperty("numBins", (Number)param.bins.size());
            return out;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public StreamImpl build(Parameter params) {
            if (params.mode == BinnerAlgorithm.Mode.WIDTH && params.width <= 0.0) {
                throw new IllegalArgumentException("width should be positive");
            }
            if (params.useMin && params.useMax && params.min >= params.max) {
                throw new IllegalArgumentException("Maximum value should be strictly superior to minimum value");
            }
            params.useDecimalSeparatorFromLocale = DKUApp.isConfigured() && ApplicationConfigurator.getParams().getBoolParam("dku.recipes.prepare.processors.binner.useDecimalSeparatorFromLocale", false);
            return new StreamImpl(params);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SnowflakeUDFSQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter binnerParam = (Parameter)pss.params;
            if (binnerParam.input.isBlank()) {
                throw new IllegalConfigurationException("Missing columns information for lineage on the mean processor.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (StringUtils.isNotBlank((String)binnerParam.output) && !binnerParam.output.equals(binnerParam.input)) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(binnerParam.output);
                    updatedDatasetPairLineage.addFactorizedColumnRelations(binnerParam.input, binnerParam.output);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    private static class StreamImpl
    extends SingleRowProcessor
    implements Processor {
        private final Parameter params;
        private Column col;
        private Column outCol;
        private BinnerAlgorithm binnerAlgorithm;

        public StreamImpl(Parameter params) {
            this.params = params;
        }

        public void init() throws Exception {
            this.col = this.getColumnFactory().column(this.params.input, Processor.ProcessorRole.INPUT_COLUMN);
            this.outCol = this.params.output != null && !this.params.output.equals("") ? this.getColumnFactory().columnAfter(this.params.input, this.params.output, Processor.ProcessorRole.OUTPUT_COLUMN) : this.col;
            this.binnerAlgorithm = new BinnerAlgorithm((BinnerAlgorithm.Parameter)this.params);
        }

        public void processRow(Row row) throws Exception {
            row.put(this.outCol, this.binnerAlgorithm.bin(row.get(this.col)));
        }

        public void postProcess() throws Exception {
        }
    }

    private static class SnowflakeUDFSQLTranslator
    implements SnowflakeUDFProcessorTranslator {
        private final String widthModeFunctionName = "numberBinner_widthMode_" + SecretKeyGenerator.generate();
        private final String customModeFunctionName = "numberBinner_customMode_" + SecretKeyGenerator.generate();
        private final Parameter params;

        private SnowflakeUDFSQLTranslator(Parameter params) {
            this.params = params;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> getUDFResources() throws IOException {
            List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> resources = SnowflakeUDFProcessorTranslator.createStandardResourceList();
            SnowflakeUDFProcessorTranslator.addStandardResources(resources, SnowflakeUDFProcessorTranslator.StandardResource.DKU_CORE_JAR);
            return resources;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef> getUDFs() {
            SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef functionDef = this.params.mode == BinnerAlgorithm.Mode.WIDTH ? new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef(this.widthModeFunctionName, "com.dataiku.dip.shaker.processors.numbers.BinnerProcessorUDF.widthModeProcess", "input STRING, width DOUBLE, max DOUBLE, min DOUBLE", "STRING, DOUBLE, DOUBLE, DOUBLE", "STRING") : new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef(this.customModeFunctionName, "com.dataiku.dip.shaker.processors.numbers.BinnerProcessorUDF.customModeProcess", "input STRING, bins ARRAY", "STRING, ARRAY", "STRING");
            functionDef.importStandardResources(SnowflakeUDFProcessorTranslator.StandardResource.DKU_CORE_JAR);
            return Lists.newArrayList((Object[])new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef[]{functionDef});
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            ExpressionBuilder func;
            SQLDialect d = chain.getDialect();
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            if (chain.isCreatedOrModifiedByCurrentQuery(this.params.input)) {
                chain = chain.makeSubquery();
            }
            if (this.params.mode == BinnerAlgorithm.Mode.WIDTH) {
                func = ebf.expr(String.format(Locale.ROOT, "%s(%s, %s, %s, %s)", this.widthModeFunctionName, d.quoteIdentifier(this.params.input), this.params.width, this.params.useMax ? Double.valueOf(this.params.max) : "NULL", this.params.useMin ? Double.valueOf(this.params.min) : "NULL"));
            } else {
                StringJoiner joiner = new StringJoiner(", ");
                for (BinnerAlgorithm.Interval interval : this.params.bins) {
                    joiner.add(interval.inf != null ? d.quoteString(interval.inf.toString()) : "NULL");
                    joiner.add(interval.sup != null ? d.quoteString(interval.sup.toString()) : "NULL");
                    joiner.add(interval.name != null ? d.quoteString(interval.name) : "NULL");
                }
                func = ebf.expr(String.format(Locale.ROOT, "%s(%s, ARRAY_CONSTRUCT(%s))", this.customModeFunctionName, d.quoteIdentifier(this.params.input), joiner.toString()));
            }
            chain.addAfterOrReplaceColumn(chain.getCurrentColumn(this.params.input), func, Type.STRING, this.params.output, false);
            return chain;
        }
    }

    public static class Parameter
    extends BinnerAlgorithm.Parameter
    implements StepParams {
        public String input;
        public String output;

        public void validate() throws IllegalArgumentException {
        }
    }
}

