/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.probes.RecordsProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import com.dataiku.dip.server.services.AchievementsService;
import com.dataiku.dip.server.services.projects.ProjectFeaturesUsageService;
import com.dataiku.dip.shaker.ShakerUtils;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RefreshTableService {
    @Autowired
    private DataService service;
    @Autowired
    private AchievementsService achievementService;
    @Autowired
    private MetricsComputationService metricsComputationService;
    @Autowired
    private DatasetMetricsStatusService datasetMetricsStatusService;
    @Autowired
    private ProjectFeaturesUsageService projectFeaturesUsageService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private static final DKULogger logger = DKULogger.getLogger(RefreshTableService.class);

    public RefreshTableFutureThread getRefreshTableFuture(DSSAuthCtx owner, Dataset dataset, SerializedShakerScript sss, boolean allowCache, Integer nbCols, boolean isForPreview, FilterRequest filterRequest, String requestedSampleId) throws UnauthorizedException {
        RefreshTableFutureThread refreshTableFutureThread = new RefreshTableFutureThread(owner, dataset, sss, allowCache, nbCols, isForPreview);
        assert (sss != null);
        assert (sss.origin != null);
        refreshTableFutureThread.requestedSampleId = requestedSampleId;
        refreshTableFutureThread.frequest = filterRequest;
        ShakerUtils.checkScriptCodePermission(owner, sss);
        return refreshTableFutureThread;
    }

    public MeaningsFutureThread getMeaningsFuture(DSSAuthCtx owner, Dataset dataset, SerializedShakerScript sss, boolean allowCache, Integer nbCols, FilterRequest filterRequest, String requestedSampleId) throws UnauthorizedException {
        MeaningsFutureThread meaningsFutureThread = new MeaningsFutureThread(owner, dataset, sss, allowCache, nbCols);
        assert (sss != null);
        meaningsFutureThread.setRequestedSampleId(requestedSampleId);
        meaningsFutureThread.setFilterRequest(filterRequest);
        ShakerUtils.checkScriptCodePermission(owner, sss);
        return meaningsFutureThread;
    }

    public class RefreshTableFutureThread
    extends FutureThread<SerializedMemTableV2> {
        final Dataset dataset;
        private final int nbCols;
        String requestedSampleId;
        final SerializedShakerScript sss;
        FilterRequest frequest;
        boolean allowCache;
        private final FuturePayload futurePayload;
        private boolean achievementsEnabled;
        private boolean postFillEnabled;
        boolean isForPreview;
        SerializedMemTableV2 result;

        public FuturePayload buildFuturePayload(Dataset dataset) {
            FuturePayload fp = new FuturePayload();
            fp.action = "refresh_sample";
            fp.targets.add(DSSFuturePayloadUtils.forDataset(dataset).withPart("sample"));
            fp.displayName = "Refreshing table";
            return fp;
        }

        public RefreshTableFutureThread(DSSAuthCtx owner, Dataset dataset, SerializedShakerScript sss, boolean allowCache, Integer nbCols, boolean isForPreview) {
            super(owner);
            this.achievementsEnabled = true;
            this.postFillEnabled = true;
            this.result = new SerializedMemTableV2();
            this.dataset = dataset;
            this.sss = sss;
            this.allowCache = allowCache;
            this.futurePayload = this.buildFuturePayload(dataset);
            this.nbCols = nbCols != null ? nbCols : 32;
            this.isForPreview = isForPreview;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public SerializedMemTableV2 getResult() {
            return this.result;
        }

        public double getDangerosity() {
            return 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() throws Exception {
            NDC.push((String)("refresh-table: " + this.dataset.getProjectKey() + "-" + this.dataset.getName()));
            try {
                if (this.achievementsEnabled) {
                    if (this.sss.steps.size() >= 20) {
                        RefreshTableService.this.achievementService.win(this.owner, AchievementsService.AchievementId.NOT_QUITE_PARKINSON);
                    } else if (this.sss.steps.size() >= 5) {
                        RefreshTableService.this.achievementService.win(this.owner, AchievementsService.AchievementId.APPRENTICE_BARTENDER);
                    }
                }
                long before = System.currentTimeMillis();
                MemScriptRunner.TableWithReport twr = RefreshTableService.this.service.get_NOTRANSACTION(this.dataset, this.sss.deepCopy(), this.requestedSampleId, this.frequest, this.allowCache, this.owner, this.isForPreview);
                MemTable memTable = twr.table;
                synchronized (memTable) {
                    this.result.fill(twr, this.sss, 64, this.nbCols);
                }
                if (this.postFillEnabled && !this.isForPreview) {
                    if (twr.usedSample != null && twr.usedSample.metadata != null) {
                        if (twr.usedSample.metadata.sampleIsWholeDataset || twr.usedSample.metadata.datasetRecordCount != -1L && !twr.usedSample.metadata.recordCountIsApproximate) {
                            if (!this.dataset.getPartitioningSchema().isPartitioned() && twr.builtSample) {
                                logger.debugV("Saving computed exact record count (%d) as metric", new Object[]{twr.usedSample.metadata.datasetRecordCount});
                                ImmutableMap metricsValue = ImmutableMap.of((Object)new RecordsProbeType.RecordsMetric(RecordsProbeType.RecordsMetrics.COUNT_RECORDS), (Object)String.valueOf(twr.usedSample.metadata.datasetRecordCount));
                                RefreshTableService.this.metricsComputationService.saveMetricsValues(this.owner, this.dataset, MetricTargetType.DATASET, Partition.newNP(), DateTime.now(), (Map<Metric, String>)metricsValue, this.buildMetricsEnvironment());
                            }
                        } else {
                            DatasetMetricsStatusService.DatasetSummaryStatus cachedStatus = RefreshTableService.this.datasetMetricsStatusService.getCachedSummaryStatus(this.dataset);
                            if (cachedStatus.records.hasData && !cachedStatus.records.incomplete) {
                                twr.usedSample.metadata.datasetRecordCount = cachedStatus.records.totalValue;
                                twr.usedSample.metadata.recordCountIsObsolete = twr.usedSample.computeTime > cachedStatus.records.lastComputed;
                            }
                        }
                    }
                    RefreshTableService.this.projectFeaturesUsageService.update(this.dataset.getProjectKey(), this.result.headers);
                }
                if (this.achievementsEnabled) {
                    long after = System.currentTimeMillis();
                    if (after - before > 60000L) {
                        RefreshTableService.this.achievementService.win(this.owner, AchievementsService.AchievementId.SLOW_SHAKE_3);
                    } else if (after - before > 25000L) {
                        RefreshTableService.this.achievementService.win(this.owner, AchievementsService.AchievementId.SLOW_SHAKE_2);
                    } else if (after - before > 10000L) {
                        RefreshTableService.this.achievementService.win(this.owner, AchievementsService.AchievementId.SLOW_SHAKE_1);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get table data", (Throwable)e);
                throw e;
            }
            finally {
                NDC.pop();
            }
        }

        private MetricsComputationService.MetricsComputationEnvironment buildMetricsEnvironment() throws IOException {
            MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
            environment.startedFromBuild = false;
            GeneralSettingsDAO.GeneralSettings generalSettings = RefreshTableService.this.generalSettingsDAO.getUnsafeAutoTXN();
            environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
            environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
            return environment;
        }
    }

    public class MeaningsFutureThread
    extends FutureThread<MeaningsResponse> {
        private final RefreshTableFutureThread refreshTableFutureThread;

        public MeaningsFutureThread(DSSAuthCtx owner, Dataset dataset, SerializedShakerScript sss, boolean allowCache, Integer nbCols) {
            super(owner);
            this.refreshTableFutureThread = new RefreshTableFutureThread(owner, dataset, sss, allowCache, nbCols, false);
            this.refreshTableFutureThread.postFillEnabled = false;
            this.refreshTableFutureThread.achievementsEnabled = false;
        }

        public FuturePayload getPayload() {
            return this.refreshTableFutureThread.getPayload();
        }

        public double getDangerosity() {
            return this.refreshTableFutureThread.getDangerosity();
        }

        public MeaningsResponse getResult() {
            return new MeaningsResponse(this.refreshTableFutureThread.getResult());
        }

        public void execute() throws Exception {
            this.refreshTableFutureThread.execute();
        }

        public void setRequestedSampleId(String requestedSampleId) {
            this.refreshTableFutureThread.requestedSampleId = requestedSampleId;
        }

        public void setFilterRequest(FilterRequest filterRequest) {
            this.refreshTableFutureThread.frequest = filterRequest;
        }
    }

    public static class MeaningsResponse {
        public String usedSampleId;
        public List<SerializedMemTableV2.Header> meanings = new ArrayList<SerializedMemTableV2.Header>();

        private MeaningsResponse() {
        }

        public MeaningsResponse(SerializedMemTableV2 table) {
            this.usedSampleId = table.usedSampleId;
            this.meanings = table.headers;
        }
    }
}

