/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server.controllers;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.recipes.ShakerRecipeService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.processors.transform.visualif.VisualIfDesc;
import com.dataiku.dip.shaker.processors.transform.visualif.VisualIfDescUtils;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ShakerRecipeController
extends DIPInternalControllerBase {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ShakerRecipeService shakerRecipeService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private VariablesService variablesService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.export");

    @AuditInline
    @RequestMapping(value={"/api/analysis/add-to-flow"})
    public void addToFlow(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam boolean createOutput, @RequestParam String outputDatasetName, @RequestParam String outputDatasetSettings, @RequestParam String options) throws Exception {
        Dataset inputDataset;
        AnalysisCoreParams acp;
        AuthCtx user;
        Options optionsObj = (Options)JSON.parse((String)options, Options.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            if (StringUtils.isBlank((String)optionsObj.inputDataset)) {
                optionsObj.inputDataset = acp.inputDatasetSmartName;
            }
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, optionsObj.inputDataset);
            inputDataset = this.datasetAccessService.getMandatory(loc);
        }
        RecipeCreator.CreationResult result = this.shakerRecipeService.deployFromAnalysis_NT(user, projectKey, inputDataset, acp, createOutput, outputDatasetName, (ManagedDatasetsCreationService.ManagedDatasetCreationSettings)JSON.parse((String)outputDatasetSettings, ManagedDatasetsCreationService.ManagedDatasetCreationSettings.class), optionsObj.exportCharts);
        this.auditTrailService.generic("recipe-create").with("projectKey", projectKey).with("recipeType", "shaker").with("recipeName", result.id).with("fromAnalysisId", analysisId).emit();
        ShakerRecipeController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @RequestMapping(value={"/api/visualif/convert"})
    public void convertAst(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String processorDesc, @RequestParam List<String> columns) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)projectKey)) {
                this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
        }
        VisualIfDesc recipeDesc = (VisualIfDesc)JSON.parse((String)processorDesc, VisualIfDesc.class);
        String result = VisualIfDescUtils.convertVisualIfToGrelExpression(recipeDesc, new HashSet<String>(columns));
        ShakerRecipeController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    static class Options {
        boolean fallbackToString;
        boolean cleanupColumnNames;
        boolean exportCharts;
        String inputDataset;

        Options() {
        }
    }
}

