/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.expressions.GrelToQueryMapping;
import com.dataiku.dip.expressions.GrelToQueryTranslator;
import com.dataiku.dip.expressions.GrelTranslator;
import com.dataiku.dip.shaker.processors.FilterAndFlagProcessor;
import com.dataiku.dip.shaker.processors.expr.FilterAndFlagOnCustomFormulaResult;
import com.dataiku.dip.shaker.sql.AbstractSqlFilterAndFlag;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SqlFilterAndFlagOnCustomFormulaResult
extends AbstractSqlFilterAndFlag {
    public SqlFilterAndFlagOnCustomFormulaResult(SQLQueryWithSchema chain, FilterAndFlagOnCustomFormulaResult.Parameter params) {
        super(chain, params);
    }

    @Override
    protected void init() {
        this.chain = this.chain.makeSubquery();
    }

    @Override
    protected FilterAndFlagProcessor.Action getAction() {
        return this.getTypedParameter().action;
    }

    @Override
    protected List<String> getAppliesToColumns() {
        String columnKey = ImmutableList.of((Object)((Object)FilterAndFlagProcessor.Action.CLEAR_CELL), (Object)((Object)FilterAndFlagProcessor.Action.DONTCLEAR_CELL)).contains((Object)this.getTypedParameter().action) ? this.getTypedParameter().clearColumn : "notUsedColumnName";
        return ImmutableList.of((Object)columnKey);
    }

    @Override
    @Nullable
    protected FilterAndFlagProcessor.BooleanMode getBooleanConditionsForMultipleColumns() {
        return null;
    }

    @Override
    @Nullable
    protected String getColumnToAddFlagColumnAfter() {
        Expression exprForPosition = new Expression(this.getTypedParameter().expression);
        List<String> inputColumns = exprForPosition.getVariables();
        logger.info((Object)("input columns " + JSON.log(inputColumns)));
        SchemaColumn lastKnown = (SchemaColumn)Iterables.getLast(this.chain.getCurrentColumns(inputColumns));
        return lastKnown == null ? null : lastKnown.getName();
    }

    @Override
    protected String getFlagColumn() {
        return this.getTypedParameter().flagColumn;
    }

    @Override
    protected ExpressionBuilder exprFor(String column) {
        ExpressionBuilder expr;
        if (StringUtils.isNotBlank((String)this.getTypedParameter().forcedSQLTranslation)) {
            expr = this.ebf.expr(this.getTypedParameter().forcedSQLTranslation);
        } else {
            Expression grel = new Expression(this.getTypedParameter().expression, this.chain);
            GrelToQueryTranslator translator = new GrelToQueryTranslator((GrelTranslator.GrelMapping)new GrelToQueryMapping(this.chain.getDialect()), this.chain.getCurrentSchema());
            GrelTranslator.TranslationResult<ExpressionBuilder> tr = translator.translateToQuery(grel, true);
            logger.info((Object)("Translation result " + JSON.log(tr)));
            assert (tr.isFullyTranslated);
            expr = (ExpressionBuilder)tr.result;
        }
        return expr;
    }

    private FilterAndFlagOnCustomFormulaResult.Parameter getTypedParameter() {
        return (FilterAndFlagOnCustomFormulaResult.Parameter)this.parameter;
    }
}

