/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.jgit.DSSVersionForCommitResponse;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public record DSSVersionInfo(@Nonnull String version, @Nullable GitModel.GitTag tag) {
    public DSSVersionInfo(@Nonnull String version, @Nullable GitModel.GitTag tag) {
        this.version = version = Objects.requireNonNullElse(version, "Unknown version");
        this.tag = tag;
    }

    private boolean isCommitFromPreviousDSSVersion(@Nonnull String hash) {
        boolean isMigrationCommit = this.tag != null && this.tag.commitId.startsWith(hash);
        return isMigrationCommit || !DKUApp.getDSSVersion().product_version.equals(this.version);
    }

    public DSSVersionForCommitResponse toCommitResponse(@Nonnull String hash) {
        return new DSSVersionForCommitResponse(this.version, this.isCommitFromPreviousDSSVersion(hash));
    }
}

