/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.impl.FilesBasedGitInfoDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.git.GitInfo;
import com.dataiku.dip.git.ProjectCommitModeService;
import com.dataiku.dip.pivot.backend.PivotTablesService;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ProjectScopePublicAPIKey;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.controllers.admin.AdminEditionController;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.IProjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ImageService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.transactions.TransactionCodes;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.git.GitCodes;
import com.dataiku.dip.transactions.git.GitCommitSeparator;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.MergeRequest;
import com.dataiku.dip.transactions.git.cli.GitRemoteCommands;
import com.dataiku.dip.transactions.git.jgit.DSSVersionInfo;
import com.dataiku.dip.transactions.git.jgit.GitLocalCommands;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.transactions.git.jgit.ProjectsGitServiceHelper;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.wikis.ArticlesCacheService;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectsJGitService {
    private static final Pattern PROJECT_VERSION_PATTERN = Pattern.compile("dss: (.+)\n", 8);
    private static final String DSS_VERSION_INTRODUCING_TAG_VERSION = "12.5.2";
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private ProjectCommitModeService projectCommitModeService;
    @Autowired
    private ArticlesCacheService articlesCacheService;
    @Autowired
    private IProjectsService projectsService;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private PublicAPIKeysService publicAPIKeysService;
    @Autowired
    private FilesBasedGitInfoDAO gitInfoDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private WebAppsDAO webAppsDAO;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ScenariosDAO scenariosDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.projects.git");

    public GitModel.SingleCommitObjectDiff getSingleCommitDiff(String projectKey, String commitId) throws IOException, GitAPIException {
        return this.getLocalGit(projectKey).singleCommitDiff(commitId);
    }

    public DSSGitModel.ObjectLog getObjectLog(TaggableObjectsService.TaggableObjectRef tor, String since, int count, @Nullable String subPath) throws IOException, GitAPIException, DKUSecurityException {
        GitCommitSeparator sep = new GitCommitSeparator(ApplicationConfigurator.getGitMode());
        List<String> paths = sep.existingGitFilePathsForObject(tor);
        if (!StringUtils.isBlank((CharSequence)subPath)) {
            PathUtils.ensurePathStaysWithinRoot((String)subPath);
            if (paths.isEmpty()) {
                paths.add(PathUtils.makeNotLeadingNoTrailing((String)subPath));
            } else {
                paths = paths.stream().map(p -> PathUtils.makeNotLeadingNoTrailing((String)PathUtils.concatLNT((String[])new String[]{p, subPath}))).collect(Collectors.toList());
            }
        }
        GitModel.DKULog log = this.getLocalGitForObject(tor).getLog(paths, since, count);
        DSSGitModel.ObjectLog ret = new DSSGitModel.ObjectLog();
        ret.logEntries = log.logEntries;
        ret.nextCommit = log.nextCommit;
        ret.object = tor;
        return ret;
    }

    public DSSGitModel.ObjectLog getObjectLogSince(TaggableObjectsService.TaggableObjectRef tor, String reference, String since, int count) throws IOException, GitAPIException {
        GitCommitSeparator sep = new GitCommitSeparator(ApplicationConfigurator.getGitMode());
        List<String> paths = sep.existingGitFilePathsForObject(tor);
        GitModel.DKULog log = this.getLocalGitForObject(tor).getLogSince(paths, reference, since, count);
        DSSGitModel.ObjectLog ret = new DSSGitModel.ObjectLog();
        ret.logEntries = log.logEntries != null ? log.logEntries : Collections.emptyList();
        ret.nextCommit = log.nextCommit;
        ret.object = tor;
        return ret;
    }

    public DSSGitModel.ObjectLog getObjectLogUntil(TaggableObjectsService.TaggableObjectRef tor, String reference, String until, int count) throws IOException, GitAPIException {
        GitCommitSeparator sep = new GitCommitSeparator(ApplicationConfigurator.getGitMode());
        List<String> paths = sep.existingGitFilePathsForObject(tor);
        GitModel.DKULog logUntil = this.getLocalGitForObject(tor).getLogUntil(paths, reference, until, count);
        DSSGitModel.ObjectLog ret = new DSSGitModel.ObjectLog();
        ret.logEntries = logUntil.logEntries != null ? logUntil.logEntries : Collections.emptyList();
        ret.countUntil = logUntil.countUntil;
        ret.object = tor;
        return ret;
    }

    public DSSGitModel.ProjectFilesLog getLogFor(TaggableObjectsService.TaggableObjectRef tor, RelFile root, String since, int count) throws IOException, GitAPIException {
        GitCommitSeparator sep = new GitCommitSeparator(ApplicationConfigurator.getGitMode());
        String path = sep.existingGitFilePathFor(root);
        GitModel.DKULog log = this.getLocalGitForProject(tor.projectKey).getLog((List)Lists.newArrayList((Object[])new String[]{path}), since, count);
        DSSGitModel.ProjectFilesLog ret = new DSSGitModel.ProjectFilesLog();
        ret.logEntries = log.logEntries;
        ret.nextCommit = log.nextCommit;
        ret.projectKey = tor.projectKey;
        ret.objectId = tor.id;
        return ret;
    }

    public DSSGitModel.ProjectFilesLog getLogFor(TaggableObjectsService.TaggableObjectRef tor, RelFile root, String from, String to) throws IOException, GitAPIException {
        GitCommitSeparator sep = new GitCommitSeparator(ApplicationConfigurator.getGitMode());
        String path = sep.existingGitFilePathFor(root);
        GitModel.DKULog log = this.getLocalGitForProject(tor.projectKey).getLog(path, from, to);
        DSSGitModel.ProjectFilesLog ret = new DSSGitModel.ProjectFilesLog();
        ret.logEntries = log.logEntries;
        ret.nextCommit = log.nextCommit;
        ret.projectKey = tor.projectKey;
        ret.objectId = tor.id;
        return ret;
    }

    public String getHashOf(String projectKey, String commitId) throws IOException {
        return this.getLocalGitForProject(projectKey).getHashOf(commitId);
    }

    public String getCommitHashFromRef(String projectKey, String ref) throws IOException {
        return this.getLocalGitForProject(projectKey).getCommitHashFromRef(ref);
    }

    public DSSGitModel.ObjectDiff getObjectDiff(TaggableObjectsService.TaggableObjectRef tor, String from, String to) throws IOException, GitAPIException {
        DSSGitModel.GitMode gitMode = ApplicationConfigurator.getGitMode();
        TreeFilter tf = new GitCommitSeparator(gitMode).objectTreeFilter(tor);
        GitModel.MultiCommitDiff diff = this.getLocalGitForObject(tor).diff(from, to, tf, false);
        return new DSSGitModel.ObjectDiff(diff, tor);
    }

    public DSSGitModel.ProjectFilesDiff getDiffFor(TaggableObjectsService.TaggableObjectRef tor, RelFile root, String from, String to) throws IOException, GitAPIException {
        DSSGitModel.GitMode gitMode = ApplicationConfigurator.getGitMode();
        GitCommitSeparator sep = new GitCommitSeparator(gitMode);
        String path = sep.existingGitFilePathFor(root);
        PathFilter tf = PathFilter.create((String)path);
        GitModel.MultiCommitDiff diff = this.getLocalGitForProject(tor.projectKey).diff(from, to, (TreeFilter)tf, false);
        return new DSSGitModel.ProjectFilesDiff(diff, tor.projectKey, tor.id, path);
    }

    public DSSGitModel.ObjectDiff prepareObjectCommit(TaggableObjectsService.TaggableObjectRef tor) throws IOException {
        DSSGitModel.GitMode gitMode = ApplicationConfigurator.getGitMode();
        TreeFilter tf = new GitCommitSeparator(gitMode).objectTreeFilter(tor);
        logger.infoV("Getting working-copy diff for %s", new Object[]{tor});
        GitModel.MultiCommitDiff diff = this.getLocalGitForObject(tor).workingCopyDiff(tf);
        return new DSSGitModel.ObjectDiff(diff, tor);
    }

    public void commitObject(TaggableObjectsService.TaggableObjectRef tor, AuthCtx author, String message) throws IOException {
        DSSGitModel.GitMode gitMode = ApplicationConfigurator.getGitMode();
        GitCommitSeparator sep = new GitCommitSeparator(gitMode);
        DSSCommitDef commitDef = sep.commitDefForObect(tor, new GitModel.GitAuthor(author), message);
        this.transactionService.performDirectCommit(commitDef);
    }

    private void revertPathsToRevision(AuthCtx authCtx, TaggableObjectsService.TaggableObjectRef tor, String hash, List<String> paths) throws IOException, GitAPIException, CodedException, LimitsStatusComputer.LicenseLimitException {
        logger.info((Object)("Reverting " + String.valueOf(tor) + " to " + hash));
        logger.info((Object)("Paths: " + JSON.log(paths)));
        ProjectSnapshot snapshot = this.takeProjectSnapshot(tor.projectKey);
        this.getLocalGitForObject(tor).checkout(hash, paths);
        logger.info((Object)"Revert: checkout done, committing it");
        String pathsMsg = paths.size() > 3 ? StringUtils.join(paths, (String)", ", (int)0, (int)3) + " and " + (paths.size() - 3) + " more" : StringUtils.join(paths, (String)", ");
        this.commitObject(tor, authCtx, "Reverted path" + (paths.size() > 1 ? "s " : " ") + pathsMsg + " of " + tor.toPrettyString() + " to " + hash);
        TaggableObjectChangedEvent.ActionType actionType = TaggableObjectChangedEvent.ActionType.getEditAction(tor.type);
        logger.info((Object)("Dispatching changed event: " + String.valueOf((Object)actionType)));
        if (!tor.type.isFakeType()) {
            logger.info((Object)("Dispatching changed event: " + String.valueOf((Object)actionType)));
            String currentBranch = this.getLocalGitForProject(tor.projectKey).getCurrentBranch();
            TaggableObjectChangedEvent event = this.performPostGlobalModificationActions(authCtx, snapshot, actionType, currentBranch, tor.projectKey);
            event.details.addProperty("revision", hash);
            event.details.addProperty("type", "path_to_revision");
            this.pubSubService.publish(event);
            this.flowGraphService.invalidateCache();
        }
        if (tor.type == ITaggingService.TaggableType.ARTICLE || tor.type == ITaggingService.TaggableType.PROJECT) {
            this.articlesCacheService.invalidateCacheForProject(tor.projectKey);
        }
    }

    public DSSVersionInfo getDSSVersionInfo(@Nonnull String projectKey, @Nonnull String hash) throws IOException, GitAPIException {
        GitLocalCommands projectGit = this.getLocalGitForProject(projectKey);
        GitModel.GitTag tag = projectGit.findLastTag(hash, t -> t.name.startsWith("dss-version-") && t.annotations != null && PROJECT_VERSION_PATTERN.matcher(t.annotations.message).find());
        if (tag != null && tag.annotations != null) {
            String extractedVersion;
            Matcher m = PROJECT_VERSION_PATTERN.matcher(tag.annotations.message);
            String string = extractedVersion = m.find() ? m.group(1) : null;
            if (StringUtils.isNotBlank((CharSequence)extractedVersion)) {
                return new DSSVersionInfo(extractedVersion, tag);
            }
        }
        return new DSSVersionInfo("before-12.5.2", tag);
    }

    public void revertObjectToRevision(AuthCtx authCtx, TaggableObjectsService.TaggableObjectRef tor, String hash) throws IOException, GitAPIException, CodedException, LimitsStatusComputer.LicenseLimitException {
        DSSGitModel.GitMode gitMode = ApplicationConfigurator.getGitMode();
        GitCommitSeparator sep = new GitCommitSeparator(gitMode);
        List<String> paths = sep.existingGitFilePathsForObject(tor);
        this.revertPathsToRevision(authCtx, tor, hash, paths);
    }

    public InfoMessage.InfoMessages revertProjectZoneToRevision(AuthCtx authCtx, String projectKey, String hash, AdminEditionController.GlobalCodeZone zone) throws IOException, GitAPIException, CodedException, LimitsStatusComputer.LicenseLimitException {
        TaggableObjectsService.TaggableObjectRef tor = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, null);
        List<String> paths = Collections.singletonList(zone.getZoneSubPath());
        this.revertPathsToRevision(authCtx, tor, hash, paths);
        return new InfoMessage.InfoMessages();
    }

    public InfoMessage.InfoMessages revertSingleCommit(AuthCtx authCtx, String projectKey, String hash) throws IOException, InterruptedException, CodedException, GitAPIException, LimitsStatusComputer.LicenseLimitException {
        logger.info((Object)("Reverting single revision: " + projectKey + ": " + hash));
        ProjectSnapshot snapshot = this.takeProjectSnapshot(projectKey);
        InfoMessage.InfoMessages ret = this.getLocalGit(projectKey).revertSingleCommit(new GitModel.GitAuthor(authCtx), hash);
        String currentBranch = this.getLocalGitForProject(projectKey).getCurrentBranch();
        if (!ret.anyFatal()) {
            if (!this.hasValidProjectParams(projectKey)) {
                logger.error((Object)"Revert: invalid state after git operation. Rollback to previous state.");
                this.getLocalGitForProject(projectKey).hardResetTo("HEAD");
                this.transactionService.invalidateCache(this.projectsService.projectDirectory(projectKey));
                ret = new InfoMessage.InfoMessages().withFatal((InfoMessage.MessageCode)GitCodes.ERR_GIT_PROJECT_CHECKOUT_INVALID_PARAMS, "Reverting this commit would result in an invalid config and unusable project. Revert was aborted.");
            } else {
                logger.info((Object)"Revert: revert done, committing it: ");
                TaggableObjectsService.TaggableObjectRef projectRef = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, null);
                this.commitObject(projectRef, authCtx, "Reverted commit " + hash + " from project " + projectKey);
                TaggableObjectChangedEvent event = this.performPostGlobalModificationActions(authCtx, snapshot, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_REVERT, currentBranch, projectKey);
                event.details.addProperty("revision", hash);
                event.details.addProperty("type", "single_commit");
                this.pubSubService.publish(event);
            }
        }
        return ret;
    }

    public InfoMessage.InfoMessages revertProjectToRevision(AuthCtx authCtx, String projectKey, String hash) throws IOException, InterruptedException, CodedException, GitAPIException, LimitsStatusComputer.LicenseLimitException {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        ProjectSnapshot snapshot = this.takeProjectSnapshot(projectKey);
        logger.info((Object)("Reverting project " + projectKey + " to " + hash));
        if (ApplicationConfigurator.getGitMode() == DSSGitModel.GitMode.GLOBAL) {
            throw new IllegalArgumentException("Cannot revert a project: DSS Git is in global mode");
        }
        this.flushPendingCommits(projectKey);
        this.checkHash(hash);
        this.getLocalGit(projectKey).revertToRevision(new GitModel.GitAuthor(authCtx), hash);
        String currentBranch = this.getLocalGitForProject(projectKey).getCurrentBranch();
        if (!this.hasValidProjectParams(projectKey)) {
            logger.error((Object)"Revert: invalid state after git operation. Rollback to previous state.");
            this.getLocalGitForProject(projectKey).hardResetTo("HEAD");
            this.transactionService.invalidateCache(this.projectsService.projectDirectory(projectKey));
            ret.withFatal((InfoMessage.MessageCode)GitCodes.ERR_GIT_PROJECT_CHECKOUT_INVALID_PARAMS, "Reverting to this revision would result in an invalid config and unusable project. Revert was aborted.");
        } else {
            logger.info((Object)"Revert: revert done, committing it: ");
            TaggableObjectsService.TaggableObjectRef projectRef = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, null);
            this.commitObject(projectRef, authCtx, "Reverted project " + projectKey + " to " + hash);
            TaggableObjectChangedEvent event = this.performPostGlobalModificationActions(authCtx, snapshot, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_REVERT, currentBranch, projectKey);
            event.details.addProperty("revision", hash);
            event.details.addProperty("type", "project_to_revision");
            this.pubSubService.publish(event);
        }
        return ret;
    }

    public String pushToRemote(AuthCtx authCtx, String projectKey, String remoteName) throws IOException, CodedException {
        if (ApplicationConfigurator.getGitMode() == DSSGitModel.GitMode.GLOBAL) {
            throw new IllegalArgumentException("Cannot push to remote: DSS Git is in global mode");
        }
        this.flushPendingCommits(projectKey);
        boolean setUpstream = StringUtils.isEmpty((CharSequence)this.getLocalGit(projectKey).getRemoteTrackingBranch());
        String localBranchName = GitLocalCommands.shortenRefName((String)this.getLocalGit(projectKey).getCurrentBranch());
        return this.getRemoteGit(projectKey).push(authCtx, remoteName, localBranchName, setUpstream);
    }

    public GitRemoteCommands.GitCommandResult pullRebase_NT(String projectKey, String remoteName, String branchName, AuthCtx authCtx, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException, GitAPIException {
        logger.info((Object)("Git pull for project: " + projectKey));
        this.flushPendingCommits(projectKey);
        ProjectSnapshot snapshot = this.takeProjectSnapshot(projectKey);
        String hashBeforePull = this.getLocalGitForProject(projectKey).getHashOf("HEAD");
        GitRemoteCommands.GitCommandResult result = this.getRemoteGit(projectKey).pullRebase(authCtx, remoteName, branchName, logTailBuilder);
        if (!result.commandSucceeded && ProjectsJGitService.isAboutGitIgnore(logTailBuilder.get().lines)) {
            result = this.mergeUntrackedGitIgnoreFile(projectKey, remoteName, branchName, authCtx, logTailBuilder, result);
        }
        if (result.commandSucceeded) {
            if (!this.hasValidProjectParams(projectKey) || !this.hasValidFiles(projectKey, hashBeforePull, logTailBuilder)) {
                logger.error((Object)"Pull: invalid state after git operation. Rollback to previous state.");
                this.getLocalGitForProject(projectKey).hardResetTo(hashBeforePull);
                this.transactionService.invalidateCache(this.projectsService.projectDirectory(projectKey));
                result.commandSucceeded = false;
                result.messages = new InfoMessage.InfoMessages().withFatal((InfoMessage.MessageCode)GitCodes.ERR_GIT_PROJECT_CHECKOUT_INVALID_PARAMS, "Pulling this branch would yield an invalid project config and an unusable project. Commit hash '" + hashBeforePull + "' was restored.");
            } else {
                this.transactionService.invalidateCache(this.projectsService.projectDirectory(projectKey));
                TaggableObjectChangedEvent event = this.performPostGlobalModificationActions(authCtx, snapshot, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_PULL, branchName, projectKey);
                event.details.addProperty("remoteName", remoteName);
                this.pubSubService.publish(event);
            }
        }
        return result;
    }

    private boolean branchIsNewMode(String projectKey, String branchName) throws IOException, GitAPIException, MissingObjectException, IncorrectObjectTypeException {
        GitLocalCommands localGitForProject = this.getLocalGitForProject(projectKey);
        Pattern tagVersionLine = Pattern.compile("tag-version: [0-9]+\n", 8);
        Pattern branchLine = Pattern.compile("branch: .*\n", 8);
        ArrayList<String> branchTags = new ArrayList<String>();
        for (GitModel.GitTag tag : localGitForProject.getFilteredTags(s -> s.startsWith("dss-branched-"), s -> tagVersionLine.matcher((CharSequence)s).find() && branchLine.matcher((CharSequence)s).find())) {
            logger.info((Object)("Tag found " + tag.name));
            if (!localGitForProject.canReachFromHead(tag)) continue;
            branchTags.add(tag.name);
        }
        logger.info((Object)("Found branching tags on " + branchName + " : " + branchTags.stream().collect(Collectors.joining(", "))));
        return !branchTags.isEmpty();
    }

    public GitRemoteCommands.GitCommandResult fetch_NT(String projectKey, String remoteName, AuthCtx authCtx, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException {
        logger.info((Object)("Git fetch for project " + projectKey));
        return this.getRemoteGit(projectKey).fetch(authCtx, remoteName, logTailBuilder);
    }

    public GitRemoteCommands.GitCommandResult push_NT(AuthCtx authCtx, String projectKey, String remoteName, String branchName, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException {
        logger.info((Object)("Git push for project: " + projectKey));
        this.flushPendingCommits(projectKey);
        GitLocalCommands localGit = this.getLocalGit(projectKey);
        boolean setUpstream = StringUtils.isEmpty((CharSequence)localGit.getRemoteTrackingBranch());
        branchName = (String)StringUtils.defaultIfBlank((CharSequence)branchName, (CharSequence)localGit.getCurrentBranch());
        remoteName = (String)StringUtils.defaultIfBlank((CharSequence)remoteName, (CharSequence)"origin");
        return this.getRemoteGit(projectKey).pushWithLogTail(authCtx, remoteName, branchName, setUpstream, logTailBuilder);
    }

    public void resetToUpstream_NT(AuthCtx authCtx, String projectKey, String remoteName, String branchName) throws IOException, CodedException, GitAPIException, LimitsStatusComputer.LicenseLimitException {
        logger.info((Object)("Git reset to upstream: " + projectKey));
        ProjectSnapshot snapshot = this.takeProjectSnapshot(projectKey);
        branchName = GitLocalCommands.shortenRefName((String)branchName);
        this.getRemoteGit(projectKey).fetch(authCtx, remoteName, branchName);
        if (StringUtils.isNotBlank((CharSequence)remoteName) && StringUtils.isNotBlank((CharSequence)branchName)) {
            this.getLocalGit(projectKey).hardResetTo(remoteName + "/" + branchName);
        } else {
            this.getLocalGit(projectKey).hardResetTo("@{upstream}");
        }
        this.getLocalGit(projectKey).cleanUntrackedFiles();
        TaggableObjectChangedEvent event = this.performPostGlobalModificationActions(authCtx, snapshot, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_RESET, branchName, projectKey);
        event.details.addProperty("type", "reset_to_upstream");
        event.details.addProperty("remoteName", remoteName);
        event.details.addProperty("branchName", branchName);
        this.pubSubService.publish(event);
    }

    public void resetToHead_NT(AuthCtx authCtx, String projectKey) throws IOException, CodedException, GitAPIException, LimitsStatusComputer.LicenseLimitException {
        logger.info((Object)("Git reset to HEAD: " + projectKey));
        ProjectSnapshot snapshot = this.takeProjectSnapshot(projectKey);
        String branchName = this.getLocalGit(projectKey).getCurrentBranch();
        this.getLocalGit(projectKey).hardResetTo("HEAD");
        this.getLocalGit(projectKey).cleanUntrackedFiles();
        String head = this.getCommitHashFromRef(projectKey, "HEAD");
        TaggableObjectChangedEvent event = this.performPostGlobalModificationActions(authCtx, snapshot, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_RESET, branchName, projectKey);
        event.details.addProperty("revision", head);
        event.details.addProperty("type", "reset_to_head");
        this.pubSubService.publish(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitModel.GitFullStatus getFullStatus_NT(String projectKey, AuthCtx authCtx) throws IOException, GitAPIException {
        GitModel.GitFullStatus status;
        block12: {
            GitInfo projectGitInfo;
            GitLocalCommands git = this.getLocalGit(projectKey);
            status = new GitModel.GitFullStatus();
            status.currentBranch = git.getCurrentBranch();
            status.remotes = git.listRemotes();
            status.trackingCount = git.getGitTrackingCount();
            try (Transaction t = this.transactionService.beginRead();){
                projectGitInfo = this.getGitInfo(projectKey);
            }
            try {
                if (projectGitInfo == null || projectGitInfo.originProjectKey == null) break block12;
                status.originProjectKey = projectGitInfo.originProjectKey;
                File originProjectDir = DKUFileUtils.getWithin((File)ApplicationConfigurator.getBaseFolderF(), (String[])new String[]{"config", "projects", projectGitInfo.originProjectKey});
                String originRemoteName = "dku-parent-project";
                this.addOrSetRepository_NT(projectKey, originRemoteName, originProjectDir.getAbsolutePath(), authCtx);
                GitLocalCommands gitRemote = this.getLocalGit(projectGitInfo.originProjectKey);
                try {
                    status.trackingCountWithOriginProject = git.computeAheadBehindWithRemote("HEAD", originRemoteName + "/" + gitRemote.getCurrentBranch());
                }
                finally {
                    this.removeRemoteRepository_NT(projectKey, originRemoteName, authCtx);
                }
            }
            catch (CodedException | UnauthorizedException e) {
                throw new InvalidRemoteException("Couldn't retrieve Git info", e);
            }
        }
        return status;
    }

    public GitModel.GitWorkingTreeStatus getWorkingCopyStatus_NT(String projectKey) throws IOException, GitAPIException {
        return this.getLocalGit(projectKey).getStatus();
    }

    public String getCurrentBranch_NT(String projectKey) throws IOException {
        return this.getLocalGit(projectKey).getCurrentBranch();
    }

    private String getCurrentBranchOrNull_NT(@Nonnull String projectKey) {
        try {
            return this.getLocalGit(projectKey).getCurrentBranch();
        }
        catch (Exception e) {
            logger.warn((Object)("Couldn't get local branch for project '" + projectKey + "'"), (Throwable)e);
            return null;
        }
    }

    public GitModel.GitBranches listBranches_NT(String projectKey) throws GitAPIException, IOException {
        GitModel.GitBranches branches = new GitModel.GitBranches();
        logger.info((Object)("List branches for project: " + projectKey));
        GitLocalCommands git = this.getLocalGit(projectKey);
        branches.local = git.listLocalBranches();
        branches.remote = git.listRemoteBranches(false);
        return branches;
    }

    public Set<String> listAvailableBranches_NT(String projectKey, boolean shortenRemoteNames) throws GitAPIException, IOException {
        logger.info((Object)("List available branches for project: " + projectKey));
        GitLocalCommands localGit = this.getLocalGit(projectKey);
        HashSet<String> branches = new HashSet<String>(localGit.listLocalBranches());
        branches.addAll(localGit.listRemoteBranches(shortenRemoteNames));
        branches.remove("HEAD");
        return branches;
    }

    public Map<MergeRequest.BranchToMergeType, Set<String>> listAvailableBranchesByType_NT(String projectKey, boolean shortenRemoteNames) throws GitAPIException, IOException {
        logger.info((Object)("List available branches for project: " + projectKey));
        GitLocalCommands localGit = this.getLocalGit(projectKey);
        HashMap<MergeRequest.BranchToMergeType, Set<String>> branchesByType = new HashMap<MergeRequest.BranchToMergeType, Set<String>>();
        branchesByType.put(MergeRequest.BranchToMergeType.LOCAL, localGit.listLocalBranches().stream().filter(b -> !b.equals("HEAD")).collect(Collectors.toSet()));
        branchesByType.put(MergeRequest.BranchToMergeType.REMOTE, new HashSet(localGit.listRemoteBranches(shortenRemoteNames).stream().filter(b -> !b.equals("HEAD") && !b.endsWith("/HEAD")).collect(Collectors.toSet())));
        branchesByType.put(MergeRequest.BranchToMergeType.PROJECT, this.listBranchesFromDuplicates(projectKey));
        try (Transaction t = this.transactionService.beginRead();){
            GitInfo currentProjectGitInfo = this.getGitInfo(projectKey);
            if (currentProjectGitInfo != null && !StringUtils.isBlank((CharSequence)currentProjectGitInfo.originProjectKey)) {
                GitLocalCommands localGitForParentProject = this.getLocalGit(currentProjectGitInfo.originProjectKey);
                ((Set)branchesByType.get((Object)MergeRequest.BranchToMergeType.PROJECT)).addAll(localGitForParentProject.listLocalBranches().stream().map(b -> "refs/projects/" + currentProjectGitInfo.originProjectKey + "/" + b).collect(Collectors.toSet()));
            } else {
                ((Set)branchesByType.get((Object)MergeRequest.BranchToMergeType.PROJECT)).add("refs/projects/" + projectKey + "/" + this.getCurrentBranch_NT(projectKey));
            }
        }
        return branchesByType;
    }

    public Set<String> listBranchesFromDuplicates(String projectKey) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            GitInfo currentProjectGitInfo = this.getGitInfo(projectKey);
            Set<String> set = this.projectsService.listKeys().stream().map(this::getGitInfo).filter(Objects::nonNull).filter(gitInfo -> Objects.equals(gitInfo.originProjectKey, projectKey) || currentProjectGitInfo != null && currentProjectGitInfo.originProjectKey != null && currentProjectGitInfo.originProjectKey.equals(gitInfo.originProjectKey)).map(gitInfo -> "refs/projects/" + gitInfo.projectKey + "/" + (String)StringUtils.defaultIfEmpty((CharSequence)this.getCurrentBranchOrNull_NT(gitInfo.projectKey), (CharSequence)"unable-to-get-the-branch-name")).collect(Collectors.toSet());
            return set;
        }
    }

    public void deleteLocalBranch_NT(String projectKey, String branchName, boolean forceDelete) throws IOException, GitAPIException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)branchName));
        logger.info((Object)String.format("Delete local branch %s for project %s", branchName, projectKey));
        GitLocalCommands localGit = this.getLocalGit(projectKey);
        localGit.deleteLocalBranch(branchName, forceDelete);
    }

    public String deleteRemoteBranch_NT(AuthCtx authCtx, String projectKey, String branchName, boolean forceDelete, boolean deleteRemotely, String remoteName) throws IOException, CodedException, GitAPIException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)branchName));
        logger.info((Object)String.format("Delete remote branch %s for project %s", branchName, projectKey));
        this.getLocalGit(projectKey).deleteRemoteBranch(remoteName, branchName, forceDelete);
        if (deleteRemotely) {
            return this.getRemoteGit(projectKey).deleteRemoteBranch(authCtx, remoteName, branchName);
        }
        return null;
    }

    public String createBranch_NT(AuthCtx authCtx, String projectKey, String originProjectKey, String branchName, @Nullable String commitHash) throws IOException, CodedException, GitAPIException, LimitsStatusComputer.LicenseLimitException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)branchName));
        logger.info((Object)String.format("Create branch %s for project %s", projectKey, branchName));
        this.flushPendingCommits(projectKey);
        ProjectSnapshot snapshot = this.takeProjectSnapshot(projectKey);
        String tagName = "dss-branched-" + DKUDateUtils.isoFormatFileFriendlyLocalNow();
        String tagDescription = this.makeBranchTagMessage(originProjectKey, branchName);
        this.addProjectTag_NT(authCtx, projectKey, tagName, tagDescription, null);
        String result = this.getRemoteGit(projectKey).createAndCheckoutBranch(branchName, commitHash);
        TaggableObjectChangedEvent event = this.performPostGlobalModificationActions(authCtx, snapshot, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_CHECKOUT, branchName, projectKey);
        event.details.addProperty("type", "create_branch");
        this.pubSubService.publish(event);
        return result;
    }

    private String makeBranchTagMessage(String projectKey, String branchName) {
        return String.format("tag-version: 1\ndss: %s\nbranch: %s\nsource: %s\n", DKUApp.getDSSVersion().product_version, branchName, projectKey);
    }

    public void setupGitInfo(String projectKey, String originProjectKey, String branch) throws IOException {
        this.gitInfoDAO.setup(new GitInfo(projectKey, originProjectKey, branch));
    }

    public void removeGitInfo(String projectKey) throws IOException {
        this.gitInfoDAO.remove(projectKey);
    }

    public GitInfo getGitInfo(String projectKey) {
        try {
            return this.gitInfoDAO.getOrNull(projectKey, true);
        }
        catch (IOException e) {
            logger.warn((Object)("Couldn't load git info for project '" + projectKey + "'"), (Throwable)e);
            return null;
        }
    }

    public void checkoutBranch_NT(AuthCtx authCtx, String projectKey, String branchName) throws IOException, CodedException, LimitsStatusComputer.LicenseLimitException, GitAPIException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)branchName));
        logger.info((Object)String.format("Switch project %s to branch %s", projectKey, branchName));
        this.flushPendingCommits(projectKey);
        ProjectSnapshot snapshot = this.takeProjectSnapshot(projectKey);
        this.getRemoteGit(projectKey).checkoutBranch(branchName);
        this.transactionService.invalidateCache(this.projectsService.projectDirectory(projectKey));
        TaggableObjectChangedEvent event = this.performPostGlobalModificationActions(authCtx, snapshot, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_CHECKOUT, branchName, projectKey);
        event.details.addProperty("type", "checkout_branch");
        this.pubSubService.publish(event);
    }

    public GitRemoteCommands.GitCommandResult checkoutBranch_NT(AuthCtx authCtx, String projectKey, String branchName, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException, CodedException, LimitsStatusComputer.LicenseLimitException, GitAPIException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)branchName));
        logger.info((Object)String.format("Switch project %s to branch %s", projectKey, branchName));
        this.flushPendingCommits(projectKey);
        ProjectSnapshot snapshot = this.takeProjectSnapshot(projectKey);
        String branchBeforeSwitch = this.getCurrentBranch_NT(projectKey);
        GitRemoteCommands.GitCommandResult result = this.getRemoteGit(projectKey).checkoutBranch(branchName, logTailBuilder);
        if (result.commandSucceeded) {
            if (!this.hasValidProjectParams(projectKey)) {
                logger.error((Object)"Switch: invalid state after git operation. Rollback to previous state.");
                this.getRemoteGit(projectKey).checkoutBranch(branchBeforeSwitch, logTailBuilder);
                this.transactionService.invalidateCache(this.projectsService.projectDirectory(projectKey));
                result.commandSucceeded = false;
                result.messages = new InfoMessage.InfoMessages().withFatal((InfoMessage.MessageCode)GitCodes.ERR_GIT_PROJECT_CHECKOUT_INVALID_PARAMS, "Switching to a branch with an invalid project config file file would result in a unusable project. Branch '" + branchBeforeSwitch + "' was restored.");
            } else {
                this.transactionService.invalidateCache(this.projectsService.projectDirectory(projectKey));
                TaggableObjectChangedEvent event = this.performPostGlobalModificationActions(authCtx, snapshot, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_CHECKOUT, branchName, projectKey);
                event.details.addProperty("type", "checkout_branch");
                this.pubSubService.publish(event);
            }
        }
        return result;
    }

    public String addOrSetRepository_NT(String projectKey, String remoteName, String remoteUrl, AuthCtx authCtx) throws IOException, CodedException, GitAPIException, UnauthorizedException {
        String result;
        TaggableObjectChangedEvent event;
        GitRemoteCommands remoteGit = this.getRemoteGit(projectKey);
        Object sanitizedRemoteUrl = "";
        try {
            if (remoteUrl.toLowerCase().startsWith("http")) {
                URL url = new URL(remoteUrl);
                String protocol = url.getProtocol();
                String host = url.getHost();
                String path = url.getPath();
                sanitizedRemoteUrl = protocol + "://" + host + path;
            } else {
                sanitizedRemoteUrl = remoteUrl;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Couldn't sanitized remote URL for project '" + projectKey + "'"), (Throwable)e);
        }
        if (this.getLocalGit(projectKey).listRemotes().stream().anyMatch(r -> r.name.equals(remoteName))) {
            logger.info((Object)("Git update remote '" + remoteName + "' to '" + (String)sanitizedRemoteUrl + "' for project: " + projectKey));
            event = new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, projectKey, projectKey, authCtx, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_UPDATE_REMOTE);
            result = remoteGit.changeRemoteURL(authCtx, remoteName, remoteUrl);
        } else {
            event = new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, projectKey, projectKey, authCtx, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_ADD_REMOTE);
            logger.info((Object)("Git add remote '" + remoteName + "' to '" + (String)sanitizedRemoteUrl + "' for project: " + projectKey));
            try {
                result = remoteGit.addRemoteRepository(authCtx, remoteName, remoteUrl, true);
            }
            catch (CodedException e) {
                logger.info((Object)"Failed to add remote", (Throwable)e);
                if (e.code == GitCodes.ERR_GIT_ADD_REMOTE_FAILED) {
                    try {
                        remoteGit.removeRemoteRepository(remoteName);
                    }
                    catch (Exception e2) {
                        logger.info((Object)"Unable to remove the just added remote", (Throwable)e2);
                    }
                }
                throw e;
            }
        }
        String addRemoteCommit = this.getCommitHashFromRef(projectKey, "HEAD");
        event.details.addProperty("remoteName", remoteName);
        event.details.addProperty("revision", addRemoteCommit);
        event.details.addProperty("remoteUrl", (String)sanitizedRemoteUrl);
        this.pubSubService.publish(event);
        return result;
    }

    public String removeRemoteRepository_NT(String projectKey, String remoteName, AuthCtx authCtx) throws IOException, CodedException {
        logger.info((Object)("Git remove remote for project: " + projectKey));
        String result = this.getRemoteGit(projectKey).removeRemoteRepository(remoteName);
        String addRemoteCommit = this.getCommitHashFromRef(projectKey, "HEAD");
        TaggableObjectChangedEvent event = new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, projectKey, projectKey, authCtx, TaggableObjectChangedEvent.ActionType.PROJECT_GIT_DELETED_REMOTE);
        event.details.addProperty("remoteName", remoteName);
        event.details.addProperty("revision", addRemoteCommit);
        this.pubSubService.publish(event);
        return result;
    }

    public void setUpstreamForLocalBranches_NT(AuthCtx authCtx, String projectKey, String remoteName) throws IOException, GitAPIException {
        GitLocalCommands localGit = this.getLocalGit(projectKey);
        List branches = localGit.listLocalBranches();
        branches.retainAll(localGit.listRemoteBranches(true));
        for (String branch : branches) {
            try {
                this.getRemoteGit(projectKey).setUpstream(authCtx, remoteName, branch);
            }
            catch (CodedException ignored) {
                logger.warn((Object)("Could not set upstream for branch " + branch));
            }
        }
        logger.info((Object)("Git set branches upstream for project: " + projectKey));
    }

    public void addLocalTag_NT(AuthCtx author, TaggableObjectsService.TaggableObjectRef obj, String name, String message, String reference) throws IOException, GitAPIException {
        GitLocalCommands localGit = this.getLocalGitForObject(obj);
        localGit.addTag(new GitModel.GitAuthor(author), name, message, reference);
    }

    public void addProjectTag_NT(AuthCtx author, String projectKey, String name, String message, String reference) throws IOException, GitAPIException {
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, null);
        this.addLocalTag_NT(author, obj, name, message, reference);
    }

    public void addProjectVersionTag_NT(AuthCtx author, String projectKey) throws IOException, GitAPIException {
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, null);
        String tagName = "dss-version-" + DKUDateUtils.isoFormatFileFriendlyLocalNow();
        String message = String.format("tag-version: 1\ndss: %s\nproject: %s", DKUApp.getDSSVersion().product_version, projectKey);
        this.addLocalTag_NT(author, obj, tagName, message, null);
    }

    public String getProjectVersion(String projectKey) throws IOException, GitAPIException {
        Matcher m;
        Pattern projectVersionPattern;
        GitLocalCommands projectGit = this.getLocalGitForProject(projectKey);
        GitModel.GitTag tag = projectGit.findLastTag(arg_0 -> ProjectsJGitService.lambda$getProjectVersion$10(projectVersionPattern = Pattern.compile("^tag-version: (.+)\ndss: (.+)\nproject: (.+)$", 8), arg_0));
        if (tag != null && tag.annotations != null && (m = projectVersionPattern.matcher(tag.annotations.message)).find()) {
            return m.group(2);
        }
        return null;
    }

    public void addProjectTagOnProjectImport_NT(AuthCtx author, String projectKey) throws IOException, GitAPIException {
        String currentProjectDSSVersion = this.getDSSVersionInfo(projectKey, "HEAD").version();
        if (!DKUApp.getDSSVersion().product_version.equals(currentProjectDSSVersion)) {
            this.addProjectVersionTag_NT(author, projectKey);
        }
    }

    public void removeLocalTag_NT(TaggableObjectsService.TaggableObjectRef obj, String name) throws IOException, GitAPIException {
        GitLocalCommands localGit = this.getLocalGitForObject(obj);
        localGit.removeTag(name);
    }

    public void removeProjectTag_NT(String projectKey, String name) throws IOException, GitAPIException {
        TaggableObjectsService.TaggableObjectRef obj = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey);
        this.removeLocalTag_NT(obj, name);
    }

    public Set<GitModel.GitTag> getLocalTags_NT(String projectKey) throws IOException, GitAPIException {
        return this.getLocalTags_NT(new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey));
    }

    public Set<GitModel.GitTag> getLocalTags_NT(TaggableObjectsService.TaggableObjectRef obj) throws IOException, GitAPIException {
        GitLocalCommands localGit = this.getLocalGitForObject(obj);
        return localGit.getTags();
    }

    private GitLocalCommands getLocalGit(String projectKey) throws IOException {
        JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
        Git git = gitManager.getGit(projectKey);
        return new GitLocalCommands(git);
    }

    private GitRemoteCommands getRemoteGit(String projectKey) throws IOException {
        JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
        File repository = gitManager.getSubGit((String)projectKey).git.getRepository().getDirectory();
        File root = repository.getParentFile();
        return new GitRemoteCommands(root);
    }

    private GitLocalCommands getLocalGitForObject(TaggableObjectsService.TaggableObjectRef ref) throws IOException {
        JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
        Git git = ref.type.isFakeType() ? gitManager.getGlobalGit() : gitManager.getSubGit((String)ref.projectKey).git;
        return new GitLocalCommands(git);
    }

    private GitLocalCommands getLocalGitForProject(String projectKey) throws IOException {
        JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
        Git git = gitManager.getSubGit((String)projectKey).git;
        return new GitLocalCommands(git);
    }

    private void flushPendingCommits(String projectKey) throws IOException {
        this.transactionService.flushPendingCommits(projectKey);
    }

    public TaggableObjectChangedEvent performPostGlobalModificationActions(AuthCtx authCtx, ProjectSnapshot snapshot, TaggableObjectChangedEvent.ActionType actionType, String branchName, String projectKey) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException, GitAPIException {
        boolean sameExposedObjects;
        SerializedProject updatedProject;
        this.invalidateProjectCaches(snapshot.project.projectKey);
        boolean newMode = this.branchIsNewMode(projectKey, branchName);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            updatedProject = this.projectsService.getMandatory(snapshot.project.projectKey);
            boolean sameProjectKey = Objects.equals(updatedProject.projectKey, snapshot.project.projectKey);
            boolean sameOwner = Objects.equals(updatedProject.owner, snapshot.project.owner);
            boolean sameProjectName = Objects.equals(updatedProject.name, snapshot.project.name);
            boolean sameProjectStatus = Objects.equals(updatedProject.projectStatus, snapshot.project.projectStatus);
            boolean samePermissions = ProjectsGitServiceHelper.samePermissions(updatedProject.permissions, snapshot.project.permissions);
            boolean sameShortDesc = Objects.equals(updatedProject.shortDesc, snapshot.project.shortDesc);
            boolean sameDuplicatedTag = ProjectsGitServiceHelper.hasDuplicatedTag(updatedProject.tags) == ProjectsGitServiceHelper.hasDuplicatedTag(snapshot.project.tags);
            List<ProjectScopePublicAPIKey> updatedApiKeys = this.publicAPIKeysService.listProjectAPIKeys(snapshot.project.projectKey);
            boolean sameAPIKeys = ProjectsGitServiceHelper.sameApiKeys(updatedApiKeys, snapshot.apiKeys);
            sameExposedObjects = Objects.equals(updatedProject.exposedObjects, snapshot.project.exposedObjects);
            boolean needProjectChanges = false;
            if (newMode) {
                boolean bl = needProjectChanges = !sameProjectKey || !sameOwner || !samePermissions;
                if (needProjectChanges) {
                    updatedProject.owner = snapshot.project.owner;
                    updatedProject.projectKey = snapshot.project.projectKey;
                    updatedProject.permissions = snapshot.project.permissions;
                    this.projectsService.save(updatedProject, TaggableObjectChangedEvent.ProjectEditSubtype.GIT);
                }
            } else {
                boolean bl = needProjectChanges = !sameProjectKey || !sameOwner || !sameProjectName || !sameProjectStatus || !sameShortDesc || !sameDuplicatedTag || !samePermissions;
                if (needProjectChanges) {
                    updatedProject.owner = snapshot.project.owner;
                    updatedProject.projectKey = snapshot.project.projectKey;
                    updatedProject.name = snapshot.project.name;
                    updatedProject.projectStatus = snapshot.project.projectStatus;
                    updatedProject.permissions = snapshot.project.permissions;
                    updatedProject.shortDesc = snapshot.project.shortDesc;
                    if (!sameDuplicatedTag) {
                        updatedProject.tags = ProjectsGitServiceHelper.hasDuplicatedTag(snapshot.project.tags) ? ProjectsGitServiceHelper.addDuplicatedTag(updatedProject.tags) : ProjectsGitServiceHelper.removeDuplicatedTag(updatedProject.tags);
                    }
                    this.projectsService.save(updatedProject, TaggableObjectChangedEvent.ProjectEditSubtype.GIT);
                }
            }
            boolean apiKeysUpdated = false;
            if (!sameAPIKeys) {
                apiKeysUpdated = ProjectsGitServiceHelper.regenerateAPIKeys(snapshot.project.projectKey, snapshot.apiKeys, snapshot.webappApiKeys, this.passwordEncryptionService);
            }
            for (Scenario scenario : this.scenariosRunAsToRevert(authCtx, snapshot, projectKey)) {
                this.scenariosDAO.save(projectKey, scenario.id, scenario);
                needProjectChanges = true;
            }
            for (WebApp webApp : this.webappsRunAsToRevert(authCtx, snapshot, projectKey)) {
                this.webAppsDAO.save(webApp);
                needProjectChanges = true;
            }
            if (needProjectChanges || apiKeysUpdated) {
                String commitMessage = String.format("Updated invariant properties of project %s after git %s operation.", snapshot.project.projectKey, switch (actionType) {
                    case TaggableObjectChangedEvent.ActionType.PROJECT_GIT_PULL -> "pull";
                    case TaggableObjectChangedEvent.ActionType.PROJECT_GIT_CHECKOUT -> "switch";
                    case TaggableObjectChangedEvent.ActionType.PROJECT_GIT_REVERT -> "revert";
                    case TaggableObjectChangedEvent.ActionType.PROJECT_GIT_RESET -> "reset";
                    default -> actionType.toString();
                });
                t.commit(commitMessage);
            }
        }
        TaggableObjectDiffService.TaggableObjectsDiff diff = this.colaborativeMetadataDiffService.diff(snapshot.project, updatedProject, authCtx.getIdentifier());
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publish(diff, authCtx);
        }
        TaggableObjectChangedEvent event = new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, snapshot.project.projectKey, snapshot.project.projectKey, authCtx, actionType);
        event.details.addProperty("branchName", (String)StringUtils.defaultIfBlank((CharSequence)branchName, (CharSequence)"master"));
        if (sameExposedObjects) {
            event.withProjectEditSubtype(TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
        } else {
            event.withProjectEditSubtype(TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_AND_EXPOSED_ONLY);
            Sets.SetView relatedProjects = Sets.union(this.projectsService.collectRelatedProjects(snapshot.project, true, false), this.projectsService.collectRelatedProjects(updatedProject, true, false));
            logger.info((Object)("Emitting TOCE with related projects: " + Joiner.on((String)",").join((Iterable)relatedProjects)));
            event.relatedProjectsBeforeAndAfter = relatedProjects;
        }
        return event;
    }

    private List<Scenario> scenariosRunAsToRevert(AuthCtx authCtx, ProjectSnapshot snapshot, String projectKey) throws IOException {
        boolean isAdmin = this.permissionsService.isAdmin(authCtx);
        if (isAdmin) {
            return Collections.emptyList();
        }
        return this.scenariosService.list(projectKey).stream().filter(scenario -> {
            String runAs = this.scenariosService.computeRunAsUser((Scenario)scenario);
            if (StringUtils.isBlank((CharSequence)runAs)) {
                return false;
            }
            if (StringUtils.equals((CharSequence)authCtx.getIdentifier(), (CharSequence)runAs)) {
                return false;
            }
            if (snapshot.scenariosRunAs.containsKey(scenario.id)) {
                return !Objects.equals(snapshot.scenariosRunAs.get(scenario.id), runAs);
            }
            return true;
        }).peek(scenario -> {
            scenario.runAsUser = snapshot.scenariosRunAs.containsKey(scenario.id) ? snapshot.scenariosRunAs.get(scenario.id) : authCtx.getIdentifier();
        }).collect(Collectors.toList());
    }

    private List<WebApp> webappsRunAsToRevert(AuthCtx authCtx, ProjectSnapshot snapshot, String projectKey) throws IOException {
        boolean isAdmin = this.permissionsService.isAdmin(authCtx);
        if (isAdmin) {
            return Collections.emptyList();
        }
        return this.webAppsService.list(projectKey).stream().filter(webApp -> {
            String runAs = this.webAppsService.computeRunAs((WebApp)webApp);
            if (StringUtils.isBlank((CharSequence)runAs)) {
                return false;
            }
            if (StringUtils.equals((CharSequence)authCtx.getIdentifier(), (CharSequence)runAs)) {
                return false;
            }
            if (snapshot.webAppsRunAs.containsKey(webApp.id)) {
                return !Objects.equals(snapshot.webAppsRunAs.get(webApp.id), runAs);
            }
            return true;
        }).peek(webApp -> {
            webApp.params.runAs = snapshot.webAppsRunAs.containsKey(webApp.id) ? snapshot.webAppsRunAs.get(webApp.id) : authCtx.getIdentifier();
        }).collect(Collectors.toList());
    }

    public void invalidateProjectCaches(String projectKey) {
        this.transactionService.invalidateCache(this.projectsService.projectDirectory(projectKey));
        this.flowGraphService.invalidateCache();
        ImageService imageService = (ImageService)SpringUtils.getBean(ImageService.class);
        imageService.clearCache(projectKey);
        this.projectCommitModeService.clearCache(projectKey);
        this.articlesCacheService.invalidateCacheForProject(projectKey);
        try {
            DataService dataService = (DataService)SpringUtils.getBean(DataService.class);
            dataService.invalidateCacheForProject(projectKey);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to clear shaker RAM samples for " + projectKey), (Throwable)e);
        }
        try {
            SampleBuilder.clearSamplesForProject(projectKey);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to clear shaker disk samples for " + projectKey), (Throwable)e);
        }
        try {
            PivotTablesService pivotTablesService = (PivotTablesService)SpringUtils.getBean(PivotTablesService.class);
            pivotTablesService.invalidateCacheForProject(projectKey);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to clear pivot (incl. sql) caches for " + projectKey), (Throwable)e);
        }
    }

    public GitRemoteCommands.GitCommandResult mergeUntrackedGitIgnoreFile(String projectKey, String remoteName, String branchName, AuthCtx authCtx, DKUtils.SmartLogTailBuilder logTailBuilder, GitRemoteCommands.GitCommandResult result) throws IOException {
        List<String> gitIgnoreContent;
        File gitIgnore = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects", projectKey, ".gitignore"});
        if (!gitIgnore.exists()) {
            return result;
        }
        try {
            gitIgnoreContent = Files.readLines((File)gitIgnore, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            result.messages.withFatal((InfoMessage.MessageCode)GitCodes.ERR_GIT_PULL_FAILED, "Unable to read untracked .gitignore file: " + gitIgnore.getAbsolutePath());
            return result;
        }
        if (!gitIgnore.delete()) {
            result.messages.withFatal((InfoMessage.MessageCode)GitCodes.ERR_GIT_PULL_FAILED, "Unable to delete the following file on server. Please contact your administrator: " + gitIgnore.getAbsolutePath());
            return result;
        }
        logTailBuilder.appendLine("#");
        logTailBuilder.appendLine("# Settings aside .gitignore file and retrying pull operation with smart .gitignore merge");
        logTailBuilder.appendLine("#");
        result = this.getRemoteGit(projectKey).pullRebase(authCtx, remoteName, branchName, logTailBuilder);
        try {
            if (gitIgnore.exists()) {
                gitIgnoreContent = ProjectsJGitService.mergeGitIgnoreFiles(Files.readLines((File)gitIgnore, (Charset)StandardCharsets.UTF_8), gitIgnoreContent);
            }
            Files.write((CharSequence)Joiner.on((String)"\n").join((Iterable)gitIgnoreContent), (File)gitIgnore, (Charset)StandardCharsets.UTF_8);
            Git git = this.getLocalGit((String)projectKey).git;
            git.add().addFilepattern(".gitignore").call();
            GitModel.GitAuthor author = new GitModel.GitAuthor(authCtx);
            CommitCommand commit = git.commit().setSign(Boolean.valueOf(false));
            commit.setMessage("Merged untracked .gitignore file with its pulled counterpart.");
            commit.setAuthor(author.name, author.getEmailOrName());
            commit.call();
        }
        catch (GitAPIException | JGitInternalException e) {
            logger.info((Object)"Unable to commit merge of .gitignore file", e);
            result.messages.withFatal((InfoMessage.MessageCode)TransactionCodes.ERR_TRANSACTION_GIT_COMMIT_FAILED, "Unable to commit merge of .gitignore file");
        }
        catch (IOException e) {
            logger.info((Object)"Unable to merge untracked and tracked .gitignore files", (Throwable)e);
            result.messages.withFatal((InfoMessage.MessageCode)GitCodes.ERR_GIT_PULL_FAILED, "Unable to merge untracked and tracked .gitignore files");
        }
        return result;
    }

    private void checkHash(String hash) {
        if (!hash.matches("^[0-9a-f]*$")) {
            throw new SecurityException("Illegal hash: " + hash);
        }
    }

    public ProjectSnapshot takeProjectSnapshot(String projectKey) throws IOException {
        ProjectSnapshot result = new ProjectSnapshot();
        try (Transaction t = this.transactionService.beginRead();){
            result.project = this.projectsService.getMandatory(projectKey);
            result.apiKeys = this.publicAPIKeysService.listProjectAPIKeys(projectKey);
            result.webappApiKeys = new HashMap<String, String>();
            for (WebApp webApp : this.webAppsDAO.listUnsafe(projectKey)) {
                if (webApp.apiKey == null) continue;
                result.webappApiKeys.put(webApp.id, webApp.apiKey);
            }
            result.scenariosRunAs = new HashMap<String, String>();
            for (Scenario s : this.scenariosService.list(projectKey)) {
                result.scenariosRunAs.put(s.getId(), this.scenariosService.computeRunAsUser(s));
            }
            result.webAppsRunAs = new HashMap<String, String>();
            for (WebApp w : this.webAppsService.listUnsafe(projectKey)) {
                result.webAppsRunAs.put(w.getId(), this.webAppsService.computeRunAs(w));
            }
        }
        return result;
    }

    public void dropAndRebuild(RWTransaction transaction, String projectKey, boolean iKnowWhatIAmDoing) throws IOException, GitAPIException {
        if (!iKnowWhatIAmDoing) {
            throw new IllegalArgumentException("Set request parameter 'iKnowWhatIAmDoing' to true to confirm you really want to wipe out all git history.");
        }
        if (ApplicationConfigurator.getGitMode() == DSSGitModel.GitMode.GLOBAL) {
            throw new IllegalStateException("Cannot drop project Git repository in GLOBAL git mode");
        }
        JGitManager gitManager = (JGitManager)this.transactionService.getGitManager();
        File repository = gitManager.getSubGit((String)projectKey).git.getRepository().getDirectory();
        DKUFileUtils.deleteDirectory((File)repository);
        gitManager.invalidateSubGit(projectKey);
        JGitManager.SubGit git = gitManager.getSubGit(projectKey);
        git.git.add().addFilepattern(".").call();
        GitModel.GitAuthor gitAuthor = new GitModel.GitAuthor(transaction.getUser());
        git.git.commit().setSign(Boolean.valueOf(false)).setMessage(String.format("Rebuilt Git repository of project %s", projectKey)).setAuthor(gitAuthor.name, gitAuthor.getEmailOrName()).call();
    }

    private static List<String> mergeGitIgnoreFiles(List<String> content, List<String> otherContent) {
        HashSet<String> original = new HashSet<String>();
        for (String string : content) {
            if (string.startsWith("#") || string.isEmpty()) continue;
            original.add(string);
        }
        ArrayList<String> addedLines = new ArrayList<String>();
        for (String line : otherContent) {
            if (original.contains(line)) continue;
            addedLines.add(line);
        }
        ArrayList<String> arrayList = new ArrayList<String>(content);
        if (!addedLines.isEmpty()) {
            arrayList.add("");
            arrayList.add("# Rules merged by DSS");
            arrayList.add("");
            arrayList.addAll(addedLines);
        }
        return arrayList;
    }

    private static boolean isAboutGitIgnore(List<String> lines) {
        for (String line : lines) {
            if (!line.contains(".gitignore")) continue;
            return true;
        }
        return false;
    }

    private boolean hasValidProjectParams(String projectKey) {
        boolean bl;
        block8: {
            this.transactionService.invalidateCache(this.projectsDAO.getProjectFile(projectKey));
            Transaction t = this.transactionService.retrieveOrBeginRead();
            try {
                boolean bl2 = bl = this.projectsService.getOrNullUnsafe(projectKey) != null;
                if (t == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error((Object)"Unable to read project params.json while checking valid post git operation state", (Throwable)e);
                    return false;
                }
            }
            t.close();
        }
        return bl;
    }

    public Set<String> getInvalidFiles(Transaction t, RelFile baseDir, GitModel.MultiCommitDiff diff) throws IOException {
        HashSet<String> invalidFiles = new HashSet<String>();
        for (GitModel.DKUDiffEntry entry : diff.diffEntries) {
            String fileContent;
            RelFile relFile;
            File file;
            String mimeType;
            if (!StringUtils.isNotBlank((CharSequence)entry.newPath) || !(mimeType = DKUtils.guessMimeTypeFromFile((File)(file = t.resolve(relFile = new RelFile(baseDir, StringUtils.split((String)entry.newPath, (String)"/")))))).endsWith("json") || !StringUtils.isNotBlank((CharSequence)(fileContent = DKUFileUtils.readFileToStringUTF8((File)file)))) continue;
            try {
                Object parsedContent = JSON.gson().fromJson(fileContent, Object.class);
                if (parsedContent instanceof Map || parsedContent instanceof List) continue;
                invalidFiles.add(entry.newPath);
            }
            catch (JsonSyntaxException e) {
                invalidFiles.add(entry.newPath);
            }
        }
        return invalidFiles;
    }

    private boolean hasValidFiles(String projectKey, String sinceHash, DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException, GitAPIException {
        TaggableObjectsService.TaggableObjectRef projectTagObjRef = new TaggableObjectsService.TaggableObjectRef(projectKey, ITaggingService.TaggableType.PROJECT, projectKey);
        DSSGitModel.ObjectDiff diff = this.getObjectDiff(projectTagObjRef, sinceHash, "HEAD");
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            RelFile projectRelFile = new RelFile(ProjectsDAO.projectsFolder, new String[]{projectKey});
            Set<String> invalidFiles = this.getInvalidFiles(t, projectRelFile, diff);
            if (invalidFiles.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            for (String invalidFile : invalidFiles) {
                String warnMessage = "Invalid JSON format for file '" + invalidFile + "'";
                logger.warnV(warnMessage, new Object[0]);
                logTailBuilder.appendLine(warnMessage);
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean hasRemoteWithAuth(String projectKey) throws IOException, GitAPIException, URISyntaxException {
        return this.getLocalGit(projectKey).hasRemoteWithAuth();
    }

    public void checkIfHasUncommittedChangedAndRemoveNoiseFromSerialization(String projectKey) throws IOException, GitAPIException {
        GitModel.GitWorkingTreeStatus workingTreeStatus = this.getWorkingCopyStatus_NT(projectKey);
        if (!workingTreeStatus.hasUncommittedChanges) {
            return;
        }
        List<String> affectedDatasets = this.getAffectedDatasets(workingTreeStatus);
        this.removeDiffNoiseFromSerialization(projectKey, affectedDatasets);
    }

    public void removeDiffNoiseFromSerialization(String projectKey, List<String> datasetNames) {
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        for (String datasetName : datasetNames) {
            try {
                logger.infoV("Rewriting dataset '%s' from project '%s' to reduce migration noise in git diff.", new Object[]{datasetName, projectKey});
                SerializedDataset ds = (SerializedDataset)datasetsDAO.getOrNull(projectKey, datasetName);
                if (ds.type == null && ds.formatType == null) {
                    logger.warnV("No type and formatType found for '%s' from project '%s', skipping rewrite", new Object[]{datasetName, projectKey});
                    continue;
                }
                if (ds.type != null && ds.getParams() == null || ds.formatType != null && ds.getFormatParams() == null) {
                    logger.warnV("No FormatParams or Params found for '%s' from project '%s', skipping rewrite", new Object[]{datasetName, projectKey});
                    continue;
                }
                datasetsDAO.save(ds);
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Failed to process dataset '%s' from project '%s'", new Object[]{datasetName, projectKey});
            }
        }
    }

    public List<String> getAffectedDatasets(GitModel.GitWorkingTreeStatus workingTreeStatus) {
        Pattern datasetPattern = Pattern.compile("datasets/([^/]+)\\.json$");
        return Stream.of(workingTreeStatus.added, workingTreeStatus.changed, workingTreeStatus.modified, workingTreeStatus.untracked).filter(Objects::nonNull).flatMap(Collection::stream).map(filePath -> {
            Matcher matcher = datasetPattern.matcher((CharSequence)filePath);
            return matcher.find() ? matcher.group(1) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static /* synthetic */ boolean lambda$getProjectVersion$10(Pattern projectVersionPattern, GitModel.GitTag t) {
        return t.name.startsWith("dss-version-") && t.annotations != null && projectVersionPattern.matcher(t.annotations.message).find();
    }

    public static class ProjectSnapshot {
        public SerializedProject project;
        public List<ProjectScopePublicAPIKey> apiKeys;
        public Map<String, String> webappApiKeys;
        public Map<String, String> scenariosRunAs;
        public Map<String, String> webAppsRunAs;
    }
}

