/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps;

import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.bokeh.BokehWebAppMeta;
import com.dataiku.dip.webapps.dash.DashWebAppMeta;
import com.dataiku.dip.webapps.plugins.CustomWebAppMeta;
import com.dataiku.dip.webapps.plugins.CustomWebAppsService;
import com.dataiku.dip.webapps.shiny.ShinyWebAppMeta;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import com.dataiku.dip.webapps.streamlit.StreamlitWebAppMeta;
import com.google.gson.JsonObject;
import java.io.IOException;

public class WebAppLaunchInfo {
    public JsonObject config;
    public JsonObject pluginConfig;
    public boolean useProjectLibs;
    public String envName;
    public String pythonLibFolder;
    public String resourceFolder;
    public String pluginId;
    public String backendId;

    public static WebAppLaunchInfo create(AuthCtx authCtx, WebApp webApp, String backendId) throws IOException, DKUSecurityException {
        WebAppLaunchInfo ret = new WebAppLaunchInfo();
        ret.backendId = backendId;
        WebAppMeta meta = WebAppRegistry.getMeta(webApp.type);
        if (meta instanceof CustomWebAppMeta) {
            CustomWebAppMeta cmeta = (CustomWebAppMeta)meta;
            CustomWebAppsService customWebAppsService = (CustomWebAppsService)SpringUtils.getBean(CustomWebAppsService.class);
            ret.envName = WebAppLaunchInfo.getCustomWebAppCodeEnvName(webApp, cmeta);
            PluginSettingsResolver.ResolvedSettings expandedPluginSettings = customWebAppsService.getExpandedPluginSettings(meta.getType(), authCtx, webApp.projectKey, webApp.config);
            ret.config = expandedPluginSettings.config;
            ret.pluginConfig = expandedPluginSettings.pluginConfig;
            ret.useProjectLibs = false;
            ret.pythonLibFolder = customWebAppsService.getPythonLibFolder(meta.getType());
            ret.resourceFolder = customWebAppsService.getResourceFolder(meta.getType());
            ret.pluginId = cmeta.getOwnerPluginId();
        } else {
            ret.useProjectLibs = true;
            ret.pythonLibFolder = null;
            ret.resourceFolder = null;
            ret.config = null;
            ret.pluginConfig = null;
            ret.pluginId = null;
            ret.envName = StandardWebAppMeta.StandardWebAppParams.class.isAssignableFrom(meta.getParamsClass()) ? new CodeEnvSelector().selectForPythonRecipe(webApp.projectKey, webApp.getParamsAs(StandardWebAppMeta.StandardWebAppParams.class).envSelection) : (ShinyWebAppMeta.ShinyWebAppParams.class.isAssignableFrom(meta.getParamsClass()) ? new CodeEnvSelector().selectForRRecipe(webApp.projectKey, webApp.getParamsAs(ShinyWebAppMeta.ShinyWebAppParams.class).envSelection) : (BokehWebAppMeta.BokehWebAppParams.class.isAssignableFrom(meta.getParamsClass()) ? new CodeEnvSelector().selectForPythonRecipe(webApp.projectKey, webApp.getParamsAs(BokehWebAppMeta.BokehWebAppParams.class).envSelection) : (DashWebAppMeta.DashWebAppParams.class.isAssignableFrom(meta.getParamsClass()) ? new CodeEnvSelector().selectForPythonRecipe(webApp.projectKey, webApp.getParamsAs(DashWebAppMeta.DashWebAppParams.class).envSelection) : (StreamlitWebAppMeta.StreamlitWebAppParams.class.isAssignableFrom(meta.getParamsClass()) ? new CodeEnvSelector().selectForPythonRecipe(webApp.projectKey, webApp.getParamsAs(StreamlitWebAppMeta.StreamlitWebAppParams.class).envSelection) : null))));
        }
        return ret;
    }

    static String getCustomWebAppCodeEnvName(WebApp webApp, CustomWebAppMeta cmeta) throws IOException {
        if (cmeta.loaded.desc.useContextualCodeEnv && webApp.params instanceof ParamsWithSelectableCodeEnv) {
            return ((ParamsWithSelectableCodeEnv)((Object)webApp.params)).getCodeEnvSelection().envName;
        }
        return new CodeEnvSelector().getCodeEnvNameForPlugin(cmeta.getOwnerPluginId());
    }
}

