/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.webapps.backend.PerWebAppLoggingAppender;
import com.dataiku.dip.webapps.backend.WebAppRun;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.springframework.stereotype.Service;

@Service
public class WebAppRunContext {
    private PerWebAppLoggingAppender appender = new PerWebAppLoggingAppender(this);
    private InheritableThreadLocal<WebAppRun> currentWebAppRun = new InheritableThreadLocal();

    public void startLogAppender() {
        DKUtils.startLogAppender((Appender)this.appender);
    }

    public Appender getLogAppender() {
        return this.appender;
    }

    public ActiveWebAppRunContext useWebAppRun(WebAppRun webAppRun) {
        return new ActiveWebAppRunContext(webAppRun);
    }

    public void setWebappRun(WebAppRun webAppRun) {
        this.currentWebAppRun.set(webAppRun);
    }

    public void clearWebAppRun() {
        this.currentWebAppRun.set(null);
    }

    public WebAppRun getWebAppRun() {
        return (WebAppRun)this.currentWebAppRun.get();
    }

    public static File webAppsFolder() {
        return ApplicationConfigurator.getFile((String)"webappruns");
    }

    public static File webAppProjectFolder(String projectKey) {
        if (projectKey.contains("/")) {
            throw new IllegalArgumentException("Illegal path");
        }
        return DKUFileUtils.getWithin((File)WebAppRunContext.webAppsFolder(), (String[])new String[]{projectKey});
    }

    public static File webAppFolder(String projectKey, String webAppId) {
        if (webAppId.contains("/")) {
            throw new IllegalArgumentException("Illegal path");
        }
        return DKUFileUtils.getWithin((File)WebAppRunContext.webAppProjectFolder(projectKey), (String[])new String[]{webAppId});
    }

    public static File webAppRunFolder(String projectKey, String webAppId, String runId) {
        if (runId.contains("/")) {
            throw new IllegalArgumentException("Illegal path");
        }
        return DKUFileUtils.getWithin((File)WebAppRunContext.webAppFolder(projectKey, webAppId), (String[])new String[]{runId});
    }

    public static File webAppRunFolder(WebAppRun webAppRun) {
        return WebAppRunContext.webAppRunFolder(StringUtils.defaultIfBlank((String)webAppRun.webApp.projectKey, (String)""), StringUtils.defaultIfBlank((String)webAppRun.webApp.id, (String)""), StringUtils.defaultIfBlank((String)webAppRun.runId, (String)""));
    }

    public static File getWebAppLog(WebAppRun webAppRun) {
        File webAppRunFolder = WebAppRunContext.webAppRunFolder(webAppRun);
        return DKUApp.getFile((File)WebAppRunContext.webAppRunFolder(webAppRun), (String[])new String[]{"webapp.log"});
    }

    public class ActiveWebAppRunContext
    implements AutoCloseable {
        ActiveWebAppRunContext(WebAppRun webAppRun) {
            WebAppRunContext.this.setWebappRun(webAppRun);
        }

        @Override
        public void close() {
            WebAppRunContext.this.clearWebAppRun();
        }
    }
}

