(function(){"use strict";const app=angular.module("dataiku.admin.config",[]);app.service("AppConfigService",function($rootScope){const appConfig=$rootScope.appConfig;const deploymentMode=appConfig.deploymentMode;this.isDeploymentCloud=function(){return deploymentMode==="CLOUD"};this.getRaw=function(){return appConfig};this.get=function(key){return appConfig[key]}})})();(function(){"use strict";var services=angular.module("dataiku.services");services.factory("Diagnostics",function($timeout,DataikuAPI,WT1,MessengerUtils){function getLatest(success){DataikuAPI.admin.diagnostics.getLatest().success(success)}function downLoadLatest(){var url="/dip/api/admin/diagnostics/get-results";diagnosisDownloader.attr("src",url);$("body").append(diagnosisDownloader)}var diagnosisDownloader=$("<iframe>").attr("id","diagnosis-downloader");return{getLatest:getLatest,downLoadLatest:downLoadLatest}});services.factory("Logs",function(DataikuAPI){function download(logFileName){var url="/dip/api/admin/logs/get-files?name=";if(logFileName){url+=logFileName}logsDownloader.attr("src",url);$("body").append(logsDownloader)}function downloadCluster(clusterId,logName){var url="/dip/api/clusters/stream-log?clusterId="+encodeURIComponent(clusterId)+"&logName="+encodeURIComponent(logName);logsDownloader.attr("src",url);$("body").append(logsDownloader)}function downloadPod(clusterId,podName,namespace){var url="/dip/api/clusters/k8s/monitoring/stream-pod-log?clusterId="+encodeURIComponent(clusterId)+"&podName="+encodeURIComponent(podName)+"&namespace="+encodeURIComponent(namespace);logsDownloader.attr("src",url);$("body").append(logsDownloader)}function downloadAll(){download(null)}function list(){return DataikuAPI.admin.logs.list()}function cat(logFileName){return DataikuAPI.admin.logs.get(logFileName)}var logsDownloader=$("<iframe>").attr("id","logs-downloader");return{list:list,cat:cat,download:download,downloadAll:downloadAll,downloadCluster:downloadCluster,downloadPod:downloadPod}})})();(function(){"use strict";var app=angular.module("dataiku.admin",[]);app.controller("AdminUserSettingsController",function($state){if($state.is("admin.user-settings")){$state.go("admin.user-settings.cost-limiting")}});app.controller("AdminGeneralSettingsController",function($scope,$state,$stateParams,$timeout,$q,translate,DataikuAPI,WT1,ActivityIndicator,TopNav,CodeMirrorSettingService,TaggingService,FutureProgressModal,Dialogs,$rootScope,$filter,GlobalProjectActions,$anchorScroll,DeployerUtils,FutureWatcher,CreateModalFromTemplate,Assert,localStorageService,ProjectFolderService,PathUtils,PromiseService,$window,FeatureFlagsService,$http){if($state.is("admin.general")){$state.go("admin.general.themes")}$scope.setErrorInGeneralSettingsControllerScope=setErrorInScope.bind($scope);$scope.hasUrlSuffix=DeployerUtils.hasUrlSuffix;$scope.httpMethods=["GET","POST","OPTIONS","PUT","DELETE","HEAD"];$scope.virtualWebAppBackendSettingsModes=[{id:"USE_DEFAULT",label:"Run as local processes"},{id:"EXPLICIT",label:"Run in container"}];$scope.globalVariables={};TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.welcomeEmailTest={testing:false,success:false,error:null};$scope.welcomeEmailTest.recipient=$scope.welcomeEmailTest.recipient||$rootScope.appConfig.user.email||"";$scope.testWelcomeEmail=function(){$scope.welcomeEmailTest.testing=true;$scope.welcomeEmailTest.success=false;$scope.welcomeEmailTest.error=null;DataikuAPI.admin.testWelcomeEmail($scope.welcomeEmailTest.recipient,$scope.generalSettings.welcomeEmailSettings,$scope.generalSettings.notifications,$scope.generalSettings.studioMailAddress,$scope.channels).success(function(result){$scope.welcomeEmailTest.success=true}).error(function(error){$scope.welcomeEmailTest.error=error}).finally(function(){$scope.welcomeEmailTest.testing=false})};const ALL_USERS_GROUP_DISPLAY="All Users";const ALL_USERS_GROUP_INTERNAL="$$ALL_USERS$$";$scope.getProjectFolderName=item=>item.name;$scope.browseFolder=folderIds=>{$scope.destination=PathUtils.makeNLNT(folderIds).split("/").pop();return PromiseService.qToHttp(ProjectFolderService.getBrowseNode($scope.destination).catch(setErrorInScope.bind($scope)))};const ROOT_FOLDER_PROMISE=ProjectFolderService.getFolderWithPath("ROOT");function setFolderOnRuleFromPromise(rule,promise){promise.then(folder=>{if(rule.folderId==="ROOT"){folder.pathElts="/"}rule.$folder=folder}).catch(setErrorInScope.bind($scope))}function setFolderOnRule(rule){setFolderOnRuleFromPromise(rule,rule.folderId==="ROOT"?ROOT_FOLDER_PROMISE:ProjectFolderService.getFolderFallbackRoot(rule.folderId,"(missing)"))}$scope.addFolderRulePosition=function(){let allGroupIndex=$scope.generalSettings.defaultFolderSettings.rules.findIndex(rule=>rule.group===ALL_USERS_GROUP_INTERNAL);return allGroupIndex===-1?$scope.generalSettings.defaultFolderSettings.rules.length:allGroupIndex};$scope.folderRuleTemplate=function(){const rule={group:""};rule.folderId="ROOT";setFolderOnRule(rule);return rule};let groupsPreparedForDefaultFolderUI=[];$scope.getGroupsPreparedForDefaultFolderUI=()=>groupsPreparedForDefaultFolderUI;function addMissingGroupsToGroupOptions(rule){if(groupsPreparedForDefaultFolderUI.every(g=>g.id!=rule.group)){const displayName=rule.group+" (missing)";const missingGroup={display:displayName,id:rule.group};groupsPreparedForDefaultFolderUI.unshift(missingGroup)}}$scope.processFolderSettings=function(defaultFolderSettings){$scope.allGroupsPromise.then(rawGroups=>{groupsPreparedForDefaultFolderUI=rawGroups.map(g=>({display:g,id:g}));groupsPreparedForDefaultFolderUI.push({display:ALL_USERS_GROUP_DISPLAY,id:ALL_USERS_GROUP_INTERNAL});if(defaultFolderSettings&&defaultFolderSettings.rules){defaultFolderSettings.rules.forEach(rule=>{addMissingGroupsToGroupOptions(rule);setFolderOnRule(rule)})}})};$scope.alationRegister={};$scope.urlWithProtocolAndHost=$window.urlWithProtocolAndHost();$scope.editorOptions=CodeMirrorSettingService.get("text/plain",{onLoad:function(cm){$scope.codeMirror=cm}});$scope.htmlEditorOptions=CodeMirrorSettingService.get("text/html",{onLoad:function(cm){$scope.codeMirror=cm}});DataikuAPI.security.listUsers().success(function(data){$scope.allUsers=data.sort((a,b)=>a.displayName.localeCompare(b.displayName));$scope.allUsersLogin=data.map(user=>"@"+user.login)}).error(setErrorInScope.bind($scope));$scope.allGroupsPromise=DataikuAPI.security.listGroups(false).error(setErrorInScope.bind($scope)).then(function({data}){$scope.allGroups=data.sort((a,b)=>a.localeCompare(b));return $scope.allGroups});DataikuAPI.admin.connections.list().success(function(data){$scope.connectionsByName=data;$scope.connections=Object.values(data)}).error(setErrorInScope.bind($scope));$scope.isAzureConnectionOAuth=function(connectionName){return connectionName in $scope.connectionsByName&&$scope.connectionsByName[connectionName].type=="Azure"&&$scope.connectionsByName[connectionName].params.authType=="OAUTH2_APP"};var savedGeneralSettings,savedGlobalVariables,savedChannels;$scope.dirtySettings=function(){return!angular.equals($scope.generalSettings,savedGeneralSettings)||!angular.equals($scope.globalVariables.asJSON,savedGlobalVariables)||!angular.equals($scope.channels,savedChannels)};function allowedTransitionsFn(data){return data.toState&&data.fromState&&data.toState.name.startsWith("admin.general")&&data.fromState.name.startsWith("admin.general")}checkChangesBeforeLeaving($scope,$scope.dirtySettings,null,allowedTransitionsFn);$scope.hasBoundaryWhiteSpace=function(stringValue){const leadingOrTrailingWhitespace=/^\s+|\s+$/;return leadingOrTrailingWhitespace.test(stringValue)};$scope.anyHaveBoundaryWhiteSpace=function(stringValues){for(let value of stringValues){if($scope.hasBoundaryWhiteSpace(value)){return true}}return false};$scope.deployerAndNodesDirectoryEnabled=$scope.appConfig.nodesDirectoryManagedDeployerServer||$scope.appConfig.nodesDirectoryManagedDeployerClient;DataikuAPI.unifiedMonitoring.deployer.getRemoteDesignNodesUrls().success(function(data){$scope.designNodes=data}).error(setErrorInScope.bind($scope));$scope.load=function(){var promises=[];promises.push(DataikuAPI.admin.getGeneralSettings());promises.push(DataikuAPI.admin.getGlobalVariables());promises.push(DataikuAPI.admin.integrationChannels.list());promises.push(DataikuAPI.admin.getThemes());$scope.promises=$q.all(promises).then(function(values){$scope.generalSettings=values[0].data;savedGeneralSettings=angular.copy($scope.generalSettings);$scope.savedGeneralSettings=angular.copy($scope.generalSettings);$scope.processFolderSettings($scope.generalSettings.defaultFolderSettings);$scope.globalVariables.asJSON=values[1].data;savedGlobalVariables=angular.copy($scope.globalVariables.asJSON);$scope.channels=values[2].data;savedChannels=angular.copy($scope.channels);$scope.themes=values[3].data;$scope.generalSettings.customFieldsPluginComponentOrder=$scope.generalSettings.customFieldsPluginComponentOrder.filter(ref1=>$scope.appConfig.customFieldsPluginComponentRefs.find(ref2=>ref2.pluginId==ref1.pluginId&&ref2.componentId==ref1.componentId));for(let i=0;i<$scope.appConfig.customFieldsPluginComponentRefs.length;i++){const ref1=$scope.appConfig.customFieldsPluginComponentRefs[i];const existingRef=$scope.generalSettings.customFieldsPluginComponentOrder.find(ref2=>ref2.pluginId==ref1.pluginId&&ref2.componentId==ref1.componentId);if(!existingRef){$scope.generalSettings.customFieldsPluginComponentOrder.push(ref1)}}$scope.generalSettings.customPolicyHooksPluginComponentOrder=$scope.generalSettings.customPolicyHooksPluginComponentOrder.filter(ref1=>$scope.appConfig.customPolicyHooksPluginComponentRefs.find(ref2=>ref2.pluginId==ref1.pluginId&&ref2.componentId==ref1.componentId));for(let i=0;i<$scope.appConfig.customPolicyHooksPluginComponentRefs.length;i++){const ref1=$scope.appConfig.customPolicyHooksPluginComponentRefs[i];const existingRef=$scope.generalSettings.customPolicyHooksPluginComponentOrder.find(ref2=>ref2.pluginId==ref1.pluginId&&ref2.componentId==ref1.componentId);if(!existingRef){$scope.generalSettings.customPolicyHooksPluginComponentOrder.push(ref1)}}},function(errors){setErrorInScope.bind($scope)}).then(()=>{$timeout($anchorScroll)})};$scope.$watchCollection("channels",function(nv){if(nv){$scope.mailChannels=$scope.channels.filter(function(channel){return["aws-ses-mail","microsoft-graph-mail","smtp"].includes(channel.type)});if($scope.generalSettings&&$scope.mailChannels.map(c=>c.id).indexOf($scope.generalSettings.notifications.emailChannelId)<0){$scope.generalSettings.notifications.emailChannelId=void 0}}});$scope.noneUsersCallToActionBehaviorChoices=[];$scope.$watch("generalSettings.licensingSettings.trialBehavior",function(nv,ov){if(nv=="DISABLED"){$scope.noneUsersCallToActionBehaviorChoices=[["DISPLAY_MESSAGE","None, only display a message"],["ALLOW_REQUEST_ACCESS","User can request access"]];if($scope.generalSettings.licensingSettings.noneUsersCallToActionBehavior==="ALLOW_START_TRIAL"){$scope.generalSettings.licensingSettings.noneUsersCallToActionBehavior="ALLOW_REQUEST_ACCESS"}}else{$scope.noneUsersCallToActionBehaviorChoices=[["DISPLAY_MESSAGE","None, only display a message"],["ALLOW_START_TRIAL","User can start a trial"],["ALLOW_REQUEST_ACCESS","User can request access"]]}});$scope.availableUserProfilesForTrials=window.dkuAppConfig.licensing.userProfiles.filter(p=>p!="NONE").map(p=>[p,p]);$scope.load();if($stateParams.scrollTo){$scope.promises.then(()=>{$scope.scrollToMe=$stateParams.scrollTo})}$scope.autofillStudioUrl=function(){$scope.generalSettings.studioExternalUrl=urlWithProtocolAndHost()};function removeEmptyGitConfigurationOptions(){$scope.generalSettings.git.enforcedConfigurationRules.forEach(configRule=>{configRule.gitConfigurationOptions=configRule.gitConfigurationOptions.filter(option=>!option.$invalid)})}$scope.invalidTabs=new Set;$scope.$on("$stateChangeStart",function(event,toState,toParams,fromState){if($scope.adminGeneralIndexForm.$invalid&&fromState.name!=="admin.general.limits"){$scope.invalidTabs.add(fromState.name)}if($scope.adminGeneralIndexForm.homeArticlesListInvalid){$scope.invalidTabs.add("admin.general.help")}if($scope.adminGeneralIndexForm.homepagePromotedContentInvalid){$scope.invalidTabs.add("admin.general.homepage")}$timeout(function(){$scope.invalidTabs.delete(toState.name)})});$scope.isAdminGeneralIndexFormInvalid=function(){return $scope.adminGeneralIndexForm.$invalid||$scope.invalidTabs.size||$scope.adminGeneralIndexForm.homeArticlesListInvalid||$scope.adminGeneralIndexForm.homepagePromotedContentInvalid};function fetchGlobalTagsIfChanged(){if(!angular.equals($scope.generalSettings.globalTagsCategories,savedGeneralSettings.globalTagsCategories)){TaggingService.fetchGlobalTags(true)}}function checkForDuplicateNames(list,type){let names=[];list.forEach(function(element){if(!element.name){throw{message:"Found empty "+type+" name"}}if(names.includes(element.name)){throw{message:"Found duplicate "+type+" names: "+element.name}}names.push(element.name)})}$scope.saveGeneralSettings=function(){if(savedGeneralSettings.udrMode!=$scope.generalSettings.udrMode){WT1.event("usage-reporting-mode-changed",{mode:$scope.generalSettings.udrMode})}return DataikuAPI.admin.saveGeneralSettings($scope.generalSettings).success(function(data){fetchGlobalTagsIfChanged();savedGeneralSettings=angular.copy($scope.generalSettings);$scope.savedGeneralSettings=angular.copy($scope.generalSettings);if(data.anyMessage){Dialogs.infoMessagesDisplayOnly($scope,"Save warnings",data)}$scope.reloadAppConfig()}).error(setErrorInScope.bind($scope))};$scope.updateGlobalTags=function(){if(angular.equals($scope.generalSettings.globalTagsCategories,savedGeneralSettings.globalTagsCategories))return;let updatedGlobalTagsMap={};let update=false;const toDelete=["isEdited","isNew","originalTagName","removeUsage"];$scope.generalSettings.globalTagsCategories.forEach(function(category,index){category.globalTags.forEach(function(tag,idx){let originalCategoryName=savedGeneralSettings.globalTagsCategories[index]&&savedGeneralSettings.globalTagsCategories[index].name;if(originalCategoryName&&(tag.originalTagName||originalCategoryName!=category.name)){let oldGlobalTagName=`${originalCategoryName}:${tag.originalTagName||tag.name}`;updatedGlobalTagsMap[oldGlobalTagName]={color:tag.color,updatedTagName:`${category.name}:${tag.name}`,globalTagsCategory:category.name,removeUsage:tag.removeUsage};update=true}var it=$scope.generalSettings.globalTagsCategories[index].globalTags[idx];toDelete.forEach(k=>delete it[k])});delete category.isNew});if(update)DataikuAPI.admin.globalTags.updateGlobalTags(updatedGlobalTagsMap);return updatedGlobalTagsMap};$scope.invalidateConfigCache=function(){var options={type:"text"};$scope.cacheInvalidationError={};Dialogs.prompt($scope,"Invalidate cache","Path to invalidate","",options).then(function(path){DataikuAPI.admin.invalidateConfigCache(path).error(setErrorInScope.bind($scope.cacheInvalidationError))})};$scope.disablePermissionsByEmail=()=>{return $scope.generalSettings&&$scope.generalSettings.security&&$scope.generalSettings.security.enableEmailAndDisplayNameModification};const getModelCacheDetails=()=>DataikuAPI.admin.getModelCacheDetails().success(futureRes=>FutureWatcher.watchJobId(futureRes.jobId).success(res=>$scope.modelCacheDetails=res.result));getModelCacheDetails();$scope.clearModelCache=function(){Dialogs.confirmSimple($scope,"Clear model cache?").then(function(){DataikuAPI.admin.clearModelCache().error(setErrorInScope.bind($scope)).success(function(resp){FutureProgressModal.show($scope,resp,"Clearing model cache").then(function(result){ActivityIndicator.success("Cleared model cache",5e3);getModelCacheDetails()})})})};$scope.openDeleteModelModal=function(modelKey){Dialogs.confirmSimple($scope,"Delete "+modelKey+" ?").then(function(){DataikuAPI.admin.deleteModelFromCache(modelKey).error(setErrorInScope.bind($scope)).success(function(resp){getModelCacheDetails()})})};$scope.exportModel=function(modelKey){downloadURL("/dip/api/admin/model-cache/export?modelKey="+modelKey)};$scope.openImportModelModal=function(){$scope.importData={uploading:false};CreateModalFromTemplate("/templates/import-file.html",$scope,null,function(modalScope){modalScope.fileName="Model";const parentScope=$scope.$parent.$parent;modalScope.import=function(){Assert.trueish($scope.importData.files,"No model file");$scope.importData.uploading=true;DataikuAPI.admin.importModel($scope.importData.files).then(function(data){modalScope.dismiss();FutureProgressModal.show(parentScope,JSON.parse(data),"Model import",undefined,"static",false).then(function(result){Dialogs.infoMessagesDisplayOnly(parentScope,"Creation result",result.messages,result.futureLog,undefined,"static",false);getModelCacheDetails()})},function(payload){setErrorInScope.bind($scope)(JSON.parse(payload.response),payload.status,function(h){return payload.getResponseHeader(h)})})}})};$scope.fetchOpenIDConfig=function(openIdWellKnown){return DataikuAPI.admin.fetchOpenIDConfig(openIdWellKnown).success(function(config){$scope.generalSettings.ssoSettings.openIDParams.issuer=config.issuer;$scope.generalSettings.ssoSettings.openIDParams.authorizationEndpoint=config.authorization_endpoint;$scope.generalSettings.ssoSettings.openIDParams.tokenEndpoint=config.token_endpoint;$scope.generalSettings.ssoSettings.openIDParams.jwksUri=config.jwks_uri}).error(setErrorInScope.bind($scope))};$scope.computeWellKnowFromIssuer=function(){let issuer=$scope.generalSettings.ssoSettings.openIDParams.issuer;$scope.openIdWellKnown=issuer?issuer+"/.well-known/openid-configuration":""};$scope.save=function(){try{removeEmptyGitConfigurationOptions();checkForDuplicateNames($scope.generalSettings.containerSettings.executionConfigs,"container configuration");checkForDuplicateNames($scope.generalSettings.sparkSettings.executionConfigs,"Spark configuration");checkForDuplicateNames($scope.generalSettings.globalTagsCategories,"global category");const updatedGlobalTagsMap=$scope.updateGlobalTags();const gv=$scope.globalVariables.asJSON||"{}";return $scope.saveGeneralSettings().then(function(){return DataikuAPI.admin.integrationChannels.saveAll($scope.channels).success(function(data){$scope.channels=data;savedChannels=angular.copy(data);return DataikuAPI.admin.saveGlobalVariables(gv).success(function(){savedGlobalVariables=angular.copy($scope.globalVariables.asJSON);$scope.$broadcast("generalSettingsSaved",updatedGlobalTagsMap);if($scope.isAdminGeneralIndexFormInvalid()){const allInvalidTabs=new Set;$scope.invalidTabs.forEach(tab=>allInvalidTabs.add($state.get(tab).pageTitle()));if($scope.adminGeneralIndexForm.$invalid){allInvalidTabs.add($state.current.pageTitle())}if($scope.adminGeneralIndexForm.homepagePromotedContentInvalid){allInvalidTabs.add($state.get("admin.general.homepage").pageTitle())}if($scope.adminGeneralIndexForm.homeArticlesListInvalid){allInvalidTabs.add($state.get("admin.general.help").pageTitle())}const warningMessage="Saved with some invalid fields in tab"+($scope.invalidTabs.size+$scope.adminGeneralIndexForm.$invalid>1?"s '":" '")+[...allInvalidTabs].join("', '")+"'";ActivityIndicator.warning(warningMessage)}else{ActivityIndicator.success("Saved!")}$scope.appConfig.impalaEnabled=$scope.generalSettings.impalaSettings.enabled&&$scope.appConfig.hadoopEnabled;$scope.appConfig.pluginDevExplicitCommit=$scope.generalSettings.pluginDevExplicitCommit;$scope.appConfig.npsSurveyEnabled=$scope.generalSettings.npsSurveyEnabled;$scope.appConfig.nodeName=$scope.generalSettings.nodeName;$scope.appConfig.helpIntegrationEnabled=$scope.generalSettings.helpIntegrationEnabled;$scope.appConfig.openTicketsFromOpalsEnabled=$scope.generalSettings.openTicketsFromOpalsEnabled;$scope.appConfig.projectStatusList=$scope.generalSettings.projectStatusList;if(!$rootScope.featureFlagEnabled("homepageRedesign")){$scope.appConfig.homeMessages=$scope.generalSettings.homeMessages}$scope.appConfig.apiDeployerStages=$scope.generalSettings.apiDeployerServerSettings.stages;$scope.appConfig.projectVisibility=$scope.generalSettings.projectVisibility;$scope.appConfig.appVisibility=$scope.generalSettings.appVisibility;$scope.appConfig.studioForgotPasswordUrl=$scope.generalSettings.studioForgotPasswordUrl;$scope.appConfig.autoAcceptSchemaChangeAtEndOfFlow=$scope.generalSettings.autoAcceptSchemaChangeAtEndOfFlow;$scope.appConfig.uiCustomization=$scope.generalSettings.uiCustomizationSettings;$scope.appConfig.quickSharingElementsEnabled=$scope.generalSettings.quickSharingElementsEnabled;$scope.appConfig.pluginInstallRequestsEnabled=$scope.generalSettings.pluginInstallRequestsEnabled;$scope.appConfig.opalsEnabled=$scope.generalSettings.opalsEnabled;$scope.appConfig.codeEnvInstallRequestsEnabled=$scope.generalSettings.codeEnvInstallRequestsEnabled}).error(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))}).catch(setErrorInScope.bind($scope))}catch(err){ActivityIndicator.error("Invalid format: "+err.message)}};$scope.registerAlationOpener=function(){$scope.save().then(function(){DataikuAPI.connections.registerAlationOpener($scope.alationRegister.alationAPIToken).success(function(){ActivityIndicator.success("Alation registration done")}).error(setErrorInScope.bind($scope))})};DataikuAPI.connections.getNames("SQL").success(function(data){$scope.sqlConnections=data}).error(setErrorInScope.bind($scope));$scope.testLdapSettings=function(){$scope.ldapTesting=true;$scope.ldapTestResult=null;DataikuAPI.admin.testLdapSettings($scope.generalSettings.ldapSettings).success(function(data){$scope.ldapTestResult=data}).error(setErrorInScope.bind($scope)).finally(()=>$scope.ldapTesting=false)};$scope.testLdapGetUserDetails=function(userName){$scope.ldapUserTesting=true;$scope.ldapTestUserDetails=null;DataikuAPI.admin.testLdapGetUserDetails({settings:$scope.generalSettings.ldapSettings,username:userName}).success(function(data){$scope.ldapTestUserDetails=data}).error(setErrorInScope.bind($scope)).finally(()=>$scope.ldapUserTesting=false)};$scope.testAzureADSettings=function(login,email){$scope.azureADTesting=true;$scope.azureADTestResult=null;DataikuAPI.admin.testAzureADSettings({azureADSettings:$scope.generalSettings.azureADSettings,userIdentity:{login:login||"",email:email||""}}).success(function(data){$scope.azureADTestResult=data;if($scope.azureADTestResult.connectionOK){$scope.azureADTestResult.userAttributes=JSON.stringify($scope.azureADTestResult.userAttributes,null,2)}}).error(setErrorInScope.bind($scope)).finally(()=>$scope.azureADTesting=false)};$scope.governIntegrationTest=function(){DataikuAPI.admin.govern.test().success(function(data){$scope.governIntegrationTestResult=data}).error(setErrorInScope.bind($scope))};$scope.governIntegrationParams={projectKey:""};$scope.governIntegrationFullSync=function(){DataikuAPI.admin.govern.sync($scope.governIntegrationParams.projectKey).success(function(data){FutureProgressModal.show($scope,data,"Synchronizing DSS Items on Dataiku Govern",null,"static",false,true).then(function(result){if(result){$scope.governIntegrationFullSyncResult={status:"SUCCESS",data:result}}})}).error(function(data,status,headers){$scope.governIntegrationFullSyncResult={status:"ERROR",error:getErrorDetails(data,status,headers)}})};$scope.governIntegrationFullDeployerSync=function(){DataikuAPI.admin.govern.deployerSync().success(function(data){FutureProgressModal.show($scope,data,"Synchronizing DSS Deployer Items on Dataiku Govern",null,"static",false,true).then(function(result){if(result){$scope.governIntegrationFullDeployerSyncResult={status:"SUCCESS",data:result}}})}).error(function(data,status,headers){$scope.governIntegrationFullDeployerSyncResult={status:"ERROR",error:getErrorDetails(data,status,headers)}})};$scope.checkDatastoryIntegration=function(){DataikuAPI.admin.datastory.check().success(function(data){$scope.datastoryIntegrationCheckResult=data}).error(setErrorInScope.bind($scope))};$scope.addLDAPGroupProfile=function(){var groupProfiles=$scope.generalSettings.ldapSettings.groupProfiles;if(!groupProfiles||!$.isArray(groupProfiles)){$scope.generalSettings.ldapSettings.groupProfiles=[]}$scope.generalSettings.ldapSettings.groupProfiles.push({key:"",value:$scope.generalSettings.ldapSettings.userProfile})};$scope.deleteLDAPGroupProfile=function(index){$scope.generalSettings.ldapSettings.groupProfiles.splice(index,1)};$scope.addSSOGroupProfile=function(){var groupProfiles=$scope.generalSettings.ssoSettings.groupProfiles;if(!groupProfiles||!$.isArray(groupProfiles)){$scope.generalSettings.ssoSettings.groupProfiles=[]}$scope.generalSettings.ssoSettings.groupProfiles.push({key:"",value:$scope.generalSettings.ssoSettings.userProfile})};$scope.deleteSSOGroupProfile=function(index){$scope.generalSettings.ssoSettings.groupProfiles.splice(index,1)};$scope.addAzureADGroupProfile=function(){var groupProfiles=$scope.generalSettings.azureADSettings.groupProfiles;if(!groupProfiles||!$.isArray(groupProfiles)){$scope.generalSettings.azureADSettings.groupProfiles=[]}$scope.generalSettings.azureADSettings.groupProfiles.push({key:"",value:$scope.generalSettings.azureADSettings.userProfile})};$scope.deleteAzureADGroupProfile=function(index){$scope.generalSettings.azureADSettings.groupProfiles.splice(index,1)};$scope.addCustomAuthGroupProfile=function(){var groupProfiles=$scope.generalSettings.customAuthSettings.groupProfiles;if(!groupProfiles||!$.isArray(groupProfiles)){$scope.generalSettings.customAuthSettings.groupProfiles=[]}$scope.generalSettings.customAuthSettings.groupProfiles.push({key:"",value:$scope.generalSettings.customAuthSettings.userProfile})};$scope.deleteCustomAuthGroupProfile=function(index){$scope.generalSettings.customAuthSettings.groupProfiles.splice(index,1)};$scope.getChannelTypeLabel=function(type){if(!type){return"Unknown"}else if(type==="msft-teams"){return"Microsoft Teams"}else if(type==="google-chat"){return"Google Chat"}else if(type==="aws-ses-mail"){return"Mail (via Amazon SES)"}else if(type==="microsoft-graph-mail"){return"Mail (via Microsoft 365 with OAuth)"}else if(type==="smtp"){return"Mail (SMTP)"}else{return type.charAt(0).toUpperCase()+type.slice(1)}};$scope.addChannel=function(type){var definition={type:type,configuration:{sessionProperties:[]},permissions:[{group:ALL_USERS_GROUP_INTERNAL,canUse:true}],$creation:true};if(type==="slack"||type==="webhook"||type==="twilio"||type==="msft-teams"||type==="google-chat"){definition.configuration.useProxy=true}if(type==="slack"){definition.configuration.mode="WEBHOOK"}if(type==="msft-teams"){definition.configuration.webhookType="WORKFLOWS"}$scope.channels.push(definition)};$scope.removeChannel=function(channel){var index=$scope.channels.indexOf(channel);if(index>=0){$scope.channels.splice(index,1)}};DataikuAPI.admin.clusters.listAccessible("HADOOP").success(function(data){$scope.clusters=[{id:null,name:"No override"}].concat(data)}).error(setErrorInScope.bind($scope));DataikuAPI.admin.clusters.listAccessible("KUBERNETES").success(function(data){$scope.k8sClusters=[{id:null,name:"No override"}].concat(data)}).error(setErrorInScope.bind($scope));$scope.DEPLOYER_MODES=[["DISABLED","Disabled"],["LOCAL","Local"],["REMOTE","Remote"]];$scope.DEPLOYER_MODES_DESCRIPTIONS=["Disable ability to publish models and projects on the Deployer","Use this DSS instance as Deployer","Publish models and projects on a remote Deployer"];$scope.listOpalsUnsupportedWhiteLabelingSettings=function(whiteLabeling){if(whiteLabeling===undefined){return[]}let unsupportedSettings;if(whiteLabeling.productLongName!=="Dataiku DSS"){unsupportedSettings=["productLongName"]}else{unsupportedSettings=[]}const stringSettings=["referenceDocRootUrl","aboutModalTitle","aboutModalLogoUrl","aboutModalText","getHelpModalTitle","getHelpModalText"];const booleanSettings=["contextualHelpSearchEnabled"];return unsupportedSettings.concat(stringSettings.filter(s=>whiteLabeling[s])).concat(booleanSettings.filter(s=>s in whiteLabeling&&!whiteLabeling[s]))};$scope.syncOnboardingOpals=function(){$scope.generalSettings.onboardingExperience=$scope.generalSettings.opalsEnabled};$scope.pushBaseImages=function(){if($scope.dirtySettings()){$scope.save().then($scope.pushBaseImages_NoCheckDirty)}else{$scope.pushBaseImages_NoCheckDirty()}};$scope.pushBaseImages_NoCheckDirty=function(){DataikuAPI.admin.containerExec.pushBaseImages().success(function(data){FutureProgressModal.show($scope,data,"Pushing base images").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Push result",result.messages,result.futureLog)}})}).error(setErrorInScope.bind($scope))};const formatDefaults=function(defaults){if(!defaults.cudaVersion){defaults.cudaVersion=""}if(!defaults.distrib){defaults.distrib=""}return defaults};$scope.buildBaseImage=function(buildType,buildOptions){$scope.saveGeneralSettings().then(()=>DataikuAPI.admin.containerExec.getBaseImageDefaults(buildType)).then(({data})=>DataikuAPI.admin.containerExec.buildBaseImage(buildType,buildOptions||formatDefaults(data))).then(({data})=>{FutureProgressModal.show($scope,data,"Building image").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Image built",result,result.futureLog,true)}})}).catch(setErrorInScope.bind($scope))};$scope.buildCDEPluginsImage=()=>{$scope.saveGeneralSettings().then(()=>DataikuAPI.admin.containerExec.buildBaseImage("CDE_PLUGINS")).then(({data})=>{FutureProgressModal.show($scope,data,"Building image").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Image built",result,result.futureLog,true)}})}).catch(setErrorInScope.bind($scope))};$scope.setupBuildBaseImage=function(buildType){DataikuAPI.admin.containerExec.getBaseImageDefaults(buildType).then(({data})=>{CreateModalFromTemplate("/templates/admin/fragments/build-base-image-modal.html",$scope,"BuildBaseImageModalController",function(modalScope){modalScope.availableDistributions=_.concat([["","Use default"]],data.AVAILABLE_DISTRIBUTIONS.map(x=>[x,x.charAt(0).toUpperCase()+x.slice(1)]));modalScope.availableCudaVersions=_.concat([["","No CUDA"]],data.AVAILABLE_CUDA_VERSIONS.map(x=>[x,"CUDA "+x]));modalScope.buildType=buildType;modalScope.buildOptions=formatDefaults(data);modalScope.buildBaseImage=$scope.buildBaseImage})}).catch(setErrorInScope.bind($scope))};$scope.fillInBoilerplateCustomWelcomeEmail=function(){if($scope.generalSettings!=null&&$scope.generalSettings.welcomeEmailSettings!=null&&$scope.generalSettings.welcomeEmailSettings.sendAsHTML&&!$scope.generalSettings.welcomeEmailSettings.useDefaultTemplate&&!$scope.generalSettings.welcomeEmailSettings.message){$http.get("templates/admin/general/inline-boilerplate-custom-welcome-email.html").then(function(response){$scope.generalSettings.welcomeEmailSettings.message=response.data})}};$scope.datasetTypesOptions=(()=>{const datasetName=$filter("datasetTypeToName");const rawDatasetsTiles=GlobalProjectActions.getAllDatasetByTilesNoFilter();const res=[];rawDatasetsTiles.forEach(tile=>{const allTypes=tile.types.concat(tile.types2||[]);allTypes.forEach(type=>{if(type===undefined)return;res.push({tile:tile.title,value:type.type,displayName:type.label!==undefined?type.label:datasetName(type.type)})})});res.push({tile:"Import existing",value:"search_and_import",displayName:translate("PROJECT.ACTIONS.SEARCH_AND_IMPORT","Search and import…")});return res})();$scope.highlightedDatasets={getOptions:currentSelected=>{return $scope.datasetTypesOptions.filter(datasetTypeOption=>{return datasetTypeOption.value===currentSelected||$scope.generalSettings.uiCustomizationSettings.highlightedDatasets.indexOf(datasetTypeOption.value)===-1})},init:()=>{$scope.highlightedDatasets.selection=$scope.generalSettings.uiCustomizationSettings.highlightedDatasets.map(type=>({type:type}))},onChange:nv=>{$scope.generalSettings.uiCustomizationSettings.highlightedDatasets=nv.map(({type})=>type).filter(x=>x)}};$scope.promises.then($scope.highlightedDatasets.init);DataikuAPI.codeAssistant.listAvailableLLMs().success(function(data){$scope.availableLLMs=data.identifiers}).error(setErrorInScope.bind($scope));$scope.openAIServicesTermsOfUseModal=function(){return CreateModalFromTemplate("/templates/admin/general/ai-services-terms-of-use-modal.html",$scope,null,function(modalScope){modalScope.uiState={termsAccepted:false};modalScope.confirm=function(){$scope.generalSettings.aiDrivenAnalyticsSettings.dataikuAIServicesTermsOfUseAccepted=true;$scope.generalSettings.aiDrivenAnalyticsSettings.dataikuAIServicesTermsOfUseAcceptedOn=moment().toISOString(true);$scope.generalSettings.aiDrivenAnalyticsSettings.dataikuAIServicesTermsOfUseAcceptedBy=$rootScope.appConfig.login;modalScope.resolveModal()}})};$scope.llmCostLimitingEnabled=window.dkuAppConfig.llmSettings.costLimitingEnabled;$scope.llmRateLimitingEnabled=window.dkuAppConfig.llmSettings.rateLimitingEnabled});app.controller("AdminGenAIController",function($scope,$state,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.useInternalCodeEnvLabel="Use internal code env";DataikuAPI.codeenvs.list("PYTHON").then(function({data}){$scope.codeEnvs=data;$scope.codeEnvsNames=data.map(codeEnv=>codeEnv.envName);$scope.codeEnvItemsListWithDefault=[{label:$scope.useInternalCodeEnvLabel,value:undefined}].concat($scope.codeEnvsNames.map(codeEnv=>({label:codeEnv,value:codeEnv})))}).catch(setErrorInScope.bind($scope));$scope.codeEnvImageIsMissing=function(containerExec,codeEnvName){if(containerExec?.containerMode!=="EXPLICIT_CONTAINER"){return null}if(!codeEnvName){return null}if(!$scope.codeEnvs){return null}const codeEnv=$scope.codeEnvs.find(c=>c.envName===codeEnvName);if(!codeEnv){return null}return!codeEnv.allContainerConfs&&!codeEnv.containerConfs.includes(containerExec.containerConf)};DataikuAPI.pretrainedModels.listAvailableConnectionLLMs("TEXT_EMBEDDING_EXTRACTION").success(function(data){$scope.availableTextEmbeddingLLMs=data["identifiers"]}).error(setErrorInScope.bind($scope));DataikuAPI.pretrainedModels.listAvailableConnectionLLMs("IMAGE_EMBEDDING_EXTRACTION").success(function(data){$scope.availableImageEmbeddingLLMs=data["identifiers"]}).error(setErrorInScope.bind($scope));DataikuAPI.pretrainedModels.listAvailableConnectionLLMs("GENERIC_COMPLETION").success(function(data){$scope.availableCompletionLLMs=data["identifiers"]}).error(setErrorInScope.bind($scope));DataikuAPI.pretrainedModels.listAvailableConnectionLLMs("IMAGE_INPUT").success(function(data){$scope.availableVLMs=data["identifiers"];$scope.addNoneOption()}).error(setErrorInScope.bind($scope));$scope.addNoneOption=function(){$scope.availableVLMs.unshift({id:"DSS_NO_SELECTION",friendlyName:"No VLM (text-first extraction)",type:""})};let piiDetectionInternalCodeEnvChecked=false;DataikuAPI.codeenvs.checkDSSInternalCodeEnv("PII_DETECTION_CODE_ENV").then(function({data}){if(Object.keys(data).length>0){$scope.piiDetectionInternalCodeEnv=data.value}piiDetectionInternalCodeEnvChecked=true}).catch(setErrorInScope.bind($scope));let ragInternalCodeEnvChecked=false;DataikuAPI.codeenvs.checkDSSInternalCodeEnv("RAG_CODE_ENV").then(function({data}){if(Object.keys(data).length>0){$scope.ragInternalCodeEnv=data.value}ragInternalCodeEnvChecked=true}).catch(setErrorInScope.bind($scope));let documentExtractionCodeEnvChecked=false;DataikuAPI.codeenvs.checkDSSInternalCodeEnv("DOCUMENT_EXTRACTION_CODE_ENV").then(function({data}){if(Object.keys(data).length>0){$scope.docExtractionInternalCodeEnv=data.value}documentExtractionCodeEnvChecked=true}).catch(setErrorInScope.bind($scope));$scope.piiDetectionInternalCodeEnvExists=function(){return piiDetectionInternalCodeEnvChecked&&$scope.piiDetectionInternalCodeEnv!=null};$scope.ragInternalCodeEnvExists=function(){return ragInternalCodeEnvChecked&&$scope.ragInternalCodeEnv!=null};$scope.documentExtractionInternalCodeEnvExists=function(){return documentExtractionCodeEnvChecked&&$scope.docExtractionInternalCodeEnv!=null};$scope.piiDetectionCodeEnvIsInternal=function(){return $scope.generalSettings&&$scope.generalSettings.generativeAISettings&&($scope.generalSettings.generativeAISettings.presidioBasedPIIDetectionCodeEnv==null||$scope.piiDetectionInternalCodeEnvExists()&&$scope.generalSettings.generativeAISettings.presidioBasedPIIDetectionCodeEnv==$scope.piiDetectionInternalCodeEnv.envName)};$scope.piiDetectionCodeEnvImageIsMissing=function(){return $scope.codeEnvImageIsMissing($scope.generalSettings?.generativeAISettings?.presidioBasedPIIDetectionContainerExecSelection,$scope.generalSettings?.generativeAISettings?.presidioBasedPIIDetectionCodeEnv||$scope.piiDetectionInternalCodeEnv?.envName)};$scope.ragCodeEnvIsInternal=function(){return $scope.generalSettings&&$scope.generalSettings.generativeAISettings&&($scope.generalSettings.generativeAISettings.defaultRetrievableKnowledgeCodeEnv==null||$scope.ragInternalCodeEnvExists()&&$scope.generalSettings.generativeAISettings.defaultRetrievableKnowledgeCodeEnv==$scope.ragInternalCodeEnv.envName)};$scope.ragCodeEnvImageIsMissing=function(){return $scope.codeEnvImageIsMissing($scope.generalSettings?.generativeAISettings?.defaultRetrievableKnowledgeContainerExecSelection,$scope.generalSettings?.generativeAISettings?.defaultRetrievableKnowledgeCodeEnv||$scope.ragInternalCodeEnv?.envName)};$scope.documentExtractionCodeEnvIsInternal=function(){return $scope.generalSettings&&$scope.generalSettings.generativeAISettings&&$scope.generalSettings.generativeAISettings.embedDocumentsRecipeSettings&&($scope.generalSettings.generativeAISettings.embedDocumentsRecipeSettings.textExtractionCodeEnv==null||$scope.documentExtractionInternalCodeEnvExists()&&$scope.generalSettings.generativeAISettings.embedDocumentsRecipeSettings.textExtractionCodeEnv==$scope.docExtractionInternalCodeEnv.envName)};$scope.documentExtractionCodeEnvImageIsMissing=function(){return $scope.codeEnvImageIsMissing($scope.generalSettings?.generativeAISettings?.embedDocumentsRecipeSettings?.documentExtractionContainerExecSelection,$scope.generalSettings?.generativeAISettings?.embedDocumentsRecipeSettings?.textExtractionCodeEnv||$scope.docExtractionInternalCodeEnv?.envName)};$scope.showPiiDetectionCodeEnvWarning=function(){return piiDetectionInternalCodeEnvChecked&&$scope.generalSettings&&$scope.generalSettings.generativeAISettings&&(!$scope.piiDetectionInternalCodeEnvExists()||!$scope.piiDetectionCodeEnvIsInternal()||$scope.piiDetectionCodeEnvImageIsMissing())};$scope.showRagCodeEnvWarning=function(){return ragInternalCodeEnvChecked&&$scope.generalSettings&&$scope.generalSettings.generativeAISettings&&(!$scope.ragInternalCodeEnvExists()||!$scope.ragCodeEnvIsInternal()||$scope.ragCodeEnvImageIsMissing())};$scope.showDocumentExtractionCodeEnvWarning=function(){return documentExtractionCodeEnvChecked&&$scope.generalSettings&&$scope.generalSettings.generativeAISettings&&(!$scope.documentExtractionInternalCodeEnvExists()||!$scope.documentExtractionCodeEnvIsInternal()||$scope.documentExtractionCodeEnvImageIsMissing())};$scope.fixupNullishPiiDetectionCodeEnvForDirtynessCheck=function(){if($scope.generalSettings.generativeAISettings.presidioBasedPIIDetectionCodeEnv==null){$scope.generalSettings.generativeAISettings.presidioBasedPIIDetectionCodeEnv=undefined}};$scope.fixupNullishEmbedDocumentTextExtractionCodeEnvForDirtynessCheck=function(){if($scope.generalSettings.generativeAISettings.embedDocumentsRecipeSettings.textExtractionCodeEnv==null){$scope.generalSettings.generativeAISettings.embedDocumentsRecipeSettings.textExtractionCodeEnv=undefined}};$scope.fixupNullishRagCodeEnvForDirtynessCheck=function(){if($scope.generalSettings.generativeAISettings.defaultRetrievableKnowledgeCodeEnv==null){$scope.generalSettings.generativeAISettings.defaultRetrievableKnowledgeCodeEnv=undefined}};$scope.internalCodeEnvsHRef=function(){if($scope.appConfig.isAutomation){return $state.href("admin.codeenvs-automation.internal")}else{return $state.href("admin.codeenvs-design.internal")}};$scope.availableTraceExplorerWebApps=[];$scope.$watch("generalSettings.generativeAISettings.llmTraceSettings.traceExplorerDefaultWebApp.projectKey",function(newProjectKey,oldProjectKey){if(newProjectKey){DataikuAPI.taggableObjects.listAccessibleObjects(newProjectKey,"WEB_APP").then(function(response){$scope.availableTraceExplorerWebApps=response.data.filter(object=>object.subtype==="webapp_traces-explorer_traces-explorer")})}if(newProjectKey===oldProjectKey){return}if($scope.generalSettings.generativeAISettings.llmTraceSettings.traceExplorerDefaultWebApp.webAppId&&oldProjectKey){$scope.generalSettings.generativeAISettings.llmTraceSettings.traceExplorerDefaultWebApp.webAppId=null}$scope.availableTraceExplorerWebApps=[]})});app.component("llmCostLimitingTable",{bindings:{costLimitingSettings:"=",fullAccess:"<",allowCustomQuotas:"<",channels:"<",mailChannels:"<",providers:"<",canEdit:"<"},templateUrl:"/templates/admin/cost-limiting/quotas-table.html",controller:function llmCostLimitingTableController($scope,$interval,$state,DataikuAPI,Dialogs,CreateModalFromTemplate,ClipboardUtils){const $ctrl=this;const FALLBACK_ID="DKU-FALLBACK-QUOTA";$ctrl.getSortExpression=function(expression){let fnExpression={isFiltered:$ctrl.isFiltered,getTotalCostSpent:$ctrl.getTotalCostSpent,getCostProgress:$ctrl.getCostProgress,periodicityAsMinutes:$ctrl.periodicityAsMinutes}[expression];return fnExpression?fnExpression:expression};$ctrl.selection={orderQuery:"",orderReversed:false,filterQuery:""};const unwatch=$scope.$watch("canEdit",function(){if($ctrl.canEdit){const llmConnectionTypes=["Anthropic","AzureLLM","AzureOpenAI","AzureAIFoundry","Bedrock","Cohere","DatabricksLLM","HuggingFaceLocal","mistral","OpenAI","SageMaker-GenericLLM","SnowflakeCortex","StabilityAI","VertexAILLM","NVIDIA-NIM"];DataikuAPI.admin.connections.list().success(function(data){$ctrl.llmConnections=Object.values(data).filter(c=>llmConnectionTypes.includes(c.type)).map(c=>({label:c.name,value:c.name})).sort((a,b)=>a.label.localeCompare(b.label))}).error(setErrorInScope.bind($ctrl));DataikuAPI.projects.list().success(function(projects){$ctrl.availableProjects=projects.map(p=>({label:p.name+" ("+p.projectKey+")",value:p.projectKey})).sort((a,b)=>a.label.localeCompare(b.label))}).error(setErrorInScope.bind($ctrl));DataikuAPI.security.listUsers().success(function(data){$ctrl.allUsers=data;$ctrl.enumUsers=data.map(u=>({label:u.displayName+" ("+u.login+")",value:u.login})).sort((a,b)=>a.label.localeCompare(b.label))}).error(setErrorInScope.bind($ctrl));DataikuAPI.security.listGroupsFull().success(function(data){$ctrl.allGroups=data.map(g=>({label:g.name,value:g.name})).sort((a,b)=>a.label.localeCompare(b.label))}).error(setErrorInScope.bind($ctrl))}unwatch()});$ctrl.costLimitingQuotaFilterSchema={columns:[{name:"project",type:"enum",$$groupKey:"DSS items"},{name:"user",type:"enum",$$groupKey:"DSS items"},{name:"groups",type:"enum[]",$$groupKey:"DSS items"},{name:"provider",type:"enum",$$groupKey:"DSS items"},{name:"connection",type:"enum",$$groupKey:"DSS items"},{name:"llmId",type:"string",$$groupKey:"Advanced fields"},{name:"projectKey",type:"string",$$groupKey:"Advanced fields"},{name:"userLogin",type:"string",$$groupKey:"Advanced fields"},{name:"connectionName",type:"string",$$groupKey:"Advanced fields"}]};$ctrl.getCostLimitingEnumValues=function(columnName){if(columnName=="provider"){return $ctrl.providers}else if(columnName=="project"){return $ctrl.availableProjects}else if(columnName=="connection"){return $ctrl.llmConnections}else if(columnName=="user"){return $ctrl.enumUsers}else if(columnName=="groups"){return $ctrl.allGroups}return null};const allCostLimitingPeriodicities=[{label:"Calendar Year",value:"YEAR",allowRollingPeriods:false,asMinutes:365*24*60},{label:"Calendar Quarter",value:"QUARTER",allowRollingPeriods:false,asMinutes:90*24*60},{label:"Calendar Month",value:"MONTH",allowRollingPeriods:false,asMinutes:30*24*60},{label:"Rolling Day(s)",value:"DAY",allowRollingPeriods:true,asMinutes:24*60},{label:"Rolling Minute(s)",value:"MINUTE",allowRollingPeriods:true,asMinutes:1}];$ctrl.costLimitingPeriodicities=allCostLimitingPeriodicities.filter(p=>window.dkuAppConfig.llmSettings.costLimitingPeriodicities.includes(p.value));const periodicityMap=$ctrl.costLimitingPeriodicities.reduce((acc,p)=>{acc[p.value]=p;return acc},{});$ctrl.onCostLimitingPeriodicityChange=function(quota){const periodicity=$ctrl.costLimitingPeriodicities.find(p=>p.value===quota.periodicity);if(periodicity&&!periodicity.allowRollingPeriods){quota.rollingPeriods=1}};$ctrl.shouldDisplayRollingPeriods=function(quota){const periodicity=periodicityMap[quota.periodicity];return periodicity&&periodicity.allowRollingPeriods};$ctrl.getCustomQuotasAllowedMessage=function(){return!$ctrl.allowCustomQuotas?"Custom quotas require Advanced LLM Mesh, which is not enabled in your license.":""};$ctrl.getPeriodicitySummary=function(quota){const periodicity=periodicityMap[quota.periodicity];if(!periodicity)return"";if(periodicity.allowRollingPeriods){return quota.rollingPeriods+" "+periodicity.label}else{return periodicity.label}};$ctrl.periodicityAsMinutes=function(quota){return quota.rollingPeriods*periodicityMap[quota.periodicity].asMinutes};$ctrl.getPeriodicityClass=function(){return $ctrl.fullAccess?"small":"large"};$ctrl.getThresholdAmount=function(quota,reportingAction){if(quota.costLimit&&reportingAction.threshold){const thresholdAmount=quota.costLimit*reportingAction.threshold/100;const formattedAmount=(Math.round(thresholdAmount*100)/100).toFixed(2);return"$"+formattedAmount}return""};$ctrl.getThresholdsLabel=function(quota){return quota.reportingActions.map(action=>action.threshold+"%").join(", ")};$ctrl.getReportingTargetsAsString=function(quota){return"Will notify "+quota.reportingTargets.map(t=>t.email).join(", ")};$ctrl.quotaHasReportingActions=function(quota){return quota.reportingActions&&quota.reportingActions.length||quota.blockingLimit};$ctrl.quotaHasRecipients=function(quota){if(!quota.reportingTargets||quota.reportingTargets.length==0){return false}return quota.reportingTargets.filter(t=>t.email&&t.email.length>0).length>0};$ctrl.validateReportingActions=function(quota){if($ctrl.quotaHasReportingActions(quota)){return quota.reportingActions.every(action=>!action.$invalid)}return true};$ctrl.reorderReportingActions=function(quota){if($ctrl.quotaHasReportingActions(quota)){quota.reportingActions.sort((a,b)=>parseFloat(a.threshold)-parseFloat(b.threshold))}};$ctrl.hasReportingActionAndNoQuotaAmount=function(quota){return quota.costLimit===0&&quota.reportingActions.length};$ctrl.hasNoMailChannelAvailable=function(){return $ctrl.channels&&!$ctrl.mailChannels.length};$ctrl.hasNoMailChannelSelected=function(quota){return $ctrl.mailChannels.length&&$ctrl.quotaHasReportingActions(quota)&&!quota.emailChannelId};$ctrl.hasSenderSetForMailChannel=function(quota){let selectedChannel=$ctrl.mailChannels.find(channel=>channel.id===quota.emailChannelId);return selectedChannel?.configuration?.sender};$ctrl.hasReportingActionsButNotRecipient=function(quota){return $ctrl.quotaHasReportingActions(quota)&&!$ctrl.quotaHasRecipients(quota)};$ctrl.getNotificationsIssues=function(quota){if($ctrl.hasNoMailChannelAvailable())return"You must define an email channel in the 'Notifications & Integrations > Messaging channels' section to send alerts.";if($ctrl.hasNoMailChannelSelected(quota))return"You must define a channel for alerts to be sent.";if(!$ctrl.hasSenderSetForMailChannel(quota))return"You must define a sender email for channel '"+quota.emailChannelId+"'";if($ctrl.hasReportingActionsButNotRecipient(quota))return"You must add recipients for alerts to be sent.";if($ctrl.hasReportingActionAndNoQuotaAmount(quota))return"You must define a quota amount > 0 for alerts to be sent.";return""};$ctrl.globalQuotaDescription="This quota will be applied to all queries.";$ctrl.describeFallbackScope=function(){return $ctrl.costLimitingSettings.quotas.length?"This quota will be applied for queries not matching any other quota.":$ctrl.globalQuotaDescription};$ctrl.progress={};let updateProgress=function(nospinner){DataikuAPI.admin.costLimiting.getProgress(nospinner).success(function(data){$ctrl.progress=data}).error(setErrorInScope.bind($ctrl))};updateProgress(false);const progressRefreshIntervalMs=1e4;const progressRefresher=$interval(()=>updateProgress(true),progressRefreshIntervalMs);$ctrl.$onDestroy=function(){$interval.cancel(progressRefresher)};$ctrl.getTotalCostSpent=function(quota){if($ctrl.progress[quota.id]){return $ctrl.progress[quota.id].accruedCost}else{return 0}};$ctrl.getAllowedQueries=function(quota){if($ctrl.progress[quota.id]){return $ctrl.progress[quota.id].allowedQueries}else{return 0}};$ctrl.getBlockedQueries=function(quota){if($ctrl.progress[quota.id]){return $ctrl.progress[quota.id].blockedQueries}else{return 0}};$ctrl.getCostProgress=function(quota){if(quota.withFullAccess){let progress=quota.costLimit?$ctrl.getTotalCostSpent(quota)*100/quota.costLimit:Infinity;if(progress===Infinity){return null}else{return progress}}else if($ctrl.progress[quota.id]){if($ctrl.progress[quota.id].progress!==undefined){return $ctrl.progress[quota.id].progress*100}else{return null}}else{if(quota.costLimit&&quota.costLimit>0){return 0}else if(quota.costLimit===0&&quota.blockingLimit){return null}else{return undefined}}};$ctrl.getProgressColorClass=function(quota){var progress=$ctrl.getCostProgress(quota);if(progress===null){if(quota.blockingLimit){return"gauge--error"}else{return"gauge--disabled"}}else if(progress===undefined){return"gauge--disabled"}else if(progress<75){return"gauge--success"}else if(progress<100){return"gauge--warning"}else{return"gauge--error"}};$ctrl.hasCostProgress=function(quota){var progress=$ctrl.getCostProgress(quota);return progress!==null&&progress!=undefined};$ctrl.isQuotaBlocked=function(quota){var progress=$ctrl.getCostProgress(quota);return quota.blockingLimit&&(progress>=100||progress===null)};$ctrl.isCustomQuota=function(quota){return quota.id!==FALLBACK_ID};const randomAlphaNumeric=function(length){let s="";while(s.length<length){s+=Math.random().toString(36).slice(2)}return s.slice(0,length)};const generateRandomQuotaId=function(){return randomAlphaNumeric(8)};const fillMissingId=function(quota){if(!quota.id){quota.id=generateRandomQuotaId()}return quota};const pushNewQuota=function(quota){$ctrl.costLimitingSettings.quotas.push(fillMissingId(quota))};const duplicateQuota=function(quota){let newQuota=angular.copy(quota);newQuota.id=generateRandomQuotaId();newQuota.name="Copy of "+newQuota.name;return newQuota};const deleteQuota=function(quota){$ctrl.costLimitingSettings.quotas=$ctrl.costLimitingSettings.quotas.filter(q=>q.id!=quota.id)};const openQuotaModal=function(quota,title,action,confirmCallback){CreateModalFromTemplate("/templates/admin/cost-limiting/quota-modal.html",$scope,null,function(modalScope){if(!quota.permissions)quota.permissions=[];modalScope.quota=fillMissingId(quota);modalScope.title=title;modalScope.action=action;modalScope.availableUsers=$ctrl.allUsers||[];modalScope.availableGroups=$ctrl.allGroups||[];modalScope.validate=function(quota){return(!$ctrl.isCustomQuota(quota)||quota.name)&&(quota.costLimit||quota.costLimit===0)&&quota.periodicity&&quota.rollingPeriods&&$ctrl.validateReportingActions(quota)};modalScope.confirm=function(quota){confirmCallback(quota);modalScope.dismiss()};modalScope.permissionsChange=function(event){quota.permissions=event;$scope.$apply()}})};$ctrl.openNewQuotaModal=function(){let newQuota={id:generateRandomQuotaId(),filter:{enabled:false,distinct:false,uiData:{conditions:[],mode:"&&"}},withFullAccess:true,periodicity:"MONTH",rollingPeriods:1,reportingActions:[],reportingTargets:[]};openQuotaModal(newQuota,"Create a quota","CREATE",pushNewQuota)};$ctrl.openEditQuotaModal=function(currentQuota,title){openQuotaModal(angular.copy(currentQuota),title||"Update a quota","UPDATE",quota=>angular.copy(quota,currentQuota))};$ctrl.openDuplicateQuotaModal=function(quota){openQuotaModal(duplicateQuota(quota),"Duplicate a quota","Duplicate",pushNewQuota)};$ctrl.openDeleteSingleQuotaDialog=function(quota){Dialogs.confirmInfoMessages($scope,"Confirm quota deletion",null,"<p>Are you sure you want to delete quota: <strong>"+sanitize(quota.name)+"</strong> (id:&nbsp;<em>"+sanitize(quota.id)+"</em>)</p>",false).then(function(){deleteQuota(quota)}).catch(()=>{})};$ctrl.openDeleteQuotasDialog=function(quotas){Dialogs.confirmInfoMessages($scope,"Confirm quotas deletion",null,"<p>Are you sure you want to delete the following quotas:</p><ul>"+quotas.map(quota=>"<li><strong>"+sanitize(quota.name)+"</strong> (id:&nbsp;<em>"+sanitize(quota.id)+"</em>)</li>").join("")+"</ul>",false).then(function(){quotas.forEach(quota=>deleteQuota(quota))}).catch(()=>{})};$ctrl.duplicateAndPushQuotas=function(quotas){quotas.forEach(quota=>{$ctrl.costLimitingSettings.quotas.push(duplicateQuota(quota))})};$ctrl.copyToClipboard=function(value){ClipboardUtils.copyToClipboard(value)}}});app.controller("CostLimitingListController",function($scope,$interval,$state,DataikuAPI,Dialogs,CreateModalFromTemplate,ClipboardUtils){$scope.userQuotas={};$scope.mailChannels=[];DataikuAPI.admin.costLimiting.getQuotas().success(function(data){$scope.userQuotas=data;$scope.fullAccess=data.quotas.some(quota=>quota.withFullAccess);if(data.fallbackQuota&&!$scope.fullAccess){$scope.fullAccess=data.fallbackQuota.withFullAccess}}).error(setErrorInScope.bind($scope));$scope.hasAuthorizedQuotas=function(){return $scope.userQuotas.quotas&&$scope.userQuotas.quotas.length||$scope.userQuotas.fallbackQuota}});app.controller("AdminCostLimitingController",function($scope,$interval,$state,DataikuAPI,Dialogs,CreateModalFromTemplate,ClipboardUtils){const _allCustomLLMPlugins=[...$scope.appConfig.customPythonLLMs,...$scope.appConfig.customJavaLLMs];$scope.providers=[{label:"Anthropic",value:"Anthropic"},{label:"Azure LLM",value:"AzureLLM"},{label:"Azure OpenAI",value:"AzureOpenAI"},{label:"AWS Bedrock",value:"Bedrock"},{label:"Cohere",value:"Cohere"},{label:"Local Hugging Face",value:"HuggingFaceLocal"},{label:"Mistral AI",value:"MistralAI"},{label:"OpenAI",value:"OpenAI"},{label:"Python Agents",value:"python-agent"},{label:"Stability AI",value:"StabilityAI"},{label:"Vertex AI",value:"VertexAILLM"},{label:"NVIDIA NIM",value:"NVIDIA-NIM"}];$scope.providers=$scope.providers.concat(Array.from(new Set(_allCustomLLMPlugins.map(llm=>llm.ownerPluginId))).map(pluginID=>$scope.appConfig.loadedPlugins.find(plugin=>plugin.id===pluginID)).filter(plugin=>plugin).map(p=>({label:"LLM Plugin: "+p.label,value:"CustomLLM:"+p.id})).sort((a,b)=>a.label.localeCompare(b.label)));$scope.providers=$scope.providers.concat(Array.from(new Set($scope.appConfig.customAgents.map(agent=>agent.ownerPluginId))).map(pluginID=>$scope.appConfig.loadedPlugins.find(plugin=>plugin.id===pluginID)).filter(plugin=>plugin).map(p=>({label:"Plugin Agent: "+p.label,value:"plugin-agent:"+p.id})).sort((a,b)=>a.label.localeCompare(b.label)));$scope.customQuotasAllowed=function(){return $scope.appConfig.licensedFeatures.advancedLLMMeshAllowed};$scope.dirtyCostLimitingSettings=function(){return $scope.savedGeneralSettings&&!angular.equals($scope.generalSettings.generativeAISettings.costLimitingSettings,$scope.savedGeneralSettings.generativeAISettings.costLimitingSettings)}});app.controller("AdminLLMRateLimitingController",function($scope,$state,DataikuAPI,Dialogs,CreateModalFromTemplate,localStorageService){$scope.baselineSettings={};$scope.allModelsByProvider={};$scope.filteredModelsByProvider={};$scope.applicableSettings={};$scope.selection={orderQuery:"id"};const FALLBACK_RPM=1e3;function buildApplicableSettings(){let userSettings=$scope.generalSettings.generativeAISettings.rateLimitingSettings;let applicableSettings=angular.copy($scope.baselineSettings);for(let providerId in applicableSettings){let userProviderSettings=userSettings.perProviderSettings[providerId]||{perModelConfigs:{}};let applicableProviderSettings=applicableSettings[providerId];applicableProviderSettings.completionDefault=userProviderSettings.completionDefault||applicableProviderSettings.completionDefault;applicableProviderSettings.embeddingDefault=userProviderSettings.embeddingDefault||applicableProviderSettings.embeddingDefault;applicableProviderSettings.imageGenerationDefault=userProviderSettings.imageGenerationDefault||applicableProviderSettings.imageGenerationDefault;applicableProviderSettings.rerankingDefault=userProviderSettings.rerankingDefault||applicableProviderSettings.rerankingDefault;for(let modelId in userProviderSettings.perModelConfigs){applicableProviderSettings.perModelConfigs[modelId]=userProviderSettings.perModelConfigs[modelId]}}return applicableSettings}function configIsDirty(defaultConfig,config){return defaultConfig==null||defaultConfig.managed!=config.managed||defaultConfig.requestsPerMinute!=config.requestsPerMinute}function watchApplicableSettings(){$scope.$watch("applicableSettings",function(){let currentCustomSettings={perProviderSettings:{}};const initializeProviderIfNeeded=providerId=>{if(!currentCustomSettings.perProviderSettings[providerId]){currentCustomSettings.perProviderSettings[providerId]={perModelConfigs:{}}}};$scope.applicableSettings.providerList?.forEach(provider=>{provider.purposes.forEach(purpose=>{if(configIsDirty(getDefaultConfigForPurpose(provider.id,purpose.id),purpose.config)){initializeProviderIfNeeded(provider.id);currentCustomSettings.perProviderSettings[provider.id][purpose.id]=purpose.config}})});for(let providerId in $scope.applicableSettings.modelConfigs){$scope.applicableSettings.modelConfigs[providerId].forEach(model=>{if(configIsDirty(getDefaultConfigForModel(providerId,model.id),model.config)){initializeProviderIfNeeded(providerId);currentCustomSettings.perProviderSettings[providerId].perModelConfigs[model.id]=model.config}})}$scope.generalSettings.generativeAISettings["rateLimitingSettings"]=currentCustomSettings},true)}function loadBaselineSettings(){return DataikuAPI.admin.rateLimiting.getDefaults().success(function(data){$scope.baselineSettings=data.baselineSettings;$scope.allModelsByProvider=data.models;let applicableSettings=buildApplicableSettings();$scope.applicableSettings.perProvider=applicableSettings;$scope.applicableSettings.providerList=[];for(let providerId in applicableSettings){let perProviderSettings=applicableSettings[providerId];let perPurposeConfigsList=[];["completionDefault","embeddingDefault","imageGenerationDefault","rerankingDefault"].forEach(purposeId=>{if(perProviderSettings[purposeId]){perPurposeConfigsList.push({id:purposeId,config:perProviderSettings[purposeId]})}});$scope.applicableSettings.providerList.push({id:providerId,purposes:perPurposeConfigsList,hasModelSortIdx:Object.keys($scope.allModelsByProvider).includes(providerId)?1:0})}$scope.applicableSettings.providerList=$scope.applicableSettings.providerList.sort((a,b)=>{return b.hasModelSortIdx-a.hasModelSortIdx||a.id.localeCompare(b.id)});$scope.applicableSettings.modelConfigs={};for(let providerId in applicableSettings){let perProviderSettings=applicableSettings[providerId];$scope.applicableSettings.modelConfigs[providerId]=[];for(let modelId in perProviderSettings.perModelConfigs){$scope.applicableSettings.modelConfigs[providerId].push({id:modelId,config:perProviderSettings.perModelConfigs[modelId]})}filterSuggestedModelsByProvider(providerId)}initExpandStatus()}).error(setErrorInScope.bind($scope))}let unwatchGeneralSettings=$scope.$watch("generalSettings",function(){if($scope.generalSettings){loadBaselineSettings().then(watchApplicableSettings);unwatchGeneralSettings()}});function filterSuggestedModelsByProvider(providerId){if($scope.allModelsByProvider[providerId]){$scope.filteredModelsByProvider[providerId]=$scope.allModelsByProvider[providerId].filter(modelId=>!$scope.modelAlreadyExists(providerId,modelId))}}function getDefaultConfigForPurpose(providerId,purposeId){return $scope.baselineSettings[providerId][purposeId||"completionDefault"]}function getDefaultConfigForModel(providerId,modelId){return $scope.baselineSettings[providerId].perModelConfigs[modelId]}function getDefaultApplicableRPMForProvider(providerId){let providerConfig=$scope.applicableSettings.perProvider[providerId]["completionDefault"]||{};return providerConfig.managed?getDefaultConfigForPurpose(providerId).requestsPerMinute:providerConfig.requestsPerMinute}$scope.getDefaultRPMForPurpose=function(providerId,purposeId){let defaultConfig=getDefaultConfigForPurpose(providerId,purposeId)||{};return defaultConfig.requestsPerMinute||FALLBACK_RPM};$scope.getDefaultRPM=function(providerId,modelId){if(modelId){let defaultModel=getDefaultConfigForModel(providerId,modelId);return defaultModel&&defaultModel.requestsPerMinute||getDefaultApplicableRPMForProvider(providerId)||0}else{let defaultProvider=getDefaultConfigForPurpose(providerId);return defaultProvider&&defaultProvider.requestsPerMinute||FALLBACK_RPM}};$scope.modelAlreadyExists=function(providerId,modelId){return $scope.applicableSettings.modelConfigs[providerId].some(model=>model.id==modelId)};$scope.addModelRateLimit=function(provider){const providerId=provider.id;const newModelId=provider.newModelId;$scope.applicableSettings.modelConfigs[providerId].push({id:newModelId,config:{managed:false,requestsPerMinute:$scope.getDefaultRPM(providerId,newModelId)}});filterSuggestedModelsByProvider(providerId);provider.newModelId=""};$scope.isDeleteModelAllowed=function(providerId,modelId){return!getDefaultConfigForModel(providerId,modelId)};function deleteModelConfig(providerId,modelId){$scope.applicableSettings.modelConfigs[providerId]=$scope.applicableSettings.modelConfigs[providerId].filter(model=>model.id!=modelId);filterSuggestedModelsByProvider(providerId)}$scope.openDeleteSingleConfigDialog=function(providerId,modelId){Dialogs.confirmInfoMessages($scope,"Confirm rate limit deletion for "+sanitize(providerId),null,"<p>Are you sure you want to delete the rate limit settings for model: <strong>"+sanitize(modelId)+"</strong></p>",false).then(function(){deleteModelConfig(providerId,modelId)}).catch(()=>{})};$scope.getAddRateLimitDisallowedMessage=function(providerId,newModelId){if(!newModelId){return"Model is empty"}if($scope.modelAlreadyExists(providerId,newModelId)){return"Settings are already set for this model"}return""};$scope.getSuggestedModelsForProvider=function(providerId){return $scope.filteredModelsByProvider[providerId]};const purposeLabels={completionDefault:"Other completion models",embeddingDefault:"Other embedding models",imageGenerationDefault:"Other image generation models",rerankingDefault:"Other reranking models"};$scope.labelForPurpose=function(purposeId){return purposeLabels[purposeId]};function matchFilter(value,filter){return value.toLowerCase().includes(filter)}$scope.filterProviders=function(filter){filter=filter&&filter.toLowerCase();return function(provider){return!filter||matchFilter(provider.id,filter)||$scope.applicableSettings.modelConfigs[provider.id].some(model=>matchFilter(model.id,filter))}};$scope.filterModels=function(providerId,filter){filter=filter&&filter.toLowerCase();return model=>!filter||matchFilter(providerId,filter)||matchFilter(model.id,filter)};const localStorageProviderExpandKey="rateLimitingSettingsProvidersExpand";$scope.expandStatus=localStorageService.get(localStorageProviderExpandKey)||{};function initExpandStatus(){if(!Object.keys($scope.expandStatus).length){let defaultExpandStatus={};Object.keys($scope.allModelsByProvider).forEach(provider=>defaultExpandStatus[provider]=true);$scope.expandStatus=defaultExpandStatus}}$scope.showProvider=function(providerId){return $scope.expandStatus[providerId]};$scope.toogleShowProvider=function(providerId){$scope.expandStatus[providerId]=!$scope.expandStatus[providerId];localStorageService.set(localStorageProviderExpandKey,$scope.expandStatus)}});app.controller("AdminVariablesController",function($scope,$state,$stateParams,DataikuAPI,WT1,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.executeVariablesUpdate=function(){$scope.save().then(function(){DataikuAPI.admin.executeVariablesUpdate().success(function(){$state.transitionTo($state.current,angular.copy($stateParams),{reload:true,inherit:true,notify:true})}).error(setErrorInScope.bind($scope))})}});app.controller("AdminThemeController",function($scope,$rootScope,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.getThemeThumbnailUrl=function(theme){var uri=$scope.getThemeUri(theme);return uri+theme.thumbnail};$scope.setCurrentTheme=function(theme){if(theme){$scope.generalSettings.themeId=theme.id}else{delete $scope.generalSettings.themeId}$scope.saveGeneralSettings().then(function(){$rootScope.appConfig.theme=theme;$scope.setTheme(theme)}).catch(setErrorInScope.bind($scope))};$scope.removeHomeMessage=function(homeMessage){var index=$scope.generalSettings.homeMessages.indexOf(homeMessage);if(index!=-1){$scope.generalSettings.homeMessages.splice(index,1)}}});app.controller("DeleteGlobalCategoryModalController",function($scope,$rootScope,$controller){function remove(index){let items=$scope.generalSettings.globalTagsCategories[index].globalTags;items.forEach(function(item){item.originalTagName=item.name;item.name="";item.removeUsage=true});$scope.updateGlobalTags();deleteKeep(index)}function deleteKeep(index){$scope.generalSettings.globalTagsCategories.splice(index,1);setTimeout(()=>$scope.save())}function reassign(index,reassignTo){if(reassignTo===undefined)return;$scope.generalSettings.globalTagsCategories[index].name=$scope.generalSettings.globalTagsCategories[reassignTo].name;$scope.updateGlobalTags();const tagsName=$scope.generalSettings.globalTagsCategories[reassignTo].globalTags.map(it=>it.name);var mergedGlobalTags=angular.copy($scope.generalSettings.globalTagsCategories[reassignTo].globalTags);$scope.generalSettings.globalTagsCategories[index].globalTags.forEach(function(tag){if(!tagsName.includes(tag.name)){mergedGlobalTags.push(tag)}});$scope.generalSettings.globalTagsCategories[reassignTo].globalTags=mergedGlobalTags;deleteKeep(index)}$scope.doDeleteGlobalCategory=function(){switch($scope.deletionMode){case"remove":remove($scope.index);break;case"reassign":reassign($scope.index,$scope.reassignTo);break;case"keep":deleteKeep($scope.index);break}$scope.dismiss()}});app.controller("MergeGlobalTagsModalController",function($scope,$rootScope,$controller){$scope.colors=window.dkuColorPalettes.discrete.find(palette=>palette.id==="dku_font").colors;$scope.doMergeTags=function(){$scope.items.forEach(function(item){item.originalTagName=item.name;item.name=$scope.outputTag.name;item.color=$scope.outputTag.color});if(!$scope.generalSettings.globalTagsCategories[$scope.index].globalTags.find(it=>(it.originalTagName||it.name)===$scope.outputTag.name)){$scope.items.shift()}$scope.updateGlobalTags();let indexes=$scope.items.map(it=>it.$idx);$scope.generalSettings.globalTagsCategories[$scope.index].globalTags=$scope.generalSettings.globalTagsCategories[$scope.index].globalTags.filter((it,index)=>!indexes.includes(index));$scope.save();$scope.dismiss()}});app.controller("DeleteGlobalTagsModalController",function($scope,$rootScope){function remove(items){items.forEach(function(item){item.originalTagName=item.name;item.name="";item.removeUsage=true});$scope.updateGlobalTags();deleteKeep(items)}function deleteKeep(items){let indexes=items.map(it=>it.$idx);$scope.generalSettings.globalTagsCategories[$scope.index].globalTags=$scope.generalSettings.globalTagsCategories[$scope.index].globalTags.filter((it,index)=>!indexes.includes(index));setTimeout(()=>$scope.save())}function reassign(items,reassignTo){if(reassignTo===undefined)return;items.forEach(function(item){item.originalTagName=item.name;item.name=reassignTo});$scope.updateGlobalTags();deleteKeep(items)}$scope.doDeleteGlobalTags=function(){switch($scope.deletionMode){case"remove":remove($scope.items);break;case"reassign":reassign($scope.items,$scope.reassignTo);break;case"keep":deleteKeep($scope.items);break}$scope.dismiss()}});app.controller("GlobalTagsController",function($scope,$element,$timeout,TaggingService,CreateModalFromTemplate,TAGGABLE_TYPES,DataikuAPI){$scope.colors=window.dkuColorPalettes.discrete.find(palette=>palette.id==="dku_font").colors;$scope.taggableTypes=["PROJECT","ANALYSIS","SAVED_MODEL","MODEL_EVALUATION_STORE","GENAI_EVALUATION_STORE","MODEL_COMPARISON","GENAI_COMPARISON","DATASET","RECIPE","LABELING_TASK","MANAGED_FOLDER","STREAMING_ENDPOINT","FLOW_ZONE","SQL_NOTEBOOK","SEARCH_NOTEBOOK","JUPYTER_NOTEBOOK","STATISTICS_WORKSHEET","SCENARIO","DASHBOARD","INSIGHT","ARTICLE","WEB_APP","CODE_STUDIO","REPORT","LAMBDA_SERVICE","RETRIEVABLE_KNOWLEDGE","PROMPT_STUDIO","SEMANTIC_MODEL","AGENT_TOOL","DATA_COLLECTION","ENTERPRISE_ASSET_COLLECTION","ENTERPRISE_ASSET"];$scope.computeItemTemplate=function(){return{name:"",color:TaggingService.getDefaultColor(Math.random().toString(36).slice(2)),isNew:true}};$scope.addCategory=function(){$scope.generalSettings.globalTagsCategories.push({name:"",globalTags:[],appliesTo:$scope.taggableTypes,isNew:true});$timeout(function(){const focusable=$element.find('input[ng-model="category.name"]').last();if(focusable){focusable.focus()}})};$scope.calcGlobalTagUsage=function(){DataikuAPI.catalog.search("",{scope:["dss"],_type:["ALL"]},true).then(data=>{$scope.tagUsageMap=data.data.aggregations["tag.raw"].agg.buckets.reduce(function(map,obj){map[obj.key]=obj.doc_count;return map},{})})};$scope.calcGlobalTagUsage();$scope.$on("generalSettingsSaved",$scope.calcGlobalTagUsage);$scope.getGlobalTagUsage=function(category,item){if(!$scope.tagUsageMap)return 0;let tagName=item.originalTagName||item.name;return $scope.tagUsageMap[`${category}:${tagName}`]};$scope.linkToCatalog=function(category,item){const tagName=item.originalTagName||item.name;const globalTagName=`${category}:${tagName}`.replace(/\\/g,"%5C").replace(/\//g,"~2F").replace(/&/g,"%5C&");return`/search-dss-items/scope=all&tag.raw=${globalTagName}`};$scope.updateItem=function(category,originalTagName,item){if(!item.isEdited){item.isEdited=true;item.originalTagName=originalTagName}};$scope.mergeTags=function(index,items){CreateModalFromTemplate("/templates/global-tags/merge-global-tags-modal.html",$scope,"MergeGlobalTagsModalController",function(modalScope){modalScope.index=index;modalScope.items=items;modalScope.outputTag=angular.copy(items[0])})};$scope.deleteGlobalCategory=function(index,categoryName){if($scope.generalSettings.globalTagsCategories[index].isNew){$scope.generalSettings.globalTagsCategories.splice(index,1);return}CreateModalFromTemplate("/templates/global-tags/delete-global-category-modal.html",$scope,"DeleteGlobalCategoryModalController",function(modalScope){modalScope.deletionMode="remove";modalScope.index=index;modalScope.categoryName=categoryName;modalScope.assignableCategoryList=$scope.generalSettings.globalTagsCategories.filter(cat=>cat.name!=categoryName).map((cat,idx)=>idx>=index?idx+1:idx)})};$scope.deleteGlobalTags=function(index,items){CreateModalFromTemplate("/templates/global-tags/delete-global-tags-modal.html",$scope,"DeleteGlobalTagsModalController",function(modalScope){modalScope.modalTitle=`Delete global tag${items.length>1?"s":""}`;modalScope.deletionMode="remove";modalScope.index=index;modalScope.items=items;modalScope.assignableTagsList=$scope.generalSettings.globalTagsCategories[index].globalTags.filter(it=>!items.includes(it)).map(it=>it.name)})}});app.controller("ProjectStatusController",function($scope,$rootScope,TopNav,DKUConstants,TaggingService){$scope.defaultTagColor=TaggingService.getDefaultColor;$scope.colors=window.dkuColorPalettes.discrete.find(palette=>palette.id==="dku_font").colors;$scope.newStatus={name:"",defaultColor:TaggingService.getDefaultColor("")};$scope.projectStatusList=[];$scope.promises.then(function(values){$scope.projectStatusList=angular.copy($scope.generalSettings.projectStatusList);var archivedStatusIndex=$scope.projectStatusList.findIndex(function(status){return status.name==DKUConstants.ARCHIVED_PROJECT_STATUS});var archivedStatus=archivedStatusIndex>-1?$scope.projectStatusList.splice(archivedStatusIndex,1):[];$scope.$watch("projectStatusList",function(){$scope.generalSettings.projectStatusList=$scope.projectStatusList.concat(archivedStatus)},true)})});app.controller("BrandColorsController",function($scope,ColorUtils){$scope.newBrandColor={defaultColor:"#FFFFFF"};$scope.brandColors=[];$scope.brandColorsPalette=ColorUtils.getDiscretePaletteColors("dku_font");$scope.promises.then(function(){$scope.brandColors=$scope.generalSettings.brandColors.map(brandColor=>({...brandColor,palette:$scope.brandColorsPalette}));$scope.$watch("brandColors",function(){$scope.generalSettings.brandColors=$scope.brandColors.map(brandColor=>{const cleanedBrandColor={...brandColor};delete cleanedBrandColor.palette;return cleanedBrandColor})},true)})});app.controller("AdminLicensingController",function($scope,$state,CreateModalFromTemplate,TopNav,DataikuAPI){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.$state=$state;$scope.enterLicense=function(){CreateModalFromTemplate("/templates/admin/enter-license.html",$scope,"EnterLicenseController")};$scope.fetchTrialUsersStatus=function(){DataikuAPI.admin.getTrialStatus().success(function(data){$scope.trialStatus=data}).error(setErrorInScope.bind($scope))};$scope.getLimits=function(){if($scope.isDSSAdmin()){DataikuAPI.admin.getLimitsStatus().success(function(data){$scope.limits=data}).error(setErrorInScope.bind($scope))}};$scope.getLimits()});app.controller("EnterLicenseController",function($scope,$state,$rootScope,DataikuAPI,Assert,TopNav,WT1){TopNav.setLocation(TopNav.DSS_HOME,"administration");Assert.inScope($scope,"appConfig");$scope.existingKey={};$scope.reloadMe=function(){$scope.dismiss();location.reload()};$scope.setLicense=function(){WT1.event("license-update");DataikuAPI.registration.setOfflineLicense($scope.existingKey.license).success(function(data){$scope.registrationSuccessful={}}).error(setErrorInScope.bind($scope))}});app.controller("AwsChannelController",function($scope,$state,$stateParams,DataikuAPI){});app.controller("MicrosoftGraphChannelController",function($scope,$state,$stateParams,DataikuAPI){});app.controller("SMTPChannelController",function($scope,$state,$stateParams,DataikuAPI){});app.controller("SlackChannelController",function($scope,$state,$stateParams,DataikuAPI){});app.controller("TeamsChannelController",function($scope,$state,$stateParams,DataikuAPI){if($scope.channel.configuration.useProxy===undefined){$scope.channel.configuration.useProxy=false}});app.controller("GoogleChatChannelController",function($scope,$state,$stateParams,DataikuAPI){});app.controller("WebhookChannelController",function($scope,$state,$stateParams,DataikuAPI){});app.controller("ShellChannelController",function($scope,$state,$stateParams,DataikuAPI,TopNav,CodeMirrorSettingService){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.channel.configuration.type=$scope.channel.configuration.type||"COMMAND";$scope.editorOptions=CodeMirrorSettingService.get("text/x-sh",{onLoad:function(cm){$scope.cm=cm}});$scope.shellSenderTypes=[{type:"FILE",name:"Script file"},{type:"COMMAND",name:"Command"}];$scope.getCommandLine=function(){if($scope.channel.configuration.type=="FILE"){if($scope.channel.configuration.command){return"sh -c "+$scope.channel.configuration.command+" script_file"}else{return"sh script_file"}}else{return $scope.channel.configuration.command}}});app.controller("DatasetChannelController",function($scope,$state,$stateParams,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");DataikuAPI.projects.list().success(function(data){$scope.projectsList=data}).error(setErrorInScope.bind($scope));$scope.$watch("channel.configuration.projectKey",function(){if($scope.channel.configuration.projectKey==null)return;DataikuAPI.datasets.list($scope.channel.configuration.projectKey).success(function(data){$scope.datasetsList=data}).error(setErrorInScope.bind($scope))})});app.controller("ContainerSettingsController",function($scope,DataikuAPI,Dialogs,Assert,TopNav,FutureProgressModal,CodeMirrorSettingService){TopNav.setLocation(TopNav.DSS_HOME,"administration");Assert.inScope($scope,"appConfig");Assert.inScope($scope,"addLicInfo");Assert.inScope($scope,"generalSettings");$scope.codeMirrorSettingService=CodeMirrorSettingService;$scope.settings=$scope.generalSettings.containerSettings;const getConfigurationsByWorkloadType=(configs,workloadType)=>{if(configs===null){return[]}return[{value:"",label:"Nothing selected"},...configs.filter(ec=>[workloadType,"ANY"].includes(ec.workloadType)&&!!ec.name).map(ec=>({value:ec.name,label:ec.name}))]};const setConfigurationsByWorkloadType=()=>{$scope.userCodeContainerConfigs=getConfigurationsByWorkloadType($scope.settings.executionConfigs,"USER_CODE");$scope.visualRecipesContainerConfigs=getConfigurationsByWorkloadType($scope.settings.executionConfigs,"VISUAL_RECIPES")};setConfigurationsByWorkloadType();$scope.$watch("settings.executionConfigs",setConfigurationsByWorkloadType,true);$scope.getNewContainerConfig=function(){return{type:"KUBERNETES",usableBy:"ALL",allowedGroups:[],workloadType:"ANY",dockerNetwork:"host",dockerResources:[],kubernetesResources:{memRequestMB:-1,memLimitMB:-1,cpuRequest:-1,cpuLimit:-1,customRequests:[],customLimits:[],hostPathVolumes:[]},properties:[]}};DataikuAPI.security.listGroups(false).success(data=>{if(data){data.sort()}$scope.allGroups=data}).error(setErrorInScope.bind($scope));$scope.isBaseImageNameSuspicious=function(baseImage){return/^(?:[\w-_]+\.)+\w+(?::\d+)?\//.test(baseImage)};$scope.installJupyterSupport=function(){DataikuAPI.admin.containerExec.installJupyterSupport().success(function(data){FutureProgressModal.show($scope,data,"(Re)Installing kernels").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result.messages,result.futureLog)}})}).error(setErrorInScope.bind($scope))};$scope.removeJupyterSupport=function(){DataikuAPI.admin.containerExec.removeJupyterSupport().success(function(data){FutureProgressModal.show($scope,data,"Removing kernels").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result.messages,result.futureLog)}})}).error(setErrorInScope.bind($scope))};$scope.applyK8SPolicies=function(){if($scope.dirtySettings()){$scope.save().then($scope.applyK8SPolicies_NoCheckDirty)}else{$scope.applyK8SPolicies_NoCheckDirty()}};$scope.applyK8SPolicies_NoCheckDirty=function(){DataikuAPI.admin.containerExec.applyK8SPolicies().success(function(data){FutureProgressModal.show($scope,data,"Applying Kubernetes policies").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Policies applied",result,result.futureLog,true)}})}).error(setErrorInScope.bind($scope))}});app.controller("BuildBaseImageModalController",function($scope){$scope.doBuild=function(){$scope.dismiss();$scope.buildBaseImage($scope.buildType,$scope.buildOptions)}});app.controller("AdminHelpSettingsController",function($scope,AccessibleObjectsCacheService){$scope.getAccessibleObjects=AccessibleObjectsCacheService.createCachedGetter("READ",$scope.setErrorInGeneralSettingsControllerScope).asValue;$scope.adminGeneralIndexForm.homeArticlesListInvalid=false;$scope.articlesAreValid=()=>{if($scope.generalSettings&&$scope.generalSettings.personalHomePages.articles){for(let elt of $scope.generalSettings.personalHomePages.articles){if(!Object.keys(elt).includes("projectKey")||!Object.keys(elt).includes("id")){$scope.adminGeneralIndexForm.homeArticlesListInvalid=true;return false}}}$scope.adminGeneralIndexForm.homeArticlesListInvalid=false;return true}});app.controller("AdminHomepageSettingsController",function($scope,AccessibleObjectsCacheService,Ng1PromotedContentAdminService,$q,DataikuAPI){$scope.getAccessibleObjects=AccessibleObjectsCacheService.createCachedGetter("READ",$scope.setErrorInGeneralSettingsControllerScope).asPromise;$scope.adminGeneralIndexForm.homepagePromotedContentInvalid=false;$scope.promotedContentIsValid=()=>{if($scope.generalSettings&&$scope.generalSettings.personalHomePages&&$scope.generalSettings.personalHomePages.promotedContent){for(let elt of $scope.generalSettings.personalHomePages.promotedContent){if(!$scope.isItemValid(elt)){$scope.adminGeneralIndexForm.homepagePromotedContentInvalid=true;return false}}}$scope.adminGeneralIndexForm.homepagePromotedContentInvalid=false;return true};const TYPES_WITHOUT_PROJECT_KEY=["WORKSPACE","DATA_COLLECTION","PROJECT","APP","ADMIN_MESSAGE","LINK"];const TYPES_WITHOUT_OBJECT=["ADMIN_MESSAGE","LINK"];$scope.isItemValid=function(item){if(!item){return false}if(!Object.keys(item).includes("type")){return false}if(!TYPES_WITHOUT_OBJECT.includes(item.type)&&!Object.keys(item).includes("id")){return false}if(!TYPES_WITHOUT_PROJECT_KEY.includes(item.type)&&!Object.keys(item).includes("projectKey")){return false}if(!item.$displayName){return false}return true};$scope.invalidItemReason=function(item){if(!item){return"Content is not defined"}if(!Object.keys(item).includes("type")){return"Type is missing"}if(!TYPES_WITHOUT_OBJECT.includes(item.type)&&!Object.keys(item).includes("id")){return"Id is missing"}if(!TYPES_WITHOUT_PROJECT_KEY.includes(item.type)&&!Object.keys(item).includes("projectKey")){return"Project key is missing"}if(!item.$displayName){return"Item does not exist, or has an empty display name"}return""};$scope.editPromotedContent=function(itemToEdit){return Ng1PromotedContentAdminService.openPromotedContentAdminModal({promotedContent:itemToEdit,getAccessibleObjectsCached:$scope.getAccessibleObjects,mode:"EDIT"}).then(output=>{if(output?.promotedContent){return setProjectAndDisplayName([output.promotedContent]).then(()=>output.promotedContent)}})};$scope.addPromotedContent=function(){$q.when(Ng1PromotedContentAdminService.openPromotedContentAdminModal({getAccessibleObjectsCached:$scope.getAccessibleObjects,mode:"ADD"})).then(output=>{if(output?.promotedContent){return setProjectAndDisplayName([output.promotedContent]).then(()=>{$scope.generalSettings.personalHomePages.promotedContent=[...$scope.generalSettings.personalHomePages.promotedContent,output.promotedContent]})}})};$scope.displayNamesLoaded=false;const deregister=$scope.$watch("generalSettings.personalHomePages.promotedContent",function(newValue){if(angular.isDefined(newValue)){$scope.displayNamesLoaded=false;setProjectAndDisplayName(newValue).then(()=>{$scope.displayNamesLoaded=true});deregister()}});function setProjectAndDisplayName(items){const taggableObjectRefs=[];items.forEach(item=>{if(item.type==="PROJECT"){taggableObjectRefs.push({type:item.type,id:item.id,projectKey:item.id})}else if(TYPES_WITHOUT_PROJECT_KEY.includes(item.type)){taggableObjectRefs.push({type:item.type,id:item.id,projectKey:""})}else{taggableObjectRefs.push({type:"PROJECT",id:item.projectKey,projectKey:item.projectKey});taggableObjectRefs.push({type:item.type,id:item.id,projectKey:item.projectKey})}});return DataikuAPI.admin.getPromotedContentDisplayNames(taggableObjectRefs).then(function({data}){const displayNames=data;items.forEach(item=>{setProjectName(item,displayNames);setDisplayName(item,displayNames)})}).catch(setErrorInScope.bind($scope))}function setProjectName(item,displayNames){if(!item){item.$projectName="";return}if(TYPES_WITHOUT_PROJECT_KEY.includes(item.type)){item.$projectName="";return}const taggableObjectRefKey=`{projectKey:${item.projectKey}, type:PROJECT, id:${item.projectKey}}`;if(angular.isDefined(displayNames[taggableObjectRefKey])){item.$projectName=displayNames[taggableObjectRefKey]}}function setDisplayName(item,displayNames){if(!item){item.$displayName="";return}if(item.type==="ADMIN_MESSAGE"){item.$displayName=item.customTitle;return}if(item.type==="LINK"){item.$displayName=item.customTitle||item.url;return}let projectKey="";if(item.type==="PROJECT"){projectKey=item.id}else if(!TYPES_WITHOUT_PROJECT_KEY.includes(item.type)){projectKey=item.projectKey}const taggableObjectRefKey=`{projectKey:${projectKey}, type:${item.type}, id:${item.id}}`;if(angular.isDefined(displayNames[taggableObjectRefKey])){item.$displayName=displayNames[taggableObjectRefKey]}}});app.controller("AdminOtherSecurityController",function($scope,DataikuAPI){$scope.updateExistingApiKeysLifetime=function(){if($scope.dirtySettings()){$scope.save().then($scope.updateExistingApiKeysLifetime_NoCheckDirty)}else{$scope.updateExistingApiKeysLifetime_NoCheckDirty()}};$scope.updateExistingApiKeysLifetime_NoCheckDirty=function(){DataikuAPI.admin.apiKeys.updateApiKeysLifetime().error(setErrorInScope.bind($scope))}});app.controller("AdminAIAssistantsSettingsController",function($scope,DataikuAPI){DataikuAPI.webapps.listAllBackendsStates().success(function(data){$scope.backends=data.filter(backend=>backend.backendState&&backend.backendState.hasExposedEndpoint).map(backend=>({...backend,webAppReference:backend.projectKey+"."+backend.webAppId}))}).error(setErrorInScope.bind($scope));$scope.webAppSearch=function(term,webapp){return webapp.webAppReference.toLowerCase().includes(term.toLowerCase())||webapp.webAppName.includes(term.toLowerCase())};$scope.aiAssistantsEnabled=false;$scope.$watch("[generalSettings.aiDrivenAnalyticsSettings, aiAssistantMode]",()=>{$scope.aiAssistantsEnabled=!$scope.appConfig?.communityEdition&&$scope.generalSettings?.aiDrivenAnalyticsSettings?.enabled&&($scope.generalSettings?.aiDrivenAnalyticsSettings?.dataikuAIServicesTermsOfUseAccepted||$scope.aiAssistantMode==="LLM_MESH_PLUGIN")},true);$scope.toggleAIAssistants=()=>{if($scope.aiAssistantsEnabled){if($scope.aiAssistantMode==="DATAIKU_AI_SERVICES"&&!$scope.generalSettings?.aiDrivenAnalyticsSettings?.dataikuAIServicesTermsOfUseAccepted){$scope.openAIServicesTermsOfUseModal().then(()=>{$scope.generalSettings.aiDrivenAnalyticsSettings.enabled=true},()=>{$scope.aiAssistantsEnabled=false})}else{$scope.generalSettings.aiDrivenAnalyticsSettings.enabled=true}}else{$scope.generalSettings.aiDrivenAnalyticsSettings.enabled=false}};$scope.isUsingLocalAssistant=()=>{return $scope.featureFlagEnabled&&$scope.featureFlagEnabled("localAIServerWebapp")&&$scope.generalSettings?.localAIServerSettings?.useLocalServer};$scope.aiServerOptions=[{value:"DATAIKU_AI_SERVICES",label:"Dataiku AI Services",description:"Use the AI Services hosted by Dataiku. You will need to accept the Dataiku AI Services Terms of Service."}];if($scope.featureFlagEnabled&&$scope.featureFlagEnabled("localAIServerWebapp")){$scope.aiServerOptions.push({value:"LLM_MESH_PLUGIN",label:"Locally-running",description:"Run the AI server locally directly within DSS, and use your own LLM. You will be able to choose which LLM to use. Results may vary depending on the LLM"})}else{$scope.aiServerOptions.push({value:"LLM_MESH_PLUGIN",label:"Locally-running",disabled:true,description:"Run the AI server locally directly within DSS, and use your own LLM. You will be able to choose which LLM to use. Please contact your Dataiku Customer Representative if you are interested in this option."})}$scope.$watch("generalSettings.localAIServerSettings",()=>{if($scope.isUsingLocalAssistant()&&!$scope.appConfig.communityEdition){$scope.aiAssistantMode="LLM_MESH_PLUGIN"}else{$scope.aiAssistantMode="DATAIKU_AI_SERVICES"}});$scope.toggleAssistantMode=()=>{switch($scope.aiAssistantMode){case"LLM_MESH_PLUGIN":$scope.generalSettings.localAIServerSettings.useLocalServer=true;$scope.generalSettings.aiDrivenAnalyticsSettings.telemetryEnabled=false;break;case"DATAIKU_AI_SERVICES":if(!$scope.generalSettings?.aiDrivenAnalyticsSettings?.dataikuAIServicesTermsOfUseAccepted){$scope.openAIServicesTermsOfUseModal().then(()=>{$scope.generalSettings.aiDrivenAnalyticsSettings.enabled=true;$scope.generalSettings.aiDrivenAnalyticsSettings.telemetryEnabled=true;$scope.generalSettings.localAIServerSettings.useLocalServer=false},()=>{$scope.aiAssistantMode="LLM_MESH_PLUGIN"})}else{$scope.generalSettings.aiDrivenAnalyticsSettings.telemetryEnabled=true;$scope.generalSettings.localAIServerSettings.useLocalServer=false}break;default:break}};$scope.$watch("generalSettings.localAIServerSettings.useLocalServer",function(newVal){if($scope.generalSettings&&newVal===true){$scope.generalSettings.storiesVocalEnabled=false}});$scope.getAssistantsDisabledOptionsTooltip=()=>{if(!$scope.aiAssistantsEnabled){return"AI assistants are not enabled"}return""};$scope.getStoriesVocalDisabledTooltip=()=>{if($scope.isUsingLocalAssistant()){return'AI vocal is only usable with "Dataiku AI Services" server'}return $scope.getAssistantsDisabledOptionsTooltip()};$scope.$watchGroup(["generalSettings.aiDrivenAnalyticsSettings.enabled",function(){return $scope.featureFlagEnabled&&$scope.featureFlagEnabled("storiesVocal")}],function([aiEnabled,flagEnabled]){if($scope.generalSettings&&!(aiEnabled&&flagEnabled)){$scope.generalSettings.storiesVocalEnabled=false}})});app.component("integrationChannelPermissions",{bindings:{permissions:"<",allUsers:"<",allGroups:"<"},templateUrl:"templates/admin/general/integration-channel-permissions.html",controller:function integrationChannelPermissionsController($scope){const $ctrl=this;function updateUnassignedGroups(){$ctrl.unassignedGroupIds=["$$ALL_USERS$$",...$ctrl.allGroups].filter(group=>!$ctrl.permissions.some(perm=>perm.group===group))}function updateUnassignedUsers(){$ctrl.unassignedUsers=$ctrl.allUsers.filter(user=>!$ctrl.permissions.some(perm=>perm.user===user.login))}$ctrl.$onChanges=changes=>{if(changes.allUsers){$ctrl.userLoginToDisplayName=new Map($ctrl.allUsers.map(user=>[user.login,user.displayName]))}if(changes.allGroups){$ctrl.groupIdToDisplayName=new Map($ctrl.allGroups.map(group=>[group,group]));$ctrl.groupIdToDisplayName.set("$$ALL_USERS$$","All Users")}if(changes.permissions||changes.allUsers){updateUnassignedUsers()}if(changes.permissions||changes.allGroups){updateUnassignedGroups()}};$ctrl.onUsersAdded=users=>{users.forEach(login=>{$ctrl.permissions.push({user:login,canUse:true})});updateUnassignedUsers();$scope.$applyAsync()};$ctrl.onGroupsAdded=groups=>{groups.forEach(group=>{$ctrl.permissions.push({group:group,canUse:true})});updateUnassignedGroups();$scope.$applyAsync()};$ctrl.removePermission=index=>{const removed=$ctrl.permissions.splice(index,1)[0];if(removed.user){updateUnassignedUsers()}else{updateUnassignedGroups()}}}})})();(function(){"use strict";var app=angular.module("dataiku.credentials",[]);app.factory("CredentialDialogs",function(CreateModalFromTemplate,$q,$state,$timeout,$window,DataikuAPI){function isConnectionCredential(credential){return credential&&["CONNECTION","VIRTUAL_CONNECTION","DATABRICKS_INTEGRATION"].includes(credential.requestSource)}function enterCredential($scope,credential){let deferred=$q.defer();resetErrorInScope($scope);if(credential.type==="SINGLE_FIELD"||credential.type==="BASIC"){CreateModalFromTemplate("/templates/profile/edit-connection-credential-modal.html",$scope,null,function(newScope){newScope.credential=credential;newScope.plugin=credential.pluginCredentialRequestInfo;newScope.credential.password="";newScope.passwordFieldTitle=credential.type==="BASIC"?"Password":"Credentials";newScope.isConnectionCredential=isConnectionCredential(credential);newScope.confirm=function(){let apiCall;if(isConnectionCredential(credential)){apiCall=DataikuAPI.profile.setBasicConnectionCredential(newScope.credential.connection,newScope.credential.user,newScope.credential.password)}else{apiCall=DataikuAPI.profile.pluginCredentials.setBasicCredential(newScope.plugin.pluginId,newScope.plugin.paramSetId,newScope.plugin.presetId,newScope.plugin.paramName,newScope.credential.user,newScope.credential.password)}return apiCall.success(function(){newScope.dismiss();deferred.resolve(false)}).error(deferred.reject)}})}else if(credential.type==="AZURE_OAUTH_DEVICECODE"){CreateModalFromTemplate("/templates/profile/edit-azure-oauth-connection-credential-modal.html",$scope,null,function(newScope){newScope.uiState={step:"STARTUP"};newScope.credential=credential;newScope.startStep1=function(){const state={name:$state.current.name,params:$state.params};DataikuAPI.profile.connectionCredentials.azureOAuthDeviceCodeDanceStep1(urlWithProtocolAndHost(),JSON.stringify(state),newScope.credential).success(function(data){newScope.uiState.step="STEP1_COMPLETE";newScope.uiState.deviceCode=data}).error(setErrorInScope.bind($scope))};newScope.startStep2=function(){const state={name:$state.current.name,params:$state.params};DataikuAPI.profile.connectionCredentials.azureOAuthDeviceCodeDanceStep2(urlWithProtocolAndHost(),JSON.stringify(state),newScope.credential).success(function(){newScope.dismiss();deferred.resolve(false)}).error(setErrorInScope.bind($scope))};newScope.startStep1()})}else if(credential.type==="OAUTH_REFRESH_TOKEN"){CreateModalFromTemplate("/templates/profile/edit-oauth-connection-credential-modal.html",$scope,null,function(newScope){newScope.credential=credential;newScope.plugin=credential.pluginCredentialRequestInfo;newScope.isConnectionCredential=isConnectionCredential(credential);newScope.confirm=function(){const state={name:$state.current.name,params:$state.params};return DataikuAPI.profile.startOAuth2AuthorizationFlow(urlWithProtocolAndHost(),JSON.stringify(state),newScope.credential).success(function(data){$window.location.href=data;deferred.resolve(true)}).error(setErrorInScope.bind($scope))}})}return deferred.promise}function oauth2Success(scope,credential,plugin){return CreateModalFromTemplate("/templates/profile/oauth2-callback-success-modal.html",scope,null,function(newScope){newScope.credential=credential;newScope.plugin=plugin;newScope.isConnectionCredential=isConnectionCredential(newScope.credential)})}function oauth2Error(scope,data,credential,plugin,error){return CreateModalFromTemplate("/templates/profile/oauth2-callback-error-modal.html",scope,null,function(newScope){newScope.credential=credential;newScope.plugin=plugin;newScope.error=error;newScope.isConnectionCredential=isConnectionCredential(newScope.credential);newScope.tryAgain=enterCredential.bind(this,newScope,newScope.credential)})}return{enterCredential:enterCredential,oauth2Success:oauth2Success,oauth2Error:oauth2Error}});app.controller("OAuth2CallbackController",function($scope,$rootScope,$timeout,$location,$state,DataikuAPI,CredentialDialogs){const code=$location.search().code;const state=$location.search().state;const error=$location.search().error;const errorDescription=$location.search().error_description;const errorUri=$location.search().error_uri;$location.search("code",null);$location.search("state",null);$location.search("error",null);$location.search("error_description",null);$location.search("error_uri",null);if(code||error||state){DataikuAPI.profile.exchangeAuthorizationCode(code,state,error,errorDescription,errorUri).success(function(data){$timeout(()=>data.isSuccess?CredentialDialogs.oauth2Success($rootScope,data.authorizationRequestInfo.credential,data.authorizationRequestInfo.credential.pluginCredentialRequestInfo):CredentialDialogs.oauth2Error($rootScope,data,data.authorizationRequestInfo.credential,data.authorizationRequestInfo.credential.pluginCredentialRequestInfo,data),100);const userCurrentState=JSON.parse(data.authorizationRequestInfo.userCurrentState);$state.go(userCurrentState.name,userCurrentState.params)}).error(setErrorInScope.bind($scope))}})})();(function(){"use strict";var app=angular.module("dataiku.connections",["dataiku.credentials"]);app.controller("_ConnectionsListBaseController",function($scope,$rootScope,TopNav,DataikuAPI,Dialogs,$timeout,$filter,$state,ConnectionUtils,CreateModalFromTemplate){$scope.noTags=true;$scope.noStar=true;$scope.noWatch=true;$scope.canIndexConnections=true;$scope.canCreateConnection=$state.is("admin.connections.list");$scope.noDelete=!$state.is("admin.connections.list");$scope.selection=$.extend({filterQuery:{userQuery:"",type:[]},filterParams:{userQueryTargets:["name","type","description"],exactMatch:["type"]},orderQuery:"creationTag.lastModifiedOn",orderReversed:false},$scope.selection||{});$scope.sortBy=[{value:"name",label:"Name"},{value:"type",label:"Type"},{value:"creationTag.lastModifiedOn",label:"Creation date"}];$scope.uiState=$scope.uiState||{};$scope.uiState.newConnectionQuery="";$scope.connectionGroups=buildConnectionList();TopNav.setLocation(TopNav.DSS_HOME,"administration");let pollPromise;function processRunningJobsRequest(data){let doRunningJobsRemain=false;$scope.listItems.forEach(conn=>{if(conn.name in data){conn.indexingMetadata=data[conn.name];if(conn.indexingMetadata.currentJobId){doRunningJobsRemain=true}}else if(conn.indexingMetadata&&conn.metadata.currentJobId){delete conn.indexingMetadata.currentJobId}});return doRunningJobsRemain}$scope.pollRunningJobs=function(){$timeout.cancel(pollPromise);DataikuAPI.admin.connections.listRunningJobs().success(function(data){let doRunningJobsRemain=processRunningJobsRequest(data);if(doRunningJobsRemain){pollPromise=$timeout(()=>{$scope.pollRunningJobs()},5e3)}})};$scope.niceConnectionTypeComparator=(a,b)=>{return $filter("connectionTypeToNameForList")(a.value).localeCompare($filter("connectionTypeToNameForList")(b.value))};$scope.setConnectionTypeFilter=connectionType=>{const index=$scope.selection.filterQuery.type.indexOf(connectionType);if(index>-1){$scope.selection.filterQuery.type.splice(index,1)}else{$scope.selection.filterQuery.type.push(connectionType)}};$scope.isIndexable=connection=>ConnectionUtils.isIndexable(connection);$scope.list=function(){var func=$state.is("admin.connections.hiveindexing")?DataikuAPI.admin.connections.listHiveVirtual:DataikuAPI.admin.connections.list;func().success(function(data){$scope.connections=data;$scope.listItems=$.map(data,function(v,k){return v});$scope.connectionTypes=[...new Set($scope.listItems.map(it=>it.type))];$scope.canIndexAllConnections=$scope.listItems.length>0;if($scope.listItems.find(c=>c.indexingMetadata&&c.indexingMetadata.currentJobId)){$scope.pollRunningJobs()}}).error(setErrorInScope.bind($scope))};$scope.$on("$destroy",function(){pollPromise&&$timeout.cancel(pollPromise)});$scope.$on("indexConnectionEvent",(event,connectionName)=>{createIndexConnectionsModal([connectionName])});$scope.list();$scope.deleteSelected=function(name){var selectedConnectionsNames=$scope.selection.selectedObjects.map(function(c){return c.name});Dialogs.confirm($scope,"Connection deletion","Are you sure you want to delete this connection ?").then(function(){DataikuAPI.admin.connections.delete(selectedConnectionsNames).success(function(data){$scope.list()}).error(setErrorInScope.bind($scope))})};let createIndexConnectionsModal=function(connectionNames){const newScope=$scope.$new();newScope.selectedConnections=connectionNames;CreateModalFromTemplate("/templates/admin/index-connections-modal.html",newScope,"IndexConnectionsModalController")};$scope.indexSelectedConnections=function(){createIndexConnectionsModal($scope.selection.selectedObjects.map(function(c){return c.name}))};$scope.isIndexationRunning=function(){return $scope.listItems&&$scope.listItems.find(c=>{return c&&c.indexingMetadata&&c.indexingMetadata.currentJobId})};$scope.abortIndexation=function(){DataikuAPI.admin.connections.abortIndexation().success(function(data){processRunningJobsRequest(data)}).error(setErrorInScope.bind($scope))};$scope.indexAllConnections=function(){CreateModalFromTemplate("/templates/admin/index-connections-modal.html",$scope,"IndexConnectionsModalController")};$scope.focusNewConnectionFilter=function(){$timeout(()=>{document.querySelector("#new-connection-query").focus()})};$scope.clearNewConnectionQuery=function($event){$scope.uiState.newConnectionQuery="";$scope.focusNewConnectionFilter();$event.stopPropagation()};$scope.filterNewConnectionGroups=function(connectionGroup){return connectionGroup.connections.some(connection=>connectionFound(connection,$scope.uiState.newConnectionQuery))};$scope.filterNewConnections=function(connection){return connectionFound(connection,$scope.uiState.newConnectionQuery)};function connectionFound(connection,query){query=query?.toLowerCase()||"";return(connection.title||"").toLowerCase().includes(query)||(connection.type||"").toLowerCase().includes(query)||(connection.category||"").toLowerCase().includes(query)}function buildConnectionList(){const categories=[{title:"SQL Databases",connections:[{type:"Snowflake"},{type:"Databricks"},{type:"Redshift",title:"Amazon Redshift"},{type:"BigQuery",title:"Google BigQuery"},{type:"Synapse",title:"Azure Synapse"},{type:"FabricWarehouse",title:"MS Fabric Warehouse"},{type:"PostgreSQL"},{type:"MySQL"},{type:"SQLServer",title:"MS SQL Server"},{type:"Oracle"},{type:"Teradata"},...$rootScope.featureFlagEnabled("lakebase")?[{type:"DatabricksLakebase",title:"Databricks Lakebase"}]:[],{type:"AlloyDB",title:"Google AlloyDB"},{type:"Athena"},{type:"Greenplum"},{type:"Vertica"},{type:"SAPHANA"},{type:"Netezza",title:"IBM Netezza"},{type:"Trino"},{type:"TreasureData"},{type:"Denodo"},...$rootScope.featureFlagEnabled("kdbplus")?[{type:"KDBPlus",title:"KDB+"}]:[],{type:"JDBC",title:"Other SQL databases"}]},{title:"File-based",connections:[...$scope.appConfig.canAccessCloudDataikerAdminCapabilities&&$scope.appConfig.admin?[{type:"Filesystem",title:"Server Filesystem"}]:[],{type:"FTP"},{type:"SSH",title:"SCP/SFTP"}]},{title:"Cloud Storages & Hadoop",connections:[{type:"EC2",title:"Amazon S3"},{type:"Azure",title:"Azure Blob Storage"},{type:"GCS",title:"Google Cloud Storage"},...$scope.appConfig.canAccessCloudDataikerAdminCapabilities?[{type:"HDFS",title:"Hadoop HDFS"}]:[],{type:"SharePointOnline",title:"SharePoint Online"},{type:"iceberg",title:"Iceberg"}]},{title:"NoSQL",connections:[{type:"MongoDB"},{type:"Cassandra"},{type:"ElasticSearch"},...$rootScope.featureFlagEnabled("DynamoDB")?[{type:"DynamoDB"}]:[]]},{title:"Managed Model Deployment Infrastructures",connections:[{type:"SageMaker",title:"Amazon SageMaker"},{type:"AzureML",title:"Azure Machine Learning"},{type:"VertexAIModelDeployment",title:"Google Vertex AI"},{type:"DatabricksModelDeployment",title:"Databricks Managed Model Deployment"}]},{title:"LLM Mesh",connections:[{type:"OpenAI"},{type:"AzureOpenAI",title:"Azure OpenAI"},{type:"AzureAIFoundry",title:"Azure AI Foundry"},{type:"AzureLLM",title:"Azure LLM"},{type:"Cohere"},{type:"Anthropic"},{type:"VertexAILLM",title:"Vertex Generative AI"},{type:"Bedrock",title:"AWS Bedrock"},{type:"DatabricksLLM",title:"Databricks Mosaic AI"},{type:"SnowflakeCortex",title:"Snowflake Cortex"},{type:"MistralAI"},...$scope.appConfig.canAccessCloudDataikerAdminCapabilities&&$scope.appConfig.admin?[{type:"HuggingFaceLocal",title:"Hugging Face"}]:[],{type:"SageMaker-GenericLLM",title:"SageMaker LLM"},{type:"StabilityAI"},{type:"CustomLLM",title:"Custom LLM"},{type:"Pinecone"},{type:"AzureAISearch",title:"Azure AI Search"},{type:"NVIDIA-NIM",title:"NVIDIA NIM"},{type:"RemoteMCP",title:"Remote MCP"}]},{title:"Other",connections:[{type:"Twitter"},...$scope.appConfig.streamingEnabled?[{type:"Kafka"}]:[],...$scope.appConfig.streamingEnabled?[{type:"SQS"}]:[]]}];categories.forEach(({title,connections})=>connections.forEach(connection=>connection.category=title));return categories}});app.controller("ConnectionsController",function($scope,$controller,TopNav,DataikuAPI,Dialogs,$timeout,$stateParams,ConnectionUtils,CreateModalFromTemplate){$controller("_ConnectionsListBaseController",{$scope:$scope})});app.controller("ConnectionsHiveIndexingController",function($scope,$controller,TopNav,DataikuAPI,Dialogs,$timeout,$stateParams,ConnectionUtils,CreateModalFromTemplate){$controller("_ConnectionsListBaseController",{$scope:$scope})});app.controller("IndexConnectionsModalController",function($scope,$state,$stateParams,TopNav,DataikuAPI,$timeout,FutureProgressModal,Dialogs){$scope.indexationMode="scan";$scope.loading=true;DataikuAPI.admin.connections.listProcessableConnections($scope.type,$scope.selectedConnections).success(function(response){$timeout(()=>{$scope.loading=false;$scope.processableConnections=response;$scope.$digest()})}).error(setErrorInScope.bind($scope));$scope.canStartIndexation=function(){return $scope.processableConnections&&($scope.indexationMode==="index"&&$scope.processableConnections.indexableConnections.length||$scope.indexationMode==="scan"&&$scope.processableConnections.scannableConnections.length)};$scope.startIndexation=function(){let indexationFunction;let connectionsToProcess;if($scope.indexationMode==="index"){indexationFunction=DataikuAPI.admin.connections.index;connectionsToProcess=$scope.processableConnections.indexableConnections}else if($scope.indexationMode==="scan"){indexationFunction=DataikuAPI.admin.connections.scan;connectionsToProcess=$scope.processableConnections.scannableConnections}indexationFunction(connectionsToProcess).success(function(data){var parentScope=$scope.$parent.$parent;$scope.pollRunningJobs();FutureProgressModal.show(parentScope,data,"Indexing",newScope=>newScope.tellToCloseWindow=true).then(function(result){if(result){Dialogs.infoMessagesDisplayOnly(parentScope,"Indexing result",result)}});$scope.dismiss()}).error(setErrorInScope.bind($scope))}});app.controller("ConnectionController",function($scope,$rootScope,$state,$stateParams,Assert,TopNav,DataikuAPI,SqlConnectionNamespaceService,DataikuCloudService){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.connectionParamsForm={};$scope.availableCatalogs=null;$scope.availableSchemasMap={};$scope.areAdvancedPropertiesInvalid=false;$scope.areAdvancedConnectionPropertiesInvalid=false;$scope.areJobLabelsInvalid=false;$scope.setAdvancedPropertiesValidity=function(isValid){$scope.areAdvancedPropertiesInvalid=!isValid};$scope.setAdvancedConnectionPropertiesValidity=function(isValid){$scope.areAdvancedConnectionPropertiesInvalid=!isValid};$scope.setJobLabelsValidity=function(isValid){$scope.areJobLabelsInvalid=!isValid};$scope.isConnectionParamsFormInvalid=function(){return $scope.connectionParamsForm.$invalid||$scope.areAdvancedPropertiesInvalid||$scope.areAdvancedConnectionPropertiesInvalid||$scope.areJobLabelsInvalid};DataikuAPI.admin.connections.list().success(function(data){$scope.connections=data}).error(setErrorInScope.bind($scope));DataikuAPI.security.listGroups(false).success(function(data){if(data){data.sort()}$scope.allGroups=data});function $canHaveProxy(connectionType){return $scope.appConfig.hasGlobalProxy&&["ElasticSearch","HTTP","FTP","EC2","GCS","Twitter","BigQuery","Snowflake","Azure","SAPHANA","SQS","Databricks","AzureML","VertexAIModelDeployment","SageMaker","DatabricksModelDeployment","SharePointOnline"].indexOf(connectionType)>=0}$scope.isFsProviderizable=function(t){return["Filesystem","FTP","SSH","HDFS","Azure","GCS","EC2","SharePointOnline","DatabricksVolume"].indexOf(t)>=0};$scope.canBeUsedAsVectorStore=function(t){return["ElasticSearch","AzureAISearch","Pinecone","GCS"].indexOf(t)>=0};$scope.getKBDisabledReason=function(){if(!$scope.connection.allowWrite){$scope.connection.allowKnowledgeBanks=false;return"Write permissions on the connection are required to use knowledge banks."}return null};function isNonDataConnection(connectionType){const managedModelDeploymentInfra=["SageMaker","AzureML","VertexAIModelDeployment","DatabricksModelDeployment"];const llmConnections=["Anthropic","AzureOpenAI","AzureAIFoundry","Bedrock","Cohere","CustomLLM","DatabricksLLM","HuggingFaceInferenceAPI","HuggingFaceLocal","MosaicML","NVIDIA-NIM","OpenAI","SageMaker-GenericLLM","SnowflakeCortex","VertexAILLMConnection"];const miscNonDataConnections=["RemoteMCP"];return llmConnections.includes(connectionType)||managedModelDeploymentInfra.includes(connectionType)||miscNonDataConnections.includes(connectionType)}Assert.trueish($stateParams.connectionName||$stateParams.type,"no $stateParams.connectionName and no $stateParams.type");if($stateParams.connectionName){$scope.creation=false;DataikuAPI.admin.connections.get($stateParams.connectionName).success(function(data){$scope.savedConnection=angular.copy(data);$scope.connection=data;$scope.connection.$canHaveProxy=$canHaveProxy(data.type);$scope.loadDone=true;SqlConnectionNamespaceService.setTooltips($scope,data.type);$scope.isPersonalConnection=data.owner!=null;if($scope.isPersonalConnection){$scope.usableBy={policy:data.usableBy==="ALLOWED"&&_.isEmpty(data.allowedGroups)?"CREATOR":data.usableBy}}else{$scope.usableBy={policy:data.usableBy}}}).error(setErrorInScope.bind($scope))}else if($stateParams.type){$scope.creation=true;$scope.savedConnection=null;$scope.isPersonalConnection=!$rootScope.appConfig.admin;$scope.usableBy={policy:$scope.isPersonalConnection?"CREATOR":"ALL"};$scope.connection={type:$stateParams.type,params:{namingRule:{}},credentialsMode:"GLOBAL",allowMirror:$stateParams.type=="Vertica"||$stateParams.type=="ElasticSearch",usableBy:"ALL",$canHaveProxy:$canHaveProxy($stateParams.type),useGlobalProxy:$stateParams.type=="ElasticSearch"?false:$canHaveProxy($stateParams.type)};if($scope.connection.type=="BigQuery"){$scope.connection.params.properties=[{name:"Timeout",value:180,secret:false}];$scope.connection.params.driverMode="DRIVERLESS";$scope.connection.params.authType="KEYPAIR";$scope.connection.params.forbidPartitionsWriteToNonPartitionedTable=true}else if($scope.connection.type=="Redshift"){$scope.connection.params.driverMode="MANAGED_LEGACY_POSTGRESQL";$scope.connection.params.redshiftAuthenticationMode="USER_PASSWORD"}else if($scope.connection.type=="Greenplum"){$scope.connection.params.driverMode="MANAGED_LEGACY_POSTGRESQL"}else if($scope.connection.type=="PostgreSQL"||$scope.connection.type==="AlloyDB"||$scope.connection.type=="SQLServer"||$scope.connection.type=="Snowflake"||$scope.connection.type=="Databricks"||$scope.connection.type=="DatabricksLakebase"){$scope.connection.params.driverMode="MANAGED"}else if($scope.connection.type=="Trino"){$scope.connection.params.driverMode="MANAGED";$scope.connection.params.authType="PASSWORD"}else if($scope.connection.type=="Teradata"){$scope.connection.params.properties=[{name:"CHARSET",value:"UTF8",secret:false}]}else if($scope.connection.type=="SSH"){$scope.connection.params.port=22}else if($scope.connection.type=="HDFS"){$scope.connection.params.hiveSynchronizationMode="KEEP_IN_SYNC"}else if($scope.connection.type=="EC2"){$scope.connection.params.credentialsMode="KEYPAIR";$scope.connection.params.switchToRegionFromBucket=true}else if($scope.connection.type=="Synapse"){$scope.connection.params.azureDWH=true;$scope.connection.params.autocommitMode=true;$scope.connection.params.driverMode="MANAGED"}else if($scope.connection.type=="GCS"){$scope.connection.params.authType="KEYPAIR"}else if($scope.connection.type==="RemoteMCP"){$scope.connection.params.authType="NONE";$scope.connection.params.oauthAuthMethod="CLIENT_SECRET_BASIC"}else if($scope.connection.type=="FabricWarehouse"){$scope.connection.params.grantType="AUTHORIZATION_CODE";$scope.connection.params["azureOAuthLoginEnabled"]=true;$scope.connection.params["kerberosLoginEnabled"]=false;$scope.connection.credentialsMode="GLOBAL";$scope.connection.params["port"]=1433;$scope.connection.params["refreshTokenRotation"]=false;$scope.connection.params.driverMode="MANAGED"}else if($scope.connection.type=="Oracle"){$scope.connection.params.maxIdentifierSize=30}else if($scope.connection.type=="Vertica"){$scope.connection.params.usePkce=true}else if($scope.connection.type=="TreasureData"){$scope.connection.params.region="US";$scope.connection.params.db="td-presto";$scope.connection.params.driverMode="MANAGED"}else if($scope.connection.type=="Athena"&&DataikuCloudService.isDataikuCloud()){$scope.connection.params.version="2.X";$scope.connection.params.jarsDirectory="/data/dataiku/datadir/lib/athena";$scope.connection.params.driverMode="CUSTOM"}else if($scope.connection.type=="iceberg"){$scope.connection.params.hadoopImpersonateUser=true;$scope.connection.params.icebergCatalogType="REST";$scope.connection.params.authType="PASSWORD";$scope.connection.params.icebergCatalogParams={};$scope.connection.params.cloudStorageProperties=true}$scope.connection.allowManagedFolders=$scope.isFsProviderizable($scope.connection.type);$scope.connection.allowKnowledgeBanks=$scope.canBeUsedAsVectorStore($scope.connection.type);$scope.connection.allowManagedDatasets=$scope.connection.allowWrite=!isNonDataConnection($scope.connection.type);$scope.loadDone=true}$scope.customFieldsMap=$rootScope.appConfig.customFieldsMap["CONNECTION"];$scope.isConnectionNameUnique=function(v){if(v==null)return true;if($scope.connections==null)return true;return!$scope.connections.hasOwnProperty(v)};$scope.isConnectionNameValid=function(){return $scope.connection&&$scope.connection.name&&$scope.connection.name.length};function usableByToConnection(connection,usableByPolicy){const tmpConnection=angular.copy(connection);switch(usableByPolicy){case"CREATOR":tmpConnection.usableBy="ALLOWED";tmpConnection.allowedGroups=[];break;default:tmpConnection.usableBy=usableByPolicy}return tmpConnection}$scope.connectionDirty=function(){return!angular.equals(usableByToConnection($scope.connection,$scope.usableBy.policy),$scope.savedConnection)};$scope.saveConnection=function(){if($scope.isConnectionParamsFormInvalid()){return}if($scope.connection.params.regionOrEndpoint!=null&&$scope.connection.params.regionOrEndpoint.toLowerCase().startsWith("https://")){$scope.connection.params.switchToRegionFromBucket=false}const tmpConnection=usableByToConnection($scope.connection,$scope.usableBy.policy);DataikuAPI.admin.connections.save(tmpConnection,$scope.creation).success(function(data){$scope.savedConnection=tmpConnection;$scope.availableCatalogs=null;$scope.availableSchemasMap={};$state.transitionTo("admin.connections.edit",{connectionName:$scope.connection.name})}).error(setErrorInScope.bind($scope))};$scope.$watch("connection.allowWrite",function(a){if(!a&&$scope.connection){$scope.connection.allowManagedDatasets=false;$scope.connection.allowManagedFolders=false;$scope.connection.allowKnowledgeBanks=false}});$scope.canSwitchToRegionFromBucket=function(endpoint){return!endpoint||!endpoint.toLowerCase().startsWith("https://")};$scope.fetchNamespaces=function(connectionName,origin,connectionType,inputBtnName){SqlConnectionNamespaceService.listIcebergNamespaces(connectionName,$scope,origin,connectionType,inputBtnName)};$scope.fetchCatalogs=function(connectionName,origin,connectionType,inputBtnName){SqlConnectionNamespaceService.listSqlCatalogs(connectionName,$scope,origin,connectionType,inputBtnName)};$scope.fetchSchemas=function(connectionName,catalog,origin,connectionType,inputBtnName){SqlConnectionNamespaceService.listSqlSchemas(connectionName,$scope,catalog,origin,connectionType,inputBtnName)};$scope.$on("$destroy",function(){SqlConnectionNamespaceService.abortListSqlSchemas($scope);SqlConnectionNamespaceService.abortListSqlCatalogs($scope);SqlConnectionNamespaceService.abortListIcebergNamespaces($scope)})});app.controller("SQLConnectionController",function($scope,$controller,DataikuAPI,$timeout,$rootScope,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.supportsWriteSQLComment=function(type){return["Snowflake","Databricks","PostgreSQL","Oracle","Redshift","MySQL","BigQuery"].includes(type)};$scope.supportsWriteSQLCommentInCreateTableStatement=type=>{return["Snowflake","BigQuery","Databricks","MySQL"].includes(type)};if(!$scope.connection.params.properties){$scope.connection.params.properties=[]}if($scope.creation){const dp=$rootScope.appConfig&&$rootScope.appConfig.namingRulesSettings&&$rootScope.appConfig.namingRulesSettings.defaultPrefixForTables?$rootScope.appConfig.namingRulesSettings.defaultPrefixForTables:"${projectKey}_";$scope.connection.params.namingRule.tableNameDatasetNamePrefix=dp;$scope.connection.params.writeDatasetDescriptionAsSQLComment=$scope.supportsWriteSQLCommentInCreateTableStatement($scope.connection.type);$scope.connection.params.writeColumnDescriptionsAsSQLComment=$scope.supportsWriteSQLCommentInCreateTableStatement($scope.connection.type);$scope.connection.params.namingRule.writeDatasetDescriptionAsSQLComment="INHERIT";$scope.connection.params.namingRule.writeColumnDescriptionsAsSQLComment="INHERIT"}if(!$scope.connection.params.dkuProperties){$scope.connection.params.dkuProperties=[]}$scope.warnings={noVariableInTable:false};if(!$scope.connection.customBasicConnectionCredentialProviderParams){$scope.connection.customBasicConnectionCredentialProviderParams=[]}$scope.checkForHttpInHostUrl=host=>host&&(host.startsWith("http://")||host.startsWith("https://"));if($scope.connection.type==="Teradata"&&$scope.creation){$scope.connection.params.defaultAssumedTzForUnknownTz="GMT";$scope.connection.params.defaultAssumedDbTzForUnknownTz="GMT"}if($scope.connection.type==="Databricks"&&$scope.creation){$scope.connection.params.useManagedDatasetCatalogAndSchema=true;$scope.connection.params.version=""}$scope.$watch("connection.params",function(nv,ov){$scope.warnings.noVariableInTable=false;if($scope.connection.type=="BigQuery"){if(nv.authType=="OAUTH"){$scope.connection.credentialsMode="PER_USER"}else if(nv.authType=="KEYPAIR"){$scope.connection.credentialsMode="GLOBAL"}}if($scope.connection.type=="Databricks"&&nv.authType=="OAUTH2_APP"&&$scope.connection.params.authType!=$scope.savedConnection.params.authType){$scope.connection.credentialsMode="PER_USER"}if($scope.connection.type=="Trino"&&nv.authType=="OAUTH2"&&$scope.connection.params.authType!=$scope.savedConnection.params.authType){$scope.connection.credentialsMode="PER_USER"}if(!nv)return;if(!$scope.connection.allowManagedDatasets)return;if((!nv.namingRule.tableNameDatasetNamePrefix||nv.namingRule.tableNameDatasetNamePrefix.indexOf("${")==-1)&&(!nv.namingRule.tableNameDatasetNameSuffix||nv.namingRule.tableNameDatasetNameSuffix.indexOf("${")==-1)&&(!nv.namingRule.schemaName||nv.namingRule.schemaName.indexOf("${")==-1)){$scope.warnings.noVariableInTable=true}},true);$scope.$watch("connection.credentialsMode",function(nv,ov){if($scope.connection.type=="BigQuery"){if(nv=="GLOBAL"){if($scope.connection.params.authType=="OAUTH"){$scope.connection.params.authType="KEYPAIR"}}else if(nv=="PER_USER"){$scope.connection.params.authType="OAUTH"}}});$scope.uiState={};$scope.testConnection=function(){if(!$scope.connectionParamsForm||$scope.connectionParamsForm.$valid){DataikuAPI.admin.connections.testSQL($scope.connection,null).success(function(data){if($scope.connection.params.driverMode==="CUSTOM"&&data.version){$scope.connection.params.version=data.version.version}$scope.testResult=data}).error(setErrorInScope.bind($scope))}};$scope.getCatalog=function(){if($scope.connection.type==="BigQuery"){return $scope.connection.params.projectId}if($scope.connection.type==="Snowflake"){return $scope.connection.params.db}if($scope.connection.type==="Databricks"){return $scope.connection.params.defaultCatalog}if($scope.connection.type==="SQLServer"){return $scope.connection.params.db}if($scope.connection.type==="MySQL"){return $scope.connection.params.db}return null};$scope.$watch("connection",function(nv,ov){if(nv!=null){if(!$scope.connection.params.properties){$scope.connection.params.properties=[]}}});$scope.warnAboutSearchPath=function(){if($scope.connection.params.schemaSearchPath){if($scope.connection.params.namingRule.schemaName){return false}if($scope.connection.params.schemaSearchPath.indexOf(",public,")>0){return false}if($scope.connection.params.schemaSearchPath.endsWith(",public")){return false}if($scope.connection.params.schemaSearchPath.startsWith("public,")){return false}if($scope.connection.params.schemaSearchPath=="public"){return false}return true}else{return false}};$scope.connectionHasConceptOfDefaultCatalogAndSchema=function(){if(!$scope.connection)return false;return["MySQL","Snowflake","BigQuery","SQLServer","Databricks"].indexOf($scope.connection.type)>=0};$scope.dialects=[{value:"",label:"Default"},{value:"MySQLDialect",label:"MySQL < 8.0"},{value:"MySQL8Dialect",label:"MySQL >= 8.0"},{value:"PostgreSQLDialect",label:"PostgreSQL"},{value:"OracleSQLDialect",label:"Oracle"},{value:"SQLServerSQLDialect",label:"SQL Server"},{value:"SynapseSQLDialect",label:"Azure Synapse"},{value:"FabricWarehouseSQLDialect",label:"MS Fabric Warehouse"},{value:"GreenplumSQLDialect",label:"Greenplum < 5.0"},{value:"Greenplum5SQLDialect",label:"Greenplum >= 5.0"},{value:"TeradataSQLDialect",label:"Teradata"},{value:"VerticaSQLDialect",label:"Vertica"},{value:"RedshiftSQLDialect",label:"Redshift"},{value:"SybaseIQSQLDialect",label:"Sybase IQ"},{value:"AsterDataSQLDialect",label:"Aster Data"},{value:"NetezzaSQLDialect",label:"IBM Netezza"},{value:"BigQuerySQLDialect",label:"Google BigQuery"},{value:"SAPHANASQLDialect",label:"SAP HANA"},{value:"ExasolSQLDialect",label:"Exasol"},{value:"SnowflakeSQLDialect",label:"Snowflake"},{value:"DatabricksSQLDialect",label:"Databricks"},{value:"DB2SQLDialect",label:"IBM DB2"},{value:"H2SQLDialect",label:"H2 < 2.0"},{value:"H2V2SQLDialect",label:"H2 >= 2.0"},{value:"ImpalaSQLDialect",label:"Impala"},{value:"HiveSQLDialect",label:"Hive"},{value:"PrestoSQLDialect",label:"Presto"},{value:"TrinoSQLDialect",label:"Trino"},{value:"AthenaSQLDialect",label:"Athena"},{value:"SparkSQLDialect",label:"SparkSQL (via JDBC)"},{value:"SqreamSQLDialect",label:"SQream"},{value:"YellowbrickSQLDialect",label:"Yellowbrick"},{value:"DremioSQLDialect",label:"Dremio"},{value:"DenodoSQLDialect",label:"Denodo"}];if($rootScope.featureFlagEnabled("kdbplus")){$scope.dialects.push({value:"KDBSQLDialect",label:"KDB+"})}$rootScope.appConfig.customDialects.forEach(function(d){$scope.dialects.push({value:d.dialectType,label:d.desc.meta.label||d.id})})});app.controller("PostgreSQLConnectionController",function($scope,$controller,DataikuAPI){$controller("SQLConnectionController",{$scope:$scope});$scope.testConnection=function(){if(!$scope.connectionParamsForm||$scope.connectionParamsForm.$valid){$scope.testing=true;DataikuAPI.admin.connections.testPostgreSQL($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(function(a,b,c){$scope.testing=false;setErrorInScope.bind($scope)(a,b,c)})}}});app.controller("FilesystemConnectionController",function($scope,$controller,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.notTestable=true;if(!$scope.connection.params.dkuProperties){$scope.connection.params.dkuProperties=[]}});app.controller("HDFSConnectionController",function($scope,$controller,$rootScope,TopNav,$stateParams,DataikuAPI,FutureProgressModal,Dialogs){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.isExtraHadoopConfigurationInvalid=false;$scope.setExtraHadoopConfigurationValidity=function(isValid){$scope.isExtraHadoopConfigurationInvalid=!isValid};$scope.isConnectionParamsFormInvalid=function(){return $scope.connectionParamsForm.$invalid||$scope.isExtraHadoopConfigurationInvalid||$scope.areAdvancedConnectionPropertiesInvalid};$scope.notTestable=true;if($scope.creation){const dpp=$rootScope.appConfig&&$rootScope.appConfig.namingRulesSettings&&$rootScope.appConfig.namingRulesSettings.defaultPrefixForPath?$rootScope.appConfig.namingRulesSettings.defaultPrefixForPath:"${projectKey}/";const dpt=$rootScope.appConfig&&$rootScope.appConfig.namingRulesSettings&&$rootScope.appConfig.namingRulesSettings.defaultPrefixForTables?$rootScope.appConfig.namingRulesSettings.defaultPrefixForTables:"${projectKey}_";$scope.connection.params.namingRule.hdfsPathDatasetNamePrefix=dpp;$scope.connection.params.namingRule.tableNameDatasetNamePrefix=dpt}if(!$scope.connection.customBasicConnectionCredentialProviderParams){$scope.connection.customBasicConnectionCredentialProviderParams=[]}if(!$scope.connection.params.dkuProperties){$scope.connection.params.dkuProperties=[]}$scope.warnings={noVariableInPath:false,noVariableInHive:false};$scope.$watch("connection.params",function(nv,ov){$scope.warnings.noVariableInPath=false;$scope.warnings.noVariableInHive=false;if(!nv)return;if(!$scope.connection.allowManagedDatasets)return;if((!nv.namingRule.hdfsPathDatasetNamePrefix||nv.namingRule.hdfsPathDatasetNamePrefix.indexOf("${")==-1)&&(!nv.namingRule.hdfsPathDatasetNameSuffix||nv.namingRule.hdfsPathDatasetNameSuffix.indexOf("${")==-1)){$scope.warnings.noVariableInPath=true}if((!nv.namingRule.tableNameDatasetNamePrefix||nv.namingRule.tableNameDatasetNamePrefix.indexOf("${")==-1)&&(!nv.namingRule.tableNameDatasetNameSuffix||nv.namingRule.tableNameDatasetNameSuffix.indexOf("${")==-1)&&(!nv.namingRule.hiveDatabaseName||nv.namingRule.hiveDatabaseName.indexOf("${")==-1)){$scope.warnings.noVariableInHive=true}},true);$scope.resyncPermissions=function(){DataikuAPI.admin.connections.hdfs.resyncPermissions($stateParams.connectionName).success(function(data){FutureProgressModal.show($scope,data,"Permissions update").then(function(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result)})}).error(setErrorInScope.bind($scope))};$scope.resyncRootPermissions=function(){DataikuAPI.admin.connections.hdfs.resyncRootPermissions($stateParams.connectionName).success(function(data){FutureProgressModal.show($scope,data,"Permissions update")}).error(setErrorInScope.bind($scope))};DataikuAPI.projects.list().success(function(data){$scope.projectsList=data;if(data.length){$scope.massImportTargetProjectKey=data[0].projectKey;$scope.massImportTargetProjectName=data[0].name}$scope.$watch("massImportTargetProjectKey",function(){var filteredProjects=$scope.projectsList.filter(function(project){return project.projectKey==$scope.massImportTargetProjectKey});if(filteredProjects&&filteredProjects.length){$scope.massImportTargetProjectName=filteredProjects[0].name}else{$scope.massImportTargetProjectName=null}})}).error(setErrorInScope.bind($scope))});app.controller("EC2ConnectionController",function($scope,$controller,DataikuAPI,TopNav,$rootScope){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.testConnection=function(){if(!$scope.connectionParamsForm||$scope.connectionParamsForm.$valid){$scope.testing=true;if($scope.connection.params.regionOrEndpoint!=null&&$scope.connection.params.regionOrEndpoint.toLowerCase().startsWith("https://")){$scope.connection.params.switchToRegionFromBucket=false}DataikuAPI.admin.connections.testEC2($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(function(a,b,c){$scope.testing=false;setErrorInScope.bind($scope)(a,b,c)})}};if($scope.creation){$scope.connection.params["defaultManagedPath"]="/dataiku";$scope.connection.params["hdfsInterface"]="S3A";if($rootScope.appConfig&&$rootScope.appConfig.namingRulesSettings&&$rootScope.appConfig.namingRulesSettings.defaultPrefixForPath){$scope.connection.params.namingRule.pathDatasetNamePrefix=$rootScope.appConfig.namingRulesSettings.defaultPrefixForPath}}if(!$scope.connection.params.customAWSCredentialsProviderParams){$scope.connection.params.customAWSCredentialsProviderParams=[]}if(!$scope.connection.customBasicConnectionCredentialProviderParams){$scope.connection.customBasicConnectionCredentialProviderParams=[]}if(!$scope.connection.params.dkuProperties){$scope.connection.params.dkuProperties=[]}});app.controller("DatabricksVolumeConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.testConnection=function(){if(!$scope.connectionParamsForm||$scope.connectionParamsForm.$valid){$scope.testing=true;DataikuAPI.admin.connections.testDatabricksVolume($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(function(a,b,c){$scope.testing=false;setErrorInScope.bind($scope)(a,b,c)})}};if($scope.creation){$scope.connection.params["defaultManagedPath"]="/dataiku"}if(!$scope.connection.params.dkuProperties){$scope.connection.params.dkuProperties=[]}});app.controller("SageMakerConnectionController",function($scope,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.testConnection=function(){$scope.testing=true;$scope.testResult=null;if($scope.connection.params.regionOrEndpoint!=null&&$scope.connection.params.regionOrEndpoint.toLowerCase().startsWith("https://")){$scope.connection.params.switchToRegionFromBucket=false}DataikuAPI.admin.connections.testSageMaker($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(function(a,b,c){$scope.testing=false;setErrorInScope.bind($scope)(a,b,c)})};if($scope.creation){$scope.connection.params.credentialsMode="STS_ASSUME_ROLE"}});app.controller("GCSConnectionController",function($scope,$controller,$rootScope,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.testConnection=function(){if(!$scope.connectionParamsForm||$scope.connectionParamsForm.$valid){$scope.testing=true;DataikuAPI.admin.connections.testGCS($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(function(a,b,c){$scope.testing=false;setErrorInScope.bind($scope)(a,b,c)})}};$scope.$watch("connection.params",function(nv,ov){if(nv.authType=="OAUTH"){$scope.connection.credentialsMode="PER_USER"}else{$scope.connection.credentialsMode="GLOBAL"}},true);if($scope.creation){$scope.connection.params["defaultManagedPath"]="/dataiku";$scope.connection.params["hdfsInterface"]="GS";if($rootScope.appConfig&&$rootScope.appConfig.namingRulesSettings&&$rootScope.appConfig.namingRulesSettings.defaultPrefixForPath){$scope.connection.params.namingRule.pathDatasetNamePrefix=$rootScope.appConfig.namingRulesSettings.defaultPrefixForPath}}if(!$scope.connection.params.dkuProperties){$scope.connection.params.dkuProperties=[]}});app.controller("SharePointOnlineConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testSharePointOnline($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(function(a,b,c){$scope.testing=false;setErrorInScope.bind($scope)(a,b,c)})};if($scope.creation){$scope.connection.params={};$scope.connection.params["defaultManagedPath"]="/dataiku/";$scope.connection.params.authType="OAUTH2_APP";$scope.connection.credentialsMode="PER_USER";$scope.connection.params.credentialsMode="PER_USER";$scope.connection.allowManagedDatasets=true;$scope.connection.allowManagedFolders=true;$scope.connection.allowWrite=true;$scope.connection.params.scopes="User.Read Files.ReadWrite.All Sites.ReadWrite.All Sites.Manage.All offline_access";$scope.connection.params.authorizationEndpoint="https://login.microsoftonline.com/common/oauth2/v2.0/authorize";$scope.connection.params.tokenEndpoint="https://login.microsoftonline.com/common/oauth2/v2.0/token"}if(!$scope.connection.params.properties){$scope.connection.params.properties=[]}if(!$scope.connection.params.dkuProperties){$scope.connection.params.dkuProperties=[]}if(!$scope.connection.credentialsMode){$scope.connection.credentialsMode="PER_USER"}if($scope.connection.authType=="PASSWORD"){$scope.connection.credentialsMode="GLOBAL"}$scope.$watch("connection.credentialsMode",function(nv,ov){if(!nv||nv===ov)return;if(nv==="GLOBAL"){$scope.connection.params.scopes="https://graph.microsoft.com/.default"}else{$scope.connection.params.scopes="User.Read Files.ReadWrite.All Sites.ReadWrite.All Sites.Manage.All offline_access"}},true)});app.controller("VertexAIModelDeploymentConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.testConnection=function(){$scope.testing=true;$scope.testResult=null;DataikuAPI.admin.connections.testVertexAIModelDeployment($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(function(a,b,c){$scope.testing=false;setErrorInScope.bind($scope)(a,b,c)})};$scope.$watch("connection.params",function(nv,ov){if(nv.authType=="OAUTH"){$scope.connection.credentialsMode="PER_USER"}else{$scope.connection.credentialsMode="GLOBAL"}},true);if($scope.creation){$scope.connection.params.authType="KEYPAIR";$scope.connection.params.dkuProperties=[]}});app.controller("DatabricksModelDeploymentConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.testConnection=function(){$scope.testing=true;$scope.testResult=null;DataikuAPI.admin.connections.testDatabricksModelDeployment($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(function(a,b,c){$scope.testing=false;setErrorInScope.bind($scope)(a,b,c)})};$scope.$watch("connection.params",function(nv){if(nv.authType=="PERSONAL_ACCESS_TOKEN"){$scope.connection.credentialsMode="GLOBAL"}},true);if($scope.creation){$scope.connection.params.authType="PERSONAL_ACCESS_TOKEN";$scope.connection.params.dkuProperties=[]}});app.controller("AzureConnectionController",function($scope,$controller,$rootScope,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.testConnection=function(){if(!$scope.connectionParamsForm||$scope.connectionParamsForm.$valid){$scope.testing=true;DataikuAPI.admin.connections.testAzure($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(function(a,b,c){$scope.testing=false;setErrorInScope.bind($scope)(a,b,c)})}};if($scope.creation){$scope.connection.params["defaultManagedPath"]="/dataiku";$scope.connection.params["defaultManagedContainer"]="dataiku";$scope.connection.params["useSSL"]=true;$scope.connection.params["authType"]="SHARED_KEY";$scope.connection.params["hdfsInterface"]="ABFS";if($rootScope.appConfig&&$rootScope.appConfig.namingRulesSettings&&$rootScope.appConfig.namingRulesSettings.defaultPrefixForPath){$scope.connection.params.namingRule.pathDatasetNamePrefix=$rootScope.appConfig.namingRulesSettings.defaultPrefixForPath}}if(!$scope.connection.params.dkuProperties){$scope.connection.params.dkuProperties=[]}});app.controller("AzureMLConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.testConnection=function(){$scope.testing=true;$scope.testResult=null;DataikuAPI.admin.connections.testAzureML($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(function(a,b,c){$scope.testing=false;setErrorInScope.bind($scope)(a,b,c)})};if($scope.creation){$scope.connection.params["authType"]="OAUTH2_APP"}if(!$scope.connection.params.dkuProperties){$scope.connection.params.dkuProperties=[]}});app.controller("ElasticSearchConnectionController",function($scope,$controller,DataikuAPI,TopNav,$rootScope){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.availableAuthTypes=[["NONE","None","No authentication needed",null],["PASSWORD","Simple","Provide a user and a password",null],["OAUTH2_APP","OAuth","Use an authentication service supporting OAuth v2.0",null],["AWS_KEYPAIR","AWS keypair","AccessId + SecretId. Supports only OpenSearch.","KEYPAIR"],["AWS_ENVIRONMENT","AWS Environment","Use credentials from environment variables, or ~/.aws/credentials file, or instance profile. Supports only OpenSearch.","ENVIRONMENT"],["AWS_STS","AWS STS with AssumeRole","Assume a role, with master credentials coming from the environment. Supports only OpenSearch.","STS_ASSUME_ROLE"],["AWS_CUSTOM","AWS custom provider","Use a third-party authentication provider. Supports only OpenSearch.","CUSTOM_PROVIDER"]];$scope.availableAuthTypesDesc=$scope.availableAuthTypes.map(x=>x[2]);$scope.availableAWSAuthTypesDesc=$scope.availableAuthTypes.reduce((acc,x)=>{acc[x[0]]=x[3];return acc},{});$scope.availableAWSServiceTypes=[["OPENSEARCH_SERVERLESS","OpenSearch Serverless","You are connecting to a AWS serverless instance of OpenSearch."],["OPENSEARCH_HOSTED","Managed OpenSearch","You are connecting to a managed OpenSearch instance hosted on AWS."]];$scope.availableAWSServiceTypesDesc=$scope.availableAWSServiceTypes.map(x=>x[2]);$scope.connectionParamsForm={};if($scope.creation){$scope.connection.params["host"]="localhost";$scope.connection.params["port"]=9200;$scope.connection.params["dialect"]="ES_7";$scope.connection.params["connectionLimit"]=8;$scope.connection.params["oauth"]={};$scope.connection.params["aws"]={service:"OPENSEARCH_SERVERLESS"};$scope.connection.params["authType"]="NONE";const dp=$rootScope.appConfig&&$rootScope.appConfig.namingRulesSettings&&$rootScope.appConfig.namingRulesSettings.defaultPrefixForTables?$rootScope.appConfig.namingRulesSettings.defaultPrefixForTables:"${projectKey}_";$scope.connection.params.namingRule.indexNameDatasetNamePrefix=dp}$scope.isConnectionParamsFormInvalid=function(){return $scope.connectionParamsForm.$invalid};$scope.checkForHttpInHostUrl=host=>host&&(host.startsWith("http://")||host.startsWith("https://"));$scope.testConnection=function(){if(!$scope.connectionParamsForm||$scope.connectionParamsForm.$valid){DataikuAPI.admin.connections.testElasticSearch($scope.connection,null).success(function(data){if(data.dialect&&data.dialect!==$scope.connection.params.dialect){data.dialectMismatch=true}$scope.testResult=data}).error(setErrorInScope.bind($scope))}};$scope.warnings={noVariableInIndex:false};$scope.isIndexNameAllowed=function(v){if(!v){return true}return v.match(/^(?:[^.?+*|{}[\]()"\\#@&<>~ ]|\$\{[^}]*\})+$/)!==null};$scope.getKBDisabledReason=function(){if($scope.connection.params.dialect!=="ES_7"){$scope.connection.allowKnowledgeBanks=false;return"Knowledge banks require at least ElasticSearch version 7 or OpenSearch."}if($scope.connection.params.authType=="OAUTH2_APP"){$scope.connection.allowKnowledgeBanks=false;return"Knowledge banks are not supported with OAuth authentication."}if(!$scope.connection.allowWrite){$scope.connection.allowKnowledgeBanks=false;return"Write permissions on the connection are required to use knowledge banks."}return null};$scope.fixDialectMismatch=function(){if($scope.testResult&&$scope.testResult.dialect!=$scope.connection.params.dialect){$scope.connection.params.dialect=$scope.testResult.dialect;$scope.testConnection()}};$scope.$watch("connection.params",function(nv,ov){$scope.warnings.noVariableInIndex=false;$scope.connection.params.aws["credentialsMode"]=$scope.availableAWSAuthTypesDesc[$scope.connection.params.authType];if((!nv.namingRule.indexNameDatasetNamePrefix||nv.namingRule.indexNameDatasetNamePrefix.match(/^.*\$\{[^}]*\}.*$/)===null)&&(!nv.namingRule.indexNameDatasetNameSuffix||nv.namingRule.indexNameDatasetNameSuffix.match(/^.*\$\{[^}]*\}.*$/)===null)){$scope.warnings.noVariableInIndex=true}},true)});app.controller("RemoteMCPConnectionController",function($scope,TopNav,ConnectionsService,CreateModalFromTemplate,DataikuAPI){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.$watch("connection.params.authType",function(nv,ov){if(nv===ov){return}if(nv==="OAUTH2"){if(!$scope.canUseGlobalCredentialsMode()){$scope.connection.credentialsMode="PER_USER"}}else{$scope.connection.credentialsMode="GLOBAL"}},true);$scope.openDiscoverOAuthConfigModal=function(){const newScope=$scope.$new();newScope.connection=$scope.connection;CreateModalFromTemplate("/templates/admin/discover-oauth-config-modal.html",newScope,"DiscoverOAuthConfigController")};$scope.openOAuthDynamicClientRegistrationModal=function(){const newScope=$scope.$new();newScope.connection=$scope.connection;CreateModalFromTemplate("/templates/admin/oauth-dcr-modal.html",newScope,"OAuthDynamicClientRegistrationController")};$scope.canUseGlobalCredentialsMode=function(){if($scope.connection.params.authType!=="OAUTH2"){return true}return $scope.connection.params.oauthServerMetadata&&$scope.connection.params.oauthServerMetadata.grantTypesSupported&&$scope.connection.params.oauthServerMetadata.grantTypesSupported.includes("client_credentials")};$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testRemoteMCP($scope.connection).success(function(data){$scope.testResult=data;$scope.testResult.credentialsError=ConnectionsService.getCredentialsError($scope.testResult.connectionErrorMsg)}).error(setErrorInScope.bind($scope)).finally(function(){$scope.testing=false})}});app.controller("DiscoverOAuthConfigController",function($scope,DataikuAPI){$scope.config=null;$scope.loading=true;DataikuAPI.admin.connections.discoverOAuthConfig($scope.connection).success(function(data){$scope.config=data.params}).error(setErrorInScope.bind($scope)).finally(function(){$scope.loading=false});$scope.useConfig=function(){$scope.connection.params.oauthServerMetadata=$scope.config.oauthServerMetadata;$scope.connection.params.oauthAuthMethod=$scope.config.oauthAuthMethod;$scope.connection.params.scope=$scope.config.scope;$scope.dismiss()}});app.controller("OAuthDynamicClientRegistrationController",function($scope,DataikuAPI){$scope.oauthDCRInfo=null;$scope.registerDynamicOAuthClient=function(){DataikuAPI.admin.connections.registerDynamicOAuthClient($scope.connection,urlWithProtocolAndHost()).success(function(data){$scope.oauthDCRInfo=data;if(!$scope.hasWarnings()){$scope.acceptDCRInfo();$scope.dismiss()}}).error(setErrorInScope.bind($scope))};$scope.hasWarnings=function(){return $scope.oauthDCRInfo&&$scope.oauthDCRInfo.warnings&&$scope.oauthDCRInfo.warnings.length>0};$scope.ignoreWarnings=function(){$scope.acceptDCRInfo();$scope.dismiss()};$scope.acceptDCRInfo=function(){$scope.connection.params.clientId=$scope.oauthDCRInfo.clientId;$scope.connection.params.clientSecret=$scope.oauthDCRInfo.clientSecret;$scope.connection.params.oauthAuthMethod=$scope.oauthDCRInfo.authMethod}});app.controller("TwitterConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.connection.allowWrite=false;$scope.connection.allowManagedDatasets=false;$scope.connection.allowMirror=false;$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testTwitter($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})};$scope.clearForm=function(){$scope.connection.params.api_key="";$scope.connection.params.api_secret="";$scope.connection.params.token_key="";$scope.connection.params.token_secret="";$scope.verified=false};DataikuAPI.connections.getTwitterConfig().success(function(data){var activeConnection=data.connection;$scope.isActive=$scope.connection.name===activeConnection;$scope.isRunning=data.running.length>0}).error(function(){setErrorInScope.bind($scope);$scope.isActive=false});$scope.setActiveConnection=function(name){DataikuAPI.admin.connections.setActiveTwitterConnection(name).success(function(){$scope.isActive=true}).error(setErrorInScope.bind($scope))};DataikuAPI.connections.getNames("Twitter").success(function(data){$scope.displaySetActive=data.length>1}).error(setErrorInScope.bind($scope))});app.controller("_LLMConnectionController",function($scope,DataikuAPI,$state){$scope.openAiConnections=[];$scope.huggingFaceLocalConnections=[];if($scope.connection.params.imageAuditManagedFolderRef){const chunks=$scope.connection.params.imageAuditManagedFolderRef.split(".");$scope.imageStorage={projectKey:chunks[0],managedFolderId:chunks[1]}}else{$scope.imageStorage={projectKey:null,managedFolderId:null}}$scope.showFineTuningSettings=function(){return $scope.appConfig.licensedFeatures.advancedLLMMeshAllowed};DataikuAPI.pretrainedModels.listAvailableConnectionLLMs("GENERIC_COMPLETION").success(function(data){$scope.availableCompletionLLMs=data["identifiers"]}).error(setErrorInScope.bind($scope));$scope.showFineTuningSettingsIfConnectionAllowsIt=function(allowFinetuning){return $scope.showFineTuningSettings()&&allowFinetuning};$scope.$watch("imageStorage.projectKey",function(nv,ov){if(nv!==ov){$scope.imageStorage.managedFolderId="";$scope.connection.params.imageAuditManagedFolderRef=$scope.imageStorage.projectKey+"."}});$scope.$watch("imageStorage.managedFolderId",function(nv,ov){if(nv!==ov){$scope.connection.params.imageAuditManagedFolderRef=$scope.imageStorage.projectKey+"."+$scope.imageStorage.managedFolderId}});const deregister=$scope.$watch("connection.params",function(nv){if(!nv)return;if($scope.creation){$scope.connection.params.auditingMode="METADATA_ONLY";$scope.connection.params.guardrailsPipelineSettings={guardrails:[]};$scope.connection.params.cachingEnabled=false;$scope.connection.params.embeddingsCachingEnabled=true;$scope.connection.params.networkSettings={queryTimeoutMS:6e4,maxRetries:3,initialRetryDelayMS:3e3,retryDelayScalingFactor:2}}deregister()})});app.constant("OpenAiModelTypes",[{rawValue:"COMPLETION_CHAT_MULTIMODAL",displayName:"Chat completion (multimodal)"},{rawValue:"COMPLETION_CHAT",displayName:"Chat completion"},{rawValue:"COMPLETION_CHAT_NO_SYSTEM_PROMPT",displayName:"Chat completion (no system message)"},{rawValue:"COMPLETION_SIMPLE",displayName:"Simple completion (legacy)"},{rawValue:"TEXT_EMBEDDING_EXTRACTION",displayName:"Embedding"},{rawValue:"IMAGE_GENERATION",displayName:"Image Generation"}]);app.constant("OpenAIAPIModes",[{rawValue:"RESPONSES",displayName:"Responses API"},{rawValue:"CHAT_COMPLETIONS",displayName:"Chat Completions API"}]);app.constant("OpenAiMaxTokensAPIModes",[{rawValue:"AUTO",displayName:"Auto"},{rawValue:"MODERN",displayName:"Modern",description:"Use max_completion_tokens parameter"},{rawValue:"LEGACY",displayName:"Legacy",description:"Use max_tokens parameter (deprecated by OpenAI)"}]);app.constant("AzureOpenAiMaxTokensAPIModes",[{rawValue:"MODERN",displayName:"Modern (gpt5*, gpt4*, o*)",description:"Use max_completion_tokens parameter"},{rawValue:"LEGACY",displayName:"Legacy (gpt3* or earlier)",description:"Use max_tokens parameter"}]);app.constant("OpenAIImageHandlingModes",[{rawValue:"DALL_E_3",displayName:"Dall-E 3"},{rawValue:"GPT_IMAGE_1",displayName:"GPT Image"}]);app.controller("OpenAiConnectionController",function($scope,$controller,TopNav,DataikuAPI,OpenAiModelTypes,OpenAiMaxTokensAPIModes,OpenAIImageHandlingModes,OpenAIAPIModes){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});if($scope.creation){$scope.connection.params.allowFinetuning=false;$scope.connection.params["allowGPT52"]=true;$scope.connection.params["allowGPT51"]=false;$scope.connection.params["allowGPT5"]=false;$scope.connection.params["allowGPT5Mini"]=true;$scope.connection.params["allowGPT5Nano"]=true;$scope.connection.params["allowGPT5Chat"]=false;$scope.connection.params["allowGPT41"]=false;$scope.connection.params["allowGPT41Mini"]=false;$scope.connection.params["allowGPT41Nano"]=false;$scope.connection.params["allowGPT4oMini"]=false;$scope.connection.params["allowGPT35Turbo"]=false;$scope.connection.params["allowGPT4"]=false;$scope.connection.params["allowGPT4Turbo"]=false;$scope.connection.params["allowGPT4o"]=false;$scope.connection.params["allowO3"]=false;$scope.connection.params["allowO4Mini"]=false;$scope.connection.params["allowGPTImage1"]=false;$scope.connection.params["allowDallE3"]=false;$scope.connection.params["allowEmbedding3Small"]=true;$scope.connection.params["allowEmbedding3Large"]=false;$scope.connection.params["allowEmbeddingAda2"]=false;$scope.connection.params["allowGPT35TurboInstruct"]=false;$scope.connection.params["allowGPT3Davinci"]=false;$scope.connection.params["allowGPT3Babbage"]=false;$scope.connection.params.maxParallelism=8;$scope.connection.params.maxTokensAPIMode="AUTO"}$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testOpenAi($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})};$scope.modelAPIModes=OpenAIAPIModes;$scope.modelTypes=OpenAiModelTypes;$scope.maxTokensAPIModes=OpenAiMaxTokensAPIModes;$scope.imageHandlingModes=OpenAIImageHandlingModes});app.controller("BaseAzureAiConnectionController",function($scope,$controller,TopNav,DataikuAPI,OpenAIAPIModes){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});$scope.modelAPIModes=OpenAIAPIModes;if($scope.creation){$scope.connection.params.allowFinetuning=false;$scope.connection.params["availableDeployments"]=[];$scope.connection.params.maxParallelism=8}DataikuAPI.admin.connections.list().success(function(data){$scope.azureMLConnections=Object.values(data).filter(c=>c.type==="AzureML").map(c=>c.name)});$scope.testConnection=function(){$scope.testing=true;$scope.testConnectionFunc($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})};$scope.usePromptAndCompletionCosts=function(deployment){return["COMPLETION_CHAT","COMPLETION_CHAT_MULTIMODAL","COMPLETION_CHAT_NO_SYSTEM_PROMPT","COMPLETION_SIMPLE"].includes(deployment.deploymentType)};$scope.useEmbeddingCosts=function(deployment){return"TEXT_EMBEDDING_EXTRACTION"===deployment.deploymentType}});app.controller("AzureOpenAiConnectionController",function($scope,$controller,DataikuAPI,OpenAiModelTypes,AzureOpenAiMaxTokensAPIModes,OpenAIImageHandlingModes){$controller("BaseAzureAiConnectionController",{$scope:$scope});$scope.deploymentTypes=OpenAiModelTypes;$scope.maxTokensAPIModes=AzureOpenAiMaxTokensAPIModes;$scope.imageHandlingModes=OpenAIImageHandlingModes;$scope.testConnectionFunc=function(connection){return DataikuAPI.admin.connections.testAzureOpenAi(connection)};$scope.azureResourceURLFormat="https://RESOURCE_NAME.openai.azure.com/openai";const chatModels=[{rawValue:"",displayName:"Custom pricing"},{rawValue:"gpt-5.2",displayName:"GPT 5.2",promptCost:.00175,completionCost:.014},{rawValue:"gpt-5.1",displayName:"GPT 5.1",promptCost:.00125,completionCost:.01},{rawValue:"gpt-5",displayName:"GPT 5",promptCost:.00125,completionCost:.01},{rawValue:"gpt-5-mini",displayName:"GPT 5 mini",promptCost:25e-5,completionCost:.002},{rawValue:"gpt-5-nano",displayName:"GPT 5 nano",promptCost:5e-5,completionCost:4e-4},{rawValue:"gpt-5-chat",displayName:"GPT 5 Chat",promptCost:.00125,completionCost:.01},{rawValue:"o4-mini",displayName:"o4-mini",promptCost:.0011,completionCost:.0044},{rawValue:"o3",displayName:"o3",promptCost:.01,completionCost:.04},{rawValue:"o3-mini",displayName:"o3-mini",promptCost:.0011,completionCost:.0044},{rawValue:"o1",displayName:"o1",promptCost:.015,completionCost:.06},{rawValue:"gpt-4.1",displayName:"GPT 4.1",promptCost:.002,completionCost:.008},{rawValue:"gpt-4.1-mini",displayName:"GPT 4.1-mini",promptCost:4e-4,completionCost:.0016},{rawValue:"gpt-4.1-nano",displayName:"GPT 4.1-nano",promptCost:1e-4,completionCost:4e-4},{rawValue:"gpt-4o",displayName:"GPT 4o",promptCost:.0025,completionCost:.01},{rawValue:"gpt-4o-mini",displayName:"GPT 4o-mini",promptCost:15e-5,completionCost:6e-4},{rawValue:"gpt-4",displayName:"GPT 4",promptCost:.03,completionCost:.06},{rawValue:"gpt-4-32k",displayName:"GPT 4 (large context)",promptCost:.06,completionCost:.12},{rawValue:"gpt-3.5-turbo",displayName:"GPT 3.5 Chat Turbo",promptCost:.0015,completionCost:.002},{rawValue:"gpt-3.5-turbo-16k",displayName:"GPT 3.5 Turbo - large context",promptCost:.003,completionCost:.004}];const simpleCompletionModels=[{rawValue:"text-davinci-003",displayName:"GPT 3 Text Davinci (text-davinci-003)",promptCost:.02,completionCost:.02},{rawValue:"babbage-002",displayName:"GPT 3 Text Curie (text-curie-001)",promptCost:.002,completionCost:.002},{rawValue:"babbage-002",displayName:"GPT 3 Text Babbage (text-babbage-001)",promptCost:.002,completionCost:5e-4},{rawValue:"babbage-002",displayName:"GPT 3 Text Ada (text-ada-001)",promptCost:.002,completionCost:4e-4},{rawValue:"",displayName:"Custom pricing"}];const embeddingModels=[{rawValue:"text-embedding-ada-002",displayName:"Embedding (Ada 002)",embeddingCost:1e-4},{rawValue:"text-embedding-3-small",displayName:"Embedding (v3 Small)",embeddingCost:2e-5},{rawValue:"text-embedding-3-large",displayName:"Embedding (v3 Large)",embeddingCost:13e-5},{rawValue:"",displayName:"Custom pricing"}];$scope.getOpenAIModels=function(deploymentType){switch(deploymentType){case"COMPLETION_CHAT":case"COMPLETION_CHAT_MULTIMODAL":case"COMPLETION_CHAT_NO_SYSTEM_PROMPT":return chatModels;case"COMPLETION_SIMPLE":return simpleCompletionModels;case"TEXT_EMBEDDING_EXTRACTION":return embeddingModels;case"IMAGE_GENERATION":return[]}return[{rawValue:"",displayName:"Custom pricing"}]};$scope.onDeploymentTypeChange=function(deployment){if(deployment.deploymentType!=="IMAGE_GENERATION"){deployment.imageHandlingMode=null}else if(!deployment.imageHandlingMode){deployment.imageHandlingMode="DALL_E_3"}const availableModelsForPricing=$scope.getOpenAIModels(deployment.deploymentType);const openAIModel=availableModelsForPricing.find(model=>model.rawValue===deployment.underlyingModelName);if(openAIModel){deployment.underlyingModelName=openAIModel.rawValue}else{deployment.underlyingModelName=""}};$scope.onModelPricingChange=function(deployment){const availableModelsForPricing=$scope.getOpenAIModels(deployment.deploymentType);const openAIModel=availableModelsForPricing.find(model=>model.rawValue===deployment.underlyingModelName)||{};deployment.promptCost=openAIModel.promptCost;deployment.completionCost=openAIModel.completionCost;deployment.embeddingCost=openAIModel.embeddingCost};$scope.connection.params.availableDeployments.forEach($scope.onDeploymentTypeChange)});app.controller("AzureAiFoundryConnectionController",function($scope,$controller,DataikuAPI){$controller("BaseAzureAiConnectionController",{$scope:$scope});$scope.deploymentTypes=[{rawValue:"COMPLETION_CHAT_MULTIMODAL",displayName:"Chat completion (multimodal)"},{rawValue:"COMPLETION_CHAT",displayName:"Chat completion"},{rawValue:"COMPLETION_CHAT_NO_SYSTEM_PROMPT",displayName:"Chat completion (no system message)"},{rawValue:"TEXT_EMBEDDING_EXTRACTION",displayName:"Embedding"},{rawValue:"IMAGE_GENERATION",displayName:"Image Generation"},{rawValue:"RERANKING",displayName:"Reranking"}];$scope.modelHandlingModes=[{rawValue:"DEFAULT",displayName:"Default"},{rawValue:"CLAUDE",displayName:"Anthropic Claude Models"},{rawValue:"OPENAI_GPT5_POST_51",displayName:"OpenAI GPT-5.1 and later"},{rawValue:"OPENAI_GPT5",displayName:"OpenAI GPT-5"},{rawValue:"OPENAI_GPT4",displayName:"OpenAI GPT-4"},{rawValue:"OPENAI_O_CODEX",displayName:"OpenAI o*, codex"},{rawValue:"MISTRAL",displayName:"Mistral"}];$scope.imageHandlingModes=[{rawValue:"NONE",displayName:"Disabled"},{rawValue:"DALL_E_3",displayName:"Dall-E 3"},{rawValue:"GPT_IMAGE_1",displayName:"GPT Image"}];$scope.rerankingHandlingModes=[{rawValue:"COHERE",displayName:"Cohere reranking"}];$scope.onDeploymentTypeChange=function(deployment){if(deployment.deploymentType==="IMAGE_GENERATION"&&!deployment.imageHandlingMode){deployment.imageHandlingMode="NONE"}};$scope.testConnectionFunc=function(connection){return DataikuAPI.admin.connections.testAzureAiFoundry(connection)};$scope.supportsResponses=function(modelHandlingMode){return["OPENAI_O_CODEX","OPENAI_GPT4","OPENAI_GPT5","OPENAI_GPT5_POST_51"].includes(modelHandlingMode)};$scope.azureResourceURLFormat="https://RESOURCE_NAME.services.ai.azure.com"});app.controller("NvidiaNimConnectionController",function($scope,$controller,TopNav,DataikuAPI){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});if($scope.creation){$scope.connection.params.allowFinetuning=false;$scope.connection.params["availableDeployments"]=[];$scope.connection.params.maxParallelism=8}$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testNvidiaNim($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})};const openAiV1ChatCompletions={rawValue:"OPENAI_V1_CHAT_COMPLETIONS",displayName:"OpenAI Chat completions",apiPath:"v1/chat/completions"};const openAiV1Responses={rawValue:"OPENAI_V1_RESPONSES",displayName:"OpenAI Responses",apiPath:"v1/responses"};const openAiV1EmbeddingsApi={rawValue:"OPENAI_V1_EMBEDDINGS",displayName:"OpenAI Embeddings",apiPath:"v1/embeddings"};$scope.apiPathsById=Object.assign({},...[openAiV1ChatCompletions,openAiV1Responses,openAiV1EmbeddingsApi].map(type=>({[type.rawValue]:type.apiPath})));$scope.modelTypes=[{rawValue:"CHAT_COMPLETIONS",displayName:"Chat completions",supportedApis:[openAiV1ChatCompletions,openAiV1Responses]},{rawValue:"EMBEDDINGS",displayName:"Embeddings",supportedApis:[openAiV1EmbeddingsApi]}];$scope.apiByModelType=Object.assign({},...$scope.modelTypes.map(type=>({[type.rawValue]:type.supportedApis})));$scope.onModelTypeChange=function(deployment){let allowedApis=$scope.apiByModelType[deployment.modelType];if(allowedApis&&!allowedApis.some(api=>api.rawValue===deployment.api)){deployment.api=allowedApis[0].rawValue}};$scope.displayUrlWarning=function(deployment){if(deployment.url&&deployment.api&&deployment.api in $scope.apiPathsById){for(const[_,apiPath]of Object.entries($scope.apiPathsById)){if(deployment.url.endsWith(apiPath)){return true}}}return false};$scope.connection.params.availableDeployments.forEach($scope.onModelTypeChange)});app.controller("AzureLLMConnectionController",function($scope,$controller,TopNav,DataikuAPI,OpenAiModelTypes){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});$scope.uiState={azureMLDeplConnections:null};if($scope.creation){$scope.connection.params={defaultKey:null,maxParallelism:8,customModels:[{id:null,displayName:null,modelType:"COMPLETION_CHAT",targetURI:null,key:null,promptCost:null,completionCost:null,embeddingCost:null}]}}$scope.modelTypes=OpenAiModelTypes.filter(mt=>["COMPLETION_CHAT","COMPLETION_SIMPLE","COMPLETION_CHAT_MULTIMODAL","COMPLETION_CHAT_NO_SYSTEM_PROMPT","TEXT_EMBEDDING_EXTRACTION"].includes(mt.rawValue));$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testAzureMLGenericLLM($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})};$scope.usePromptAndCompletionCosts=function(model){return["COMPLETION_CHAT","COMPLETION_CHAT_MULTIMODAL","COMPLETION_SIMPLE"].includes(model.modelType)};$scope.useEmbeddingCosts=function(model){return["TEXT_EMBEDDING_EXTRACTION"].includes(model.modelType)}});app.controller("CohereConnectionController",function($scope,$controller,TopNav,DataikuAPI){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});if($scope.creation){$scope.connection.params["allowCohereCommand"]=false;$scope.connection.params["allowCohereCommandLight"]=false;$scope.connection.params["allowCohereCommandR"]=true;$scope.connection.params["allowCohereCommandRPlus"]=true;$scope.connection.params.maxParallelism=1}$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testCohere($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})}});app.controller("StabilityAIConnectionController",function($scope,$controller,TopNav,DataikuAPI){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});$scope.notTestable=true;if($scope.creation){$scope.connection.params.maxParallelism=1}$scope.testConnection=function(){}});app.controller("MistralAiConnectionController",function($scope,$controller,TopNav,DataikuAPI){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});if($scope.creation){$scope.connection.params["allowMistralSmall"]=true;$scope.connection.params["allowMistralMedium"]=true;$scope.connection.params["allowMistralLarge"]=true;$scope.connection.params["allowMistralEmbed"]=true;$scope.connection.params.maxParallelism=4}$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testMistralAi($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})}});app.constant("AnthropicModelTypes",[{rawValue:"COMPLETION_CHAT",displayName:"Chat completion"},{rawValue:"COMPLETION_CHAT_MULTIMODAL",displayName:"Chat completion (multimodal)"}]);app.controller("AnthropicConnectionController",function($scope,$controller,TopNav,DataikuAPI,AnthropicModelTypes){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});$scope.modelTypes=AnthropicModelTypes;if($scope.creation){$scope.connection.params["allowClaudeV4Opus"]=false;$scope.connection.params["allowClaudeV41Opus"]=false;$scope.connection.params["allowClaudeV45Opus"]=true;$scope.connection.params["allowClaudeV37Sonnet"]=false;$scope.connection.params["allowClaudeV4Sonnet"]=false;$scope.connection.params["allowClaudeV45Sonnet"]=true;$scope.connection.params["allowClaudeV3Haiku"]=false;$scope.connection.params["allowClaudeV35Haiku"]=false;$scope.connection.params["allowClaudeV45Haiku"]=true;$scope.connection.params.maxParallelism=2}$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testAnthropic($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})}});app.service("BedrockConnectionService",function(){this.BedrockModelTypes=[{rawValue:"TEXT_MODEL",displayName:"Chat completion"},{rawValue:"MULTIMODAL_MODEL",displayName:"Chat completion (multimodal)"},{rawValue:"TEXT_EMBEDDING_EXTRACTION",displayName:"Text embedding"},{rawValue:"IMAGE_GENERATION",displayName:"Image generation"},{rawValue:"TEXT_IMAGE_EMBEDDING_EXTRACTION",displayName:"Multimodal embedding"},{rawValue:"RERANKING",displayName:"Reranking"}];this.BedrockHandlingModes={TEXT_MODEL:[{rawValue:"GENERIC_CONVERSE",displayName:"Generic Converse API Model"},{rawValue:"AMAZON_NOVA",displayName:"Amazon Nova"},{rawValue:"AMAZON_TITAN",displayName:"Amazon Titan"},{rawValue:"ANTHROPIC_CLAUDE_CHAT",displayName:"Anthropic Claude Chat"},{rawValue:"ANTHROPIC_CLAUDE",displayName:"Anthropic Claude (legacy completion API)"},{rawValue:"AI21_J2",displayName:"AI21 Jurassic 2"},{rawValue:"COHERE_COMMAND_CHAT",displayName:"Cohere Command Chat"},{rawValue:"COHERE_COMMAND",displayName:"Cohere Command (completion API)"},{rawValue:"META_LLAMA_2_BEDROCK",displayName:"Meta Llama 2"},{rawValue:"META_LLAMA_3_BEDROCK",displayName:"Meta Llama 3"},{rawValue:"MISTRAL_AI_CHAT",displayName:"MistralAI Chat"},{rawValue:"MISTRAL_AI",displayName:"MistralAI (text completion API)"}],MULTIMODAL_MODEL:[{rawValue:"GENERIC_CONVERSE",displayName:"Generic Converse API Model"},{rawValue:"AMAZON_NOVA",displayName:"Amazon Nova"},{rawValue:"ANTHROPIC_CLAUDE_CHAT",displayName:"Anthropic Claude Chat"}],TEXT_EMBEDDING_EXTRACTION:[{rawValue:"AMAZON_TITAN_TEXT_EMBEDDING",displayName:"Text embedding Amazon Titan"},{rawValue:"COHERE_EMBED",displayName:"Text embedding Cohere"}],TEXT_IMAGE_EMBEDDING_EXTRACTION:[{rawValue:"AMAZON_TITAN_TEXT_IMAGE_EMBEDDING",displayName:"Multimodal embedding Amazon Titan"}],IMAGE_GENERATION:[{rawValue:"AMAZON_TITAN",displayName:"Amazon Titan Image Generator G1"},{rawValue:"STABILITYAI_STABLE_DIFFUSION_10",displayName:"Stability AI SDXL 1.0"},{rawValue:"STABILITYAI_STABLE_IMAGE_CORE",displayName:"Stability AI Stable Image Core"},{rawValue:"STABILITYAI_STABLE_DIFFUSION_3",displayName:"Stability AI SD3"},{rawValue:"STABILITYAI_STABLE_IMAGE_ULTRA",displayName:"Stability AI Stable Image Ultra"}],RERANKING:[{rawValue:"COHERE_RERANK",displayName:"Reranking Cohere"}]}});app.controller("BedrockConnectionController",function($scope,$controller,TopNav,DataikuAPI,BedrockConnectionService){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});if($scope.creation){$scope.connection.params.allowFinetuning=false;$scope.connection.params.allowAWSNovaPro=true;$scope.connection.params.allowAWSNovaLite=false;$scope.connection.params.allowAWSNovaMicro=false;$scope.connection.params.allowAWSTitanTextPremierV1=false;$scope.connection.params.allowAWSTitanTextLiteV1=false;$scope.connection.params.allowAWSTitanTextExpressV1=false;$scope.connection.params.allowAWSTitanLarge=false;$scope.connection.params.allowAnthropicClaude45Sonnet=true;$scope.connection.params.allowAnthropicClaude45Haiku=true;$scope.connection.params.allowAnthropicClaude45Opus=true;$scope.connection.params.allowAnthropicClaude41Opus=false;$scope.connection.params.allowAnthropicClaude4Sonnet=false;$scope.connection.params.allowAnthropicClaude4Opus=false;$scope.connection.params.allowAnthropicClaude37Sonnet=false;$scope.connection.params.allowAnthropicClaude35SonnetV2=false;$scope.connection.params.allowAnthropicClaude35Sonnet=false;$scope.connection.params.allowAnthropicClaude3Sonnet=false;$scope.connection.params.allowAnthropicClaude35Haiku=false;$scope.connection.params.allowAnthropicClaude3Haiku=false;$scope.connection.params.allowAnthropicClaude3Opus=false;$scope.connection.params.allowAI21Jurassic2Ultra=false;$scope.connection.params.allowAI21Jurassic2Mid=false;$scope.connection.params.allowCohereCommandRPlus=true;$scope.connection.params.allowCohereCommandR=false;$scope.connection.params.allowMetaLlama33_70BInstruct=true;$scope.connection.params.allowMetaLlama31_8BInstruct=false;$scope.connection.params.allowMetaLlama31_70BInstruct=true;$scope.connection.params.allowMetaLlama31_405BInstruct=false;$scope.connection.params.allowMetaLlama38BInstruct=false;$scope.connection.params.allowMetaLlama370BInstruct=false;$scope.connection.params.allowMistral7BInstruct=false;$scope.connection.params.allowMixtral8X7BInstruct=false;$scope.connection.params.allowMistralSmall=false;$scope.connection.params.allowMistralLarge=false;$scope.connection.params.allowMistralLarge2=true;$scope.connection.params.allowAWSTitanEmbedTextV2=true;$scope.connection.params.allowAWSTitanEmbedText=false;$scope.connection.params.allowAWSTitanMultimodalEmbedV1=false;$scope.connection.params.allowCohereEmbedEnglish=false;$scope.connection.params.allowCohereEmbedMultilingual=false;$scope.connection.params.allowCohereRerank3_5=true;$scope.connection.params.allowAWSTitanImageGeneratorV1=false;$scope.connection.params.allowDeepSeekR1=false;$scope.connection.params.inferenceProfile=null;$scope.connection.params.maxParallelism=8;$scope.connection.params.useBedrockGuardrail=false;$scope.connection.params.guardrailIdentifier=null;$scope.connection.params.guardrailVersion=null}$scope.s3Connections=[];DataikuAPI.admin.connections.list().success(function(data){$scope.s3Connections=Object.values(data).filter(c=>c.type==="EC2").map(c=>c.name)});$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testBedrock($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})};$scope.modelTypes=BedrockConnectionService.BedrockModelTypes;$scope.handlingModes=BedrockConnectionService.BedrockHandlingModes;$scope.TEXT_MODEL="TEXT_MODEL";$scope.MULTIMODAL_MODEL="MULTIMODAL_MODEL";$scope.customModelTypeChanged=function(customModel){if(!customModel.modelType)return;customModel.handlingMode=undefined};$scope.customModelHandlingChanged=function(customModel){if(!customModel.handlingMode)return;if(["GENERIC_CONVERSE","AMAZON_NOVA"].includes(customModel.handlingMode)){customModel.useConverseAPI=true}}});app.controller("MosaicMLConnectionController",function($scope,$controller,TopNav,DataikuAPI){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});if($scope.creation){$scope.connection.params.allowMPT7BInstruct=true;$scope.connection.params.allowMPT30BInstruct=true;$scope.connection.params.allowLLAMA270BChat=true;$scope.connection.params.maxParallelism=1}$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testMosaicML($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})}});app.controller("SageMakerGenericLLMConnectionController",function($scope,$controller,TopNav,DataikuAPI){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});$scope.modelTypes=[{rawValue:"TEXT_COMPLETION",displayName:"Text completion"},{rawValue:"SUMMARIZATION",displayName:"Summarization"},{rawValue:"TEXT_EMBEDDING",displayName:"Text embedding"}];const modelHandlingModesCompletionSummarization=[["AI21_J2","AI21 Jurassic 2"],["AI21_SUMMARIZE","AI21 Summarize"],["COHERE_COMMAND","Cohere Command"],["HUGGING_FACE","Hugging Face"],["META_LLAMA_2_SAGEMAKER","Meta Llama 2"],["FULLY_CUSTOM","Fully Custom Handling"]];const modelHandlingModesTextEmbeddings=[["COHERE_EMBED","Cohere Embed"]];$scope.modelHandlingModes={TEXT_COMPLETION:modelHandlingModesCompletionSummarization,SUMMARIZATION:modelHandlingModesCompletionSummarization,TEXT_EMBEDDING:modelHandlingModesTextEmbeddings};$scope.useFullyCustomHandling=function(){if(!$scope.connection||!$scope.connection.params||!$scope.connection.params.sageMakerModel)return false;return $scope.connection.params.sageMakerModel.handling==="FULLY_CUSTOM"};if($scope.creation){$scope.connection.params.maxParallelism=8;$scope.connection.params.sageMakerModel={friendlyNameShort:"Custom SageMaker LLM Endpoint",modelType:"TEXT_COMPLETION",customHeaders:[],handling:null};$scope.connection.params.customQuery=`{
    "prompt": __PROMPT__,
    "parameters": {
        "top_k": __TOPK__,
        "top_p": __TOPP__,
        "temperature": __TEMPERATURE__,
        "max_tokens": __MAX_TOKENS__,
        "frequency_penalty": __FREQUENCY_PENALTY__,
        "presence_penalty": __PRESENCE_PENALTY__,
        "logit_bias": __LOGIT_BIAS__
    }
}`;$scope.connection.params.responseJsonPath="$.response"}$scope.$watch("connection.params.sageMakerModel.modelType",function(nv,ov){if(ov&&nv!==ov){$scope.connection.params.sageMakerModel.handling=null}});$scope.sageMakerConnections=[];DataikuAPI.admin.connections.list().success(function(data){$scope.sageMakerConnections=Object.values(data).filter(c=>c.type==="SageMaker").map(c=>c.name);if($scope.sageMakerConnections.length==1){$scope.connection.params.sageMakerConnection=$scope.sageMakerConnections[0]}});$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testSageMakerGenericLLM($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})}});app.constant("VertexModelTypes",[{rawValue:"GEMINI_CHAT",displayName:"Chat Completion"},{rawValue:"TEXT_EMBEDDING_EXTRACTION",displayName:"Embedding"},{rawValue:"TEXT_IMAGE_EMBEDDING_EXTRACTION",displayName:"Embedding multimodal"},{rawValue:"IMAGE_GENERATION",displayName:"Image Generation"}]);app.controller("VertexAILLMConnectionController",function($scope,$controller,TopNav,DataikuAPI,VertexModelTypes){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});if($scope.creation){$scope.connection.params.allowGeminiFlash25=true;$scope.connection.params.allowGeminiPro25=true;$scope.connection.params.allowGeminiFlashLite25=true;$scope.connection.params.allowGeminiFlash20=false;$scope.connection.params.allowGeminiFlashLite20=false;$scope.connection.params.allowGeminiFlash20Exp=false;$scope.connection.params.allowGeminiTextEmb=true;$scope.connection.params.allowTextEmb005=true;$scope.connection.params.allowTextEmb=false;$scope.connection.params.allowTextMultilangEmb=true;$scope.connection.params.allowMultimodalEmb=true;$scope.connection.params.allowImagen4Ultra=false;$scope.connection.params.allowImagen4=false;$scope.connection.params.allowImagen4Fast=false;$scope.connection.params.allowImagen3=false;$scope.connection.params.allowImagen3Fast=false;$scope.connection.params.authType="KEYPAIR";$scope.connection.params.dkuProperties=[];$scope.connection.params.maxParallelism=8}$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testVertexAILLM($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})};$scope.$watch("connection.params",function(nv,ov){if(nv.authType=="OAUTH"){$scope.connection.credentialsMode="PER_USER"}else{$scope.connection.credentialsMode="GLOBAL"}},true);$scope.modelTypes=VertexModelTypes});app.constant("DatabricksLLMModelTypes",[{rawValue:"CHAT",displayName:"Chat Completion"},{rawValue:"TEXT_EMBEDDING",displayName:"Embedding"}]);app.controller("DatabricksLlmConnectionController",function($scope,$controller,TopNav,DataikuAPI,DatabricksLLMModelTypes){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});if($scope.creation){$scope.connection.params.allowGPT51=true;$scope.connection.params.allowGPT5=false;$scope.connection.params.allowGPT5Mini=false;$scope.connection.params.allowGPT5Nano=false;$scope.connection.params.allowGeminiPro25=true;$scope.connection.params.allowGeminiFlash25=false;$scope.connection.params.allowGemma3_12B=false;$scope.connection.params.allowClaude4_5_Sonnet=true;$scope.connection.params.allowClaude4_Sonnet=false;$scope.connection.params.allowClaude4_1_Opus=true;$scope.connection.params.allowClaude3_7_Sonnet=false;$scope.connection.params.allowLlama4_Maverick=true;$scope.connection.params.allowLlama3_3_70BChat=false;$scope.connection.params.allowLlama3_1_405BChat=false;$scope.connection.params.allowBGELargeEn=true;$scope.connection.params.maxParallelism=1}$scope.databricksModelDeplConnections=[];DataikuAPI.admin.connections.list().success(function(data){$scope.databricksModelDeplConnections=Object.values(data).filter(c=>c.type==="DatabricksModelDeployment").map(c=>c.name)}).error(setErrorInScope.bind($scope));$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testDatabricksLLM($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})};$scope.modelTypes=DatabricksLLMModelTypes});app.constant("SnowflakeCortexLLMModelTypes",[{rawValue:"CHAT_COMPLETION",displayName:"Chat Completion"},{rawValue:"CHAT_COMPLETION_MULTIMODAL",displayName:"Chat Completion (multimodal)"},{rawValue:"TEXT_EMBEDDING",displayName:"Embedding"}]);app.controller("SnowflakeCortexConnectionController",function($scope,$controller,TopNav,DataikuAPI,SnowflakeCortexLLMModelTypes){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});$scope.uiState=$scope.uiState||{};if($scope.creation){$scope.connection.params.allowSnowflakeArctic=false;$scope.connection.params.allowClaude45Sonnet=true;$scope.connection.params.allowClaude45Haiku=true;$scope.connection.params.allowClaude4Sonnet=true;$scope.connection.params.allowClaude35Sonnet=false;$scope.connection.params.allowDeepSeekR1=false;$scope.connection.params.allowLlama4_Maverick=true;$scope.connection.params.allowLlama33_70BChat=true;$scope.connection.params.allowLlama31_70BChat=false;$scope.connection.params.allowMistral_Large2=true;$scope.connection.params.allowMistral_Large=false;$scope.connection.params.allowMixtral8x7B=false;$scope.connection.params.allowMistral_7B=false;$scope.connection.params.allowOpenAIGPT5Chat=true;$scope.connection.params.allowOpenAIGPT41=true;$scope.connection.params.allowSnowflakeArcticEmbedM=true;$scope.connection.params.allowE5BaseV2=true;$scope.connection.params.allowNVEmbedQA4=true;$scope.connection.params.maxParallelism=8}function computeSelectedConnection(){if($scope.connection.params.snowflakeConnection){$scope.uiState.selectedSnowflakeConnection=$scope.snowflakeConnections.find(sc=>sc.name==$scope.connection.params.snowflakeConnection)}else{$scope.uiState.selectedSnowflakeConnection=null}}$scope.snowflakeConnections=[];DataikuAPI.admin.connections.list().success(function(data){$scope.snowflakeConnections=Object.values(data).filter(c=>c.type==="Snowflake");$scope.snowflakeConnectionNames=$scope.snowflakeConnections.map(c=>c.name);computeSelectedConnection()}).error(setErrorInScope.bind($scope));$scope.$watch("connection.params.snowflakeConnection",()=>{computeSelectedConnection()});$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testSnowflakeCortex($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})};$scope.modelTypes=SnowflakeCortexLLMModelTypes});app.service("HuggingFaceLocalConnectionService",function(FeatureFlagsService){const GUARDED_MODEL_PRESETS=["LLAMA_2_7B_CHAT","LLAMA_2_13B_CHAT","LLAMA_3_8B_INSTRUCT","LLAMA_GUARD2","LLAMA_GUARD3_1B","LLAMA_GUARD3_8B","PROMPT_GUARD","MISTRAL_7B_INSTRUCT","MISTRAL_7B_INSTRUCT_V2","MISTRAL_7B_INSTRUCT_V3","MISTRAL_NEMO_12B_INSTRUCT","MIXTRAL_8X7B_INSTRUCT","LLAMA_3_1_8B_INSTRUCT","LLAMA_3_1_70B_INSTRUCT","GEMMA_3_1B_INSTRUCT","GEMMA_3_4B_INSTRUCT","GEMMA_3_12B_INSTRUCT","GEMMA_3_27B_INSTRUCT","GEMMA_3N_E4B_INSTRUCT","LLAMA_3_2_3B_INSTRUCT","LLAMA_3_2_11B_VISION_INSTRUCT","LLAMA_3_3_70B_INSTRUCT","LLAMA_4_SCOUT_17B_16E-INSTRUCT","LLAMA_4_MAVERICK_17B_128E_INSTRUCT_FP8"];this.isGuardedModel=presetId=>{return GUARDED_MODEL_PRESETS.includes(presetId)};const HF_PURPOSES={GENERIC_COMPLETION:{categoryName:"Text Generation",addFromPresetsModalTitle:"Add text generation model from library",handlingModes:[{rawValue:"TEXT_GENERATION_LLAMA_2",displayName:"Llama 2/3 model"},{rawValue:"TEXT_GENERATION_DEEPSEEK",displayName:"Deepseek model"},{rawValue:"TEXT_GENERATION_DOLLY",displayName:"Dolly model"},{rawValue:"TEXT_GENERATION_GPT",displayName:"GPT model"},{rawValue:"TEXT_GENERATION_MISTRAL",displayName:"Mistral model"},{rawValue:"TEXT_GENERATION_QWEN",displayName:"Qwen model"},{rawValue:"TEXT_GENERATION_ZEPHYR",displayName:"Zephyr model"},{rawValue:"TEXT_GENERATION_FALCON",displayName:"Falcon model"},{rawValue:"TEXT_GENERATION_MPT",displayName:"MPT model"},{rawValue:"TEXT_GENERATION_OPENBMB",displayName:"OpenBMB model"},{rawValue:"TEXT_GENERATION_GEMMA",displayName:"Gemma model"},{rawValue:"TEXT_GENERATION_PHI_3",displayName:"Phi-3 model"},{rawValue:"TEXT_GENERATION_GENERIC",displayName:"Generic models"}],huggingFacePurposes:["GENERIC_COMPLETION"]},TEXT_EMBEDDING_EXTRACTION:{categoryName:"Text Embedding",addFromPresetsModalTitle:"Add text embedding model from library",handlingModes:[{rawValue:"TEXT_EMBEDDING",displayName:"Text embedding"}],huggingFacePurposes:["TEXT_EMBEDDING_EXTRACTION"]},RERANKING:{categoryName:"Text reranking models",addFromPresetsModalTitle:"Add text reranking model from library",handlingModes:[{rawValue:"DOCUMENT_RERANKING",displayName:"Text reranking model"}],huggingFacePurposes:["RERANKING"]},IMAGE_GENERATION:{categoryName:"Image Generation",addFromPresetsModalTitle:"Add image generation model from library",handlingModes:[{rawValue:"IMAGE_GENERATION_DIFFUSION",displayName:"Image generation model"}],huggingFacePurposes:["IMAGE_GENERATION"]},IMAGE_EMBEDDING_EXTRACTION:{categoryName:"Image Embedding",addFromPresetsModalTitle:"Add image embedding model from library",handlingModes:[{rawValue:"IMAGE_EMBEDDING",displayName:"Image embedding"}],huggingFacePurposes:["IMAGE_EMBEDDING_EXTRACTION"]},SAFETY_AND_MODERATION:{categoryName:"Safety & Moderation",addFromPresetsModalTitle:"Add safety and moderation model from library",handlingModes:[{rawValue:"TEXT_CLASSIFICATION_TOXICITY",displayName:"Toxicity detection (Bert models)"},{rawValue:"TEXT_GENERATION_LLAMA_GUARD",displayName:"Toxicity detection (Llama Guard models)"},{rawValue:"TEXT_CLASSIFICATION_PROMPT_INJECTION",displayName:"Prompt injection"}],huggingFacePurposes:["TOXICITY_DETECTION","PROMPT_INJECTION_DETECTION"]},CLASSIFICATION:{categoryName:"Text Classification",addFromPresetsModalTitle:"Add text classification model from library",handlingModes:[{rawValue:"TEXT_CLASSIFICATION_OTHER",displayName:"Text classification (other use cases)"},{rawValue:"ZSC_GENERIC",displayName:"Zero-shot classification"},{rawValue:"TEXT_CLASSIFICATION_EMOTIONS",displayName:"Emotion analysis"},{rawValue:"TEXT_CLASSIFICATION_SENTIMENT",displayName:"Sentiment analysis"}],huggingFacePurposes:["CLASSIFICATION_WITH_USER_PROVIDED_CLASSES","SENTIMENT_ANALYSIS","EMOTION_ANALYSIS","CLASSIFICATION_WITH_OTHER_MODEL_PROVIDED_CLASSES"]},SUMMARIZATION:{categoryName:"Text Summarization",addFromPresetsModalTitle:"Add text summarization model from library",handlingModes:[{rawValue:"SUMMARIZATION_GENERIC",displayName:"Summarization (generic)"},{rawValue:"SUMMARIZATION_ROBERTA",displayName:"Summarization (Roberta models)"}],huggingFacePurposes:["SUMMARIZATION"]}};this.getPossibleHandlingModes=purpose=>{return HF_PURPOSES[purpose]["handlingModes"]};this.getHuggingFacePurposes=purpose=>{return HF_PURPOSES[purpose]["huggingFacePurposes"]};this.getAddModelModalTitle=purpose=>{return HF_PURPOSES[purpose]["addFromPresetsModalTitle"]};this.getPurposes=()=>{return HF_PURPOSES};this.getNoPresetCustomModel=function(purpose){const handlingMode=this.getPossibleHandlingModes(purpose)[0].rawValue;return{displayName:"",huggingFaceId:"",id:"",handlingMode:handlingMode,quantizationMode:"NONE",enabled:true,containerSelection:{containerMode:"INHERIT"}}}});app.controller("HuggingFaceLocalConnectionController",function($scope,$state,$controller,$interval,TopNav,DataikuAPI,HuggingFaceLocalConnectionService){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});$scope.notTestable=true;if($scope.creation){$scope.connection.params.useDSSModelCache=true;$scope.connection.params.enableReserveCapacity=true;$scope.connection.params.allowFinetuning=false;$scope.connection.params.models=[];$scope.connection.params.containerSelection={containerMode:"NONE"}}DataikuAPI.admin.getGeneralSettings().then(function({data}){$scope.globalMaxKernels=data.generativeAISettings.huggingFaceLocalSettings.maxConcurrentKernels}).catch(setErrorInScope.bind($scope));$scope.inheritClusterLabel="Inherit instance default";DataikuAPI.admin.clusters.listAccessible("KUBERNETES").success(function(data){$scope.k8sClusters=[{id:undefined,name:$scope.inheritClusterLabel}].concat(data)}).error(setErrorInScope.bind($scope));$scope.useInternalCodeEnvLabel="Use internal code env";DataikuAPI.codeenvs.listNames("PYTHON").then(function({data}){$scope.codeEnvItemsListWithDefault=[{label:$scope.useInternalCodeEnvLabel,value:undefined}].concat(data.map(codeEnv=>({label:codeEnv,value:codeEnv})))}).catch(setErrorInScope.bind($scope));let hfLocalInternalCodeEnvChecked=false;DataikuAPI.codeenvs.checkDSSInternalCodeEnv("HUGGINGFACE_LOCAL_CODE_ENV").then(function({data}){if(Object.keys(data).length>0){$scope.hfLocalInternalCodeEnv=data.value;if($scope.creation&&$scope.hfLocalCodeEnv!=null){$scope.connection.params.codeEnvName=$scope.hfLocalInternalCodeEnv.envName}}hfLocalInternalCodeEnvChecked=true}).catch(setErrorInScope.bind($scope));$scope.hfLocalInternalCodeEnvExists=function(){return hfLocalInternalCodeEnvChecked&&$scope.hfLocalInternalCodeEnv!=null};$scope.hfLocalCodeEnvIsInternal=function(){return $scope.connection.params.codeEnvName==null||$scope.hfLocalInternalCodeEnvExists()&&$scope.connection.params.codeEnvName==$scope.hfLocalInternalCodeEnv.envName};$scope.showHFLocalCodeEnvWarning=function(){return hfLocalInternalCodeEnvChecked&&(!$scope.hfLocalInternalCodeEnvExists()||!$scope.hfLocalCodeEnvIsInternal())};$scope.internalCodeEnvsHRef=function(){if($scope.appConfig.isAutomation){return $state.href("admin.codeenvs-automation.internal")}else{return $state.href("admin.codeenvs-design.internal")}};$scope.fixupNullishForDirtynessCheck=function(param){if($scope.connection.params[param]==null){$scope.connection.params[param]=undefined}};$scope.presetModels=null;$scope.facets=null;$scope.presets=null;$scope.facetFamilyDescriptions=[];DataikuAPI.admin.connections.listHuggingFacePresets().success(function(config){$scope.presets=config.presets;$scope.presetModels=config.presets.map(p=>p.model);$scope.facets=config.facets}).catch(setErrorInScope.bind($scope));window._dkuHFOverrideHFPresets=function(config){DataikuAPI.admin.connections.listHuggingFacePresets(config).success(function(config){$scope.presets=config.presets;$scope.presetModels=config.presets.map(p=>p.model);$scope.facets=config.facets}).catch(setErrorInScope.bind($scope))};$scope.$on("$destroy",function(){delete window._dkuHFOverrideHFPresets});$scope.shouldShowExplicitUnsavedWarning=true;$scope.hasAtLeastOneReservedCapacity=function(){return $scope.connection.params.models.some(model=>$scope.isValidHFModel(model)&&model.enabled&&model.minKernelCount>0)};$scope.isValidHFModel=function(model){return model.id&&model.huggingFaceId&&model.handlingMode};$scope.updateStatus=function(){if(!$scope.creation&&$scope.connection.name){DataikuAPI.admin.connections.getHfKernelStatus($scope.connection.name).success(function(status){$scope.kernelsStatus=status}).catch(setErrorInScope.bind($scope))}};$scope.kernelsStatus=null;$scope.updateStatus();const cancelStatusUpdate=$interval(()=>{$scope.updateStatus()},5e3);$scope.$on("$destroy",()=>{if(cancelStatusUpdate){$interval.cancel(cancelStatusUpdate)}});checkChangesBeforeLeaving($scope,$scope.connectionDirty)});app.controller("HuggingFaceAddModelFromPresetController",function($scope,$filter,Debounce,TaggingService){$scope.filteredPresets=$scope.presets;$scope.selectedPreset=null;$scope.filterFacets=angular.copy($scope.facets);$scope.uiState=$scope.uiState||{};$scope.uiState.facetFilter="";$scope.displaySpecs=[];$scope.visibleFamilies=computeVisibleFacets("family",[$scope.allFamilyFacetValue]);$scope.facetFamilyDescriptions=$scope.visibleFamilies.map(facet=>facet.description);$scope.filterPresets=()=>{$scope.filteredPresets=$scope.presets.filter(isInSelectedFamily).filter(hasSelectedTags).filter(hasSearchString);function isInSelectedFamily(preset){const selectedFamily=$scope.selectedFacets["family"];const presetFamilies=preset.facets["family"];if(selectedFamily===$scope.allFamilyFacetValue.id){return true}if(!selectedFamily){return true}if(!presetFamilies){return false}return presetFamilies.includes(selectedFamily)}function hasSelectedTags(preset){const selectedTags=$scope.selectedFacets["tags"];const presetTags=preset.facets["tags"];if(!selectedTags||selectedTags.length===0){return true}if(!presetTags){return false}return selectedTags.every(tagValue=>presetTags.includes(tagValue))}function hasSearchString(preset){if(!preset.model){return false}const displayName=(preset.model.displayName||"").toLowerCase();const searchString=$scope.uiState.facetFilter.toLowerCase();return displayName.includes(searchString)}};$scope.selectPreset=preset=>{$scope.selectedPreset=preset;$scope.displaySpecs=computeSpecs(preset)};$scope.addModel=preset=>{$scope.appendModel(preset.model,$scope.purpose);$scope.resolveModal()};$scope.resetFilters=()=>{$scope.uiState.facetFilter="";$scope.selectedFacets={family:$scope.allFamilyFacetValue.id,tags:[]};$scope.filterPresets()};$scope.isFiltering=()=>{return $scope.selectedFacets.family!==$scope.allFamilyFacetValue.id||$scope.selectedFacets.tags.length>0||$scope.uiState.facetFilter.length>0};$scope.selectTag=function(tagId){if($scope.selectedFacets["tags"].includes(tagId)){return}$scope.selectedFacets["tags"].push(tagId);$scope.filterPresets()};$scope.unSelectTag=function(tagId){if(!$scope.selectedFacets["tags"].includes(tagId)){return}$scope.selectedFacets["tags"]=$scope.selectedFacets["tags"].filter(element=>element!==tagId);$scope.filterPresets()};$scope.tagColor=TaggingService.getTagColor;$scope.visibleTags=computeVisibleFacets("tags");$scope.$watch("uiState.facetFilter",Debounce().withDelay(100,200).wrap($scope.filterPresets));function computeVisibleFacets(facetName,customFacetValues=[]){const visibleFacetIds=new Set($scope.presets.flatMap(preset=>preset.facets[facetName]??[]));return[...customFacetValues,...$scope.facets[facetName].values.filter(facet=>visibleFacetIds.has(facet.id))]}function computeSpecs(preset){if(!preset||!preset.model.specs){return[]}const specs=preset.model.specs;return Object.keys(specDefinitions).filter(key=>specs[key]!=null).map(key=>{const def=specDefinitions[key];return{label:def.label,value:def.format(specs[key])}})}const specDefinitions={author:{label:"Author",format:val=>val},license:{label:"License",format:val=>val},releaseDate:{label:"Release date",format:val=>val},storageSize:{label:"Model storage size",format:val=>$filter("fileSizeOrNA")(val)},parameterCount:{label:"Number of parameters",format:val=>$filter("friendlyHugeNumber")(val)},contextWindow:{label:"Maximum context length",format:val=>$filter("friendlyHugeNumber")(val)+" tokens"}}});app.component("hfModelsTable",{templateUrl:"/templates/admin/connection-huggingface-local-models-table.html",bindings:{models:"<",kernelsStatus:"<",presetModels:"<",apiKey:"<",supportsLlmFineTuning:"<",connectionName:"<",presets:"<",facets:"<",updateStatus:"<"},controller:function($scope,HuggingFaceLocalConnectionService,CreateModalFromTemplate,Dialogs,$sce){const kernelsStatusWrapper={kernelsStatus:this.kernelsStatus};this.purposes=HuggingFaceLocalConnectionService.getPurposes();this.$onChanges=()=>{kernelsStatusWrapper.kernelsStatus=this.kernelsStatus};this.isHandlingModeSupportedForPurpose=(purpose,handlingMode)=>{const handlingModes=HuggingFaceLocalConnectionService.getPossibleHandlingModes(purpose);const supportedHandlingModes=handlingModes.map(mode=>mode.rawValue);return supportedHandlingModes.includes(handlingMode)};this.addCustomModel=function(purpose){const newModel=HuggingFaceLocalConnectionService.getNoPresetCustomModel(purpose);this.openEditModal(newModel,purpose,"Edit new model","Add")};this.appendModel=(model,purpose)=>{const clonedModel=_.cloneDeep(model);this.openEditModal(clonedModel,purpose,"Edit new model","Add")};this.addModelFromPresets=function(purpose){const newScope=$scope.$new();const usagePurposes=HuggingFaceLocalConnectionService.getHuggingFacePurposes(purpose);newScope.purpose=purpose;newScope.presets=this.presets.filter(preset=>usagePurposes.includes(preset.facets["mainUsagePurpose"][0]));newScope.facets=this.facets;newScope.appendModel=this.appendModel;newScope.tagsDescription={};const allTagNamesMap=new Map;for(const tag of this.facets.tags.values){newScope.tagsDescription[tag.id]=tag.description;allTagNamesMap.set(tag.id,tag.name)}function getTagNames(tagIds){const tagNamesMap=new Map;tagIds.forEach(tagId=>tagNamesMap.set(tagId,allTagNamesMap.get(tagId)));const tagNames=[];allTagNamesMap.forEach((tagName,tagId)=>tagNamesMap.has(tagId)?tagNames.push(tagName):null);tagNamesMap.forEach((tagName,tagId)=>tagName??tagNames.push(tagId));return tagNames}newScope.presets.forEach(preset=>preset.tagNames=getTagNames(preset.facets.tags??[]));newScope.allFamilyFacetValue={id:"allFamilies",name:"All families",description:"Select all the families available"};newScope.selectedFacets={family:newScope.allFamilyFacetValue.id,tags:[]};newScope.modalTitle=HuggingFaceLocalConnectionService.getAddModelModalTitle(purpose);CreateModalFromTemplate("/templates/admin/connection-huggingface-local-add-model.html",newScope,"HuggingFaceAddModelFromPresetController")};this.delete=idx=>{const dialogScope=$scope.$new();const dialogModels=this.models;Dialogs.confirmAlert(dialogScope,"Delete model","Are you sure you want to delete this model?").then(function(){dialogModels.splice(idx,1)},function(){})};this._getCustomModelWarningMessages=(customModel,checkDuplicatedModelId)=>{const warnings=[];if(checkDuplicatedModelId(customModel)){warnings.push("Duplicate model id.")}if(HuggingFaceLocalConnectionService.isGuardedModel(customModel.presetId)&&!this.apiKey&&customModel.enabled){warnings.push("This model is gated and cannot be used without an access token.")}if(warnings.length==0){return null}if(warnings.length==1){return warnings[0]}return warnings.map(w=>"• "+w).join("<br>")};this.getCustomModelWarningMessages=customModel=>{return this._getCustomModelWarningMessages(customModel,model=>{const sameIdModels=this.models.filter(m=>m.id==model.id);return sameIdModels.length>1})};this.getHumanStatus=model=>{if(this.kernelsStatus){const modelStatus=this.kernelsStatus["kernels"].filter(kernel=>kernel.modelId===model.id);if(modelStatus.some(kernel=>kernel.state==="READY"&&kernel.usedEngine==="transformers"&&model.handlingMode.startsWith("TEXT_GENERATION"))){return{color:"orange",text:"Running using transformers",tooltipText:"Transformers fallback is used instead of vLLM. Performances and capabilities are limited using transformers. For more detailed information, refer to the logs."}}if(modelStatus.some(kernel=>kernel.state==="READY")){return{color:"green",text:"Running"}}const deadKernels=modelStatus.filter(k=>k.state==="DEAD");let lastDeadKernel=null;if(deadKernels&&deadKernels.length>0){lastDeadKernel=deadKernels.reduce((prev,current)=>current.diedAtTime>=prev.diedAtTime?current:prev)}if(lastDeadKernel&&lastDeadKernel.deathReason&&lastDeadKernel.deathReason.includes("FAIL")){return{color:"red",text:"Error"}}if(modelStatus.some(kernel=>kernel.state==="STARTING")){return{color:"orange",text:"Starting"}}if(modelStatus.some(kernel=>["SENTENCED","DYING"].includes(kernel.state))){return{color:"orange",text:"Stopping"}}if(lastDeadKernel){return{text:`Stopped ${moment(lastDeadKernel.diedAtTime).fromNow()}`}}return{text:"—"}}};this.getEnrichedLLMId=model=>{return`huggingfacelocal:${this.connectionName}:${model.id}`};this.openStatusModal=model=>{const newScope=$scope.$new();newScope.model=model;newScope.connectionName=this.connectionName;newScope.kernelsStatusWrapper=kernelsStatusWrapper;newScope.updateStatus=this.updateStatus;CreateModalFromTemplate("/templates/admin/connection-huggingface-local-custom-status-modal.html",newScope,"HuggingFaceModelStatusController")};this.openEditModal=(model,purpose,titleText="Edit model",confirmText="Ok")=>{const newScope=$scope.$new();newScope.model=model;newScope.models=this.models;newScope.purpose=purpose;newScope.presetModels=this.presetModels;newScope.supportsLlmFineTuning=this.supportsLlmFineTuning;newScope.titleText=titleText;newScope.confirmText=confirmText;newScope._getCustomModelWarningMessages=this._getCustomModelWarningMessages;CreateModalFromTemplate("/templates/admin/connection-huggingface-local-edit-modal.html",newScope,"HuggingFaceModelEditController")}}});app.controller("HuggingFaceModelEditController",function($scope,HuggingFaceLocalConnectionService,Dialogs,HuggingFaceKernelPoolConstants,DataikuAPI){const NULL_PRESET_ID="NONE";$scope.HuggingFaceKernelPoolConstants=HuggingFaceKernelPoolConstants;$scope.quantizationModes=[{rawValue:"NONE",displayName:"None (recommended)"},{rawValue:"Q_8BIT",displayName:"8 bit"},{rawValue:"Q_4BIT",displayName:"4 bit"}];$scope.enforceEagerModes=[{rawValue:"AUTO",displayName:"Auto (recommended)"},{rawValue:true,displayName:"Enforce eager mode"},{rawValue:false,displayName:"Enable CUDA graph"}];$scope.trustRemoteCodeModes=[{rawValue:"AUTO",displayName:"Auto (recommended)"},{rawValue:true,displayName:"Yes"},{rawValue:false,displayName:"No"}];$scope.enableExpertParallelismModes=[{rawValue:"AUTO",displayName:"Auto (recommended)"},{rawValue:true,displayName:"Yes"},{rawValue:false,displayName:"No"}];$scope.supportedHandlingModes=HuggingFaceLocalConnectionService.getPossibleHandlingModes($scope.purpose);const supportedHandlingModesRawValues=$scope.supportedHandlingModes.map(mode=>mode.rawValue);const supportedPresetModels=_.cloneDeep(($scope.presetModels||[]).filter(model=>supportedHandlingModesRawValues.includes(model.handlingMode)));$scope.tempModel=_.cloneDeep($scope.model);function applyDefaultValuesForEmptyFields(){$scope.tempModel.enforceEager=$scope.tempModel.enforceEager??"AUTO";$scope.tempModel.trustRemoteCode=$scope.tempModel.trustRemoteCode??"AUTO";$scope.tempModel.enableExpertParallelism=$scope.tempModel.enableExpertParallelism??"AUTO";$scope.tempModel.presetId=$scope.tempModel.presetId??NULL_PRESET_ID}applyDefaultValuesForEmptyFields();const isDeprecatedPresetId=!supportedPresetModels.some(model=>model.presetId===$scope.tempModel.presetId);const nonePresetId=isDeprecatedPresetId?$scope.tempModel.presetId:NULL_PRESET_ID;$scope.presetIdOptions=[{presetId:nonePresetId,displayName:"None"},...supportedPresetModels];$scope.checkDuplicatedModelId=()=>{const sameIdModels=$scope.models.filter(m=>m.id==$scope.tempModel.id);if($scope.models.includes($scope.model)&&$scope.model.id===$scope.tempModel.id){return sameIdModels.length>1}return sameIdModels.length>0};$scope.getCustomModelWarningMessages=()=>{return $scope._getCustomModelWarningMessages($scope.tempModel,$scope.checkDuplicatedModelId)};$scope.applyPreset=function(){const presetModel=supportedPresetModels.find(o=>o.presetId===$scope.tempModel.presetId);const newModel=_.cloneDeep(presetModel??HuggingFaceLocalConnectionService.getNoPresetCustomModel($scope.purpose));$scope.presetIdOptions=[{presetId:NULL_PRESET_ID,displayName:"None"},...supportedPresetModels];const settingsToPreserve=["enabled","containerSelection","cudaVisibleDevices","minKernelCount","maxKernelCount","autoscalingTimeWindowSeconds","autoscalingTargetRequestsPerKernel"];settingsToPreserve.forEach(k=>newModel[k]=$scope.tempModel[k]);angular.copy(newModel,$scope.tempModel);applyDefaultValuesForEmptyFields()};$scope.hasInferenceSettings=function(){return["GENERIC_COMPLETION","TEXT_EMBEDDING_EXTRACTION","RERANKING"].includes($scope.purpose)||$scope.tempModel.handlingMode==="IMAGE_GENERATION_DIFFUSION"};$scope.resetModel=function(){const inferenceText=$scope.hasInferenceSettings()?" and inference":"";Dialogs.confirm($scope,"Reset model",`Are you sure you want to reset this model ? It will overwrite the model${inferenceText} settings.`).then(function(){$scope.applyPreset()},function(){})};$scope.fixupNullValuesForTextInput=function(attr){$scope.tempModel[attr]=$scope.tempModel[attr]??""};$scope.saveModel=function(){if(!$scope.models.includes($scope.model)){$scope.models.push($scope.model)}if($scope.tempModel.dtype==="")$scope.tempModel.dtype=undefined;if($scope.tempModel.enforceEager==="AUTO")$scope.tempModel.enforceEager=undefined;if($scope.tempModel.trustRemoteCode==="AUTO")$scope.tempModel.trustRemoteCode=undefined;if($scope.tempModel.enableExpertParallelism==="AUTO")$scope.tempModel.enableExpertParallelism=undefined;if($scope.tempModel.presetId===NULL_PRESET_ID)$scope.tempModel.presetId=undefined;Object.keys($scope.tempModel).forEach(k=>$scope.tempModel[k]=$scope.tempModel[k]??undefined);angular.copy($scope.tempModel,$scope.model)};DataikuAPI.admin.getGeneralSettings().then(function({data}){$scope.globalKernelIdleTTLSeconds=data.generativeAISettings.huggingFaceLocalSettings.kernelIdleTTLSeconds}).catch(setErrorInScope.bind($scope))});app.controller("HuggingFaceModelStatusController",function($scope,DataikuAPI){$scope.getStateColor=kernel=>{switch(kernel.state){case"READY":return isTextGenerationModelUsingTransformers(kernel)?"orange":"green";case"STARTING":case"SENTENCED":case"DYING":return"orange";case"DEAD":{if(kernel.deathReason&&kernel.deathReason.includes("FAIL")){return"red"}else if(kernel.deathError){return"orange"}else{return"inherit"}}}};$scope.getStateText=kernel=>{let humanReadableDeathReason=null;let failedMessage=null;switch(kernel.deathReason){case"STRATEGY":{humanReadableDeathReason="because it isn't needed anymore";break}case"PER_KERNEL_MAX_LIMIT":{humanReadableDeathReason="to comply with the per-model max limit";break}case"GLOBAL_MAX_LIMIT":{humanReadableDeathReason="to comply with the global model instance limit";break}case"ROOM_FOR_RESERVED_CAPACITY":{humanReadableDeathReason="to make room for reserved capacity for another model instance";break}case"ROOM_FOR_REQUEST":{humanReadableDeathReason="to make room for a request that had no model instance running";break}case"OUTDATED":{humanReadableDeathReason="because model settings have changed";break}case"USER_REQUEST":{humanReadableDeathReason="because it was requested to stop by a user";break}case"DEBUG":{humanReadableDeathReason="for debugging reasons";break}case"FAIL_START":failedMessage="Model instance failed to start. Check the logs for more information.";break;case"FAIL_RUNNING":{failedMessage="Model instance failed while it was running. Check the logs for more information.";break}case"UNKNOWN":default:humanReadableDeathReason="for an unknown reason"}switch(kernel.state){case"STARTING":{return`Model instance is starting (${moment(kernel.startingAtTime).fromNow()})`}case"READY":{if(kernel.nbActiveRequests>0){return`Processing ${kernel.nbActiveRequests} requests (started ${moment(kernel.readyAtTime).fromNow()})${isTextGenerationModelUsingTransformers(kernel)?" (using transformers)":""}`}else{return`Ready to accept requests (started ${moment(kernel.readyAtTime).fromNow()})${isTextGenerationModelUsingTransformers(kernel)?" (using transformers)":""}`}}case"SENTENCED":{return(failedMessage??`Model instance is scheduled to shutdown ${humanReadableDeathReason}, after completing the ${kernel.nbActiveRequests} ongoing requests`)+` (${moment(kernel.sentencedAtTime).fromNow()})`}case"DYING":{return(failedMessage??`Model instance is shutting down ${humanReadableDeathReason}`)+` (${moment(kernel.sentencedAtTime).fromNow()})`}case"DEAD":{if(kernel.deathError){return(failedMessage??`Model instance should have been stopped ${humanReadableDeathReason}, but an issue occurred during shutdown`)+` (${moment(kernel.diedAtTime).fromNow()})`}else{return(failedMessage??`Model instance was stopped ${humanReadableDeathReason}`)+` (${moment(kernel.diedAtTime).fromNow()})`}};default:return kernel.state}};$scope.stoppedKernels=[];$scope.killKernel=kernel=>{if($scope.stopShouldBeDisabled(kernel))return;DataikuAPI.admin.connections.killHFKernel(kernel.id).then(()=>{$scope.updateStatus()});$scope.stoppedKernels.push(kernel.id)};$scope.stopShouldBeDisabled=kernel=>{return $scope.stoppedKernels.includes(kernel.id)||kernel.state!="STARTING"&&kernel.state!="READY"};$scope.logs={};this.fetchedStoppedKernelLogs=[];const updateLogs=()=>{if($scope.modelKernelsStatus){$scope.modelKernelsStatus.forEach(kernel=>{if(kernel.state!=="DEAD"||!this.fetchedStoppedKernelLogs.includes(kernel.id)){DataikuAPI.admin.connections.getHfKernelLogs(kernel.id).success(function(data){$scope.logs[kernel.id]=data}).catch(setErrorInScope.bind($scope));if(kernel.state==="DEAD"){this.fetchedStoppedKernelLogs.push(kernel.id)}}})}};$scope.$watch("kernelsStatusWrapper.kernelsStatus",status=>{$scope.modelKernelsStatus=status["kernels"].filter(kernel=>kernel.modelId===$scope.model.id);$scope.runningKernelsStatus=_.sortBy($scope.modelKernelsStatus.filter(k=>k.state!=="DEAD"),k=>k.startingAtTime).reverse();$scope.deadKernelsStatus=_.sortBy($scope.modelKernelsStatus.filter(k=>k.state==="DEAD"),k=>k.diedAtTime).reverse();$scope.graveyardTimeout=status["graveyardTimeoutInS"];updateLogs()});function isTextGenerationModelUsingTransformers(kernel){return kernel.usedEngine==="transformers"&&$scope.model.handlingMode.startsWith("TEXT_GENERATION")}});app.controller("HuggingFaceInferenceAPIConnectionController",function($scope,$controller,TopNav,DataikuAPI){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});if($scope.creation){$scope.connection.params.maxParallelism=2}$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testHuggingFace($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})}});app.controller("CustomLLMConnectionController",function($scope,$controller,$rootScope,TopNav,DataikuAPI,PluginConfigUtils){TopNav.setLocation(TopNav.DSS_HOME,"administration");$controller("_LLMConnectionController",{$scope:$scope});$scope._allCustomLLMPlugins=[...$scope.appConfig.customPythonLLMs,...$scope.appConfig.customJavaLLMs];const idToType={};$scope.appConfig.customPythonLLMs.forEach(llm=>{idToType[llm.ownerPluginId]="python"});$scope.appConfig.customJavaLLMs.forEach(llm=>{idToType[llm.ownerPluginId]="java"});function loadLLMPlugins(){const uniquePluginIdsFromVisibleLLMs=new Set($scope._allCustomLLMPlugins.filter(PluginConfigUtils.shouldComponentBeVisible($rootScope.appConfig.loadedPlugins,$scope.connection.params.pluginID,llm=>llm.ownerPluginId)).map(llm=>llm.ownerPluginId));$scope.customLLMPlugins=Array.from(uniquePluginIdsFromVisibleLLMs).map(pluginID=>$scope.appConfig.loadedPlugins.find(plugin=>plugin.id===pluginID)).filter(plugin=>plugin).map(plugin=>{plugin["type"]=idToType[plugin["id"]]??"unknown";return plugin}).sort((a,b)=>a.label.localeCompare(b.label))}loadLLMPlugins();$scope.selectedPlugin=$scope.customLLMPlugins.find(plugin=>plugin.id===$scope.connection.params.pluginID);const cachedLLMDefinitions={};$scope.$watch("selectedPlugin",function(nv,ov){if(!nv){$scope.connection.params.pluginID="";$scope.pluginDesc={};$scope.llmOptions=[]}else{$scope.connection.params.pluginID=$scope.selectedPlugin.id;$scope.pluginDesc=$scope.selectedPlugin;$scope.llmOptions=$scope._allCustomLLMPlugins.filter(llm=>llm.ownerPluginId===nv.id).sort((a,b)=>a.desc.meta.label.localeCompare(b.desc.meta.label))}loadLLMPlugins();cachedLLMDefinitions[ov&&ov.id]=$scope.connection.params.models;$scope.connection.params.models=cachedLLMDefinitions[nv&&nv.id]||[];for(const model of $scope.connection.params.models){$scope.onModelTypeChanged(model)}});let previousType;$scope.onModelTypeChanged=function(model){model.$cachedCustomConfig=model.$cachedCustomConfig||{};model.$cachedCustomConfig[previousType||model.type]=angular.copy(model.customConfig);previousType=model.type;if(model.$cachedCustomConfig[model.type]){model.customConfig=model.$cachedCustomConfig[model.type]}const loadedDesc=$scope.llmOptions.find(llm=>llm.llmType==model.type);if(loadedDesc){model.$desc=angular.copy(loadedDesc.desc);for(let paramName in model.customConfig){if(!model.$desc.params.some(x=>x.name===paramName)){delete model.customConfig[paramName]}}PluginConfigUtils.setDefaultValues(model.$desc.params,model.customConfig)}};$scope.addModel=function(){DataikuAPI.humanId.create($scope.connection.params.models.map(model=>model.id)).then(function({data}){$scope.connection.params.models.push({id:data.id,capability:"TEXT_COMPLETION",type:undefined,customConfig:{}})})};$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testCustomLLM($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope))["finally"](function(){$scope.testing=false})};$scope.capabilities=[["TEXT_COMPLETION","Chat completion"],["TEXT_COMPLETION_MULTIMODAL","Chat completion (multimodal)"],["TEXT_EMBEDDING","Text embedding"],["IMAGE_GENERATION","Image generation"],["TEXT_IMAGE_EMBEDDING_EXTRACTION","Multimodal embedding"]]});app.controller("PineconeConnectionController",function($scope,TopNav,DataikuAPI){TopNav.setLocation(TopNav.DSS_HOME,"administration");if($scope.creation){$scope.connection.params["version"]="POST_APRIL_2024"}$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testPinecone($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope)).finally(function(){$scope.testing=false})}});app.controller("AzureAISearchConnectionController",function($scope,TopNav,DataikuAPI){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.azureResourceURLFormat="https://RESOURCE_NAME.search.windows.net";$scope.testConnection=function(){$scope.testing=true;DataikuAPI.admin.connections.testAzureAISearch($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope)).finally(function(){$scope.testing=false})}});app.controller("KafkaConnectionController",function($scope,$controller,DataikuAPI,TopNav,CodeMirrorSettingService,FeatureFlagsService){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.codeMirrorSettingService=CodeMirrorSettingService;$scope.securityModes=[{id:"NONE",label:"No security protocol"},{id:"KERBEROS",label:"Kerberos"},{id:"SASL",label:"Generic Sasl"},{id:"CUSTOM",label:"Custom (using properties)"}];$scope.testConnection=function(){$scope.testing=true;$scope.testResult=null;DataikuAPI.admin.connections.testKafka($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope)).finally(function(){$scope.testing=false})};$scope.testKsql=function(){$scope.testingKsql=true;$scope.testKsqlResult=null;DataikuAPI.admin.connections.testKsql($scope.connection).success(function(data){$scope.testKsqlResult=data}).error(setErrorInScope.bind($scope)).finally(function(){$scope.testingKsql=false})};$scope.showKsqlSettings=function(){return FeatureFlagsService.featureFlagEnabled("ignoreKsqlDeprecation")}});app.controller("SQSConnectionController",function($scope,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.testConnection=function(){$scope.testing=true;$scope.testResult=null;DataikuAPI.admin.connections.testSQS($scope.connection).success(function(data){$scope.testResult=data}).error(setErrorInScope.bind($scope)).finally(function(){$scope.testing=false})}});app.controller("MongoDBConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.checkForHttpInHostUrl=host=>host&&(host.startsWith("http://")||host.startsWith("https://"));if($scope.creation){$scope.connection.params["useURI"]=false;$scope.connection.params["uri"]="mongodb://HOST:27017/DB"}var sequenceId=0;$scope.testConnection=function(){if(!$scope.connectionParamsForm||$scope.connectionParamsForm.$valid){$scope.testing=true;$scope.testResult=null;DataikuAPI.admin.connections.testMongoDB($scope.connection,++sequenceId).success(function(data){if(data.sequenceId!=sequenceId){return}$scope.testing=false;$scope.testResult=data}).error(setErrorInScope.bind($scope))}}});app.controller("DynamoDBConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");if($scope.creation){$scope.connection.params["regionOrEndpoint"]="eu-west-3";$scope.connection.params["mode"]="WEBSERVICE";$scope.connection.params["port"]=8e3;$scope.connection.params["hostname"]="localhost";$scope.connection.params["rwCapacityMode"]="ON_DEMAND";$scope.connection.params["readCapacity"]=1;$scope.connection.params["writeCapacity"]=1}var sequenceId=0;$scope.testConnection=function(){if(!$scope.connectionParamsForm||$scope.connectionParamsForm.$valid){$scope.testing=true;$scope.testResult=null;DataikuAPI.admin.connections.testDynamoDB($scope.connection,++sequenceId).success(function(data){if(data.sequenceId!=sequenceId){return}$scope.testing=false;$scope.testResult=data}).error(setErrorInScope.bind($scope))}}});app.controller("CassandraConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");addDatasetUniquenessCheck($scope,DataikuAPI);$scope.checkForHttpInHostsUrl=hosts=>hosts&&hosts.split(",").some(host=>host.startsWith("http://")||host.startsWith("https://"));$scope.testConnection=function(){if(!$scope.connectionParamsForm||$scope.connectionParamsForm.$valid){$scope.testing=true;$scope.testResult=null;DataikuAPI.admin.connections.testCassandra($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(setErrorInScope.bind($scope))}};if(!$scope.connection.customBasicConnectionCredentialProviderParams){$scope.connection.customBasicConnectionCredentialProviderParams=[]}});app.controller("IcebergConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.testConnection=function(){if(!$scope.connectionParamsForm||$scope.connectionParamsForm.$valid){$scope.testing=true;$scope.testResult=null;DataikuAPI.admin.connections.testIceberg($scope.connection).success(function(data){$scope.testing=false;$scope.testResult=data}).error(setErrorInScope.bind($scope))}}});app.controller("FTPConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");if($scope.creation){$scope.connection.params.passive=true;$scope.connection.allowManagedDatasets=false}$scope.connection.allowMirror=false;$scope.notTestable=true;if(!$scope.connection.params.dkuProperties){$scope.connection.params.dkuProperties=[]}});app.controller("SSHConnectionController",function($scope,$controller,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.connection.allowMirror=false;$scope.notTestable=true;if($scope.creation){$scope.connection.allowManagedDatasets=false;$scope.connection.params["usePublicKey"]=false}if(!$scope.connection.params.dkuProperties){$scope.connection.params.dkuProperties=[]}});app.component("credentialsErrorHandler",{templateUrl:"/templates/admin/credentials-error-handler.html",bindings:{error:"<",short:"<?"},controller:function($scope,ActivityIndicator,CredentialDialogs,DataikuAPI){const $ctrl=this;$scope.error=$ctrl.error;$scope.$watch("$ctrl.error",function(error){$scope.short=$ctrl.short?$ctrl.short:false;$scope.error=$ctrl.error;if(error&&error.code&&error.payload&&(error.payload.connectionName||error.payload.pluginId)){DataikuAPI.profile.listConnectionCredentials().then(({data:{credentials}})=>{$scope.credential=credentials.find(credential=>error.payload.connectionName&&error.payload.connectionName===credential.connection||error.payload.pluginId&&credential.pluginCredentialRequestInfo&&error.payload.pluginId===credential.pluginCredentialRequestInfo.pluginId&&error.payload.paramSetId===credential.pluginCredentialRequestInfo.paramSetId&&error.payload.presetId===credential.pluginCredentialRequestInfo.presetId&&error.payload.paramName===credential.pluginCredentialRequestInfo.paramName);if($scope.credentials){$scope.plugin=$scope.credential.pluginCredentialRequestInfo}})}else{$scope.credential=null}});$scope.needConnection=function(){return $scope.credential&&($scope.credential.type==="OAUTH_REFRESH_TOKEN"||$scope.credential.type==="AZURE_OAUTH_DEVICECODE")};$scope.enterCredential=function(){CredentialDialogs.enterCredential($scope,$scope.credential).then(function(redirect){if(!redirect){ActivityIndicator.success("Credential saved");$scope.credentialEntered=true}})};$scope.isConnectionCredential=function(){return $ctrl.error&&$ctrl.error.payload&&$ctrl.error.payload.connectionName}}})})();(function(){"use strict";var app=angular.module("dataiku.admin.security",[]);app.controller("AdminSecurityController",function(){});app.directive("projectGrantItem",function(){return{template:`
            <ul class="grant-matrix">
                <li><abbr ng-show="grant.item.readProjectContent" class="grant grant--readProjectContent" title="Read project content">RPC</abbr></li>
                <li><abbr ng-show="grant.item.writeProjectContent" class="grant grant--writeProjectContent" title="Write project content">WPC</abbr></li>
                <li><abbr ng-show="grant.item.shareToWorkspaces" class="grant grant--shareToWorkspaces" title="Publish to workspaces">PW</abbr></li>
                <li><abbr ng-show="grant.item.publishToDataCollections" class="grant grant--publishToDataCollections" title="Publish to Data Collections">PDC</abbr></li>
                <li><abbr ng-show="grant.item.readDashboards" class="grant grant--readDashboards" title="Read dashboard">RD</abbr></li>
                <li><abbr ng-show="grant.item.writeDashboards" class="grant grant--writeDashboards" title="Write dashboards">WD</abbr></li>
                <li ng-if="showLegacyPermissions"><abbr ng-show="grant.item.moderateDashboards" class="grant grant--moderateDashboards" title="Moderate dashboards">MD</abbr></li>
                <li ng-if="showLegacyPermissions"><abbr ng-show="grant.item.manageAdditionalDashboardUsers" class="grant grant--manageAdditionalDashboardUsers" title="Manage dashboard users">MDU</abbr></li>
                <li><abbr ng-show="grant.item.manageDashboardAuthorizations" class="grant grant--manageDashboardAuthorizations" title="Manage authorized objects">MAO</abbr></li>
                <li><abbr ng-show="grant.item.manageExposedElements" class="grant grant--manageExposedElements" title="Manage shared objects">MSO</abbr></li>
                <li><abbr ng-show="grant.item.runScenarios" class="grant grant--runScenarios" title="Run scenarios">RS</abbr></li>
                <li><abbr ng-show="grant.item.executeApp" class="grant grant--executeApp" title="Execute app">EA</abbr></li>
                <li><abbr ng-show="grant.item.editPermissions" class="grant grant--editPermissions" title="Edit permissions">EP</abbr></li>
                <li><abbr ng-show="grant.item.admin" class="grant grant--admin" title="Admin">A</abbr></li>
            </ul>
        `,scope:{grant:"=",showLegacyPermissions:"="}}});app.directive("authorizationMatrixTable",function(){return{scope:true,link:function($scope){$scope.hover={col:null}}}});app.controller("AdminSecurityAuthorizationMatrixUserController",function($scope){const loginIndexMap={};$scope.authorizationMatrix.perUser.users.forEach((user,userIdx)=>{loginIndexMap[user.login]=userIdx});$scope.localSelectedUsers=$scope.selectedUsers.map(idx=>$scope.authorizationMatrix.perUser.users[idx]);$scope.deselectUser=function(userIndex){$scope.localSelectedUsers=$scope.localSelectedUsers.filter((_,idx)=>idx!==userIndex)};$scope.save=function(){const localSelectedIndexes=$scope.localSelectedUsers.map(user=>loginIndexMap[user.login]);$scope.saveUsers(localSelectedIndexes,$scope.unselectedUsers);$scope.dismiss()}});app.controller("AdminSecurityAuthorizationMatrixGroupController",function($scope){const groupIndexMap={};$scope.authorizationMatrix.perGroup.groups.forEach((group,groupIdx)=>{groupIndexMap[group]=groupIdx});$scope.localSelectedGroups=$scope.selectedGroups.map(idx=>$scope.authorizationMatrix.perGroup.groups[idx]);$scope.deselectGroup=function(groupIndex){$scope.localSelectedGroups=$scope.localSelectedGroups.filter((_,idx)=>idx!==groupIndex)};$scope.save=function(group){const localSelectedIndexes=$scope.localSelectedGroups.map(group=>groupIndexMap[group]);$scope.saveGroups(localSelectedIndexes,$scope.unselectedGroups);$scope.dismiss()}});app.factory("AdminSecurityAuthorizationMatrixExportService",()=>{function isUserContext(context){return context==="USERS"}function globalAuthorizationTitleKeyPair(context){return[["Global admin","admin"],["Manage user-defined meanings","mayManageUDM"],["Create projects","mayCreateProjects"],["Create workspaces","mayCreateWorkspaces"],["Share to workspaces","mayShareToWorkspaces"],["Create Data Collections","mayCreateDataCollections"],["Publish to Data Collections","mayPublishToDataCollections"],[isUserContext(context)?"Manage own code envs":"Create code envs","mayCreateCodeEnvs"],["Manage all code envs","mayManageCodeEnvs"],[isUserContext(context)?"Manage own cluster":"Create clusters","mayCreateClusters"],["Manage all clusters","mayManageClusters"],[isUserContext(context)?"Manage own Code Studio template":"Create Code Studio templates","mayCreateCodeStudioTemplates"],["Manage all Code Studio templates","mayManageCodeStudioTemplates"],["Develop plugins","mayDevelopPlugins"],["Edit lib folders","mayEditLibFolders"],["Create user connections","mayCreateAuthenticatedConnections"],["Write unisolated code","mayWriteUnsafeCode"],["Write isolated code","mayWriteSafeCode"],["Create published API services","mayCreatePublishedAPIServices"],["Create published projects","mayCreatePublishedProjects"],["May write in root project folder","mayWriteInRootProjectFolder"],["May create active web content","mayCreateActiveWebContent"],["Create Data Collections","mayCreateDataCollections"],["Publish to Data Collections","mayPublishToDataCollections"]]}function projectAuthorizationTitleKeyPair(){return[["Read project content","readProjectContent"],["Write project content","writeProjectContent"],["Run scenarios","runScenarios"],["Share to workspaces","shareToWorkspaces"],["Read dashboard","readDashboards"],["Write dashboards","writeDashboards"],["Moderate dashboards","moderateDashboards"],["Manage authorized objects","manageDashboardAuthorizations"],["Manage shared objects","manageExposedElements"],["Manage dashboard users","manageAdditionalDashboardUsers"],["Share to Data Collections","publishToDataCollections"],["Execute app","executeApp"],["Admin","admin"]]}function createHeader(context){let headers=[{name:"Permission",type:"string"},{name:"Type",type:"string"},{name:"Name",type:"string"}];if(isUserContext(context)){headers.push({name:"User",type:"string"},{name:"Login",type:"string"})}else{headers.push({name:"Group",type:"string"})}headers.push({name:"Value",type:"string"});return headers}function createInstanceAuthorization(element,index,rawAuthorizationMatrix,context){const selector=isUserContext(context)?"perUser":"perGroup";return globalAuthorizationTitleKeyPair(context).map(authorization=>{let result=[authorization[0],"GLOBAL",null];if(isUserContext(context)){result.push(element.displayName,element.login)}else{result.push(element)}result.push(`${rawAuthorizationMatrix[selector][authorization[1]][index]?1:0}`);return result})}function createProjectAuthorization(element,elementIndex,rawAuthorizationMatrix,context){const selector=isUserContext(context)?"perUser":"perGroup";return rawAuthorizationMatrix[selector].projectsGrants.map(projectGrants=>{return projectAuthorizationTitleKeyPair().map(authorization=>{let result=[authorization[0],"PROJECT",projectGrants.projectKey];if(isUserContext(context)){result.push(element.displayName,element.login)}else{result.push(element)}result.push(projectGrants.grants[elementIndex]?`${projectGrants.grants[elementIndex].item[authorization[1]]?1:0}`:"0");return result})})}function createElement(rawAuthorizationMatrix,context){return function(element,index){return[...createInstanceAuthorization(element,index,rawAuthorizationMatrix,context),...createProjectAuthorization(element,index,rawAuthorizationMatrix,context).flat()]}}function createData(rawAuthorizationMatrix,context){return rawAuthorizationMatrix[isUserContext(context)?"perUser":"perGroup"][isUserContext(context)?"users":"groups"].map(createElement(rawAuthorizationMatrix,context)).flat()}return function(rawAuthorizationMatrix,context){return{name:`${isUserContext(context)?"users":"groups"}-matrix`,description:"The matrix",columns:createHeader(context),data:createData(rawAuthorizationMatrix,context)}}});app.controller("AdminSecurityAuthorizationMatrixController",function($scope,DataikuAPI,TopNav,CreateModalFromTemplate,ExportUtils,AdminSecurityAuthorizationMatrixExportService,$filter){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.formData={};$scope.selectedUsers=[];$scope.selectedGroups=[];$scope.userPagination={selectedPage:0,pageSize:50};$scope.groupPagination={selectedPage:0,pageSize:50};$scope.uiState={showPermissionsBy:"USERS",query:"",showLegacyPermissions:false};$scope.authorizationMatrix={perUser:{projectsGrants:[]},perGroup:{projectsGrants:[]}};function createRangeOfTenOrLessFromList(list){return Array.from({length:Math.min(list.length,10)},(_,k)=>k)}function isUserSelected(index){return $scope.selectedUsers.includes(index)}function isGroupSelected(index){return $scope.selectedGroups.includes(index)}$scope.saveUsers=function(selectedUsers,unselectedUsers){$scope.selectedUsers=selectedUsers;$scope.unselectedUsers=unselectedUsers};$scope.showUserModal=function(){CreateModalFromTemplate("/templates/admin/security/authorization-matrix-user.html",$scope,"AdminSecurityAuthorizationMatrixUserController")};$scope.saveGroups=function(selectedGroups,unselectedGroups){$scope.selectedGroups=selectedGroups;$scope.unselectedGroups=unselectedGroups};$scope.showGroupModal=function(){CreateModalFromTemplate("/templates/admin/security/authorization-matrix-group.html",$scope,"AdminSecurityAuthorizationMatrixGroupController")};DataikuAPI.security.getAuthorizationMatrix().success(function(data){$scope.authorizationMatrix=data;$scope.selectedUsers=createRangeOfTenOrLessFromList(data.perUser.users);$scope.selectedGroups=createRangeOfTenOrLessFromList(data.perGroup.groups);$scope.unselectedUsers=data.perUser.users.filter((_,index)=>!isUserSelected(index));$scope.unselectedGroups=data.perGroup.groups.filter((_,index)=>!isGroupSelected(index))}).error(setErrorInScope.bind($scope));$scope.onGroupPageSelect=function(event){$scope.groupPagination.selectedPage=event.pageIndex};$scope.onUserPageSelect=function(event){$scope.userPagination.selectedPage=event.pageIndex};function resetPaginationSelectedPageIfNeeded(filteredOutput,paginationSettings){if(Math.ceil(filteredOutput.length/paginationSettings.pageSize)<=paginationSettings.selectedPage){paginationSettings.selectedPage=0}}$scope.$watchCollection(()=>[$scope.authorizationMatrix.perGroup.projectsGrants,$scope.uiState.query],([projectsGrantsGroup,filterQuery])=>{$scope.filteredGroup=$filter("filter")(projectsGrantsGroup,filterQuery);resetPaginationSelectedPageIfNeeded($scope.filteredGroup,$scope.groupPagination)});$scope.$watchCollection(()=>[$scope.authorizationMatrix.perUser.projectsGrants,$scope.uiState.query],([projectsGrantsUser,filterQuery])=>{$scope.filteredUser=$filter("filter")(projectsGrantsUser,filterQuery);resetPaginationSelectedPageIfNeeded($scope.filteredUser,$scope.userPagination)});$scope.uiState=$scope.uiState||{};$scope.uiState.showPermissionsBy=$scope.uiState.showPermissionsBy||"USERS";$scope.export=function(){ExportUtils.exportUIData($scope,AdminSecurityAuthorizationMatrixExportService($scope.authorizationMatrix,$scope.uiState.showPermissionsBy),`Export ${$scope.uiState.showPermissionsBy==="USERS"?"users":"groups"} matrix`,{downloadOnly:true,hideAdvancedParameters:true})}});app.directive("authorizations",function(){return{restrict:"A",scope:{title:"@",selectedElements:"<",allElements:"<",key:"@"},template:`
            <th class="table-matrix__title table-matrix__title--grant">{{title}}</th>
            <td ng-repeat="elementIndex in selectedElements"
                ng-class="{'global-grant': allElements[key][elementIndex]}">
                <i class="icon-ok-sign" ng-if="allElements[key][elementIndex]" />
                <span class="sr-only" ng-if="allElements[key][elementIndex]">Enabled</span>
            </td>
    `}});app.component("paginationInfo",{bindings:{selectedPage:"<",pageSize:"<",listSize:"<"},controller:function(){this.$onChanges=()=>{this.firstVisibleElement=this.selectedPage*this.pageSize+1;this.lastVisibleElement=Math.min((this.selectedPage+1)*this.pageSize,this.listSize)}},template:`
        <span class="pagination__label">Projects &nbsp;{{$ctrl.firstVisibleElement}}-{{$ctrl.lastVisibleElement}} of {{$ctrl.listSize}}</span>
    `});app.component("discoverabilitySettings",{bindings:{objectType:"<",requestType:"<",requestDocumentation:"<",visibilitySettings:"<"},templateUrl:"/templates/admin/security/discoverability-settings-dropdowns.html"});app.controller("UsersController",function($scope,$filter,DataikuAPI,Dialogs,TopNav,Logger,CreateModalFromTemplate,ListFilter,WT1,FutureProgressModal){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.canFetchExternalUsers=false;DataikuAPI.admin.users.getFetchableSourceTypes().success(function(data){$scope.canFetchExternalUsers=(data||[]).length>0}).error(setErrorInScope.bind($scope));$scope.selection={orderQuery:"login",orderReversed:false};$scope.pagination=new ListFilter.Pagination([],50);$scope.isOutOfTrials=false;function arrayToHtmlList(a){return a.map(e=>`<li>${sanitize(e)}</li>`).join("")}function formatUsers(users){return users.map(u=>`${u.login}: ${u.displayName}`)}function refreshList(){const lastActivity=true;DataikuAPI.admin.users.list(lastActivity).success(function(data){$scope.users=data;refreshPage()}).error(setErrorInScope.bind($scope))}function refreshPage(){$scope.pagination.updateAndGetSlice($scope.selection.filteredObjects)}$scope.switchToTrial=function(login){const targetLoginH=md5(login.toLowerCase());function startUserTrial(selectedItem){WT1.event("admin-user-trial-start",{forLoginh:targetLoginH,chosenUserProfile:selectedItem["title"]});DataikuAPI.admin.users.switchToTrial(login,selectedItem["title"]).success(function(data){WT1.event("admin-user-trial-start-success",{forLoginh:targetLoginH,chosenUserProfile:selectedItem["title"]});refreshList()}).error(function(a,b,c){setErrorInScope.bind($scope)(a,b,c);WT1.event("admin-user-trial-start-failed",{forLoginh:targetLoginH,chosenUserProfile:selectedItem["title"]})})}DataikuAPI.admin.getTrialStatus().success(function(data){const trialLicenses=window.dkuAppConfig.licensing.userProfiles.filter(profile=>profile!=="NONE").map(profile=>{const profileTrialStatus=data.allocations.filter(elt=>elt.userProfile===profile);const remainingTokensForProfile=profileTrialStatus.length>0&&profileTrialStatus[0].mode==="TOTAL_CREDIT"?profileTrialStatus[0].remainingCredit:0;const selectable=remainingTokensForProfile>0||profileTrialStatus.length&&profileTrialStatus[0].mode!=="TOTAL_CREDIT";return{title:profile,desc:"Start a trial as profile "+profile,selectable:selectable,unselectableReason:!selectable?`No more trial tokens available for the "${profile}" profile. Please select another profile or reach out to Dataiku to request additional trial tokens.`:""}});const selectableTrialLicences=trialLicenses.filter(item=>item.selectable);if(selectableTrialLicences.length===0){$scope.isOutOfTrials=true;return}$scope.isOutOfTrials=false;Dialogs.select($scope,"Start trial for "+login,"Please select the user profile for which a trial will be started",trialLicenses,selectableTrialLicences[0]||null,{alert:"Dataiku needs to store the user's login in order to grant the personal trial license. Additionally, Dataiku may contact the user during the trial, for onboarding purposes.",alertLevel:"info"}).then(startUserTrial)}).error(setErrorInScope.bind($scope))};function getConversionOptions(userProfile){let ret=[{title:"Remove access",desc:"User profile will be changed to NONE"},{title:"Convert to normal user",desc:"User will become a normal user, with the user profile "+userProfile}];if(window.dkuAppConfig&&window.dkuAppConfig.licensing&&window.dkuAppConfig.licensing.userProfiles&&window.dkuAppConfig.licensing.userProfiles.indexOf("AI_CONSUMER")>=0){ret.push({title:"Convert to AI Consumer",desc:"User will become an AI Consumer user"})}else{ret.push({title:"Convert to Reader",desc:"User will become a Reader user"})}return ret}$scope.convertExpiredTrial=function(user){const login=user.login;const targetLoginH=md5(login.toLowerCase());const items=getConversionOptions(user.userProfile);Dialogs.select($scope,"Convert expired trial for "+login,login+" had a trial, but it expired. What do you want to do next?",items,items[0]).then(function(selectedItem){let action=null;if(selectedItem===items[0]){action="SWITCH_TO_NONE"}else if(selectedItem===items[1]){action="SWITCH_TO_REGULAR"}else if(selectedItem===items[2]){action="SWITCH_TO_READER"}WT1.event("admin-user-trial-convert-expired",{forLoginh:targetLoginH,action:action});DataikuAPI.admin.users.convertFromTrial(login,action).success(function(data){refreshList()}).error(setErrorInScope.bind($scope))})};$scope.convertActiveTrial=function(user){const login=user.login;const targetLoginH=md5(login.toLowerCase());const items=getConversionOptions(user.userProfile);Dialogs.select($scope,"Convert trial for "+login,login+" is currently running a trial. What do you want to do next?",items,items[0]).then(function(selectedItem){let action=null;if(selectedItem===items[0]){action="SWITCH_TO_NONE"}else if(selectedItem===items[1]){action="SWITCH_TO_REGULAR"}else if(selectedItem===items[2]){action="SWITCH_TO_READER"}WT1.event("admin-user-trial-convert-not-expired",{forLoginh:targetLoginH,action:action});DataikuAPI.admin.users.convertFromTrial(login,action).success(function(data){refreshList()}).error(setErrorInScope.bind($scope))})};$scope.canDoDisableEnableMassAction=function(selectedUsers,activate){return selectedUsers.some(u=>u.enabled!==activate)};$scope.activateDeactivateUsers=function(users,activate){event.preventDefault();if(!$scope.canDoDisableEnableMassAction(users,activate)){return}users=users.filter(u=>u.enabled!==activate);const title=`Confirm user${users.length>1?"s":""} ${activate?"activation":"deactivation"}`;const loginsText=arrayToHtmlList(formatUsers(users));const text=`Are you sure you want to ${activate?"enable":"disable"} the following user${users.length>1?"s":""}<ul>${loginsText}</ul>`;const logins=users.map(u=>u.login);if(activate){Dialogs.confirmPositive($scope,title,text).then(()=>{DataikuAPI.admin.users.enableOrDisable(logins,true).success(()=>{refreshList();logins.forEach(login=>{WT1.event("user-enable",{forLoginh:md5(login.toLowerCase())})})}).error(setErrorInScope.bind($scope))})}else{DataikuAPI.admin.users.prepareDisable(logins).success(data=>{Dialogs.confirmInfoMessages($scope,title,data,text,false).then(()=>{DataikuAPI.admin.users.enableOrDisable(logins,false).success(()=>{refreshList();logins.forEach(login=>{WT1.event("user-disable",{forLoginh:md5(login.toLowerCase())})})}).error(setErrorInScope.bind($scope))})}).error(setErrorInScope.bind($scope))}};$scope.deleteUsers=function(selectedUsers){const loginsText=arrayToHtmlList(formatUsers(selectedUsers));const text=`Are you sure you want to delete the following users<ul>${loginsText}</ul>`;const logins=selectedUsers.map(u=>u.login);DataikuAPI.admin.users.prepareDelete(logins).success(function(data){Dialogs.confirmInfoMessages($scope,"Confirm users deletion",data,text,false).then(function(){DataikuAPI.admin.users.delete(logins).success(function(data){refreshList();logins.forEach(login=>{WT1.event("user-delete",{forLoginh:md5(login.toLowerCase())})})}).error(setErrorInScope.bind($scope))})}).error(setErrorInScope.bind($scope))};$scope.deleteUser=function(user){DataikuAPI.admin.users.prepareDelete([user.login]).success(function(data){Dialogs.confirmInfoMessages($scope,"Confirm user deletion",data,'Are you sure you want to delete user "'+sanitize(user.login)+'"?',false).then(function(){DataikuAPI.admin.users.delete([user.login]).success(function(data){refreshList();WT1.event("user-delete",{forLoginh:md5(user.login.toLowerCase())})}).error(setErrorInScope.bind($scope))})}).error(setErrorInScope.bind($scope))};$scope.openAssignUsersToGroupModal=function(users,groups){CreateModalFromTemplate("/templates/admin/security/assign-users-groups-modal.html",$scope,null,function(newScope){newScope.users=users;const newGroups={};groups.forEach(group=>{const empty=!users.some(u=>u.groups.includes(group));const full=users.every(u=>u.groups.includes(group));newGroups[group]={name:group,selected:full,originallyAssigned:!empty,indeterminate:!empty&&!full}});newScope.groups=newGroups;let newAssignedGroups={};newScope.assignGroup=function(group){if(!group.selected&&group.originallyAssigned){newAssignedGroups[group.name]=false}else if(group.selected&&!group.originallyAssigned){newAssignedGroups[group.name]=true}else if(group.selected&&group.indeterminate){newAssignedGroups[group.name]=true}else{delete newAssignedGroups[group.name]}};newScope.wereGroupsChanged=function(){return Object.keys(newAssignedGroups).length>0};newScope.assignGroups=function(users){const groupsToAdd=Object.keys(newAssignedGroups).filter(k=>newAssignedGroups[k]);const groupsToRemove=Object.keys(newAssignedGroups).filter(k=>!newAssignedGroups[k]);const loginsText=arrayToHtmlList(formatUsers(users));let text=`The following users <ul>${loginsText}</ul>`;if(groupsToAdd.length>0){const groupsToAddText=arrayToHtmlList(groupsToAdd);text+=`will be added to groups <ul>${groupsToAddText}</ul>`}if(groupsToRemove.length>0){const groupsToRemoveText=arrayToHtmlList(groupsToRemove);text+=`will be removed from groups <ul>${groupsToRemoveText}</ul>`}const logins=users.map(u=>u.login);DataikuAPI.admin.users.prepareAssignUsersGroups(logins,groupsToAdd,groupsToRemove).success(function(data){Dialogs.confirmInfoMessages($scope,"Confirm reassigning users to groups",data,text,false).then(function(){newScope.dismiss();Logger.info("Adding users",logins,"to group",groupsToAdd," and removing from groups",groupsToRemove);DataikuAPI.admin.users.assignUsersGroups(logins,groupsToAdd,groupsToRemove).success(function(data){refreshList()}).error(setErrorInScope.bind($scope))})}).error(setErrorInScope.bind($scope))}})};$scope.openAssignUsersToProfileModal=function(users){CreateModalFromTemplate("/templates/admin/security/assign-users-profile-modal.html",$scope,null,function(newScope){newScope.users=users;newScope.newProfile=null;newScope.assignProfile=function(users,newProfile){const usersByProfile=new Map;const usersToUpdate=users.filter(u=>u.userProfile!==newProfile);usersToUpdate.forEach(user=>{if(user.userProfile!==newProfile){const usersForProfile=usersByProfile.get(user.userProfile);if(usersForProfile){usersForProfile.push(user)}else{usersByProfile.set(user.userProfile,[user])}}});let text="";usersByProfile.forEach((affectedUsers,profile)=>{const loginsText=arrayToHtmlList(formatUsers(affectedUsers));const niceProfile=$filter("niceProfileName")(profile);const niceNewProfile=$filter("niceProfileName")(newProfile);text+=`The following users will have their profile changed from <strong>${niceProfile}</strong> to <strong>${niceNewProfile}</strong>: <ul class="mbot8">${loginsText}</ul></p>`});Dialogs.confirmInfoMessages($scope,"Confirm changing profile for users",null,text,false).then(()=>{newScope.dismiss();const logins=usersToUpdate.map(u=>u.login);DataikuAPI.admin.users.assignUsersProfile(logins,newProfile).success(()=>{refreshList()}).error(setErrorInScope.bind($scope))})}})};$scope.$watch("pagination.page",()=>{$scope.pagination.update()});$scope.$watch("selection.filteredObjects",()=>{refreshPage()});refreshList();DataikuAPI.security.listGroups(true).success(function(data){if(data){data.sort()}$scope.groups=data}).error(setErrorInScope.bind($scope));$scope.syncAll=function(){DataikuAPI.admin.users.syncAll().success(function(data){FutureProgressModal.show($scope,data,"Syncing users...",null,"static",false,true).then(function(result){Dialogs.infoMessagesDisplayOnly($scope,"Sync result",result,result.futureLog);refreshList()})}).error(setErrorInScope.bind($scope))};$scope.canSyncAll=false;DataikuAPI.admin.users.getSyncableSourceTypes().success(function(data){$scope.canSyncAll=data.length>0}).error(setErrorInScope.bind($scope))});app.controller("UserController",function($scope,$state,$stateParams,DataikuAPI,$route,TopNav,Dialogs,ActivityIndicator,WT1,FutureProgressModal){TopNav.setLocation(TopNav.DSS_HOME,"administration");let savedUser;$scope.user={groups:[],login:"",sourceType:"LOCAL",displayName:"",userProfile:"DATA_SCIENTIST",password:"",trialTokenStrategy:"NO_ATTEMPT"};if($scope.appConfig&&$scope.appConfig.licensing&&$scope.appConfig.licensing.userProfiles){$scope.user.userProfile=$scope.appConfig.licensing.userProfiles[0]}if($stateParams.login){$scope.creation=false;fetchUser()}else{$scope.creation=true;DataikuAPI.security.listGroups(true).success(function(data){if(data){data.sort()}$scope.allGroups=data}).error(setErrorInScope.bind($scope))}function fetchUser(){DataikuAPI.security.listGroups(true).success(function(data){if(data){data.sort()}$scope.allGroups=data;DataikuAPI.admin.users.get($stateParams.login).success(function(data){$scope.user=data;savedUser=angular.copy(data)}).error(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))}$scope.prepareSaveUser=function(){if($scope.creation){$scope.saveUser()}else{DataikuAPI.admin.users.prepareUpdate($scope.user).success(function(data){Dialogs.confirmInfoMessages($scope,"Confirm user edition",data,'Are you sure you want to edit user "'+sanitize($scope.user.login)+'"?',true).then($scope.saveUser)}).error(setErrorInScope.bind($scope))}};const buildUserWT1Params=user=>{const params={forLoginh:md5(user.login.toLowerCase()),type:user.sourceType,chosenUserProfile:user.userProfile};if(user.email&&user.email!=""){params.forEmailh=md5(user.email.toLowerCase())}return params};$scope.saveUser=function(){if($scope.creation){DataikuAPI.admin.users.create($scope.user).success(function(data){WT1.event("user-create",buildUserWT1Params($scope.user));Dialogs.infoMessagesDisplayOnly($scope,"Warnings during user creation",data).then(function(){$state.go("admin.security.users.list")})}).error(setErrorInScope.bind($scope))}else{DataikuAPI.admin.users.update($scope.user).success(function(data){WT1.event("user-edit",buildUserWT1Params($scope.user));$state.go("admin.security.users.list")}).error(setErrorInScope.bind($scope))}};$scope.userIsDirty=function(){return!angular.equals(savedUser,$scope.user)};var getGeneralSettings=function(){DataikuAPI.admin.getGeneralSettings().success(function(gs){$scope.generalSettings=gs}).error(setErrorInScope.bind($scope))};$scope.$watch("user",function(){if(!$scope.user.adminProperties){$scope.user.adminProperties={}}if(!$scope.user.userProperties){$scope.user.userProperties={}}});getGeneralSettings();$scope.syncUser=function(){DataikuAPI.admin.users.sync($stateParams.login).success(function(data){FutureProgressModal.show($scope,data,"Syncing user...",null,"static",false,true).then(function(result){Dialogs.infoMessagesDisplayOnly($scope,"Sync result",result,result.futureLog);fetchUser()})}).error(setErrorInScope.bind($scope))};if(!$scope.creation){DataikuAPI.admin.users.getSyncableSourceTypes().success(function(data){$scope.syncableSourceTypes=data}).error(setErrorInScope.bind($scope))}});app.controller("GroupsController",function($scope,$state,$stateParams,DataikuAPI,$route,$modal,$q,Dialogs,TopNav,CreateModalFromTemplate){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.usersByGroup={};$scope.apiKeysByGroup={};var loadGroups=function(){const promises=[DataikuAPI.security.listGroupsFull(),DataikuAPI.security.listUsers(),DataikuAPI.admin.publicApi.listGlobalKeys()];$q.all(promises).then(function(responses){const groups=responses[0].data;const users=responses[1].data;const apiKeys=responses[2].data;for(const group of groups){group.userCount=0;$scope.usersByGroup[group.name]=[];for(const userDesc of users){if(userDesc.groups.includes(group.name)){group.userCount++;$scope.usersByGroup[group.name].push(userDesc)}}group.apiKeyCount=0;$scope.apiKeysByGroup[group.name]=[];for(const apiKeyDesc of apiKeys){if(apiKeyDesc.groups&&apiKeyDesc.groups.includes(group.name)){group.apiKeyCount++;$scope.apiKeysByGroup[group.name].push(apiKeyDesc)}}}$scope.groups=groups}).catch(setErrorInScope.bind($scope))};$scope.deleteGroup=function(group){DataikuAPI.security.prepareDeleteGroup(group.name).success(function(data){Dialogs.confirmInfoMessages($scope,"Delete group",data,'Are you sure you want to delete group "'+sanitize(group.name)+'" ?',false).then(function(){DataikuAPI.security.deleteGroup(group.name).success(function(data){loadGroups()}).error(setErrorInScope.bind($scope))})}).error(setErrorInScope.bind($scope))};$scope.showGroupUsers=groupName=>{CreateModalFromTemplate("/templates/admin/security/group-members-modal.html",$scope,null,function(newScope){newScope.groupName=groupName;newScope.usersInGroup=$scope.usersByGroup[groupName];newScope.matchesQuery=object=>{if(!object)return false;if(!newScope.filterQuery)return true;if(object.login&&object.login.toLowerCase().includes(newScope.filterQuery.toLowerCase())){return true}if(object.displayName&&object.displayName.toLowerCase().includes(newScope.filterQuery.toLowerCase())){return true}return false}})};$scope.showGroupApiKeys=groupName=>{CreateModalFromTemplate("/templates/admin/security/group-apikeys-modal.html",$scope,null,function(newScope){newScope.groupName=groupName;newScope.apiKeysInGroup=$scope.apiKeysByGroup[groupName];newScope.matchesQuery=object=>{if(!object)return false;if(!newScope.filterQuery)return true;if(object.id&&object.id.toLowerCase().includes(newScope.filterQuery.toLowerCase())){return true}if(object.label&&object.label.toLowerCase().includes(newScope.filterQuery.toLowerCase())){return true}return false}})};loadGroups()});app.controller("GroupController",function($scope,$state,$stateParams,DataikuAPI,$route,TopNav,Dialogs){TopNav.setLocation(TopNav.DSS_HOME,"administration");let savedGroup;if($stateParams.name){$scope.creation=false;DataikuAPI.security.getGroup($stateParams.name).success(function(data){$scope.group=data;savedGroup=angular.copy(data)}).error(setErrorInScope.bind($scope))}else{$scope.creation=true;$scope.group={sourceType:"LOCAL",mayWriteSafeCode:true,mayWriteInRootProjectFolder:true,mayCreateProjects:true,mayCreateActiveWebContent:true,mayShareToWorkspaces:true,mayCreateDataCollections:true,mayPublishToDataCollections:true}}$scope.prepareSaveGroup=function(){if($scope.creation){$scope.saveGroup()}else{DataikuAPI.security.prepareUpdateGroup($scope.group).success(function(data){Dialogs.confirmInfoMessages($scope,"Confirm user edition",data,'Are you sure you want to edit group "'+sanitize($scope.group.name)+'"?',true).then($scope.saveGroup)}).error(setErrorInScope.bind($scope))}};$scope.saveGroup=function(){if($scope.creation){DataikuAPI.security.createGroup($scope.group).success(function(data){$state.go("admin.security.groups.list")}).error(setErrorInScope.bind($scope))}else{DataikuAPI.security.updateGroup($scope.group).success(function(data){$state.go("admin.security.groups.list")}).error(setErrorInScope.bind($scope))}};$scope.groupIsDirty=function(){return!angular.equals(savedGroup,$scope.group)};var getGeneralSettings=function(){DataikuAPI.admin.getGeneralSettings().success(function(gs){$scope.generalSettings=gs}).error(setErrorInScope.bind($scope))};$scope.$watch("[group.sourceType, group.ldapGroupNames, group.azureADGroupNames, group.ssoGroupNames, group.customGroupNames]",()=>{const invalidGroupMappingRequiredState=!$scope.group||$scope.group.sourceType==="LDAP"&&($scope.group.ldapGroupNames||[]).length===0||$scope.group.sourceType==="AZURE_AD"&&($scope.group.azureADGroupNames||[]).length===0||$scope.group.sourceType==="LOCAL_NO_AUTH"&&($scope.group.ssoGroupNames||[]).length===0||$scope.group.sourceType==="CUSTOM"&&($scope.group.customGroupNames||[]).length===0;$scope.groupDescriptionForm.$setValidity("ldapGroupMappingRequired",!invalidGroupMappingRequiredState)});getGeneralSettings()});app.controller("ExternalUsersController",function($scope,DataikuAPI,Dialogs,ListFilter,FutureProgressModal,FutureWatcher){$scope.selection={orderQuery:"userAttributes.login",orderReversed:false};$scope.pagination=new ListFilter.Pagination([],50);$scope.fetchUsers=function(){let groupName=$scope.groupName?$scope.groupName:$scope.groupNameSelect;DataikuAPI.admin.users.fetchUsers($scope.userSourceType,{login:$scope.login,email:$scope.email,groupName:groupName}).success(function(initialResponse){FutureProgressModal.show($scope,initialResponse,"Fetching users...",null,"static",false,true).then(function(result){$scope.users=result.users;refreshPage();if(result.unusedFilters&&result.unusedFilters.length>0){Dialogs.ack($scope,"⚠️ Warning: Incompatible source type","This source type did not use the following filters: "+result.unusedFilters.join(", "))}})}).error(setErrorInScope.bind($scope))};function fetchUsersNoModal(){let groupName=$scope.groupName?$scope.groupName:$scope.groupNameSelect;DataikuAPI.admin.users.fetchUsers($scope.userSourceType,{login:$scope.login,groupName:groupName}).success(function(initialResponse){FutureWatcher.watchJobId(initialResponse.jobId).success(function(data){$scope.users=data.result.users;refreshPage()}).error(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))}$scope.provisionUsers=function(selectedUsers){let usersToSync=selectedUsers.filter(u=>u.status==="NOT_PROVISIONED");if(usersToSync.length>0){DataikuAPI.admin.users.provisionUsers($scope.userSourceType,usersToSync).success(function(data){FutureProgressModal.show($scope,data,"Provision users...",null,"static",false,true).then(function(result){let title="Provisioning result";if(result.maxSeverity!=="INFO"){let summaryMessage=result.messages.find(m=>m.code==="INFO_SECURITY_SUPPLIER_PROVISIONING_SUMMARY");if(summaryMessage){const index=result.messages.indexOf(summaryMessage);result.messages.splice(index,1);title=summaryMessage.details}}Dialogs.infoMessagesDisplayOnly($scope,title,result,result.futureLog);fetchUsersNoModal()})}).error(setErrorInScope.bind($scope))}else{let msg=`<div>All selected users are already provisioned</div>`;Dialogs.error($scope,`Failed to provision selected users.`,msg)}};$scope.syncUsers=function(selectedUsers){let usersToSync=selectedUsers.filter(u=>u.status==="UNSYNCED").map(u=>{return u.userAttributes.login});if(usersToSync.length>0){DataikuAPI.admin.users.syncUsers(usersToSync).success(function(data){FutureProgressModal.show($scope,data,"Syncing users...",null,"static",false,true).then(function(result){Dialogs.infoMessagesDisplayOnly($scope,"Sync result",result,result.futureLog);fetchUsersNoModal()})}).error(setErrorInScope.bind($scope))}else{let msg=`<div>All selected users cannot be synced (not yet provisionned or already synced)</div>`;Dialogs.error($scope,`Failed to sync selected users.`,msg)}};$scope.fetchGroups=function(){$scope.enableGroups=true;$scope.enableEmail=$scope.userSourceType=="AZURE_AD";if($scope.userSourceType=="LDAP"){$scope.enableGroups=$scope.generalSettings.ldapSettings.enableGroups}$scope.users=[];refreshPage();if($scope.enableGroups){DataikuAPI.admin.users.fetchGroups($scope.userSourceType).success(function(data){FutureProgressModal.show($scope,data,"Fetching groups for filtering...",null,"static",false,true).then(function(result){$scope.groups=result})}).error(setErrorInScope.bind($scope))}};$scope.$watch("pagination.page",()=>{$scope.pagination.update()});$scope.$watch("selection.filteredObjects",()=>{refreshPage()});function refreshPage(){$scope.pagination.updateAndGetSlice($scope.selection.filteredObjects)}var getGeneralSettings=function(){DataikuAPI.admin.getGeneralSettings().success(function(gs){$scope.generalSettings=gs}).error(setErrorInScope.bind($scope))};getGeneralSettings();$scope.fetchableSourceTypes=[];DataikuAPI.admin.users.getFetchableSourceTypes().success(function(data){$scope.fetchableSourceTypes=data}).error(setErrorInScope.bind($scope))});app.directive("globalPermissionsEditor",function(){return{scope:{permissions:"="},templateUrl:"/templates/admin/security/global-permissions-editor.html",link:function($scope){$scope.$watch("permissions",function(nv,ov){if(!nv)return;nv.$mayCreateProjectsFromMacrosDisabled=false;nv.$mayCreateProjectsFromTemplatesDisabled=false;if(nv.mayCreateProjects||nv.admin){nv.$mayCreateProjectsFromMacrosDisabled=true;nv.$mayCreateProjectsFromTemplatesDisabled=true}},true)}}});app.controller("AdminSecurityAuditBufferController",function($scope,$state,$stateParams,DataikuAPI,$route,TopNav,Dialogs){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.uiState={includeAllCalls:false};$scope.refreshList=function(){DataikuAPI.security.getAuditBuffer($scope.uiState.includeAllCalls).success(function(data){$scope.auditBuffer=data}).error(setErrorInScope.bind($scope))};$scope.refreshList()});app.filter("auditBufferEventDetails",function(Logger){return function(obj){var sa=[];Object.keys(obj).forEach(function(x){if(x!="callPath"&&x!="msgType"&&x!="authSource"&&x!="authUser"&&x!="clientIP"&&x!="originalIP"){let v=obj[x];if(typeof v==="object"){try{v=JSON.stringify(v)}catch(e){Logger.debug("could not stringify key: "+x)}}sa.push(x+": "+v)}});return sa.join(", ")}});app.controller("GlobalPublicAPIKeysController",function($scope,$state,DataikuAPI,CreateModalFromTemplate,Dialogs,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.refreshApiKeysList=function(){DataikuAPI.admin.publicApi.listGlobalKeys().success(function(data){$scope.apiKeys=data}).error(setErrorInScope.bind($scope))};$scope.refreshApiKeysList();$scope.deleteGlobalKey=function(keyId){Dialogs.confirm($scope,"Remove API key","Are you sure you want to remove this API key?").then(function(){DataikuAPI.admin.publicApi.deleteGlobalKey(keyId).success(function(data){$scope.refreshApiKeysList()}).error(setErrorInScope.bind($scope))})};$scope.viewQRCode=function(key){CreateModalFromTemplate("/templates/admin/security/api-key-qrcode-modal.html",$scope,null,function(newScope){newScope.apiKeyQRCode=JSON.stringify({k:key.key,u:$scope.appConfig.dssExternalURL})})};$scope.isExpired=function(key){return key.expiresOn!=0&&key.expiresOn<(new Date).getTime()}});app.controller("EditGlobalPublicAPIKeyController",function($scope,$state,DataikuAPI,TopNav,$stateParams,CreateModalFromTemplate,ClipboardUtils,Dialogs){TopNav.setLocation(TopNav.DSS_HOME,"administration");let oldKey;DataikuAPI.security.listGroups(false).success(function(data){if(data){data.sort()}$scope.allGroups=data}).error(setErrorInScope.bind($scope));if($stateParams.id){$scope.creation=false;DataikuAPI.admin.publicApi.getGlobalKey($stateParams.id).success(function(data){$scope.apiKey=data;oldKey=Object.assign({},data)}).error(setErrorInScope.bind($scope))}else{$scope.creation=true;$scope.apiKey={label:"New key",groups:[]}}$scope.migrateToGroups=function(){if($scope.apiKey){$scope.apiKey.groups=[]}};$scope.create=function(){DataikuAPI.admin.publicApi.createGlobalKey($scope.apiKey).success(function(data){CreateModalFromTemplate("/templates/admin/security/new-api-key-modal.html",$scope,null,function(newScope){newScope.hashedApiKeysEnabled=$scope.appConfig.hashedApiKeysEnabled;newScope.key=data;newScope.uiSref="admin.security.globalapi.list";newScope.copyKeyToClipboard=function(){ClipboardUtils.copyToClipboard(data.key,"Copied to clipboard.")};newScope.viewQRCode=function(){CreateModalFromTemplate("/templates/admin/security/api-key-qrcode-modal.html",$scope,null,function(newScope){newScope.apiKeyQRCode=JSON.stringify({k:data.key,u:$scope.appConfig.dssExternalURL})})};newScope.$on("$destroy",function(){$state.go(newScope.uiSref)})})}).error(setErrorInScope.bind($scope))};const doSave=function(){DataikuAPI.admin.publicApi.saveGlobalKey($scope.apiKey).success(function(data){$state.go("admin.security.globalapi.list")}).error(setErrorInScope.bind($scope))};$scope.save=function(){if((oldKey.groups===null||typeof oldKey.groups==="undefined")&&($scope.apiKey.groups||$scope.apiKey.groups===[])){Dialogs.confirmAlert($scope,"Switch to group-based permissions","API key permissions will now solely be determined by group membership.","Any previously defined permissions will be deleted.","WARNING").then(function(){doSave()})}else{doSave()}}});app.controller("AdminPersonalPublicAPIKeysController",function($scope,$state,translate,DataikuAPI,CreateModalFromTemplate,Dialogs,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.refreshApiKeysList=function(){DataikuAPI.admin.publicApi.listPersonalKeys().success(function(data){$scope.apiKeys=data}).error(setErrorInScope.bind($scope))};$scope.isExpired=function(key){return key.expiresOn!=0&&key.expiresOn<(new Date).getTime()};$scope.refreshApiKeysList();$scope.editPersonalAPIKey=function(apiKey){CreateModalFromTemplate("/templates/admin/security/personal-api-key-modal.html",$scope,null,function(newScope){newScope.apiKey={...apiKey};newScope.creation=false})};$scope.deletePersonalAPIKey=function(keyId){Dialogs.confirm($scope,translate("PROFILE.API_KEYS.REMOVE_DIALOG.TITLE","Remove API key"),translate("PROFILE.API_KEYS.REMOVE_DIALOG.MESSAGE","Are you sure you want to remove this API key?")).then(function(){DataikuAPI.admin.publicApi.deletePersonalKey(keyId).success(function(data){$scope.refreshApiKeysList()}).error(setErrorInScope.bind($scope))})};$scope.viewQRCode=function(key){CreateModalFromTemplate("/templates/admin/security/api-key-qrcode-modal.html",$scope,null,function(newScope){newScope.apiKeyQRCode=JSON.stringify({k:key.key,u:$scope.appConfig.dssExternalURL})})}});app.controller("EditPersonalAPIKeyModalController",function($scope,DataikuAPI,CreateModalFromTemplate,ClipboardUtils,WT1){$scope.create=function(){WT1.event("user-profile-create-API-key",{});DataikuAPI.profile.createPersonalAPIKey($scope.apiKey).success(function(data){$scope.refreshApiKeysList();CreateModalFromTemplate("/templates/admin/security/new-api-key-modal.html",$scope,null,function(newScope){newScope.hashedApiKeysEnabled=$scope.appConfig.hashedApiKeysEnabled;newScope.key=data;newScope.copyKeyToClipboard=function(){ClipboardUtils.copyToClipboard(data.key,"Copied to clipboard.");$scope.dismiss()};newScope.viewQRCode=function(){CreateModalFromTemplate("/templates/admin/security/api-key-qrcode-modal.html",$scope,null,function(newScope){newScope.apiKeyQRCode=JSON.stringify({k:data.key,u:$scope.appConfig.dssExternalURL})})};newScope.$on("$destroy",function(){$scope.dismiss()})})}).error(setErrorInScope.bind($scope))};$scope.save=function(apiKey){WT1.event("user-profile-edit-API-key",{});DataikuAPI.profile.editPersonalAPIKey(apiKey).success(function(data){$scope.dismiss();$scope.refreshApiKeysList()}).error(setErrorInScope.bind($scope))}})})();(function(){"use strict";var app=angular.module("dataiku.admin.maintenance",[]);app.constant("TAIL_STATUS",{DEBUG:0,INFO:1,WARNING:2,ERROR:3});app.controller("AdminMaintenanceController",function($scope,$rootScope,$state,DataikuCloudService){$scope.isCloud=DataikuCloudService.isDataikuCloud()});app.controller("AdminScheduledTasksController",function($scope,$rootScope,$state,DataikuAPI,ActivityIndicator,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.refresh=function(){DataikuAPI.admin.scheduledTasks.getStatus().success(function(data){$scope.status=data}).error(setErrorInScope.bind($scope))};$scope.fireTask=function(task){DataikuAPI.admin.scheduledTasks.fire(task.jobGroup,task.jobName).success(function(data){ActivityIndicator.success("Task fired");$scope.refresh()}).error(setErrorInScope.bind($scope))};$scope.refresh()});app.controller("AdminMaintenanceInfoController",function($scope,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");DataikuAPI.admin.getInstanceInfo().success(function(data){$scope.data=data})});app.controller("AdminProfilingController",function($scope,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.uiState={};$scope.loadProfilesList=function(){$scope.uiState.loadingProfilesList=true;DataikuAPI.admin.profiling.listProfiles().success(function(data){$scope.uiState.loadingProfilesList=false;$scope.profiles=data})};$scope.downloadProfile=function(profile){downloadURL(DataikuAPI.admin.profiling.downloadProfile(profile.id))};$scope.deleteProfile=function(profile){DataikuAPI.admin.profiling.deleteProfile(profile.id).success(function(){$scope.loadProfilesList()})};$scope.refreshProfilerSettings=function(){DataikuAPI.admin.profiling.getConfig().success(function(profilerSettings){$scope.profilerSettings=profilerSettings;$scope.originalProfilerSettings=angular.copy(profilerSettings)}).error(setErrorInScope.bind($scope))};$scope.saveProfilerSettings=function(){return DataikuAPI.admin.profiling.saveConfig($scope.profilerSettings).success(function(){$scope.refreshProfilerSettings();$scope.loadProfilesList()})};$scope.isDirty=function(){return $scope.originalProfilerSettings&&$scope.profilerSettings&&!angular.equals($scope.originalProfilerSettings,$scope.profilerSettings)};$scope.loadProfilesList();$scope.refreshProfilerSettings()});app.controller("AdminLogsController",function($scope,$state,$rootScope,$window,$timeout,Logs,Diagnostics,DataikuAPI,ActivityIndicator,TopNav,TAIL_STATUS){TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.showIntercomForCloud=()=>{$rootScope.forceShowIntercom()};var saveData=function(){var a=document.createElement("a");a.style.display="none";document.body.appendChild(a);return function(data,fileName){var blob=new Blob([data],{type:"octet/stream"}),url=window.URL.createObjectURL(blob);a.href=url;a.download=fileName;a.click();setTimeout(function(){window.URL.revokeObjectURL(url)},1e3)}}();$scope.uiState={active:"logs",dState:null};$scope.TAIL_STATUS=TAIL_STATUS;$scope.loadLogsList=function(){$scope.uiState.loadingLogsList=true;Logs.list().success(function(data){$scope.uiState.loadingLogsList=false;$scope.logs=data})};$scope.loadLog=function(log){$scope.uiState.currentLog=log;$scope.uiState.loadingLog=log;Logs.cat(log.name).success(function(data){$scope.uiState.loadingLog=null;$scope.logData=data;$scope.logDataHTML=smartLogTailToHTML(data.tail,false);$timeout(function(){var content=$(".log-container .scrollable")[0];content.scrollTop=content.scrollHeight})})};$scope.reloadLog=function(){if($scope.uiState.currentLog){$scope.loadLog($scope.uiState.currentLog)}};$scope.downloadExtract=function(){var text=$scope.logData.tail.lines.join("\n");var filename="extractof_"+$scope.uiState.currentLog.name;saveData(text,filename)};$scope.downloadCurrentLogFile=function(){if($scope.uiState.currentLog){Logs.download($scope.uiState.currentLog.name)}};$scope.downloadBackendLog=function(){Logs.download("backend.log")};$scope.downloadAllLogFiles=function(){Logs.downloadAll()};$scope.loadLogsList()});app.controller("AdminDiagnosticsController",function($scope,$state,$rootScope,$window,$timeout,Logs,Diagnostics,DataikuAPI,ActivityIndicator,TopNav,TAIL_STATUS,FutureProgressModal){$scope.now=(new Date).getTime();$scope.options={includeConfigDir:true,includeBackendStacks:true,includeDockerImagesListing:true,includeFullLogs:false,includeFullDataDirListing:true};$scope.getLatestDiagnosis=function(){Diagnostics.getLatest(function(data){if(data.exists){$scope.latestDiagnosis=data}})};$scope.downloadLatestDiagnosis=function(){Diagnostics.downLoadLatest()};$scope.runDiagnosis=function(){DataikuAPI.admin.diagnostics.run($scope.options).success(function(data){FutureProgressModal.show($scope,data,"Running diagnosis...",null,"static",false,true).then(function(result){if(result){$scope.downloadLatestDiagnosis()}$scope.getLatestDiagnosis()})}).error(setErrorInScope.bind($scope))};$scope.getLatestDiagnosis()});app.controller("AdminSanityCheckController",function($scope,$sce,DataikuAPI,TopNav,FutureProgressModal,WT1){TopNav.setLocation(TopNav.DSS_HOME,"administration");const getLevel=function(message){if(message.isFatal)return 0;if(message.severity==="ERROR")return 1;if(message.severity==="WARNING")return 2;if(message.severity==="INFO")return 3;return 4};const sortMessages=function(a,b){return getLevel(a)!==getLevel(b)?getLevel(a)-getLevel(b):a.title.localeCompare(b.title)};const sortCodes=function(a,b){return a.label.localeCompare(b.label)};$scope.now=(new Date).getTime();$scope.uiState={exclusions:[]};DataikuAPI.admin.sanityCheck.getRunningJob().success(function(data){FutureProgressModal.showPeekOnlyIfRunning($scope,data.jobId,"Running sanity check...").then(function(result){DataikuAPI.admin.sanityCheck.getLatestRun().success(function(result){result.analysisResult.messages.sort(sortMessages);$scope.latestSanityCheck=result}).error(setErrorInScope.bind($scope))})}).error(setErrorInScope.bind($scope));$scope.getCodes=function(customOptionsCallback){Promise.all([DataikuAPI.admin.sanityCheck.getCodes(),DataikuAPI.admin.sanityCheck.getExclusions()]).then(([{data:codes},{data:exclusions}])=>{codes.filter(code=>exclusions.includes(code.value)).forEach(code=>code.selected=true);codes.sort(sortCodes);customOptionsCallback(codes)}).catch(setErrorInScope.bind($scope))};$scope.runSanityCheck=function(){WT1.event("instance-sanity-check-run",{exclusions:$scope.uiState.exclusions});DataikuAPI.admin.sanityCheck.run($scope.uiState.exclusions).success(function(data){FutureProgressModal.show($scope,data,"Running sanity check...",null,"static",false,true).then(function(result){result.messages.sort(sortMessages);$scope.latestSanityCheck={analysisResult:result,epochTimestamp:(new Date).getTime()}})}).error(setErrorInScope.bind($scope))};$scope.resultContainsMessages=function(){return _.get($scope,"latestSanityCheck.analysisResult.messages",[]).length>0};$scope.hasResults=function(){return _.get($scope,"latestSanityCheck.epochTimestamp",0)!==0};$scope.downloadLatestAnalysis=function(){let data={};angular.copy($scope.latestSanityCheck,data);delete data.analysisResult["futureLog"];const file=new Blob([JSON.stringify(data)],{type:"application/json"});let a=document.createElement("a");a.href=URL.createObjectURL(file);a.download="sanity_check.json";a.click()}})})();(function(){"use strict";const app=angular.module("dataiku.admin.codeenvs.common",["dataiku.logs"]);app.directive("codeEnvSecurityPermissions",function(DataikuAPI,$rootScope,PermissionsService){return{restrict:"A",templateUrl:"/templates/admin/code-envs/common/security-permissions.html",replace:true,scope:{codeEnv:"="},link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;$scope.ui={};function makeNewPerm(){$scope.newPerm={update:true,delete:true,use:true}}makeNewPerm();const fixupPermissions=function(){if(!$scope.codeEnv)return;$scope.codeEnv.permissions.forEach(function(p){p.$updateDisabled=false;p.$manageUsersDisabled=false;p.$useDisabled=false;if($scope.codeEnv.usableByAll){p.$useDisabled=true}if(p.update){p.$useDisabled=true}if(p.manageUsers){p.$useDisabled=true;p.$updateDisabled=true}})};DataikuAPI.security.listGroups(false).success(function(allGroups){if(allGroups){allGroups.sort()}$scope.allGroups=allGroups;DataikuAPI.security.listUsers().success(function(data){$scope.allUsers=data.sort((a,b)=>a.displayName.localeCompare(b.displayName));$scope.allUsersLogin=data.map(user=>"@"+user.login)}).error(setErrorInScope.bind($scope));$scope.unassignedGroups=PermissionsService.buildUnassignedGroups($scope.codeEnv,$scope.allGroups)}).error(setErrorInScope.bind($scope));$scope.$watch("codeEnv.owner",function(){$scope.ui.ownerLogin=$scope.codeEnv.owner});$scope.addPermission=function(){$scope.codeEnv.permissions.push($scope.newPerm);makeNewPerm()};$scope.$watch("codeEnv.usableByAll",function(nv,ov){fixupPermissions()});$scope.$watch("codeEnv.permissions",function(nv,ov){if(!nv)return;$scope.unassignedGroups=PermissionsService.buildUnassignedGroups($scope.codeEnv,$scope.allGroups);fixupPermissions()},true);$scope.$watch("codeEnv.permissions",function(nv,ov){if(!nv)return;$scope.unassignedGroups=PermissionsService.buildUnassignedGroups($scope.codeEnv,$scope.allGroups);fixupPermissions()},false);$scope.unassignedGroups=PermissionsService.buildUnassignedGroups($scope.codeEnv,$scope.allGroups);fixupPermissions();$scope.$watch("ui.ownerLogin",function(){PermissionsService.transferOwnership($scope,($scope.codeEnv||{}).desc,"code env")})}}});app.directive("codeEnvContainers",function(DataikuAPI,$rootScope){return{restrict:"A",templateUrl:"/templates/admin/code-envs/common/code-env-containers.html",replace:true,scope:{codeEnv:"=",envLang:"=",deploymentMode:"="},controller:function($scope){$scope.appConfig=$rootScope.appConfig;$scope.addLicInfo=$rootScope.addLicInfo;DataikuAPI.codeenvs.getUserAccessibleCodeEnvSettings().then(({data})=>{$scope.enableCodeEnvResources=data.enableCodeEnvResources});let _mode="NONE";if($scope.codeEnv.allContainerConfs){_mode="ALL"}else if(!$scope.codeEnv.allContainerConfs&&$scope.codeEnv.containerConfs.length!==0){_mode="ALLOWED"}let _sparkMode="NONE";if($scope.codeEnv.allSparkKubernetesConfs){_sparkMode="ALL"}else if(!$scope.codeEnv.allSparkKubernetesConfs&&$scope.codeEnv.sparkKubernetesConfs.length!==0){_sparkMode="ALLOWED"}let _codeStudioMode=$scope.codeEnv.rebuildDependentCodeStudioTemplates;$scope.containerSelection=function(newMode){if(!arguments.length){return _mode}_mode=newMode;switch(newMode){case"NONE":$scope.codeEnv.allContainerConfs=false;$scope.codeEnv.containerConfs=[];break;case"ALLOWED":$scope.codeEnv.allContainerConfs=false;break;case"ALL":$scope.codeEnv.allContainerConfs=true;break}};$scope.sparkKubernetesSelection=function(newMode){if(!arguments.length){return _sparkMode}_sparkMode=newMode;switch(newMode){case"NONE":$scope.codeEnv.allSparkKubernetesConfs=false;$scope.codeEnv.sparkKubernetesConfs=[];break;case"ALLOWED":$scope.codeEnv.allSparkKubernetesConfs=false;break;case"ALL":$scope.codeEnv.allSparkKubernetesConfs=true;break}};$scope.codeStudioRebuildTemplateSelection=function(newMode){if(!arguments.length){return _codeStudioMode}_codeStudioMode=newMode;$scope.codeEnv.rebuildDependentCodeStudioTemplates=_codeStudioMode};$scope.removeOutdatedContainerConfs=function(){$scope.codeEnv.containerConfs=$scope.codeEnv.containerConfs.filter(o=>$scope.outdatedContainerConfs.indexOf(o)===-1)};$scope.removeOutdatedSparkKubernetesConfs=function(){$scope.codeEnv.sparkKubernetesConfs=$scope.codeEnv.sparkKubernetesConfs.filter(o=>$scope.outdatedSparkKubernetesConfs.indexOf(o)===-1)};$scope.containsMismatchedPythonHooks=function(){if($scope.codeEnv&&$scope.codeEnv.desc&&$scope.codeEnv.desc.predefinedContainerHooks&&$scope.codeEnv.desc.pythonInterpreter){return $scope.codeEnv.desc.predefinedContainerHooks.some(hook=>hook.type&&hook.type!==$scope.codeEnv.desc.pythonInterpreter+"_SUPPORT"&&/^PYTHON\d{2,3}_SUPPORT$/.test(hook.type))}return false};DataikuAPI.containers.listNames(null,"USER_CODE").success(data=>{$scope.containerNames=data;$scope.outdatedContainerConfs=$scope.codeEnv.containerConfs.filter(o=>$scope.containerNames.indexOf(o)===-1);$scope.$watch("containerNames && codeEnv.containerConfs",function(nv,ov){$scope.outdatedContainerConfs=$scope.codeEnv.containerConfs.filter(o=>$scope.containerNames.indexOf(o)===-1)})}).error(setErrorInScope.bind($scope));DataikuAPI.containers.listSparkNames().success(data=>{$scope.sparkKubernetesNames=data;$scope.outdatedSparkKubernetesConfs=$scope.codeEnv.sparkKubernetesConfs.filter(o=>$scope.sparkKubernetesNames.indexOf(o)===-1);$scope.$watch("sparkKubernetesNames && codeEnv.sparkKubernetesConfs",function(nv,ov){$scope.outdatedSparkKubernetesConfs=$scope.codeEnv.sparkKubernetesConfs.filter(o=>$scope.sparkKubernetesNames.indexOf(o)===-1)})}).error(setErrorInScope.bind($scope));$scope.cacheLocations=[["BEGINNING","Beginning"],["AFTER_START_DOCKERFILE","After initial hooks"],["AFTER_PACKAGES","After installation of packages"],["AFTER_AFTER_PACKAGES_DOCKERFILE","After post-installation hooks"],["END","At end"],["NONE","None"]];$scope.runtimeAdditionTypes=[["SYSTEM_LEVEL_CUDA_122_CUDNN_897","GPU support for Visual Machine Learning"],["CUDA_SUPPORT_FOR_TORCH2_WITH_PYPI_NVIDIA_PACKAGES","GPU support for Torch 2"],["BASIC_GPU_ENABLING","GPU support for Torch 1 (with +cuXXX variant)"],["PYTHON36_SUPPORT","Install Python 3.6"],["PYTHON37_SUPPORT","Install Python 3.7"],["PYTHON38_SUPPORT","Install Python 3.8"],["AGENT_TOOL_MCP_SERVERS_SUPPORT","Agent tool MCP servers support"],["SYSTEM_LEVEL_CUDA_112_CUDNN_811","[Deprecated] GPU support with CUDA 11.2"]];$scope.runtimeAdditionTypesDescriptions=["Visual Machine Learning, Visual Deep Learning and Visual Time Series Forecasting","Prompt studios, LLM recipes & Knowledge banks (for local Hugging Face models)","Object detection, image classification","Add support for Python 3.6","Add support for Python 3.7","Add support for Python 3.8","Add commands used by MCP servers (uvx, npx)",""]}}});app.directive("codeEnvResources",["DataikuAPI","Dialogs","CreateModalFromTemplate",function(DataikuAPI,Dialogs,CreateModalFromTemplate){return{restrict:"A",templateUrl:"/templates/admin/code-envs/common/code-env-resources.html",replace:true,scope:{codeEnv:"=",envName:"=",editorOptions:"=",nodeType:"@",canUpdateCodeEnv:"=",deploymentMode:"="},controller:function($scope,$rootScope,$q,PathUtils){$scope.showResourcesSize=false;$scope.resourcesCanSelectFn=()=>true;$scope.resourcesBrowserPath="/";$scope.registerExecuteResourcesBrowseFn=function(fnToRegister){$scope.executeResourcesBrowse=fnToRegister};$scope.getResourcesEnvVars=function(){switch($scope.nodeType){case"DESIGN":DataikuAPI.admin.codeenvs.design.getResourcesEnvVars("PYTHON",$scope.envName).then(response=>{$scope.resourcesEnvironmentVariables=response.data.variables});break;case"AUTOMATION":DataikuAPI.admin.codeenvs.automation.getResourcesEnvVars("PYTHON",$scope.envName,$scope.codeEnv.versionId).then(response=>{$scope.resourcesEnvironmentVariables=response.data.variables});break}};$scope.$on("refreshCodeEnvResources",function(event,opt){if(opt.envName===$scope.envName&&(!opt.versionId||opt.versionId===$scope.codeEnv.versionId)){$scope.getResourcesEnvVars();$scope.executeResourcesBrowse($scope.resourcesBrowserPath)}});$scope.resourcesBrowseFn=function(relativePath){switch($scope.nodeType){case"DESIGN":return DataikuAPI.admin.codeenvs.design.browseResources("PYTHON",$scope.envName,relativePath,$scope.showResourcesSize);case"AUTOMATION":return DataikuAPI.admin.codeenvs.automation.browseResources("PYTHON",$scope.envName,$scope.codeEnv.versionId,relativePath,$scope.showResourcesSize)}};$scope.computeSize=function(){switch($scope.nodeType){case"DESIGN":DataikuAPI.admin.codeenvs.design.browseResources("PYTHON",$scope.envName,"/",true).then(response=>{$scope.resourcesSize=response.data.size;$scope.showResourcesSize=true;$scope.executeResourcesBrowse($scope.resourcesBrowserPath)});break;case"AUTOMATION":DataikuAPI.admin.codeenvs.automation.browseResources("PYTHON",$scope.envName,$scope.codeEnv.versionId,"/",true).then(response=>{$scope.resourcesSize=response.data.size;$scope.showResourcesSize=true;$scope.executeResourcesBrowse($scope.resourcesBrowserPath)});break}};$scope.clearResources=function(){Dialogs.confirm($scope,"Clear resources","Are you sure you want to clear the resources?").then(function(){switch($scope.nodeType){case"DESIGN":DataikuAPI.admin.codeenvs.design.clearResources("PYTHON",$scope.envName).then(()=>{$scope.showResourcesSize=false;$scope.executeResourcesBrowse("/")});break;case"AUTOMATION":DataikuAPI.admin.codeenvs.automation.clearResources("PYTHON",$scope.envName,$scope.codeEnv.versionId).then(()=>{$scope.showResourcesSize=false;$scope.executeResourcesBrowse("/")});break}})};$scope.openUploadResourcesModal=function(){CreateModalFromTemplate("/templates/admin/code-envs/common/upload-resources-modal.html",$scope,"AdminCodeEnvsUploadResourcesController")};$scope.canBeUpdated=function(){return $scope.canUpdateCodeEnv&&($scope.deploymentMode==="DSS_INTERNAL"&&$rootScope.appConfig.admin||["DESIGN_MANAGED","PLUGIN_MANAGED","AUTOMATION_SINGLE","AUTOMATION_VERSIONED"].includes($scope.deploymentMode))};$scope.openRenameResourceModal=resource=>{return Dialogs.prompt($scope,"Rename "+resource.name,"New name",resource.name,{pattern:/^(?!\.{1,2}$)[^<>"/\\|?*\x00-\x1F]+$/}).then(function(newName){return DataikuAPI.admin.codeenvs[$scope.nodeType.toLowerCase()].renameResource("PYTHON",$scope.envName,resource.fullPath,newName,$scope.codeEnv.versionId).then(function({data}){return data}).catch(setErrorInScope.bind($scope))})};$scope.openMoveResourceModal=resource=>{const deferred=$q.defer();CreateModalFromTemplate("/templates/admin/code-envs/common/code-env-move-resource-modal.html",$scope,undefined,function(newScope){newScope.resourceToMove=resource;newScope.sourceParent=$scope.resourcesBrowserPath;newScope.destParent=$scope.resourcesBrowserPath;newScope.canBrowse=currentResource=>{return currentResource.directory&&currentResource.fullPath!==resource.fullPath};newScope.canSelect=()=>false;newScope.cancel=()=>{deferred.resolve();newScope.dismiss()};newScope.isSamePath=()=>{return newScope.destParent===newScope.sourceParent};newScope.confirmMove=()=>{const destination=PathUtils.absPathFromUserPath(newScope.destParent,newScope.sourceParent);const sourcePath=resource.fullPath;const destPath=PathUtils.concatLNT(destination,resource.name);DataikuAPI.admin.codeenvs[$scope.nodeType.toLowerCase()].moveResource("PYTHON",$scope.envName,sourcePath,destPath,$scope.codeEnv.versionId).then(function({data}){newScope.dismiss();deferred.resolve(data);newScope.dismiss()}).catch(function(data){setErrorInScope.bind($scope)(data)})}});return deferred.promise};$scope.openDeleteResourceModal=resource=>{return Dialogs.confirm($scope,`File deletion (${resource.name})`,`Are you sure you want to delete this ${resource.directory?"folder and all its contents":"file"}?`).then(function(){return DataikuAPI.admin.codeenvs[$scope.nodeType.toLowerCase()].deleteResource("PYTHON",$scope.envName,resource.fullPath,$scope.codeEnv.versionId).then(function({data}){return data}).catch(setErrorInScope.bind($scope))})};DataikuAPI.codeenvs.getUserAccessibleCodeEnvSettings().then(({data})=>{$scope.enableCodeEnvResources=data.enableCodeEnvResources});$scope.getResourcesEnvVars()}}}]);app.controller("AdminCodeEnvsUploadResourcesController",["$scope","Assert","DataikuAPI",function($scope,Assert,DataikuAPI){$scope.resourcesToUpload=false;$scope.overwrite=false;$scope.upload=function(){Assert.trueish($scope.resourcesToUpload,"No resource to upload");const parentScope=$scope.$parent.$parent;switch(parentScope.nodeType){case"DESIGN":DataikuAPI.admin.codeenvs.design.uploadResources("PYTHON",parentScope.envName,parentScope.resourcesBrowserPath,$scope.resourcesToUpload,$scope.overwrite).then(()=>{$scope.dismiss()}).catch(setErrorInScope2.bind($scope)).finally(()=>{parentScope.executeResourcesBrowse(parentScope.resourcesBrowserPath)});break;case"AUTOMATION":DataikuAPI.admin.codeenvs.automation.uploadResources("PYTHON",parentScope.envName,parentScope.codeEnv.versionId,parentScope.resourcesBrowserPath,$scope.resourcesToUpload,$scope.overwrite).then(()=>{$scope.dismiss()}).catch(setErrorInScope2.bind($scope)).finally(()=>{parentScope.executeResourcesBrowse(parentScope.resourcesBrowserPath)});break}}}]);app.component("dssInternalCodeEnv",{templateUrl:"/templates/admin/code-envs/common/dss-internal-code-env.html",bindings:{internalCodeEnvType:"@",codeEnvDescription:"@"},controller:function($scope,DataikuAPI,FutureProgressModal,Dialogs,$state,$filter,$rootScope,CodeEnvService){const $ctrl=this;$ctrl.appConfig=$rootScope.appConfig;$ctrl.mayCreateCodeEnvs=$rootScope.mayCreateCodeEnvs;$ctrl.supportedPythonInterpreters=[];$ctrl.codeEnvConfig={pythonInterpreter:null};$ctrl.$onInit=()=>{$ctrl.checkAndShowCodeEnv();$ctrl.fetchSupportedPythonInterpreters();$ctrl.fetchDefaultAvailableInterpreter()};$ctrl.fetchSupportedPythonInterpreters=function(){const enrichInterpretersDescription=pythonInterpreters=>DataikuAPI.codeenvs.getSupportedInterpreters($ctrl.internalCodeEnvType).then(function({data}){$ctrl.supportedPythonInterpreters=pythonInterpreters.filter(interpreter=>data.includes(interpreter[0]))}).catch(setErrorInScope.bind($scope));CodeEnvService.getPythonInterpreters().then(enrichInterpretersDescription)};$ctrl.fetchDefaultAvailableInterpreter=function(){DataikuAPI.codeenvs.getDSSInternalDefaultAvailableInterpreter($ctrl.internalCodeEnvType).then(function({data}){$ctrl.codeEnvConfig.pythonInterpreter=data}).catch(setErrorInScope.bind($scope))};$ctrl.checkAndShowCodeEnv=function(){DataikuAPI.codeenvs.checkDSSInternalCodeEnv($ctrl.internalCodeEnvType).then(function({data}){$ctrl.codeEnvExists=Object.keys(data).length>0;if($ctrl.codeEnvExists){$ctrl.codeEnv=data.value;if($ctrl.appConfig.isAutomation){$ctrl.codeEnvHref=$state.href("admin.codeenvs-automation.python-edit",{envName:$ctrl.codeEnv.envName})}else{$ctrl.codeEnvHref=$state.href("admin.codeenvs-design.python-edit",{envName:$ctrl.codeEnv.envName})}if($ctrl.internalCodeEnvType==="PII_DETECTION_CODE_ENV"){DataikuAPI.codeenvs.checkInternalCodeEnvUsedForPII().then(function({data}){$ctrl.showDefaultCodeEnvIsNotUsedWarning=!data}).catch(setErrorInScope.bind($scope))}if($ctrl.internalCodeEnvType==="RAG_CODE_ENV"){DataikuAPI.codeenvs.checkInternalCodeEnvUsedForRAG().then(function({data}){$ctrl.showDefaultCodeEnvIsNotUsedWarning=!data}).catch(setErrorInScope.bind($scope))}if($ctrl.internalCodeEnvType==="DOCUMENT_EXTRACTION_CODE_ENV"){DataikuAPI.codeenvs.checkInternalCodeEnvUsedForDocumentExtraction().then(function({data}){$ctrl.showDefaultCodeEnvIsNotUsedWarning=!data}).catch(setErrorInScope.bind($scope))}if($ctrl.internalCodeEnvType==="HUGGINGFACE_LOCAL_CODE_ENV"){DataikuAPI.codeenvs.checkInternalCodeEnvUsedForHF().then(function({data}){$ctrl.hfLocalConnectionsWithWrongCodeEnv=data.map(name=>({name:name,href:$state.href("admin.connections.edit",{connectionName:name})}))}).catch(setErrorInScope.bind($scope))}$ctrl.outdated=$ctrl.codeEnv.outdatedItems.length>0;$ctrl.showOutdatedRequirementsWarning=$ctrl.codeEnv.outdatedItems.includes("REQUIREMENTS");$ctrl.showOutdatedContainerImagesWarning=$ctrl.codeEnv.outdatedItems.includes("CONTAINER_IMAGES")}}).catch(setErrorInScope.bind($scope))};$ctrl.createCodeEnv=function(){DataikuAPI.codeenvs.createForDSSInternal($ctrl.internalCodeEnvType,$ctrl.codeEnvConfig.pythonInterpreter).then(function(resp){FutureProgressModal.show($scope,resp.data,$filter("capitalize")($ctrl.codeEnvDescription+" code environment"),undefined,"static",false).then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Creation result",result.messages,result.futureLog,undefined,"static",false)}$ctrl.checkAndShowCodeEnv()})}).catch(setErrorInScope.bind($scope))};$ctrl.updateCodeEnv=function(){DataikuAPI.codeenvs.updateForDSSInternal($ctrl.internalCodeEnvType).then(function(resp){FutureProgressModal.show($scope,resp.data,$filter("capitalize")($ctrl.codeEnvDescription+" code environment"),undefined,"static",false).then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result.messages,result.futureLog,undefined,"static",false)}$ctrl.checkAndShowCodeEnv()})}).catch(setErrorInScope.bind($scope))}}});app.component("codeEnvUsage",{templateUrl:"/templates/admin/code-envs/common/code-env-usage.html",bindings:{envLang:"@",envName:"@"},controller:function($scope,DataikuAPI,StateUtils,FullModelLikeIdUtils,Logger,$filter){const $ctrl=this;const getUsageLink={PROJECT:(_objectId,projectKey)=>StateUtils.href.project(projectKey,{page:"settings",selectedTab:"code-envs"}),RECIPE:StateUtils.href.recipe,NOTEBOOK:StateUtils.href.jupyterNotebook,PLUGIN:StateUtils.href.plugin,SCENARIO:(objectId,projectKey)=>StateUtils.href.scenario(objectId,projectKey,{tab:"settings"}),SCENARIO_STEP:(objectId,projectKey)=>StateUtils.href.scenario(objectId,projectKey,{tab:"steps"}),SCENARIO_TRIGGER:(objectId,projectKey)=>StateUtils.href.scenario(objectId,projectKey,{tab:"settings"}),DATASET_METRIC:(objectId,projectKey)=>StateUtils.href.dataset(objectId,projectKey,{tab:"settings"}),DATASET_CHECK:(objectId,projectKey)=>StateUtils.href.dataset(objectId,projectKey,{tab:"settings"}),DATASET:(objectId,projectKey)=>StateUtils.href.dataset(objectId,projectKey,{tab:"settings"}),WEBAPP:(objectId,projectKey)=>StateUtils.href.webapp(objectId,projectKey,{tab:"edit"}),REPORT:(objectId,projectKey)=>StateUtils.href.report(objectId,projectKey,{tab:"edit"}),RETRIEVABLE_KNOWLEDGE:(objectId,projectKey)=>StateUtils.href.retrievableKnowledge(objectId,projectKey,{tab:"settings"}),API_SERVICE_ENDPOINT:StateUtils.href.lambdaService,AGENT_TOOL:(objectId,projectKey)=>StateUtils.href.agentTool(objectId,projectKey,{tab:"design"}),SAVED_MODEL:(objectId,projectKey)=>{try{const obj=FullModelLikeIdUtils.parse(objectId);if(obj.savedModelId){return StateUtils.href.savedModel(obj.savedModelId,projectKey)}}catch(e){}Logger.error("code env usage - unsupported saved model id",objectId,projectKey);return null},MODEL:(objectId,projectKey)=>{try{const obj=FullModelLikeIdUtils.parse(objectId);if(obj.analysisId){return StateUtils.href.analysis(obj.analysisId,projectKey,{tab:"ml.list"})}}catch(e){if(objectId){return StateUtils.href.analysis(objectId,projectKey,{tab:"ml.list"})}}Logger.error("code env usage - unsupported model id",objectId,projectKey);return null},CODE_STUDIO_TEMPLATE:StateUtils.href.codeStudioTemplate};$ctrl.uiState={filters:{query:"",resetable:false,types:[],projects:[]},options:{types:[],projects:[]},filteredUsages:[],filteredProjectsCount:0};$ctrl.filterUsages=()=>{if($ctrl.accessibleUsages){const qry=$ctrl.uiState.filters.query.trim().toLocaleLowerCase();const nbSelectedTypes=$ctrl.uiState.filters.types.length;const nbSelectedProjects=$ctrl.uiState.filters.projects.length;$ctrl.uiState.filteredUsages=$ctrl.accessibleUsages.filter(usage=>!qry||usage.envUsage.toLocaleLowerCase().includes(qry)||usage.projectLabel.toLocaleLowerCase().includes(qry)||usage.objectId&&usage.objectId.toLocaleLowerCase().includes(qry)).filter(usage=>!nbSelectedTypes||$ctrl.uiState.filters.types.indexOf(usage.envUsage)>=0).filter(usage=>!nbSelectedProjects||$ctrl.uiState.filters.projects.indexOf(usage.projectLabel)>=0);$ctrl.uiState.filters.resetable=nbSelectedTypes>0||nbSelectedProjects>0||qry.length;$ctrl.uiState.filteredProjectsCount=$ctrl.uiState.filteredUsages.reduce((projects,usage)=>{projects.add(usage.projectKey);return projects},new Set).size}};$ctrl.resetFilters=function(){$ctrl.uiState.filters.query="";$ctrl.uiState.filters.types=[];$ctrl.uiState.filters.projects=[];$ctrl.filterUsages()};function makeOptions(items,field,idToNameFunc){return items.reduce((dedup,item)=>{const dedupedItem=dedup.find(dedupItem=>dedupItem.id===item[field]);if(dedupedItem){dedupedItem.count++}else{dedup.push({id:item[field],count:1})}return dedup},[]).map(dedup=>{let name;if(idToNameFunc){name=idToNameFunc(dedup.id)}else{name=dedup.id}dedup.label=`${name} (${dedup.count})`;return dedup})}$ctrl.getUsage=function(){DataikuAPI.admin.codeenvs.design.listUsages($ctrl.envLang,$ctrl.envName,false).success(function(usagesList){$ctrl.inaccessibleObjectsCount=usagesList.filter(usage=>!usage.accessible).length;$ctrl.accessibleUsages=usagesList.filter(usage=>usage.accessible).map(usage=>{usage.projectLabel=usage.projectKey==="__DKU_ANY_PROJECT__"?"All":usage.projectKey;usage.href=getUsageLink[usage.envUsage](usage.objectId,usage.projectKey);if(usage.envUsage==="PROJECT"){usage.linkLabel="Go to project settings"}else if(usage.envUsage==="SAVED_MODEL"){usage.linkLabel="Go to Saved models versions"}else if(usage.envUsage==="MODEL"){usage.linkLabel="Go to Analysis page"}else if(usage.href){usage.linkLabel="Go to "+$filter("typeToName")(usage.envUsage)}return usage});$ctrl.uiState.options.types=makeOptions($ctrl.accessibleUsages,"envUsage",$filter("typeToName"));$ctrl.uiState.options.projects=makeOptions($ctrl.accessibleUsages,"projectLabel");$ctrl.filterUsages()}).error(setErrorInScope.bind($scope))}}})})();(function(){"use strict";var app=angular.module("dataiku.admin.codeenvs.design",[]);app.controller("AdminCodeEnvsDesignController",function($scope,$rootScope,TopNav,DataikuAPI,Dialogs,FutureProgressModal,CreateModalFromTemplate,ActivityIndicator,Deprecation,CodeEnvsDesignService){$scope.canCreateCodeEnv=$rootScope.mayCreateCodeEnvs;$scope.openDeleteEnvModal=function(codeEnv){var newScope=$scope.$new();newScope.codeEnv=codeEnv;CreateModalFromTemplate("/templates/admin/code-envs/common/delete-env-modal.html",newScope,"AdminCodeEnvsDesignDeleteController")};$scope.isExportable=function(codeEnv){return codeEnv&&["PLUGIN_MANAGED","PLUGIN_NON_MANAGED","DSS_INTERNAL"].indexOf(codeEnv.deploymentMode)<0};$scope.exportEnv=function(envLang,envName){ActivityIndicator.success("Exporting code env ...");downloadURL(DataikuAPI.admin.codeenvs.design.getExportURL(envLang,envName))};$scope.getEnvDiagnostic=function(envLang,envName){ActivityIndicator.success("Generating code env diagnostic ...");downloadURL(DataikuAPI.admin.codeenvs.design.getDiagnosticURL(envLang,envName))};$scope.isPythonDeprecated=function(pythonInterpreter){return Deprecation.isPythonDeprecated(pythonInterpreter)};$scope.openCRANEditHelp=function(){Dialogs.ackMarkdown($scope,"R packages",CodeEnvsDesignService.CRANEditHelpString)};$scope.openRCondaSpecEditHelp=function(){Dialogs.ackMarkdown($scope,"Conda packages",CodeEnvsDesignService.rCondaSpecEditHelpString)};$scope.openPipRequirementsEditHelp=function(){Dialogs.ackMarkdown($scope,"Pip requirements",CodeEnvsDesignService.pipRequirementsEditHelpString)};$scope.openPyCondaSpecEditHelp=function(){Dialogs.ackMarkdown($scope,"Conda packages",CodeEnvsDesignService.pyCondaSpecEditHelpString)}});app.controller("AdminCodeEnvsDesignListController",function($scope,$controller,CodeEnvsDesignService,TopNav,DataikuAPI,Dialogs,CreateModalFromTemplate,$state,RequestCenterService,CodeEnvService){$controller("AdminCodeEnvsDesignController",{$scope:$scope});TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.refreshList=function(){return DataikuAPI.admin.codeenvs.design.list().success(function(data){for(const codeEnv of data){codeEnv["languageDisplayName"]=codeEnv["pythonInterpreter"]||codeEnv["envLang"]}$scope.codeEnvs=data}).error(setErrorInScope.bind($scope))};CodeEnvsDesignService.getUserAccessibleSettings().then(({data})=>{$scope.enableCodeEnvResources=data.enableCodeEnvResources;$scope.useConda=data.useConda});$scope.refreshList();$scope.canRequestCodeEnvInstall=$scope.appConfig.codeEnvInstallRequestsEnabled;$scope.isAdmin=$scope.appConfig.admin;$scope.openNewPythonEnvModal=function(){CreateModalFromTemplate("/templates/admin/code-envs/design/new-python-env-modal.html",$scope,"AdminCodeEnvsDesignNewPythonController")};$scope.openNewREnvModal=function(){CreateModalFromTemplate("/templates/admin/code-envs/design/new-R-env-modal.html",$scope,"AdminCodeEnvsDesignNewRController")};$scope.openImportEnvModal=function(){CreateModalFromTemplate("/templates/admin/code-envs/design/import-env-modal.html",$scope,"AdminCodeEnvsDesignImportController")};$scope.actionAfterDeletion=function(){$scope.refreshList()};$scope.goToEditIfExists=function(envName){const env=$scope.codeEnvs.find(e=>e.envName===envName);if(env&&env.envLang==="R"){$state.go("admin.codeenvs-design.r-edit",{envName:envName})}else if(env&&env.envLang==="PYTHON"){$state.go("admin.codeenvs-design.python-edit",{envName:envName})}};$scope.openNewEnvRequestModal=function(envLang){if(envLang==="PYTHON"){$scope.requestedEnv=CodeEnvsDesignService.getDefaultPythonEnv()}else if(envLang==="R"){$scope.requestedEnv=CodeEnvsDesignService.getDefaultREnv()}$scope.requestedEnv.conda=$scope.useConda;$scope.refreshList();$scope.isCodeEnvNameUnique=function(value){if($scope.codeEnvs){for(let k in $scope.codeEnvs){if($scope.codeEnvs[k].envName===value){return false}}}return true};$scope.codeEnvModal={$modalTab:"GENERAL"};$scope.nextTab=function(){if($scope.codeEnvModal.$modalTab==="GENERAL"){$scope.codeEnvModal.$modalTab="PACKAGES"}};$scope.openCRANEditHelp=function(){Dialogs.ackMarkdown($scope,"R packages",CodeEnvsDesignService.CRANEditHelpString)};$scope.openRCondaSpecEditHelp=function(){Dialogs.ackMarkdown($scope,"Conda packages",CodeEnvsDesignService.rCondaSpecEditHelpString)};$scope.openPipRequirementsEditHelp=function(){Dialogs.ackMarkdown($scope,"Pip requirements",CodeEnvsDesignService.pipRequirementsEditHelpString)};$scope.openPyCondaSpecEditHelp=function(){Dialogs.ackMarkdown($scope,"Conda packages",CodeEnvsDesignService.pyCondaSpecEditHelpString)};$scope.codeEnvResourcesEditorOptions=$scope.codeMirrorSettingService.get("text/x-python");$scope.specPackageListEditorOptionsPip=$scope.codeMirrorSettingService.get("text/plain",{onLoad:function(cm){$scope.codeMirrorPip=cm}});$scope.specPackageListEditorOptionsConda=$scope.codeMirrorSettingService.get("text/plain",{onLoad:function(cm){$scope.codeMirrorConda=cm}});$scope.updateModalPackages=function(){DataikuAPI.codeenvs.getMandatoryPackages(envLang,$scope.requestedEnv).then(({data})=>{$scope.requestedEnv.mandatoryPackageList=data});if(envLang=="PYTHON"){CodeEnvsDesignService.fetchPackagePresets({desc:$scope.requestedEnv},$scope)}};$scope.requestedEnv.mandatoryPackageList=$scope.updateModalPackages();$scope.requestedEnv.specPackageList="";$scope.requestedEnv.specCondaEnvironment="";$scope.insertAdditionalPackages=editorType=>{const newScope=$scope.$new();newScope.packageListTypes=$scope.packageListTypes;newScope.packageListValues=$scope.packageListValues;newScope.selectedPackages=$scope.packageListTypes[0][0];newScope.codeMirrorPip=$scope.codeMirrorPip;newScope.codeMirrorConda=$scope.codeMirrorConda;const editorSettings=$scope.codeMirrorSettingService.get("text/plain");newScope.insertReadOnlyOptions={...editorSettings,readOnly:true,lineNumbers:false,foldGutter:false};CreateModalFromTemplate("/templates/admin/code-envs/design/add-additional-packages-modal.html",newScope,null,scope=>{scope.insertPackages=()=>{const selectedContent=scope.packageListValues[scope.selectedPackages];CodeEnvsDesignService.replacePackageListEditorContent(selectedContent,editorType,newScope.codeMirrorPip,newScope.codeMirrorConda);scope.dismiss()}})};if(envLang==="PYTHON"){CreateModalFromTemplate("/templates/admin/code-envs/design/new-python-env-request-modal.html",$scope,"AdminCodeEnvsDesignNewPythonController",modalScope=>{modalScope.requestedEnv=$scope.requestedEnv;modalScope.$watch("[requestedEnv.pythonInterpreter, requestedEnv.installCorePackages, requestedEnv.corePackagesSet, requestedEnv.installJupyterSupport]",function(nv,ov){$scope.updateModalPackages()});modalScope.cancelRequest=function(){modalScope.$destroy();modalScope.dismiss()};modalScope.sendRequest=function(){DataikuAPI.requests.createCodeEnvRequest("INSTALL_CODE_ENV",$scope.requestedEnv.envName,envLang,JSON.stringify($scope.requestedEnv),$scope.requestedEnv.specPackageList,$scope.requestedEnv.specCondaEnvironment,$scope.codeEnvModal.message,"MANUAL").success(function(data){RequestCenterService.WT1Events.onRequestSent("CODE_ENV",null,$scope.requestedEnv.envName,$scope.codeEnvModal.message,data.id)}).error(setErrorInScope.bind($scope));modalScope.$destroy();modalScope.dismiss()};modalScope.updateDefaultCorePackageSet=function(){DataikuAPI.codeenvs.getDefaultCorePackageSet($scope.requestedEnv.pythonInterpreter).success(function(data){$scope.requestedEnv.corePackagesSet=data}).error(setErrorInScope.bind($scope))};modalScope.updatePythonInterpreters=function(){if(modalScope.requestedEnv.conda===true){modalScope.requestPythonInterpreters=CodeEnvService.pythonCondaInterpreters}else{modalScope.requestPythonInterpreters=CodeEnvService.pythonInterpreters.filter(i=>i[0]!=="CUSTOM");CodeEnvService.getPythonInterpreters().then(interpreters=>{modalScope.requestPythonInterpreters=interpreters.filter(i=>i[0]!=="CUSTOM")})}};modalScope.updatePythonInterpreters()})}else if(envLang==="R"){CreateModalFromTemplate("/templates/admin/code-envs/design/new-R-env-request-modal.html",$scope,"AdminCodeEnvsDesignNewRController",modalScope=>{modalScope.requestedEnv=$scope.requestedEnv;modalScope.$watch("[requestedEnv.installCorePackages, requestedEnv.corePackagesSet, requestedEnv.installJupyterSupport]",function(nv,ov){$scope.updateModalPackages()});modalScope.cancelRequest=function(){modalScope.$destroy();modalScope.dismiss()};modalScope.sendRequest=function(){DataikuAPI.requests.createCodeEnvRequest("INSTALL_CODE_ENV",$scope.requestedEnv.envName,envLang,JSON.stringify($scope.requestedEnv),$scope.requestedEnv.specPackageList,$scope.requestedEnv.specCondaEnvironment,$scope.codeEnvModal.message,"MANUAL").success(function(data){RequestCenterService.WT1Events.onRequestSent("CODE_ENV",null,$scope.requestedEnv.envName,$scope.codeEnvModal.message,data.id)}).error(setErrorInScope.bind($scope));modalScope.$destroy();modalScope.dismiss()}})}}});app.controller("AdminCodeEnvsDesignDeleteController",function($scope,TopNav,DataikuAPI,Dialogs,FutureProgressModal,$q){$scope.delete=function(){var parentScope=$scope.$parent;DataikuAPI.admin.codeenvs.design.delete($scope.codeEnv.envLang,$scope.codeEnv.envName).success(function(data){$scope.dismiss();FutureProgressModal.show(parentScope,data,"Env deletion").then(function(result){const infoModalClosed=result?Dialogs.infoMessagesDisplayOnly(parentScope,"Deletion result",result.messages,result.futureLog):$q.resolve();infoModalClosed.then(()=>$scope.actionAfterDeletion())})}).error(setErrorInScope.bind($scope))}});app.controller("AdminCodeEnvsDesignChangePythonSuccessfulController",function($scope,$state,CodeEnvService,$stateParams){const parentScope=$scope.$parent.$parent;$scope.goToEnv=function(envName){$state.go("admin.codeenvs-design.python-edit",{envName:envName})};$scope.installPackages=function(envName){CodeEnvService.updateEnv(parentScope,envName,true,false,false,"PYTHON",function(){if($stateParams.envName!=envName){$scope.goToEnv(envName)}else{$scope.uiState.active="actual"}})}});app.controller("AdminCodeEnvsDesignChangePythonController",function($scope,TopNav,DataikuAPI,Dialogs,FutureProgressModal,$q,$state,CreateModalFromTemplate,CodeEnvService,Deprecation){$scope.inplace=true;$scope.supportedDeprecatedPythons=["PYTHON36","PYTHON37","PYTHON38"];$scope.pythonInterpreters=CodeEnvService.pythonInterpreters;CodeEnvService.getPythonInterpreters().then(interpreters=>{$scope.pythonInterpreters=interpreters});$scope.insertReadOnlyOptions={...$scope.codeMirrorSettingService.get("text/plain"),readOnly:true,lineNumbers:true,foldGutter:true};$scope.insertReadWriteOptions={...$scope.codeMirrorSettingService.get("text/plain"),lineNumbers:true,foldGutter:true};const isDeprecatedPythonInHooks=function(hooks,pythonInterpreter){return $scope.supportedDeprecatedPythons.includes(pythonInterpreter)&&hooks.some(hook=>hook.type===pythonInterpreter+"_SUPPORT")};const parentScope=$scope.$parent.$parent;$scope.$watch("newEnv.pythonInterpreter",function(nv){if(!$scope.nameChangedByUser){$scope.newEnv.envName=$scope.oldEnv.envName+"_"+$scope.newEnv.pythonInterpreter.toLowerCase()}$scope.newEnv.pythonInterpreterFriendlyName=CodeEnvService.pythonInterpreterFriendlyName($scope.newEnv.pythonInterpreter);DataikuAPI.admin.codeenvs.design.updatePythonPackagePresets($scope.newEnv.specPackageList,$scope.newEnv.pythonInterpreter).success(function(data){$scope.newEnv.specPackageList=data}).error(setErrorInScope.bind($scope));if(!["PYTHON27","PYTHON35","PYTHON36","PYTHON37","CUSTOM"].includes($scope.newEnv.pythonInterpreter)&&$scope.newEnv.corePackagesSet=="LEGACY_PANDAS023"){$scope.previousCorePackagesSet=$scope.newEnv.corePackagesSet;$scope.newEnv.corePackagesSet="PANDAS13"}else if($scope.newEnv.pythonInterpreter=="PYTHON27"){$scope.previousCorePackagesSet=$scope.newEnv.corePackagesSet;$scope.newEnv.corePackagesSet="LEGACY_PANDAS023"}$scope.oldEnvContainsDeprecatedPythonCRA=function(newPythonInterpreter){if(!$scope.oldEnv||!$scope.oldEnv.desc||!$scope.oldEnv.desc.predefinedContainerHooks||!newPythonInterpreter||!$scope.supportedDeprecatedPythons.includes($scope.oldEnv.desc.pythonInterpreter)){return false}if($scope.supportedDeprecatedPythons.includes(newPythonInterpreter)){return isDeprecatedPythonInHooks($scope.oldEnv.desc.predefinedContainerHooks,$scope.oldEnv.desc.pythonInterpreter)&&!isDeprecatedPythonInHooks($scope.oldEnv.desc.predefinedContainerHooks,newPythonInterpreter)}else if(!$scope.supportedDeprecatedPythons.includes(newPythonInterpreter)){return isDeprecatedPythonInHooks($scope.oldEnv.desc.predefinedContainerHooks,"PYTHON36")||isDeprecatedPythonInHooks($scope.oldEnv.desc.predefinedContainerHooks,"PYTHON37")||isDeprecatedPythonInHooks($scope.oldEnv.desc.predefinedContainerHooks,"PYTHON38")}};$scope.newEnvRequiresDeprecatedPythonCRA=function(newPythonInterpreter){if(!$scope.oldEnv||!$scope.oldEnv.desc||!$scope.oldEnv.desc.predefinedContainerHooks||!newPythonInterpreter){return false}return!$scope.supportedDeprecatedPythons.includes($scope.oldEnv.desc.pythonInterpreter)&&!isDeprecatedPythonInHooks($scope.oldEnv.desc.predefinedContainerHooks,newPythonInterpreter)}});$scope.create=function(){DataikuAPI.admin.codeenvs.design.create("PYTHON",$scope.newEnv).success(function(data){$scope.dismiss();FutureProgressModal.show(parentScope,data,"Env creation",undefined,"static",false).then(function(result){const modalClosed=result?Dialogs.infoMessagesDisplayOnly(parentScope,"Creation result",result.messages,result.futureLog,undefined,"static",false):$q.resolve();modalClosed.then(()=>{DataikuAPI.admin.codeenvs.design.get("PYTHON",$scope.newEnv.envName).success(function(data){let packageList=$scope.newEnv.specPackageList;$scope.newEnv=data;$scope.newEnv.specPackageList=packageList;$scope.newEnv.resourcesInitScript=$scope.oldEnv.resourcesInitScript;DataikuAPI.admin.codeenvs.design.save("PYTHON",$scope.newEnv.envName,$scope.newEnv).success(function(){CreateModalFromTemplate("/templates/admin/code-envs/design/change-python-modal-successful.html",parentScope,"AdminCodeEnvsDesignChangePythonSuccessfulController",function(newScope){newScope.env=$scope.newEnv;newScope.inplace=$scope.inplace;newScope.env.pythonInterpreterFriendlyName=CodeEnvService.pythonInterpreterFriendlyName(newScope.env.desc.pythonInterpreter);newScope.previousCorePackagesSet=$scope.previousCorePackagesSet})}).error(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))})})}).error(setErrorInScope.bind(parentScope))};$scope.update=function(){$scope.dismiss();if($scope.newEnv.removeContainerRuntimeAdditions&&!$scope.supportedDeprecatedPythons.includes($scope.newEnv.pythonInterpreter)){var filteredHooks=$scope.oldEnv.desc.predefinedContainerHooks.filter(hook=>hook.type!=="PYTHON36_SUPPORT"&&hook.type!=="PYTHON37_SUPPORT"&&hook.type!=="PYTHON38_SUPPORT");$scope.oldEnv.desc.predefinedContainerHooks=filteredHooks}else if($scope.newEnv.updateContainerRuntimeAdditions&&$scope.supportedDeprecatedPythons.includes($scope.newEnv.pythonInterpreter)){var updatedHooks=$scope.oldEnv.desc.predefinedContainerHooks.filter(hook=>hook.type!==$scope.oldEnv.desc.pythonInterpreter+"_SUPPORT");updatedHooks.push({type:$scope.newEnv.pythonInterpreter+"_SUPPORT"});$scope.oldEnv.desc.predefinedContainerHooks=updatedHooks}$scope.oldEnv.desc.pythonInterpreter=$scope.newEnv.pythonInterpreter;$scope.oldEnv.desc.customInterpreter=$scope.newEnv.customInterpreter;$scope.oldEnv.desc.corePackagesSet=$scope.newEnv.corePackagesSet;$scope.oldEnv.specPackageList=$scope.newEnv.specPackageList;DataikuAPI.admin.codeenvs.design.save("PYTHON",$scope.oldEnv.envName,$scope.oldEnv).success(function(data){DataikuAPI.admin.codeenvs.design.recreate("PYTHON",$scope.oldEnv.envName).success(function(data){FutureProgressModal.show(parentScope,data,"Change python interpreter",undefined,"static",false).then(function(result){const modalClosed=result?Dialogs.infoMessagesDisplayOnly(parentScope,"Migration result",result.messages,result.futureLog,undefined,"static",false):$q.resolve();if(!result.messages.error){modalClosed.then(()=>{CreateModalFromTemplate("/templates/admin/code-envs/design/change-python-modal-successful.html",parentScope,"AdminCodeEnvsDesignChangePythonSuccessfulController",function(newScope){$scope.oldEnv.desc.corePackagesSet=$scope.newEnv.corePackagesSet;newScope.env=$scope.oldEnv;newScope.inplace=$scope.inplace;newScope.env.pythonInterpreterFriendlyName=CodeEnvService.pythonInterpreterFriendlyName(newScope.env.desc.pythonInterpreter);newScope.previousCorePackagesSet=$scope.previousCorePackagesSet})})}});CodeEnvService.refreshEnv(parentScope)}).error(setErrorInScope.bind($scope))}).error(setErrorInScope.bind(parentScope))}});app.controller("AdminCodeEnvsDesignNewPythonController",function($scope,CodeEnvsDesignService,TopNav,DataikuAPI,Dialogs,FutureProgressModal,$q,Deprecation,CodeEnvService){$scope.newEnv=CodeEnvsDesignService.getDefaultPythonEnvNoCorePackage();$scope.deploymentModes=[["DESIGN_MANAGED","Managed by DSS (recommended)"],["DESIGN_NON_MANAGED","Non-managed path"],["EXTERNAL_CONDA_NAMED","Named external Conda env"]];CodeEnvsDesignService.getUserAccessibleSettings().then(({data})=>{$scope.enableCodeEnvResources=data.enableCodeEnvResources});$scope.$watch("newEnv.conda",function(nv){if(nv===true){$scope.pythonInterpreters=CodeEnvService.pythonCondaInterpreters}else if(nv===false){$scope.pythonInterpreters=CodeEnvService.pythonInterpreters;CodeEnvService.getPythonInterpreters().then(interpreters=>{$scope.pythonInterpreters=interpreters})}});$scope.$watch("newEnv.deploymentMode",$scope.isPythonDeprecated);$scope.create=function(){var parentScope=$scope.$parent.$parent;DataikuAPI.admin.codeenvs.design.create("PYTHON",$scope.newEnv).success(function(data){$scope.dismiss();FutureProgressModal.show(parentScope,data,"Env creation",undefined,"static",false).then(function(result){const modalClosed=result?Dialogs.infoMessagesDisplayOnly(parentScope,"Creation result",result.messages,result.futureLog,undefined,"static",false):$q.resolve();const refreshed=parentScope.refreshList();$q.all([modalClosed,refreshed]).then(()=>{parentScope.goToEditIfExists(result&&result.envName)})})}).error(setErrorInScope.bind($scope))};$scope.isPythonDeprecated=function(){return $scope.newEnv&&$scope.newEnv.deploymentMode==="DESIGN_MANAGED"&&Deprecation.isPythonDeprecated($scope.newEnv.pythonInterpreter)}});app.controller("AdminCodeEnvsDesignNewRController",function($scope,CodeEnvsDesignService,TopNav,DataikuAPI,Dialogs,FutureProgressModal,$q){$scope.newEnv=CodeEnvsDesignService.getDefaultREnv();$scope.deploymentModes=[["DESIGN_MANAGED","Managed by DSS (recommended)"],["DESIGN_NON_MANAGED","Non-managed path"],["EXTERNAL_CONDA_NAMED","Named external Conda env"]];CodeEnvsDesignService.getUserAccessibleSettings().then(({data})=>{$scope.enableCodeEnvResources=data.enableCodeEnvResources});$scope.create=function(){var parentScope=$scope.$parent.$parent;DataikuAPI.admin.codeenvs.design.create("R",$scope.newEnv).success(function(data){$scope.dismiss();FutureProgressModal.show(parentScope,data,"Env creation",undefined,"static",false).then(function(result){const modalClosed=result?Dialogs.infoMessagesDisplayOnly(parentScope,"Creation result",result.messages,result.futureLog,undefined,"static",false):$q.resolve();const refreshed=parentScope.refreshList();$q.all([modalClosed,refreshed]).then(()=>{parentScope.goToEditIfExists(result&&result.envName)})})}).error(setErrorInScope.bind($scope))}});app.controller("AdminCodeEnvsDesignCreateFromDraftController",function($scope,$controller,$state,$stateParams,Assert,TopNav,DataikuAPI,FutureProgressModal,CreateModalFromTemplate,Dialogs,Logs,$q,CodeEnvService){$controller("AdminCodeEnvsDesignListController",{$scope:$scope});$scope.loadDraftCodeEnv=function(){return DataikuAPI.admin.codeenvs.design.getDraft($stateParams.draftId).success(function(data){$scope.draftId=data.config.id;$scope.newEnv=data.env;$scope.newEnv.envName=data.config.envName;$scope.envLang=data.config.envLang;$scope.openDraftModal()}).error(setErrorInScope.bind($scope))};$scope.loadDraftCodeEnv();$scope.isAdmin=$scope.appConfig.admin;$scope.openDraftModal=function(){if($scope.envLang==="PYTHON"){CreateModalFromTemplate("/templates/admin/code-envs/design/new-python-env-from-draft-modal.html",$scope,"AdminCodeEnvsDesignNewPythonController",modalScope=>{modalScope.requestedEnv=$scope.newEnv;if(modalScope.requestedEnv.conda===true){modalScope.draftPythonInterpreters=CodeEnvService.pythonCondaInterpreters}else{modalScope.draftPythonInterpreters=CodeEnvService.pythonInterpreters;CodeEnvService.getPythonInterpreters().then(interpreters=>{modalScope.draftPythonInterpreters=interpreters})}modalScope.createEnvFromDraft=function(){DataikuAPI.admin.codeenvs.design.createFromDraft($scope.draftId,"PYTHON",$scope.newEnv).success(function(data){modalScope.dismiss();handleEnvCreationResult(data)}).error(setErrorInScope.bind($scope))}})}else if($scope.envLang==="R"){CreateModalFromTemplate("/templates/admin/code-envs/design/new-R-env-from-draft-modal.html",$scope,"AdminCodeEnvsDesignNewRController",modalScope=>{modalScope.requestedEnv=$scope.newEnv;modalScope.createEnvFromDraft=function(){DataikuAPI.admin.codeenvs.design.createFromDraft($scope.draftId,"R",$scope.newEnv).success(function(data){modalScope.dismiss();handleEnvCreationResult(data)}).error(setErrorInScope.bind($scope))}})}};function handleEnvCreationResult(data){FutureProgressModal.show($scope,data,"Env creation",undefined,"static",false).then(function(result){const modalClosed=result?Dialogs.infoMessagesDisplayOnly($scope,"Creation result",result.messages,result.futureLog,undefined,"static",false):$q.resolve();const refreshed=$scope.refreshList();$q.all([modalClosed,refreshed]).then(()=>{$scope.goToEditIfExists(result&&result.envName)})})}});app.controller("AdminCodeEnvsDesignImportController",function($scope,$state,$stateParams,Assert,TopNav,DataikuAPI,FutureProgressModal,Dialogs,Logs,$q){$scope.newEnv={};$scope.import=function(){Assert.trueish($scope.newEnv.file,"No code env file");const parentScope=$scope.$parent.$parent;DataikuAPI.admin.codeenvs.design.import($scope.newEnv.file).then(function(data){$scope.dismiss();FutureProgressModal.show(parentScope,JSON.parse(data),"Env import",undefined,"static",false).then(function(result){const modalClosed=result?Dialogs.infoMessagesDisplayOnly(parentScope,"Creation result",result.messages,result.futureLog,undefined,"static",false):$q.resolve();const refreshed=parentScope.refreshList();$q.all([modalClosed,refreshed]).then(()=>{parentScope.goToEditIfExists(result&&result.envName)})})},function(payload){setErrorInScope.bind($scope)(JSON.parse(payload.response),payload.status,function(h){return payload.getResponseHeader(h)})})}});app.controller("_AdminCodeEnvsDesignEditController",function($scope,$controller,$state,$stateParams,TopNav,DataikuAPI,ActivityIndicator,CreateModalFromTemplate,FutureProgressModal,Dialogs,Logs,CodeEnvService){$controller("AdminCodeEnvsDesignController",{$scope:$scope});TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.envName=$stateParams.envName;$scope.uiState={performChangesOnSave:true,upgradeAllPackages:true,updateResources:true,forceRebuildEnv:false,active:"info"};$scope.getSingleVersion=function(codeEnv){return null};$scope.actionAfterDeletion=function(){$state.go("admin.codeenvs-design.list")};$scope.canBeUpdated=function(){return $scope.codeEnv&&$scope.codeEnv.canUpdateCodeEnv&&["DESIGN_MANAGED","PLUGIN_MANAGED","AUTOMATION_SINGLE","AUTOMATION_VERSIONED","DSS_INTERNAL"].indexOf($scope.codeEnv.deploymentMode)>=0};$scope.getPackagesThatWereRequiredAndInstalledButAreNotRequiredAnymore=function(packageSystem){if(!$scope.codeEnv||!$scope.previousPackagesSetForRemovalWarning[packageSystem])return[];const newSet=CodeEnvService.getPackagesThatAreRequired($scope.codeEnv,packageSystem);return[...CodeEnvService.difference($scope.previousPackagesSetForRemovalWarning[packageSystem],newSet)]};$scope.isPackageRequired=function(packageSystem,packageName){let required="";if(packageSystem=="pip"){required=$scope.codeEnv.specPackageList}else if(packageSystem=="conda"){required=$scope.codeEnv.specCondaEnvironment}return CodeEnvService.getPackageNames(required).has(packageName)};$scope.isPackageInstalled=function(packageSystem,packageName){let installed="";if(packageSystem=="pip"){installed=$scope.codeEnv.actualPackageList}else if(packageSystem=="conda"){installed=$scope.codeEnv.actualCondaEnvironment}return CodeEnvService.getPackageNames(installed).has(packageName)};$scope.isInternalCodeEnv=function(){return $scope.codeEnv&&$scope.codeEnv.deploymentMode==="DSS_INTERNAL"};$scope.hasOptedOutOfReferenceSpec=function(){return $scope.isInternalCodeEnv()&&$scope.codeEnv.desc&&$scope.codeEnv.desc.useReferenceSpec===false};$scope.useReferenceSpec=function(){return $scope.isInternalCodeEnv()&&$scope.codeEnv.desc&&$scope.codeEnv.desc.useReferenceSpec===true};$scope.specIsDirty=function(){if(!$scope.codeEnv)return false;var currentSpec=CodeEnvService.makeCurrentSpec($scope.codeEnv);return!angular.equals(currentSpec,$scope.previousSpec)};checkChangesBeforeLeaving($scope,$scope.specIsDirty);$scope.previousSpec={};$scope.previousPackagesSetForRemovalWarning={pip:new Set,conda:new Set};$scope.refreshMandatoryPackageList=function(){if(!$scope.codeEnv)return;if(!$scope.codeEnv.desc.installCorePackages&&!$scope.codeEnv.desc.installJupyterSupport){$scope.codeEnv.mandatoryPackageList="";$scope.codeEnv.mandatoryCondaEnvironment="";return}DataikuAPI.codeenvs.getMandatoryPackages($scope.envLang,$scope.codeEnv.desc).then(({data})=>{if($scope.codeEnv.conda){$scope.codeEnv.mandatoryCondaEnvironment=data}else{$scope.codeEnv.mandatoryPackageList=data}})};CodeEnvService.refreshEnv($scope).then(()=>$scope.uiState.forceRebuildEnv=$scope.isInternalCodeEnv());$scope.updateEnv=function(){CodeEnvService.updateEnv($scope,$stateParams.envName,$scope.uiState.upgradeAllPackages,$scope.uiState.updateResources,$scope.uiState.forceRebuildEnv,$scope.envLang,null)};$scope.saveAndMaybePerformChanges=function(performChangesOnSave){DataikuAPI.admin.codeenvs.design.save($scope.envLang,$stateParams.envName,$scope.codeEnv).success(function(data){CodeEnvService.refreshEnv($scope);if(performChangesOnSave){$scope.updateEnv()}}).error(setErrorInScope.bind($scope))};$scope.fetchNonManagedEnvDetails=function(){DataikuAPI.admin.codeenvs.design.fetchNonManagedEnvDetails($scope.envLang,$stateParams.envName).success(function(data){$scope.nonManagedEnvDetails=data}).error(setErrorInScope.bind($scope))};$scope.installJupyterSupport=function(){DataikuAPI.admin.codeenvs.design.installJupyterSupport($scope.envLang,$stateParams.envName).success(function(data){FutureProgressModal.show($scope,data,"Env update").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result.messages,result.futureLog)}CodeEnvService.refreshEnv($scope)})}).error(setErrorInScope.bind($scope))};$scope.removeJupyterSupport=function(){DataikuAPI.admin.codeenvs.design.removeJupyterSupport($scope.envLang,$stateParams.envName).success(function(data){FutureProgressModal.show($scope,data,"Env update").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result.messages,result.futureLog)}CodeEnvService.refreshEnv($scope)})}).error(setErrorInScope.bind($scope))};$scope.showResourcesTab=function(){return $scope.appConfig.admin&&$scope.isInternalCodeEnv()||!["EXTERNAL_CONDA_NAMED","DSS_INTERNAL"].includes($scope.codeEnv?.deploymentMode)};$scope.specPackageListEditorOptionsPip=$scope.codeMirrorSettingService.get("text/plain",{onLoad:function(cm){$scope.codeMirrorPip=cm}});$scope.specPackageListEditorOptionsConda=$scope.codeMirrorSettingService.get("text/plain",{onLoad:function(cm){$scope.codeMirrorConda=cm}});$scope.codeEnvResourcesEditorOptions=$scope.codeMirrorSettingService.get("text/x-python");$scope.getLog=DataikuAPI.admin.codeenvs.design.getLog;$scope.downloadURL=function(envLang,envName,logName){return"/dip/api/code-envs/design/stream-log?envLang="+envLang+"&envName="+encodeURIComponent(envName)+"&logName="+encodeURIComponent(logName)}});app.controller("AdminCodeEnvsDesignPythonEditController",function($scope,$controller,$stateParams,CodeEnvsDesignService,Dialogs,DataikuAPI,CreateModalFromTemplate,PandasSupport){$scope.envLang="PYTHON";$controller("_AdminCodeEnvsDesignEditController",{$scope:$scope});let codeMirrorPip=null;$scope.specPackageListEditorOptionsPip=$scope.codeMirrorSettingService.get("text/plain",{onLoad:codeMirror=>{codeMirrorPip=codeMirror}});let codeMirrorConda=null;$scope.specPackageListEditorOptionsConda=$scope.codeMirrorSettingService.get("text/plain",{onLoad:codeMirror=>{codeMirrorConda=codeMirror}});$scope.packageListTypes=[];$scope.packageListValues={};$scope.corePackagesVersions=[];$scope.$watch("codeEnv",function(nv){if(!nv)return;$scope.corePackagesVersions=PandasSupport.listSupportedVersions($scope.codeEnv.desc.pythonInterpreter,$scope.codeEnv.desc.corePackagesSet)});CodeEnvsDesignService.getUserAccessibleSettings().then(({data})=>{$scope.enableCodeEnvResources=data.enableCodeEnvResources});$scope.insertAdditionalPackages=editorType=>{const newScope=$scope.$new();const editorSettings=$scope.codeMirrorSettingService.get("text/plain");newScope.insertReadOnlyOptions={...editorSettings,readOnly:true,lineNumbers:false,foldGutter:false};CreateModalFromTemplate("/templates/admin/code-envs/design/add-additional-packages-modal.html",newScope,null,scope=>{CodeEnvsDesignService.fetchPackagePresets(newScope.codeEnv,newScope).then(()=>{newScope.selectedPackages=newScope.packageListTypes[0][0]});scope.insertPackages=()=>{const selectedContent=scope.packageListValues[scope.selectedPackages];CodeEnvsDesignService.replacePackageListEditorContent(selectedContent,editorType,codeMirrorPip,codeMirrorConda);scope.dismiss()}})};$scope.openChangePythonInterpreterModal=function(codeEnv){CreateModalFromTemplate("/templates/admin/code-envs/design/change-python-modal.html",$scope,"AdminCodeEnvsDesignChangePythonController",function(newScope,newDOMElt){newScope.oldEnv=codeEnv;newScope.previousPython=codeEnv.desc.pythonInterpreter;newScope.newEnv=angular.copy(codeEnv.desc);newScope.newEnv.pythonInterpreter="PYTHON39";newScope.newEnv.envLang=codeEnv.envLang;newScope.newEnv.deploymentMode=codeEnv.deploymentMode;newScope.newEnv.specPackageList=newScope.oldEnv.specPackageList;newScope.newEnv.updateContainerRuntimeAdditions=true;newScope.newEnv.removeContainerRuntimeAdditions=true;newScope.nameChangedByUser=false;newDOMElt.on("keydown","input",function(e){newScope.nameChangedByUser=true})})}});app.controller("AdminCodeEnvsDesignREditController",function($scope,$controller){$scope.envLang="R";$controller("_AdminCodeEnvsDesignEditController",{$scope:$scope})});app.service("CodeEnvsDesignService",(DataikuAPI,$timeout)=>{const svc={};svc.getDefaultPythonEnv=()=>{return{envLang:"PYTHON",deploymentMode:"DESIGN_MANAGED",pythonInterpreter:"PYTHON39",conda:false,installCorePackages:true,corePackagesSet:"PANDAS10",installJupyterSupport:true}};svc.getDefaultPythonEnvNoCorePackage=()=>{return{envLang:"PYTHON",deploymentMode:"DESIGN_MANAGED",pythonInterpreter:"PYTHON39",conda:false,installCorePackages:true,installJupyterSupport:true}};svc.getDefaultREnv=()=>{return{envLang:"R",deploymentMode:"DESIGN_MANAGED",conda:false,installCorePackages:true,installJupyterSupport:true}};svc.CRANEditHelpString="Specify the packages you want:\n\n"+"* one row per package\n"+"* each row is a pair of package name and minimal package version (optional)\n"+"\n"+"The version is only a minimal version. It is not supported to specify an explicity version.\n\n"+"Examples of package specifications:\n\n"+"* RJSONIO,0.13\n"+"* dplyr,";svc.rCondaSpecEditHelpString="Specify the packages you want:\n\n"+"* one row per package\n"+"* each row is a Conda package match specification ( [link](https://conda.io/docs/user-guide/tasks/build-packages/package-spec.html#package-match-specifications) )\n"+"\n"+"Examples of package specifications:\n\n"+"* r-irkernel>=0.7";svc.pipRequirementsEditHelpString="Specify the packages you want:\n\n"+"* one row per package\n"+"* each row is a PIP package specification ( [link](https://setuptools.readthedocs.io/en/latest/pkg_resources.html#requirement-objects) )\n"+"\n"+"Examples of package specifications:\n\n"+"* pandas==0.20.3\n"+"* numpy>=0.19";svc.pyCondaSpecEditHelpString="Specify the packages you want:\n\n"+"* one row per package\n"+"* each row is a Conda package match specification ( [link](https://conda.io/docs/user-guide/tasks/build-packages/package-spec.html#package-match-specifications) )\n"+"\n"+"Examples of package specifications:\n\n"+"* pandas=0.20.3\n"+"* numpy>=0.19";svc.fetchPackagePresets=(codeEnv,$scope)=>{const{pythonInterpreter,conda,installCorePackages,corePackagesSet}=codeEnv.desc;let pythonCorePackageSet=corePackagesSet;if(installCorePackages===false){pythonCorePackageSet=null}return DataikuAPI.admin.codeenvs.design.listPythonPackagePresets(pythonInterpreter,conda,pythonCorePackageSet).success(presets=>{$scope.packageListTypes=[];$scope.packageListValues={};presets.forEach(preset=>{const{id,description,packages}=preset;$scope.packageListTypes.push([id,description]);$scope.packageListValues[id]=("# "+description+"\n").concat(packages.join("\n"))})}).error(setErrorInScope.bind($scope))};svc.replacePackageListEditorContent=(content,editorType,codeMirrorPip,codeMirrorConda)=>{const codeMirror=editorType==="pip"?codeMirrorPip:codeMirrorConda;const lastLine=codeMirror.lastLine();const lastChar=codeMirror.getLine(lastLine).length;if(lastLine>0){codeMirror.replaceRange("\n\n",{line:lastLine,ch:lastChar});codeMirror.setCursor(lastLine+2,0)}else{codeMirror.setCursor(lastLine,lastChar)}$timeout(()=>{codeMirror.replaceSelection(content,"end")});codeMirror.focus()};svc.getUserAccessibleSettings=function(){return DataikuAPI.codeenvs.getUserAccessibleCodeEnvSettings()};return svc})})();(function(){"use strict";var app=angular.module("dataiku.admin.codeenvs.automation",[]);app.controller("AdminCodeEnvsAutomationController",function($scope,$rootScope,TopNav,DataikuAPI,Dialogs,FutureProgressModal,CreateModalFromTemplate,ActivityIndicator,Deprecation){$scope.canCreateCodeEnv=$rootScope.mayCreateCodeEnvs;$scope.isDeployer=function(){return!$scope.appConfig.projectsModuleEnabled};$scope.openDeleteEnvModal=function(codeEnv){var newScope=$scope.$new();newScope.codeEnv=codeEnv;CreateModalFromTemplate("/templates/admin/code-envs/common/delete-env-modal.html",newScope,"AdminCodeEnvsAutomationDeleteController")};$scope.isPythonDeprecated=function(pythonInterpreter){return Deprecation.isPythonDeprecated(pythonInterpreter)};$scope.getEnvDiagnostic=function(envLang,envName){ActivityIndicator.success("Generating code env diagnostic ...");downloadURL(DataikuAPI.admin.codeenvs.automation.getDiagnosticURL(envLang,envName))}});app.controller("AdminCodeEnvsAutomationListController",function($scope,$controller,TopNav,DataikuAPI,Dialogs,CreateModalFromTemplate,$state){$controller("AdminCodeEnvsAutomationController",{$scope:$scope});TopNav.setLocation(TopNav.DSS_HOME,"administration");var buildKernelSpecField=function(env){if(env.currentVersion){env.kernelSpecName=env.currentVersion.kernelSpecName}else if(env.noVersion){env.kernelSpecName=env.noVersion.kernelSpecName}else if(env.versions){var names=[];env.versions.forEach(function(ver){angular.forEach(ver.kernelSpecNames,function(v,k){names.push(k)})});env.kernelSpecName=names.join(", ")}};$scope.refreshList=function(){return DataikuAPI.admin.codeenvs.automation.list().success(function(data){for(const codeEnv of data){codeEnv["languageDisplayName"]=codeEnv["pythonInterpreter"]||codeEnv["envLang"]}$scope.codeEnvs=data;$scope.codeEnvs.forEach(function(env){buildKernelSpecField(env)})}).error(setErrorInScope.bind($scope))};$scope.refreshList();const YOU_DONT_REALLY_WANT_TO_CREATE="Manually creating code envs in automation nodes is <strong>not recommended</strong>. The recommended way to manage "+"code envs in automation is to let bundle preload take care of it: simply preload and activate bundles "+"and the required code envs will be automatically managed.<br /><strong>Manually created code envs may not be entirely "+"functional</strong>.";const YOU_DONT_REALLY_WANT_TO_IMPORT="Manually importing code envs in automation nodes is <strong>not recommended</strong>. The recommended way to manage "+"code envs in automation is to let bundle preload take care of it: simply preload and activate bundles "+"and the required code envs will be automatically managed.<br /><strong>Manually imported code envs may not be entirely "+"functional</strong>.";$scope.openNewPythonEnvModal=function(){if($scope.isDeployer()){CreateModalFromTemplate("/templates/admin/code-envs/automation/new-python-env-modal.html",$scope,"AdminCodeEnvsAutomationNewPythonController")}else{Dialogs.confirm($scope,"Really create a new Python env?",YOU_DONT_REALLY_WANT_TO_CREATE).then(function(){CreateModalFromTemplate("/templates/admin/code-envs/automation/new-python-env-modal.html",$scope,"AdminCodeEnvsAutomationNewPythonController")})}};$scope.openNewREnvModal=function(){Dialogs.confirm($scope,"Really create a new R env?",YOU_DONT_REALLY_WANT_TO_CREATE).then(function(){CreateModalFromTemplate("/templates/admin/code-envs/automation/new-R-env-modal.html",$scope,"AdminCodeEnvsAutomationNewRController")})};$scope.openImportEnvModal=function(){if($scope.isDeployer()){CreateModalFromTemplate("/templates/admin/code-envs/automation/import-env-modal.html",$scope,"AdminCodeEnvsAutomationImportController")}else{Dialogs.confirm($scope,"Really import a code env?",YOU_DONT_REALLY_WANT_TO_IMPORT).then(function(){CreateModalFromTemplate("/templates/admin/code-envs/automation/import-env-modal.html",$scope,"AdminCodeEnvsAutomationImportController")})}};$scope.actionAfterDeletion=function(){$scope.refreshList()};$scope.goToEditIfExists=function(envName){const env=$scope.codeEnvs.find(e=>e.envName===envName);if(env&&env.envLang==="R"){$state.go("admin.codeenvs-automation.r-edit",{envName:envName})}else if(env&&env.envLang==="PYTHON"){$state.go("admin.codeenvs-automation.python-edit",{envName:envName})}}});app.controller("AdminCodeEnvsAutomationDeleteController",function($scope,TopNav,DataikuAPI,Dialogs,FutureProgressModal,$q){$scope.delete=function(){var parentScope=$scope.$parent;DataikuAPI.admin.codeenvs.automation.delete($scope.codeEnv.envLang,$scope.codeEnv.envName).success(function(data){$scope.dismiss();FutureProgressModal.show(parentScope,data,"Env deletion").then(function(result){const infoModalClosed=result?Dialogs.infoMessagesDisplayOnly(parentScope,"Deletion result",result.messages,result.futureLog):$q.resolve();infoModalClosed.then(()=>$scope.actionAfterDeletion())})}).error(setErrorInScope.bind($scope))}});app.controller("AdminCodeEnvsAutomationNewPythonController",function($scope,TopNav,DataikuAPI,Dialogs,FutureProgressModal,$q,Deprecation,CodeEnvService){$scope.isDeployer=function(){return!$scope.appConfig.projectsModuleEnabled};$scope.newEnv={deploymentMode:"AUTOMATION_SINGLE",pythonInterpreter:"PYTHON39",conda:false,installCorePackages:true,installJupyterSupport:!$scope.isDeployer()};$scope.deploymentModes=$scope.isDeployer()?[["AUTOMATION_SINGLE","Managed, non versioned"]]:[["AUTOMATION_VERSIONED","Managed and versioned (recommended)"],["AUTOMATION_SINGLE","Managed, non versioned"],["AUTOMATION_NON_MANAGED_PATH","Externally-managed"],["EXTERNAL_CONDA_NAMED","Named external Conda env"]];$scope.$watch("newEnv.conda",function(nv){if(nv===true){$scope.pythonInterpreters=CodeEnvService.pythonCondaInterpreters}else if(nv===false){$scope.pythonInterpreters=CodeEnvService.pythonInterpreters;CodeEnvService.getPythonInterpreters().then(interpreters=>{$scope.pythonInterpreters=interpreters})}});$scope.$watch("newEnv.deploymentMode",$scope.isPythonDeprecated);$scope.create=function(){var parentScope=$scope.$parent.$parent;DataikuAPI.admin.codeenvs.automation.create("PYTHON",$scope.newEnv).success(function(data){$scope.dismiss();FutureProgressModal.show(parentScope,data,"Env creation").then(function(result){const modalClosed=result?Dialogs.infoMessagesDisplayOnly(parentScope,"Creation result",result.messages,result.futureLog,undefined,"static",false):$q.resolve();const refreshed=parentScope.refreshList();$q.all([modalClosed,refreshed]).then(()=>{parentScope.goToEditIfExists(result&&result.envName)})})}).error(setErrorInScope.bind($scope))};$scope.isPythonDeprecated=function(){return $scope.newEnv&&$scope.newEnv.deploymentMode==="AUTOMATION_SINGLE"&&Deprecation.isPythonDeprecated($scope.newEnv.pythonInterpreter)}});app.controller("AdminCodeEnvsAutomationNewRController",function($scope,TopNav,DataikuAPI,Dialogs,FutureProgressModal,$q){$scope.newEnv={deploymentMode:"AUTOMATION_SINGLE",conda:false,installCorePackages:true,installJupyterSupport:true};$scope.deploymentModes=[["AUTOMATION_VERSIONED","Managed and versioned (recommended)"],["AUTOMATION_SINGLE","Managed, non versioned"],["AUTOMATION_NON_MANAGED_PATH","Externally-managed"],["EXTERNAL_CONDA_NAMED","Named external Conda env"]];$scope.create=function(){var parentScope=$scope.$parent.$parent;DataikuAPI.admin.codeenvs.automation.create("R",$scope.newEnv).success(function(data){$scope.dismiss();FutureProgressModal.show(parentScope,data,"Env creation").then(function(result){const modalClosed=result?Dialogs.infoMessagesDisplayOnly(parentScope,"Creation result",result.messages,result.futureLog,undefined,"static",false):$q.resolve();const refreshed=parentScope.refreshList();$q.all([modalClosed,refreshed]).then(()=>{parentScope.goToEditIfExists(result&&result.envName)})})}).error(setErrorInScope.bind($scope))}});app.controller("AdminCodeEnvsAutomationImportController",function($scope,$state,$stateParams,Assert,TopNav,DataikuAPI,FutureProgressModal,Dialogs,Logs,$q){$scope.newEnv={};$scope.import=function(){Assert.trueish($scope.newEnv.file,"No code env file");const parentScope=$scope.$parent.$parent;DataikuAPI.admin.codeenvs.automation.import($scope.newEnv.file).then(function(data){$scope.dismiss();FutureProgressModal.show(parentScope,JSON.parse(data),"Env import",undefined,"static",false).then(function(result){const modalClosed=result?Dialogs.infoMessagesDisplayOnly(parentScope,"Creation result",result.messages,result.futureLog,undefined,"static",false):$q.resolve();const refreshed=parentScope.refreshList();$q.all([modalClosed,refreshed]).then(()=>{parentScope.goToEditIfExists(result&&result.envName)})})},function(payload){setErrorInScope.bind($scope)(JSON.parse(payload.response),payload.status,function(h){return payload.getResponseHeader(h)})})}});app.controller("AdminCodeEnvsAutomationImportVersionController",function($scope,$state,$stateParams,Assert,TopNav,DataikuAPI,FutureProgressModal,Dialogs,Logs){$scope.newEnv={};$scope.import=function(){Assert.trueish($scope.newEnv.file,"No code env file");const parentScope=$scope.$parent.$parent;DataikuAPI.admin.codeenvs.automation.importVersion($scope.newEnv.file,$scope.envLang,$scope.envName).then(function(data){$scope.dismiss();FutureProgressModal.show(parentScope,JSON.parse(data),"Env import",undefined,"static",false).then(function(result){if(result){Dialogs.infoMessagesDisplayOnly(parentScope,"Import result",result.messages,result.futureLog);$scope.addImportedVersion(result.version)}})},function(payload){setErrorInScope.bind($scope)(JSON.parse(payload.response),payload.status,function(h){return payload.getResponseHeader(h)})})}});app.controller("_AdminCodeEnvsAutomationEditController",function($scope,$controller,$state,$stateParams,TopNav,DataikuAPI,FutureProgressModal,Dialogs,Logs,CreateModalFromTemplate,$q){$controller("AdminCodeEnvsAutomationController",{$scope:$scope});TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.envName=$stateParams.envName;$scope.uiState={active:"info",upgradeAllPackages:true,updateResources:true,forceRebuildEnv:false};$scope.actionAfterDeletion=function(){$state.go("admin.codeenvs-automation.list")};$scope.canBeUpdated=function(){return $scope.codeEnv&&$scope.codeEnv.canUpdateCodeEnv&&["DESIGN_MANAGED","PLUGIN_MANAGED","AUTOMATION_SINGLE","DSS_INTERNAL"].indexOf($scope.codeEnv.deploymentMode)>=0};$scope.canVersionBeUpdated=function(versionId){return["AUTOMATION_VERSIONED"].indexOf($scope.codeEnv.deploymentMode)>=0||$scope.canBeUpdated()};$scope.getSingleVersion=function(codeEnv){if(codeEnv&&codeEnv.currentVersion){return codeEnv.currentVersion.versionId}else if(codeEnv&&codeEnv.noVersion){return codeEnv.noVersion.versionId}else{return null}};var makeDiffedEnvSettings=function(envSettings){return{inheritGlobalSettings:envSettings.inheritGlobalSettings,condaCreateExtraOptions:envSettings.condaCreateExtraOptions,condaInstallExtraOptions:envSettings.condaInstallExtraOptions,pipInstallExtraOptions:envSettings.pipInstallExtraOptions,virtualenvCreateExtraOptions:envSettings.virtualenvCreateExtraOptions}};var makeDiffedDesc=function(desc){return{yarnPythonBin:desc.yarnPythonBin,yarnRBin:desc.yarnRBin,dockerImageResources:desc.dockerImageResources,updateResourcesApiNode:desc.updateResourcesApiNode,corePackagesSet:desc.corePackagesSet,envSettings:makeDiffedEnvSettings(desc.envSettings),predefinedContainerHooks:angular.copy(desc.predefinedContainerHooks),dockerfileAtStart:desc.dockerfileAtStart,dockerfileBeforePackages:desc.dockerfileBeforePackages,dockerfileAfterCondaPackages:desc.dockerfileAfterCondaPackages,dockerfileAfterPackages:desc.dockerfileAfterPackages,dockerfileAtEnd:desc.dockerfileAtEnd,containerCacheBustingLocation:desc.containerCacheBustingLocation}};var makeDiffedVersion=function(version){return{specCondaEnvironment:version.specCondaEnvironment,specPackageList:version.specPackageList,desc:makeDiffedDesc(version.desc),allContainerConfs:version.allContainerConfs,containerConfs:version.containerConfs,allSparkKubernetesConfs:version.allSparkKubernetesConfs,sparkKubernetesConfs:version.sparkKubernetesConfs,resourcesInitScript:version.resourcesInitScript}};var makeDiffedSpec=function(codeEnv){var spec={};if(codeEnv){spec.desc=codeEnv.desc;spec.externalCondaEnvName=codeEnv.externalCondaEnvName;if(codeEnv.currentVersion){spec.currentVersion=makeDiffedVersion(codeEnv.currentVersion)}if(codeEnv.noVersion){spec.noVersion=makeDiffedVersion(codeEnv.noVersion)}if(codeEnv.versions){spec.versions=codeEnv.versions.map(function(v){return makeDiffedVersion(v)})}spec.permissions=angular.copy(codeEnv.permissions);spec.envSettings=angular.copy(codeEnv.envSettings);spec.usableByAll=codeEnv.usableByAll;spec.owner=codeEnv.owner}return spec};const getSingleDesc=function(codeEnv){if(codeEnv&&codeEnv.currentVersion){return codeEnv.currentVersion.desc}else if(codeEnv&&codeEnv.noVersion){return codeEnv.noVersion.desc}else{return null}};$scope.isInternalCodeEnv=function(){return $scope.codeEnv&&$scope.codeEnv.deploymentMode==="DSS_INTERNAL"};$scope.hasOptedOutOfReferenceSpec=function(){const currentDesc=getSingleDesc($scope.codeEnv);return $scope.isInternalCodeEnv()&&currentDesc&&currentDesc.useReferenceSpec===false};$scope.useReferenceSpec=function(){const currentDesc=getSingleDesc($scope.codeEnv);return $scope.isInternalCodeEnv()&&currentDesc&&currentDesc.useReferenceSpec===true};$scope.specIsDirty=function(){if(!$scope.codeEnv)return false;var currentSpec=makeDiffedSpec($scope.codeEnv);return!angular.equals(currentSpec,$scope.previousSpec)};$scope.versionSpecIsDirty=function(versionId){if(!$scope.codeEnv)return false;var idx=-1;$scope.codeEnv.versions.forEach(function(v,i){if(v.versionId==versionId){idx=i}});if(idx<0){return false}else{var currentSpec=makeDiffedVersion($scope.codeEnv.versions[idx]);return!angular.equals(currentSpec,$scope.previousSpec.versions[idx])}};checkChangesBeforeLeaving($scope,$scope.specIsDirty);$scope.previousSpec=makeDiffedSpec($scope.codeEnv);var listLogs=function(){return DataikuAPI.admin.codeenvs.automation.listLogs($scope.envLang,$stateParams.envName).then(function(response){$scope.logs=response.data}).catch(setErrorInScope.bind($scope))};var refreshEnv=function(){const getEnvPromise=DataikuAPI.admin.codeenvs.automation.get($scope.envLang,$stateParams.envName).then(function(response){$scope.codeEnv=response.data;$scope.previousSpec=makeDiffedSpec($scope.codeEnv)}).catch(setErrorInScope.bind($scope));const listLogsPromise=listLogs();return $q.all([getEnvPromise,listLogsPromise])};var refreshEnvVersion=function(versionId){DataikuAPI.admin.codeenvs.automation.getVersion($scope.envLang,$stateParams.envName,versionId).success(function(data){var idx=-1;$scope.codeEnv.versions.forEach(function(v,i){if(v.versionId==versionId){idx=i}});if(idx>=0){$scope.codeEnv.versions[idx]=data;$scope.previousSpec.versions[idx]=makeDiffedVersion(data)}}).error(setErrorInScope.bind($scope))};refreshEnv().then(()=>$scope.uiState.forceRebuildEnv=$scope.isInternalCodeEnv());$scope.fetchNonManagedEnvDetails=function(){DataikuAPI.admin.codeenvs.automation.fetchNonManagedEnvDetails($scope.envLang,$stateParams.envName).success(function(data){$scope.nonManagedEnvDetails=data}).error(setErrorInScope.bind($scope))};$scope.installJupyterSupport=function(versionId){DataikuAPI.admin.codeenvs.automation.installJupyterSupport($scope.envLang,$stateParams.envName,versionId).success(function(data){FutureProgressModal.show($scope,data,"Env update").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result.messages,result.futureLog)}if(versionId){refreshEnvVersion(versionId)}else{refreshEnv()}})}).error(setErrorInScope.bind($scope))};$scope.removeJupyterSupport=function(versionId){DataikuAPI.admin.codeenvs.automation.removeJupyterSupport($scope.envLang,$stateParams.envName,versionId).success(function(data){FutureProgressModal.show($scope,data,"Env update").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result.messages,result.futureLog)}if(versionId){refreshEnvVersion(versionId)}else{refreshEnv()}})}).error(setErrorInScope.bind($scope))};$scope.showResourcesTab=function(){return $scope.appConfig.admin&&$scope.isInternalCodeEnv()||!["EXTERNAL_CONDA_NAMED","DSS_INTERNAL"].includes($scope.codeEnv?.deploymentMode)};$scope.updateEnvVersion=function(upgradeAllPackages,forceRebuildEnv,updateResources,versionToUpdate){var updateSettings={upgradeAllPackages:upgradeAllPackages,forceRebuildEnv:forceRebuildEnv,updateResources:updateResources,versionToUpdate:versionToUpdate};DataikuAPI.admin.codeenvs.automation.update($scope.envLang,$stateParams.envName,updateSettings).success(function(data){FutureProgressModal.show($scope,data,"Env update",undefined,"static",false).then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result.messages,result.futureLog)}if(versionToUpdate){refreshEnvVersion(versionToUpdate)}else{refreshEnv()}const broadcastEventParams=versionToUpdate?{envName:$scope.codeEnv.envName,versionId:versionToUpdate}:{envName:$scope.codeEnv.envName};$scope.$broadcast("refreshCodeEnvResources",broadcastEventParams)})}).error(setErrorInScope.bind($scope))};$scope.updateEnv=()=>$scope.updateEnvVersion($scope.uiState.upgradeAllPackages,$scope.uiState.forceRebuildEnv,$scope.uiState.updateResources);$scope.saveAndMaybePerformChanges=function(performChangesOnSave){DataikuAPI.admin.codeenvs.automation.save($scope.envLang,$stateParams.envName,$scope.codeEnv).success(function(data){refreshEnv();if(performChangesOnSave){$scope.updateEnv()}}).error(setErrorInScope.bind($scope))};$scope.saveVersionAndMaybePerformChanges=function(performChangesOnSave,upgradeAllPackages,forceRebuildEnv,updateResources,version){DataikuAPI.admin.codeenvs.automation.saveVersion($scope.envLang,$stateParams.envName,version.versionId,version).success(function(data){refreshEnvVersion(version.versionId);if(performChangesOnSave){$scope.updateEnvVersion(upgradeAllPackages,forceRebuildEnv,updateResources,version.versionId)}}).error(setErrorInScope.bind($scope))};$scope.setContainerConfForAllVersions=function(origVersion){$scope.codeEnv.versions.forEach(function(v){v.desc.allContainerConfs=origVersion.desc.allContainerConfs;v.desc.containerConfs=origVersion.desc.containerConfs;v.desc.allSparkKubernetesConfs=origVersion.desc.allSparkKubernetesConfs;v.desc.sparkKubernetesConfs=origVersion.desc.sparkKubernetesConfs})};$scope.setResourcesConfForAllVersions=function(origVersion){$scope.codeEnv.versions.forEach(function(v){v.resourcesInitScript=origVersion.resourcesInitScript})};$scope.getLog=DataikuAPI.admin.codeenvs.automation.getLog;$scope.downloadURL=function(envLang,envName,logName){return"/dip/api/code-envs/automation/stream-log?envLang="+envLang+"&envName="+encodeURIComponent(envName)+"&logName="+encodeURIComponent(logName)};$scope.codeEnvResourcesEditorOptions=$scope.codeMirrorSettingService.get("text/x-python");$scope.openImportEnvVersionModal=function(){CreateModalFromTemplate("/templates/admin/code-envs/automation/import-env-version-modal.html",$scope,"AdminCodeEnvsAutomationImportVersionController",function(newScope){newScope.envName=$stateParams.envName;newScope.envLang=$scope.envLang;newScope.addImportedVersion=function(version){if(version==null)return;$scope.codeEnv.versions.splice(0,0,version);$scope.previousSpec.versions.splice(0,0,makeDiffedVersion(version))}})}});app.controller("AdminCodeEnvsAutomationPythonEditController",function($scope,$controller,$state,$stateParams,TopNav,DataikuAPI,FutureProgressModal,Dialogs){$scope.envLang="PYTHON";$controller("_AdminCodeEnvsAutomationEditController",{$scope:$scope});DataikuAPI.codeenvs.getUserAccessibleCodeEnvSettings().then(({data})=>{$scope.enableCodeEnvResources=data.enableCodeEnvResources})});app.controller("AdminCodeEnvsAutomationREditController",function($scope,$controller,$state,$stateParams,TopNav,DataikuAPI,FutureProgressModal,Dialogs){$scope.envLang="R";$controller("_AdminCodeEnvsAutomationEditController",{$scope:$scope})});app.directive("pythonVersion",function(DataikuAPI,$state,$stateParams,$rootScope,Deprecation,PandasSupport){return{restrict:"A",templateUrl:"/templates/admin/code-envs/automation/python-version.html",scope:{version:"=pythonVersion",updateVersion:"&",saveVersion:"&",versionSpecIsDirty:"&",installJupyterSupport:"&",removeJupyterSupport:"&",editable:"=",withSaveUpdate:"=",canVersionBeUpdated:"&"},link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;$scope.uiState={upgradeAllPackages:false,updateResources:true,forceRebuildEnv:false};$scope.updateVersionEnv=function(){$scope.updateVersion()($scope.uiState.upgradeAllPackages,$scope.uiState.forceRebuildEnv,$scope.uiState.updateResources,$scope.version.versionId)};$scope.saveVersionEnv=function(performChangesOnSave){$scope.saveVersion()(performChangesOnSave,$scope.uiState.upgradeAllPackages,$scope.uiState.forceRebuildEnv,$scope.uiState.updateResources,$scope.version)};$scope.installJupyterSupportVersion=function(){$scope.installJupyterSupport()($scope.version.versionId)};$scope.specIsDirty=function(){return $scope.versionSpecIsDirty()($scope.version.versionId)};$scope.canBeUpdated=function(){return $scope.canVersionBeUpdated()($scope.version.versionId)};$scope.removeJupyterSupportVersion=function(){$scope.removeJupyterSupport()($scope.version.versionId)};$scope.refreshMandatoryPackageList=function(){if(!$scope.version)return;if(!$scope.version.desc.installCorePackages&&!$scope.codeEnv.version.installJupyterSupport){$scope.version.mandatoryPackageList="";$scope.version.mandatoryCondaEnvironment="";return}DataikuAPI.codeenvs.getMandatoryPackages("PYTHON",$scope.version.desc).then(({data})=>{if($scope.version.conda){$scope.version.mandatoryCondaEnvironment=data}else{$scope.version.mandatoryPackageList=data}})};$scope.isPythonDeprecated=Deprecation.isPythonDeprecated;$scope.corePackagesVersions=PandasSupport.listSupportedVersions($scope.version.desc.pythonInterpreter,$scope.version.desc.corePackagesSet)}}});app.directive("rVersion",function(DataikuAPI,$state,$stateParams,$rootScope){return{restrict:"A",templateUrl:"/templates/admin/code-envs/automation/R-version.html",scope:{version:"=rVersion",updateVersion:"&",saveVersion:"&",versionSpecIsDirty:"&",installJupyterSupport:"&",removeJupyterSupport:"&",editable:"=",withSaveUpdate:"=",canVersionBeUpdated:"&"},link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;$scope.uiState={upgradeAllPackages:false,updateResources:true,forceRebuildEnv:false};$scope.updateVersionEnv=function(){$scope.updateVersion()($scope.uiState.upgradeAllPackages,$scope.uiState.forceRebuildEnv,$scope.uiState.updateResources,$scope.version.versionId)};$scope.saveVersionEnv=function(performChangesOnSave){$scope.saveVersion()(performChangesOnSave,$scope.uiState.upgradeAllPackages,$scope.uiState.forceRebuildEnv,$scope.uiState.updateResources,$scope.version)};$scope.installJupyterSupportVersion=function(){$scope.installJupyterSupport()($scope.version.versionId)};$scope.specIsDirty=function(){return $scope.versionSpecIsDirty()($scope.version.versionId)};$scope.canBeUpdated=function(){return $scope.canVersionBeUpdated()($scope.version.versionId)};$scope.removeJupyterSupportVersion=function(){$scope.removeJupyterSupport()($scope.version.versionId)}}}});app.directive("containerVersion",function(DataikuAPI,$state,$stateParams,$rootScope,$timeout){return{restrict:"A",templateUrl:"/templates/admin/code-envs/automation/container-version.html",scope:{version:"=containerVersion",updateVersion:"&",saveVersion:"&",versionSpecIsDirty:"&",withSaveUpdate:"=",canVersionBeUpdated:"&",setForAllVersions:"&",envLang:"=",deploymentMode:"="},controller:function($scope){$scope.appConfig=$rootScope.appConfig;$scope.uiState={upgradeAllPackages:false,updateResources:true,forceRebuildEnv:false};$scope.updateVersionEnv=function(){$scope.updateVersion()($scope.uiState.upgradeAllPackages,$scope.uiState.forceRebuildEnv,$scope.uiState.updateResources,$scope.version.versionId)};$scope.saveVersionEnv=function(performChangesOnSave){$scope.saveVersion()(performChangesOnSave,$scope.uiState.upgradeAllPackages,$scope.uiState.forceRebuildEnv,$scope.uiState.updateResources,$scope.version)};$scope.specIsDirty=function(){return $scope.versionSpecIsDirty()($scope.version.versionId)};$scope.canBeUpdated=function(){return $scope.canVersionBeUpdated()($scope.version.versionId)};$scope.setThisForAllVersions=function(){$timeout(function(){$scope.setForAllVersions()($scope.version)})}}}});app.directive("resourcesVersion",["$rootScope","$timeout",function($rootScope,$timeout){return{restrict:"A",templateUrl:"/templates/admin/code-envs/automation/resources-version.html",scope:{version:"=resourcesVersion",envName:"=",updateVersion:"&",saveVersion:"&",versionSpecIsDirty:"&",withSaveUpdate:"=",canVersionBeUpdated:"&",setForAllVersions:"&",codeEnvResourcesEditorOptions:"=editorOptions"},link:function($scope){$scope.appConfig=$rootScope.appConfig;$scope.uiState={upgradeAllPackages:false,updateResources:true,forceRebuildEnv:false};$scope.updateVersionEnv=function(){$scope.updateVersion()($scope.uiState.upgradeAllPackages,$scope.uiState.forceRebuildEnv,$scope.uiState.updateResources,$scope.version.versionId)};$scope.saveVersionEnv=function(performChangesOnSave){$scope.saveVersion()(performChangesOnSave,$scope.uiState.upgradeAllPackages,$scope.uiState.forceRebuildEnv,$scope.uiState.updateResources,$scope.version)};$scope.specIsDirty=function(){return $scope.versionSpecIsDirty()($scope.version.versionId)};$scope.canBeUpdated=function(){return $scope.canVersionBeUpdated()($scope.version.versionId)};$scope.setThisForAllVersions=function(){$timeout(function(){$scope.setForAllVersions()($scope.version)})}}}}])})();(function(){"use strict";var app=angular.module("dataiku.admin.monitoring",[]);app.controller("AdminMonitoringSummaryController",function($scope,$rootScope,$state,DataikuAPI,$filter,$anchorScroll,$timeout){$scope.refresh=function refresh(){$scope.isLoading=true;DataikuAPI.admin.monitoring.getGlobalUsageSummary().success(function(data){$scope.globalSummary=data;$scope.globalSummary.datasets.allByTypeArray=$filter("toKVArray")($scope.globalSummary.datasets.allByType);$scope.globalSummary.recipes.byTypeArray=$filter("toKVArray")($scope.globalSummary.recipes.byType);$timeout(()=>$anchorScroll());$scope.isLoading=false}).error(()=>{setErrorInScope.bind($scope);$scope.isLoading=false})};$scope.isLoading=false});app.controller("AdminMonitoringWebAppBackendsController",function($scope,$rootScope,$state,DataikuAPI,ActivityIndicator){$scope.refreshList=function(){DataikuAPI.webapps.listAllBackendsStates().success(function(data){$scope.backends=data}).error(setErrorInScope.bind($scope))};$scope.stopBackend=function(backend){DataikuAPI.webapps.stopBackend({projectKey:backend.projectKey,id:backend.webAppId}).success(function(data){ActivityIndicator.success("Backend stopped")}).error(setErrorInScope.bind($scope))};$scope.restartBackend=function(backend){DataikuAPI.webapps.restartBackend({projectKey:backend.projectKey,id:backend.webAppId}).success(function(data){ActivityIndicator.success("Backend start command sent")}).error(setErrorInScope.bind($scope))};$scope.refreshList()});app.controller("AdminMonitoringIntegrationsController",function($scope,DataikuAPI,ActivityIndicator,Dialogs,WT1){$scope.hidePreviewColumn=true;$scope.noTags=true;$scope.noStar=true;$scope.noWatch=true;$scope.massDelete=true;$scope.massIntegrations=true;$scope.noDelete=true;$scope.sortBy=[{value:"projectKey",label:"Project name"},{value:"integrationName",label:"Integration type"},{value:"integrationActive",label:"Active"}];$scope.selection=$.extend({filterQuery:{userQuery:"",interest:{starred:""}},filterParams:{userQueryTargets:["projectKey","name","integrationName","integrationProperties"],propertyRules:{}},orderQuery:"projectKey",orderReversed:false},$scope.selection||{});$scope.sortCookieKey="project-integrations";$scope.maxItems=100;$scope.list=()=>{WT1.event("refresh-project-integrations-list");DataikuAPI.admin.monitoring.getProjectsIntegrations().success(data=>{$scope.integrations=data;$scope.listItems=[];data.forEach(item=>{item.integrations.forEach(integration=>{$scope.listItems.push({...integration,integrationName:formatIntegrationName(integration.hook.type),integrationActive:integration.active,integrationDetails:integration.hook.configuration.webhookUrl||undefined,integrationProperties:formatIntegrationProperties(integration),projectKey:item.projectKey})})})}).error(setErrorInScope.bind($scope))};$scope.list();$scope.toggleActive=function(item){WT1.event("integration-save-active");DataikuAPI.admin.monitoring.saveProjectIntegration(item.projectKey,item).success(function(data){ActivityIndicator.success("Saved")}).error(setErrorInScope.bind($scope))};$scope.deleteIntegration=item=>{WT1.event("integration-delete");DataikuAPI.admin.monitoring.deleteProjectIntegration(item.projectKey,item).success(()=>{ActivityIndicator.success("Saved")}).error(setErrorInScope.bind($scope))};$scope.massDeletion=items=>{if(items.length<1)return;Dialogs.confirm($scope,"Confirm deletion","Are you sure you want to delete the selected integrations?").then(function(){items.forEach(item=>{item.active=status;$scope.deleteIntegration(item);$scope.listItems=$scope.listItems.filter(s=>s!==item)})})};$scope.allIntegrations=function(objects){if(!objects)return;return objects.map(o=>o.active).reduce(function(a,b){return a&&b},true)};$scope.autoIntegrationsObjects=function(autoIntegrationsStatus,objects){objects.forEach(function(object){if(object.active===autoIntegrationsStatus)return;object.active=autoIntegrationsStatus;$scope.toggleActive(object)})};const formatIntegrationProperties=integration=>{if(integration.hook.type==="github"){return"Repository: "+integration.hook.configuration.repository}const labels=[];if(integration.hook.configuration.selection.commits){labels.push("Git commits")}if(integration.hook.configuration.selection.discussions){labels.push("Discussions messages")}if(integration.hook.configuration.selection.jobEnds){labels.push("Build jobs ends")}if(integration.hook.configuration.selection.jobStarts){labels.push("Build jobs beginnings")}if(integration.hook.configuration.selection.mlEnds){labels.push("Analysis ML training ends")}if(integration.hook.configuration.selection.mlStarts){labels.push("Analysis ML training beginnings")}if(integration.hook.configuration.selection.scenarioEnds){labels.push("Scenario ends")}if(integration.hook.configuration.selection.scenarioStarts){labels.push("Scenario starts")}if(integration.hook.configuration.selection.timelineEditionItems){labels.push("Objects editions")}if(integration.hook.configuration.selection.timelineItemsExceptEditions){labels.push("Objects creation / deletion / ...")}if(integration.hook.configuration.selection.watchStar){labels.push("Watch / Star")}return labels.length>0?"Sends on "+labels.join(", "):""};const formatIntegrationName=type=>{const typeMapping={"msft-teams-project":"Microsoft Teams","google-chat-project":"Google Chat",github:"Github","slack-project":"Slack"};return typeMapping[type]||type}});app.controller("AdminMonitoringClusterTasksController",function($scope,$rootScope,$state,DataikuAPI,Fn,$filter,ConnectionsService){$scope.uiState={};$scope.searchConnectionsWithDescriptions=ConnectionsService.searchConnectionsWithDescriptions;DataikuAPI.admin.connections.list().success(function(data){var array=$filter("toArray")(data);var hasHDFS=array.filter(Fn.compose(Fn.prop("type"),Fn.eq("HDFS"))).length>0;$scope.connections=array.filter(function(x){return x.type!="HDFS"}).map(function(x){return{name:x.name,type:x.type,id:x.name,description:x.description}});if(hasHDFS){$scope.connections.push({name:"Hadoop",type:"Hadoop",id:"HADOOP"})}}).error(setErrorInScope.bind($scope));$scope.fetchData=function fetchData(connectionId){DataikuAPI.admin.monitoring.getConnectionTasksHistory(connectionId).success(function(data){$scope.connectionData=data;data.lastTasks.forEach(function(t){t.elapsedTime=t.endTime-t.startTime});$scope.projectData=[];data.perProject.forEach(function(p){p.types.forEach(function(t,i){$scope.projectData.push(angular.extend(t,{projectKey:p.project,l:p.types.length}))})});$scope.userData=[];data.perUser.forEach(function(p){p.types.forEach(function(t,i){$scope.userData.push(angular.extend(t,{initiator:p.user,l:p.types.length}))})})}).error(setErrorInScope.bind($scope))}});app.controller("AdminMonitoringBackgroundTasksController",function($scope,DataikuAPI,$rootScope,Dialogs,ProgressStackMessageBuilder,$timeout){$scope.Math=window.Math;$scope.isLoading=false;$scope.uiState={query:{task:{$:""}},taskType:[],sortColumn:"type",sortDescending:false};$scope.tasks=[],$scope.taskTypeOptions=[{value:"future",label:"Long task"},{value:"notebook",label:"Notebook"},{value:"job",label:"Job"},{value:"scenario",label:"Scenario"},{value:"clusterKernel",label:"Hive & Scala validation"}];const isScenarioFuture=future=>future?.payload?.action==="run_scenario";$scope.filterOnType=value=>$scope.uiState.taskType.length===0||$scope.uiState.taskType.includes(value.type);$scope.labelForType=value=>$scope.taskTypeOptions.find(t=>t.value===value)?.label;$scope.refreshList=function(){$scope.isLoading=true;$scope.tasks=[];DataikuAPI.running.listAll().success(function(data){$scope.tasks=[...data.futures.map(future=>({type:isScenarioFuture(future)?"scenario":"future",task:future,since:future.alive&&!future.aborted?future.startTime:undefined,abortLabel:"Abort",canAbort:!future.aborted&&future.alive&&future.abortable,abortModalTitle:isScenarioFuture(future)?"Abort the scenario?":"Abort the task?",abort:()=>DataikuAPI.futures.abort(future.jobId)})),...data.notebooks.map(notebook=>({type:"notebook",task:notebook,since:notebook.activeSessions?.[0].sessionStartTime,abortLabel:"Unload",canAbort:notebook.activeSessions.length,abortModalTitle:"Unload the notebook?",abort:()=>DataikuAPI.jupyterNotebooks.unload(notebook.activeSessions[0]?.sessionId)})),...data.jobs.map(job=>({type:"job",task:job,since:job.state==="PENDING"?job.def.initiationTimestamp:job.startTime,abortLabel:"Abort",canAbort:!job.stableState,abortModalTitle:"Abort the job?",abort:()=>DataikuAPI.flow.jobs.abort(job.def.projectKey,job.def.id)})),...data.clusterKernels.map(clusterKernel=>({type:"clusterKernel",task:clusterKernel,since:clusterKernel.aborted?undefined:clusterKernel.lastTouched,abortLabel:"Abort",canAbort:!clusterKernel.aborted,abortModalTitle:"Abort the validation kernel?",abort:()=>{clusterKernel.aborted=true;return DataikuAPI.admin.clusters.abortKernel(clusterKernel.prefix,clusterKernel.kernelId)}}))]}).error(setErrorInScope.bind($scope)).finally(()=>$scope.isLoading=false)};$scope.abort=item=>{Dialogs.confirm($scope,item.abortModalTitle).then(()=>{item.canAbort=false;item.abort().success($scope.refreshList).error(setErrorInScope.bind($scope))})};$scope.refreshList()});app.controller("AdminMonitoringConnectionDataController",function($scope,$rootScope,$state,DataikuAPI,Fn,$filter,CreateModalFromTemplate,FutureProgressModal,InfoMessagesModal,Dialogs,DatasetsService,ConnectionsService,ManagedFoldersService){$scope.uiState={};$scope.searchConnectionsWithDescriptions=ConnectionsService.searchConnectionsWithDescriptions;DataikuAPI.admin.connections.list().success(function(data){var array=$filter("toArray")(data);$scope.connections=array.map(function(x){return{name:x.name,type:x.type,id:x.name,description:x.description}})}).error(setErrorInScope.bind($scope));$scope.fetchData=function fetchData(connectionId){DataikuAPI.admin.monitoring.connectionData.get(connectionId).success(function(data){$scope.connectionData=data}).error(setErrorInScope.bind($scope))};$scope.focusOnProject=function(connectionId,projectKey){DataikuAPI.admin.monitoring.connectionData.getForProject(connectionId,projectKey).success(function(data){$scope.projectData=data}).error(setErrorInScope.bind($scope))};$scope.clearProjectData=function(){$scope.projectData=null};$scope.updateForProject=function(connectionId,projectKey){CreateModalFromTemplate("/templates/admin/monitoring/connection-data-update-confirm.html",$scope,null,function(newScope){newScope.settings={computeRecords:false,forceRecompute:false};newScope.go=function(){DataikuAPI.admin.monitoring.connectionData.updateForProject(connectionId,projectKey,newScope.settings.computeRecords,newScope.settings.forceRecompute).success(function(data){FutureProgressModal.show($scope,data,"Datasets update").then(function(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result);$scope.fetchData(connectionId)});newScope.dismiss()})}})};$scope.updateSingleDataset=function(connectionId,projectKey,datasetName){CreateModalFromTemplate("/templates/admin/monitoring/connection-data-update-confirm.html",$scope,null,function(newScope){newScope.settings={computeRecords:false,forceRecompute:false};newScope.go=function(){DataikuAPI.admin.monitoring.connectionData.updateForDataset(projectKey,datasetName,newScope.settings.computeRecords,newScope.settings.forceRecompute).success(function(data){FutureProgressModal.show($scope,data,"Dataset update").then(function(result){InfoMessagesModal.showIfNeeded($scope,result,"Update result");$scope.focusOnProject(connectionId,projectKey)});newScope.dismiss()})}})};$scope.updateSingleManagedFolder=function(connectionId,projectKey,managedFolderName){CreateModalFromTemplate("/templates/admin/monitoring/connection-data-update-managed-folder-confirm.html",$scope,null,function(newScope){newScope.settings={forceRecompute:false};newScope.go=function(){DataikuAPI.admin.monitoring.connectionData.updateForManagedFolder(projectKey,managedFolderName,newScope.settings.forceRecompute).success(function(data){FutureProgressModal.show($scope,data,"Managed Folder update").then(function(result){InfoMessagesModal.showIfNeeded($scope,result,"Update result");$scope.focusOnProject(connectionId,projectKey)});newScope.dismiss()})}})};$scope.clearDataset=function(connectionId,projectKey,datasetName){DatasetsService.clear($scope,projectKey,datasetName).then(function(){$scope.focusOnProject(connectionId,projectKey)})};$scope.clearManagedFolder=function(connectionId,projectKey,managedFolderId,managedFolderName){ManagedFoldersService.clear($scope,projectKey,managedFolderId,managedFolderName).then(function(){$scope.focusOnProject(connectionId,projectKey)})}})})();(function(){"use strict";var app=angular.module("dataiku.admin.alertMessageBanner",[]);const ALERT_MESSAGE_BANNER_ID_KEY="dss.admin.ALERT_MESSAGE_BANNER_ID_KEY";app.component("alertMessageBanner",{template:`
            <div ng-if="$ctrl.display && !$root.appConfig.unattendedMode" class="alert alert-warning alert-message-banner children-horizontal-spacing-2x" role="alert">
                <div class="alert-message-banner__header children-horizontal-spacing-2x">
                    <i class="dku-icon-warning-fill-16"></i>
                    <blockquote class="alert-message-banner__title" from-markdown="$ctrl.alertBanner.message"></blockquote>
                </div>
                <button class="btn btn--outline btn--secondary" ng-click="$ctrl.dismiss()">Dismiss</button>
            </div>
        `,controller:function($rootScope,LocalStorage,Notification,Logger,DataikuAPI,$scope){this.display=false;this.alertBanner=undefined;const handleLocalStorageAndDisplay=alertMessageBanner=>{const storedAlertMessageBannerId=LocalStorage.get(ALERT_MESSAGE_BANNER_ID_KEY);if(alertMessageBanner&&storedAlertMessageBannerId!==alertMessageBanner.id){LocalStorage.clear(ALERT_MESSAGE_BANNER_ID_KEY);if(md5($rootScope.appConfig.login)!==alertMessageBanner.authorId){this.display=true}}else{this.display=false}};this.$onInit=function(){try{this.alertBanner=$rootScope.appConfig.alertBanner;handleLocalStorageAndDisplay(this.alertBanner)}catch(error){Logger.error("Error handling initialisation of alertMessageBanner.",error);this.display=false}};const notificationUnsubscribe=Notification.registerEvent("admin-message-banner-changed",(_,message)=>{this.alertBanner=message.alertBanner;handleLocalStorageAndDisplay(message.alertBanner)});$scope.$on("$destroy",notificationUnsubscribe);this.dismiss=function(){LocalStorage.set(ALERT_MESSAGE_BANNER_ID_KEY,this.alertBanner.id);this.display=false;DataikuAPI.profile.notifyAlertBannerDismissed(this.alertBanner.id)}}});app.component("alertMessageBannerForm",{bindings:{alertBanner:"="},template:`
            <form class="dkuform-horizontal">
                <h2 id="alert-message-banner-form">Alert Banner</h2>
                <div class="control-group">
                    <label for="alert-banner-message" class="control-label">Message</label>
                    <div class="controls">
                        <textarea id="alert-banner-message" style="height: 5rem;" ng-model="$ctrl.workingAlertBannerMessage" ng-change="$ctrl.onMessageChange()" />
                        <span class="help-inline">Text of the alert banner. Supports Markdown.</span>
                    </div>
                    <input type="hidden" ng-model="$ctrl.alertBanner.id">
                    <input type="hidden" ng-model="$ctrl.alertBanner.authorId">
                </div>
            </form>
        `,controller:function($rootScope){let previousContent;this.workingAlertBannerMessage;this.$doCheck=()=>{if(this.alertBanner!==undefined&&previousContent===undefined){previousContent=angular.copy(this.alertBanner);this.workingAlertBannerMessage=angular.copy(this.alertBanner.message)}};this.onMessageChange=function(){if(this.workingAlertBannerMessage===""){this.alertBanner=undefined}else if(previousContent&&previousContent.message!==this.workingAlertBannerMessage||previousContent===undefined){this.alertBanner={};this.alertBanner.message=this.workingAlertBannerMessage;this.alertBanner.id=md5(this.workingAlertBannerMessage);this.alertBanner.authorId=md5($rootScope.appConfig.login)}else{this.alertBanner=previousContent}}}})})();(function(){"use strict";var app=angular.module("dataiku.admin.globalApiKeyInput",[]);app.component("globalApiKeyInput",{bindings:{apiKey:"=",newKeyLabel:"<",newKeyDescription:"<"},template:`
        <span class="global-api-key-input">
            <input id="apikey"
                type="password"
                ng-model="$ctrl.apiKey"/>
            <span class="overlay-disablable-item-container">
                <span toggle="tooltip" container="body" data-placement="right"
                    title="{{apiKeyDescription}}" >
                    <i ng-if="!apiKeyWarning" class="ng-scope icon-info-sign text-info"></i>
                    <i ng-if="apiKeyWarning" class="ng-scope icon-dku-warning text-warning"></i>
                </span>
                <button class="btn btn--secondary"
                        title="New Global API key"
                        ng-click="createGlobalApiKey()">
                        <i class="icon-plus" ></i>
                </button>
                <span class="overlay-disabled-item"
                    ng-if="!isInstanceAdmin"
                    toggle="tooltip"
                    container="body"
                    title="Only instance administrators can check or create an API key">
                </span>
            </span>
        </div>
        `,controller:function($scope,$rootScope,$timeout,$filter,DataikuAPI,CreateModalFromTemplate,ClipboardUtils){const $ctrl=this;$scope.isInstanceAdmin=$rootScope.appConfig.admin;var getKeyDebounceTimeout;$scope.$watch("$ctrl.apiKey",function(nv){$scope.apiKeyWarning=false;$scope.apiKeyDescription="";if(nv&&$scope.isInstanceAdmin){if(getKeyDebounceTimeout){$timeout.cancel(getKeyDebounceTimeout)}getKeyDebounceTimeout=$timeout(function(){DataikuAPI.admin.publicApi.getGlobalKeyDetails(nv).then(function({data}){$scope.apiKeyDescription="Key Label: "+data.label+", Created on: "+$filter("friendlyDate")(data.createdOn,"d MMMM yyyy")}).catch(function(err){$scope.apiKeyDescription=err.data.detailedMessage;$scope.apiKeyWarning=true})},500)}else{$scope.apiKeyWarning=true;$scope.apiKeyDescription="No key defined"}});$scope.createGlobalApiKey=function(){let apiKey={label:$ctrl.newKeyLabel,description:$ctrl.newKeyDescription,globalPermissions:{admin:true}};DataikuAPI.admin.publicApi.createGlobalKey(apiKey).success(function(data){$scope.apiKeyWarning=false;$ctrl.apiKey=data.key;CreateModalFromTemplate("/templates/admin/security/new-api-key-modal.html",$scope,null,function(newScope){newScope.hashedApiKeysEnabled=$rootScope.appConfig.hashedApiKeysEnabled;newScope.key=data;newScope.copyKeyToClipboard=function(){ClipboardUtils.copyToClipboard(data.key,"Copied to clipboard.")};newScope.viewQRCode=function(){CreateModalFromTemplate("/templates/admin/security/api-key-qrcode-modal.html",$scope,null,function(newScope){newScope.apiKeyQRCode=JSON.stringify({k:data.key,u:$rootScope.appConfig.dssExternalURL})})}})}).error(setErrorInScope.bind($scope))}}})})();(function(){"use strict";const app=angular.module("dataiku.plugins",["dataiku.filters","dataiku.plugindev"]);app.filter("extractGitRefGroup",function(){return function(input){return input.split("/",2)[1]==="heads"?"Branch":"Tag"}});app.filter("extractGitRefName",function(){var namePattern=/(?:.+?\/){2}(.+)$/;return function(input){let match;if(match=namePattern.exec(input)){return match[1]}else{return input}}});app.directive("pluginContributionList",function(){return{restrict:"E",templateUrl:"/templates/plugins/modals/plugin-contribution-list.html",scope:{pluginContent:"="}}});app.directive("checkNewPluginIdUnique",function(){return{require:"ngModel",scope:true,link:function(scope,elem,attrs,ngModel){function apply_validation(value){ngModel.$setValidity("uniqueness",true);if(value==null||value.length===0)return value;var valid=true;if(scope.uniquePluginIds){valid=scope.uniquePluginIds.indexOf(value)<0}ngModel.$setValidity("uniqueness",valid);return value}ngModel.$parsers.unshift(apply_validation);ngModel.$formatters.unshift(function(value){apply_validation(value);return value})}}});app.service("PluginUtils",function(){const utils=this;utils.isDataikuPlugin=function(author){return author&&author.includes("Dataiku")};utils.removeAuthors=function(author){return author.replace(/\s*\(.*?\)\s*$/,"")};utils.getProvider=function(author){return utils.isDataikuPlugin(author)?utils.removeAuthors(author):author};utils.extractAuthors=function(author){const match=author.match(/\((.*?)\)$/);return match?match[1]:""};utils.getAuthors=function(author){if(!author)return author;return utils.isDataikuPlugin(author)?utils.extractAuthors(author):author};utils.hasAuthors=function(author){return utils.isDataikuPlugin(author)&&!!utils.extractAuthors(author)}});app.service("PluginRequestService",function(DataikuAPI,CreateModalFromTemplate,RequestCenterService,$rootScope,Assert){function checkForPreviousPluginRequest(modalScope,errorScope,pluginId){modalScope.hasPreviousRequest=false;modalScope.latestRequest={};if(modalScope.appConfig.admin)return;DataikuAPI.requests.getLatestRequestForCurrentUser(pluginId,"PLUGIN","").then(response=>{if(response.data.status==="PENDING"||modalScope.queryRequestType==="INSTALL_PLUGIN"&&response.data.status==="APPROVED"){modalScope.hasPreviousRequest=true;modalScope.latestRequest=response.data}},error=>{if(error.status!==404){setErrorInScope.bind(errorScope)(error)}})}function openPluginRequestModal(parentScope,plugin,mode){const isUpdate=mode==="UPDATE";CreateModalFromTemplate("/templates/plugins/modals/plugin-install-request.html",parentScope,null,function(newScope){newScope.plugin=plugin;newScope.ui={message:""};newScope.requestType=isUpdate?"update":"install";newScope.queryRequestType=isUpdate?"UPDATE_PLUGIN":"INSTALL_PLUGIN";newScope.storePlugin=plugin.storeDesc;newScope.isDevPlugin=plugin?.installedDesc?.origin==="DEV";checkForPreviousPluginRequest(newScope,parentScope,plugin.id);if(!isUpdate){parentScope.refreshList(true)}newScope.sendRequest=requestMessage=>{DataikuAPI.requests.createPluginRequest(newScope.queryRequestType,plugin.id,newScope.ui.message).success(data=>{RequestCenterService.WT1Events.onRequestSent("PLUGIN",null,plugin.id,requestMessage,data.id)}).error(setErrorInScope.bind(parentScope));newScope.dismiss();$rootScope.$broadcast("dismissModals")}})}return{requestInstall(plugin,scope){Assert.trueish(plugin.inStore,"Plugin not in store");openPluginRequestModal(scope,plugin,"INSTALL")},requestUpdate(plugin,scope){plugin.id=plugin.installedDesc.desc.id;openPluginRequestModal(scope,plugin,"UPDATE")},checkForPreviousPluginRequest:checkForPreviousPluginRequest}});app.controller("PluginController",function($scope,$controller,$state,$stateParams,DataikuAPI,CreateModalFromTemplate,SpinnerService,TopNav,Assert,FutureWatcher,WT1){TopNav.setLocation(TopNav.DSS_HOME,"plugin");$scope.pluginsUIState=$scope.pluginsUIState||{};$controller("PlugindevCommonController",{$scope:$scope});$scope.isInstallingOrUpdatingPlugin=function(){return $state.includes("plugin.installation")||$state.includes("plugin.installationfromgit")||$state.includes("plugin.update")||$state.includes("plugin.upload")||$state.includes("plugin.upload.update")||$state.includes("plugin.updatefromgit")};$scope.pluginCanBeUninstalled=function(){if(!$scope.pluginData)return false;return $scope.pluginData.installedDesc.origin!=="BUILTIN"&&$scope.pluginData.installedDesc.origin!=="DEV"};$scope.pluginCanBeMovedToDev=function(){if(!$scope.pluginData)return false;return $scope.pluginData.installedDesc.origin!="BUILTIN"};$scope.moveToDev=function(){CreateModalFromTemplate("/templates/plugins/modals/move-plugin-to-dev.html",$scope,null,function(modalScope){modalScope.go=function(){const pluginId=$scope.pluginData.installedDesc.desc.id;const pluginVersion=$scope.pluginData.installedDesc.desc.version;SpinnerService.lockOnPromise(DataikuAPI.plugins.moveToDev(pluginId).success(function(data){if(!data.success){WT1.event("plugin-move-to-dev",{pluginId:pluginId,pluginVersion:pluginVersion,success:"FAILED"});$scope.installationError=data.installationError}else{WT1.event("plugin-move-to-dev",{pluginId:pluginId,pluginVersion:pluginVersion,success:"DONE"});$state.transitionTo("plugindev.definition",{pluginId:pluginId})}}).error(setErrorInScope.bind($scope)))}})};$scope.getPlugin=function(){DataikuAPI.plugins.get($stateParams.pluginId).then(function(data){$scope.pluginData=data.data;$scope.initContentTypeList($scope.pluginData)},setErrorInScope.bind($scope))};$scope.previewUninstallPlugin=function(){Assert.trueish($scope.pluginData.installedDesc.origin!=="BUILTIN","Plugin is BUILTIN");Assert.trueish($scope.pluginData.installedDesc.origin!=="DEV","Plugin is DEV");var handlePluginDeleted=function(pluginId,pluginVersion){WT1.event("plugin-delete",{pluginId:pluginId,pluginVersion:pluginVersion});$state.transitionTo("plugins.installed")};var handlePluginDeletionFailed=function(data,status,headers){$scope.state="FAILED";$scope.failure={message:getErrorDetails(data,status,headers).detailedMessage}};CreateModalFromTemplate("/templates/plugins/modals/uninstall-plugin-confirm.html",$scope,null,function(newScope){const pluginId=$scope.pluginData.installedDesc.desc.id;const pluginVersion=$scope.pluginData.installedDesc.desc.version;DataikuAPI.plugins.prepareDelete(pluginId).success(function(usageStatistics){newScope.pluginId=pluginId;newScope.pluginName=$scope.pluginData.installedDesc.desc.meta.label;newScope.usageStatistics=usageStatistics;newScope.confirmPluginUninstall=function(){DataikuAPI.plugins.delete(pluginId,true).success(function(initialResponse){if(initialResponse&&initialResponse.jobId&&!initialResponse.hasResult){FutureWatcher.watchJobId(initialResponse.jobId).success(function(){handlePluginDeleted(pluginId,pluginVersion)}).error(handlePluginDeletionFailed)}else{handlePluginDeleted(pluginId,pluginVersion)}}).error(handlePluginDeletionFailed)}})})};$scope.validatePluginEnv=function(){$scope.pluginEnvUpToDate=true};$scope.invalidatePluginEnv=function(){$scope.pluginEnvUpToDate=false};if($scope.isInstallingOrUpdatingPlugin()){$scope.pluginLabel=$stateParams.pluginId}if(!$scope.isInstallingOrUpdatingPlugin()){$scope.getPlugin()}});app.controller("PluginSummaryController",function($scope,$filter,$stateParams,$state,$rootScope,DataikuAPI,CreateModalFromTemplate,RequestCenterService,Assert,PluginUtils,SemanticVersionService,PluginRequestService){$scope.updatePlugin=function(){if($rootScope.appConfig.admin){$state.transitionTo("plugin.update",{pluginId:$stateParams.pluginId,pluginVersion:$scope.pluginData.storeDesc.storeVersion})}};$scope.isDevPlugin=function(){return $scope.pluginData.installedDesc&&$scope.pluginData.installedDesc.origin==="DEV"};$scope.updateAvailable=$scope.updateAvailable||false;function updateAvailable(){const installed=$scope.pluginData?.installedDesc?.desc;const store=$scope.pluginData?.storeDesc;return installed&&store&&store.storeFlags?.downloadable===true&&store.storeVersion&&installed.version&&SemanticVersionService.compareVersions(store.storeVersion,installed.version)>0}$scope.canUpdate=$scope.canUpdate||false;function canUpdate(){return $scope.updateAvailable&&$rootScope.appConfig.admin}$scope.canRequestUpdate=$scope.canRequestUpdate||false;function canRequestUpdate(){return $scope.updateAvailable&&!$rootScope.appConfig.admin&&$rootScope.appConfig.pluginInstallRequestsEnabled}$scope.getPlugin=function(){return DataikuAPI.plugins.get($stateParams.pluginId).then(function(data){$scope.pluginData=data.data;$scope.initContentTypeList($scope.pluginData)},setErrorInScope.bind($scope))};$scope.requestUpdatePlugin=function(plugin){$scope.getPlugin().then(()=>{$scope.pluginData.installedDesc.origin="STORE";Assert.trueish($scope.pluginData.installedDesc.origin==="STORE","Plugin not in store");PluginRequestService.requestUpdate($scope.pluginData,$scope)})};$scope.filterQuery={userQuery:""};$scope.filteredContent={};function filterContent(pluginInstallDesc){let filteredContent={};let types=$scope.getComponentsTypeList(pluginInstallDesc);types.forEach(function(type){let filteredComponents=$filter("filter")(pluginInstallDesc.content[type],$scope.filterQuery.userQuery);if(filteredComponents.length){filteredContent[type]=filteredComponents}});if(pluginInstallDesc.desc.featureFlags){const matchingFeatureFlag=$filter("filter")(pluginInstallDesc.desc.featureFlags,$scope.filterQuery.userQuery);if(matchingFeatureFlag.length>0){filteredContent["featureFlags"]=$filter("filter")(pluginInstallDesc.desc.featureFlags,$scope.filterQuery.userQuery);filteredContent["featureFlags"]=filteredContent["featureFlags"].map(featureFlag=>({id:featureFlag}))}}return filteredContent}function filterContentOnChange(){let pluginData=$scope.pluginData;if(pluginData&&pluginData.installedDesc.content){$scope.filteredContent=filterContent(pluginData.installedDesc)}else{$scope.filteredContent={}}}$scope.filterAuthor=PluginUtils.filterAuthor;$scope.getAuthors=PluginUtils.getAuthors;$scope.getProvider=PluginUtils.getProvider;$scope.isDataikuPlugin=PluginUtils.isDataikuPlugin;$scope.hasAuthors=PluginUtils.hasAuthors;$scope.$watch("pluginData",function(newVal,oldVal){if(newVal!==oldVal){$scope.updateAvailable=updateAvailable();$scope.canUpdate=canUpdate();$scope.canRequestUpdate=canRequestUpdate()}filterContentOnChange()},true);$scope.$watch("filterQuery.userQuery",filterContentOnChange,true);$scope.getComponentsTypeListFiltered=function(){return Object.keys($scope.filteredContent)}});app.controller("PluginSettingsController",function($scope,PluginConfigUtils,DataikuAPI,WT1,$stateParams,CreateModalFromTemplate,Dialogs,PermissionsDataFetcher){$scope.pluginsUIState=$scope.pluginsUIState||{};$scope.pluginsUIState.settingsPane=$stateParams.selectedTab||"parameters";$scope.permissionsDataFetcher=PermissionsDataFetcher($scope);$scope.hooks={};$scope.setPluginSettings=function(settings){$scope.originalPluginSettings=settings;$scope.pluginSettings=angular.copy($scope.originalPluginSettings);if($scope.hooks.settingsSet){$scope.hooks.settingsSet()}};function refreshPluginDesc(){if(!$stateParams.pluginId||$scope.installed){return}DataikuAPI.plugins.get($stateParams.pluginId,$scope.projectKey).success(function(data){$scope.installed=data.installedDesc;if($scope.installed.desc.params&&data.settings.config){PluginConfigUtils.setDefaultValues($scope.installed.desc.params,data.settings.config)}$scope.setPluginSettings(data.settings)}).error(setErrorInScope.bind($scope))}refreshPluginDesc();$scope.savePluginSettings=function(projectKey){DataikuAPI.plugins.saveSettings($scope.pluginData.installedDesc.desc.id,projectKey,$scope.pluginSettings).success(function(data){if(data.error){Dialogs.infoMessagesDisplayOnly($scope,"Update result",data)}else{$scope.originalPluginSettings=angular.copy($scope.pluginSettings);$scope.pluginData.settings=$scope.originalPluginSettings;WT1.event("plugin-settings-changed",{pluginId:$scope.pluginData.installedDesc.desc.id})}}).error(setErrorInScope.bind($scope))};$scope.getParameterSetDesc=function(type){return $scope.installed.customParameterSets.filter(function(parameterSetDesc){return parameterSetDesc.elementType==type})[0]};$scope.getAppTemplateDesc=function(type){return $scope.installed.customAppTemplates.filter(function(appTemplateDesc){return appTemplateDesc.elementType==type})[0]};$scope.deletePreset=function(preset){let index=$scope.pluginSettings.presets.indexOf(preset);if(index>=0){$scope.pluginSettings.presets.splice(index,1)}};$scope.createPreset=function(){CreateModalFromTemplate("/templates/plugins/modals/new-preset.html",$scope,"NewPresetController")};$scope.isPluginSettingsFormsInvalid=function(){return $scope.pluginSettingsForms.$invalid};$scope.dirtyPluginSettings=function(){return $scope.originalPluginSettings!==null&&!angular.equals($scope.originalPluginSettings,$scope.pluginSettings)};$scope.$watch("pluginData",function(nv){if(nv&&$scope.pluginData&&$scope.pluginData.installedDesc.desc&&$scope.pluginData.installedDesc.desc.params){PluginConfigUtils.setDefaultValues($scope.pluginData.installedDesc.desc.params,$scope.pluginData.settings.config);$scope.pluginSettings=angular.copy($scope.pluginData.settings)}});$scope.presetsByParameterSet={};$scope.hooks.settingsSet=function(){$scope.presetsByParameterSet={};$scope.pluginSettings.parameterSets.forEach(function(parameterSet){$scope.presetsByParameterSet[parameterSet.name]=[]});$scope.pluginSettings.presets.forEach(function(preset){let parameterSet=$scope.pluginSettings.parameterSets.filter(function(parameterSet){return parameterSet.type==preset.type})[0];if(parameterSet){$scope.presetsByParameterSet[parameterSet.name].push(preset)}})};checkChangesBeforeLeaving($scope,$scope.dirtyPluginSettings)});app.controller("PluginUsagesController",function($scope,DataikuAPI,StateUtils){$scope.getUsages=function(projectKey){DataikuAPI.plugins.getUsages($scope.pluginData.installedDesc.desc.id,projectKey).success(function(data){$scope.pluginUsages=data;$scope.pluginUsages.columns=["Kind","Component","Type","Project","Object"];$scope.pluginUsages.columnWidths=[50,100,50,100,100];$scope.pluginUsages.shownHeight=10+25*(1+Math.min(10,$scope.pluginUsages.usages.length))}).error(setErrorInScope.bind($scope))};$scope.computeUsageLink=function(usage){return StateUtils.href.dssObject(usage.objectType.toUpperCase(),usage.objectId,usage.projectKey)}});app.directive("pluginRequirements",function(DataikuAPI,$rootScope,Dialogs,MonoFuture,WT1){return{restrict:"A",templateUrl:"/templates/plugins/plugin-requirements.html",scope:{pluginDesc:"=",settings:"=",onValid:"=",onInvalid:"="},link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;$scope.checkValidity=function(){if(!$scope.onValid&&!$scope.onInvalid){return}const codeEnvOk=!$scope.pluginDesc.frontendRequirements.codeEnvLanguage||$scope.settings.codeEnvName!==undefined;const pythonDepsOK=$scope.pluginDesc.frontendRequirements.pythonPackages.length===0||$scope.pluginDesc.frontendRequirements.pythonInstalled;const rDepsOk=$scope.pluginDesc.frontendRequirements.rPackages.length===0||$scope.pluginDesc.frontendRequirements.rInstalled;const customInstallOk=!$scope.pluginDesc.frontendRequirements.installScriptCommand||$scope.pluginDesc.frontendRequirements.customInstalled;if(codeEnvOk&&pythonDepsOK&&rDepsOk&&customInstallOk){$scope.onValid&&$scope.onValid()}else{$scope.onInvalid&&$scope.onInvalid()}};$scope.useCodeEnv=function(envName){DataikuAPI.plugins.useCodeEnv($scope.pluginDesc.desc.id,envName).success(function(data){WT1.event("plugin-settings-changed",{pluginId:$scope.pluginId});$scope.settings.codeEnvName=envName;$scope.checkValidity()}).error(function(){setErrorInScope.apply($scope,arguments);$scope.onInvalid&&$scope.onInvalid()})};$scope.codeEnvs=[];if($scope.pluginDesc.codeEnvLang){$scope.listCodeEnvs=function(){DataikuAPI.codeenvs.listForPlugins($scope.pluginDesc.desc.id).success(function(data){$scope.codeEnvs=data;$scope.checkValidity()}).error(function(){setErrorInScope.apply($scope,arguments);$scope.onInvalid&&$scope.onInvalid()})};$scope.listCodeEnvs()}$scope.installingFuture=null;function go(type){$scope.failure=null;$scope.installationLog=null;$scope.installationResult=null;MonoFuture($scope).wrap(DataikuAPI.plugins.installRequirements)($scope.pluginDesc.desc.id,type).success(function(data){$scope.state=data.result.success?"DONE":"FAILED";WT1.event("plugin-requirement-install",{success:$scope.state,type:type});$scope.installationResult=data.result;$scope.installationLog=data.log;$scope.installingFuture=null;if(data.result.success){$scope.pluginDesc.frontendRequirements.pythonInstalled=$scope.pluginDesc.frontendRequirements.pythonInstalled||type=="PYTHON";$scope.pluginDesc.frontendRequirements.rInstalled=$scope.pluginDesc.frontendRequirements.rInstalled||type=="R";$scope.pluginDesc.frontendRequirements.customInstalled=$scope.pluginDesc.frontendRequirements.customInstalled||type=="CUSTOM_SCRIPT";$scope.checkValidity()}else{$scope.onInvalid&&$scope.onInvalid()}}).update(function(data){$scope.state="RUNNING";$scope.installingFuture=data;$scope.installationLog=data.log}).error(function(data,status,headers){$scope.state="FAILED";if(data.aborted){$scope.failure={message:"Aborted"}}else if(data.hasResult){$scope.installationResult=data.result}else{$scope.failure={message:"Unexpected error"}}$scope.installingFuture=null;$scope.onInvalid&&$scope.onInvalid()})}$scope.abort=function(){$scope.state="FAILED";$scope.failure={message:"Aborted"};DataikuAPI.futures.abort($scope.installingFuture.jobId);$scope.onInvalid&&$scope.onInvalid()};$scope.installRequirements=function(type){var message="";if($scope.pluginDesc.frontendRequirements.disclaimer){message=$scope.pluginDesc.frontendRequirements.disclaimer}else{let envType="";if(type=="PYTHON")envType="the Python environment on ";if(type=="R")envType="the R environment on ";if(type=="CUSTOM_SCRIPT")envType="";message="This operation will alter the setup of "+envType+"the machine running the DSS server, and cannot be reverted."}Dialogs.confirmDisclaimer($scope,"Dependencies installation","Are you sure you want to install these dependencies?",message).then(function(){go(type)})};$scope.checkValidity()}}});app.directive("pluginCodeEnv",function(DataikuAPI,Dialogs,WT1,FutureProgressModal,$rootScope,MonoFuture,CodeEnvService){return{restrict:"A",templateUrl:"/templates/plugins/modals/plugin-code-env.html",scope:{pluginDesc:"=",settings:"=",onValid:"=",onInvalid:"="},link:function($scope,element,attrs){$scope.uiState={state:"DISPLAY"};$scope.addLicInfo=$rootScope.addLicInfo;$scope.newEnv={deploymentMode:"PLUGIN_MANAGED",pythonInterpreter:"PYTHON39",allContainerConfs:false,containerConfs:[],allSparkKubernetesConfs:false,sparkKubernetesConfs:[],rebuildDependentCodeStudioTemplates:"NONE"};$scope.defaultInterpreterFound=false;const getPluginDefaultAvailableInterpreter=codeEnvLang=>{if(codeEnvLang!=="PYTHON"){return}return DataikuAPI.codeenvs.getPluginDefaultAvailableInterpreter($scope.pluginDesc.desc.id).success(data=>{$scope.newEnv.pythonInterpreter=data;$scope.defaultInterpreterFound=true}).error(function(){$scope.defaultInterpreterFound=true;setErrorInScope.apply($scope,arguments)})};$scope.$watch("pluginDesc.codeEnvLang",getPluginDefaultAvailableInterpreter);$scope.useCodeEnv=function(envName,nextState){const handleError=(...args)=>{setErrorInScope.apply($scope,args);$scope.onInvalid&&$scope.onInvalid()};const handleSuccess=()=>{$scope.settings.codeEnvName=envName;$scope.uiState.state=nextState||"DISPLAY";$scope.onValid&&$scope.onValid()};DataikuAPI.plugins.useCodeEnv($scope.pluginDesc.desc.id,envName).success(function(data){WT1.event("plugin-settings-changed",{pluginId:$scope.pluginDesc.desc.id});if(data&&data.jobId){FutureProgressModal.show($scope,data,"Rebuilding container image",undefined,"static",false,true).then(function(result){Dialogs.infoMessagesDisplayOnly($scope,"Build result",result,result.futureLog,undefined,"static",false);handleSuccess()})}else{handleSuccess()}}).error(handleError)};$scope.containerNames=[];DataikuAPI.containers.listNames(null,"USER_CODE").success(function(data){$scope.containerNames=data}).error(function(){$scope.onInvalid&&$scope.onInvalid();setErrorInScope.apply($scope,arguments)});$scope.sparkKubernetesNames=[];DataikuAPI.containers.listSparkNames().success(function(data){$scope.sparkKubernetesNames=data}).error(function(){$scope.onInvalid&&$scope.onInvalid();setErrorInScope.apply($scope,arguments)});$scope.codeEnvs=[];$scope.listCodeEnvs=function(){DataikuAPI.codeenvs.listForPlugins($scope.pluginDesc.desc.id).success(function(data){$scope.codeEnvs=data;if(!$scope.settings.codeEnvName&&$scope.codeEnvs.length){$scope.uiState.state="SELECT"}else if(!$scope.settings.codeEnvName){$scope.uiState.state="CREATE"}}).error(function(){$scope.onInvalid&&$scope.onInvalid();setErrorInScope.apply($scope,arguments)})};$scope.listCodeEnvs();$scope.isCurrentSelectedEnvUpToDate=function(){if(!$scope.settings.codeEnvName)return true;var env=$scope.codeEnvs.filter(function(e){return e.envName==$scope.settings.codeEnvName})[0];if(env==null)return true;return env.isUptodate};$scope.codeEnvDeploymentModes=[["PLUGIN_MANAGED","Managed by DSS (recommended)"],["PLUGIN_NON_MANAGED","Managed manually"]];$scope.possiblePythonInterpreters=[];if($scope.pluginDesc.codeEnvSpec){const codeEnvSpec=$scope.pluginDesc.codeEnvSpec;if(!codeEnvSpec.forceConda){$scope.possiblePythonInterpreters=$scope.possiblePythonInterpreters.concat(["CUSTOM"])}if(codeEnvSpec.acceptedPythonInterpreters&&codeEnvSpec.acceptedPythonInterpreters.length>0){$scope.possiblePythonInterpreters=$scope.possiblePythonInterpreters.concat(codeEnvSpec.acceptedPythonInterpreters);$scope.newEnv.pythonInterpreter=codeEnvSpec.acceptedPythonInterpreters[0]}}CodeEnvService.getPythonInterpreters().then(function(enrichedInterpreters){const allowed=new Set($scope.possiblePythonInterpreters);$scope.enrichedPossiblePythonInterpreters=enrichedInterpreters.filter(i=>allowed.has(i[0]))});$scope.buildNewCodeEnv=function(newEnv){DataikuAPI.codeenvs.createForPlugin($scope.pluginDesc.desc.id,newEnv,true).success(function(data){FutureProgressModal.show($scope,data,"Environment creation",undefined,"static",false,true).then(function(result){Dialogs.infoMessagesDisplayOnly($scope,"Creation result",result.messages,result.futureLog,undefined,"static",false);$scope.listCodeEnvs();const isCodeEnvImported=result.messages&&result.messages.messages&&result.messages.messages.findIndex(message=>message.code==="INFO_CODEENV_IMPORT_OK")>-1;if(result.messages.error&&!isCodeEnvImported){$scope.onInvalid&&$scope.onInvalid()}else{if(result.envName){$scope.settings.codeEnvName=result.envName;$scope.uiState.state="DISPLAY"}$scope.onValid&&$scope.onValid()}})}).error(function(){$scope.onInvalid&&$scope.onInvalid();setErrorInScope.apply($scope,arguments)})};$scope.updateCodeEnv=function(envName){DataikuAPI.codeenvs.updateForPlugin($scope.pluginDesc.desc.id,envName).success(function(data){FutureProgressModal.show($scope,data,"Environment update").then(function(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result.messages,result.futureLog);$scope.listCodeEnvs()})}).error(function(){$scope.onInvalid&&$scope.onInvalid();setErrorInScope.apply($scope,arguments)})}}}});app.controller("PluginsExploreController",function($rootScope,$scope,$controller,DataikuAPI,$state,Assert,CreateModalFromTemplate,WT1,TopNav,FutureWatcher,FutureProgressModal,Dialogs,RequestCenterService,SemanticVersionService,PluginUtils,PluginRequestService){$controller("PlugindevCommonController",{$scope:$scope});$scope.SemanticVersionService=SemanticVersionService;TopNav.setLocation(TopNav.DSS_HOME,"plugins");$scope.pluginsUIState={filteredStorePlugins:{},filteredInstalledPlugins:{},filteredDevelopmentPlugins:{},searchQuery:"",storeTags:new Map,storeTagsQuery:[],storeInstallationStatusQuery:[],installedTags:new Map,installedTagsQuery:[],developmentTags:new Map,developmentTagsQuery:[],showAllStoreTags:false,showAllInstalledTags:false,showAllDevelopmentTags:false,storeSupportLevelQuery:[],installedSupportLevelQuery:[],storeInstallationStatusCount:new Map,storeSupportLevelsCount:new Map,installedSupportLevelsCount:new Map};$scope.pluginsUIState.supportLevels=[{value:"SUPPORTED",label:"Supported",icon:"icon-dku-supported"},{value:"TIER2_SUPPORT",label:"Tier 2 Support",icon:"icon-dku-half-supported"}];$scope.uploadedPlugin={isUpdate:false};$scope.clonePlugin={devMode:false,bootstrapMode:"GIT_CLONE",path:null,customCheckout:true};function toggleShowAllTags(tab){$scope.pluginsUIState["showAll"+tab+"Tags"]=!$scope.pluginsUIState["showAll"+tab+"Tags"]}function extractPluginIdFromUrl(pluginUri){if(!pluginUri){return"custom-plugin"}const sshPattern=/git@github\.com:dataiku\/dss-plugin-(.*)\.git/;const httpPattern=/https:\/\/github\.com\/dataiku\/dss-plugin-(.*)\.git/;const sshMatch=pluginUri.match(sshPattern);const httpMatch=pluginUri.match(httpPattern);if(sshMatch){return sshMatch[1]}else if(httpMatch){return httpMatch[1]}return"custom-plugin"}$scope.toggleShowAllStoreTags=toggleShowAllTags.bind(this,"Store");$scope.toggleShowAllInstalledTags=toggleShowAllTags.bind(this,"Installed");$scope.toggleShowAllDevelopmentTags=toggleShowAllTags.bind(this,"Development");$scope.installPlugin=function(pluginToInstall,isUpdate){if($rootScope.appConfig.admin&&pluginToInstall){if(isUpdate===true){$state.transitionTo("plugin.update",{pluginId:pluginToInstall.id,pluginVersion:pluginToInstall.storeVersion})}else{$state.transitionTo("plugin.installation",{pluginId:pluginToInstall.id,pluginVersion:pluginToInstall.storeVersion})}$scope.dismiss&&$scope.dismiss()}};$scope.triggerRestart=function(){DataikuAPI.plugins.triggerRestart().success(function(data){}).error(function(){})};$scope.getStoreSupportLevelCount=function(supportLevelValue){return $scope.pluginsUIState.storeSupportLevelsCount.get(supportLevelValue)||0};$scope.getInstalledSupportLevelCount=function(supportLevelValue){return $scope.pluginsUIState.installedSupportLevelsCount.get(supportLevelValue)||0};$scope.toggleStoreInstallationStatusFilter=function(installationStatus,event){const installationStatusQuery=$scope.pluginsUIState.storeInstallationStatusQuery;const statusPosition=installationStatusQuery.indexOf(installationStatus);if(statusPosition>-1){installationStatusQuery.splice(statusPosition,1)}else{if(installationStatusQuery.length>0){installationStatusQuery.splice(0,1);event.preventDefault()}else{installationStatusQuery.push(installationStatus)}}};$scope.isStoreInstallationStatusSelected=function(installationStatus){return $scope.pluginsUIState.storeInstallationStatusQuery.includes(installationStatus)};$scope.getStoreInstallationStatusCount=function(installationStatus){return $scope.pluginsUIState.storeInstallationStatusCount.get(installationStatus)||0};function toggleSupportFilter(supportLevel,tab){const supportLevelQuery=$scope.pluginsUIState[tab+"SupportLevelQuery"];let supportLevelPosition=supportLevelQuery.indexOf(supportLevel);if(supportLevelPosition>-1){supportLevelQuery.splice(supportLevelPosition,1)}else{supportLevelQuery.push(supportLevel)}}$scope.toggleStoreSupportFilter=function(supportLevel){toggleSupportFilter(supportLevel,"store")};$scope.toggleInstalledSupportFilter=function(supportLevel){toggleSupportFilter(supportLevel,"installed")};$scope.isStoreSupportLevelSelected=function(supportName){return $scope.pluginsUIState.storeSupportLevelQuery.includes(supportName)};$scope.isInstalledSupportLevelSelected=function(supportName){return $scope.pluginsUIState.installedSupportLevelQuery.includes(supportName)};function toggleTagQuery(tagName,tab){const tagsQuery=$scope.pluginsUIState[tab+"TagsQuery"];const tagPosition=tagsQuery.indexOf(tagName);if(tagPosition>-1){tagsQuery.splice(tagPosition,1)}else{tagsQuery.push(tagName)}}$scope.toggleStoreTagQuery=function(tagName){toggleTagQuery(tagName,"store")};$scope.toggleInstalledTagQuery=function(tagName){toggleTagQuery(tagName,"installed")};$scope.toggleDevelopmentTagQuery=function(tagName){toggleTagQuery(tagName,"development")};$scope.isStoreTagSelected=function(tagName){return $scope.pluginsUIState.storeTagsQuery.includes(tagName)};$scope.isInstalledTagSelected=function(tagName){return $scope.pluginsUIState.installedTagsQuery.includes(tagName)};$scope.isDevelopmentTagSelected=function(tagName){return $scope.pluginsUIState.developmentTagsQuery.includes(tagName)};$scope.resetStoreInstallationStatusQuery=function(){$scope.pluginsUIState.storeInstallationStatusQuery=[]};function resetTagsQuery(tab){$scope.pluginsUIState[tab+"TagsQuery"]=[]}$scope.resetStoreTagsQuery=function(){resetTagsQuery("store")};$scope.resetInstalledTagsQuery=function(){resetTagsQuery("installed")};$scope.resetDevelopmentTagsQuery=function(){resetTagsQuery("development")};function resetSupportLevelQuery(tab){$scope.pluginsUIState[tab+"SupportLevelQuery"]=[]}$scope.resetStoreSupportLevelQuery=function(){resetSupportLevelQuery("store")};$scope.resetInstalledSupportLevelQuery=function(){resetSupportLevelQuery("installed")};$scope.resetStoreQuery=function(){$scope.resetStoreTagsQuery();$scope.resetStoreSupportLevelQuery();$scope.$evalAsync(()=>{$scope.pluginsUIState.searchQuery=""})};$scope.resetInstalledQuery=function(){$scope.resetInstalledTagsQuery();$scope.resetInstalledSupportLevelQuery();$scope.$evalAsync(()=>{$scope.pluginsUIState.searchQuery=""})};$scope.resetDevelopmentQuery=function(){$scope.resetDevelopmentTagsQuery();$scope.$evalAsync(()=>{$scope.pluginsUIState.searchQuery=""})};$scope.reloadAllPlugins=function(){Dialogs.confirmSimple($scope,"Reload all plugins?").then(function(){DataikuAPI.plugindev.reloadAll().success(_=>$scope.refreshList()).error(setErrorInScope.bind($scope))})};function filterPluginsByInstallationStatus(){return function(plugin){const installationStatusList=$scope.pluginsUIState.storeInstallationStatusQuery;const hasUserFiltered=installationStatusList&&installationStatusList.length>0;if(!hasUserFiltered){return true}return installationStatusList.includes(plugin.installed)}}$scope.filterStorePluginsByInstallationStatus=filterPluginsByInstallationStatus.bind(this);function filterPluginsBySupportLevel(tab,supportKey){return function(plugin){const supportList=$scope.pluginsUIState[tab+"SupportLevelQuery"];const pluginSupportLevel=resolveValue(plugin,supportKey);const hasUserFiltered=supportList&&supportList.length>0;const hasSupportLevel=pluginSupportLevel&&pluginSupportLevel.length>=0;if(!hasUserFiltered){return true}if(!hasSupportLevel){return false}return supportList.includes(pluginSupportLevel)}}$scope.filterStorePluginsBySupportLevel=filterPluginsBySupportLevel.bind(this,"store","storeDesc.meta.supportLevel");$scope.filterInstalledPluginsBySupportLevel=filterPluginsBySupportLevel.bind(this,"installed","installedDesc.desc.meta.supportLevel");$scope.removeAuthors=PluginUtils.removeAuthors;function filterPluginsByTags(tab,tagsKey){return function(plugin){const tagsList=$scope.pluginsUIState[tab+"TagsQuery"];const pluginTags=resolveValue(plugin,tagsKey);const hasUserFiltered=tagsList&&tagsList.length>0;const hasTags=pluginTags&&pluginTags.length>0;if(!hasUserFiltered){return true}if(!hasTags){return false}let containsATag=false;pluginTags.forEach(tag=>{tag=tag.split(" ").map(word=>{return word.charAt(0).toUpperCase()+word.slice(1)}).join(" ");if(tagsList.includes(tag)){containsATag=true}});return containsATag}}$scope.filterStorePluginsByTags=filterPluginsByTags.bind(this,"store","storeDesc.meta.tags");$scope.filterInstalledPluginsByTags=filterPluginsByTags.bind(this,"installed","installedDesc.desc.meta.tags");$scope.filterDevelopmentPluginsByTags=filterPluginsByTags.bind(this,"development","installedDesc.desc.meta.tags");$scope.hasNoResultsForStoreQuery=function(){const isListEmpty=$scope.pluginsUIState.filteredStorePlugins&&$scope.pluginsUIState.filteredStorePlugins.length===0;const hasSearched=$scope.pluginsUIState.searchQuery&&$scope.pluginsUIState.searchQuery.length;const hasFilteredTags=$scope.pluginsUIState.storeTagsQuery&&$scope.pluginsUIState.storeTagsQuery.length;const hasFilteredSupport=$scope.pluginsUIState.storeSupportLevelQuery&&$scope.pluginsUIState.storeSupportLevelQuery.length;const hasFiltered=hasSearched||hasFilteredTags||hasFilteredSupport;return isListEmpty&&hasFiltered};$scope.hasNoResultsForInstalledQuery=function(){const isListEmpty=$scope.pluginsUIState.filteredInstalledPlugins&&$scope.pluginsUIState.filteredInstalledPlugins.length===0;const hasSearched=$scope.pluginsUIState.searchQuery&&$scope.pluginsUIState.searchQuery.length;const hasFilteredTags=$scope.pluginsUIState.installedTagsQuery&&$scope.pluginsUIState.installedTagsQuery.length;const hasFilteredSupport=$scope.pluginsUIState.installedSupportLevelQuery&&$scope.pluginsUIState.installedSupportLevelQuery.length;const hasFiltered=hasSearched||hasFilteredTags||hasFilteredSupport;return isListEmpty&&hasFiltered};$scope.computePluginOrigin=function(plugin){let origin="";if(plugin.inStore===true){origin="Store"}else if(plugin.installedDesc.origin){if(plugin.installedDesc.origin==="INSTALLED"){if(plugin.installedDesc.gitState.enabled===true){origin="Git repository"}else{origin="Uploaded"}}else if(plugin.installedDesc.origin==="DEV"){origin="Local dev"}else{origin=plugin.installedDesc.origin}}else{origin=plugin.installedDesc.origin}return origin};$scope.refreshTags=function(){$scope.pluginsUIState.storeTags.clear();$scope.pluginsUIState.installedTags.clear();$scope.pluginsUIState.developmentTags.clear();$scope.pluginsUIState.storeSupportLevelsCount.clear();$scope.pluginsUIState.installedSupportLevelsCount.clear();$scope.pluginsUIState.storeInstallationStatusCount.clear();$scope.pluginsList.plugins.forEach(plugin=>{if(plugin.storeDesc){if($scope.pluginsUIState.storeInstallationStatusCount.has(plugin.installed)){$scope.pluginsUIState.storeInstallationStatusCount.set(plugin.installed,$scope.pluginsUIState.storeInstallationStatusCount.get(plugin.installed)+1)}else{$scope.pluginsUIState.storeInstallationStatusCount.set(plugin.installed,1)}const supportLevelValue=plugin.storeDesc.meta&&plugin.storeDesc.meta.supportLevel;if(supportLevelValue){if($scope.pluginsUIState.storeSupportLevelsCount.has(supportLevelValue)){$scope.pluginsUIState.storeSupportLevelsCount.set(supportLevelValue,$scope.pluginsUIState.storeSupportLevelsCount.get(supportLevelValue)+1)}else{$scope.pluginsUIState.storeSupportLevelsCount.set(supportLevelValue,1)}}plugin.storeDesc.meta&&plugin.storeDesc.meta.tags&&plugin.storeDesc.meta.tags.forEach(tag=>{tag=tag.split(" ").map(word=>{return word.charAt(0).toUpperCase()+word.slice(1)}).join(" ");if($scope.pluginsUIState.storeTags.has(tag)){$scope.pluginsUIState.storeTags.set(tag,$scope.pluginsUIState.storeTags.get(tag)+1)}else{$scope.pluginsUIState.storeTags.set(tag,1)}})}if(plugin.installedDesc){const supportLevelValue=plugin.installedDesc.desc.meta&&plugin.installedDesc.desc.meta.supportLevel;if(supportLevelValue){if($scope.pluginsUIState.installedSupportLevelsCount.has(supportLevelValue)){$scope.pluginsUIState.installedSupportLevelsCount.set(supportLevelValue,$scope.pluginsUIState.installedSupportLevelsCount.get(supportLevelValue)+1)}else{$scope.pluginsUIState.installedSupportLevelsCount.set(supportLevelValue,1)}}plugin.installedDesc.desc.meta&&plugin.installedDesc.desc.meta.tags&&plugin.installedDesc.desc.meta.tags.forEach(tag=>{tag=tag.split(" ").map(word=>{return word.charAt(0).toUpperCase()+word.slice(1)}).join(" ");if($scope.pluginsUIState.installedTags.has(tag)){$scope.pluginsUIState.installedTags.set(tag,$scope.pluginsUIState.installedTags.get(tag)+1)}else{$scope.pluginsUIState.installedTags.set(tag,1)}if(plugin.installedDesc.origin==="DEV"){if($scope.pluginsUIState.developmentTags.has(tag)){$scope.pluginsUIState.developmentTags.set(tag,$scope.pluginsUIState.developmentTags.get(tag)+1)}else{$scope.pluginsUIState.developmentTags.set(tag,1)}}})}});$scope.pluginsUIState.storeTags=new Map([...$scope.pluginsUIState.storeTags.entries()].sort((a,b)=>b[1]-a[1]));$scope.pluginsUIState.installedTags=new Map([...$scope.pluginsUIState.installedTags.entries()].sort((a,b)=>b[1]-a[1]));$scope.pluginsUIState.developmentTags=new Map([...$scope.pluginsUIState.developmentTags.entries()].sort((a,b)=>b[1]-a[1]))};$scope.refreshList=function(forceFetch){if($scope.pluginsList&&forceFetch===false){return}DataikuAPI.plugins.list(forceFetch).success(function(data){$scope.pluginsList=data;$scope.refreshTags();$scope.pluginsUIState.storePluginsCount=0;$scope.pluginsUIState.developedPluginsCount=0;$scope.pluginsUIState.installedPluginsCount=0;$scope.pluginsList.plugins.forEach(plugin=>{if(plugin.storeDesc){$scope.pluginsUIState.storePluginsCount++}if(plugin.installedDesc){$scope.pluginsUIState.installedPluginsCount++;if(plugin.installedDesc.origin==="DEV"){plugin.isDevPlugin=true;$scope.pluginsUIState.developedPluginsCount++}if(plugin.installedDesc.origin!=="BUILTIN"&&plugin.installedDesc.origin!=="DEV"){plugin.uninstallable=true}}if(plugin.installed&&plugin.installedDesc&&plugin.storeDesc&&plugin.storeDesc.storeFlags.downloadable===true&&plugin.storeDesc.storeVersion&&plugin.installedDesc.desc.version&&SemanticVersionService.compareVersions(plugin.storeDesc.storeVersion,plugin.installedDesc.desc.version)>0){plugin.updateAvailable=true}});const supportLevelMap={SUPPORTED:2,TIER2_SUPPORT:1,NOT_SUPPORTED:0,NONE:-1};function rank(plugin){const untagged=plugin.storeDesc?.meta?.tags.length>0?1:0;const updateAvailable=plugin.updateAvailable&&!plugin.isDevPlugin?1:0;const notInstalled=plugin.installed?0:1;const deprecated=plugin.storeDesc?.meta?.deprecated?0:1;const desc=plugin.storeDesc||{};const meta=desc.meta||{};const supportLevel=supportLevelMap[meta.supportLevel||"NONE"];return[deprecated,untagged,updateAvailable,notInstalled,supportLevel]}$scope.pluginsList.plugins.sort((a,b)=>rank(a)>rank(b)?-1:1)}).error(setErrorInScope.bind($scope))};$scope.previewInstallStorePlugin=function(plugin){Assert.trueish(plugin.inStore,"Plugin not in store");CreateModalFromTemplate("/templates/plugins/modals/plugin-install-preview.html",$scope,null,function(newScope){newScope.attachDownloadTo=$scope;newScope.isUpdate=plugin.installed;if(plugin.installed){newScope.installedVersion=plugin.installedDesc.desc.version}newScope.uiState={activeTab:"details"};$scope.initContentTypeList(plugin);newScope.storePlugin=plugin.storeDesc;newScope.contentTypes=Object.keys(newScope.storePlugin.content)})};$scope.installStorePlugin=function(plugin){Assert.trueish(plugin.inStore,"Plugin not in store");const isUpdate=plugin.installed;$scope.installPlugin(plugin.storeDesc,isUpdate)};$scope.previewUninstallPlugin=function(plugin){Assert.trueish(plugin.installedDesc.origin!=="BUILTIN","Plugin is BUILTIN");Assert.trueish(plugin.installedDesc.origin!=="DEV","Plugin is DEV");var handlePluginDeleted=function(pluginId,pluginVersion){WT1.event("plugin-delete",{pluginId:pluginId,pluginVersion:pluginVersion});$scope.reload()};var handlePluginDeletionFailed=function(data,status,headers){WT1.event("plugin-delete",{pluginId:plugin.id,pluginVersion:plugin.installedDesc.desc.version});$scope.reload()};CreateModalFromTemplate("/templates/plugins/modals/uninstall-plugin-confirm.html",$scope,null,function(newScope){DataikuAPI.plugins.prepareDelete(plugin.id).success(function(usageStatistics){newScope.pluginId=plugin.installedDesc.desc.id;newScope.pluginName=plugin.installedDesc.desc.meta.label;newScope.usageStatistics=usageStatistics;newScope.confirmPluginUninstall=function(){DataikuAPI.plugins.delete(plugin.id,true).success(function(initialResponse){if(initialResponse&&initialResponse.jobId&&!initialResponse.hasResult){FutureWatcher.watchJobId(initialResponse.jobId).success(function(){handlePluginDeleted(plugin.id,plugin.installedDesc.desc.version)}).error(handlePluginDeletionFailed)}else{handlePluginDeleted(plugin.id,plugin.installedDesc.desc.version)}}).error(handlePluginDeletionFailed)}}).error(setErrorInScope.bind($scope))})};$scope.isDataikuPlugin=PluginUtils.isDataikuPlugin;$scope.seePluginStoreDetails=function(plugin){Assert.trueish(plugin.inStore,"Plugin not in store");$scope.uiState={activeTab:"details"};let changeInProgress;$scope.$on("$stateChangeStart",function(){changeInProgress=true});$scope.$on("$stateChangeSuccess",function(){changeInProgress=false});const modal=CreateModalFromTemplate("/templates/plugins/modals/plugin-see-details.html",$scope,null,function(newScope){$state.go("plugins.store",Object.assign({},$state.params,{pluginid:plugin.id}),{notify:false});newScope.attachDownloadTo=$scope;newScope.isUpdate=plugin.installed;newScope.queryRequestType=plugin.installed?"UPDATE_PLUGIN":"INSTALL_PLUGIN";if(plugin.installed){newScope.installedVersion=plugin.installedDesc.desc.version}$scope.initContentTypeList(plugin);$scope.plugin=plugin;newScope.storePlugin=plugin.storeDesc;newScope.contentTypes=Object.keys(newScope.storePlugin.content);newScope.isDevPlugin=plugin.installedDesc&&plugin.installedDesc.origin==="DEV";newScope.getProvider=PluginUtils.getProvider;newScope.hasAuthors=PluginUtils.hasAuthors;newScope.getAuthors=PluginUtils.getAuthors;$scope.isDataikuPlugin=PluginUtils.isDataikuPlugin;newScope.advancedLLMMeshAllowed=$rootScope.appConfig.licensedFeatures.advancedLLMMeshAllowed;newScope.openAdvancedLLMMeshModal=function(forbiddenFeature){CreateModalFromTemplate("/templates/llm/advanced-llm-mesh-required.html",$rootScope,null,function(modalScope){modalScope.uiState={forbiddenFeature:forbiddenFeature}})};PluginRequestService.checkForPreviousPluginRequest(newScope,$scope,plugin.id)});modal.catch(()=>{if(!changeInProgress){$state.go("plugins.store",Object.assign({},$state.params,{pluginid:null}),{notify:false})}})};$scope.requestInstallPlugin=function(plugin){PluginRequestService.requestInstall(plugin,$scope)};$scope.newZippedPlugin=function(){CreateModalFromTemplate("/templates/plugins/modals/new-plugin-from-desktop.html",$scope)};$scope.newGitPlugin=function(){CreateModalFromTemplate("/templates/plugins/modals/new-plugin-from-git.html",$scope)};$scope.newDevPlugin=function(){CreateModalFromTemplate("/templates/plugins/development/new-devplugin.html",$scope)};$scope.uploadPlugin=function(){if($scope.uploadedPlugin.file&&$scope.uploadedPlugin.file!=""){let fileName=$scope.uploadedPlugin.file.name;if($scope.uploadedPlugin.isUpdate){$state.transitionTo("plugin.upload.update",{pluginId:fileName,uploadedPluginFile:$scope.uploadedPlugin.file})}else{$state.transitionTo("plugin.upload",{pluginId:fileName,uploadedPluginFile:$scope.uploadedPlugin.file})}}};$scope.previewPullPlugin=function(plugin){CreateModalFromTemplate("/templates/plugins/modals/plugin-preview-pull.html",$scope,null,function(newScope){newScope.attachDownloadTo=$scope;if(plugin.installed){newScope.installedVersion=plugin.installedDesc.desc.version}newScope.gitPlugin=angular.copy(plugin.installedDesc);newScope.update=()=>{$state.transitionTo("plugin.updatefromgit",{uri:newScope.gitPlugin.gitState.repository,checkout:newScope.gitPlugin.gitState.checkout,path:newScope.gitPlugin.gitState.path,pluginName:extractPluginIdFromUrl(newScope.gitPlugin.gitState.repository)})}})};$scope.cloneAndCreate=function(){const pluginName=extractPluginIdFromUrl($scope.clonePlugin.uri);if($scope.clonePlugin.devMode){DataikuAPI.plugindev.create("",$scope.clonePlugin.bootstrapMode,$scope.clonePlugin.uri,$scope.clonePlugin.checkout,$scope.clonePlugin.path).success(function(data){FutureProgressModal.show($scope,data,"Creating plugin",undefined,"static",false,true).then(function(result){if(result){WT1.event("plugin-dev-create",{pluginId:pluginName});$scope.goToDevPluginDetails(result.details)}})}).error(setErrorInScope.bind($scope))}else{$state.transitionTo("plugin.installationfromgit",{uri:$scope.clonePlugin.uri,checkout:$scope.clonePlugin.checkout,path:$scope.clonePlugin.path,pluginName:pluginName})}};$scope.reload=function(){location.reload()};$scope.refreshPluginLists=function(){$scope.refreshList(true)};$scope.goToPluginDetails=function(pluginId){$state.transitionTo("plugin.summary",{pluginId:pluginId},{reload:false})};$scope.goToDevPluginDetails=function(pluginId){$state.transitionTo("plugindev.definition",{pluginId:pluginId})};$scope.goToDevPluginEditor=function(pluginId){$state.transitionTo("plugindev.editor",{pluginId:pluginId})};$scope.deletePluginAndReloadPage=function(pluginDesc){$scope.deletePlugin(pluginDesc.id,pluginDesc.version,$scope.reload)};Mousetrap.bind("r l",function(){$scope.refreshList(true)});$scope.$on("$destroy",function(){Mousetrap.unbind("r l")});$scope.refreshList(false);if($state.is("plugins")){$state.transitionTo("plugins.store")}});app.controller("PluginsStoreController",($rootScope,$scope,$stateParams,SemanticVersionService)=>{let unwatchPluginsList=undefined;const displayPlugin=(pluginId=$stateParams.pluginid)=>{const pluginFound=$scope.pluginsList.plugins.find(p=>p.id===pluginId);if(pluginFound){$scope.seePluginStoreDetails(pluginFound)}};if($stateParams.pluginid){if($scope.pluginsList===undefined){unwatchPluginsList=$scope.$watch("pluginsList",newVal=>{if(!newVal){return}unwatchPluginsList();unwatchPluginsList=undefined;displayPlugin()})}else{displayPlugin()}}$scope.$on("$destroy",()=>{if(unwatchPluginsList){unwatchPluginsList()}});$scope.openPluginInfo=function(plugin){if(!plugin.installed){$scope.seePluginStoreDetails(plugin)}else{const canDevelopPlugin=$rootScope.appConfig?.admin||$rootScope.appConfig?.globalPermissions?.mayDevelopPlugins;if(plugin.isDevPlugin&&canDevelopPlugin){$scope.goToDevPluginDetails(plugin.installedDesc.desc.id)}else{$scope.goToPluginDetails(plugin.installedDesc.desc.id)}}};$scope.updateAvailable=plugin=>{const installedVersion=plugin.installedDesc?.desc?.version;const storeVersion=plugin.storeDesc?.storeVersion;if(!installedVersion||!storeVersion){return false}return SemanticVersionService.compareVersions(storeVersion,installedVersion)>0};$scope.getVersion=plugin=>{const installedVersion=plugin.installedDesc?.desc?.version;const storeVersion=plugin.storeDesc?.storeVersion;return installedVersion?installedVersion:storeVersion}});app.controller("PluginPreviewPullController",function($rootScope,$scope,Assert,$state){$scope.error=null;$scope.go=function(){if(!$rootScope.appConfig.admin){return}Assert.trueish($scope.gitPlugin,"Git plugin not ready");$state.transitionTo("plugin.updatefromgit",{uri:$scope.gitPlugin.gitState.repository,checkout:$scope.gitPlugin.gitState.checkout,path:$scope.gitPlugin.gitState.path})}});app.controller("PluginInstallationController",function($scope,DataikuAPI,MonoFuture,Fn,WT1,$state,$stateParams,FutureWatcher,ProgressStackMessageBuilder,Logger){$scope.state="NOT_STARTED";$scope.environmentState="NOT_STARTED";$scope.pluginId=$stateParams.pluginId;$scope.pluginVersion=$stateParams.pluginVersion;$scope.isGit=$state.includes("plugin.installationfromgit")||$state.includes("plugin.updatefromgit");$scope.isUpdate=$state.includes("plugin.update")||$state.includes("plugin.upload.update")||$state.includes("plugin.updatefromgit");$scope.isUploadUpdate=$state.includes("plugin.upload.update");$scope.isUpload=$state.includes("plugin.upload")||$scope.isUploadUpdate;$scope.isCodeEnvDefined=false;let uploadedPluginFile=$stateParams.uploadedPluginFile;function go(){MonoFuture($scope).wrap(DataikuAPI.plugins.install)($scope.pluginId,$scope.isUpdate).success(function(data){if(data&&data.log){$scope.installationLog=data.log}if(!data.result.success){$scope.state="FAILED";WT1.event("plugin-download",{pluginId:$scope.pluginId,pluginVersion:$scope.pluginVersion,success:"FAILED"});$scope.failure={message:data.result.installationError.detailedMessage,isAlreadyInstalled:data.result.installationError.detailedMessage.includes("already installed")};$scope.installingFuture=null;return}WT1.event("plugin-download",{pluginId:$scope.pluginId,pluginVersion:$scope.pluginVersion,success:"DONE"});const confirmInstallation=()=>{$scope.state="DONE";$scope.pluginDesc=data.result.pluginDesc;$scope.$parent.pluginLabel=data.result.pluginDesc.desc.meta.label;$scope.pluginSettings=data.result.settings;$scope.needsRestart=data.result.needsRestart;$scope.isCodeEnvDefined=!!($scope.pluginDesc&&($scope.pluginDesc.frontendRequirements.hasDependencies||$scope.pluginDesc.frontendRequirements.codeEnvLanguage));$scope.installingFuture=null};if(data.result.success&&data.result.messages&&data.result.messages.warning){$scope.state="WAITING_CONFIRMATION";$scope.installationMessages=data.result.messages;$scope.confirmInstallation=confirmInstallation;return}confirmInstallation()}).update(function(data){$scope.state="RUNNING";$scope.installingFuture=data;$scope.installationLog=data.log}).error(function(data,status,headers){$scope.state="FAILED";if(data.aborted){$scope.failure={message:"Aborted"}}else if(data.hasResult){$scope.failure={message:data.result.errorMessage}}else{$scope.failure={message:"Unexpected error"}}$scope.installingFuture=null})}const handleError=message=>{$scope.state="FAILED";$scope.failure={message:message}};const handleAPIError=(data,status,headers)=>{handleError(getErrorDetails(data,status,headers).detailedMessage)};const handleFutureError=data=>{let errorMessage;if(data&&data.result&&data.result.installationError&&data.result.installationError.detailedMessage){errorMessage=data.result.installationError.detailedMessage}else{errorMessage="An error occured"}handleError(errorMessage)};const handleResult=(eventId,pluginId)=>data=>{if(data.aborted)return;if(data&&data.log){$scope.installationLog=data.log}if(!data||!data.result||!data.result.success){WT1.event(eventId,{pluginId:pluginId,success:"FAILED"});handleFutureError(data);return}WT1.event(eventId,{pluginId:pluginId,success:"DONE"});const confirmInstallation=()=>{$scope.state="DONE";$scope.pluginDesc=data.result.pluginDesc;$scope.$parent.pluginLabel=data.result.pluginDesc.desc.meta.label;$scope.pluginSettings=data.result.settings;$scope.needsRestart=data.result.needsRestart;$scope.isCodeEnvDefined=!!($scope.pluginDesc&&($scope.pluginDesc.frontendRequirements.hasDependencies||$scope.pluginDesc.frontendRequirements.codeEnvLanguage));unregisterPluginIdWatcher();$scope.pluginId=data.result.pluginDesc.desc.id};if(data.result.success&&data.result.messages&&data.result.messages.warning){$scope.state="WAITING_CONFIRMATION";$scope.installationMessages=data.result.messages;$scope.confirmInstallation=confirmInstallation;return}confirmInstallation()};function goFromGit(){$scope.state="RUNNING";const isUpdate=$state.includes("plugin.updatefromgit");const eventId=isUpdate?"plugin-update-from-git":"plugin-clone";DataikuAPI.plugins.clonePlugin($stateParams.uri,$stateParams.checkout,$stateParams.path,$scope.isUpdate).success(function(data){FutureWatcher.watchJobId(data.jobId).success(handleResult(eventId,$stateParams.pluginName)).update(function(data){$scope.clonePercentage=ProgressStackMessageBuilder.getPercentage(data.progress);$scope.cloneLabel=ProgressStackMessageBuilder.build(data.progress,true);$scope.installingFuture=data;$scope.installationLog=data.log}).error(handleAPIError)}).error(handleAPIError)}function upload(){$scope.state="RUNNING";DataikuAPI.plugins.uploadPlugin(uploadedPluginFile,$scope.isUploadUpdate).then(function(payload){const data=JSON.parse(payload);FutureWatcher.watchJobId(data.jobId).success(handleResult("plugin-upload")).update(function(data){$scope.installingFuture=data;$scope.installationLog=data.log}).error(handleAPIError)},function(payload){let errorMessage;try{const parsedResponse=JSON.parse(payload.response);errorMessage=parsedResponse.detailedMessage}catch(exception){Logger.error(exception);errorMessage="An unknown error ocurred."}handleError(errorMessage)})}$scope.abort=function(){$scope.state="FAILED";$scope.failure={message:"Aborted"};DataikuAPI.futures.abort($scope.installingFuture.jobId)};$scope.skipEnvironmentCreation=function(){$scope.state="DONE";$scope.environmentState="SKIPPED"};$scope.approveEnvironmentCreation=function(){$scope.environmentState="WAITING_CONFIRMATION"};$scope.disapproveEnvironmentCreation=function(){$scope.environmentState="NOT_STARTED"};$scope.confirmEnvironmentCreation=function(){$scope.environmentState="DONE"};$scope.goToPluginPage=function(){window.location=$state.href("plugin.summary",{pluginId:$scope.pluginId})};$scope.$on("$destroy",function(){if($scope.state=="RUNNING"){$scope.abort()}});$scope.triggerRestart=function(){$state.go("plugin.summary",{pluginId:$scope.pluginId},{reload:true});DataikuAPI.plugins.triggerRestart().success(function(data){}).error(function(){})};let unregisterPluginIdWatcher=$scope.$watch("pluginId",Fn.doIfNv($scope.isGit?goFromGit:$scope.isUpload?upload:go))});app.controller("PluginLearnMoreController",function($scope){$scope.customDatasets=$scope.appConfig.customDatasets.filter(function(x){return x.ownerPluginId==$scope.pluginDesc.id});$scope.customRecipes=$scope.appConfig.customCodeRecipes.filter(function(x){return x.ownerPluginId==$scope.pluginDesc.id})});app.directive("pluginPresetSecurityPermissions",function(PermissionsService){return{restrict:"A",templateUrl:"/templates/plugins/plugin-preset-security-permissions.html",scope:{preset:"=",permissionsDataFetcher:"<"},link:function($scope){$scope.ui={};$scope.securityPermissionsHooks={};$scope.securityPermissionsHooks.makeNewPerm=function(){return{use:false}};$scope.securityPermissionsHooks.fixupPermissionItem=function(p){p.$useDisabled=false};$scope.securityPermissionsHooks.fixupWithDefaultPermissionItem=function(p,d){if(d.use||d.$useDisabled){p.$useDisabled=true}};$scope.$watch("preset.owner",function(){$scope.ui.ownerLogin=$scope.preset.owner});$scope.$watch("ui.ownerLogin",function(){PermissionsService.transferOwnership($scope,$scope.preset,"preset")})}}});app.directive("pluginParameterSetSecurityPermissions",function(){return{restrict:"A",templateUrl:"/templates/admin/plugins/plugin-parameter-set-security-permissions.html",scope:{parameterSet:"=",permissionsDataFetcher:"<"},link:function($scope,element,attrs){$scope.securityPermissionsHooks={};$scope.securityPermissionsHooks.makeNewPerm=function(){return{definableAtProjectLevel:false,definableInline:false}};$scope.securityPermissionsHooks.fixupPermissionItem=function(p){p.$definableAtProjectLevelDisabled=false;p.$definableInlineDisabled=false};$scope.securityPermissionsHooks.fixupWithDefaultPermissionItem=function(p,d){if(d.definableAtProjectLevel||d.$definableAtProjectLevelDisabled){p.$definableAtProjectLevelDisabled=true}if(d.definableInline||d.$definableInlineDisabled){p.$definableInlineDisabled=true}}}}});app.directive("pluginSecurityPermissions",function(){return{restrict:"A",templateUrl:"/templates/plugins/plugin-security-permissions.html",scope:{pluginSettings:"=",permissionsDataFetcher:"<"},link:function($scope){$scope.securityPermissionsHooks={};$scope.securityPermissionsHooks.makeNewPerm=function(){return{canViewComponents:true}};$scope.securityPermissionsHooks.fixupPermissionItem=function(p){p.$adminDisabled=false};$scope.securityPermissionsHooks.fixupWithDefaultPermissionItem=function(p,d){if(d.admin||d.$adminDisabled){p.$adminDisabled=true}}}}});app.directive("securityPermissionsBase",function($rootScope,PermissionsService){return{restrict:"A",scope:false,link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;function makeNewPerm(){$scope.newPerm=$scope.securityPermissionsHooks.makeNewPerm()}const hooksDeregister=$scope.$watch("securityPermissionsHooks",function(){if(!$scope.securityPermissionsHooks)return;makeNewPerm();hooksDeregister()},false);const fixupDefaultPermission=function(){if(!$scope[attrs.permissionsBearer])return;$scope.securityPermissionsHooks.fixupPermissionItem($scope[attrs.permissionsBearer].defaultPermission)};const fixupPermissions=function(){if(!$scope[attrs.permissionsBearer]||!$scope.securityPermissionsHooks)return;$scope[attrs.permissionsBearer].permissions.forEach(function(p){$scope.securityPermissionsHooks.fixupPermissionItem(p);$scope.securityPermissionsHooks.fixupWithDefaultPermissionItem(p,$scope[attrs.permissionsBearer].defaultPermission)})};$scope.permissionsDataFetcher.getUsersAndGroups().then(function(result){$scope.allUsers=result.allUsers;$scope.allGroups=result.allGroups;$scope.allUsersLogin=result.allUsersLogin;if($scope[attrs.permissionsBearer]){$scope.unassignedGroups=PermissionsService.buildUnassignedGroups($scope[attrs.permissionsBearer],$scope.allGroups)}fixupPermissions()});$scope.addPermission=function(){$scope[attrs.permissionsBearer].permissions.push($scope.newPerm);makeNewPerm()};$scope.$watch(attrs.permissionsBearer+".permissions",function(nv,ov){if(!nv)return;$scope.unassignedGroups=PermissionsService.buildUnassignedGroups($scope[attrs.permissionsBearer],$scope.allGroups);fixupPermissions()},true);$scope.$watch(attrs.permissionsBearer+".permissions",function(nv,ov){if(!nv)return;$scope.unassignedGroups=PermissionsService.buildUnassignedGroups($scope[attrs.permissionsBearer],$scope.allGroups);fixupPermissions()},false);$scope.$watch(attrs.permissionsBearer+".defaultPermission",function(nv,ov){if(!nv)return;fixupDefaultPermission();fixupPermissions()},true);$scope.$watch(attrs.permissionsBearer+".defaultPermission",function(nv,ov){if(!nv)return;fixupDefaultPermission();fixupPermissions()},false)}}});app.controller("NewPresetController",function($scope){$scope.presetTypes=$scope.pluginSettings.accessibleParameterSetDescs.map(function(p){return{id:p.elementType,label:p.desc.meta.label||p.elementType}});$scope.newPreset={type:$scope.presetTypes[0].id,name:"Preset "+($scope.pluginSettings.presets.length+1),permissions:[],defaultPermission:{},visibleByAll:true,usableByAll:false,canAdmin:true,canManage:true};$scope.presetNameList=$scope.pluginSettings.presets.map(function(p){return p.name});$scope.create=function(){$scope.pluginSettings.presets.push($scope.newPreset);$scope.dismiss()}});app.controller("NewPresetInParameterSetController",function($scope){$scope.newPreset={name:"Preset "+($scope.allPresets.length+1),permissions:[],defaultPermission:{},canAdmin:true,canManage:true};$scope.presetNameList=$scope.presets.map(function(p){return p.name});$scope.create=function(){$scope.presets.push($scope.newPreset);$scope.allPresets.push($scope.newPreset);$scope.dismiss()}});app.directive("pluginParameterSet",function(CreateModalFromTemplate){return{restrict:"A",templateUrl:"/templates/plugins/plugin-parameter-set.html",scope:{parameterSet:"=",parameterSetDesc:"=",pluginDesc:"=",presets:"=",remove:"=",allPresets:"=",permissionsDataFetcher:"<"},link:function($scope,element,attrs){$scope.$watch("allPresets",function(){if(!$scope.allPresets)return;$scope.presets=$scope.allPresets.filter(function(p){return p.type==$scope.parameterSet.type})},true);$scope.deletePresetInParameterSet=function(preset){var idxInPlugin=$scope.allPresets.indexOf(preset);if(idxInPlugin>=0){$scope.allPresets.splice(idxInPlugin,1)}var idx=$scope.presets.indexOf(preset);if(idx>=0){$scope.presets.splice(idx,1)}};$scope.createPresetInParameterSet=function(){CreateModalFromTemplate("/templates/plugins/modals/new-preset.html",$scope,"NewPresetInParameterSetController",function(newScope){newScope.inParameterSet=true;newScope.newPreset.type=$scope.parameterSet.type})}}}});app.directive("pluginPreset",function(){return{restrict:"A",templateUrl:"/templates/plugins/plugin-preset.html",scope:{preset:"=",parameterSetDesc:"=",pluginDesc:"=",remove:"=",permissionsDataFetcher:"<"},link:function($scope){$scope.canAdminPlugin=undefined;$scope.permissionsDataFetcher.canAdminPlugin($scope.pluginDesc.id).then(function(canAdmin){$scope.canAdminPlugin=canAdmin});$scope.$watch("preset",function(){if(!$scope.preset)return;$scope.preset.config=$scope.preset.config||{};$scope.preset.pluginConfig=$scope.preset.pluginConfig||{}})}}});app.directive("pluginAppTemplate",function(DataikuAPI){return{restrict:"A",templateUrl:"/templates/plugins/plugin-app-template.html",scope:{appTemplate:"=",appTemplateDesc:"=",pluginDesc:"=",remove:"="},link:function($scope,element,attrs){$scope.addConnectionRemapping=function(name){$scope.appTemplate.remapping.connections.push({source:name,target:null})};$scope.addCodeEnvRemapping=function(name){$scope.appTemplate.remapping.codeEnvs.push({source:name,target:null})};$scope.addContainerExecRemapping=function(name){$scope.appTemplate.remapping.containerExecs.push({source:name,target:null})};$scope.availableConnections=[];DataikuAPI.admin.connections.list().success(function(data){angular.forEach(data,function(c,n){$scope.availableConnections.push({name:n,type:c.type,description:c.description})})}).error(setErrorInScope.bind($scope));$scope.availableCodeEnvs=[{envLang:"PYTHON",envName:"Builtin",builtin:true},{envLang:"R",envName:"Builtin",builtin:true}];DataikuAPI.codeenvs.listNames("PYTHON").success(function(data){data.forEach(function(n){$scope.availableCodeEnvs.push({envLang:"PYTHON",envName:n,builtin:false})})}).error(setErrorInScope.bind($scope));DataikuAPI.codeenvs.listNames("R").success(function(data){data.forEach(function(n){$scope.availableCodeEnvs.push({envLang:"R",envName:n,builtin:false})})}).error(setErrorInScope.bind($scope));$scope.availableContainerExecConfs=[];DataikuAPI.containers.listNames("DOCKER",null).success(data=>{data.forEach(function(n){$scope.availableContainerExecConfs.push({type:"DOCKER",name:n})})}).error(setErrorInScope.bind($scope));DataikuAPI.containers.listNames("KUBERNETES",null).success(data=>{data.forEach(function(n){$scope.availableContainerExecConfs.push({type:"KUBERNETES",name:n})})}).error(setErrorInScope.bind($scope))}}})})();(function(){"use strict";const app=angular.module("dataiku.businessapps",["dataiku.filters"]);app.controller("BusinessAppCommonController",function($scope,DataikuAPI,CreateModalFromTemplate,TopNav,FutureProgressModal,WT1){TopNav.setLocation(TopNav.DSS_HOME,"businessapp");$scope.uninstallBusinessApp=function(businessApp){const desc=businessApp.desc;function onSuccess(resolve){resolve(desc.id,desc.version);WT1.event("business-app-delete",{businessAppId:desc.id,businessAppVersion:desc.version,success:true})}function onError(reject,data,status,headers){reject(data,status,headers);WT1.event("business-app-delete",{businessAppId:desc.id,businessAppVersion:desc.version,success:false});setErrorInScope.call($scope,data,status,headers)}return new Promise((resolve,reject)=>{CreateModalFromTemplate("/templates/business-apps/modals/business-app-uninstall-confirm.html",$scope,null,function(newScope){newScope.businessAppId=desc.id;newScope.businessAppName=desc.name;newScope.confirmBusinessAppUninstall=function(){DataikuAPI.businessApps.delete(desc.id,true).success(function(initialResponse){if(initialResponse&&initialResponse.jobId&&!initialResponse.hasResult){FutureProgressModal.show($scope,initialResponse,"Uninstalling "+(desc.name||desc.id)).then(function(){onSuccess(resolve)}).catch(function(data,status,headers){onError(reject,data,status,headers)})}else{onSuccess(resolve)}}).error(function(data,status,headers){onError(reject,data,status,headers)})}})})}});app.controller("BusinessAppInstancesCommonController",function($scope,DataikuAPI,$stateParams,CreateModalFromTemplate,WT1,ActivityIndicator){$scope.deleteBusinessAppInstances=function(projectKeys){return new Promise((resolve,reject)=>{DataikuAPI.businessApps.checkInstancesDeletability($stateParams.businessAppId,projectKeys).success(function(data){if(data.anyMessage){CreateModalFromTemplate("/templates/business-apps/modals/business-app-delete-instances-results.html",$scope,null,function(newScope){newScope.beforeDeletion=true;newScope.results=data.messages;newScope.$on("$destroy",function(){reject()})})}else{CreateModalFromTemplate("/templates/business-apps/modals/business-app-delete-instances-confirm.html",$scope,null,function(newScope){newScope.projectKeys=projectKeys;newScope.clearManagedDatasets=true;newScope.clearOutputManagedFolders=true;newScope.clearJobAndScenarioLogs=true;newScope.clearManagedKnowledgeBanks=true;newScope.confirmProjectDeletion=function(clearManagedDatasets,clearOutputManagedFolders,clearJobAndScenarioLogs,clearManagedKnowledgeBanks){DataikuAPI.businessApps.deleteInstances($stateParams.businessAppId,projectKeys,clearManagedDatasets,clearOutputManagedFolders,clearJobAndScenarioLogs,clearManagedKnowledgeBanks).success(function(deletionResult){if(deletionResult.anyMessage){CreateModalFromTemplate("/templates/business-apps/modals/business-app-delete-instances-results.html",$scope,null,function(newScope){newScope.beforeDeletion=false;newScope.results=deletionResult.messages;newScope.$on("$destroy",function(){ActivityIndicator.success("Instances deleted");resolve()})})}else{ActivityIndicator.success("Instances deleted");resolve()}}).error((data,status,headers)=>{setErrorInScope.call($scope,data,status,headers);ActivityIndicator.error("Failed to delete instances");reject()});WT1.event("business-app-delete-instances",{clearManagedDatasets:clearManagedDatasets,clearOutputManagedFolders:clearOutputManagedFolders,clearJobAndScenarioLogs:clearJobAndScenarioLogs,clearManagedKnowledgeBanks:clearManagedKnowledgeBanks})}})}}).error((data,status,headers)=>{setErrorInScope.call($scope,data,status,headers);reject()})})}});app.controller("BusinessAppsExploreController",function($rootScope,$scope,$controller,$state,DataikuAPI,Assert,CreateModalFromTemplate,TopNav,RequestCenterService,ActivityIndicator,SemanticVersionService){$controller("BusinessAppCommonController",{$scope:$scope});TopNav.setLocation(TopNav.DSS_HOME,"businessapps");$scope.businessAppsUIState={filteredStoreBusinessApps:{},filteredInstalledBusinessApps:{},searchQuery:""};$scope.uploadedBusinessApp={file:null};$scope.installBusinessApp=function(businessAppToInstall,isUpdate){if($rootScope.appConfig.admin&&businessAppToInstall){if(isUpdate===true){$state.transitionTo("businessapp.update",{businessAppId:businessAppToInstall.id,businessAppVersion:businessAppToInstall.storeVersion})}else{$state.transitionTo("businessapp.installation",{businessAppId:businessAppToInstall.id,businessAppVersion:businessAppToInstall.storeVersion})}$scope.dismiss&&$scope.dismiss()}};$scope.resetStoreQuery=function(){$scope.businessAppsUIState.searchQuery=""};$scope.resetInstalledQuery=function(){$scope.businessAppsUIState.searchQuery=""};$scope.hasNoResultsForStoreQuery=function(){const isListEmpty=$scope.businessAppsUIState.filteredStoreBusinessApps&&$scope.businessAppsUIState.filteredStoreBusinessApps.length===0;const hasSearched=$scope.businessAppsUIState.searchQuery&&$scope.businessAppsUIState.searchQuery.length;return isListEmpty&&hasSearched};$scope.hasNoResultsForInstalledQuery=function(){const isListEmpty=$scope.businessAppsUIState.filteredInstalledBusinessApps&&$scope.businessAppsUIState.filteredInstalledBusinessApps.length===0;const hasSearched=$scope.businessAppsUIState.searchQuery&&$scope.businessAppsUIState.searchQuery.length;return isListEmpty&&hasSearched};$scope.refreshList=function(forceFetch){if($scope.businessAppsList&&forceFetch===false){return}DataikuAPI.businessApps.list(forceFetch).success(function(data){$scope.businessAppsList=data;$scope.businessAppsUIState.storeBusinessAppsCount=0;$scope.businessAppsUIState.installedBusinessAppsCount=0;$scope.businessAppsList.businessApps.forEach(app=>{if(app.storeDesc){$scope.businessAppsUIState.storeBusinessAppsCount++;app.imageURL=app.storeDesc.imageURL}if(app.installedDesc){$scope.businessAppsUIState.installedBusinessAppsCount++;app.imageURL="/dip/api/image/get-image?type=BUSINESS_APP&id="+encodeURIComponent(app.installedDesc.desc.id)}if(app.storeDesc?.storeVersion&&app?.installedDesc?.desc.version&&SemanticVersionService.compareVersions(app.storeDesc.storeVersion,app.installedDesc.desc.version)>0){app.updateAvailable=true}});if(forceFetch){if(data.couldFetch){ActivityIndicator.success("Store content refreshed")}else{ActivityIndicator.error("Failed to reach the store")}}}).error((data,status,headers)=>{setErrorInScope.call($scope,data,status,headers);if(!$scope.businessAppsList){$scope.businessAppsList={businessAppsNumberInStore:0,couldFetch:false}}})};$scope.previewInstallStoreBusinessApp=function(businessApp){Assert.trueish(businessApp.inStore,"Business Application not in store");CreateModalFromTemplate("/templates/business-apps/modals/business-app-install-preview.html",$scope,null,function(newScope){newScope.attachDownloadTo=$scope;newScope.isUpdate=businessApp.installed;if(businessApp.installed){newScope.installedVersion=businessApp.installedDesc.desc.version}newScope.uiState={activeTab:"details"};newScope.storeBusinessApp=businessApp.storeDesc})};$scope.previewUninstallBusinessApp=function(businessApp){$scope.uninstallBusinessApp(businessApp.installedDesc).then(()=>$scope.refreshList())};function checkForPreviousBusinessAppRequest(modalScope,errorScope,businessAppId){modalScope.hasPreviousRequest=false;modalScope.latestRequest={};if(modalScope.appConfig.admin){return}DataikuAPI.requests.getLatestRequestForCurrentUser(businessAppId,"BUSINESS_APP","").then(response=>{if(response.data.status==="PENDING"||modalScope.queryRequestType==="INSTALL_BUSINESS_APP"&&response.data.status==="APPROVED"){modalScope.hasPreviousRequest=true;modalScope.latestRequest=response.data}},error=>{if(error.status!==404){setErrorInScope.bind(errorScope)(error)}})}$scope.requestInstallOrUpdateBusinessApp=function(businessApp){Assert.trueish(businessApp.inStore,"Business Application not in store");CreateModalFromTemplate("/templates/business-apps/modals/business-app-install-request.html",$scope,null,function(newScope){newScope.businessApp=businessApp;newScope.ui={message:""};newScope.requestType=newScope.businessApp.installed?"update":"install";newScope.storeBusinessApp=newScope.businessApp.storeDesc;newScope.queryRequestType=newScope.businessApp.installed?"UPDATE_BUSINESS_APP":"INSTALL_BUSINESS_APP";checkForPreviousBusinessAppRequest(newScope,$scope,businessApp.id);DataikuAPI.businessApps.list(false).success(function(data){$scope.businessAppsList=data;newScope.businessApp=data.businessApps.find(aBusinessApp=>aBusinessApp.id===businessApp.id)}).error(setErrorInScope.bind($scope));newScope.sendRequest=requestMessage=>{DataikuAPI.requests.createBusinessAppRequest(newScope.queryRequestType,newScope.businessApp.id,newScope.ui.message).success(data=>{RequestCenterService.WT1Events.onRequestSent("BUSINESS_APP",null,newScope.businessApp.id,requestMessage,data.id)}).error(setErrorInScope.bind($scope));newScope.dismiss();$rootScope.$broadcast("dismissModals")}})};$scope.newZippedBusinessApp=function(){CreateModalFromTemplate("/templates/business-apps/modals/business-app-upload.html",$scope)};$scope.uploadBusinessApp=function(){if($scope.uploadedBusinessApp.file&&$scope.uploadedBusinessApp.file!==""){let fileName=$scope.uploadedBusinessApp.file.name;$state.transitionTo("businessapp.upload",{businessAppId:fileName,uploadedBusinessAppFile:$scope.uploadedBusinessApp.file})}};$scope.reload=function(){location.reload()};$scope.goToBusinessAppPage=function(businessAppId){$state.transitionTo("businessapp.settings",{businessAppId:businessAppId})};Mousetrap.bind("r l",function(){$scope.refreshList(true)});$scope.$on("$destroy",function(){Mousetrap.unbind("r l")});$scope.refreshList(false);if($state.is("businessapps")){$state.transitionTo("businessapps.store")}});app.controller("BusinessAppController",function($scope,$controller,$state,$stateParams,DataikuAPI,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"businessapp");$scope.businessAppsUIState=$scope.businessAppsUIState||{};$controller("BusinessAppCommonController",{$scope:$scope});$scope.isInstallingOrUpdatingBusinessApp=function(){return $state.includes("businessapp.installation")||$state.includes("businessapp.update")||$state.includes("businessapp.upload")};$scope.previewUninstallBusinessApp=function(){$scope.uninstallBusinessApp($scope.businessAppStateInfo.installedDesc).then(()=>{$state.transitionTo("businessapps.store")}).catch((data,status,headers)=>{$scope.state="FAILED";$scope.failure={message:getErrorDetails(data,status,headers).detailedMessage}})};$scope.getBusinessApp=function(){return DataikuAPI.businessApps.get($stateParams.businessAppId).success(function(data){$scope.businessAppStateInfo=data}).error(setErrorInScope.bind($scope))};if($scope.isInstallingOrUpdatingBusinessApp()){$scope.businessAppLabel=$stateParams.businessAppId}else{$scope.getBusinessApp()}});app.controller("BusinessAppInstallationController",function($scope,DataikuAPI,MonoFuture,Fn,WT1,$state,$stateParams,FutureWatcher,Logger){$scope.state="NOT_STARTED";$scope.environmentState="NOT_STARTED";$scope.businessAppId=$stateParams.businessAppId;$scope.businessAppVersion=$stateParams.businessAppVersion;$scope.isUpdate=$state.includes("businessapp.update");$scope.isUpload=$state.includes("businessapp.upload");$scope.isCodeEnvDefined=false;const uploadedBusinessAppFile=$stateParams.uploadedBusinessAppFile;function go(){MonoFuture($scope).wrap(DataikuAPI.businessApps.install)($scope.businessAppId).success(function(data){if(data&&data.log){$scope.installationLog=data.log}if(!data.result.success){$scope.state="FAILED";WT1.event("business-app-download",{businessAppId:$scope.businessAppId,businessAppVersion:$scope.businessAppVersion,success:"FAILED"});$scope.failure={message:data.result.installationError.detailedMessage,isAlreadyInstalled:data.result.installationError.detailedMessage.includes("already installed")};$scope.installingFuture=null;return}WT1.event("business-app-download",{businessAppId:$scope.businessAppId,businessAppVersion:$scope.businessAppVersion,success:"DONE"});const confirmInstallation=()=>{$scope.state="DONE";$scope.businessApp=data.result.businessApp;$scope.businessAppSettings=data.result.businessApp.settings;$scope.isCodeEnvDefined=!!$scope.businessApp.desc.codeEnvName;if($scope.isCodeEnvDefined&&$scope.businessApp.codeEnvExist){$scope.environmentState=$scope.businessApp.codeEnvUpToDate?"DONE":"WAITING_CONFIRMATION"}$scope.installingFuture=null;$scope.$parent.businessAppLabel=$scope.businessApp.desc.name};if(data.result.success&&data.result.messages&&data.result.messages.warning){$scope.state="WAITING_CONFIRMATION";$scope.installationMessages=data.result.messages;$scope.confirmInstallation=confirmInstallation;return}confirmInstallation()}).update(function(data){$scope.state="RUNNING";$scope.installingFuture=data;$scope.installationLog=data.log}).error(function(data){$scope.state="FAILED";if(data.aborted){$scope.failure={message:"Aborted"}}else if(data.hasResult){$scope.failure={message:data.result.errorMessage}}else if(data.errorType&&data.message){$scope.failure={message:data.message}}else{$scope.failure={message:"Unexpected error"}}$scope.installingFuture=null})}const handleError=message=>{$scope.state="FAILED";$scope.failure={message:message}};const handleAPIError=(data,status,headers)=>{handleError(getErrorDetails(data,status,headers).detailedMessage)};const handleFutureError=data=>{let errorMessage;if(data&&data.result&&data.result.installationError&&data.result.installationError.detailedMessage){errorMessage=data.result.installationError.detailedMessage}else{errorMessage="An error occurred"}handleError(errorMessage)};const handleResult=(eventId,businessAppId)=>data=>{if(data.aborted)return;if(data&&data.log){$scope.installationLog=data.log}if(!data||!data.result||!data.result.success){WT1.event(eventId,{businessAppId:businessAppId,success:"FAILED"});handleFutureError(data);return}WT1.event(eventId,{businessAppId:businessAppId,success:"DONE"});const confirmInstallation=()=>{$scope.state="DONE";$scope.businessApp=data.result.businessApp;$scope.businessAppSettings=data.result.settings;$scope.isCodeEnvDefined=!!$scope.businessApp.desc.codeEnvName;if($scope.isCodeEnvDefined&&$scope.businessApp.codeEnvExist){$scope.environmentState=$scope.businessApp.codeEnvUpToDate?"DONE":"WAITING_CONFIRMATION"}unregisterBusinessAppIdWatcher();$scope.businessAppId=data.result.businessApp.desc.id;$scope.$parent.businessAppLabel=data.result.businessApp.desc.name};if(data.result.success&&data.result.messages&&data.result.messages.warning){$scope.state="WAITING_CONFIRMATION";$scope.installationMessages=data.result.messages;$scope.confirmInstallation=confirmInstallation;return}confirmInstallation()};function upload(){$scope.state="RUNNING";DataikuAPI.businessApps.uploadBusinessApp(uploadedBusinessAppFile).then(function(payload){const data=JSON.parse(payload);FutureWatcher.watchJobId(data.jobId).success(handleResult("business-app-upload")).update(function(data){$scope.installingFuture=data;$scope.installationLog=data.log}).error(handleAPIError)},function(payload){let errorMessage;try{const parsedResponse=JSON.parse(payload.response);errorMessage=parsedResponse.detailedMessage}catch(exception){Logger.error(exception);errorMessage="An unknown error occurred."}handleError(errorMessage)})}$scope.abort=function(){$scope.state="FAILED";$scope.failure={message:"Aborted"};DataikuAPI.futures.abort($scope.installingFuture.jobId)};$scope.skipEnvironmentCreation=function(){$scope.state="DONE";$scope.environmentState="SKIPPED"};$scope.approveEnvironmentCreation=function(){$scope.environmentState="WAITING_CONFIRMATION"};$scope.disapproveEnvironmentCreation=function(){$scope.environmentState="NOT_STARTED"};$scope.confirmEnvironmentCreation=function(){$scope.environmentState="DONE"};$scope.goToBusinessAppPage=function(businessAppId){window.location=$state.href("businessapp.settings",{businessAppId:businessAppId})};$scope.$on("$destroy",function(){if($scope.state==="RUNNING"){$scope.abort()}});let unregisterBusinessAppIdWatcher=$scope.$watch("businessAppId",Fn.doIfNv($scope.isUpload?upload:go))});app.controller("BusinessAppSettingsController",function($scope,$controller,$state,$stateParams,$filter,DataikuAPI,MonoFuture,Fn,WT1,Dialogs,CreateModalFromTemplate,FutureProgressModal,ActivityIndicator,PermissionsDataFetcher){const INSTANCE_OWNER="%%INSTANCE_OWNER%%";function updateRunAsUserOptions(){if(!$scope.allUsers||!$scope.businessAppSettings){return}const options=[{login:INSTANCE_OWNER,displayName:"< New instance owner >"},...$scope.allUsers];const defaultRunAsUser=$scope.businessAppSettings.defaultRunAsUser;if(defaultRunAsUser&&!options.some(user=>user.login===defaultRunAsUser)){options.push({login:defaultRunAsUser,displayName:`${defaultRunAsUser} (not found)`})}$scope.runAsUserOptions=options;$scope.runAsUserOptionsLogin=options.map(user=>user.login===INSTANCE_OWNER?"User creating the instance":`@${user.login}`)}function ensureContainerSelection(selection){const containerSelection=selection||{};if(!containerSelection.containerMode){containerSelection.containerMode="INHERIT"}return containerSelection}function checkConnectionRemapping(nv){$scope.needsRemapping=nv&&nv.some(r=>!r.target)}$scope.$watch("businessAppSettings.remapping.connections",checkConnectionRemapping,true);$scope.getConnectionNameWithDescription=connection=>$filter("connectionNameFormatter")(connection.name)+(connection.description?" | "+connection.description:"");$scope.isBusinessAppSettingsFormsInvalid=function(){return $scope.businessAppSettingsForms.$invalid};$scope.dirtyBusinessAppSettings=function(){return $scope.originalBusinessAppSettings!==null&&!angular.equals($scope.originalBusinessAppSettings,$scope.businessAppSettings)};checkChangesBeforeLeaving($scope,$scope.dirtyBusinessAppSettings);$scope.saveBusinessAppSettings=function(){DataikuAPI.businessApps.saveSettings($scope.businessAppStateInfo.installedDesc.desc.id,$scope.businessAppSettings).success(()=>{$scope.originalBusinessAppSettings=angular.copy($scope.businessAppSettings);WT1.event("business-app-settings-changed",{businessAppId:$scope.businessAppStateInfo.installedDesc.desc.id})}).error(setErrorInScope.bind($scope))};$scope.permissionsDataFetcher=PermissionsDataFetcher($scope);if(!$stateParams.businessAppId||$scope.installed){return}DataikuAPI.businessApps.get($stateParams.businessAppId).success(function(data){$scope.businessAppStateInfo=data;$scope.installed=data.installedDesc;$scope.businessAppSettings=data?.installedDesc?.settings||{};$scope.businessAppSettings.container=ensureContainerSelection($scope.businessAppSettings.container);$scope.businessAppSettings.containerForVisualRecipesWorkloads=ensureContainerSelection($scope.businessAppSettings.containerForVisualRecipesWorkloads);$scope.originalBusinessAppSettings=angular.copy($scope.businessAppSettings);$scope.requiredConnections=data.installedDesc?.desc?.connections||{};checkConnectionRemapping($scope.businessAppSettings?.remapping?.connections);updateRunAsUserOptions()}).error(setErrorInScope.bind($scope));DataikuAPI.admin.connections.list().success(data=>{$scope.connectionsByName=data;$scope.connections=Object.values(data)}).error(setErrorInScope.bind($scope));DataikuAPI.containers.listNames(null,"USER_CODE").success(function(data){$scope.containerNames=data}).error(setErrorInScope.bind($scope));DataikuAPI.containers.listNames(null,"VISUAL_RECIPES").success(function(data){$scope.containerNamesForVisualRecipesWorkloads=data}).error(setErrorInScope.bind($scope));DataikuAPI.security.listUsers().success(function(data){$scope.allUsers=data.sort((a,b)=>a.displayName.localeCompare(b.displayName));updateRunAsUserOptions()}).error(setErrorInScope.bind($scope))});app.controller("BusinessAppInstancesController",function($scope,$controller,$state,$stateParams,$filter,DataikuAPI,MonoFuture,Fn,WT1,Dialogs,CreateModalFromTemplate,FutureProgressModal,ActivityIndicator){$controller("BusinessAppInstancesCommonController",{$scope:$scope});function loadInstances(){DataikuAPI.businessApps.listInstances($stateParams.businessAppId).success(data=>{$scope.businessAppInstanceListLoaded=true;$scope.businessAppInstanceList=data}).error(setErrorInScope.bind($scope))}$scope.upgradeBusinessAppInstance=function(instance){CreateModalFromTemplate("/templates/business-apps/modals/business-app-upgrade-instance-confirm.html",$scope,null,newScope=>{newScope.projectKey=instance.projectKey;newScope.projectName=instance.name;newScope.version=$scope.installed.desc.version;newScope.confirmBusinessAppInstanceUpgrade=function(){WT1.event("business-app-instance-upgrade",{businessAppId:instance.businessAppId,oldVersion:instance.businessAppVersion,newVersion:$scope.installed.desc.version,projectHash:md5(instance.projectKey)});DataikuAPI.businessApps.upgradeInstance(instance.businessAppId,instance.projectKey).success(function(data){FutureProgressModal.show($scope,data,"Upgrade "+instance.projectKey,undefined,"static",false,true).then(function(result){loadInstances();if(result&&result.anyMessage){Dialogs.infoMessagesDisplayOnly($scope,"Upgrade "+instance.projectKey,result)}}).catch(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))}})};$scope.deleteBusinessAppInstance=function(instance){$scope.deleteBusinessAppInstances([instance.projectKey]).then(()=>{$scope.businessAppInstanceList=$scope.businessAppInstanceList.filter(item=>item!==instance);$scope.$apply()}).catch(setErrorInScope.bind($scope))};$scope.createBusinessAppInstance=function(){CreateModalFromTemplate("/templates/business-apps/modals/business-app-new-instance.html",$scope,"BusinessAppNewInstanceModalController",newScope=>{newScope.businessAppId=$scope.installed.desc.id;newScope.businessAppVersion=$scope.installed.desc.version;newScope.businessAppName=$scope.installed.desc.name;newScope.defaultRunAsUser=$scope.businessAppSettings?.defaultRunAsUser;newScope.allowRunAsUserOverride=$scope.businessAppSettings?.allowRunAsUserOverride}).then(function({projectKey,webAppId}){$state.go("projects.project.webapps.webapp.view",{projectKey:projectKey,webAppId:webAppId})}).catch(loadInstances)};$scope.restartWebAppBackend=function(instance){DataikuAPI.webapps.restartBackend({projectKey:instance.projectKey,id:instance.webAppId}).error(setErrorInScope.bind($scope)).success(data=>{FutureProgressModal.show($scope,data,"Starting backend").then(function(result){if(result){instance.isWebAppBackendRunning=true}}).catch(setErrorInScope.bind($scope))})};$scope.stopWebAppBackend=function(instance){DataikuAPI.webapps.stopBackend({projectKey:instance.projectKey,id:instance.webAppId}).error(setErrorInScope.bind($scope)).success(()=>{ActivityIndicator.success("Backend stopped");instance.isWebAppBackendRunning=false})};if(!$stateParams.businessAppId||$scope.installed){return}DataikuAPI.businessApps.get($stateParams.businessAppId).success(function(data){$scope.businessAppStateInfo=data;$scope.installed=data.installedDesc;$scope.businessAppSettings=data?.installedDesc?.settings||{}}).error(setErrorInScope.bind($scope));$scope.businessAppInstanceListLoaded=false;loadInstances()});app.directive("businessAppSecurityPermissions",function(){return{restrict:"A",templateUrl:"/templates/business-apps/business-app-security-permissions.html",scope:{businessAppSettings:"=",permissionsDataFetcher:"<"},link:function($scope){$scope.securityPermissionsHooks={};$scope.securityPermissionsHooks.makeNewPerm=function(){return{use:true,create:true}};$scope.securityPermissionsHooks.fixupPermissionItem=function(p){p.$useDisabled=p.create;p.$createDisabled=false};$scope.securityPermissionsHooks.fixupWithDefaultPermissionItem=function(p,d){if(d.use||d.$useDisabled){p.$useDisabled=true}if(d.create||d.$createDisabled){p.$createDisabled=true}}}}});app.directive("businessAppRequirements",function(DataikuAPI,$rootScope){return{restrict:"A",templateUrl:"/templates/business-apps/business-app-requirements.html",scope:{businessApp:"=",onValid:"=",onInvalid:"=",showTitle:"<"},link:function($scope){function markAsValid(valid){if(valid){$scope.onValid&&$scope.onValid()}else{$scope.onInvalid&&$scope.onInvalid()}}function checkCodeEnv(){if(!$scope.businessApp){return}if($scope.businessApp.desc.codeEnvName){DataikuAPI.codeenvs.getForBusinessApp($scope.businessApp.desc.id,$scope.businessApp.desc.codeEnvName).success(function(data){$scope.codeEnv=data;markAsValid($scope.codeEnv!==null&&$scope.codeEnv!==undefined)}).error(function(){setErrorInScope.apply($scope,arguments);markAsValid(false)})}else{markAsValid(true)}}$scope.checkValidity=function(){const codeEnvOk=!$scope.businessApp.desc.codeEnvName||$scope.codeEnv!==undefined;markAsValid(codeEnvOk)};$scope.onCodeEnvValid=function(){$scope.businessApp.codeEnvExist=true;$scope.businessApp.codeEnvUpToDate=true;markAsValid(true)};$scope.onCodeInvalid=function(){markAsValid(false)};if($scope.showTitle===undefined){$scope.showTitle=true}$scope.$watch("businessApp",checkCodeEnv);$scope.appConfig=$rootScope.appConfig;$scope.codeEnv=null}}});app.directive("businessAppCodeEnv",function(DataikuAPI,Dialogs,WT1,FutureProgressModal,$rootScope,MonoFuture,CodeEnvService){return{restrict:"A",templateUrl:"/templates/business-apps/modals/business-app-code-env.html",scope:{businessApp:"=",onValid:"=",onInvalid:"="},link:function($scope){$scope.codeEnv=undefined;$scope.uiState={state:"DISPLAY"};$scope.newEnv={deploymentMode:"BUSINESS_APP_MANAGED",pythonInterpreter:"PYTHON39",allContainerConfs:false,containerConfs:[],allSparkKubernetesConfs:false,sparkKubernetesConfs:[],rebuildDependentCodeStudioTemplates:"NONE"};$scope.defaultInterpreterFound=false;$scope.getCodeEnv=function(){return DataikuAPI.codeenvs.getForBusinessApp($scope.businessApp.desc.id,$scope.businessApp.desc.codeEnvName).success(function(data){$scope.codeEnv=data}).error(function(){$scope.onInvalid&&$scope.onInvalid();setErrorInScope.apply($scope,arguments)})};$scope.buildNewCodeEnv=function(newEnv){DataikuAPI.codeenvs.createForBusinessApp($scope.businessApp.desc.id,newEnv).success(function(data){FutureProgressModal.show($scope,data,"Environment creation",undefined,"static",false,true).then(function(result){Dialogs.infoMessagesDisplayOnly($scope,"Creation result",result.messages,result.futureLog,undefined,"static",false);const isCodeEnvImported=result.messages&&result.messages.messages&&result.messages.messages.findIndex(message=>message.code==="INFO_CODEENV_IMPORT_OK")>-1;if(result.messages.error&&!isCodeEnvImported){$scope.onInvalid&&$scope.onInvalid()}else{DataikuAPI.codeenvs.getForBusinessApp($scope.businessApp.desc.id,$scope.businessApp.desc.codeEnvName).success(function(data){$scope.codeEnv=data;$scope.onValid&&$scope.onValid()}).error(function(){$scope.onInvalid&&$scope.onInvalid();setErrorInScope.apply($scope,arguments)})}})}).error(function(){$scope.onInvalid&&$scope.onInvalid();setErrorInScope.apply($scope,arguments)})};$scope.updateCodeEnv=function(){DataikuAPI.codeenvs.updateForBusinessApp($scope.businessApp.desc.id).success(function(data){FutureProgressModal.show($scope,data,"Environment update").then(function(result){Dialogs.infoMessagesDisplayOnly($scope,"Update result",result.messages,result.futureLog);$scope.getCodeEnv().then(()=>{if($scope.codeEnv&&$scope.codeEnv.isUptodate){$scope.onValid&&$scope.onValid()}})})}).error(function(){$scope.onInvalid&&$scope.onInvalid();setErrorInScope.apply($scope,arguments)})};$scope.isCurrentSelectedEnvUpToDate=function(){return $scope.codeEnv&&$scope.codeEnv.isUptodate};const getBusinessAppDefaultAvailableInterpreter=codeEnvLang=>{if(codeEnvLang!=="PYTHON"){return}return DataikuAPI.codeenvs.getBusinessAppDefaultAvailableInterpreter($scope.businessApp.desc.id).success(data=>{$scope.newEnv.pythonInterpreter=data;$scope.defaultInterpreterFound=true}).error(function(){$scope.defaultInterpreterFound=true;setErrorInScope.apply($scope,arguments)})};$scope.$watch("businessApp.codeEnvLang",getBusinessAppDefaultAvailableInterpreter);$scope.containerNames=[];DataikuAPI.containers.listNames(null,"USER_CODE").success(function(data){$scope.containerNames=data}).error(function(){$scope.onInvalid&&$scope.onInvalid();setErrorInScope.apply($scope,arguments)});$scope.sparkKubernetesNames=[];DataikuAPI.containers.listSparkNames().success(function(data){$scope.sparkKubernetesNames=data}).error(function(){$scope.onInvalid&&$scope.onInvalid();setErrorInScope.apply($scope,arguments)});$scope.codeEnvDeploymentModes=[["BUSINESS_APP_MANAGED","Managed by DSS (recommended)"],["BUSINESS_APP_NON_MANAGED","Managed manually"]];$scope.possiblePythonInterpreters=[];if($scope.businessApp.codeEnvSpec){const codeEnvSpec=$scope.businessApp.codeEnvSpec;if(!codeEnvSpec.forceConda){$scope.possiblePythonInterpreters=$scope.possiblePythonInterpreters.concat(["CUSTOM"])}if(codeEnvSpec.acceptedPythonInterpreters&&codeEnvSpec.acceptedPythonInterpreters.length>0){$scope.possiblePythonInterpreters=$scope.possiblePythonInterpreters.concat(codeEnvSpec.acceptedPythonInterpreters);$scope.newEnv.pythonInterpreter=codeEnvSpec.acceptedPythonInterpreters[0]}}CodeEnvService.getPythonInterpreters().then(function(enrichedInterpreters){const allowed=new Set($scope.possiblePythonInterpreters);$scope.enrichedPossiblePythonInterpreters=enrichedInterpreters.filter(i=>allowed.has(i[0]))});$scope.getCodeEnv()}}});app.controller("BusinessAppInstanceController",function($scope,$controller,ProjectStatusService,$state,$stateParams,$rootScope,$filter,$element,CreateModalFromTemplate,DataikuAPI,TopNav,Debounce,ListFilter,Assert,DKUConstants,WT1,TaggingService,StateUtils,openDkuPopin,DetectUtils){$controller("BusinessAppInstancesCommonController",{$scope:$scope});$controller("_ProjectsListBaseBehavior",{$scope:$scope});if(!$scope.preventSettingLocation){TopNav.setLocation(TopNav.DSS_HOME)}TaggingService.fetchGlobalTags();$scope.getDefaultTagColor=TaggingService.getTagColor;$scope.uiState={};$scope.displayMode={mode:"mosaic"};$scope.query={tags:[],projectStatus:[],contributors:[],q:""};$scope.sortBy={mode:"commit"};$scope.tagsMap={};$scope.tagsList=[];$scope.contributorsMap={};$scope.contributorsList=[];$scope.os=DetectUtils.getOS();const orderBy=$filter("orderBy");$scope.noAccessPermission=false;const getMosaicRows=function(itemsList){const tileW=310;const margins=40;const leftPaneWidth=400+40;let itemsPerRow=1;let elementWidth=$element.width();elementWidth-=margins;elementWidth-=leftPaneWidth;if(elementWidth>tileW){itemsPerRow=Math.floor(elementWidth/tileW)}const mosaicItemsPerRow=[];let i,j;for(i=0,j=itemsList.length;i<j;i+=itemsPerRow){mosaicItemsPerRow.push(itemsList.slice(i,i+itemsPerRow))}return mosaicItemsPerRow};const updateDisplayedItems=function(){$scope.filteredAppInstancesList=filterAppInstancesList($scope.appInstancesList,$scope.query);$scope.filteredAppInstancesList=sortAppInstancesList($scope.filteredAppInstancesList);$scope.filteredAppInstancesRows=getMosaicRows($scope.filteredAppInstancesList)};const debouncedResizeCB=Debounce().withDelay(200,200).wrap(updateDisplayedItems);$(window).on("resize.appPageResize",debouncedResizeCB);$scope.$on("$destroy",function(){$(window).off("resize.appPageResize",debouncedResizeCB)});$scope.$on("topbarDrawerStateChanged",(_,args)=>{if(!args.autoHide){updateDisplayedItems()}});$scope.appInstancesList=[];$scope.fetchAppSummary=function(){$scope.appInstancesList=[];return DataikuAPI.businessApps.getSummary($stateParams.businessAppId).success(function(data){$scope.appSummary=data;$scope.appInstancesList=$scope.appSummary.instances;$scope.selectedProjects=[...$scope.appInstancesList.filter(p=>$scope.selectedProjects.findIndex(p2=>p.projectKey===p2.projectKey)>=0)];updateDisplayedItems()}).error((data,status,headers)=>{if(data&&data.errorType){$scope.noAccessPermission=status===403}setErrorInScope.bind($scope)(data,status,headers)})};$scope.goToBusinessAppPage=function(businessAppId){$state.transitionTo("businessapp.settings",{businessAppId:businessAppId})};$scope.createBusinessAppInstance=function(){CreateModalFromTemplate("/templates/business-apps/modals/business-app-new-instance.html",$scope,"BusinessAppNewInstanceModalController",function(newScope){newScope.businessAppId=$scope?.appSummary?.appId;newScope.businessAppVersion=$scope?.appSummary?.appVersion;newScope.businessAppName=$scope?.appSummary?.label;newScope.defaultRunAsUser=$scope?.appSummary?.defaultRunAsUser;newScope.allowRunAsUserOverride=$scope?.appSummary?.allowRunAsUserOverride}).then(function({projectKey,webAppId}){$state.go("projects.project.webapps.webapp.view",{projectKey:projectKey,webAppId:webAppId})}).catch($scope.fetchAppSummary)};$scope.clickOnAppInstance=function(appInstance,$event){if($scope.isPopupActive){return}$event.preventDefault();if($event.ctrlKey||$event.metaKey){toggleSelectProject(appInstance);window.getSelection().removeAllRanges()}else{$state.go("projects.project.webapps.webapp.view",{projectKey:appInstance.projectKey,webAppId:appInstance.webAppId})}};$scope.selectedProjects=[];function toggleSelectProject(project,expectSelected){let index=$scope.selectedProjects.findIndex(p=>p.projectKey===project.projectKey);if(index===-1){if(expectSelected===true||expectSelected===undefined){$scope.selectedProjects.push(project)}}else{if(expectSelected===false||expectSelected===undefined){$scope.selectedProjects.splice(index,1)}}}$scope.isProjectSelected=project=>$scope.selectedProjects.findIndex(sp=>sp.projectKey===project.projectKey)!==-1;$scope.selectAllInstances=function(){$scope.filteredAppInstancesList.forEach(p=>toggleSelectProject(p,true))};$scope.unselectAllInstances=function(){$scope.filteredAppInstancesList.forEach(p=>toggleSelectProject(p,false))};function toggleAllInstancesStartingFrom(project,selectAfter,expectSelected){let idx=$scope.filteredAppInstancesList.findIndex(p=>p.projectKey===project.projectKey);if(idx>=0){let affected=selectAfter?$scope.filteredAppInstancesList.filter((p,i)=>i>=idx):$scope.filteredAppInstancesList.filter((p,i)=>i<=idx);affected.forEach(p=>toggleSelectProject(p,expectSelected))}else{}}$scope.getProjectContributorDisplayList=function(contributors,maxDisplayedContributors){if(contributors.length>maxDisplayedContributors){return contributors.slice(0,maxDisplayedContributors-1)}return contributors};$scope.getProjectStatusColor=function(status){return ProjectStatusService.getProjectStatusColor(status)};$scope.isFiltering=function(){return $scope.query.tags.length>0||$scope.query.contributors.length>0||$scope.query.projectStatus.length>0||$scope.isFullStringQuerying()};$scope.isFullStringQuerying=function(){return typeof $scope.query.q!=="undefined"&&$scope.query.q.length>0};$scope.clearFilters=function(){$scope.query.tags=[];$scope.query.projectStatus=[];$scope.query.contributors=[];$scope.query.q=""};$scope.toggleTag=function(tagTitle){if(tagTitle){var index=$scope.query.tags.indexOf(tagTitle);index>-1?$scope.query.tags.splice(index,1):$scope.query.tags.push(tagTitle)}};function filterAppInstancesList(appInstancesList,query){if($scope.isFiltering()){WT1.event("app-instances-filtering",{tags:query.tags&&query.tags.length,contributors:query.contributors&&query.contributors.length,projectStatus:query.projectStatus&&query.projectStatus.length,fullString:$scope.isFullStringQuerying()})}return ListFilter.filter(appInstancesList||[],query.q).filter(app=>{if(query.tags&&query.tags.length){if(!app.tags||!query.tags.some(tag=>app.tags.includes(tag))){return}}if(query.contributors&&query.contributors.length){if(!app.contributors||!app.contributors.some(contributor=>query.contributors.includes(contributor.login))){return}}if(query.projectStatus&&query.projectStatus.length){if(query.projectStatus.indexOf(app.projectStatus)<0){return}}else if(app.projectStatus===DKUConstants.ARCHIVED_PROJECT_STATUS){return}return true})}$scope.$watch("query",function(nv,ov){if(!angular.equals(nv,ov)){updateDisplayedItems()}},true);$scope.$watch("sortBy",function(nv,ov){if(!angular.equals(nv,ov)){updateDisplayedItems()}},true);$scope.sortByModeTitles=Object.freeze({name:"Project Name",commit:"Last Modified",commit_for_user:"Last Modified By Me",status:"Status"});function sortAppInstancesList(appInstancesList){if(!$scope.sortBy){return}switch($scope.sortBy.mode){case"name":sortByName(appInstancesList);break;case"status":sortByStatus(appInstancesList);break;case"commit":appInstancesList=orderBy(appInstancesList,"-lastCommitTime");break;case"commit_for_user":appInstancesList=orderBy(appInstancesList,"-lastCommitTimeForUser");break}if($scope.sortBy.isReversedSort){appInstancesList.reverse()}return appInstancesList}function sortByName(appInstancesList){appInstancesList.sort(function(p1,p2){return alphabeticalSort(p1.name,p2.name)})}function sortByStatus(appInstancesList){Assert.inScope($rootScope,"appConfig");const projectStatusNames=[];$rootScope.appConfig.projectStatusList.forEach(function(s){projectStatusNames.push(s.name)});appInstancesList.sort(function(p1,p2){if(p1.projectStatus&&p2.projectStatus){var indexOfStatus1=projectStatusNames.indexOf(p1.projectStatus);var indexOfStatus2=projectStatusNames.indexOf(p2.projectStatus);return indexOfStatus1<indexOfStatus2?-1:indexOfStatus1===indexOfStatus2?alphabeticalSort(p1.name,p2.name):1}else if(p1.projectStatus){return-1}else if(p2.projectStatus){return 1}else{return alphabeticalSort(p1.name,p2.name)}})}$scope.deleteSelectedInstances=function(){const projectKeys=$scope.selectedProjects.map(p=>p.projectKey);$scope.deleteBusinessAppInstances(projectKeys).then($scope.fetchAppSummary).catch(setErrorInScope.bind($scope))};$scope.openInstanceMenu=function(project,$event){let template=`<ul class="dropdown-menu projects-dropdown-menu" >
        <li><a ng-click="toggleSelection()">{{selectedProjects.indexOf(project) < 0 ? 'Select' : 'Unselect'}}</a></li>
        <li><a ng-click="selectBefore()">Select all before</a></li>
        <li><a ng-click="selectAfter()">Select all after</a></li>
        <li><a ng-click="unselectBefore()">Unselect all before</a></li>
        <li><a ng-click="unselectAfter()">Unselect all after</a></li>
        </ul>`;let callback=newScope=>{newScope.projects=newScope.selectedProjects.length>0?newScope.selectedProjects:[project];newScope.project=project;newScope.appConfig=$scope.appConfig;newScope.toggleSelection=()=>toggleSelectProject(project);newScope.selectAfter=()=>toggleAllInstancesStartingFrom(project,true,true);newScope.selectBefore=()=>toggleAllInstancesStartingFrom(project,false,true);newScope.unselectAfter=()=>toggleAllInstancesStartingFrom(project,true,false);newScope.unselectBefore=()=>toggleAllInstancesStartingFrom(project,false,false)};let isElsewhere=(_,e)=>$(e.target).parents(".dropdown-menu").length===0;$scope.lockForPopup();let dkuPopinOptions={template:template,isElsewhere:isElsewhere,popinPosition:"CLICK",callback:callback,onDismiss:$scope.unlockAfterPopup};$scope.popupDismiss=openDkuPopin($scope,$event,dkuPopinOptions)};$scope.fetchAppSummary()});app.controller("BusinessAppNewInstanceModalController",function($scope,$rootScope,DataikuAPI,Dialogs,FutureProgressModal,WT1){function isProjectKeyUnique(value){return!$scope.allProjectKeys||$scope.allProjectKeys.indexOf(value)<0}function generateValidProjectKey(projectName){const slug=projectName.toUpperCase().replace(/\W+/g,"");let cur=slug;let i=2;while(!isProjectKeyUnique(cur)){cur=slug+"_"+i++}return cur}$scope.$watch("context.projectKey",function(nv){$scope.uniq=!nv||isProjectKeyUnique(nv)});$scope.$watch("context.projectName",function(nv){if(nv){$scope.context.projectKey=generateValidProjectKey(nv)}});$scope.create=function(){WT1.event("business-app-create-instance",{businessAppId:$scope.businessAppId,businessAppVersion:$scope.businessAppVersion});const parentScope=$scope.$parent;const runAsUser=$scope.allowRunAsUserOverride?$scope.context.runAsUser:null;DataikuAPI.businessApps.createInstance($scope.businessAppId,$scope.context.projectKey,$scope.context.projectName,$scope.context.shortDesc,runAsUser).success(data=>{FutureProgressModal.show(parentScope,data,"Create instance").then(function(result){if(result&&result.anyMessage){Dialogs.infoMessagesDisplayOnly(parentScope,"Create instance",result).then(function(){if(result.error){$scope.dismiss()}else{$scope.resolveModal({projectKey:result.projectKey,webAppId:result.businessAppWebAppId})}})}else{$scope.resolveModal({projectKey:result.projectKey,webAppId:result.businessAppWebAppId})}}).catch(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))};$scope.context={projectKey:"",projectName:"",shortDesc:"",runAsUser:""};$scope.usersLoaded=false;DataikuAPI.projects.listAllKeys().success(function(data){$scope.allProjectKeys=data;if($scope.context.projectName===""&&$scope.businessAppName){$scope.context.projectName=$scope.businessAppName;$scope.context.projectKey=generateValidProjectKey($scope.businessAppName)}}).error(setErrorInScope.bind($scope));$scope.$watch("allowRunAsUserOverride",function(){if($scope.allowRunAsUserOverride&&!$scope.usersLoaded){$scope.usersLoaded=true;DataikuAPI.security.listUsers().success(function(data){$scope.allUsers=data.sort((a,b)=>a.displayName.localeCompare(b.displayName));$scope.allUsersLogin=data.map(user=>"@"+user.login);if($scope.defaultRunAsUser&&$scope.defaultRunAsUser!=="%%INSTANCE_OWNER%%"){$scope.context.runAsUser=$scope.defaultRunAsUser}else{$scope.context.runAsUser=$rootScope.appConfig.login}}).error(setErrorInScope.bind($scope))}})})})();(function(){"use strict";const app=angular.module("dataiku.admin.clusters",[]);app.controller("ClusterCoreController",function($scope,CreateModalFromTemplate,KubernetesClusterService){$scope.openDeleteClusterModal=function(clusterId,actionAfterDeletion){var newScope=$scope.$new();newScope.clusterId=clusterId;newScope.actionAfterDeletion=actionAfterDeletion||function(){};CreateModalFromTemplate("/templates/admin/clusters/delete-cluster-modal.html",newScope,"ClusterDeleteController")};$scope.getStateDisplayString=KubernetesClusterService.getStateDisplayString;$scope.getStartStopButtonDisplayString=KubernetesClusterService.getStartStopButtonDisplayString;$scope.getStateDisplayClass=function(cluster){var classes={NONE:"icon-off none",RUNNING:"icon-play running",STARTING:"icon-play starting",STOPPING:"icon-unlink stopping","":"icon-question unknown"};if(cluster.state==null||cluster.type==="manual")return classes[""];return classes[cluster.state]};$scope.getStateDisplayClassNoIcon=function(cluster){var classes={NONE:"none",RUNNING:"running",STARTING:"starting",STOPPING:"stopping","":"question unknown"};if(cluster.state==null||cluster.type==="manual")return classes[""];return classes[cluster.state]};$scope.getCreatedByString=function(cluster){if(cluster.origin==null){return null}else if(cluster.origin.type==="MANUAL"){return"Created by "+cluster.origin.identifier}else if(cluster.origin.type==="SCENARIO"){return"Created by scenario "+cluster.origin.scenarioProjectKey+"."+cluster.origin.scenarioId}else{return null}}});app.controller("ClusterDeleteController",function($scope,Assert,DataikuAPI,FutureProgressModal){$scope.uiState={stop:true};DataikuAPI.admin.clusters.getStatus($scope.clusterId).success(function(data){$scope.clusterStatus=data}).error(setErrorInScope.bind($scope));$scope.doesntNeedStop=function(){return $scope.clusterStatus&&$scope.clusterStatus.clusterType!="manual"&&$scope.clusterStatus.state=="NONE"};$scope.mayNeedStop=function(){return $scope.clusterStatus&&$scope.clusterStatus.clusterType!="manual"&&$scope.clusterStatus.state!="NONE"};$scope.delete=function(){Assert.inScope($scope,"clusterStatus");if($scope.mayNeedStop()&&$scope.uiState.stop){var parentScope=$scope.$parent;DataikuAPI.admin.clusters.stop($scope.clusterId,true,false).success(function(data){$scope.dismiss();FutureProgressModal.show(parentScope,data,"Stop cluster",undefined,"static","false").then(function(result){if(result){$scope.actionAfterDeletion()}})}).error(setErrorInScope.bind($scope))}else{DataikuAPI.admin.clusters.delete($scope.clusterId).success(function(data){$scope.dismiss();$scope.actionAfterDeletion()}).error(setErrorInScope.bind($scope))}}});app.controller("ClustersController",function($scope,$controller,DataikuAPI,CreateModalFromTemplate,TopNav,FutureWatcher,KubernetesClusterService,ActivityIndicator,$rootScope,Dialogs){$controller("ClusterCoreController",{$scope:$scope});TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.uiState={query:null};$scope.clusters=[];$scope.getK8SClusterData=cluster=>{let handleError=()=>{cluster.data.state="ERROR"};DataikuAPI.admin.clusters.countNodesAndPods(cluster.id).success(initialResponse=>{let setResponse=response=>{cluster.data.count=response.result;cluster.data.state="LOADED"};if(initialResponse.hasResult){setResponse(initialResponse)}else{FutureWatcher.watchJobId(initialResponse.jobId).success(setResponse).error(handleError)}}).error(handleError)};$scope.getNodesMetrics=cluster=>{const clusterInScope=$scope.clusters.find(el=>el.id===cluster.id);let handleError=()=>{clusterInScope.metrics.state="ERROR"};DataikuAPI.admin.clusters.getNodesMetrics(cluster.id).success(initialResponse=>{let parseResponse=response=>{clusterInScope.metrics=response.result.reduce((accumulator,current)=>{accumulator.cpuUsage+=current.cpuUsage;accumulator.memoryUsage+=current.memoryUsage;return accumulator},{cpuUsage:0,memoryUsage:0});clusterInScope.metrics.cpuUsage=clusterInScope.metrics.cpuUsage/response.result.length|0;clusterInScope.metrics.memoryUsage=clusterInScope.metrics.memoryUsage/response.result.length|0;clusterInScope.metrics.state="LOADED"};if(initialResponse.hasResult){parseResponse(initialResponse)}else{FutureWatcher.watchJobId(initialResponse.jobId).success(parseResponse).error(handleError)}}).error(handleError)};$scope.refreshList=function(){$scope.refreshing=true;DataikuAPI.admin.clusters.list().success(function(data){data.sort((el1,el2)=>{if(el1.architecture===el2.architecture||el1.architecture!=="KUBERNETES"&&el2.architecture!=="KUBERNETES"){return 0}else{return el1.architecture==="KUBERNETES"?-1:1}});data.forEach(el=>{el.ui={};el["ui"]["typeName"]=KubernetesClusterService.getTypeDisplayName(el.type);el["ui"]["icon"]=KubernetesClusterService.getIcon(el.architecture,el.type);el.metricsServer="NOT_INSTALLED";if($scope.isK8sAndIsRunning(el)){if(el.canUpdateCluster){el.data={state:"LOADING"};el.metrics={state:"LOADING"};el.metricsServer="CHECKING";$scope.getK8SClusterData(el);const handleError=()=>{el.metricsServer="ERROR";el.metrics={state:"ERROR"}};const parseResponse=response=>{el.metricsServer=response.result?"INSTALLED":"NOT_INSTALLED";if(el.metricsServer==="INSTALLED"){$scope.getNodesMetrics(el)}};DataikuAPI.admin.clusters.hasMetricsServer(el.id).success(response=>{if(response.hasResult){parseResponse(response)}else{return FutureWatcher.watchJobId(response.jobId).success(parseResponse).error(handleError)}}).error(handleError)}else{el.metricsServer="INSUFFICIENT_PERMISSION";el.data={state:"INSUFFICIENT_PERMISSION"}}}});$scope.clusters=data;if(data.length===0){const basicClusterCreateOption={title:"Add Cluster",action:$scope.createCluster};if($scope.isPluginInstalled("eks")||$scope.isPluginInstalled("aks")||$scope.isPluginInstalled("gke")){$scope.createClusterOptions=[];const addPluginOption=name=>{if($scope.isPluginInstalled(name)){const currentOption={title:`Create ${name.toUpperCase()} cluster`,action:()=>$scope.createPluginCluster(name)};if(!$scope.mainCreateOption){$scope.mainCreateOption=currentOption}else{$scope.createClusterOptions.push(currentOption)}}};addPluginOption("eks");addPluginOption("aks");addPluginOption("gke");$scope.createClusterOptions.push(basicClusterCreateOption)}else{$scope.mainCreateOption=basicClusterCreateOption}}$scope.refreshing=false}).error(setErrorInScope.bind($scope))};$scope.filterClusters=function(clusterObject){if(!$scope.uiState.query)return true;const query=$scope.uiState.query.toLowerCase();return clusterObject&&clusterObject.name.toLowerCase().includes(query)||clusterObject.ui.typeName&&clusterObject.ui.typeName.toLowerCase().includes(query)||clusterObject.architecture&&clusterObject.architecture.toLowerCase().includes(query)};$scope.isK8sAndIsRunning=cluster=>{return cluster.architecture==="KUBERNETES"&&(cluster.state==="RUNNING"||cluster.type==="manual")};$scope.isK8sAndIsStopped=cluster=>{return cluster.architecture==="KUBERNETES"&&cluster.state!=="RUNNING"&&cluster.type!=="manual"};$scope.refreshList();$scope.createCluster=function(){CreateModalFromTemplate("/templates/admin/clusters/new-cluster-modal.html",$scope,"NewClusterController")};$scope.deleteCluster=(clusterId,architecture,type)=>{KubernetesClusterService.sendWt1Event("clusters-action-delete",architecture,type);$scope.openDeleteClusterModal(clusterId,function(){$scope.refreshList();KubernetesClusterService.sendWt1Event("clusters-status-deleted",architecture,type)})};$scope.downloadClusterDiagnostic=(clusterId,architecture,type)=>{ActivityIndicator.success("Preparing cluster diagnosis ...");KubernetesClusterService.sendWt1Event("clusters-action-diagdownload",architecture,type);downloadURL(DataikuAPI.admin.clusters.getDiagnosisURL(clusterId));KubernetesClusterService.sendWt1Event("clusters-status-diagdownloaded",architecture,type)};$scope.markStoppedCluster=(clusterId,architecture,type)=>{KubernetesClusterService.sendWt1Event("clusters-action-markstopped",architecture,type);DataikuAPI.admin.clusters.markStopped(clusterId).success(function(){$scope.refreshList();KubernetesClusterService.sendWt1Event("clusters-status-markstopped",architecture,type)}).error(setErrorInScope.bind($scope))};$scope.forceStopCluster=(clusterId,architecture,type)=>{Dialogs.confirm($scope,"Confirm cluster force stop","Are you sure you want to force stop the cluster?").then(()=>{KubernetesClusterService.stopCluster(true,$scope,clusterId,$scope.refreshList,architecture,type)},()=>{})};const getPluginCreateClusterType=function(cloud){return"pycluster_"+cloud+"-clusters_create-"+cloud+"-cluster"};$scope.isPluginInstalled=function(cloud){return $rootScope.appConfig.customPythonPluginClusters.some(pluginCluster=>pluginCluster.clusterType===getPluginCreateClusterType(cloud))};$scope.createPluginCluster=function(cloud){CreateModalFromTemplate("/templates/admin/clusters/new-cluster-modal.html",$scope,"NewClusterController",function(newScope){newScope.title="Create "+cloud.toUpperCase()+" cluster";newScope.newCluster={type:getPluginCreateClusterType(cloud),architecture:"KUBERNETES",params:{}};newScope.typeAlreadyKnown=true})}});app.controller("NewClusterController",function($scope,$rootScope,$state,DataikuAPI,KubernetesClusterService,PluginConfigUtils){const visibilityFilter=PluginConfigUtils.shouldComponentBeVisible($rootScope.appConfig.loadedPlugins);$scope.title=$scope.title||"Add cluster";$scope.newCluster=$scope.newCluster||{type:"manual",params:{}};$scope.clusterArchitectures=[{id:"HADOOP",label:"Hadoop"},{id:"KUBERNETES",label:"K8S"}];$scope.clusterTypes=[{id:"manual",label:"Non managed",architecture:"MANUAL"},...$rootScope.appConfig.customPythonPluginClusters.filter(visibilityFilter).filter(cluster=>!["pycluster_eks-clusters_create-eks-cluster","pycluster_aks-clusters_create-aks-cluster","pycluster_gke-clusters_create-gke-cluster"].includes(cluster.clusterType)).map(cluster=>({id:cluster.clusterType,label:cluster.desc.meta.label||cluster.id,architecture:cluster.desc.architecture||"HADOOP"}))];$scope.$watch("newCluster.type",function(){if($scope.newCluster.type&&$scope.newCluster.type!="manual"){let clusterType=$scope.clusterTypes.filter(function(t){return $scope.newCluster.type==t.id})[0];$scope.newCluster.architecture=clusterType?clusterType.architecture:null}});$scope.create=function(){var parentScope=$scope.$parent.$parent;KubernetesClusterService.sendWt1Event("clusters-action-create",$scope.newCluster.architecture,$scope.newCluster.type);DataikuAPI.admin.clusters.create($scope.newCluster).success(function(data){$scope.dismiss();parentScope.refreshList();$state.go("admin.clusters.cluster",{clusterId:data.id});KubernetesClusterService.sendWt1Event("clusters-status-created",data.architecture,data.type)}).error(setErrorInScope.bind($scope))}});app.controller("ClusterController",function($scope,$controller,$stateParams,Assert,DataikuAPI,$state,TopNav,FutureProgressModal,ActivityIndicator,$q,Logs,CreateModalFromTemplate,FutureWatcher,KubernetesClusterService,StateUtils,Dialogs){$controller("ClusterCoreController",{$scope:$scope});TopNav.setLocation(TopNav.DSS_HOME,"administration");$scope.uiState={active:$state.params.action?"actions":"info",logsQuery:"",detailedNodeData:false,detailedPodData:false};$scope.cluster={};$scope.origCluster={};$scope.listLogs=function(){DataikuAPI.admin.clusters.listLogs($scope.cluster.id).success(function(data){$scope.logs=data}).error(setErrorInScope.bind($scope))};$scope.refreshItem=function(){DataikuAPI.admin.clusters.get($stateParams.clusterId).success(function(data){$scope.cluster=data;$scope.origCluster=angular.copy(data);$scope.cluster.params=$scope.cluster.params||{};$scope.listLogs();$scope.refreshStatus()}).error(setErrorInScope.bind($scope))};$scope.refreshItem();$scope.getDisplayType=clusterType=>KubernetesClusterService.getTypeDisplayName(clusterType);$scope.refreshStatus=function(){if(!$scope.cluster.canUpdateCluster)return;DataikuAPI.admin.clusters.getStatus($stateParams.clusterId).success(function(data){$scope.clusterStatus=data}).error(setErrorInScope.bind($scope))};const dssObjectColumns=[{type:"dss-user",key:"dssSubmitter",columnName:"DSS user"},{type:"dss-project",key:"dssProjectKey",columnName:"DSS project"},{type:"dss-object",key:"dssExecutionType",columnName:"DSS object"}];const podMonitoringColumns={simple:["ready",{type:"pod-status",key:"status"},...dssObjectColumns],detailed:["ready",{type:"pod-status",key:"status"},"cpuRequestMillis","cpuLimitMillis","cpuCurrentMillis","memoryRequestMB","memoryLimitMB","memoryCurrentMB",...dssObjectColumns]};const nodeMonitoringColumns={simple:[{type:"node-status",key:"status"}],detailed:[{type:"node-status",key:"status"},"cpuCapacityMillis","cpuCurrentMillis","cpuLoad","memoryCapacityMB","memoryCurrentMB","memoryLoad"]};function calcPercent(value,max){const m=parseFloat(max),v=parseFloat(value);return isNaN(m)||isNaN(v)||m==0?"":Math.floor(100*Math.min(1,v/m))+"%"}const isNumericalRegex=/^\d+%$|^\d+ \/ \d+$/;$scope.resourceSort=function(a,b){if(a.type==="string"||b.type==="string"){let va=a.value||"";let vb=b.value||"";if(isNumericalRegex.test(va)||isNumericalRegex.test(vb)){va=parseFloat(va)||0;vb=parseFloat(vb)||0;return va-vb}return va.localeCompare(vb)}else if(a.type==="number"||b.type==="number"){return(a.value||0)-(b.value||0)}return 0};function buildDssObjectLink(item){if(!item["dssExecutionType"]||!item["onLocalDssNode"]){return""}const projectKey=item["dssProjectKey"];switch(item["dssExecutionType"]){case"ANALYSIS_ML_TRAIN":return StateUtils.href.analysis(item["analysisId"],projectKey,{tab:"ml.list"});case"WEBAPP_BACKEND":return StateUtils.href.webapp(item["webappId"],projectKey,{tab:"edit"});case"JUPYTER_NOTEBOOK_KERNEL":return StateUtils.href.jupyterNotebook(item["notebookId"],projectKey);case"EDA":return StateUtils.href.dataset(item["datasetName"],projectKey,{tab:"statistics"});case"JOB_ACTIVITY":return StateUtils.href.job(projectKey,item["jobId"]);case"CONTINUOUS_ACTIVITY":return StateUtils.href.continuousActivity(item["activityId"],projectKey);case"API_DEPLOYER_DEPLOYMENT":return StateUtils.href.apiDeployer.deployment(item["deploymentId"]);case"CODE_STUDIO":return StateUtils.href.codeStudio(item["codeStudioId"],projectKey);default:return""}}function addLinksToObjects(data){data.forEach(item=>{item.dssLink=buildDssObjectLink(item)})}$scope.clusterObjects=[{name:"Pod",state:"NONE",cols:podMonitoringColumns.simple,api:()=>DataikuAPI.admin.clusters.monitoring.getPods($stateParams.clusterId,$scope.namespaces.selectedMonitoringNamespaceFilter.filterType,$scope.namespaces.selectedMonitoringNamespaceFilter.name,$scope.uiState.detailedPodData),hasNamespace:true,parseClusterObjectData:data=>{data.forEach(pod=>{pod.ready=`${pod.readyContainerCount} / ${pod.containerCount}`});addLinksToObjects(data)}},{name:"Job",state:"NONE",cols:dssObjectColumns,api:()=>DataikuAPI.admin.clusters.monitoring.getJobs($stateParams.clusterId,$scope.namespaces.selectedMonitoringNamespaceFilter.filterType,$scope.namespaces.selectedMonitoringNamespaceFilter.name),parseClusterObjectData:addLinksToObjects,hasNamespace:true},{name:"Deployment",state:"NONE",cols:dssObjectColumns,api:()=>DataikuAPI.admin.clusters.monitoring.getDeployments($stateParams.clusterId,$scope.namespaces.selectedMonitoringNamespaceFilter.filterType,$scope.namespaces.selectedMonitoringNamespaceFilter.name),parseClusterObjectData:addLinksToObjects,hasNamespace:true},{name:"Service",state:"NONE",cols:["type",...dssObjectColumns],api:()=>DataikuAPI.admin.clusters.monitoring.getServices($stateParams.clusterId,$scope.namespaces.selectedMonitoringNamespaceFilter.filterType,$scope.namespaces.selectedMonitoringNamespaceFilter.name),parseClusterObjectData:addLinksToObjects,hasNamespace:true},{name:"Node",state:"NONE",cols:nodeMonitoringColumns.simple,api:()=>DataikuAPI.admin.clusters.monitoring.getNodes($stateParams.clusterId,$scope.uiState.detailedNodeData),hasNamespace:false,parseClusterObjectData:data=>{data.forEach(node=>{node.cpuLoad=calcPercent(node.cpuCurrentMillis,node.cpuCapacityMillis);node.memoryLoad=calcPercent(node.memoryCurrentMB,node.memoryCapacityMB)})}}];$scope.namespaces={loading:false,loaded:false,monitoringNamespaceFilterOptions:[{name:"None specified (kubectl default)",filterType:"NONE"},{name:"All",filterType:"ALL"},{name:"All but kube-system",filterType:"ALL_BUT_SYSTEM"}],parseClusterObjectData:data=>{$scope.namespaces.monitoringNamespaceFilterOptions=$scope.namespaces.monitoringNamespaceFilterOptions.filter(namespace=>namespace.filterType!=="LOADING");$scope.namespaces.loaded=true;data.forEach(namespace=>$scope.namespaces.monitoringNamespaceFilterOptions.push({name:namespace,filterType:"EXPLICIT"}))},api:()=>DataikuAPI.admin.clusters.monitoring.getNamespaces($stateParams.clusterId)};$scope.namespaces.selectedMonitoringNamespaceFilter=$scope.namespaces.monitoringNamespaceFilterOptions[2];$scope.$watch("uiState.detailedPodData",function(nv,ov){if(nv===true){$scope.clusterObjects[0].cols=podMonitoringColumns.detailed;$scope.refreshMonitoring()}else if(nv===false){$scope.clusterObjects[0].cols=podMonitoringColumns.simple}});$scope.$watch("uiState.detailedNodeData",function(nv,ov){if(nv){$scope.clusterObjects[4].cols=nodeMonitoringColumns.detailed;$scope.refreshMonitoring()}else{$scope.clusterObjects[4].cols=nodeMonitoringColumns.simple}});$scope.getClusterObjectData=clusterObject=>{if(!$scope.cluster.canUpdateCluster)return;clusterObject.state="NONE";const parseResponse=data=>{clusterObject.state="LOADED";if(clusterObject.parseClusterObjectData){clusterObject.parseClusterObjectData(data)}clusterObject.data=data};let handleError=(data,status,headers)=>{clusterObject.state="ERROR";setErrorInScope.bind($scope)(data,status,headers)};clusterObject.api().success(function(initialResponse){if(initialResponse.hasResult){parseResponse(initialResponse.result)}else{clusterObject.state="LOADING";FutureWatcher.watchJobId(initialResponse.jobId).success(data=>parseResponse(data.result)).error(handleError)}}).error(handleError)};$scope.goToClusterObjectMonitoring=function(clusterObject){$scope.uiState.activeMonitoring=clusterObject.name;if($scope.cluster.type==="manual"||$scope.cluster.state==="RUNNING"){$scope.getClusterObjectData(clusterObject)}KubernetesClusterService.sendWt1Event(`clusters-monitoring-${clusterObject.name}s-viewed`.toLowerCase(),$scope.cluster.architecture,$scope.cluster.type)};$scope.refreshMonitoring=function(){let clusterObject=$scope.clusterObjects.find(item=>item.name===$scope.uiState.activeMonitoring);$scope.getClusterObjectData(clusterObject)};$scope.getNamespaces=function(){if(($scope.cluster.type==="manual"||$scope.cluster.state==="RUNNING")&&!$scope.namespaces.loading&&!$scope.namespaces.loaded){$scope.namespaces.monitoringNamespaceFilterOptions.push({name:"Loading cluster namespaces...",filterType:"LOADING"});$scope.getClusterObjectData($scope.namespaces)}};$scope.setMonitoringNamespaceFilter=function(nv){$scope.namespaces.selectedMonitoringNamespaceFilter=nv;$scope.refreshMonitoring()};$scope.filterMonitoring=function(clusterObject){if(!$scope.uiState.monitoringQuery)return true;const query=$scope.uiState.monitoringQuery.toLowerCase();return clusterObject&&clusterObject.name.toLowerCase().includes(query)||clusterObject.status&&clusterObject.status.toLowerCase().includes(query)||clusterObject.namespace&&clusterObject.namespace.toLowerCase().includes(query)||clusterObject.type&&clusterObject.type.toLowerCase().includes(query)||clusterObject.dssSubmitter&&clusterObject.dssSubmitter.toLowerCase().includes(query)||clusterObject.dssExecutionType&&clusterObject.dssExecutionType.toLowerCase().includes(query)||clusterObject.dssProjectKey&&clusterObject.dssProjectKey.toLowerCase().includes(query)};$scope.showObjectDescribe=function(name,objectType,namespace){CreateModalFromTemplate("/templates/admin/clusters/k8s-object-describe-modal.html",$scope,null,function(newScope){newScope.uiState={mode:"describe"};newScope.objectName=name;newScope.objectType=objectType;newScope.clusterId=$scope.cluster.id;newScope.namespace=namespace;newScope.describeObject()})};$scope.clusterIsDirty=function(){if(!$scope.cluster||!$scope.origCluster)return false;return!angular.equals($scope.cluster,$scope.origCluster)};checkChangesBeforeLeaving($scope,$scope.clusterIsDirty);$scope.saveCluster=function(){var deferred=$q.defer();if(!$scope.clusterIsDirty()){deferred.resolve("Saved");return deferred.promise}KubernetesClusterService.sendWt1Event("clusters-action-save",$scope.cluster.architecture,$scope.cluster.type);DataikuAPI.admin.clusters.save(angular.copy($scope.cluster)).success(function(data){$scope.cluster=data;$scope.origCluster=angular.copy(data);deferred.resolve("Saved");KubernetesClusterService.sendWt1Event("clusters-status-saved",$scope.cluster.architecture,$scope.cluster.type)}).error(function(a,b,c){setErrorInScope.bind($scope)(a,b,c);deferred.reject("Not saved")});return deferred.promise};$scope.deleteCluster=function(){KubernetesClusterService.sendWt1Event("clusters-action-delete",$scope.cluster.architecture,$scope.cluster.type);$scope.openDeleteClusterModal($scope.cluster.id,function(){$state.go("admin.clusters.list");KubernetesClusterService.sendWt1Event("clusters-status-deleted",$scope.cluster.architecture,$scope.cluster.type)})};const doStartCluster=function(){Assert.inScope($scope,"cluster");KubernetesClusterService.sendWt1Event("clusters-action-start",$scope.cluster.architecture,$scope.cluster.type);return DataikuAPI.admin.clusters.start($scope.cluster.id).success(data=>FutureProgressModal.show($scope,data,"Start cluster",undefined,"static","false").then(function(result){if(result){$scope.refreshItem();KubernetesClusterService.sendWt1Event("clusters-status-started",$scope.cluster.architecture,$scope.cluster.type)}})).error(setErrorInScope.bind($scope))};const doStopCluster=function(forceStop){Assert.inScope($scope,"cluster");return KubernetesClusterService.stopCluster(forceStop,$scope,$scope.cluster.id,$scope.refreshItem,$scope.cluster.architecture,$scope.cluster.type)};const doLongRunningOperation=function(operation){$scope.isLongClusterOperationRunning=true;operation().finally(()=>$scope.isLongClusterOperationRunning=false)};const wrapLongClusterOperationRunning=function(operationName,needsConfirmation,operation){return()=>{if($scope.isLongClusterOperationRunning){return}if(needsConfirmation){Dialogs.confirm($scope,"Confirm cluster "+operationName,"Are you sure you want to "+operationName+" the cluster?").then(()=>{doLongRunningOperation(operation)},()=>{})}else{doLongRunningOperation(operation)}}};$scope.startCluster=wrapLongClusterOperationRunning("start",false,function(){return $scope.saveCluster().then(doStartCluster)});$scope.stopCluster=wrapLongClusterOperationRunning("stop",true,function(){return doStopCluster(false)});$scope.forceStopCluster=wrapLongClusterOperationRunning("force stop",true,function(){return doStopCluster(true)});$scope.markStoppedCluster=function(){Assert.inScope($scope,"cluster");KubernetesClusterService.sendWt1Event("clusters-action-markstopped",$scope.cluster.architecture,$scope.cluster.type);DataikuAPI.admin.clusters.markStopped($scope.cluster.id).success(function(){$scope.refreshItem();KubernetesClusterService.sendWt1Event("clusters-status-markstopped",$scope.cluster.architecture,$scope.cluster.type)}).error(setErrorInScope.bind($scope))};$scope.currentLogName=null;$scope.currentLog=null;$scope.fetchLog=function(logName){DataikuAPI.admin.clusters.getLog($scope.cluster.id,logName).success(function(data){$scope.currentLogName=logName;$scope.currentLog=data;KubernetesClusterService.sendWt1Event("clusters-logs-opened",$scope.cluster.architecture,$scope.cluster.type)}).error(setErrorInScope.bind($scope))};$scope.streamLog=function(logName){Logs.downloadCluster($scope.cluster.id,logName)};$scope.downloadClusterDiagnostic=function(){ActivityIndicator.success("Preparing cluster diagnosis ...");KubernetesClusterService.sendWt1Event("clusters-action-diagdownload",$scope.cluster.architecture,$scope.cluster.type);downloadURL(DataikuAPI.admin.clusters.getDiagnosisURL($scope.cluster.id));KubernetesClusterService.sendWt1Event("clusters-status-diagdownloaded",$scope.cluster.architecture,$scope.cluster.type)}});app.controller("K8SObjectDescribeController",function($rootScope,$scope,DataikuAPI,FutureWatcher,Dialogs,Logs){$scope.describeObject=function(){DataikuAPI.admin.clusters.monitoring.describeObject($scope.clusterId,$scope.objectType.toLowerCase(),$scope.objectName,$scope.namespace).success(function(initialResponse){if(initialResponse.hasResult){$scope.describeResult=initialResponse.result.out;$scope.err=initialResponse.result.err;$scope.code=initialResponse.result.rv}else{$scope.loading=true;FutureWatcher.watchJobId(initialResponse.jobId).success(function(data){$scope.loading=false;$scope.describeResult=data.result.out;$scope.err=data.result.err;$scope.code=data.result.rv}).update(function(){$scope.loading=true}).error(function(data,status,headers){$scope.loading=false;setErrorInScope.bind($scope)(data,status,headers)})}}).error(setErrorInScope.bind($scope))};$scope.tailPodLog=function(){DataikuAPI.admin.clusters.monitoring.tailPodLog($scope.clusterId,$scope.objectName,$scope.namespace).success(function(data){$scope.podLogTail=data}).error(setErrorInScope.bind($scope))};$scope.downloadPodLog=function(){if($scope.objectType!=="Pod"){return}Logs.downloadPod($scope.clusterId,$scope.objectName,$scope.namespace)};$scope.switchToDescribe=function(){$scope.uiState.mode="describe";$scope.describeObject()};$scope.switchToLogs=function(){$scope.uiState.mode="logs";$scope.tailPodLog()};$scope.canDeleteObject=function(){return["Pod","Job","Service","Deployment"].includes($scope.objectType)};$scope.deleteObject=function(){if(!$scope.canDeleteObject()){return}Dialogs.confirmPositive($scope,"Delete "+$scope.objectType,"Are you sure you want to delete this {0}?".format($scope.objectType.toLowerCase())).then(function(){$scope.deleting=true;let handleSuccess=response=>{$scope.refreshMonitoring();$scope.deleting=false;$scope.deleteResult=response.result.out;$scope.err=response.result.err;$scope.code=response.result.rv};DataikuAPI.admin.clusters.monitoring.deleteObject($scope.clusterId,$scope.objectType.toLowerCase(),$scope.objectName,$scope.namespace).success(function(initialResponse){if(initialResponse.hasResult){handleSuccess(initialResponse)}else{FutureWatcher.watchJobId(initialResponse.jobId).success(function(data){handleSuccess(data)}).update(function(){$scope.deleting=true}).error(function(data,status,headers){$scope.deleting=false;setErrorInScope.bind($scope)(data,status,headers)})}}).error(setErrorInScope.bind($scope))},function(){})}});app.directive("clusterParamsForm",function(Assert,$rootScope,PluginConfigUtils){return{restrict:"A",templateUrl:"/templates/admin/clusters/cluster-params-form.html",scope:{params:"=",clusterType:"="},link:function($scope,element,attrs){$scope.$watch("clusterType",function(){if(!$scope.clusterType)return;$scope.loadedDesc=$rootScope.appConfig.customPythonPluginClusters.filter(function(x){return x.clusterType==$scope.clusterType})[0];Assert.inScope($scope,"loadedDesc");$scope.desc=$scope.loadedDesc.desc;$scope.params.config=$scope.params.config||{};PluginConfigUtils.setDefaultValues($scope.desc.params,$scope.params.config);$scope.pluginDesc=$rootScope.appConfig.loadedPlugins.filter(function(x){return x.id==$scope.loadedDesc.ownerPluginId})[0]})}}});app.directive("clusterActionsForm",function($rootScope,DataikuAPI,CreateModalFromTemplate,KubernetesClusterService){return{restrict:"A",templateUrl:"/templates/admin/clusters/cluster-actions-form.html",scope:{params:"=",clusterId:"=",clusterType:"=",clusterArchitecture:"=",clusterState:"="},link:function($scope){var refreshClusterActions=function(){$scope.clusterActions=[];const pluginsById=$rootScope.appConfig.loadedPlugins.reduce(function(map,obj){map[obj.id]=obj;return map},{});$rootScope.appConfig.customRunnables.forEach(function(runnable){if(!runnable.desc.macroRoles)return;const plugin=pluginsById[runnable.ownerPluginId];if(!plugin||plugin.hideComponents)return;runnable.desc.macroRoles.forEach(function(macroRole){if(macroRole.type!="CLUSTER")return;if(macroRole.limitToSamePlugin){if(!$scope.loadedDesc||runnable.ownerPluginId!=$scope.loadedDesc.ownerPluginId)return}$scope.clusterActions.push({label:runnable.desc.meta.label||runnable.id,icon:runnable.desc.meta.icon||plugin.icon,roleTarget:macroRole.targetParamsKey||macroRole.targetParamsKeys,runnable:runnable})})});$scope.isManualOrRunning=()=>{return $scope.clusterType==="manual"||$scope.clusterState==="RUNNING"};if($scope.clusterArchitecture==="KUBERNETES"){$scope.k8sActions=[{label:"Run kubectl command",description:"Run an arbitrary kubectl command",icon:"icon-play",hasFilters:false,customCommand:true,check:()=>{return $scope.$parent.isDSSAdmin()}},{label:"Delete finished pods",description:"Delete succeeded and failed pods",command:"delete pods --field-selector=status.phase!=Pending,status.phase!=Running,status.phase!=Unknown",icon:"icon-trash",hasFilters:true,wt1Event:"clusters-action-deletefinishedpods",controller:"RunPredefinedK8sActionController",api:DataikuAPI.admin.clusters.deleteFinishedPods,customCommand:false},{label:"Delete all pods",description:"Delete all pods",command:"delete --all pods",icon:"icon-trash",hasFilters:true,wt1Event:"clusters-action-deleteallpods",controller:"RunPredefinedK8sActionController",api:DataikuAPI.admin.clusters.deleteAllPods,customCommand:false},{label:"Delete finished jobs",description:"Delete finished jobs",icon:"icon-trash",hasFilters:true,wt1Event:"clusters-action-deletefinishedjobs",controller:"DeleteFinishedJobsController",customCommand:false}];$scope.showRunK8sAction=function(clusterId,{command,longDescription,label,icon,hasFilters,controller,wt1Event,api,customCommand}){KubernetesClusterService.sendWt1Event(wt1Event,$scope.clusterArchitecture,$scope.clusterType);let actionController=controller?controller:"RunK8sActionController";CreateModalFromTemplate("/templates/admin/clusters/run-k8s-action-modal.html",$scope,actionController,newScope=>{newScope.customCommand=customCommand;newScope.longDescription=longDescription;newScope.hasFilters=hasFilters;newScope.clusterId=clusterId;newScope.command=command?command:"";newScope.label=label;newScope.icon=icon;newScope.api=api;newScope.fullCommand="kubectl "+newScope.command})};$scope.getActionByLabel=label=>{return $scope.k8sActions.find(action=>action.label===label)};if($rootScope.$state.params&&$rootScope.$state.params.action){let action=$scope.getActionByLabel($rootScope.$state.params.action);$scope.showRunK8sAction($scope.clusterId,action)}}$scope.showCreateRunnable=function(clusterId,{roleTarget,runnable}){CreateModalFromTemplate("/templates/macros/runnable-modal.html",$scope,null,function(newScope){newScope.runnable=runnable;newScope.targetKey=roleTarget;newScope.targetValue=clusterId;newScope.cluster=true})}};$scope.$watch("clusterType",function(){if(!$scope.clusterType)return;$scope.loadedDesc=$rootScope.appConfig.customPythonPluginClusters.filter(function(x){return x.clusterType==$scope.clusterType})[0];refreshClusterActions()})}}});app.directive("clusterActionTile",function(){return{restrict:"E",templateUrl:"/templates/admin/clusters/cluster-action-tile.html",scope:{action:"<",clusterId:"<",showCallback:"<",description:"<?"},link:function($scope){if($scope.description===undefined){$scope.description=$scope.action.description}}}});app.service("KubernetesClusterService",(DataikuAPI,FutureWatcher,FutureProgressModal,WT1)=>{const svc={};const EKS_CREATE_TYPE="pycluster_eks-clusters_create-eks-cluster";const EKS_ATTACH_TYPE="pycluster_eks-clusters_attach-eks-cluster";const AKS_CREATE_TYPE="pycluster_aks-clusters_create-aks-cluster";const AKS_ATTACH_TYPE="pycluster_aks-clusters_attach-aks-cluster";const GKE_CREATE_TYPE="pycluster_gke-clusters_create-gke-cluster";const GKE_ATTACH_TYPE="pycluster_gke-clusters_attach-gke-cluster";const EMR_CREATE_TYPE="pycluster_emr-clusters_emr-create-cluster";const EMR_ATTACH_TYPE="pycluster_emr-clusters_emr-attach-cluster";svc.getTypeDisplayName=type=>{switch(type){case EKS_CREATE_TYPE:return"EKS (managed)";case EKS_ATTACH_TYPE:return"EKS (attach)";case AKS_CREATE_TYPE:return"AKS (managed)";case AKS_ATTACH_TYPE:return"AKS (attach)";case GKE_CREATE_TYPE:return"GKE (managed)";case GKE_ATTACH_TYPE:return"GKE (attach)";case EMR_CREATE_TYPE:return"EMR (managed)";case EMR_ATTACH_TYPE:return"EMR (attach)";default:return type}};svc.getStartStopButtonDisplayString=(cluster,isStart)=>{switch(cluster.type){case EKS_CREATE_TYPE:case AKS_CREATE_TYPE:case GKE_CREATE_TYPE:case EMR_CREATE_TYPE:return isStart?"Start":"Stop";case EKS_ATTACH_TYPE:case AKS_ATTACH_TYPE:case GKE_ATTACH_TYPE:case EMR_ATTACH_TYPE:return isStart?"Attach":"Detach";default:return isStart?"Start/Attach":"Stop/Detach"}};svc.getStateDisplayString=cluster=>{let displayNames=null;switch(cluster.type){case EKS_CREATE_TYPE:case AKS_CREATE_TYPE:case GKE_CREATE_TYPE:case EMR_CREATE_TYPE:displayNames={NONE:"Stopped",RUNNING:"Running",STARTING:"Starting",STOPPING:"Stopping"};break;case EKS_ATTACH_TYPE:case AKS_ATTACH_TYPE:case GKE_ATTACH_TYPE:case EMR_ATTACH_TYPE:displayNames={NONE:"Detached",RUNNING:"Attached",STARTING:"Attaching",STOPPING:"Detaching"};break;default:displayNames={NONE:"Stopped/Detached",RUNNING:"Running/Attached",STARTING:"Starting/Attaching",STOPPING:"Stopping/Detaching"};break}if(cluster.state==null){return"Unknown"}return displayNames[cluster.state]||"unknown"};svc.getIcon=(architecture,type)=>{if(architecture==="KUBERNETES"){switch(type){case EKS_CREATE_TYPE:case EKS_ATTACH_TYPE:return"icon-amazon-elastic-kubernetes";case AKS_CREATE_TYPE:case AKS_ATTACH_TYPE:return"icon-azure-kubernetes-services";case GKE_CREATE_TYPE:case GKE_ATTACH_TYPE:return"icon-gcp-kubernetes-engine";default:return"icon-gcp-kubernetes-engine"}}else if(architecture==="HADOOP"){return"icon-HDFS"}return"icon-question"};svc.getTypeForWt1=function(clusterType){if(["manual","pycluster_eks-clusters_create-eks-cluster","pycluster_eks-clusters_attach-eks-cluster","pycluster_aks-clusters_create-aks-cluster","pycluster_aks-clusters_attach-aks-cluster","pycluster_gke-clusters_create-gke-cluster","pycluster_gke-clusters_attach-gke-cluster"].includes(clusterType)){return clusterType}else{return"custom"}};svc.sendWt1Event=function(eventName,architecture,type){WT1.event(eventName,{architecture:architecture,type:svc.getTypeForWt1(type)})};svc.stopCluster=(forceStop,scope,clusterId,successCallBack,architecture,type)=>{svc.sendWt1Event(forceStop?"clusters-action-forcestop":"clusters-action-stop",architecture,type);return DataikuAPI.admin.clusters.stop(clusterId,false,forceStop).success(data=>FutureProgressModal.show(scope,data,"Stop cluster",undefined,"static","false").then(function(result){if(result){successCallBack();svc.sendWt1Event("clusters-status-stopped",architecture,type)}})).error(setErrorInScope.bind(scope))};return svc});app.controller("BaseK8sActionController",($scope,FutureWatcher)=>{$scope.running=false;$scope.dryRun=true;$scope.hasFilters=true;$scope.hasAdditionalOptions=false;$scope.hasCommandDryRunFlag=()=>{return true};$scope.buildCommandArgs=()=>{throw new Error("Method buildCommandArgs should not be called from the base controller")};$scope.callApi=()=>{throw new Error("Method callApi should not be called from the base controller")};$scope.resetCommandResult=()=>{$scope.output="";$scope.err="";$scope.code=""};$scope.run=()=>{let parseResponse=response=>{if($scope.fatalAPIError){delete $scope.fatalAPIError}$scope.running=false;$scope.output=response.result.out;$scope.err=response.result.err;$scope.code=response.result.rv};let handleError=(data,status,headers,config,statusText,xhrStatus)=>{$scope.running=false;setErrorInScope.bind($scope)(data,status,headers,config,statusText,xhrStatus)};$scope.resetCommandResult();$scope.running=true;$scope.callApi().success(initialResponse=>{if(initialResponse.hasResult){parseResponse(initialResponse)}else{FutureWatcher.watchJobId(initialResponse.jobId).success(parseResponse).error(handleError)}}).error(handleError)};$scope.extendedResetSetting=()=>{return};$scope.resetSettings=()=>{$scope.extendedResetSetting();$scope.namespaceFilter="";$scope.labelFilter="";$scope.commandArgs="";$scope.dryRun=true;$scope.resetCommandResult();$scope.updateCommand()};$scope.updateCommand=()=>{$scope.fullCommand="kubectl "+$scope.buildCommandArgs()}});app.controller("RunK8sActionController",($scope,$controller,DataikuAPI)=>{$controller("BaseK8sActionController",{$scope:$scope});const commandsWithDryRun=["create","run","expose","delete","apply","annotate","autoscale","label","patch","replace","scale","set","reconcile","cordon","drain","taint","uncordon","undo"];const DRY_RUN_FLAG=" --dry-run=client";const EXEC_SEPARATOR=" -- ";$scope.hasCommandDryRunFlag=()=>{let commandArgs=$scope.commandArgs||$scope.command||"";let commandParts=commandArgs.split(" ");return commandParts.some(el=>commandsWithDryRun.includes(el))};$scope.buildCommandArgs=()=>{let commandArgs=$scope.commandArgs||$scope.command||"";commandArgs+=$scope.namespaceFilter&&$scope.namespaceFilter.trim()!==""?" --namespace "+$scope.namespaceFilter:"";if($scope.labelFilter&&$scope.labelFilter.trim()!==""){if(commandArgs.match(/\s--all[\s$]/)){commandArgs=commandArgs.replace(/\s--all[\s$]/," ")}commandArgs+=" -l "+$scope.labelFilter}if($scope.dryRun&&$scope.hasCommandDryRunFlag()){if(commandArgs.includes(EXEC_SEPARATOR)){commandArgs=commandArgs.replace(EXEC_SEPARATOR,`${DRY_RUN_FLAG} ${EXEC_SEPARATOR}`)}else{commandArgs+=DRY_RUN_FLAG}}return commandArgs};$scope.callApi=()=>{let commandWithFilters=$scope.buildCommandArgs();return DataikuAPI.admin.clusters.runKubectl($scope.clusterId,commandWithFilters)}});app.controller("RunPredefinedK8sActionController",($scope,$controller)=>{$controller("RunK8sActionController",{$scope:$scope});$scope.callApi=()=>{return $scope.api($scope.clusterId,$scope.dryRun,$scope.namespaceFilter,$scope.labelFilter)}});app.controller("DeleteFinishedJobsController",($scope,$controller,DataikuAPI)=>{$controller("BaseK8sActionController",{$scope:$scope});const COMMAND="delete jobs $(kubectl  get job -o go-template='{{range $i, $p := .items}}{{range .status.conditions}}{{if TYPE_FILTER}}{{$p.metadata.name}}{{\" \"}}{{end}}{{end}}{{end}}'LABEL_FILTER NAMESPACE_FILTER)NAMESPACE_FILTER";const COMPLETE_JOB_FILTER='(eq .type "Complete")';const COMPLETE_AND_FAILED_JOB_FILTER='or (eq .type "Failed") (eq .type "Complete")';$scope.hasAdditionalOptions=true;$scope.deleteFailed=false;$scope.fullCommand="kubectl "+$scope.command;$scope.buildCommandArgs=()=>{let commandArgs=COMMAND;commandArgs=commandArgs.replace("TYPE_FILTER",$scope.deleteFailed?COMPLETE_AND_FAILED_JOB_FILTER:COMPLETE_JOB_FILTER);let namespaceReplacement=$scope.namespaceFilter&&$scope.namespaceFilter.trim()!==""?" -n "+$scope.namespaceFilter:"";commandArgs=commandArgs.replaceAll("NAMESPACE_FILTER",namespaceReplacement);let labelReplacement=$scope.labelFilter&&$scope.labelFilter.trim()!==""?" -l "+$scope.labelFilter:"";commandArgs=commandArgs.replaceAll("LABEL_FILTER",labelReplacement);if($scope.dryRun){commandArgs+=" --dry-run=client"}return commandArgs};$scope.callApi=()=>{return DataikuAPI.admin.clusters.deleteFinishedJobs($scope.clusterId,$scope.dryRun,$scope.deleteFailed,$scope.namespaceFilter,$scope.labelFilter)};$scope.extendedResetSetting=()=>{$scope.deleteFailed=false}});app.directive("hadoopClusterSettingsBlock",function($rootScope){return{restrict:"A",templateUrl:"/templates/admin/clusters/fragments/hadoop-cluster-settings-block.html",scope:{settings:"=",mask:"=",impersonationEnabled:"="},link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;$scope.addLicInfo=$rootScope.addLicInfo}}});app.directive("hiveClusterSettingsBlock",function($rootScope,CodeMirrorSettingService){return{restrict:"A",templateUrl:"/templates/admin/clusters/fragments/hive-cluster-settings-block.html",scope:{settings:"=",hadoopSettings:"=",mask:"=",impersonationEnabled:"="},link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;$scope.addLicInfo=$rootScope.addLicInfo;$scope.codeMirrorSettingService=CodeMirrorSettingService;$scope.copyHadoopSettings=function(){if(!$scope.settings)return;if(!$scope.hadoopSettings)return;var hiveProps=$scope.settings.executionConfigsGenericOverrides;var hadoopPropsNames=$scope.hadoopSettings.extraConf.map(function(p){return p.key});hadoopPropsNames.forEach(function(k){var indices=hiveProps.map(function(p,i){return p.key==k?i:null}).filter(function(x){return x!=null});indices.reverse().forEach(function(i){hiveProps.splice(i,1)})});$scope.hadoopSettings.extraConf.forEach(function(p){var hp=angular.copy(p);hiveProps.push(hp)});$scope.settings.executionConfigsGenericOverrides=[].concat(hiveProps)}}}});app.directive("impalaClusterSettingsBlock",function($rootScope){return{restrict:"A",templateUrl:"/templates/admin/clusters/fragments/impala-cluster-settings-block.html",scope:{settings:"=",mask:"=",impersonationEnabled:"="},link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;$scope.addLicInfo=$rootScope.addLicInfo}}});app.directive("sparkClusterSettingsBlock",function(DataikuAPI,$rootScope,FutureProgressModal,ActivityIndicator,FeatureFlagsService){return{restrict:"A",templateUrl:"/templates/admin/clusters/fragments/spark-cluster-settings-block.html",scope:{settings:"=",hadoopSettings:"=",mask:"=",impersonationEnabled:"=",clusterId:"="},link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;$scope.addLicInfo=$rootScope.addLicInfo;$scope.executionEngines=[{value:null,label:"Disabled"},{value:"SPARK_SUBMIT",label:"Enabled"}];$scope.copyHadoopSettings=function(){if(!$scope.settings)return;if(!$scope.hadoopSettings)return;var sparkProps=$scope.settings.executionConfigsGenericOverrides;var hadoopPropsNames=$scope.hadoopSettings.extraConf.map(function(p){return p.key});hadoopPropsNames.forEach(function(k){var indices=sparkProps.map(function(p,i){return p.key=="spark.hadoop."+k?i:null}).filter(function(x){return x!=null});indices.reverse().forEach(function(i){sparkProps.splice(i,1)})});$scope.hadoopSettings.extraConf.forEach(function(p){var sp=angular.copy(p);sp.key="spark.hadoop."+p.key;sparkProps.push(sp)});$scope.settings.executionConfigsGenericOverrides=[].concat(sparkProps)};$scope.preloadYarnClusterFiles=function(yarnClusterSettings){DataikuAPI.admin.clusters.preloadYarnClusterFiles(yarnClusterSettings).success(function(data){FutureProgressModal.show($scope,data,"Preload files on cluster",undefined,"static","false").then(function(result){})}).error(setErrorInScope.bind($scope))};$scope.sparkVersionsCompatible=function(dssVersion,livyVersion){if(dssVersion==null||dssVersion.length==0)dssVersion=$rootScope.appConfig.sparkVersion;if(dssVersion==null||dssVersion.length==0)return true;if(livyVersion==null||livyVersion.length==0)return true;return dssVersion.substring(0,2)==livyVersion.substring(0,2)};$scope.shouldUseYarnCluster=function(sparkMaster,deployMode){if(sparkMaster=="yarn"&&deployMode=="cluster")return true;if(sparkMaster=="yarn-cluster")return true;return false}}}});app.directive("containerClusterSettingsBlock",function(DataikuAPI,WT1,$rootScope,FutureProgressModal,Dialogs,CodeMirrorSettingService){return{restrict:"A",templateUrl:"/templates/admin/clusters/fragments/container-cluster-settings-block.html",scope:{settings:"=",mask:"=",impersonationEnabled:"=",clusterId:"=",k8sClusters:"=",clusterDefinedConfig:"="},link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;$scope.addLicInfo=$rootScope.addLicInfo;$scope.codeMirrorSettingService=CodeMirrorSettingService;$scope.getNewContainerConfig=function(){return{type:"KUBERNETES",usableBy:"ALL",allowedGroups:[],workloadType:"ANY",dockerResources:[],kubernetesResources:{memRequestMB:-1,memLimitMB:-1,cpuRequest:-1,cpuLimit:-1,customRequests:[],customLimits:[],hostPathVolumes:[]},customSHMValueMB:-1,properties:[]}};DataikuAPI.security.listGroups(false).success(data=>{if(data){data.sort()}$scope.allGroups=data}).error(setErrorInScope.bind($scope));$scope.isBaseImageNameSuspicious=function(baseImage){return/^(?:[\w-_]+\.)+\w+(?::\d+)?\//.test(baseImage)};var testErrors={};$scope.getTestError=function(config){let s=testErrors[config.name];return s!=null?s.fatalAPIError:null};$scope.testConf=function(configuration,clusterId){testErrors[configuration.name]={};DataikuAPI.admin.containerExec.testConf(configuration,$scope.clusterDefinedConfig,clusterId||$scope.clusterId,$scope.settings.executionConfigsGenericOverrides).success(function(data){FutureProgressModal.show($scope,data,"Testing container configuration",undefined,"static","false").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Container test result",result.messages,result.futureLog)}})}).error(setErrorInScope.bind(testErrors[configuration.name]));WT1.event("container-conf-test")};$scope.getExtraClusters=function(){if(!$scope.k8sClusters)return[];return $scope.k8sClusters.filter(function(c){return(c.id||"__builtin__")!=($scope.clusterId||"__builtin__")})}}}});app.directive("clusterSecurityPermissions",function(DataikuAPI,$rootScope,PermissionsService){return{restrict:"A",templateUrl:"/templates/admin/clusters/fragments/security-permissions.html",replace:true,scope:{cluster:"="},link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;$scope.ui={};function makeNewPerm(){$scope.newPerm={update:true,use:true}}makeNewPerm();const fixupPermissions=function(){if(!$scope.cluster)return;$scope.cluster.permissions.forEach(function(p){p.$updateDisabled=false;p.$manageUsersDisabled=false;p.$useDisabled=false;if($scope.cluster.usableByAll){p.$useDisabled=true}if(p.update){p.$useDisabled=true}if(p.manageUsers){p.$useDisabled=true;p.$updateDisabled=true}})};DataikuAPI.security.listGroups(false).success(function(allGroups){if(allGroups){allGroups.sort()}$scope.allGroups=allGroups;DataikuAPI.security.listUsers().success(function(data){$scope.allUsers=data.sort((a,b)=>a.displayName.localeCompare(b.displayName));$scope.allUsersLogin=$scope.allUsers.map(user=>"@"+user.login)}).error(setErrorInScope.bind($scope));$scope.unassignedGroups=PermissionsService.buildUnassignedGroups($scope.cluster,$scope.allGroups)}).error(setErrorInScope.bind($scope));$scope.$watch("cluster.owner",function(){$scope.ui.ownerLogin=$scope.cluster.owner});$scope.addPermission=function(){$scope.cluster.permissions.push($scope.newPerm);makeNewPerm()};$scope.$watch("cluster.usableByAll",function(nv,ov){fixupPermissions()});$scope.$watch("cluster.permissions",function(nv,ov){if(!nv)return;$scope.unassignedGroups=PermissionsService.buildUnassignedGroups($scope.cluster,$scope.allGroups);fixupPermissions()},true);$scope.$watch("cluster.permissions",function(nv,ov){if(!nv)return;$scope.unassignedGroups=PermissionsService.buildUnassignedGroups($scope.cluster,$scope.allGroups);fixupPermissions()},false);$scope.unassignedGroups=PermissionsService.buildUnassignedGroups($scope.cluster,$scope.allGroups);fixupPermissions();$scope.$watch("ui.ownerLogin",function(){PermissionsService.transferOwnership($scope,$scope.cluster,"cluster")})}}})})();(function(){"use strict";const app=angular.module("dataiku.admin.charts_dashboards",[]);app.controller("ChartsAndDashboardsController",function($scope,$timeout,DSSVisualizationTheming,DefaultDSSVisualizationTheme){$scope.promises.then(function(){if(!$scope.generalSettings.selectedDSSVisualizationThemeId){$scope.generalSettings.selectedDSSVisualizationThemeId=DefaultDSSVisualizationTheme.id}});$scope.handleCurrentThemeIdChange=id=>{$timeout(()=>{$scope.generalSettings.selectedDSSVisualizationThemeId=id})}})})();(function(){"use strict";const app=angular.module("dataiku.admin.stories_themes",[]);app.controller("StoriesThemesController",function($scope,$timeout,DataikuAPI){$scope.checkDatastoryIntegration=function(){DataikuAPI.admin.datastory.check().success(function(data){$scope.datastoryIntegrationCheckResult=data}).error(setErrorInScope.bind($scope))};$scope.checkDatastoryIntegration();$scope.handleThemeDefaultIdChange=themeId=>{$timeout(()=>{$scope.generalSettings.dataikuStoriesSettings.themeDefaultId=themeId})}})})();(function(){"use strict";const app=angular.module("dataiku.plugindev",["dataiku.plugindev.git"]);app.controller("PlugindevCommonController",function($rootScope,$scope,DataikuAPI,$controller,$state,$stateParams,$filter,CreateModalFromTemplate,TopNav,FutureWatcher,WT1,FutureProgressModal,Dialogs,AgentCodeTemplates){TopNav.setLocation(TopNav.DSS_HOME,"plugin");const COMPONENT_IDENTIFIER_PLACEHOLDER="use-this-kind-of-case";if($scope.appConfig.pluginDevGitMode==="PLUGIN"){$controller("_PlugindevGitController",{$scope:$scope})}let regularPyAndJavaDescriptors=[{key:"python",label:"Python"},{key:"java",label:"Java"}];let regularPyOnlyDescriptor=[{key:"python",label:"Python"}];let regularJavaOnlyDescriptor=[{key:"java",label:"Java"}];let regularJythonOnlyDescriptor=[{key:"jython",label:"Python"}];let regularPyAndRDescriptors=[{key:"python",label:"Python"},{key:"r",label:"R"}];let regularGenericOnlyDescriptor=[{key:"generic",label:"Generic"}];let downloadIframe=$("<iframe>").attr("id","plugin-downloader");downloadIframe[0].onload=function(){if(this.contentDocument.URL!=="about:blank"){CreateModalFromTemplate("/templates/plugins/modals/plugin-download-error.html",$scope)}};function getIdentifierHint(typeName=""){return`Unique identifier for the new ${typeName} type. <br> It should not start with the plugin id and must be unique across the ${typeName} components of this plugin.`}$scope.initContentTypeList=function(pluginData=$scope.pluginData){let codeEnvSpec=pluginData.installedDesc&&pluginData.installedDesc.codeEnvSpec;$scope.contentTypeList=[{name:"Code Env",type:"codeEnv",icon:"icon-cogs",iconColor:"universe-color more",disabled:codeEnvSpec!=null,disabledReason:"Only one code env can exist in a plugin",description:"Create the code environment associated with this plugin, defining required libraries and their versions.",addDescriptors:regularPyAndRDescriptors,addFuncMap:{python:DataikuAPI.plugindev.addPythonCodeEnv,r:DataikuAPI.plugindev.addRCodeEnv}},{name:"Dataset",type:"customDatasets",icon:"icon-database",iconColor:"universe-color datasets",description:"Create a new type of dataset. This is generally used to fetch data from an external service, for example using an API",addDescriptors:regularPyAndJavaDescriptors,addFuncMap:{java:DataikuAPI.plugindev.addJavaDataset,python:DataikuAPI.plugindev.addPythonDataset},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("dataset")},{name:"Recipe",type:"customCodeRecipes",icon:"dku-icon-recipe-type",iconColor:"universe-color recipe",disabled:true,disabledReason:"To create a new plugin recipe, you need to create it from an existing code recipe in a project. Go to the advanced tab > Convert to plugin recipe.",description:"Create a new kind of recipe (Python, R, or Scala)"},{name:"Macro",type:"customRunnables",icon:"icon-macro",iconColor:"universe-color more",description:"Create a new kind of runnable piece. Useful to occasionally launch external or maintenance tasks. Macros can also be run in a scenario.",addDescriptors:regularPyAndJavaDescriptors,addFuncMap:{java:DataikuAPI.plugindev.addJavaRunnable,python:DataikuAPI.plugindev.addPythonRunnable},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("runnable")},{name:"Parameter set",type:"customParameterSets",icon:"icon-indent-right",iconColor:"universe-color more",description:"Create a definition for presets in this plugin.",addDescriptors:regularGenericOnlyDescriptor,addFuncMap:{generic:DataikuAPI.plugindev.addParameterSet},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("parameter set")},{name:"Notebook template",type:function(language=""){if(language.startsWith("scala")){return"customScalaNotebookTemplates"}if(language.startsWith("r")){return"customRNotebookTemplates"}return"customPythonNotebookTemplates"},icons:{customPreBuiltDatasetNotebookTemplates:{icon:"icon-dku-nav_notebook",iconColor:"universe-color notebook"},customRNotebookTemplates:{icon:"icon-code_r_recipe",iconColor:"universe-color notebook"},customRDatasetNotebookTemplates:{icon:"icon-code_r_recipe",iconColor:"universe-color notebook"},customPythonNotebookTemplates:{icon:"icon-code_python_recipe",iconColor:"universe-color notebook"},customPythonDatasetNotebookTemplates:{icon:"icon-code_python_recipe",iconColor:"universe-color notebook"},customScalaNotebookTemplates:{icon:"icon-code_spark_scala_recipe",iconColor:"universe-color notebook"},customScalaDatasetNotebookTemplates:{icon:"icon-code_spark_scala_recipe",iconColor:"universe-color notebook"}},description:"Create a new notebook template.",addDescriptors:[{key:"pythonDataset",label:"Python (create from a dataset)"},{key:"pythonStandalone",label:"Python (create from notebooks list, unrelated to a dataset)"},{key:"pythonDatasetPrebuilt",label:"Python (create from a dataset, in 'predefined' list)"},{key:"rDataset",label:"R (create from a dataset)"},{key:"rStandalone",label:"R (create from notebooks list, unrelated to a dataset)"},{key:"rDatasetPrebuilt",label:"R (create from a dataset, in 'predefined' list)"},{key:"scalaDataset",label:"Scala (create from a dataset)"},{key:"scalaStandalone",label:"Scala (create from notebooks list, unrelated to a dataset)"}],identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("notebook template"),addFuncMap:{pythonDataset:DataikuAPI.plugindev.addNotebookTemplate.bind(this,"dataset","python",false),pythonStandalone:DataikuAPI.plugindev.addNotebookTemplate.bind(this,"standalone","python",false),pythonDatasetPrebuilt:DataikuAPI.plugindev.addNotebookTemplate.bind(this,"dataset","python",true),rDataset:DataikuAPI.plugindev.addNotebookTemplate.bind(this,"dataset","r",false),rStandalone:DataikuAPI.plugindev.addNotebookTemplate.bind(this,"standalone","r",false),rDatasetPrebuilt:DataikuAPI.plugindev.addNotebookTemplate.bind(this,"dataset","r",true),scalaDataset:DataikuAPI.plugindev.addNotebookTemplate.bind(this,"dataset","scala",false),scalaStandalone:DataikuAPI.plugindev.addNotebookTemplate.bind(this,"standalone","scala",false)}},{name:"RMarkdown report template",type:"customRMarkdownReportTemplates",icon:"icon-DKU_rmd",iconColor:"universe-color report",description:"Create a new template for RMarkdown reports",addDescriptors:[{key:"rmarkdown",label:"RMarkdown"}],addFuncMap:{rmarkdown:DataikuAPI.plugindev.addRMarkdownReportTemplate},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("RMarkdown report template")},{name:"Webapp",type:"customWebApps",icon:"icon-eye",iconColor:"universe-color recipe-visual",disabled:true,disabledReason:"To create a new plugin webapp, you need to create it from an existing webapp in a project. Go to the advanced tab > Convert to plugin webapp.",description:"Create a reusable webapp for custom visualization or interactive screen without code for the end user"},{name:"Webapp template",type:function(language=""){if(language.startsWith("bokeh")){return"customBokehWebAppTemplates"}if(language.startsWith("shiny")){return"customShinyWebAppTemplates"}if(language.startsWith("dash")){return"customDashWebAppTemplates"}if(language.startsWith("streamlit")){return"customStreamlitWebAppTemplates"}return"customStandardWebAppTemplates"},icons:{customBokehWebAppTemplates:{icon:"icon-bokeh",iconColor:"universe-color recipe-code"},customDashWebAppTemplates:{icon:"icon-dash",iconColor:"universe-color recipe-code"},customShinyWebAppTemplates:{icon:"icon-shiny",iconColor:"universe-color recipe-code"},customStreamlitWebAppTemplates:{icon:"icon-streamlit",iconColor:"universe-color recipe-code"},customStandardWebAppTemplates:{icon:"icon-code",iconColor:"universe-color recipe-code"}},description:"Create a new template for webapps",addDescriptors:[{key:"standard",label:"Standard webapp (JS/HTML/CSS/Python)"},{key:"bokeh",label:"Bokeh webapp (Python)"},{key:"dash",label:"Dash webapp (Python)"},{key:"shiny",label:"Shiny webapp (R)"},{key:"streamlit",label:"Streamlit webapp (Python)"}],addFuncMap:{standard:DataikuAPI.plugindev.addStandardWebAppTemplate,bokeh:DataikuAPI.plugindev.addBokehWebAppTemplate,dash:DataikuAPI.plugindev.addDashWebAppTemplate,shiny:DataikuAPI.plugindev.addShinyWebAppTemplate,streamlit:DataikuAPI.plugindev.addStreamlitWebAppTemplate},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("template for webapps")},{name:"Scenario trigger",type:"customPythonTriggers",icon:"icon-list",iconColor:"universe-color scenario",description:"Create a new kind of trigger for scenarios",addDescriptors:regularPyOnlyDescriptor,addFuncMap:{python:DataikuAPI.plugindev.addPythonTrigger},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("trigger")},{name:"Scenario step",type:"customPythonSteps",icon:"icon-step-forward",iconColor:"universe-color scenario",description:"Create a new kind of step for scenarios",addDescriptors:regularPyOnlyDescriptor,addFuncMap:{python:DataikuAPI.plugindev.addPythonStep},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("scenario step")},{name:"Metrics probe",type:function(language=""){if(language.startsWith("sql")){return"customSQLProbes"}return"customPythonProbes"},icons:{customSQLProbes:{icon:"icon-subscript",iconColor:"universe-color datasets"},customPythonProbes:{icon:"icon-superscript",iconColor:"universe-color datasets"}},description:"Create a new kind of probe to compute metrics, that can be applied on datasets",addDescriptors:[{key:"python",label:"Python"},{key:"sql",label:"SQL"}],addFuncMap:{python:DataikuAPI.plugindev.addPythonProbe,sql:DataikuAPI.plugindev.addSqlProbe},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("probe")},{name:"Check",type:"customPythonChecks",icon:"icon-ok",iconColor:"universe-color dataset",description:"Create a new kind of check, that can be applied on datasets, managed folders, saved model versions, model evaluations or projects",addDescriptors:regularPyOnlyDescriptor,addFuncMap:{python:DataikuAPI.plugindev.addPythonCheck},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("check")},{name:"Exporter",type:"customExporters",icon:"icon-dku-download",iconColor:"universe-color datasets",description:"Create a new option to export dataset out of DSS. This can be export to file (that the user can download) or to custom destinations (like an external API). Exporters have only 'write' support. If you want 'read' support, you need to write a format instead",addDescriptors:regularPyAndJavaDescriptors,addFuncMap:{java:DataikuAPI.plugindev.addJavaExporter,python:DataikuAPI.plugindev.addPythonExporter},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("exporter")},{name:"File format",type:"customFormats",icon:"icon-file",iconColor:"universe-color datasets",description:"Create a new supported file format, that DSS uses to read and write on all files-based kinds of datasets (Filesystem, HDFS, S3, ...). Write support is optional",addDescriptors:regularPyAndJavaDescriptors,addFuncMap:{java:DataikuAPI.plugindev.addJavaFormat,python:DataikuAPI.plugindev.addPythonFormat},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("file format")},{name:"Sample dataset",type:"customSampleDatasets",icon:"icon-dku-tutorial",iconColor:"universe-color datasets",description:"Create a sample dataset to be used directly in a project",addDescriptors:regularGenericOnlyDescriptor,addFuncMap:{generic:DataikuAPI.plugindev.addSampleDataset},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("sample dataset")},{name:"FS provider",type:"customFileSystemProviders",icon:"icon-server_file_system_1",iconList:"universe-color datasets",description:"Create a new kind of files-based system, usable both for dataset (together with a file format) or for managed folders. Examples include cloud storages, file sharing systems, ... Write support is optional.",addDescriptors:regularPyAndJavaDescriptors,addFuncMap:{java:DataikuAPI.plugindev.addJavaFSProvider,python:DataikuAPI.plugindev.addPythonFSProvider},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("FS provider")},{name:"Preparation processor",type:"customJythonProcessors",icon:"icon-visual_prep_cleanse_recipe",iconColor:"universe-color recipe-visual",description:"Create a new kind of step for preparation scripts",addDescriptors:regularJythonOnlyDescriptor,addFuncMap:{jython:DataikuAPI.plugindev.addJythonProcessor},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("processor")},{name:"Prediction Algorithm",type:"customPythonPredictionAlgos",icon:"icon-machine_learning_regression",iconColor:"universe-color recipe-train",description:"Create a new prediction algorithm",addDescriptors:regularPyOnlyDescriptor,addFuncMap:{python:DataikuAPI.plugindev.addPredictionPythonAlgorithm},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("prediction algorithm")},{name:"LLM Guardrail",type:"customGuardrails",icon:"dku-icon-shield-check-24",iconColor:"universe-color more",description:"Create a new guardrail for LLMs",addDescriptors:regularPyOnlyDescriptor,addFuncMap:{python:DataikuAPI.plugindev.addGuardrail},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("guardrail")},{name:"Agent",type:"customAgents",icon:"dku-icon-ai-agent-plugin-24",iconColor:"universe-color more",description:"Create a new agent",addDescriptors:regularPyOnlyDescriptor,addFuncMap:{python:(pluginId,componentId,javaClassName,codeTemplate)=>DataikuAPI.plugindev.addAgent(pluginId,componentId,codeTemplate)},codeTemplates:Object.keys(AgentCodeTemplates).map(function(key){return{key:key,label:AgentCodeTemplates[key].title,description:AgentCodeTemplates[key].description,codeSample:AgentCodeTemplates[key].codeSample}}),identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("agent")},{name:"Agent Tool",type:"customAgentTools",icon:"dku-icon-tool-wrench-24",iconColor:"universe-color more",description:"Create a new tool for agents",addDescriptors:regularPyOnlyDescriptor,addFuncMap:{python:DataikuAPI.plugindev.addAgentTool},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("agent-tool")},{name:"Cluster",type:"customPythonClusters",icon:"icon-sitemap",iconColor:"universe-color more",description:"(Expert usage) Create a new kind of cluster",addDescriptors:regularPyOnlyDescriptor,addFuncMap:{python:DataikuAPI.plugindev.addPythonCluster},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("cluster")},{name:"Code Studio block",type:"customPythonCodeStudioBlocks",icon:"icon-code-studio",iconColor:"universe-color more",description:"(Expert usage) Create a new kind of Code Studio block",addDescriptors:regularPyOnlyDescriptor,addFuncMap:{python:DataikuAPI.plugindev.addPythonCodeStudioBlock},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("codeStudioBlock")},{name:"Custom Fields",type:"customFields",icon:"icon-list-ol",iconColor:"universe-color more",description:"Create new custom fields",addDescriptors:[{key:"json",label:"json"}],addFuncMap:{json:DataikuAPI.plugindev.addCustomFields},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("custom fields")},{name:"Custom Policy Hooks",type:"customPolicyHooks",icon:"icon-legal",iconColor:"universe-color more",description:"Create new custom policy hooks",addDescriptors:[{key:"java",label:"Java"}],addFuncMap:{java:DataikuAPI.plugindev.addJavaPolicyHooks},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("custom policy hooks")},{name:"Custom User Supplier",type:"customUserSupplier",icon:"icon-group",iconColor:"universe-color more",description:"Create new custom user supplier",addDescriptors:[{key:"java",label:"Java"}],addFuncMap:{java:DataikuAPI.plugindev.addJavaUserSupplier},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("custom user supplier")},{name:"Custom User Authenticator",type:"customUserAuthenticator",icon:"icon-signin",iconColor:"universe-color more",description:"Create new custom user authenticator",addDescriptors:[{key:"java",label:"Java"}],addFuncMap:{java:DataikuAPI.plugindev.addJavaUserAuthenticator},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("custom user authenticator")},{name:"Custom User Authenticator and Supplier",type:"customUserAuthenticatorAndSupplier",icon:"icon-signin",iconColor:"universe-color more",description:"Create new custom user authenticator and supplier",addDescriptors:[{key:"java",label:"Java"}],addFuncMap:{java:DataikuAPI.plugindev.addJavaUserAuthenticatorAndSupplier},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("custom user authenticator and supplier")},{name:"Dataiku Application Template",type:"customAppTemplates",icon:"icon-tasks",iconColor:"universe-color more",disabled:true,disabledReason:"To create a new Dataiku application template, you need to create it from an existing application template project.",description:"Create a new Dataiku application template"},{name:"Exposition",type:"customExpositions",icon:"icon-external-link",iconColor:"universe-color more",description:"(Expert usage) Create a new exposition to expose webapps or API services running in containers.",addDescriptors:regularJavaOnlyDescriptor,addFuncMap:{java:DataikuAPI.plugindev.addJavaExposition},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("exposition")},{name:"Custom Java LLM",type:"customJavaLLMs",icon:"dku-icon-puzzle-piece-24",iconColor:"universe-color more",description:"Create a new custom LLM",addDescriptors:regularJavaOnlyDescriptor,disabled:true,disabledReason:"Advanced usage - Dataiku support required"},{name:"Custom Python LLM",type:"customPythonLLMs",icon:"dku-icon-puzzle-piece-24",iconColor:"universe-color more",description:"Create a new custom LLM",addDescriptors:regularPyOnlyDescriptor,addFuncMap:{python:(pluginId,componentId,javaClassName,codeTemplate)=>DataikuAPI.plugindev.addCustomLLM(pluginId,componentId,codeTemplate.key)},codeTemplates:[{key:"text-completion",label:"Text completion",description:"Text completion sample"},{key:"embedding",label:"Embedding",description:"Embedding sample"},{key:"image-generation",label:"Image generation",description:"Image generation sample"}],identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("custom LLM")}];if($scope.appConfig.licensedFeatures.projectStandardsAllowed){$scope.contentTypeList.push({name:"Project Standards check spec",type:"customPythonProjectStandardsCheckSpecs",icon:"icon-code",iconColor:"universe-color more",description:"(Expert usage) Create a new kind of Project Standards Check Spec",addDescriptors:regularPyOnlyDescriptor,addFuncMap:{python:DataikuAPI.plugindev.addPythonProjectStandardsCheckSpec},identifierPlaceholder:()=>COMPONENT_IDENTIFIER_PLACEHOLDER,identifierHint:()=>getIdentifierHint("Project Standards check spec")})}};$scope.getComponentsTypeList=function(pluginInstallDesc){if(!pluginInstallDesc||!pluginInstallDesc.content){return[]}var componentsTypeList=[];Object.keys(pluginInstallDesc.content).forEach(function(contentType){var contentList=pluginInstallDesc.content[contentType];if(contentList instanceof Array&&contentList.length>0){componentsTypeList.push(contentType)}});return componentsTypeList};$scope.getComponentIcon=function(componentType,component={},iconSize=20){if(typeof componentType==="function"){componentType=componentType()}let componentIcon=component.meta&&component.meta.icon;let componentIconColor;if(componentType==="customJavaPolicyHooks"){componentType="customPolicyHooks"}if(componentType==="customJavaUserSupplier"){componentType="customUserSupplier"}if(componentType==="customJavaUserAuthenticator"){componentType="customUserAuthenticator"}if(componentType==="customJavaUserAuthenticatorAndSupplier"){componentType="customUserAuthenticatorAndSupplier"}if(componentType==="javaPreparationProcessors"){componentType="customJythonProcessors"}if(componentType==="javaFormulaFunctions"){return"universe-color analysis icon-beaker"}if(componentType==="tutorials"){return"universe-color more icon-dku-tutorial"}if(componentType==="customParameterSets"){return"universe-color more icon-indent-right"}if(componentType==="featureFlags"){return"universe-color more icon-dkubird"}for(let index=0;index<$scope.contentTypeList.length;index++){let currentType=$scope.contentTypeList[index].type;if(typeof currentType==="function"){let currentTypes=$scope.contentTypeList[index].icons;if(!currentTypes){continue}if(currentTypes[componentType]){componentIcon=componentIcon||currentTypes[componentType].icon;componentIconColor=currentTypes[componentType].iconColor;break}}else{let currentType=$scope.contentTypeList[index].type;if(currentType===componentType){componentIcon=componentIcon||$scope.contentTypeList[index].icon;componentIconColor=$scope.contentTypeList[index].iconColor;break}}}return componentIconColor+" "+$filter("toModernIcon")(componentIcon,iconSize)};$scope.computeNbComponents=function(pluginInstallDesc){if(!pluginInstallDesc||!pluginInstallDesc.content){return 0}var nbComponents=0;Object.keys(pluginInstallDesc.content).forEach(function(contentType){var contentList=pluginInstallDesc.content[contentType];if(contentList instanceof Array){nbComponents+=contentList.length}});if(pluginInstallDesc.desc&&pluginInstallDesc.desc.featureFlags){nbComponents+=pluginInstallDesc.desc.featureFlags.length}return nbComponents};$scope.getPlugin=function(){if($scope.appConfig.pluginDevGitMode==="PLUGIN"){$scope.getGitFullStatus()}return DataikuAPI.plugindev.get($stateParams.pluginId).then(function(data){$scope.pluginData=data.data;$scope.initContentTypeList()},setErrorInScope.bind($scope))};$scope.downloadPlugin=function(pluginId=$stateParams.pluginId){let url="/dip/api/plugins/dev/download?pluginId="+pluginId;downloadIframe.attr("src",url);$("body").append(downloadIframe)};$scope.deletePlugin=function(pluginId,pluginVersion,callback){CreateModalFromTemplate("/templates/plugins/development/delete-plugin-confirm-dialog.html",$scope,null,function(newScope){var handlePluginDeleted=function(){WT1.event("plugin-delete",{pluginId:newScope.pluginName,pluginVersion:newScope.pluginVersion});if(callback===undefined){$state.transitionTo("plugins.installed")}else{callback()}};newScope.pluginName=pluginId||$scope.pluginData.installedDesc.desc.id;newScope.pluginVersion=pluginVersion||$scope.pluginData.installedDesc.desc.version;DataikuAPI.plugins.prepareDelete(newScope.pluginName).success(function(usageStatistics){newScope.usageStatistics=usageStatistics}).error(setErrorInScope.bind($scope));newScope.confirmPluginDeletion=function(){DataikuAPI.plugindev.delete(newScope.pluginName,true).success(function(initialResponse){if(initialResponse&&initialResponse.jobId&&!initialResponse.hasResult){FutureWatcher.watchJobId(initialResponse.jobId).success(handlePluginDeleted).error(function(data,status,headers){setErrorInScope.bind($scope)(data,status,headers)})}else{handlePluginDeleted()}}).error(setErrorInScope.bind($scope))}})};$scope.newComponentPopin=function(){CreateModalFromTemplate("/templates/plugins/development/new-component-modal.html",$scope,"NewComponentModalController")};$scope.rebuildImage=()=>{DataikuAPI.admin.containerExec.buildBaseImage("CDE_PLUGINS").then(({data})=>{FutureProgressModal.show($scope,data,"Building image").then(function(result){if(result){Dialogs.infoMessagesDisplayOnly($scope,"Image built",result,result.futureLog,true);return $scope.getPlugin()}})}).catch(setErrorInScope.bind($scope))};const _togglePlugin=value=>()=>{const settings=angular.copy($scope.pluginData.settings);settings.excludedFromCDE=value;return DataikuAPI.plugins.saveSettings($stateParams.pluginId,$stateParams.projectKey,settings).then(data=>{if(data.error){Dialogs.infoMessagesDisplayOnly($scope,"Update result",data)}else{return $scope.rebuildImage()}}).catch(setErrorInScope.bind($scope))};$scope.removePluginFromImage=_togglePlugin(true);$scope.addPluginToImage=_togglePlugin(false)});app.directive("pluginEditCallbacks",function(DataikuAPI,$stateParams,Dialogs,$state){return{scope:false,restrict:"A",link:{pre:function($scope,$element,attrs){$scope.folderEditCallbacks={list:function(){return DataikuAPI.plugindev.listContents($stateParams.pluginId)},get:function(content,sendAnyway){return DataikuAPI.plugindev.getContent($stateParams.pluginId,content.path,sendAnyway)},previewImageURL:function(content){return"/dip/api/plugins/dev/preview-image?pluginId="+$stateParams.pluginId+"&path="+encodeURIComponent(content.path)+"&contentType="+encodeURIComponent(content.mimeType)},set:function(content){return DataikuAPI.plugindev.setContent($stateParams.pluginId,content.path,content.data)},validate:function(contentMap){return DataikuAPI.plugindev.validate($stateParams.pluginId,contentMap)},setAll:function(contentMap){return DataikuAPI.plugindev.setContentMultiple($stateParams.pluginId,contentMap)},create:function(path,isFolder){return DataikuAPI.plugindev.createContent($stateParams.pluginId,path,isFolder)},delete:function(content){return DataikuAPI.plugindev.deleteContent($stateParams.pluginId,content.path)},decompress:function(content){return DataikuAPI.plugindev.decompressContent($stateParams.pluginId,content.path)},rename:function(content,newName){return DataikuAPI.plugindev.renameContent($stateParams.pluginId,content.path,newName)},checkUpload:function(contentPath,paths){return DataikuAPI.plugindev.checkUploadContent($stateParams.pluginId,contentPath,paths)},upload:function(contentPath,file,callback){return DataikuAPI.plugindev.uploadContent($stateParams.pluginId,contentPath,file,callback)},move:function(content,to){return DataikuAPI.plugindev.moveContent($stateParams.pluginId,content.path,to?to.path:"")},copy:function(content){return DataikuAPI.plugindev.copyContent($stateParams.pluginId,content.path)},downloadURL:function(content){return"/dip/api/plugins/dev/download-content?pluginId="+$stateParams.pluginId+"&path="+encodeURIComponent(content.path)}};$scope.folderEditSaveWarning="You have unsaved changes to a plugin file, are you sure you want to leave?";$scope.description=$stateParams.pluginId;$scope.headerDescription="Plugin Content";$scope.rootDescription="[plugin root]";$scope.localStorageId=$stateParams.pluginId}}}});app.filter("humanContentType",function(){var fromCamelCaseToHuman=function(str){if(str=="featureFlags"){return"feature"}var humanStr="";var upperCase=str.match(/[A-Z]/);while(upperCase){humanStr+=str.substring(0,upperCase.index)+" ";str=upperCase[0].toLowerCase()+str.substring(upperCase.index+1);upperCase=str.match(/[A-Z]/)}humanStr+=str;return humanStr};return function(contentType){let humanContentType;humanContentType=fromCamelCaseToHuman(contentType);if(contentType=="customRunnables"){humanContentType="Macros"}humanContentType=humanContentType.replace("custom ","");if(humanContentType==="code recipes"){humanContentType="Recipes"}if(humanContentType[humanContentType.length-1]=="s"){humanContentType=humanContentType.substring(0,humanContentType.length-1)}return humanContentType}});app.controller("PlugindevCreateController",function($scope,$element,DataikuAPI,_SummaryHelper,Dialogs,$state,WT1,TopNav,SpinnerService,FutureProgressModal,StateUtils,PluginsService,MonoFuture){_SummaryHelper.addEditBehaviour($scope,$element);$scope.desc={id:"",bootstrapMode:"EMPTY",gitRepository:"",gitCheckout:"",gitPath:""};$scope.pattern=PluginsService.namingConvention;$scope.bootstrap=function(){MonoFuture($scope).wrap(DataikuAPI.plugindev.create)($scope.desc.id,$scope.desc.bootstrapMode,$scope.desc.gitRepository,$scope.desc.gitCheckout,$scope.desc.gitPath).success(function(data){FutureProgressModal.show($scope,data,"Creating plugin").then(function(result){if(result){WT1.event("plugin-dev-create");$scope.dismiss();DataikuAPI.plugindev.git.getFullStatus(result.details).finally(StateUtils.go.pluginDefinition(result.details))}})}).error(setErrorInScope.bind($scope))}});app.controller("PlugindevEditionController",function($scope,DataikuAPI,$state,$stateParams,CreateModalFromTemplate,Dialogs,FutureProgressModal,TopNav,$controller,$filter,WT1,$timeout){$controller("PlugindevCommonController",{$scope:$scope});$controller("PlugindevDefinitionController",{$scope:$scope});$scope.uiState={envName:null,newEnvDeploymentMode:"PLUGIN_MANAGED",state:$state};$scope.reloadPlugin=function(){return DataikuAPI.plugindev.reload($stateParams.pluginId).then(function(data){$scope.$broadcast("pluginReload");return $scope.getPlugin()},setErrorInScope.bind($scope))};$scope.modalCreateBranch=function(wantedBranch){CreateModalFromTemplate("/templates/plugins/development/git/create-branch-modal.html",$scope,"PlugindevCreateBranchController",function(newScope){newScope.targetBranchName=wantedBranch||""})};$scope.createBranchFromCommit=function(commitId){CreateModalFromTemplate("/templates/plugins/development/git/create-branch-modal.html",$scope,"PlugindevCreateBranchController",function(newScope){newScope.targetBranchName="";newScope.commitId=commitId})};$scope.focusBranchSearchInput=function(){$timeout(function(){angular.element("#branch-search-input").focus()},100)};$scope.reloadPlugin().then(function(){if($scope.customCodeRecipeIdToOpen&&$scope.pluginData&&$scope.pluginData.installedDesc&&$scope.pluginData.installedDesc.customCodeRecipes){$scope.pluginData.installedDesc.customCodeRecipes.forEach(function(customCodeRecipe){if(customCodeRecipe.id==$scope.customCodeRecipeIdToOpen){$scope.openPluginContentInEditor(customCodeRecipe,"customCodeRecipes")}});$scope.customCodeRecipeIdToOpen=null}})});app.controller("PlugindevDefinitionController",function($scope,$rootScope,DataikuAPI,StateUtils,CreateModalFromTemplate,Dialogs,$filter,$stateParams,SemanticVersionService){$scope.deleteComponent=function(event,content,contentType){let contentName=content.id;event.stopPropagation();if(contentType){contentType=$filter("humanContentType")(contentType).toLowerCase();if(contentType[contentType.length-1]=="s"){contentType=contentType.substring(0,contentType.length-1)}contentName=contentType+" "+contentName}var message="Are you sure you want to delete "+contentName+" ?";Dialogs.confirm($scope,"Delete "+content.id,message).then(function(){DataikuAPI.plugindev.deleteContent($scope.pluginData.installedDesc.desc.id,content.folderName).success(function(data){$scope.reloadPlugin()}).error(setErrorInScope.bind($scope))})};$scope.createCodeEnvPopin=function(){CreateModalFromTemplate("/templates/plugins/development/code-env-creation-modal.html",$scope,"NewCodeEnvController")};$scope.removeCodeEnv=function(){DataikuAPI.plugindev.removeCodeEnv($scope.pluginData.installedDesc.desc.id).success(function(){$scope.reloadPlugin()}).error(setErrorInScope.bind($scope))};$scope.displayUpdateButton=$scope.displayUpdateButton||false;function canDisplayUpdateButton(){return $rootScope.appConfig.admin&&$scope.pluginData&&$scope.updateAvailable}$scope.displayRequestUpdateButton=$scope.displayRequestUpdateButton||false;function canDisplayRequestUpdateButton(){return!$rootScope.appConfig.admin&&$rootScope.appConfig.pluginInstallRequestsEnabled&&$scope.pluginData&&$scope.updateAvailable}const FILE_TO_OPEN_MAP={customDatasets:"connector.json",customCodeRecipes:"recipe.json",customExporters:function(folderName){if(folderName.startsWith("java")){return"jexporter.json"}return"exporter.py"},customFormats:function(folderName){if(folderName.startsWith("java")){return"jformat.json"}return"format.py"},customPythonChecks:"check.py",customPythonProbes:"probe.py",customSQLProbes:"probe.sql",customPythonSteps:"step.py",customPythonClusters:"cluster.py",customPythonCodeStudioTemplates:"codeStudio.py",customPythonCodeStudioBlocks:"codeStudioBlock.py",customPythonProjectStandardsCheckSpecs:"project_standards_check_spec.py",customPythonTriggers:"trigger.py",customRunnables:function(folderName){if(folderName.startsWith("java")){return"runnable.json"}return"runnable.py"},customWebApps:"webapp.json",customStandardWebAppTemplates:"app.js",customBokehWebAppTemplates:"backend.py",customDashWebAppTemplates:"backend.py",customShinyWebAppTemplates:"ui.R",customStreamlitWebAppTemplates:"backend.py",customRMarkdownReportTemplates:"script.Rmd",customPythonNotebookTemplates:"notebook.ipynb",customPythonDatasetNotebookTemplates:"notebook.ipynb",customRNotebookTemplates:"notebook.ipynb",customRDatasetNotebookTemplates:"notebook.ipynb",customScalaNotebookTemplates:"notebook.ipynb",customScalaDatasetNotebookTemplates:"notebook.ipynb",customPreBuiltDatasetNotebookTemplates:"notebook.ipynb",customJythonProcessors:"processor.py",customFileSystemProviders:function(folderName){if(folderName.startsWith("java")){return"fs-provider.json"}return"fs-provider.py"},codeEnv:"desc.json",customPythonPredictionAlgos:"algo.json",customParameterSets:"preset.json",customFields:"custom-fields.json",customJavaPolicyHooks:function(folderName){if(folderName.startsWith("java")){return"policy-hook.json"}},customJavaUserSupplier:function(folderName){if(folderName.startsWith("java")){return"custom-user-supplier.json"}},customJavaUserAuthenticator:function(folderName){if(folderName.startsWith("java")){return"custom-user-authenticator.json"}},customJavaUserAuthenticatorAndSupplier:function(folderName){if(folderName.startsWith("java")){return"custom-user-authenticator-and-supplier.json"}},customAppTemplates:"app.json",customExpositions:"exposition.json",customAgents:"agent.py",customAgentTools:"tool.py",customGuardrails:"guardrail.py",customSampleDatasets:"dataset.json",customPythonLLMs:"llm.py"};$scope.hasFileToOpen=function(contentType){return!!FILE_TO_OPEN_MAP[contentType]};$scope.openPluginContentInEditor=function(content,contentType){var fileToOpen=FILE_TO_OPEN_MAP[contentType];if(fileToOpen){if(typeof fileToOpen==="function"){fileToOpen=fileToOpen(content.folderName)}fileToOpen=content.folderName+"/"+fileToOpen;openContentInEditor(fileToOpen)}};$scope.$on("PLUGIN_DEV_LIST:openCustomRecipeInEditor",function(event,id){$scope.customCodeRecipeIdToOpen=id});var openContentInEditor=function(path){StateUtils.go.pluginEditor($stateParams.pluginId,path)};$scope.openPluginDescInEditor=function(){openContentInEditor("plugin.json")};$scope.filterQuery={userQuery:""};$scope.filteredContent={};function filterContent(pluginInstallDesc){let filteredContent={};let types=$scope.getComponentsTypeList(pluginInstallDesc);types.forEach(function(type){let filteredComponents=$filter("filter")(pluginInstallDesc.content[type],$scope.filterQuery.userQuery);if(filteredComponents.length){filteredContent[type]=filteredComponents}});if(pluginInstallDesc.desc.featureFlags){const matchingFeatureFlag=$filter("filter")(pluginInstallDesc.desc.featureFlags,$scope.filterQuery.userQuery);if(matchingFeatureFlag.length>0){filteredContent["featureFlags"]=$filter("filter")(pluginInstallDesc.desc.featureFlags,$scope.filterQuery.userQuery);filteredContent["featureFlags"]=filteredContent["featureFlags"].map(featureFlag=>({id:featureFlag}))}}return filteredContent}function filterContentOnChange(){if($scope.pluginData&&$scope.pluginData.installedDesc&&$scope.pluginData.installedDesc.content){$scope.filteredContent=filterContent($scope.pluginData.installedDesc)}else{$scope.filteredContent={}}}$scope.updateAvailable=$scope.updateAvailable||false;function updateAvailable(){return $scope.pluginData&&$scope.pluginData.installedDesc&&$scope.pluginData.installedDesc.desc&&$scope.pluginData.installedDesc.desc.version&&$scope.pluginData.pluginStoreVersion&&SemanticVersionService.compareVersions($scope.pluginData.pluginStoreVersion,$scope.pluginData.installedDesc.desc.version)>0}$scope.$watch("pluginData",function(newVal,oldVal){if(newVal!==oldVal){$scope.updateAvailable=updateAvailable();$scope.displayUpdateButton=canDisplayUpdateButton();$scope.displayRequestUpdateButton=canDisplayRequestUpdateButton()}filterContentOnChange()},true);$scope.$watch("filterQuery.userQuery",filterContentOnChange,true);$scope.getComponentsTypeListFiltered=function(){return Object.keys($scope.filteredContent)};$scope.validatePluginEnv=function(){$scope.pluginEnvUpToDate=true};$scope.invalidatePluginEnv=function(){$scope.pluginEnvUpToDate=false}});app.controller("PlugindevEditorController",function($scope,$stateParams){$scope.filePath=$stateParams.filePath||""});app.controller("PlugindevHistoryController",function($scope,$stateParams,DataikuAPI,$timeout,TopNav){const PAGE_SIZE=20;$scope.loadMore=function(){if($scope.hasMore&&!$scope.loading){$scope.loading=true;DataikuAPI.plugindev.git.getLog($stateParams.pluginId,$scope.nextCommit,PAGE_SIZE).success(function(data){$scope.logEntries=($scope.logEntries||[]).concat(data.logEntries);$scope.nextCommit=data.nextCommit;if(!$scope.nextCommit){$scope.hasMore=false}$scope.loading=false}).error(function(e){$scope.loading=false;setErrorInScope.bind($scope)})}};$scope.loadLogFromStart=function(){$scope.nextCommit=null;$scope.logEntries=[];$scope.hasMore=true;$scope.loadMore()};$timeout(()=>{$scope.loadLogFromStart()})});function computeDefaultLanguage(contentType,previousLanguage){const noPreviousLanguageDefined=previousLanguage===null;const previousLanguageInvalidForNewComponentType=!(previousLanguage in contentType.addFuncMap);const useDefaultLanguage=noPreviousLanguageDefined||previousLanguageInvalidForNewComponentType;if(useDefaultLanguage){return contentType.addDescriptors[0].key}return previousLanguage}app.controller("NewComponentModalController",function($scope,$controller,$element,$timeout,$state,WT1,DKUtils,PluginsService,ListFilter){$controller("PlugindevCommonController",{$scope:$scope});$controller("PlugindevDefinitionController",{$scope:$scope});$scope.pattern=PluginsService.namingConvention;$scope.newComponent={contentType:null,contentLanguage:null,id:"",javaClassNameForPlugin:"",codeTemplate:null};function resetNewComponentSettings(contentType){$scope.newComponent.contentType=contentType;$scope.newComponent.contentLanguage=computeDefaultLanguage(contentType,$scope.newComponent.contentLanguage)}$scope.selectContentType=function(contentType){if(contentType&&contentType.disabled)return;resetNewComponentSettings(contentType);$timeout(function(){$element.find(".language-select").selectpicker("refresh")})};$scope.isJava=function(){return $scope.newComponent.contentLanguage==="java"};$scope.requiresLanguage=function(contentType){return contentType&&!(contentType.addDescriptors.length===1&&contentType.addDescriptors[0].key==="generic")};$scope.requiresCodeTemplate=function(contentType){return contentType&&contentType.codeTemplates!==undefined&&contentType.codeTemplates.length>0};$scope.create=function(){if($scope.isFormValid()){const addThingFunc=$scope.newComponent.contentType.addFuncMap[$scope.newComponent.contentLanguage];addThingFunc($scope.pluginData.installedDesc.desc.id,$scope.newComponent.id,$scope.newComponent.javaClassNameForPlugin,$scope.newComponent.codeTemplate).success(function(data){WT1.event("plugin-dev-add-"+$scope.newComponent.contentType.name+"-"+$scope.newComponent.contentLanguage);$scope.dismiss();$scope.getPlugin().then(function(){let folderName=data.pathToFiles.substring($scope.pluginData.baseFolderPath.length);if(folderName.startsWith("/")){folderName=folderName.substring(1)}let componentType=$scope.newComponent.contentType.type;if(typeof $scope.newComponent.contentType.type==="function"){componentType=$scope.newComponent.contentType.type($scope.newComponent.contentLanguage)}if($state.$current.name=="plugindev.editor"){DKUtils.reloadState()}else{$scope.openPluginContentInEditor({folderName:folderName},componentType)}$scope.reloadPlugin()})}).error(setErrorInScope.bind($scope))}};$scope.validateComponentId=()=>{return PluginsService.validateComponentId($scope.newComponent.id,$scope.pluginData.installedDesc.desc.id,$scope.filteredContent[$scope.newComponent.contentType.type]||[])};$scope.getComponentIdWarningMessages=()=>{if(!$scope.newComponent.contentType)return null;const warnings=$scope.validateComponentId();if(warnings.length==0){return null}if(warnings.length==1){return warnings[0]}return warnings.map(w=>"• "+w).join("<br>")};$scope.isFormValid=function(){if(!$scope.newComponent.contentType)return false;const hasAddFunc=$scope.newComponent.contentLanguage&&$scope.newComponent.contentType.addFuncMap[$scope.newComponent.contentLanguage];const hasTemplate=!$scope.requiresCodeTemplate($scope.newComponent.contentType)||$scope.newComponent.codeTemplate;const hasClassName=!$scope.isJava()||$scope.newComponent.javaClassNameForPlugin&&$scope.newComponent.javaClassNameForPlugin.length>0;return $scope.validateComponentId().length==0&&hasAddFunc&&hasTemplate&&hasClassName};$scope.refreshComponentSearch=function(){let components=$scope.contentTypeList;components=ListFilter.filter(components,$scope.componentSearchQuery);$scope.filteredContentTypeList=components};$scope.$watch("componentSearchQuery",$scope.refreshComponentSearch)});app.controller("NewCodeEnvController",function($scope,$controller,WT1){$controller("PlugindevCommonController",{$scope:$scope});$controller("PlugindevDefinitionController",{$scope:$scope});$scope.codeEnvData=$scope.contentTypeList.find(contentType=>{return contentType.type==="codeEnv"});$scope.uiState={contentLanguage:computeDefaultLanguage($scope.codeEnvData,null)};$scope.create=function(){if($scope.isFormValid()){const addThingFunc=$scope.codeEnvData.addFuncMap[$scope.uiState.contentLanguage];addThingFunc($scope.pluginData.installedDesc.desc.id,undefined,undefined,$scope.forceConda).success(function(data){WT1.event("plugin-dev-create-code-env-"+$scope.uiState.contentLanguage);$scope.dismiss();$scope.getPlugin().then(function(){let folderName=data.pathToFiles.substring($scope.pluginData.baseFolderPath.length);if(folderName.startsWith("/")){folderName=folderName.substring(1)}$scope.openPluginContentInEditor({folderName:folderName},"codeEnv");$scope.reloadPlugin()})}).error(setErrorInScope.bind($scope))}};$scope.isFormValid=function(){return $scope.uiState.contentLanguage&&$scope.codeEnvData&&$scope.codeEnvData.addFuncMap[$scope.uiState.contentLanguage]}});app.config(["$controllerProvider","$compileProvider","$filterProvider","$provide","$injector",function($controllerProvider,$compileProvider,$filterProvider,$provide,$injector){app.registerModule=function(moduleName){var module=angular.module(moduleName);if(module.requires){for(var i=0;i<module.requires.length;i++){app.registerModule(module.requires[i])}}var providers={$controllerProvider:$controllerProvider,$compileProvider:$compileProvider,$filterProvider:$filterProvider,$provide:$provide};angular.forEach(module._invokeQueue,function(invokeArgs){var provider=providers[invokeArgs[0]];provider[invokeArgs[1]].apply(provider,invokeArgs[2])});angular.forEach(module._configBlocks,function(fn){$injector.invoke(fn)});angular.forEach(module._runBlocks,function(fn){$injector.invoke(fn)})}}]);app.service("CustomUISetup",function(PluginConfigUtils,DataikuAPI,$q,$stateParams){return{setupCallPythonDo:function($scope,errorScope,pluginId,componentId,config,side){$scope.uiInteraction={pluginId:pluginId,componentId:componentId,sessionId:null};$scope.callPythonDo=function(payload){var deferred=$q.defer();DataikuAPI.plugins.callPythonDo($scope.uiInteraction.sessionId,$scope.uiInteraction.pluginId,$scope.uiInteraction.componentId,config,payload,$scope.recipeConfig,$stateParams.projectKey,$stateParams.clusterId,side).success(function(data){$scope.uiInteraction.sessionId=data.sessionId;deferred.resolve(data.data)}).error(function(data,status,headers,config,statusText,xhrStatus){setErrorInScope.bind(errorScope)(data,status,headers,config,statusText,xhrStatus);deferred.reject("Failed to get test result for ui")});return deferred.promise}}}});app.directive("customTemplateWithCallPythonDo",function(CustomUISetup){return{restrict:"E",templateUrl:"templates/plugins/development/custom-template.html",link:function($scope,element,attrs){CustomUISetup.setupCallPythonDo($scope,$scope.$eval(attrs.errorScope),$scope.$eval(attrs.pluginId),$scope.$eval(attrs.componentId),$scope.$eval(attrs.config),attrs.side)}}});app.directive("customParamsForm",function(PluginConfigUtils,DataikuAPI,$q,$stateParams,CustomUISetup){return{restrict:"EA",scope:{pluginDesc:"=",componentId:"=",desc:"=",config:"=",columnsPerInputRole:"=",recipeConfig:"=",viewMode:"<"},templateUrl:"/templates/plugins/development/custom-form.html",link:function($scope,element,attrs){var setupDone=false;var updateSetup=function(){if($scope.desc==null||setupDone){}else{if($scope.desc.paramsModule){app.registerModule($scope.desc.paramsModule)}if($scope.desc.paramsTemplate){$scope.baseTemplateUrl="/plugins/"+$scope.pluginDesc.id+"/resource/";$scope.templateUrl=$scope.baseTemplateUrl+$scope.desc.paramsTemplate}setupDone=true}};updateSetup();$scope.$watch("desc",updateSetup)}}});app.directive("autoconfigForm",function(Debounce){return{restrict:"EA",replace:false,scope:{params:"=",pluginId:"=",componentId:"=",model:"=",rootModel:"=?",columnsPerInputRole:"=",recipeConfig:"=",chart:"=",side:"@",activeDragDrop:"=",validity:"=",errorScope:"=",qaSelectorPrefix:"@?",viewMode:"=",isList:"=",objectListElementIndex:"="},templateUrl:"/templates/plugins/development/autoconfig-form.html",link:function($scope){if($scope.rootModel===undefined){if($scope.model===undefined){$scope.$watch($scope.model,()=>{if($scope.rootModel===undefined){$scope.rootModel=$scope.model}})}else{$scope.rootModel=$scope.model}}$scope.qaSelectorPrefix=$scope.qaSelectorPrefix||"data-qa-autoconfig-form-element";$scope.getQaSelector=function(paramId){return`${$scope.qaSelectorPrefix}-${paramId}`};$scope.callbacksByDynamicParamId={};$scope.dynamicParamsByTriggerParamId={};$scope.dynamicParamIdTriggeredByModelChange=[];$scope.isInitializedWithDynamicParams=function(){return Object.keys($scope.dynamicParamsByTriggerParamId).length!==0||$scope.dynamicParamIdTriggeredByModelChange.length>0};$scope.registerDynamicParamCallback=function(dynamicParamDesc,reloadCustomChoicesCallback){let dynamicParamToRegister=dynamicParamDesc.name;$scope.callbacksByDynamicParamId[dynamicParamToRegister]=reloadCustomChoicesCallback;if(!dynamicParamDesc.triggerParameters||dynamicParamDesc.triggerParameters.length===0){$scope.dynamicParamIdTriggeredByModelChange.push(dynamicParamToRegister)}else{dynamicParamDesc.triggerParameters.forEach(triggerParamId=>{if($scope.dynamicParamsByTriggerParamId[triggerParamId]===undefined){$scope.dynamicParamsByTriggerParamId[triggerParamId]=[]}$scope.dynamicParamsByTriggerParamId[triggerParamId].push(dynamicParamToRegister)})}};$scope.triggerParameterIdsToWatch=new Set;if($scope.params){for(const param of $scope.params){if(param.getChoicesFromPython&&!param.disableAutoReload&&param.triggerParameters){param.triggerParameters.forEach(triggerParam=>$scope.triggerParameterIdsToWatch.add(triggerParam))}}}$scope.dynamicParamsNeededToBeCalled=new Set;for(const triggerParameterId of $scope.triggerParameterIdsToWatch){$scope.$watch(`model.${triggerParameterId}`,()=>{if($scope.isInitializedWithDynamicParams()){$scope.dynamicParamsByTriggerParamId[triggerParameterId].forEach(dynamicParameterId=>{$scope.dynamicParamsNeededToBeCalled.add(dynamicParameterId)})}},true)}$scope.$watch("model",Debounce().withDelay(1e3,1e3).wrap(()=>{if($scope.isInitializedWithDynamicParams()){$scope.dynamicParamIdTriggeredByModelChange.forEach(dynamicParameterId=>$scope.dynamicParamsNeededToBeCalled.add(dynamicParameterId));$scope.dynamicParamsNeededToBeCalled.forEach(pythonParamId=>$scope.callbacksByDynamicParamId[pythonParamId]());$scope.dynamicParamsNeededToBeCalled.clear()}}),true)}}});function initChartWebAppBar(isLeftBar){return function(scope){var loadedType=null;scope.$watch("chart.def.$loadedDesc",function(){if(!scope.chart||!scope.chart.def)return;if(scope.chart.def.$loadedDesc!=null&&scope.chart.def.$loadedDesc.webappType!==loadedType){scope.config=scope.chart.def.webAppConfig;if(isLeftBar){scope.optionsFolds.webapp=true}loadedType=scope.chart.def.$loadedDesc.webappType;scope.loadedDesc=scope.chart.def.$loadedDesc;scope.pluginChartDesc=scope.chart.def.$pluginChartDesc;scope.pluginDesc=scope.chart.def.$pluginDesc;scope.componentId=scope.chart.def.$loadedDesc.id;const module=isLeftBar?scope.pluginChartDesc.leftBarModule:scope.pluginChartDesc.topBarModule;if(module){app.registerModule(module)}const template=isLeftBar?scope.pluginChartDesc.leftBarTemplate:scope.pluginChartDesc.topBarTemplate;if(template){scope.baseTemplateUrl="/plugins/"+scope.pluginDesc.id+"/resource/";scope.templateUrl=scope.baseTemplateUrl+template}else{scope.baseTemplateUrl=null;scope.templateUrl=null}}})}}const initChartLeftBarWebApp=initChartWebAppBar(true);const initChartRightBarWebApp=initChartWebAppBar(false);app.controller("WebAppChartLeftBarController",function($scope){initChartLeftBarWebApp($scope)});app.controller("WebAppChartTopBarController",function($scope){initChartRightBarWebApp($scope)});app.directive("customAdminParamsForm",function(PluginConfigUtils,DataikuAPI,$q,$stateParams){return{restrict:"EA",scope:{pluginDesc:"=",componentId:"=",desc:"=",config:"=",columnsPerInputRole:"=",recipeConfig:"="},templateUrl:"/templates/plugins/development/custom-admin-form.html",link:function($scope,element,attrs){}}});app.directive("pluginSettingsAlert",function($state){return{restrict:"EA",scope:{componentType:"@",appConfig:"=",hasSettings:"=",pluginDesc:"="},templateUrl:"/templates/plugins/development/plugin-settings-alert.html",link:function($scope,element,attrs){if($scope.pluginDesc){$scope.pluginLink=$scope.pluginDesc.isDev?"plugindev.settings({pluginId: '"+$scope.pluginDesc.id+"'})":"plugin.settings({pluginId: '"+$scope.pluginDesc.id+"'})"}else{$scope.pluginLink="plugins.installed"}}}})})();(function(){"use strict";const app=angular.module("dataiku.plugindev.git",["dataiku.git"]);app.controller("_PlugindevGitController",function($scope,DataikuAPI,$state,$stateParams,CreateModalFromTemplate,Dialogs,FutureProgressModal,DKUtils,$filter,WT1,FullGitSupportService){$scope.getGitFullStatus=function(cb){return FullGitSupportService.getFullStatus($scope,DataikuAPI.plugindev.git.getFullStatus($stateParams.pluginId),cb)};$scope.modalRemoveRemote=function(){const callback=function(remoteName){WT1.event("plugindev-git-remove-remote",{pluginId:$stateParams.pluginId});DataikuAPI.plugindev.git.removeRemote($stateParams.pluginId,remoteName).then(function(){$scope.getGitFullStatus();$scope.getGitBranches()},setErrorInScope.bind($scope))};FullGitSupportService.removeRemote($scope,callback)};$scope.getGitBranches=function(){return FullGitSupportService.getBranches($scope,DataikuAPI.plugindev.git.listBranches($stateParams.pluginId))};$scope.filterBranches=function(query){$scope.gitBranchesFiltered=$filter("filter")($scope.gitBranches,query)};$scope.formatTrackingCount=function(count){return count!=null?count:"-"};$scope.postSaveCallback=function(){if($scope.appConfig.pluginDevExplicitCommit===false&&$scope.appConfig.pluginDevGitMode==="PLUGIN"){$scope.getGitFullStatus()}};$scope.modalFetch=function(){WT1.event("plugindev-git-fetch",{pluginId:$stateParams.pluginId});FullGitSupportService.fetch($scope,DataikuAPI.plugindev.git.fetch($stateParams.pluginId))};$scope.modalPull=function(){WT1.event("plugindev-git-pull",{pluginId:$stateParams.pluginId});FullGitSupportService.pull($scope,DataikuAPI.plugindev.git.pull($stateParams.pluginId))};$scope.modalPush=function(){WT1.event("plugindev-git-push",{pluginId:$stateParams.pluginId});FullGitSupportService.push($scope,DataikuAPI.plugindev.git.push($stateParams.pluginId))};$scope.modalAddOrEditRemote=function(){const callback=function(remoteName,newURL){WT1.event("plugindev-git-set-remote",{pluginId:$stateParams.pluginId});DataikuAPI.plugindev.git.setRemote($stateParams.pluginId,remoteName,newURL).then(function(){$scope.getGitFullStatus()},setErrorInScope.bind($scope))};FullGitSupportService.editRemote($scope,callback)};$scope.switchToBranch=function(branchName){WT1.event("plugindev-git-switch-branch",{pluginId:$stateParams.pluginId});FullGitSupportService.switchToBranch($scope,DataikuAPI.plugindev.git.switchBranch($stateParams.pluginId,branchName))};$scope.modalDeleteLocalBranches=function(){const callback=function(modalScope,branchesToDelete,deleteOptions){WT1.event("plugindev-git-delete-branches",{pluginId:$stateParams.pluginId});DataikuAPI.plugindev.git.deleteBranches($stateParams.pluginId,branchesToDelete,deleteOptions).then(function(){$state.reload();modalScope.dismiss()},setErrorInScope.bind(modalScope))};FullGitSupportService.deleteBranches($scope,callback)};$scope.needsExplicitCommit=function(){return $scope.appConfig.pluginDevExplicitCommit};$scope.modalCommit=function(){CreateModalFromTemplate("/templates/plugins/development/git/commit-modal.html",$scope,"PlugindevCommitController")};$scope.getResetModes=function(){let modes=[];if($scope.appConfig.pluginDevExplicitCommit)modes.push("HEAD");if($scope.gitStatus.hasRemoteOrigin&&$scope.gitStatus.hasTrackingCount)modes.push("UPSTREAM");return modes};$scope.modalReset=function(){CreateModalFromTemplate("/templates/plugins/development/git/reset-modal.html",$scope,"PlugindevResetController")};$scope.$on("pluginReload",function(){$scope.getGitBranches()});$scope.canChangeRemote=true;$scope.canChangeBranch=true;$scope.canUpdateContent=true});app.controller("PlugindevCreateBranchController",function($scope,$stateParams,DataikuAPI,$state){$scope.createBranch=function(){DataikuAPI.plugindev.git.createBranch($stateParams.pluginId,$scope.targetBranchName,$scope.commitId).then(function(){$state.reload();$scope.dismiss()},setErrorInScope.bind($scope))}});app.controller("PlugindevCommitController",function($scope,$stateParams,$filter,DataikuAPI,ActivityIndicator,$timeout,WT1){DataikuAPI.plugindev.git.prepareCommit($stateParams.pluginId).then(function(resp){$scope.preparationData=resp.data},setErrorInScope.bind($scope));$scope.uiState={activeTab:"message",message:""};$timeout(()=>{$scope.commitEditorOptions={mode:"text/plain",lineNumbers:false,matchBrackets:false,autofocus:true,onLoad:function(cm){$scope.codeMirror=cm}}},100);$scope.gitCommit=function(){WT1.event("plugindev-git-commit",{pluginId:$stateParams.pluginId});DataikuAPI.plugindev.git.commit($stateParams.pluginId,$scope.uiState.message).then(function(){ActivityIndicator.success("Changes successfully committed.");$scope.dismiss();$scope.getGitFullStatus()},setErrorInScope.bind($scope))}});app.controller("PlugindevResetController",function($scope,$filter,$stateParams,DataikuAPI,ActivityIndicator,Dialogs,$state,WT1){$scope.resetStrategy=$scope.getResetModes()[0];$scope.setStrategy=function(strategy){if($scope.getResetModes().includes(strategy)){$scope.resetStrategy=strategy}};$scope.gitReset=function(){const resetToUpstream=()=>DataikuAPI.plugindev.git.resetToUpstream($stateParams.pluginId);const resetToHead=()=>DataikuAPI.plugindev.git.resetToHead($stateParams.pluginId);const resetAPICall=$scope.resetStrategy==="HEAD"?resetToHead:resetToUpstream;WT1.event("plugindev-git-reset",{pluginId:$stateParams.pluginId,resetStrategy:$scope.resetStrategy});resetAPICall().then(function(){ActivityIndicator.success("Reset succeeded.");$state.reload();$scope.dismiss()},setErrorInScope.bind($scope))}});app.directive("pluginGitLog",function($controller,DataikuAPI,$stateParams){return{templateUrl:"/templates/git/git-log.html",scope:{logEntries:"=",lastStatus:"=",objectRevertable:"=",objectRef:"=",projectRevertable:"=",commitRevertable:"=",noCommitDiff:"=",noAuthorLink:"=",createBranchFromCommit:"=",canChangeBranch:"=",backgroundColor:"@"},link:function($scope,WT1,element){$scope.backgroundColor=$scope.backgroundColor||"#f2f2f2";const pluginGitAPI={getDSSVersionForASpecificCommit:hash=>DataikuAPI.plugindev.git.getDSSVersionForASpecificCommit($stateParams.pluginId,hash),getRevisionsDiff:(commitFrom,commitTo)=>DataikuAPI.plugindev.git.getRevisionsDiff($stateParams.pluginId,commitFrom,commitTo),getCommitDiff:commitId=>DataikuAPI.plugindev.git.getCommitDiff($stateParams.pluginId,commitId),revertObjectToRevision:()=>console.warn("`revertObjectToRevision` should not be fired on a plugin"),revertProjectToRevision:hash=>DataikuAPI.plugindev.git.revertPluginToRevision($stateParams.pluginId,hash),revertSingleCommit:hash=>DataikuAPI.plugindev.git.revertSingleCommit($stateParams.pluginId,hash),createBranchFromCommit:commitId=>$scope.createBranchFromCommit(commitId),canChangeBranch:$scope.canChangeBranch,removeTag:tagName=>DataikuAPI.plugindev.git.removeTag($stateParams.pluginId,tagName),addTag:(tagRef,tagName,tagMessage)=>DataikuAPI.plugindev.git.addTag($stateParams.pluginId,tagRef,tagName,tagMessage)};$controller("_gitLogControllerBase",{$scope:$scope,element:element,DataikuGitAPI:pluginGitAPI,objectType:"plugin"})}}});app.directive("branchPopup",function($stateParams,DataikuAPI,$rootScope,$timeout,CreateModalFromTemplate,Dialogs){return{controller:function($scope){},link:function(scope,element,attr){},templateUrl:'/templates/plugins/development/git/branch-popup.html"'}})})();(function(){"use strict";const app=angular.module("dataiku.folder_edit",[]);let moveText="Move...";let duplicateText="Duplicate";let renameText="Rename...";let deleteText="Delete...";let createFileText="Create file...";let createFolderText="Create folder...";let uploadText="Upload file...";let downloadText="Download file...";let commitText="Commit and push...";let pullText="Reset from remote HEAD";let editText="Edit Git reference...";let unlinkText="Unlink remote repository...";let closeOtherTabText="Close other tabs";let customizeEditorSettingsText="Customize editor settings";let reloadLocalFileText="Reload local files";let manageReferenceText="Manage repositories...";let importFromGitText="Import from Git...";let updateAllText="Reset all from remote HEAD...";let commitAllText="Commit and push all...";let editInCodeStudioText="Edit in Code Studio...";let moveIcon='<i class="icon-fixed-width dku-icon-arrow-right-16 text-icon"> </i>';let duplicateIcon='<i class="icon-fixed-width dku-icon-copy-16 text-icon"> </i>';let renameIcon='<i class="icon-fixed-width dku-icon-edit-note-16 text-icon"> </i>';let deleteIcon='<i class="icon-fixed-width dku-icon-trash-16 text-icon"> </i>';let createFileIcon='<i class="icon-fixed-width dku-icon-file-16 text-icon"> </i>';let createFolderIcon='<i class="icon-fixed-width dku-icon-folder-open-16 text-icon"> </i>';let uploadIcon='<i class="icon-fixed-width dku-icon-file-upload-16 text-icon"> </i>';let downloadIcon='<i class="icon-fixed-width dku-icon-file-download-16 text-icon"> </i>';let commitIcon='<i class="icon-fixed-width dku-icon-git-push-16 text-icon"> </i>';let pullIcon='<i class="icon-fixed-width dku-icon-git-pull-16 text-icon"> </i>';let editIcon='<i class="icon-fixed-width dku-icon-git-edit-16 text-icon"> </i>';let editFileIcon='<i class="icon-fixed-width dku-icon-edit-16 text-icon"> </i>';let unlinkIcon='<i class="icon-fixed-width dku-icon-unlink-16 text-icon"> </i>';let closeOtherTabIcon='<i class="icon-fixed-width dku-icon-dismiss-16 text-icon"> </i>';let customizeEditorSettingsIcon='<i class="icon-fixed-width dku-icon-gear-16 text-icon"> </i>';let reloadLocalFileIcon='<i class="icon-fixed-width dku-icon-arrow-circular-16 text-icon"> </i>';let manageReferenceIcon=editIcon;let importFromGitIcon='<i class="icon-fixed-width dku-icon-git-import-16 text-icon"> </i>';let updateAllIcon=pullIcon;let commitAllIcon=commitIcon;app.directive("zoneEditCallbacks",function(DataikuAPI,$stateParams,Dialogs,$state){return{scope:false,restrict:"A",link:{pre:function($scope,$element,attrs){var zone=attrs.zone;$scope.folderEditCallbacks={list:function(){return DataikuAPI.admin.folderEdit.listContents(zone)},get:function(content,sendAnyway){return DataikuAPI.admin.folderEdit.getContent(zone,content.path,sendAnyway)},previewImageURL:function(content){return"/dip/api/admin/folder-edition/preview-image?type="+zone+"&path="+encodeURIComponent(content.path)+"&contentType="+encodeURIComponent(content.mimeType)},set:function(content){return DataikuAPI.admin.folderEdit.setContent(zone,content.path,content.data)},setAll:function(contentMap){return DataikuAPI.admin.folderEdit.setContentMultiple(zone,contentMap)},create:function(path,isFolder){return DataikuAPI.admin.folderEdit.createContent(zone,path,isFolder)},delete:function(content){return DataikuAPI.admin.folderEdit.deleteContent(zone,content.path)},decompress:function(content){return DataikuAPI.admin.folderEdit.decompressContent(zone,content.path)},rename:function(content,newName){return DataikuAPI.admin.folderEdit.renameContent(zone,content.path,newName)},checkUpload:function(contentPath,paths){return DataikuAPI.admin.folderEdit.checkUploadContent(zone,contentPath,paths)},upload:function(contentPath,file,callback){return DataikuAPI.admin.folderEdit.uploadContent(zone,contentPath,file,callback)},move:function(content,to){return DataikuAPI.admin.folderEdit.moveContent(zone,content.path,to?to.path:"")},copy:function(content){return DataikuAPI.admin.folderEdit.copyContent(zone,content.path)},downloadURL:function(content){return"/dip/api/admin/folder-edition/download-content?type="+zone+"&path="+encodeURIComponent(content.path)}};$scope.folderEditSaveWarning="You have unsaved changes to a file, are you sure you want to leave?";$scope.rootDescription=attrs.rootDescription||"["+zone+"]";$scope.description=$state.includes("libedition.libpython")?"lib-python":$state.includes("libedition.libr")?"lib-r":"local-static";$scope.headerDescription=$state.includes("libedition.localstatic")?"Web Resources Content":"Library Content";$scope.localStorageId=$state.includes("libedition.libpython")?"lib-python":$state.includes("libedition.libr")?"lib-r":"local-static"}}}});app.directive("projectZoneEditCallbacks",function(DataikuAPI,$stateParams,Dialogs,$state,CreateModalFromTemplate,FutureProgressModal,DKUtils,CodeStudiosService){return{scope:false,restrict:"A",link:{pre:function($scope,$element,attrs){var zone=attrs.zone;var projectKey=$stateParams.projectKey;$scope.folderEditCallbacks={list:function(){return DataikuAPI.projects.folderEdit.listContents(projectKey,zone)},get:function(content,sendAnyway){return DataikuAPI.projects.folderEdit.getContent(projectKey,zone,content.path,sendAnyway)},previewImageURL:function(content){return DataikuAPI.projects.folderEdit.previewImageURL(projectKey,zone,content.path,content.mimeType)},set:function(content,gitLib){$scope.folderEditCallbacks.setDirty(gitLib);return DataikuAPI.projects.folderEdit.setContent(projectKey,zone,content.path,content.data)},setAll:function(contentMap,gitLibs){DataikuAPI.projects.git.setAllDirty(projectKey,gitLibs);return DataikuAPI.projects.folderEdit.setContentMultiple(projectKey,zone,contentMap)},setDirty:function(gitLib){if(gitLib&&gitLib.length!==0){DataikuAPI.projects.git.setDirty(projectKey,gitLib)}},getDirty:function(gitLib){return DataikuAPI.projects.git.getDirty(projectKey,gitLib)},getAllDirty:function(){return DataikuAPI.projects.git.getDirty(projectKey)},create:function(path,isFolder){return DataikuAPI.projects.folderEdit.createContent(projectKey,zone,path,isFolder)},delete:function(content){return DataikuAPI.projects.folderEdit.deleteContent(projectKey,zone,content.path)},decompress:function(content){return DataikuAPI.projects.folderEdit.decompressContent(projectKey,zone,content.path)},rename:function(content,newName){return DataikuAPI.projects.folderEdit.renameContent(projectKey,zone,content.path,newName)},checkUpload:function(contentPath,paths){return DataikuAPI.projects.folderEdit.checkUploadContent(projectKey,zone,contentPath,paths)},upload:function(contentPath,file,callback){return DataikuAPI.projects.folderEdit.uploadContent(projectKey,zone,contentPath,file,callback)},move:function(content,to){return DataikuAPI.projects.folderEdit.moveContent(projectKey,zone,content.path,to?to.path:"")},copy:function(content){return DataikuAPI.projects.folderEdit.copyContent(projectKey,zone,content.path)},downloadURL:function(content){return DataikuAPI.projects.folderEdit.downloadURL(projectKey,zone,content.path)},editInCodeStudio:function(content){return CodeStudiosService.editFileInCodeStudio($scope,"project_lib_versioned",content.path)}};$scope.folderEditSaveWarning="You have unsaved changes to a file, are you sure you want to leave?";$scope.description="lib";$scope.headerDescription=$state.includes("projects.project.libedition.localstatic")?"Web Resources Content":"Library Content";$scope.localStorageId="lib"+"-"+projectKey}}}});app.directive("resourcesProjectZoneEditCallbacks",function(DataikuAPI,$stateParams,Dialogs,$state,CreateModalFromTemplate,FutureProgressModal,DKUtils,CodeStudiosService){return{scope:false,restrict:"A",link:{pre:function($scope,$element,attrs){var zone=attrs.zone;var projectKey=$stateParams.projectKey;$scope.folderEditCallbacks={list:function(){return DataikuAPI.projects.resourcesFolderEdit.listContents(projectKey,zone)},get:function(content,sendAnyway){return DataikuAPI.projects.resourcesFolderEdit.getContent(projectKey,zone,content.path,sendAnyway)},previewImageURL:function(content){return DataikuAPI.projects.resourcesFolderEdit.previewImageURL(projectKey,zone,content.path,content.mimeType)},set:function(content){return DataikuAPI.projects.resourcesFolderEdit.setContent(projectKey,zone,content.path,content.data)},setAll:function(contentMap){return DataikuAPI.projects.resourcesFolderEdit.setContentMultiple(projectKey,zone,contentMap)},create:function(path,isFolder){return DataikuAPI.projects.resourcesFolderEdit.createContent(projectKey,zone,path,isFolder)},delete:function(content){return DataikuAPI.projects.resourcesFolderEdit.deleteContent(projectKey,zone,content.path)},decompress:function(content){return DataikuAPI.projects.resourcesFolderEdit.decompressContent(projectKey,zone,content.path)},rename:function(content,newName){return DataikuAPI.projects.resourcesFolderEdit.renameContent(projectKey,zone,content.path,newName)},checkUpload:function(contentPath,paths){return DataikuAPI.projects.resourcesFolderEdit.checkUploadContent(projectKey,zone,contentPath,paths)},upload:function(contentPath,file,callback){return DataikuAPI.projects.resourcesFolderEdit.uploadContent(projectKey,zone,contentPath,file,callback)},move:function(content,to){return DataikuAPI.projects.resourcesFolderEdit.moveContent(projectKey,zone,content.path,to?to.path:"")},copy:function(content){return DataikuAPI.projects.resourcesFolderEdit.copyContent(projectKey,zone,content.path)},downloadURL:function(content){return DataikuAPI.projects.resourcesFolderEdit.downloadURL(projectKey,zone,content.path)},editInCodeStudio:function(content){return CodeStudiosService.editFileInCodeStudio($scope,"project_lib_resources",content.path)}};$scope.isInProjectResources=true;$scope.folderEditSaveWarning="You have unsaved changes to a file, are you sure you want to leave?";$scope.description="lib";$scope.headerDescription=$state.includes("projects.project.libedition.localstatic")?"Web Resources Content":"Library Content";$scope.localStorageId="lib"+"-"+projectKey}}}});app.directive("codeStudioZoneEditCallbacks",function(DataikuAPI,$stateParams,Dialogs,$state,CreateModalFromTemplate,FutureProgressModal,DKUtils,CodeStudiosService){return{scope:false,restrict:"A",link:{pre:function($scope,$element,attrs){var zone=attrs.zone;var projectKey=$stateParams.projectKey;var codeStudioObjectId=$stateParams.codeStudioObjectId;$scope.folderEditCallbacks={list:function(){return DataikuAPI.codeStudioObjects.folderEdit.listContents(projectKey,codeStudioObjectId,zone)},get:function(content,sendAnyway){return DataikuAPI.codeStudioObjects.folderEdit.getContent(projectKey,codeStudioObjectId,zone,content.path,sendAnyway)},previewImageURL:function(content){return"/dip/api/code-studio-objects/folder-edition/preview-image?projectKey="+projectKey+"&codeStudioObjectId="+codeStudioObjectId+"&type="+zone+"&path="+encodeURIComponent(content.path)+"&contentType="+encodeURIComponent(content.mimeType)},set:function(content){return DataikuAPI.codeStudioObjects.folderEdit.setContent(projectKey,codeStudioObjectId,zone,content.path,content.data)},setAll:function(contentMap){return DataikuAPI.codeStudioObjects.folderEdit.setContentMultiple(projectKey,codeStudioObjectId,zone,contentMap)},create:function(path,isFolder){return DataikuAPI.codeStudioObjects.folderEdit.createContent(projectKey,codeStudioObjectId,zone,path,isFolder)},delete:function(content){return DataikuAPI.codeStudioObjects.folderEdit.deleteContent(projectKey,codeStudioObjectId,zone,content.path)},decompress:function(content){return DataikuAPI.codeStudioObjects.folderEdit.decompressContent(projectKey,codeStudioObjectId,zone,content.path)},rename:function(content,newName){return DataikuAPI.codeStudioObjects.folderEdit.renameContent(projectKey,codeStudioObjectId,zone,content.path,newName)},checkUpload:function(contentPath,paths){return DataikuAPI.codeStudioObjects.folderEdit.checkUploadContent(projectKey,codeStudioObjectId,zone,contentPath,paths)},upload:function(contentPath,file,callback){return DataikuAPI.codeStudioObjects.folderEdit.uploadContent(projectKey,codeStudioObjectId,zone,contentPath,file,callback)},move:function(content,to){return DataikuAPI.codeStudioObjects.folderEdit.moveContent(projectKey,codeStudioObjectId,zone,content.path,to?to.path:"")},copy:function(content){return DataikuAPI.codeStudioObjects.folderEdit.copyContent(projectKey,codeStudioObjectId,zone,content.path)},downloadURL:function(content){return DataikuAPI.codeStudioObjects.folderEdit.downloadURL(projectKey,codeStudioObjectId,zone,content.path)}};$scope.folderEditSaveWarning="You have unsaved changes to a file, are you sure you want to leave?";$scope.description="files";$scope.headerDescription="Files";$scope.localStorageId=zone+"-"+projectKey+"-"+codeStudioObjectId}}}});app.directive("codeStudioTemplateResourcesCallbacks",function(DataikuAPI,$stateParams,Dialogs,$state,CreateModalFromTemplate,FutureProgressModal,DKUtils,CodeStudiosService){return{scope:false,restrict:"A",link:{pre:function($scope,$element,attrs){const codeStudioTemplateId=$stateParams.codeStudioTemplateId;$scope.folderEditCallbacks={list:function(){return DataikuAPI.codeStudioTemplates.resources.listContents(codeStudioTemplateId)},get:function(content,sendAnyway){return DataikuAPI.codeStudioTemplates.resources.getContent(codeStudioTemplateId,content.path,sendAnyway)},previewImageURL:function(content){return"/dip/api/code-studio-templates/resources/preview-image?codeStudioTemplateId="+codeStudioTemplateId+"&path="+encodeURIComponent(content.path)+"&contentType="+encodeURIComponent(content.mimeType)},set:function(content){return DataikuAPI.codeStudioTemplates.resources.setContent(codeStudioTemplateId,content.path,content.data)},setAll:function(contentMap){return DataikuAPI.codeStudioTemplates.resources.setContentMultiple(codeStudioTemplateId,contentMap)},create:function(path,isFolder){return DataikuAPI.codeStudioTemplates.resources.createContent(codeStudioTemplateId,path,isFolder)},delete:function(content){return DataikuAPI.codeStudioTemplates.resources.deleteContent(codeStudioTemplateId,content.path)},decompress:function(content){return DataikuAPI.codeStudioTemplates.resources.decompressContent(codeStudioTemplateId,content.path)},rename:function(content,newName){return DataikuAPI.codeStudioTemplates.resources.renameContent(codeStudioTemplateId,content.path,newName)},checkUpload:function(contentPath,paths){return DataikuAPI.codeStudioTemplates.resources.checkUploadContent(codeStudioTemplateId,contentPath,paths)},upload:function(contentPath,file,callback){return DataikuAPI.codeStudioTemplates.resources.uploadContent(codeStudioTemplateId,contentPath,file,callback)},move:function(content,to){return DataikuAPI.codeStudioTemplates.resources.moveContent(codeStudioTemplateId,content.path,to?to.path:"")},copy:function(content){return DataikuAPI.codeStudioTemplates.resources.copyContent(codeStudioTemplateId,content.path)},downloadURL:function(content){return DataikuAPI.codeStudioTemplates.resources.downloadURL(codeStudioTemplateId,content.path)}};$scope.folderEditSaveWarning="You have unsaved changes to a file, are you sure you want to leave?";$scope.description="files";$scope.headerDescription="Resource files";$scope.localStorageId="codestudio-templates-"+codeStudioTemplateId+"-resources"}}}});app.directive("userZoneEditCallbacks",function(DataikuAPI,$stateParams,Dialogs,$state,CreateModalFromTemplate,FutureProgressModal,DKUtils){return{scope:false,restrict:"A",link:{pre:function($scope,$element,attrs){var zone=attrs.zone;$scope.folderEditCallbacks={list:function(){return DataikuAPI.profile.folderEdit.listContents(zone)},get:function(content,sendAnyway){return DataikuAPI.profile.folderEdit.getContent(zone,content.path,sendAnyway)},previewImageURL:function(content){return DataikuAPI.profile.folderEdit.previewImageURL(zone,content.path,content.mimeType)},set:function(content){return DataikuAPI.profile.folderEdit.setContent(zone,content.path,content.data)},setAll:function(contentMap){return DataikuAPI.profile.folderEdit.setContentMultiple(zone,contentMap)},create:function(path,isFolder){return DataikuAPI.profile.folderEdit.createContent(zone,path,isFolder)},delete:function(content){return DataikuAPI.profile.folderEdit.deleteContent(zone,content.path)},decompress:function(content){return DataikuAPI.profile.folderEdit.decompressContent(zone,content.path)},rename:function(content,newName){return DataikuAPI.profile.folderEdit.renameContent(zone,content.path,newName)},checkUpload:function(contentPath,paths){return DataikuAPI.profile.folderEdit.checkUploadContent(zone,contentPath,paths)},upload:function(contentPath,file,callback){return DataikuAPI.profile.folderEdit.uploadContent(zone,contentPath,file,callback)},move:function(content,to){return DataikuAPI.profile.folderEdit.moveContent(zone,content.path,to?to.path:"")},copy:function(content){return DataikuAPI.profile.folderEdit.copyContent(zone,content.path)},downloadURL:function(content){return DataikuAPI.profile.folderEdit.downloadURL(zone,content.path)}};$scope.folderEditSaveWarning="You have unsaved changes to a file, are you sure you want to leave?";$scope.description="files";$scope.headerDescription="Files";$scope.localStorageId=zone}}}});app.directive("projectZoneGitRefCallbacks",function(DataikuAPI,$stateParams,WT1){return{scope:false,restrict:"A",link:{pre:function($scope){$scope.gitRefCallbacks={set:function(gitRef,gitRefPath,addPythonPath){WT1.event("project-libs-git-refs-save");return DataikuAPI.git.setProjectGitRef($stateParams.projectKey,gitRef,gitRefPath,addPythonPath)},rm:function(gitRefPath,deleteDirectory){WT1.event("project-libs-git-refs-rm",{"delete-directory":deleteDirectory});return DataikuAPI.git.rmProjectGitRef($stateParams.projectKey,gitRefPath,deleteDirectory)},pullOne:function(gitRefPath){WT1.event("project-libs-git-refs-pull-one");return DataikuAPI.git.pullProjectGitRef($stateParams.projectKey,gitRefPath)},pullAll:function(){WT1.event("project-libs-git-refs-pull-all");return DataikuAPI.git.pullProjectGitRefs($stateParams.projectKey)},pushOne:function(commitMessage,gitRefPath){WT1.event("project-libs-git-ref-push-one");return DataikuAPI.git.pushProjectGitRefs($stateParams.projectKey,commitMessage,gitRefPath)},pushAll:function(commitMessage){WT1.event("project-libs-git-ref-push-all");return DataikuAPI.git.pushProjectGitRefs($stateParams.projectKey,commitMessage)},revertAllFiles:function(gitLib){WT1.event("project-libs-git-ref-revert-all");return DataikuAPI.git.revertAllFiles($stateParams.projectKey,gitLib)},markAsResolved:function(fileName,gitLibPath){WT1.event("project-libs-git-ref-mark-resolved");return DataikuAPI.git.markAsResolved($stateParams.projectKey,fileName,gitLibPath)}}}}}});app.controller("TopLevelFolderEditionController",function($scope,DataikuAPI,$state,$stateParams,CreateModalFromTemplate,TopNav){TopNav.setLocation(TopNav.DSS_HOME,"administration");TopNav.setNoItem();$scope.pythonEmptyCta={title:"No shared python code on this "+$scope.wl.productLongName+" instance.",text:"Create your own libraries or helpers and share them within all the "+$scope.wl.productShortName+" instance. The contents of 'lib-python' are accessible to python recipes and notebooks just like regular python libraries.",image:"static/dataiku/images/empty-states/libraries/empty_state_libraries_large.svg",btnAction:"create",btnLabel:"Create your first shared python file"};$scope.rEmptyCta={title:"No shared R code on this "+$scope.wl.productLongName+" instance.",text:"Create your own libraries and share them within all the "+$scope.wl.productShortName+" instance. The contents of 'lib-r' are accessible to R recipes and notebooks just like regular R libraries.",image:"static/dataiku/images/empty-states/libraries/empty_state_libraries_large.svg",btnAction:"create",btnLabel:"Create your first shared R file"}});app.controller("TopLevelLocalStaticEditorController",function($scope,DataikuAPI,$state,$stateParams,CreateModalFromTemplate,TopNav,$rootScope){TopNav.setLocation(TopNav.DSS_HOME,"administration");TopNav.setNoItem();$scope.emptyCta={title:"No static web resources on this "+$scope.wl.productLongName+" instance.",text:"Create and upload your static web resources and use them for your webapps within all the "+$scope.wl.productShortName+" instance. Right click on local-static root folder and create or upload your files.",image:"static/dataiku/images/empty-states/libraries/empty_state_libraries_large.svg",btnAction:"upload",btnLabel:"Upload your first resource"}});app.controller("ProjectFolderVersionedEditionController",function($scope,DataikuAPI,$state,$stateParams,CreateModalFromTemplate,TopNav,$rootScope){TopNav.setLocation(TopNav.TOP_NOTEBOOKS,"libraries",TopNav.TABS_NONE,null);TopNav.setNoItem();$scope.projectNoTabsCta={title:"Share and reuse code with project Libraries",text:"Develop Libraries to reuse and share code in Python or R Recipes and Notebooks across your project.",image:"static/dataiku/images/empty-states/libraries/empty_state_libraries_large.svg",knowledgeBankLink:"/code/shared/concept-project-libraries"}});app.controller("ProjectFolderVersionedHistoryController",function($scope,$stateParams,TopNav){TopNav.setLocation(TopNav.TOP_NOTEBOOKS,"libraries",TopNav.TABS_NONE,null);TopNav.setNoItem()});app.controller("ProjectFolderResourcesEditionController",function($scope,DataikuAPI,$state,$stateParams,CreateModalFromTemplate,TopNav,$rootScope){TopNav.setLocation(TopNav.TOP_NOTEBOOKS,"libraries",TopNav.TABS_NONE,null);TopNav.setNoItem();$scope.projectNoTabsCta={title:"Project resources",text:"Create your own resources and share them within the project."}});app.directive("folderContentEditor",function(DataikuAPI,$stateParams,Dialogs,$state,CreateModalFromTemplate,$q,$timeout,LocalStorage,$rootScope,openDkuPopin,Logger,CodeMirrorSettingService,FutureProgressModal,DKUtils,CodeStudiosService){return{scope:true,restrict:"A",templateUrl:"/templates/plugins/development/fragments/folder-content-editor.html",link:function($scope,$element,attrs){$scope.editorOptions=null;$scope.uiState={foldRoot:false};$scope.canEdit=true;$scope.canEditInCodeStudio=false;if($stateParams.projectKey){DataikuAPI.projects.getSummary($stateParams.projectKey).success(data=>{$scope.canEdit=data.object.canWriteProjectContent});DataikuAPI.codeStudioTemplates.canEditInCodeStudio($stateParams.projectKey).success(data=>{$scope.canEditInCodeStudio=data.canEdit})}$scope.emptyCta=$scope.$eval(attrs.emptyCta);$scope.noTabsCta=$scope.$eval(attrs.noTabsCta);$scope.canCommit=$scope.$eval(attrs.canCommit);$scope.commitFn=$scope[attrs.commitFn];const postSaveCallback=()=>{if(attrs.postSaveCallback){$scope[attrs.postSaveCallback]()}};const initialPath=attrs.initialPath||$stateParams.initialPath;if(initialPath){$scope.openOnLoad=initialPath}$scope.listContents=function(){return $scope.folderEditCallbacks.list().success(data=>{const recGetExpandedState=function(content,map){if(content.children!=null){map[content.path]=content.expanded||false;content.children.forEach(subContent=>recGetExpandedState(subContent,map))}};const recSetExpandedState=(content,map)=>{if(content.children!=null){content.expanded=map[content.path]||false}};const recSetDepth=function(content,depth){content.depth=depth};const recSetGit=(externalLibs,content,gitSubPath,gitRefPath)=>{if(gitSubPath||content.path in externalLibs.gitReferences){content.fromGit=true;if(gitSubPath&&gitRefPath){const name=content.path.substring(gitRefPath.length+1);content.gitLib=gitRefPath;const gitRef=externalLibs.gitReferences[gitRefPath];if(gitRef&&gitRef.conflictingFiles!=null&&gitRef.conflictingFiles.includes(name)){content.isInConflict=true}if(gitRef&&gitRef.resolvedFiles&&gitRef.resolvedFiles.includes(name)){content.isResolved=true}}}if(externalLibs.pythonPath.includes(content.path)){content.inPythonPath=true}if(externalLibs.rsrcPath.includes(content.path)){content.inRSrcPath=true}if(content.children!=null){content.children.forEach(childContent=>{recSetGit(externalLibs,childContent,content.fromGit,!gitSubPath?content.path:gitRefPath);if(childContent.isInConflict){content.isInConflict=true}if(childContent.isResolved){content.isResolved=true}})}};const handleContent=(content,states,depth)=>{recSetExpandedState(content,states);recSetDepth(content,depth);if(content.children!=null){content.children.forEach(childContent=>handleContent(childContent,states,depth+1))}};const oldStates={};if($scope.devContents!=null){$scope.devContents.forEach(content=>recGetExpandedState(content,oldStates))}$scope.devContents=data;if($scope.gitRefCallbacks){DataikuAPI.git.getProjectExternalLibs($stateParams.projectKey).then(result=>{$scope.externalLibs=result.data;$scope.gitReferences=result.data.gitReferences;if($scope.devContents!=null){$scope.devContents.forEach(content=>recSetGit($scope.externalLibs,content,false,content.path))}},setErrorInScope.bind($scope))}if($scope.devContents!=null){$scope.devContents.forEach(content=>handleContent(content,oldStates,1,false,content.path))}}).error(setErrorInScope.bind($scope))};$scope.listContents().then(()=>{openSavedTabs();if($scope.openOnLoad){openFileFromExternal($scope.openOnLoad);$scope.openOnLoad=null}});$scope.reloadContents=()=>{return $scope.listContents().then(()=>{$scope.tabsList.forEach($scope.reloadTab);$scope.updateActiveTab($scope.activeTabIndex)})};$scope.reloadTab=(tab,index)=>{const filePaths=searchInDevContents(tab.path);if(filePaths&&filePaths.length>0){$scope.tabsList[index]=filePaths[filePaths.length-1];$scope.tabsList[index].needReload=true}};$scope.sortFolder=function(content){content.sort(function(c1,c2){if(c1.children&&!c2.children){return-1}if(!c1.children&&c2.children){return 1}return c1.name>c2.name?1:-1});return content};$scope.originalContentMap={};$scope.editedContentMap={};$scope.activeTabIndex=-1;$scope.openFile=function(file){if(!$scope.canBeDecompressed(file)){var tabIndex=$scope.addTab(file);$scope.updateActiveTab(tabIndex);if(typeof $scope.unregisterArrowSliderInit==="function"){$scope.unregisterArrowSliderInit()}}};$scope.addTab=function(file){var tabIndex=$scope.tabsList.findIndex(f=>f.path===file.path);if(tabIndex===-1){$scope.tabsList.push(file);tabIndex=$scope.tabsList.length-1}else{$scope.tabsList[tabIndex]=file}return tabIndex};$scope.updateActiveTab=function(tabIndex){if(tabIndex!=-1&&tabIndex<$scope.tabsList.length&&$scope.tabsList[tabIndex]){var fileToOpen=$scope.tabsList[tabIndex];var currentContent=$scope.getCurrentContent();if(currentContent){saveTabScrollPosition(currentContent.path,$(".CodeMirror-scroll").scrollTop())}$scope.activeTabIndex=tabIndex;saveActiveTab();$timeout(function(){if($scope.needSlider()){slideToTab(fileToOpen.path)}});if($scope.editedContentMap[fileToOpen.path]&&!fileToOpen.needReload){setCurrentContent(fileToOpen)}else{fileToOpen.needReload=false;const isImage=fileToOpen.mimeType&&fileToOpen.mimeType.startsWith("image");$scope.loadAndSetCurrentContent(fileToOpen,isImage)}}};$scope.loadAndSetCurrentContent=function(file,sendAnyway){$scope.folderEditCallbacks.get(file,sendAnyway).success(function(data){$scope.originalContentMap[file.path]=angular.copy(data);$scope.editedContentMap[file.path]=data;setCurrentContent(file)}).error(setErrorInScope.bind($scope))};$scope.editActiveTabInCodeStudio=function(){$scope.folderEditCallbacks.editInCodeStudio($scope.getCurrentContent())};var setCurrentContent=function(file){var mimeType=selectSyntaxicColoration(file.name,file.mimeType);$scope.editorOptions=CodeMirrorSettingService.get(mimeType,{readOnly:!$scope.canEdit,onLoad:function(codeMirror){$timeout(function(){codeMirror.scrollTo(0,$scope.getTabScrollPosition(file.path))})}})};var selectSyntaxicColoration=function(fileName,mimeType){if(mimeType==="application/sql"){return"text/x-sql"}if(mimeType==="text/x-python-script"){return"text/x-python"}if(fileName.endsWith(".java")){return"text/x-java"}return mimeType};var refreshSyntaxicColoration=function(fileName,mimeType){$scope.editorOptions.mode=selectSyntaxicColoration(fileName,mimeType)};var closeContent=function(file){var tabIndex=$scope.tabsList.findIndex(f=>f.path===file.path);if(tabIndex>-1){$scope.tabsList.splice(tabIndex,1);if(tabIndex==$scope.activeTabIndex){$scope.activeTabIndex=-1;if($scope.tabsList.length>0){var newActiveTabIndex=tabIndex>0?tabIndex-1:0;$scope.updateActiveTab(newActiveTabIndex)}}else if(tabIndex<$scope.activeTabIndex){$scope.activeTabIndex--}}};$scope.closeFile=function(file){if($scope.isContentDirty(file)){CreateModalFromTemplate("/templates/plugins/development/fragments/fileclose-prompt.html",$scope,null,function(newScope){newScope.closeAndSave=function(){var fileToSave=$scope.editedContentMap[file.path];if(fileToSave){$scope.saveContent(fileToSave)}closeContent(file);newScope.dismiss()};newScope.close=function(){closeContent(file);newScope.dismiss()}})}else{closeContent(file)}};$scope.closeOtherFiles=function(file){var dirtyFiles=[];var fileToClose=[];$scope.tabsList.forEach(function(f){if(f.path!=file.path){fileToClose.push(f);if($scope.isContentDirty(f)){dirtyFiles.push(f)}}});if(dirtyFiles.length>0){Dialogs.confirm($scope,"Discard changes","Are you sure you want to discard your changes?").then(function(){$scope.tabsList=[file];$scope.updateActiveTab(0)},angular.noop)}else{$scope.tabsList=[file];$scope.updateActiveTab(0)}};$scope.$watch("tabsList",function(nv,ov){if(nv&&ov&&nv.length<ov.length){var nvPath=nv.map(function(file){return file.path});ov.forEach(function(file){if(nvPath.indexOf(file.path)==-1){delete $scope.originalContentMap[file.path];delete $scope.editedContentMap[file.path]}});cleanTabScrollPosition()}$scope.tabsMap={};if(nv){nv.forEach(function(file){$scope.tabsMap[file.path]=file})}saveTabsList()},true);var searchInDevContents=function(filePath){if(filePath==null)return null;var pathFolders=[];var searchRecursively=function(folder){for(var i=0;i<folder.length;i++){var child=folder[i];if(child.children&&filePath.startsWith(child.path+"/")){pathFolders.push(child);return searchRecursively(child.children)}else if(child.path==filePath){pathFolders.push(child);return pathFolders}}return null};return searchRecursively($scope.devContents)};var openFileFromExternal=function(filePath){var pathFolders=searchInDevContents(filePath);if(pathFolders&&pathFolders.length>0){pathFolders.forEach(function(f){f.expanded=true});let file=pathFolders[pathFolders.length-1];if(!file.mimeType){function recFindFirstFile(x){if(x.mimeType)return x;if(x.children){for(var i=0;i<x.children.length;i++){let y=recFindFirstFile(x.children[i]);if(y.mimeType)return y}}return x}file=recFindFirstFile(file)}if(file.mimeType){$scope.openFile(file);$timeout(function(){$scope.focusedFile=file})}}};$scope.getCurrentContent=function(){if($scope.activeTabIndex>-1&&$scope.tabsList&&$scope.activeTabIndex<$scope.tabsList.length){var currentFile=$scope.tabsList[$scope.activeTabIndex];return currentFile?$scope.editedContentMap[currentFile.path]:null}return null};$scope.getCurrentGitLib=function(){if($scope.activeTabIndex>-1&&$scope.activeTabIndex<$scope.tabsList.length){var currentFile=$scope.tabsList[$scope.activeTabIndex];return currentFile&&currentFile.fromGit?currentFile.gitLib:null}return null};$scope.isContentFromGit=function(){if($scope.activeTabIndex>-1&&$scope.activeTabIndex<$scope.tabsList.length){var currentFile=$scope.tabsList[$scope.activeTabIndex];return currentFile?currentFile.fromGit:false}return false};$scope.isInConflict=function(){if($scope.activeTabIndex>-1&&$scope.activeTabIndex<$scope.tabsList.length){var currentFile=$scope.tabsList[$scope.activeTabIndex];return currentFile?currentFile.isInConflict:false}return false};$scope.isResolved=function(){if($scope.activeTabIndex>-1&&$scope.activeTabIndex<$scope.tabsList.length){var currentFile=$scope.tabsList[$scope.activeTabIndex];return currentFile?currentFile.isResolved:false}return false};$scope.isFileIsExternalLibrariesJSON=function(){if($scope.activeTabIndex>-1&&$scope.activeTabIndex<$scope.tabsList.length){var currentFile=$scope.tabsList[$scope.activeTabIndex];return currentFile?currentFile.path==currentFile.name&&currentFile.name=="external-libraries.json":false}return false};$scope.isFileInPublicDirectory=function(){if(!$scope.isInProjectResources)return false;if($scope.activeTabIndex>-1&&$scope.activeTabIndex<$scope.tabsList.length){var currentFile=$scope.tabsList[$scope.activeTabIndex];return currentFile&&currentFile.path.startsWith("local-static/")}return false};$scope.isContentDirty=function(file){var isFileOpen=file&&file.path&&$scope.originalContentMap[file.path]&&$scope.editedContentMap[file.path];return isFileOpen&&$scope.originalContentMap[file.path].data!=$scope.editedContentMap[file.path].data};$scope.hasDirtyContent=function(){if($scope.tabsList){for(var i=0;i<$scope.tabsList.length;i++){var file=$scope.tabsList[i];if($scope.isContentDirty(file)){return true}}}return false};$scope.reloadFileUponConflict=function(filePath){var element=searchInDevContents(filePath);element[element.length-1].isInConflict=true;$scope.openFile(element[element.length-1])};$scope.focusOnFile=function(filePath){var pathFolders=searchInDevContents(filePath);if(pathFolders&&pathFolders.length>0){pathFolders.forEach(function(content){content.expanded=true});$timeout(function(){$scope.focusedFile=pathFolders[pathFolders.length-1]})}};var slideToTab=function(path){$scope.$broadcast("slideToId","#tabs-frame","#tabs-slider",path)};$scope.openTabMenu=function(element,$event){var template='<ul class="dropdown-menu">'+'<li><a ng-disabled="!canEdit" ng-click="moveContent(element)">'+moveIcon+moveText+"</a></li>"+'<li ng-disabled="!canEdit" ng-show="canDuplicateContent"><a ng-disabled="!canEdit" ng-click="duplicateContent(element)">'+duplicateIcon+duplicateText+"</a></li>"+'<li><a ng-disabled="!canEdit" ng-click="renameContent(element)">'+renameIcon+renameText+"</a></li>"+'<li><a ng-click="closeOtherFiles(element)">'+closeOtherTabIcon+closeOtherTabText+"</a></li>"+'<li><a ng-disabled="!canEdit" ng-click="deleteContent(element)" style="border-top: 1px #eee solid;">'+deleteIcon+deleteText+"</a></li>"+"</ul>";openRightClickMenu(element,$event,template)};$scope.openFileMenu=function(element,$event){let template='<ul class="dropdown-menu">';template+='<li><a ng-disabled="!canEdit" ng-click="moveContent(element)">'+moveIcon+moveText+"</a></li>"+'<li ng-show="canDuplicateContent"><a ng-disabled="!canEdit" ng-click="duplicateContent(element)">'+duplicateIcon+duplicateText+"</a></li>"+($scope.folderEditCallbacks.editInCodeStudio&&$rootScope.projectSummary.canWriteProjectContent&&$scope.canEditInCodeStudio?'<li><a ng-disabled="!canEdit" ng-click="editInCodeStudio(element)">'+editFileIcon+editInCodeStudioText+"</a></li>":"")+'<li><a ng-disabled="!canEdit" ng-click="renameContent(element)">'+renameIcon+renameText+"</a></li>"+'<li><a ng-disabled="!canEdit" ng-click="deleteContent(element)">'+deleteIcon+deleteText+"</a></li>"+($scope.folderEditCallbacks.downloadURL?'<li><a ng-click="downloadElement(element)">'+downloadIcon+downloadText+"</a></li>":"")+"</ul>";openRightClickMenu(element,$event,template)};$scope.openFolderMenu=function(element,$event){const folderLocalActions='<li><a ng-disabled="!canEdit" ng-click="addInElement(element.path, false, element)">'+createFileIcon+createFileText+"</a></li>"+'<li><a ng-disabled="!canEdit" ng-click="addInElement(element.path, true, element)">'+createFolderIcon+createFolderText+"</a></li>"+'<li><a ng-disabled="!canEdit" ng-click="moveContent(element)">'+moveIcon+moveText+"</a></li>"+'<li ng-show="canDuplicateContent"><a ng-disabled="!canEdit" ng-click="duplicateContent(element)">'+duplicateIcon+duplicateText+"</a></li>"+'<li ng-show="!element.fromGit"><a  ng-disabled="!canEdit" ng-click="renameContent(element)">'+renameIcon+renameText+"</a></li>"+'<li><a ng-disabled="!canEdit" ng-click="uploadElement(element.path)">'+uploadIcon+uploadText+"</a></li>"+($scope.folderEditCallbacks.downloadURL?'<li><a ng-click="downloadElement(element)">'+downloadIcon+downloadText+"</a></li>":"")+'<li><a ng-disabled="!canEdit" ng-click="deleteContent(element)">'+deleteIcon+deleteText+"</a></li>";let template='<ul class="dropdown-menu">';if(element.fromGit){if(element.path in $scope.gitReferences){template+='<li><a ng-click="gitRefActions.pushModal(element.path)" ng-disabled="isInConflict()">'+commitIcon+commitText+"</a></li>"+'<li><a ng-click="gitRefActions.pullModal(element.path)">'+pullIcon+pullText+"</a></li>"+'<li><a ng-click="gitRefActions.setModal(gitReferences[element.path], element.path)">'+editIcon+editText+"</a></li>"+'<li><a ng-click="gitRefActions.untrackModal(element.path)">'+unlinkIcon+unlinkText+"</a></li>"+'<li class="divider"></li>'}}template+=folderLocalActions+"</ul>";openRightClickMenu(element,$event,template)};$scope.openRootMenu=function($event){var template='<ul class="dropdown-menu">'+"<li><a ui-sref=\"profile.my.settings({'#':'code_editor'})\" target=\"_blank\">"+customizeEditorSettingsIcon+customizeEditorSettingsText+"</a></li>"+"<li><a ng-click=\"listContents('')\">"+reloadLocalFileIcon+reloadLocalFileText+"</a></li>"+"</ul>";openRightClickMenu(null,$event,template)};$scope.openAddMenu=function($event){var template='<ul class="dropdown-menu">'+'<li><a ng-disabled="!canEdit" ng-if="$state.$current.name == \'plugindev.editor\'" ng-click="newComponentPopin()">Create component</a></li>'+'<li><a ng-disabled="!canEdit" ng-click="addInElement(\'\', false)" id="qa_plugindev_folder-file-add-btn">'+createFileIcon+createFileText+"</a></li>"+'<li><a ng-disabled="!canEdit" ng-click="addInElement(\'\', true)">'+createFolderIcon+createFolderText+"</a></li>"+'<li><a ng-disabled="!canEdit" ng-click="uploadElement(\'\')">'+uploadIcon+uploadText+"</a></li>"+($scope.folderEditCallbacks.downloadURL?"<li><a ng-click=\"downloadElement({path:''})\">"+downloadIcon+downloadText+"</a></li>":"")+"</ul>";openRightClickMenu(null,$event,template)};$scope.openGitMenu=function($event){var template='<ul class="dropdown-menu">'+'<li ng-disabled="!canEdit" ng-show="gitRefCallbacks"><a ng-click="gitRefActions.setModal()">'+importFromGitIcon+importFromGitText+"</a></li>"+'<li ng-disabled="!canEdit" ng-show="gitRefCallbacks"><a ng-click="gitRefActions.listModal()">'+manageReferenceIcon+manageReferenceText+"</a></li>"+'<li ng-disabled="!canEdit" ng-show="gitRefCallbacks"><a ng-click="gitRefActions.pullModal()">'+updateAllIcon+updateAllText+"</a></li>"+'<li ng-disabled="!canEdit" ng-show="gitRefCallbacks"><a ng-click="gitRefActions.pushModal()">'+commitAllIcon+commitAllText+"</a></li>"+"</ul>";openRightClickMenu(null,$event,template)};var openRightClickMenu=function(element,$event,template){var callback=function(newScope){newScope.element=element};openMenu($event,template,callback)};var openMenu=function($event,template,callback){function isElsewhere(elt,e){return $(e.target).parents(".plugindev-tab-menu").length==0}var dkuPopinOptions={template:template,isElsewhere:isElsewhere,callback:callback};openDkuPopin($scope,$event,dkuPopinOptions)};var getFolderEditLocalStorage=function(){var allFolderEditLocalStorage=LocalStorage.get("dss.folderedit");if(!allFolderEditLocalStorage){allFolderEditLocalStorage={}}var folderEditLocalStorage=allFolderEditLocalStorage[$scope.localStorageId];if(!folderEditLocalStorage){folderEditLocalStorage={tabsList:[]}}if(!folderEditLocalStorage.tabsList){folderEditLocalStorage.tabsList=[]}return folderEditLocalStorage};var setFolderEditLocalStorage=function(folderEditLocalStorage){var allFolderEditLocalStorage=LocalStorage.get("dss.folderedit");if(!allFolderEditLocalStorage){allFolderEditLocalStorage={}}allFolderEditLocalStorage[$scope.localStorageId]=folderEditLocalStorage;LocalStorage.set("dss.folderedit",allFolderEditLocalStorage)};var saveTabsList=function(){if($scope.tabsList){var folderEditLocalStorage=getFolderEditLocalStorage();folderEditLocalStorage.tabsList=$scope.tabsList.map(function(file){return file.path});setFolderEditLocalStorage(folderEditLocalStorage)}};var saveActiveTab=function(){var folderEditLocalStorage=getFolderEditLocalStorage();folderEditLocalStorage.activeTab=$scope.tabsList[$scope.activeTabIndex].path;setFolderEditLocalStorage(folderEditLocalStorage)};var saveTabScrollPosition=function(path,scroll){var folderEditLocalStorage=getFolderEditLocalStorage();if(!folderEditLocalStorage.scrollPositions){folderEditLocalStorage.scrollPositions={}}folderEditLocalStorage.scrollPositions[path]=scroll;setFolderEditLocalStorage(folderEditLocalStorage)};var cleanTabScrollPosition=function(){var folderEditLocalStorage=getFolderEditLocalStorage();var scrollPositions=folderEditLocalStorage.scrollPositions;if(scrollPositions){var tabsPathList=$scope.tabsList.map(function(f){return f.path});Object.keys(scrollPositions).forEach(function(path){if(tabsPathList.indexOf(path)==-1){delete scrollPositions[path]}})}setFolderEditLocalStorage(folderEditLocalStorage)};$scope.getTabScrollPosition=function(path){var folderEditLocalStorage=getFolderEditLocalStorage();return folderEditLocalStorage.scrollPositions&&folderEditLocalStorage.scrollPositions[path]?folderEditLocalStorage.scrollPositions[path]:0};var openSavedTabs=function(){var folderEditLocalStorage=getFolderEditLocalStorage();var activeTab=null;$scope.tabsList=[];folderEditLocalStorage.tabsList.forEach(function(filePath){var objPath=searchInDevContents(filePath);if(objPath){var file=objPath[objPath.length-1];$scope.addTab(file);if(filePath==folderEditLocalStorage.activeTab){activeTab=file}}});var fileToOpen=folderEditLocalStorage.activeTab&&activeTab?activeTab:$scope.tabsList[$scope.tabsList.length-1];if(fileToOpen){$scope.focusOnFile(fileToOpen.path);$scope.openFile(fileToOpen);$scope.unregisterArrowSliderInit=$scope.$on("DKU_ARROW_SLIDER:arrow_slider_initialized",function(){slideToTab(fileToOpen.path)})}};const updateGitRefsAfterSave=function(cond){if($scope.gitRefCallbacks){$scope.listContents()}};$scope.saveCurrentContent=function(){var currentContent=$scope.getCurrentContent();$scope.saveContent(currentContent,$scope.getCurrentGitLib())};$scope.editInCodeStudio=function(element){$scope.folderEditCallbacks.editInCodeStudio(element)};function refreshFileSize(filePath){const leaf=(searchInDevContents(filePath)||[]).pop();if(leaf&&$scope.originalContentMap[filePath]&&angular.isString($scope.originalContentMap[filePath].data)){leaf.size=$scope.originalContentMap[filePath].data.length}}function doSaveContent(content,gitLib){$scope.folderEditCallbacks.set(content,gitLib).success(function(data){$scope.originalContentMap[content.path]=angular.copy(content);refreshFileSize(content.path);postSaveCallback();updateGitRefsAfterSave(content.path==="external-libraries.json");const dirtyFiles={[content.path]:content.data};reloadPluginIfNeeded(dirtyFiles)}).error(setErrorInScope.bind($scope))}function validateAndSaveContent(content,gitLib){if(!$scope.folderEditCallbacks.validate){doSaveContent(content,gitLib)}else{const dirtyFiles={[content.path]:content.data};$scope.folderEditCallbacks.validate(dirtyFiles).success(function(data){if(!data.anyMessage){doSaveContent(content,gitLib)}else{CreateModalFromTemplate("/templates/plugins/development/plugin-dev-warning-modal.html",$scope,null,function(modalScope){resetErrorInScope(modalScope);modalScope.messages=data;modalScope.saveAnyway=function(){modalScope.dismiss();doSaveContent(content,gitLib)}})}}).error(setErrorInScope.bind($scope))}}$scope.saveContent=function(content,gitLib){validateAndSaveContent(content,gitLib)};function doSaveAll(dirtyFiles,lib){$scope.folderEditCallbacks.setAll(dirtyFiles,lib).success(function(data){Object.keys(dirtyFiles).forEach(function(filePath){$scope.originalContentMap[filePath].data=dirtyFiles[filePath];refreshFileSize(filePath)});postSaveCallback();updateGitRefsAfterSave("external-libraries.json"in dirtyFiles);reloadPluginIfNeeded(dirtyFiles)}).error(setErrorInScope.bind($scope))}$scope.saveAll=function(){var dirtyFiles={};var modifiedLibs=new Set;$scope.tabsList.forEach(function(file){if($scope.isContentDirty(file)){dirtyFiles[file.path]=$scope.editedContentMap[file.path].data;modifiedLibs=modifiedLibs.add(file.gitLib)}});resetErrorInScope($scope);if(!$scope.folderEditCallbacks.validate){doSaveAll(dirtyFiles,modifiedLibs)}else{$scope.folderEditCallbacks.validate(dirtyFiles).success(function(data){if(!data.anyMessage){doSaveAll(dirtyFiles,modifiedLibs)}else{CreateModalFromTemplate("/templates/plugins/development/plugin-dev-warning-modal.html",$scope,null,function(modalScope){modalScope.messages=data;modalScope.saveAnyway=function(){modalScope.dismiss();doSaveAll(dirtyFiles,modifiedLibs)}})}}).error(setErrorInScope.bind($scope))}};function reloadPluginIfNeeded(dirtyFiles){let doReload="reloadPlugin"in $scope;if(doReload&&dirtyFiles){let hasAnyJson=false;let hasAnyJs=false;for(const f of Object.keys(dirtyFiles)){if(f.toLowerCase().endsWith(".json")){hasAnyJson=true;break}if(f.toLowerCase().endsWith(".js")){hasAnyJs=true;break}}if(!hasAnyJson&&!hasAnyJs){doReload=false}}return doReload?$scope.reloadPlugin($stateParams.pluginId):Promise.resolve()}$scope.deleteContent=function(content){var isNonEmptyFolder=content.children!=null&&content.children.length>0;var message=isNonEmptyFolder?"Are you sure you want to delete "+content.name+" and all its contents?":"Are you sure you want to delete "+content.name+" ?";Dialogs.confirm($scope,"Delete "+(isNonEmptyFolder?"folder":"file"),message).then(function(){$scope.folderEditCallbacks.delete(content).success(function(data){if((content.children&&content.children.length>0||content.mimeType)&&$scope.folderEditCallbacks.setDirty){$scope.folderEditCallbacks.setDirty(content.gitLib)}var toClose=[];$scope.tabsList.forEach(function(file){if(isIncludedOrEqual(file.path,content.path)){toClose.push(file)}});toClose.forEach(function(f){closeContent(f)});if($scope.folderEditCallbacks.setDirty){DKUtils.reloadState()}else{$scope.listContents("")}}).error(setErrorInScope.bind($scope))},angular.noop)};$scope.renameContent=function(content){var popinName=content.children?"Rename folder":"Rename file";Dialogs.prompt($scope,popinName,"New name",content.name).then(function(newName){$scope.folderEditCallbacks.rename(content,newName).success(function(data){if((content.children&&content.children.length>0||content.mimeType)&&$scope.folderEditCallbacks.setDirty){$scope.folderEditCallbacks.setDirty(content.gitLib)}if(content.mimeType!=data.mimeType){if($scope.getCurrentContent()&&$scope.getCurrentContent().path==content.path){refreshSyntaxicColoration(content.name,data.mimeType)}if($scope.tabsMap[content.path]){propagatingMimeTypeChange(content.path,data.mimeType)}}propagatingPathChange(content.path,data.path);reloadPluginIfNeeded().then(()=>{if($scope.folderEditCallbacks.setDirty){DKUtils.reloadState()}else{$scope.listContents("")}})}).error(setErrorInScope.bind($scope))},angular.noop)};$scope.moveContent=function(content){CreateModalFromTemplate("/templates/plugins/development/fragments/filemove-prompt.html",$scope,"MoveContentModalController",function(newScope){resetErrorInScope(newScope);newScope.devContents=angular.copy($scope.devContents);newScope.toMove=content;newScope.doMove=function(to){$scope.folderEditCallbacks.move(content,to).success(function(data){if((content.children&&content.children.length>0||content.mimeType)&&$scope.folderEditCallbacks.setDirty){$scope.folderEditCallbacks.setDirty(content.gitLib)}propagatingPathChange(content.path,data.path);reloadPluginIfNeeded().then(()=>{if($scope.folderEditCallbacks.setDirty){DKUtils.reloadState()}else{$scope.listContents("")}})}).error(setErrorInScope.bind($scope))}})};$scope.canDuplicateContent=$scope.folderEditCallbacks.copy!=null;$scope.duplicateContent=function(content){if((content.children&&content.children.length>0||content.mimeType)&&$scope.folderEditCallbacks.setDirty){$scope.folderEditCallbacks.setDirty(content.gitLib)}$scope.folderEditCallbacks.copy(content).success(function(data){if($scope.folderEditCallbacks.setDirty){DKUtils.reloadState()}else{$scope.listContents("")}}).error(setErrorInScope.bind($scope))};const propagatingPathChange=function(oldPath,newPath){$scope.tabsList.forEach(function(file){if(isIncludedOrEqual(file.path,oldPath)){const oldFilePath=file.path;const newFilePath=file.path.replace(oldPath,newPath);const newName=newFilePath.split("/").at(-1);file.path=newFilePath;file.name=newName;const originalContent=$scope.originalContentMap[oldFilePath];if(originalContent){originalContent.path=newFilePath;originalContent.name=newName;delete $scope.originalContentMap[oldFilePath];$scope.originalContentMap[newFilePath]=originalContent}const editedContent=$scope.editedContentMap[oldFilePath];if(editedContent){editedContent.path=newFilePath;editedContent.name=newName;delete $scope.editedContentMap[oldFilePath];$scope.editedContentMap[newFilePath]=editedContent}}});const folderEditLocalStorage=getFolderEditLocalStorage();for(let i=0;i<folderEditLocalStorage.tabsList.length;i++){const filePath=folderEditLocalStorage.tabsList[i];if(isIncludedOrEqual(filePath,oldPath)){folderEditLocalStorage.tabsList[i]=filePath.replace(oldPath,newPath)}}if(folderEditLocalStorage.activeTab&&isIncludedOrEqual(folderEditLocalStorage.activeTab,oldPath)){folderEditLocalStorage.activeTab=folderEditLocalStorage.activeTab.replace(oldPath,newPath)}setFolderEditLocalStorage(folderEditLocalStorage);const lastPathElementRegExp=new RegExp("/[^/]*$");const oldParent=(searchInDevContents(oldPath.replace(lastPathElementRegExp,""))||[]).pop();if(oldParent&&oldParent.children){const childidx=oldParent.children.findIndex(child=>child.path===oldPath);if(childidx!==-1){const leaf=oldParent.children.splice(childidx,1)[0];const newParent=(searchInDevContents(newPath.replace(lastPathElementRegExp,""))||[]).pop();if(newParent&&newParent.children){function updatePath(leaf){if(leaf){leaf.path=leaf.path.replace(oldPath,newPath);leaf.name=leaf.path.split("/").at(-1);if(leaf.children)leaf.children.forEach(updatePath)}}updatePath(leaf);newParent.children.push(leaf)}}}};var propagatingMimeTypeChange=function(path,mimeType){for(var i=0;i<$scope.tabsList.length;i++){var file=$scope.tabsList[i];if(file.path==path){file.mimeType=mimeType;break}}};var decompressibleMimes=["application/zip","application/x-bzip","application/x-bzip2","application/x-gzip","application/x-tar","application/gzip","application/bzip","application/bzip2","application/x-compressed-tar"];$scope.canBeDecompressed=function(content){return content&&content.mimeType&&decompressibleMimes.indexOf(content.mimeType)>=0};$scope.computeFileIconClass=function(file){if(file.fromGit){return"dku-icon-git-file-16"}else if($scope.canBeDecompressed(file)){return"dku-icon-file-zip-16"}else if($scope.isImage(file)){return"dku-icon-image-16"}else{return"dku-icon-file-text-16"}};$scope.decompressContent=function(content){$scope.folderEditCallbacks.decompress(content).success(function(data){$scope.listContents()}).error(setErrorInScope.bind($scope))};$scope.addInElement=function(contentPath,isFolder,element){CreateModalFromTemplate("/templates/plugins/development/fragments/filename-prompt.html",$scope,null,function(newScope){resetErrorInScope(newScope);newScope.isFolder=isFolder;newScope.doCreation=function(fileName){$scope.folderEditCallbacks.create(contentPath+"/"+fileName,isFolder).success(function(data){if(!isFolder&&element&&element.fromGit){if(element.gitLib){$scope.folderEditCallbacks.setDirty(element.gitLib)}else{$scope.folderEditCallbacks.setDirty(element.name)}}$scope.listContents().success(function(){if(!isFolder){var newElPath=contentPath&&contentPath.length>0?contentPath+"/"+fileName:fileName;var newElement=searchInDevContents(newElPath);if(newElement){$scope.openFile(newElement[newElement.length-1])}}})}).error(setErrorInScope.bind($scope))}})};var openFirstUpload=function(contentPath,firstUpload){$scope.listContents().success(function(){var firstUploadPath=contentPath&&contentPath.length>0?contentPath+"/"+firstUpload.name:firstUpload.name;var firstUploadPathObj=searchInDevContents(firstUploadPath);if(firstUploadPathObj){$scope.openFile(firstUploadPathObj[firstUploadPathObj.length-1])}})};$scope.uploadElement=function(contentPath){CreateModalFromTemplate("/templates/plugins/development/fragments/upload-prompt.html",$scope,"UploadContentModalController",function(newScope){resetErrorInScope(newScope);newScope.folderEditCallbacks=$scope.folderEditCallbacks;newScope.openFirstUpload=openFirstUpload;newScope.contentPath=contentPath})};$scope.downloadElement=function(content){let downloadUrl=$scope.folderEditCallbacks.downloadURL?$scope.folderEditCallbacks.downloadURL(content):undefined;if(downloadUrl){downloadURL(downloadUrl)}else{Logger.warn("No download possible for "+content.path)}};checkChangesBeforeLeaving($scope,$scope.hasDirtyContent,$scope.folderEditSaveWarning);$scope.gitRefActions={setModal:function(gitRef,gitRefPath){CreateModalFromTemplate("/templates/plugins/development/fragments/git-ref-prompt.html",$scope,"GitReferenceSetController",newScope=>{resetErrorInScope(newScope);if(gitRef&&gitRefPath){newScope.gitRef=gitRef;newScope.gitRefPath=gitRefPath;newScope.isEditingGitRef=true}newScope.onSetCallback=()=>{$scope.listContents()}})},listModal:function(){$scope.listContents().then(()=>{CreateModalFromTemplate("/templates/plugins/development/fragments/git-ref-list.html",$scope,undefined,newScope=>{resetErrorInScope(newScope);newScope.gitURL=url=>{url=url.replace(/\.git(#.*)?$/,"");if(url.startsWith("git")){url=url.replace(":","/");url=url.replace("git@","https://")}return url}})},setErrorInScope.bind($scope))},isDirty:function(gitRefPath){return gitRefPath?$scope.folderEditCallbacks.getDirty(gitRefPath):$scope.folderEditCallbacks.getAllDirty()},doPull:function(gitRefPath){const pullGitRefAPI=gitRefPath?$scope.gitRefCallbacks.pullOne(gitRefPath):$scope.gitRefCallbacks.pullAll();pullGitRefAPI.then(pullResult=>{FutureProgressModal.show($scope,pullResult.data,"Updating").then(futureResult=>{if(futureResult){Dialogs.infoMessagesDisplayOnly($scope,"Update result",futureResult).then(()=>{if(futureResult.messages.some(message=>message["severity"]==="SUCCESS")){DKUtils.reloadState()}})}},setErrorInScope.bind($scope))},setErrorInScope.bind($scope))},pullModal:function(gitRefPath){const state=$scope.gitRefActions.isDirty(gitRefPath);state.then(dirtyState=>{if(dirtyState.data){Dialogs.confirm($scope,pullText,"Some files are unpushed, are you sure you want to "+pullText,{btnConfirm:"Reset"}).then(()=>{$scope.gitRefActions.doPull(gitRefPath)},angular.noop)}else{$scope.gitRefActions.doPull(gitRefPath)}})},rmModal:function(gitRefPath){Dialogs.confirm($scope,"Remove Git reference","Are you sure you want to remove this Git reference and the associated folder?",{btnConfirm:"Remove"}).then(()=>{$scope.gitRefCallbacks.rm(gitRefPath,true).then(()=>{DKUtils.reloadState()},setErrorInScope.bind($scope))},angular.noop)},untrackModal:function(gitRefPath){Dialogs.confirm($scope,"Untrack Git reference","Are you sure you want to untrack this Git reference and keep the associated folder?",{btnConfirm:"Untrack"}).then(()=>{$scope.gitRefCallbacks.rm(gitRefPath,false).then(()=>{DKUtils.reloadState()},setErrorInScope.bind($scope))},angular.noop)},pushModalWithCommitMessage:function(gitRefPath,commitMessage){const pushGitRefAPI=gitRefPath?$scope.gitRefCallbacks.pushOne(commitMessage,gitRefPath):$scope.gitRefCallbacks.pushAll(commitMessage);pushGitRefAPI.then(pushResult=>{const title=pushResult.config.params.gitReferencePath?"Pushing library "+pushResult.config.params.gitReferencePath:"Pushing all "+Object.keys($scope.gitReferences).length+" libraries";FutureProgressModal.show($scope,pushResult.data,title).then(futureResult=>{if(futureResult){const toDisplay=Object.assign({},futureResult,{messages:futureResult.messages.filter(message=>message["code"]!=="INFO_GIT_PUSH_CONFLICTING_FILE")});Dialogs.infoMessagesDisplayOnly($scope,"Push result",toDisplay).then(()=>{if(futureResult.messages.some(message=>message["severity"]==="SUCCESS"||message["code"]==="INFO_GIT_PUSH_CONFLICTING_FILE")){if(gitRefPath){const conflictingFiles=futureResult.messages.filter(message=>message["code"]==="INFO_GIT_PUSH_CONFLICTING_FILE");conflictingFiles.forEach(file=>{$scope.reloadFileUponConflict(gitRefPath+"/"+file["details"])})}}});$scope.reloadContents()}},setErrorInScope.bind($scope))},setErrorInScope.bind($scope))},push:function(gitRefPath=null){let standardMessage="Library update from DSS";var options={type:"textarea",btnConfirm:"Commit"};Dialogs.prompt($scope,"Enter your commit message","Commit message",standardMessage,options).then(function(newMessage){$scope.gitRefActions.pushModalWithCommitMessage(gitRefPath,newMessage)},angular.noop)},pushModal:function(gitRefPath=null){if($scope.hasDirtyContent()){var options={btnConfirm:"Save",positive:true};Dialogs.confirm($scope,"Unsaved files","You have unsaved files. Do you want to save them before?",options).then(function(){$scope.saveAll();$scope.gitRefActions.push(gitRefPath)},angular.noop)}else{$scope.gitRefActions.push(gitRefPath)}},makeResolve:function(currentFile){var options={btnConfirm:"Mark",positive:true};Dialogs.confirm($scope,"Mark as resolved","<p>Do you really want to mark this file as resolved?</p><p>You won't be able to mark as unresolved.</p>",options).then(function(){$scope.gitRefCallbacks.markAsResolved(currentFile.path,currentFile.gitLib).then(result=>{currentFile.isResolved=true;currentFile.isInConflict=false;$scope.reloadContents()},error=>Dialogs.displaySerializedError($scope,error))},angular.noop)},markAsResolved:function(){if($scope.activeTabIndex>-1&&$scope.activeTabIndex<$scope.tabsList.length){var currentFile=$scope.tabsList[$scope.activeTabIndex];if($scope.isContentDirty(currentFile)){var options={btnConfirm:"Save and mark",positive:true};Dialogs.confirm($scope,"Save file","Your file has been modified. Do you want to save it and mark as resolved?<br/>"+"You won't be able to mark as unresolved.",options).then(function(){$scope.saveCurrentContent();$scope.gitRefCallbacks.markAsResolved(currentFile.path,currentFile.gitLib).then(()=>{currentFile.isResolved=true;currentFile.isInConflict=false;$scope.reloadContents()},error=>Dialogs.displaySerializedError($scope,error))},angular.noop)}else{$scope.gitRefActions.makeResolve(currentFile)}}else{Dialogs.error($scope,"Mark as resolved","Unable to find this file")}},restoreLibToPreviousVersion:function(){if($scope.activeTabIndex>-1&&$scope.activeTabIndex<$scope.tabsList.length){var currentFile=$scope.tabsList[$scope.activeTabIndex];var options={btnConfirm:"Restore"};Dialogs.confirm($scope,"Restore the library to your previous version","Do you really want to rollback to the previous version. This will replace the current (conflicting) files with the files you were editing before trying to push your library.",options).then(function(){$scope.gitRefCallbacks.revertAllFiles(currentFile.gitLib).then(result=>{if(result){$scope.reloadContents()}},error=>Dialogs.displaySerializedError($scope,error))},angular.noop)}else{Dialogs.error($scope,"Restore to previous version","Unable to find this file")}}};$scope.getMarginFromDepth=function(depth){return(depth+1)*15+10};$scope.getCarretLeftPosition=function(depth){return $scope.getMarginFromDepth(depth-1)};$scope.containsFolder=function(element){if(!element.children){return false}for(var i=0;i<element.children.length;i++){var e=element.children[i];if(typeof e.children!=="undefined"){return true}}return false};$scope.isImage=function(element){return element.mimeType.startsWith("image")};$scope.emptyCtaBtnAction=function(){if($scope.emptyCta&&$scope.emptyCta.btnAction){switch($scope.emptyCta.btnAction){case"create":$scope.addInElement("",false);break;case"upload":$scope.uploadElement("");break;default:return false}}};var isIncludedOrEqual=function(path,path2){return path.startsWith(path2+"/")||path==path2}}}});app.controller("NewFileModalController",function($scope,DataikuAPI,$state,$stateParams,WT1){$scope.fileName=null;$scope.create=function(){$scope.doCreation($scope.fileName);$scope.dismiss()}});app.controller("GitReferenceSetController",function($scope,$stateParams,DKUtils,DataikuAPI,ActivityIndicator,CreateModalFromTemplate,SpinnerService){$scope.gitRef=$scope.gitRef||{remote:"",remotePath:"",checkout:""};$scope.gitRefPath=$scope.gitRefPath||"";$scope.addPythonPath=true;$scope.isGitRefPathUnique=true;$scope.$watch("gitRefPath",function(gitRefPath){if(!$scope.isEditingGitRef){$scope.isGitRefPathUnique=!gitRefPath||!(gitRefPath in $scope.gitReferences)}});$scope.setGitRef=function(){$scope.gitRefCallbacks.set($scope.gitRef,$scope.gitRefPath,$scope.addPythonPath).then(result=>{ActivityIndicator.success("Git reference successfully set.");if($scope.onSetCallback){$scope.onSetCallback()}$scope.gitRefPath=result.data.refPath;$scope.gitRefActions.pullModal($scope.gitRefPath)},setErrorInScope.bind($scope))}});app.controller("MoveContentModalController",function($scope){$scope.uiState={moveToTop:false,destination:null};$scope.changeDestination=function(to){$scope.uiState.destination=to;var recClearMoveToHere=function(l){l.forEach(function(e){if(e!=to){e.moveToHere=false;if(e.children){recClearMoveToHere(e.children)}}})};recClearMoveToHere($scope.devContents);if(to!=null){$scope.uiState.moveToTop=false;to.moveToHere=true}else{$scope.uiState.moveToTop=true}};$scope.hasNowhereToGo=function(){if($scope.uiState.moveToTop){return false}else if($scope.uiState.destination&&$scope.uiState.destination.moveToHere){return false}else{return true}};$scope.move=function(){if($scope.uiState.moveToTop){$scope.doMove(null)}else if($scope.uiState.destination&&$scope.uiState.destination.moveToHere){$scope.doMove($scope.uiState.destination)}$scope.dismiss()}});app.controller("UploadContentModalController",function($scope,DataikuAPI,$state,$stateParams,WT1,Logger){$scope.toUpload=[];$scope.selectedCount=function(){return $scope.toUpload.filter(function(f){return f.$selected}).length};$scope.startedCount=function(){return $scope.toUpload.filter(function(f){return f.started}).length};$scope.doneCount=function(){return $scope.toUpload.filter(function(f){return f.done}).length};var getPathForFileToUpload=function(fileToUpload){return fileToUpload.name};var isAlreadyListed=function(filePath){var found=false;$scope.toUpload.forEach(function(u){found|=filePath==u.name});return found};$scope.uploadFiles=function(files){var filePaths=[];var newFiles=[];for(var i=0,len=files.length;i<len;i++){var file=files[i];var filePath=getPathForFileToUpload(file);if(!isAlreadyListed(filePath)){filePaths.push(filePath);newFiles.push(file)}}$scope.doCheckUpload(filePaths).success(function(data){for(var i=0,len=newFiles.length;i<len;i++){var file=newFiles[i];var feasability=data.feasabilities[i];$scope.toUpload.push({file:file,name:getPathForFileToUpload(file),feasability:feasability,$selected:feasability.canUpload})}}).error(setErrorInScope.bind($scope))};$scope.upload=function(){$scope.doUpload($scope.toUpload.filter(function(f){return f.$selected}))};$scope.goToFirstUploaded=function(){var succeeded=$scope.toUpload.filter(function(f){return f.succeeded!=null})[0];if(succeeded!=null){$scope.openFirstUpload($scope.contentPath,succeeded)}$scope.dismiss()};var checkUploadCompletion=function(){if($scope.startedCount()==1&&$scope.startedCount()==$scope.doneCount()){var succeeded=$scope.toUpload.filter(function(f){return f.succeeded!=null})[0];if(succeeded!=null){$scope.goToFirstUploaded()}}};$scope.doUpload=function(filesToUpload){filesToUpload.forEach(function(fileToUpload){fileToUpload.started=true;$scope.folderEditCallbacks.upload($scope.contentPath,fileToUpload.file,function(e){if(e.lengthComputable){$scope.$apply(function(){fileToUpload.progress=Math.round(e.loaded*100/e.total)})}}).then(function(data){Logger.info("file "+fileToUpload.name+"uploaded",data);fileToUpload.done=true;fileToUpload.succeeded=JSON.parse(data);checkUploadCompletion()},function(payload){Logger.info("file "+fileToUpload.name+"could not be uploaded",payload);fileToUpload.done=true;fileToUpload.failed=getErrorDetails(JSON.parse(payload.response),payload.status,function(h){return payload.getResponseHeader(h)},payload.statusText);fileToUpload.failed.html=getErrorHTMLFromDetails(fileToUpload.failed);checkUploadCompletion()})})};$scope.doCheckUpload=function(filePaths){return $scope.folderEditCallbacks.checkUpload($scope.contentPath,filePaths)}})})();(function(){"use strict";const app=angular.module("dataiku.taggableobjects",[]);const TAGGABLE_TYPES=["PROJECT","FLOW_ZONE","DATASET","MANAGED_FOLDER","STREAMING_ENDPOINT","LABELING_TASK","RECIPE","SQL_NOTEBOOK","SEARCH_NOTEBOOK","JUPYTER_NOTEBOOK","ANALYSIS","STATISTICS_WORKSHEET","SAVED_MODEL","MODEL_EVALUATION_STORE","MODEL_COMPARISON","PROMPT_STUDIO","SEMANTIC_MODEL","RETRIEVABLE_KNOWLEDGE","AGENT_TOOL","AGENT_REVIEW","SCENARIO","DASHBOARD","INSIGHT","WEB_APP","CODE_STUDIO","REPORT","ARTICLE","LAMBDA_SERVICE","WORKSPACE","DATA_COLLECTION","ENTERPRISE_ASSET_COLLECTION","ENTERPRISE_ASSET"];app.constant("TAGGABLE_TYPES",TAGGABLE_TYPES);const FLOW_EXPOSABLE_TYPES=["JUPYTER_NOTEBOOK","WEB_APP","REPORT","SCENARIO"];const FLOW_QUICK_SHAREABLE_TYPES=["DATASET","MANAGED_FOLDER","SAVED_MODEL","MODEL_EVALUATION_STORE","GENAI_EVALUATION_STORE"];app.constant("FLOW_QUICK_SHAREABLE_TYPES",FLOW_QUICK_SHAREABLE_TYPES);app.constant("FLOW_EXPOSABLE_TYPES",[...FLOW_QUICK_SHAREABLE_TYPES,"RETRIEVABLE_KNOWLEDGE",...FLOW_EXPOSABLE_TYPES]);app.constant("ALL_EXPOSABLE_TYPES",[...FLOW_QUICK_SHAREABLE_TYPES,...FLOW_EXPOSABLE_TYPES,"ARTICLE"]);app.constant("FLOW_COMPUTABLE_TYPES",["DATASET","MANAGED_FOLDER","SAVED_MODEL","MODEL_EVALUATION_STORE","GENAI_EVALUATION_STORE","STREAMING_ENDPOINT","RETRIEVABLE_KNOWLEDGE"]);app.constant("FLOW_COMPUTABLE_DEPENDENCIES",["DATASET","SAVED_MODEL","RETRIEVABLE_KNOWLEDGE"]);app.constant("PUBLISHABLE_TYPES",["DATASET","JUPYTER_NOTEBOOK","SAVED_MODEL","MANAGED_FOLDER","SCENARIO","WEB_APP","REPORT","CODE_STUDIO"]);app.constant("PIPELINEABILITY_ACTIONS",{changeSQL:"action-change-sql-pipelineability",changeSpark:"action-change-spark-pipelineability"});function isHDFSAbleType(type){return["HDFS","S3","GCS","Azure"].includes(type)}app.service("TaggableObjectsUtils",function($state,$stateParams){const svc=this;this.getCommonType=function(items,typeFieldAccessor){let commonType=null;for(let i=0;i<items.length;++i){let itemType=typeFieldAccessor?typeFieldAccessor(items[i]):items[i];if(!commonType){commonType=itemType}else if(commonType!=itemType){return"TAGGABLE_OBJECT"}}return commonType||"TAGGABLE_OBJECT"};this.getCommonIndexableType=function(items,typeFieldAccessor){const types=new Set(items.map(item=>typeFieldAccessor?.(item)??item));return types.size===1?types.values().next().value:"INDEXABLE_OBJECT"};this.getIndexableTypeFromNode=function(node,nodeType){const taggableType=this.fromNodeType(nodeType);if(taggableType==="SAVED_MODEL"&&node.savedModelType){switch(node.savedModelType){case"PYTHON_AGENT":case"PLUGIN_AGENT":case"TOOLS_USING_AGENT":return"AI_AGENT";case"LLM_GENERIC":case"RETRIEVAL_AUGMENTED_LLM":return"GEN_AI_MODEL";default:break}}return taggableType};this.fromNodeType=function(nodeType){if(!nodeType)return;if(nodeType.includes("DATASET")){return"DATASET"}else if(nodeType.includes("LAMBDA_SERVICE")){return"LAMBDA_SERVICE"}else if(nodeType.includes("SAVEDMODEL")||nodeType.includes("SAVED_MODEL")){return"SAVED_MODEL"}else if(nodeType.includes("MODELEVALUATIONSTORE")||nodeType.includes("MODEL_EVALUATION_STORE")){return"MODEL_EVALUATION_STORE"}else if(nodeType.includes("GENAIEVALUATIONSTORE")||nodeType.includes("GENAI_EVALUATION_STORE")){return"GENAI_EVALUATION_STORE"}else if(nodeType.includes("RETRIEVABLE_KNOWLEDGE")){return"RETRIEVABLE_KNOWLEDGE"}else if(nodeType.includes("MODEL_COMPARISON")){return"MODEL_COMPARISON"}else if(nodeType.includes("GENAI_COMPARISON")){return"GENAI_COMPARISON"}else if(nodeType.includes("PROMPT_STUDIO")){return"PROMPT_STUDIO"}else if(nodeType.includes("SEMANTIC_MODEL")){return"SEMANTIC_MODEL"}else if(nodeType.includes("AGENT_TOOL")){return"AGENT_TOOL"}else if(nodeType.includes("AGENT_REVIEW")){return"AGENT_REVIEW"}else if(nodeType.includes("STREAMING_ENDPOINT")){return"STREAMING_ENDPOINT"}else if(nodeType.includes("MANAGED_FOLDER")){return"MANAGED_FOLDER"}else if(nodeType=="RECIPE"){return"RECIPE"}else if(nodeType=="LABELING_TASK"){return"LABELING_TASK"}else if(nodeType=="PROJECT"){return"PROJECT"}else if(nodeType=="JUPYTER_NOTEBOOK"){return"JUPYTER_NOTEBOOK"}else if(nodeType=="SQL_NOTEBOOK"){return"SQL_NOTEBOOK"}else if(nodeType=="SEARCH_NOTEBOOK"){return"SEARCH_NOTEBOOK"}else if(nodeType=="DASHBOARD"){return"DASHBOARD"}else if(nodeType=="INSIGHT"){return"INSIGHT"}else if(nodeType=="SCENARIO"){return"SCENARIO"}else if(nodeType=="ANALYSIS"){return"ANALYSIS"}else if(nodeType=="WEB_APP"){return"WEB_APP"}else if(nodeType=="CODE_STUDIO"){return"CODE_STUDIO"}else if(nodeType=="REPORT"){return"REPORT"}else if(nodeType=="NOTEBOOK"){return"NOTEBOOK"}else if(nodeType=="ZONE"){return"FLOW_ZONE"}else if(nodeType=="ARTICLE"){return"ARTICLE"}throw new Error("Unhandled nodeType")};this.fromNode=function(node){return{type:svc.fromNodeType(node.nodeType),projectKey:node.projectKey,id:node.name,displayName:node.description||node.name,subType:node.datasetType||node.recipeType||node.savedModelType||node.folderType,tags:node.tags}};this.fromObjectItem=function(objectItem){return{type:svc.fromNodeType(objectItem.nodeType),projectKey:objectItem.projectKey,id:objectItem.id||objectItem.name,displayName:objectItem.description||objectItem.name,subType:objectItem.datasetType||objectItem.recipeType||objectItem.savedModelType,tags:objectItem.tags,workspaceKey:objectItem.workspaceKey}};this.fromListItem=function(listItem){return{type:svc.taggableTypeFromAngularState(listItem),projectKey:listItem.projectKey||$stateParams.projectKey,id:listItem.id,displayName:listItem.name,subType:listItem.type,tags:listItem.tags,workspaceKey:listItem.workspaceKey}};this.taggableTypeFromAngularState=function(listItem){const stateName=$state.current.name;if(listItem&&listItem.type&&stateName.startsWith("projects.project.notebooks")){switch(listItem.type){case"SQL":return"SQL_NOTEBOOK";case"SEARCH":return"SEARCH_NOTEBOOK";default:return"JUPYTER_NOTEBOOK"}}if(listItem&&stateName.startsWith("projects.project.continuous-activities")){return"CONTINUOUS_ACTIVITY"}if(stateName.startsWith("projects.project.datasets")||stateName.startsWith("projects.project.foreigndatasets")){return"DATASET"}else if(stateName.startsWith("projects.project.streaming-endpoints")){return"STREAMING_ENDPOINT"}else if(stateName.startsWith("projects.project.labelingtasks")){return"LABELING_TASK"}else if(stateName.startsWith("projects.project.managedfolders")){return"MANAGED_FOLDER"}else if(stateName.startsWith("projects.project.modelevaluationstores")){return"MODEL_EVALUATION_STORE"}else if(stateName.startsWith("projects.project.genaievaluationstores")){return"GENAI_EVALUATION_STORE"}else if(stateName.startsWith("projects.project.modelcomparisons")){return"MODEL_COMPARISON"}else if(stateName.startsWith("projects.project.genaicomparisons")){return"GENAI_COMPARISON"}else if(stateName.startsWith("projects.project.savedmodels")||stateName.startsWith("projects.project.genai")){return"SAVED_MODEL"}else if(stateName.startsWith("projects.project.promptstudios")){return"PROMPT_STUDIO"}else if(stateName.startsWith("projects.project.semanticmodels")){return"SEMANTIC_MODEL"}else if(stateName.startsWith("projects.project.agenttools")){return"AGENT_TOOL"}else if(stateName.startsWith("projects.project.agentreviews")){return"AGENT_REVIEW"}else if(stateName.startsWith("projects.project.recipes")){return"RECIPE"}else if(stateName.startsWith("projects.project.analyses")){return"ANALYSIS"}else if(stateName.startsWith("projects.project.scenarios")){return"SCENARIO"}else if(stateName.startsWith("projects.project.webapps")||stateName.startsWith("projects.project.agenthub")||stateName.startsWith("projects.project.traceexplorers")){return"WEB_APP"}else if(stateName.startsWith("projects.project.code-studios")){return"CODE_STUDIO"}else if(stateName.startsWith("projects.project.reports")){return"REPORT"}else if(stateName.startsWith("projects.project.dashboards.insights")){return"INSIGHT"}else if(stateName.startsWith("projects.project.dashboards")){return"DASHBOARD"}else if(stateName.startsWith("projects.project.lambdaservices")){return"LAMBDA_SERVICE"}else if(stateName.startsWith("projects.project.continuous-activities")){throw new Error("Cannot get continuous activity taggable type from angular state")}else if(stateName.startsWith("projects.project.notebooks")){throw new Error("Cannot get notebook taggable type from angular state")}throw new Error("Failed to get taggable type from angular state")};this.isComputable=function(tor){if(!tor)return;return tor.type=="DATASET"||tor.type=="MANAGED_FOLDER"||tor.type=="SAVED_MODEL"||tor.type=="MODEL_EVALUATION_STORE"||tor.type=="GENAI_EVALUATION_STORE"||tor.type=="STREAMING_ENDPOINT"};this.isLocal=function(tor){if(!tor||!$stateParams.projectKey)return;return tor.projectKey==$stateParams.projectKey};this.isHDFSAbleType=isHDFSAbleType;this.humanReadableObjectType=function(objectType){if(!objectType)return;switch(objectType){case"MANAGED_FOLDER":return"folder";case"SAVED_MODEL":return"model";case"GENAI_EVALUATION_STORE":return"genai evaluation store";case"MODEL_EVALUATION_STORE":return"model evaluation store";case"LAMBDA_SERVICE":return"API service";default:return objectType.toLowerCase().replace("_"," ")}}});app.service("TaggableObjectsService",function($stateParams,$rootScope,$q,DataikuAPI,CreateModalFromTemplate,Dialogs,Logger,QuickSharingWT1EventsService){const THUMBNAIL_WIDTH=220;const THUMBNAIL_HEIGHT=138;this.delete=function(deletionRequests,customMassDeleteSelected){let deferred=$q.defer();CreateModalFromTemplate("/templates/taggable-objects/delete-modal.html",$rootScope,"DeleteTaggableObjectsModalController",function(modalScope){modalScope.nrObjectsToDelete=0;modalScope.nrObjectsToUnshare=0;modalScope.deleteAndReconnect=false;deletionRequests.forEach(function(dr){dr.options={...dr.options,...{dropData:false}};dr.projectKey==$stateParams.projectKey?modalScope.nrObjectsToDelete+=1:modalScope.nrObjectsToUnshare+=1;modalScope.deleteAndReconnect|=dr.options.deleteAndReconnect});modalScope.computedImpact={};modalScope.deletionRequests=deletionRequests;modalScope.currentProject=$stateParams.projectKey}).then(function(){deletionRequests=deletionRequests.filter(it=>it.type!="FLOW_ZONE"||it.id!="default");deletionRequests.forEach(function(item){if(item.type=="JUPYTER_NOTEBOOK"&&item.activeSessions){item.activeSessions.forEach(function(session){DataikuAPI.jupyterNotebooks.unload(session.sessionId)});delete item.activeSessions}});let tmpDeletionRequests=[],unsharingRequests=[];for(const delRequest of deletionRequests){delRequest.projectKey==$stateParams.projectKey?tmpDeletionRequests.push(delRequest):unsharingRequests.push(delRequest)}const deleteCall=customMassDeleteSelected||DataikuAPI.taggableObjects.delete;deleteCall(deletionRequests,$stateParams.projectKey).success(function(errors){$rootScope.$emit("flowItemAddedOrRemoved",deletionRequests);deletionRequests.forEach(function(req){if(!errors.error&&req.projectKey!==$stateParams.projectKey){DataikuAPI.projects.getObjectExposition(req.projectKey,req.type,req.id).success(objectExposition=>{const object={projectKey:req.projectKey,quickSharingEnabled:objectExposition.quickSharingEnabled,type:req.type,localName:req.id};QuickSharingWT1EventsService.onRuleRemoved(object,$stateParams.projectKey);if(objectExposition.rules.length===0&&!objectExposition.quickSharingEnabled){QuickSharingWT1EventsService.onSharingDisabled({...object,rules:[{targetProject:$stateParams.projectKey}]})}})}});DataikuAPI.flow.zones.list($stateParams.projectKey).then(data=>{if(data.data.length==1&&data.data[0].id=="default"){DataikuAPI.flow.zones.delete($stateParams.projectKey,"default")}});Dialogs.infoMessagesDisplayOnly($rootScope,"Cannot delete or unshare",errors);deferred.resolve()}).error(function(){deferred.reject.apply(this,arguments)})});return deferred.promise};this.checkAndUpdateThumbnailData=(tor,selector,sourceDocument=document)=>{const deferred=$q.defer();DataikuAPI.images.getObjectThumbnailInfo(tor.projectKey,tor.type,tor.id).success(imageInfo=>{if(tor.versionTag&&tor.versionTag.lastModifiedOn>imageInfo.lastModified){Logger.debug(`Thumbnail for object ${tor.type} is outdated, generating a new one`);const containerToUseAsThumbnail=sourceDocument.querySelector(selector);if(containerToUseAsThumbnail){const loadImagePromises=[];containerToUseAsThumbnail.querySelectorAll("img").forEach(img=>{if(!img.complete){loadImagePromises.push($q(resolve=>{img.onload=resolve;img.onerror=resolve}))}});$q.all(loadImagePromises).then(()=>this.generateThumbnailData(selector,sourceDocument)).then(thumbnailData=>{DataikuAPI.images.uploadCapturedObjectThumbnail(tor.projectKey,tor.type,tor.id,thumbnailData).success(()=>deferred.resolve(true)).error(deferred.reject.bind(deferred))}).catch(deferred.reject.bind(deferred))}else{deferred.reject("Failed to generate thumbnail, html element not found")}}else{deferred.resolve(false)}});return deferred.promise};this.generateThumbnailData=(selector,sourceDocument=document)=>{const container=sourceDocument.querySelector(selector);const rect=container.getBoundingClientRect();const width=rect.width;const height=width*THUMBNAIL_WIDTH/THUMBNAIL_HEIGHT;const scale=THUMBNAIL_WIDTH/width;const maxBounds={x:rect.x+width,y:rect.y+height};for(let node=container;node!==null;node=node.parentElement){maxBounds.x+=node.scrollLeft;maxBounds.y+=node.scrollTop}return html2canvas_latest(container,{foreignObjectRendering:true,width:width/scale,height:height/scale,scale:scale,ignoreElements:element=>{const bounds=element.getBoundingClientRect();if(bounds.x>maxBounds.x||bounds.y>maxBounds.y){return true}return!element.contains(container)&&!container.contains(element)},onclone:cloneDocument=>{let node=cloneDocument.querySelector(selector);while(node){if(node.style){node.scrollTop=0;node.scrollLeft=0;node.style.position="absolute";node.style.top=0;node.style.left=0;node.style.margin="initial";node.style.padding="initial"}node=node.parentNode}const images=cloneDocument.querySelectorAll("img");const promises=[];if(images.length){const imageCanvas=document.createElement("canvas");const imageCtx=imageCanvas.getContext("2d");cloneDocument.querySelectorAll("img").forEach(img=>{img.crossOrigin="anonymous";promises.push(new Promise(resolve=>{img.onload=()=>{if(img&&img.naturalWidth){imageCanvas.width=img.naturalWidth;imageCanvas.height=img.naturalHeight;imageCtx.clearRect(0,0,img.naturalWidth,img.naturalHeight);imageCtx.drawImage(img,0,0);img.src=imageCanvas.toDataURL()}img.onload=null;resolve()};img.onerror=()=>{img.remove();resolve()}}))})}return Promise.all(promises)}}).then(canvas=>{const thumbnail=document.createElement("canvas");thumbnail.width=THUMBNAIL_WIDTH;thumbnail.height=THUMBNAIL_HEIGHT;const imageData=canvas.getContext("2d").getImageData(0,0,THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT);thumbnail.getContext("2d").putImageData(imageData,0,0);return thumbnail.toDataURL()})}});app.filter("niceTaggableType",function($filter,$translate){const dict={MANAGED_FOLDER:"folder",LOCAL_MANAGED_FOLDER:"folder",SAVED_MODEL:"model",LOCAL_SAVEDMODEL:"model",MODEL_EVALUATION_STORE:"evaluation store",GENAI_EVALUATION_STORE:"genai evaluation store",LOCAL_MODEL_EVALUATION_STORE:"evaluation store",LOCAL_GENAI_EVALUATION_STORE:"genai evaluation store",MODEL_COMPARISON:"model comparison",GENAI_COMPARISON:"genai comparison",LAMBDA_SERVICE:"API service",SQL_NOTEBOOK:"SQL notebook",SEARCH_NOTEBOOK:"Search notebook",RETRIEVABLE_KNOWLEDGE:"knowledge bank",TAGGABLE_OBJECT:"item",INDEXABLE_OBJECT:"item",GEN_AI_MODEL:"GenAI model",AI_AGENT:"AI agent"};const plurals={ANALYSIS:"analyses"};return function(input,count=1){if(!input)return input;const key="TAGGABLE_TYPE."+input;const usePlural=count>1||count===0&&($translate&&$translate.proposedLanguage()||$translate.use()||"en")==="en";if(usePlural){const pluralKey=key+".PLURAL";const pluralResult=$translate.instant(pluralKey);if(pluralResult!==pluralKey){return pluralResult}}const result=$translate.instant(key);if(result===key){return $filter("plurify")(dict[input]||input.toLowerCase().replace("_"," "),count,plurals[input])}else{return usePlural?result+"s":result}}});app.filter("taggableObjectRef",function(){return function(input){if(!input||!input.type)return"";switch(input.type){case"PROJECT":return"Project "+input.projectKey;case"DATASET":return"Dataset "+input.projectKey+"."+input.id;case"RECIPE":return"Recipe "+input.projectKey+"."+input.id;default:return input.id}}});app.controller("_TaggableObjectPageRightColumnActions",function($scope,$rootScope,$controller,$state,TaggableObjectsUtils,CreateModalFromTemplate,$timeout,ActivityIndicator){$controller("TaggableObjectPageMassActionsCallbacks",{$scope:$scope});$scope.getSelectedNodes=function(){return[$scope.selection.selectedObject]};$scope.getSelectedTaggableObjectRefs=function(){return $scope.getSelectedNodes().map(TaggableObjectsUtils.fromObjectItem)};const safeRenamingObjectTypes=["AGENT_TOOL","RETRIEVABLE_KNOWLEDGE"];$scope.safeIsDirty=function(){if(safeRenamingObjectTypes.includes($scope.objectType)){if($scope.isDirty!=null){return $scope.isDirty()}else if($scope.dirtySettings){return $scope.dirtySettings()}}return false};$scope.renameTaggableObject=function(){CreateModalFromTemplate("/templates/taggable-objects/rename-modal.html",$scope,null,function(newScope){const currentName=$rootScope.topNav.item.data.name;newScope.objectName=currentName;newScope.uiState={newName:currentName};newScope.go=function(){$scope.renameObjectAndSave(newScope.uiState.newName).success(()=>{ActivityIndicator.success("Saved");$state.reload()}).error(setErrorInScope.bind($scope));newScope.dismiss()}})}});app.controller("DeleteTaggableObjectsModalController",function($scope,$state,$stateParams,Assert,DataikuAPI,WT1,TaggableObjectsUtils,FLOW_COMPUTABLE_TYPES,PUBLISHABLE_TYPES){$scope.$watch("deletionRequests",function(newDeletionRequests){if(newDeletionRequests==null){return}Assert.inScope($scope,"deletionRequests");$scope.commonTaggableType=TaggableObjectsUtils.getCommonType($scope.deletionRequests,function(x){return x.type});let typesWithImpact=PUBLISHABLE_TYPES.concat(FLOW_COMPUTABLE_TYPES).concat("DASHBOARD").concat("LABELING_TASK").concat("RETRIEVABLE_KNOWLEDGE").concat("AGENT_TOOL");let computeImpact=$scope.deletionRequests.filter(function(x){return typesWithImpact.indexOf(x.type)>-1}).length>0;if(computeImpact){DataikuAPI.taggableObjects.computeDeletionImpact($scope.deletionRequests,$stateParams.projectKey).success(function(data){$scope.computedImpact.data=data;$scope.nrDistinctUnsharedItemTypes=new Set($scope.computedImpact.data.toUnshare.map(obj=>obj.type)).size;$scope.nbActions=0;$scope.nbActionsNotRequested=0;for(let k in data.availableOptions){let isShared=false;for(const o of data.toUnshare){let objectName=o.projectKey+"."+o.id;isShared|=objectName===k}if(!isShared){let optns=data.availableOptions[k];let enabled=false;for(let j in optns){enabled|="isDropDataDangerous"!==j&&optns[j]}if(enabled){$scope.nbActions++;if(!$scope.deletionRequests.map(dr=>dr.projectKey+"."+dr.id).includes(k)){$scope.nbActionsNotRequested++}}}}$scope.deletionRequests.forEach(function(dr){switch(dr.type){case"DASHBOARD":$scope.nbActions+=2;$scope.hasAnyDashboard=true;break;case"DATASET":dr.options.dropData=$scope.appConfig.dropDataWithDatasetDeleteEnabled;dr.options.dropMetastoreTable=$scope.appConfig.dropDataWithDatasetDeleteEnabled;break;case"MANAGED_FOLDER":dr.options.dropData=$scope.appConfig.dropDataWithDatasetDeleteEnabled;break;case"LABELING_TASK":dr.options.dropData=$scope.appConfig.dropDataWithDatasetDeleteEnabled;dr.options.dropData=false;break}});let deletedLabelingTasks=angular.copy($scope.computedImpact.data.deletedLabelingTasks);deletedLabelingTasks.forEach(function(lt){lt.displayName=lt.name+" ("+lt.id+")";lt.options=$scope.computedImpact.data.availableOptions[lt.projectKey+"."+lt.id];lt.type="LABELING_TASK"});$scope.allDeletedObjects=$scope.deletionRequests.concat(deletedLabelingTasks)}).error(setErrorInScope.bind($scope))}else{$scope.computedImpact.data={ok:true}}$scope.confirm=function(){WT1.event("taggable-items-delete-many",{state:$state.current,numberOfItems:$scope.deletionRequests.length});$scope.resolveModal();$scope.dismiss()};$scope.isZoneDeleted=newDeletionRequests.some(deletionRequest=>deletionRequest.type==="FLOW_ZONE")})});app.controller("TaggableObjectPageMassActionsCallbacks",function($scope,$rootScope,$state,DKUtils,PIPELINEABILITY_ACTIONS){$scope.onAction=function(action){switch(action){case"action-delete":$state.go("projects.project.flow");break;case"action-tag":break;case"action-watch":case"action-star":$rootScope.$emit("userInterestsUpdated");break;case"action-clear":DKUtils.reloadState();break;case"action-build":break;case"action-change-connection":DKUtils.reloadState();break;case"action-update-status":case"action-set-auto-count-of-records":case"action-set-virtualizable":case"action-add-to-scenario":case"action-share":break;case"action-unshare":$state.go("projects.project.flow");break;case"action-change-recipes-engines":case"action-change-spark-config":case PIPELINEABILITY_ACTIONS.changeSpark:case PIPELINEABILITY_ACTIONS.changeSQL:case"action-change-impala-write-mode":case"action-change-hive-engine":case"action-change-spark-engine":break;case"action-convert-to-hive":case"action-convert-to-impala":DKUtils.reloadState();break;case"action-change-python-env":case"action-change-r-env":DKUtils.reloadState();break;case"action-code-studio-state-change":break;default:break}}});app.controller("ListMassActionsCallbacks",function($scope,PIPELINEABILITY_ACTIONS){$scope.onAction=function(action){switch(action){case"action-delete":case"action-tag":case"action-watch":case"action-star":case"action-clear":case"action-build":case"action-change-connection":case"action-update-status":case"action-set-auto-count-of-records":case"action-set-virtualizable":case"action-add-to-scenario":case"action-share":case"action-unshare":case"action-change-recipes-engines":case"action-change-spark-config":case PIPELINEABILITY_ACTIONS.changeSQL:case PIPELINEABILITY_ACTIONS.changeSpark:case"action-change-impala-write-mode":case"action-change-hive-engine":case"action-change-spark-engine":case"action-convert-to-hive":case"action-convert-to-impala":case"action-change-python-env":case"action-change-r-env":case"action-code-studio-state-change":$scope.list();break;default:break}}});app.controller("_TaggableObjectsListPageCommon",function($controller,$scope,$stateParams,$rootScope,TaggableObjectsUtils,InterestsService){$controller("ListMassActionsCallbacks",{$scope:$scope});$controller("_TaggableObjectsMassActions",{$scope:$scope});let loadMoreLock=false;$scope.loadMoreItems=function(){if(!loadMoreLock&&$scope.listItems&&$scope.maxItems<$scope.listItems.length){$scope.maxItems+=20;loadMoreLock=true;setTimeout(function(){loadMoreLock=false},300)}};$scope.selectTag=function(event,tag){if(!$scope.selection||!$scope.selection.filterQuery||!$scope.selection.filterQuery.tags)return;let index=$scope.selection.filterQuery.tags.indexOf(tag);if(index>=0){$scope.selection.filterQuery.tags.splice(index,1)}else{$scope.selection.filterQuery.tags.push(tag)}};$scope.restoreOriginalSelection=function(){if(!$scope.selection||!$scope.selection.filteredSelectedObjects){return}$scope.selection.filteredSelectedObjects.forEach(obj=>{let i=$scope.listItems.find(item=>item.id===obj.id);if(i){i.$selected=true}})};$scope.$on("tagSelectedInList",function(e,tag){$scope.selectTag($scope.selection.filterQuery,tag);e.stopPropagation()});$scope.$on("selectedIndex",function(e,index){$scope.$broadcast("clearMultiSelect")});$scope.$on("projectTagsUpdated",function(e,args){if(args.refreshFlowFilters)$scope.list()});const updateSelectedObjectMetadata=function(metaData){const o=$scope.selection.selectedObject;if(o&&metaData){o.shortDesc=metaData.shortDesc;o.description=metaData.description;o.tags=angular.copy(metaData.tags);o.checklists=angular.copy(metaData.checklists);o.customFields=angular.copy(metaData.customFields)}};const unregisterObjectMetaDataRefresh=$rootScope.$on("objectMetaDataRefresh",(ev,metaData)=>{updateSelectedObjectMetadata(metaData)});const unregisterObjectMetaDataChanged=$rootScope.$on("objectMetaDataChanged",(ev,metaData)=>{updateSelectedObjectMetadata(metaData)});$scope.containsForeignObject=function(listItems){return listItems&&listItems.some(item=>item.foreign)};$scope.enableForeignFilterWithLabels=({all,onlyLocal,onlyForeign},defaultFilterValue="")=>{$scope.showForeignFilter=true;$scope.showForeignOptions=[{label:all,value:""},{label:onlyLocal,value:"false"},{label:onlyForeign,value:"true"}];$scope.selection.filterQuery.foreign=defaultFilterValue};$scope.allStarred=function(listItems){if(!listItems||!listItems.length)return true;return listItems.map(x=>!!(x&&x.interest&&x.interest.starred)).reduce((a,b)=>a&&b)};$scope.allWatching=function(listItems){if(!listItems||!listItems.length)return true;return listItems.map(it=>it.interest&&it.interest.watching).every($scope.isWatching)};$scope.watchObject=function(watch,item){InterestsService.watch($scope,[TaggableObjectsUtils.fromListItem(item)],watch).then($scope.list)};$scope.starObject=function(star,item){InterestsService.star($scope,[TaggableObjectsUtils.fromListItem(item)],star).then($scope.list)};$scope.toggleFilterStarred=function(){let fq=$scope.selection.filterQuery;fq.interest.starred=fq.interest.starred===""?"true":""};$scope.list=function(){return $scope.listHeads($stateParams.projectKey,$scope.tagFilter).success(function(data){$scope.filteredOut=data.filteredOut;$scope.listItems=data.items;$scope.restoreOriginalSelection();if($scope.listHeadHook&&typeof $scope.listHeadHook.list==="function"){$scope.listHeadHook.list($scope.listItems)}}).error(setErrorInScope.bind($scope))};$scope.getSelectedListItems=function(){if($scope.selection.selectedObjects&&$scope.selection.selectedObjects.length){return $scope.selection.selectedObjects}else if($scope.selection.selectedObject){return[$scope.selection.selectedObject]}else{return[]}};$scope.getSelectedTaggableObjectRefs=function(){return $scope.getSelectedListItems().map(TaggableObjectsUtils.fromListItem)};$scope.$on("$destroy",()=>{unregisterObjectMetaDataRefresh();unregisterObjectMetaDataChanged()});try{$scope.listItemType=TaggableObjectsUtils.taggableTypeFromAngularState()}catch(e){console.info("Cannot set the taggable type on this list page")}});app.service("TaggableObjectsCapabilities",function($stateParams,AI_EXPLANATION_MODAL_MODES,RecipesCapabilities,TaggableObjectsUtils,CreateModalFromTemplate){$.extend(this,RecipesCapabilities);this.canChangeConnection=function(tor){if(tor.nodeType){tor=TaggableObjectsUtils.fromNode(tor)}if($stateParams.projectKey&&tor.projectKey!=$stateParams.projectKey){return false}if(tor.type=="DATASET"){if(tor.subType&&["Inline","UploadedFiles"].includes(tor.subType)){return false}return true}else if(tor.type=="MANAGED_FOLDER"){return true}return false};this.canSyncMetastore=function(tor){if(tor.nodeType){tor=TaggableObjectsUtils.fromNode(tor)}if($stateParams.projectKey&&tor.projectKey!=$stateParams.projectKey){return false}if(tor.type=="DATASET"){if(tor.subType&&isHDFSAbleType(tor.subType)){return true}}return false};this.explainObject=function(){const scope=this;CreateModalFromTemplate("/static/dataiku/ai-explanations/explanation-modal/explanation-modal.html",scope,"AIExplanationModalController",function(newScope){newScope.objectType=TaggableObjectsUtils.fromNodeType(scope.selection.confirmedItem.nodeType);newScope.object=scope.selection.selectedObject;newScope.mode=AI_EXPLANATION_MODAL_MODES.EXPLAIN})}});app.controller("_TaggableObjectsCapabilities",function($scope,TaggableObjectsCapabilities){$.extend($scope,TaggableObjectsCapabilities)});app.controller("_TaggableObjectsMassActions",function($scope,$state,$rootScope,$q,$stateParams,WT1,Logger,Dialogs,DataikuAPI,CreateModalFromTemplate,TaggableObjectsService,TaggingService,translate,ImpalaService,HiveService,SparkService,ComputablesService,DatasetsService,DatasetConnectionChangeService,RecipesEnginesService,Ng2ObjectsExpositionService,GlobalProjectActions,InterestsService,InterestWording,WatchInterestState,CodeEnvsService,ToolBridgeService,PipelineService,PIPELINEABILITY_ACTIONS){function onAction(action){return function(data){if($scope.onAction){$scope.onAction(action)}else{Logger.warn("No mass action callbacks handler")}return data}}$scope.deleteSelected=function(items=$scope.getSelectedTaggableObjectRefs(),onSuccess=onAction("action-delete")){WT1.event("action-delete",{state:$state.current.name,items:items.length});return TaggableObjectsService.delete(items,$scope.customMassDeleteSelected).then(onSuccess)};$scope.startApplyTagging=function(selection=$scope.getSelectedTaggableObjectRefs()){WT1.event("action-tag",{state:$state.current.name,items:selection.length});TaggingService.startApplyTagging(selection).then(onAction("action-tag"))};$scope.copyAllSelected=function(){WT1.event("action-copy-all",{state:$state.current.name,preselectedNodes:$scope.getSelectedNodes().length});$scope.startTool("COPY",{preselectedNodes:$scope.getSelectedNodes().map(n=>n.id)})};$scope.watchObjects=function(watch){InterestsService.watch($scope,$scope.getSelectedTaggableObjectRefs(),watch).then(onAction("action-watch"))};$scope.starObjects=function(star){InterestsService.star($scope,$scope.getSelectedTaggableObjectRefs(),star).then(onAction("action-star"))};$scope.isWatching=WatchInterestState.isWatching;$scope.actionLabels={...InterestWording.labels};$scope.actionTooltips={...InterestWording.tooltips,CANNOT_TAG_FOREIGN:translate("PROJECT.LIST_ITEMS.CANNOT_TAG_BECAUSE_FOREIGN","Shared objects cannot be tagged"),CANNOT_CLEAR_FOREIGN:translate("PROJECT.LIST_ITEMS.CANNOT_CLEAR_BECAUSE_FOREIGN","Shared objects cannot be cleared")};$scope.shareObjectsInWorkspace=(items=$scope.getSelectedTaggableObjectRefs().map(tor=>({reference:tor})))=>{CreateModalFromTemplate("/templates/dialogs/share-in-workspace.html",$scope,undefined,newScope=>{newScope.init(items)})};$scope.addToDataCollection=(items=$scope.getSelectedTaggableObjectRefs())=>{CreateModalFromTemplate("/templates/dialogs/add-to-data-collection.html",$rootScope,undefined,newScope=>{newScope.init(items)})};$scope.resynchronizeMetastore=function(){WT1.event("action-sync-metastore",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});HiveService.resynchronizeMetastore($scope.getSelectedTaggableObjectRefs())};$scope.resynchronizeDataset=function(){WT1.event("action-sync-dataset",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});HiveService.resynchronizeDataset($scope.getSelectedTaggableObjectRefs())};$scope.clearSelected=function(){WT1.event("action-clear",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});ComputablesService.clear($scope,$scope.getSelectedTaggableObjectRefs()).then(onAction("action-clear"))};$scope.buildSelected=function(){WT1.event("action-build",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});$scope.buildSelectedComputables($scope.getSelectedTaggableObjectRefs()).then(onAction("action-build"))};$scope.changeSelectedItemsConnections=function(){WT1.event("action-change-connection",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});DatasetConnectionChangeService.start($scope.getSelectedTaggableObjectRefs()).then(onAction("action-change-connection"))};$scope.updateStatuses=function(){const items=$scope.getSelectedTaggableObjectRefs().filter(it=>it.type=="DATASET");WT1.event("action-update-status",{state:$state.current.name,items:items.length});DatasetsService.refreshSummaries($scope,items).then(onAction("action-update-status")).then(function(result){if(result.anyMessage){Dialogs.infoMessagesDisplayOnly($scope,"Datasets statuses update results",result)}},setErrorInScope.bind($scope))};$scope.startSetAutoCountOfRecords=function(){const items=$scope.getSelectedTaggableObjectRefs().filter(it=>it.type=="DATASET");WT1.event("action-set-auto-count-of-records",{state:$state.current.name,items:items.length});DatasetsService.startSetAutoCountOfRecords(items).then(onAction("action-set-auto-count-of-records"))};$scope.setAutoCountOfRecords=function(autoCountOfRecords){const items=$scope.getSelectedTaggableObjectRefs().filter(it=>it.type=="DATASET");WT1.event("action-set-auto-count-of-records2",{state:$state.current.name,items:items.length});DatasetsService.setAutoCountOfRecords(items,autoCountOfRecords).then(onAction("action-set-auto-count-of-records"))};$scope.setVirtualizable=function(virtualizable){WT1.event("action-set-virtualizable",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});DatasetsService.setVirtualizable($scope,$scope.getSelectedTaggableObjectRefs(),virtualizable).then(onAction("action-set-virtualizable"))};$scope.addSelectedToScenario=function(){WT1.event("action-add-to-scenario",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});CreateModalFromTemplate("/templates/scenarios/add-to-scenario-modal.html",$scope,"AddToScenarioModalController",function(modalScope){}).then(onAction("action-add-to-scenario"))};$scope.exposeSelected=function(){WT1.event("action-share",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});Ng2ObjectsExpositionService.exposeObjects($scope.getSelectedTaggableObjectRefs()).then(onAction("action-share"))};$scope.unshare=function(){WT1.event("action-unshare",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});var items=$scope.getSelectedTaggableObjectRefs();var deletionRequests=items.map(item=>({type:item.type,projectKey:item.projectKey,id:item.id,displayName:item.displayName}));Ng2ObjectsExpositionService.unshare(deletionRequests).then(onAction("action-unshare"))};$scope.isZoneInput=function(){return $scope.selection.selectedObject.usedByZones.length&&$scope.selection.selectedObject.usedByZones[0]!=$scope.selection.selectedObject.ownerZone};$scope.changeSelectedRecipesEngines=function(){WT1.event("action-change-recipes-engines",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});RecipesEnginesService.startChangeEngine($scope.getSelectedTaggableObjectRefs()).then(onAction("action-change-recipes-engines"))};$scope.changeSelectedSparkConfig=function(){WT1.event("action-change-spark-config",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});SparkService.startChangeSparkConfig($scope.getSelectedTaggableObjectRefs()).then(onAction("action-change-spark-config"))};$scope.changeSelectedPipelineability=function(pipelineActionType){WT1.event(pipelineActionType,{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});const pipelineType=pipelineActionType===PIPELINEABILITY_ACTIONS.changeSpark?"SPARK":"SQL";PipelineService.startChangePipelineability($scope.getSelectedTaggableObjectRefs(),pipelineType).then(onAction(pipelineActionType))};$scope.changeSelectedSparkPipelineability=function(){$scope.changeSelectedPipelineability(PIPELINEABILITY_ACTIONS.changeSpark)};$scope.changeSelectedSqlPipelineability=function(){$scope.changeSelectedPipelineability(PIPELINEABILITY_ACTIONS.changeSQL)};$scope.changeSelectedImpalaWriteMode=function(){WT1.event("action-change-impala-write-mode",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});ImpalaService.startChangeWriteMode($scope.getSelectedTaggableObjectRefs()).then(onAction("action-change-impala-write-mode")).then(function(){ToolBridgeService.emitRefreshView("ImpalaWriteModeView")})};$scope.changeSelectedHiveEngine=function(){WT1.event("action-change-hive-engine",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});HiveService.startChangeHiveEngine($scope.getSelectedTaggableObjectRefs()).then(onAction("action-change-hive-engine")).then(function(){ToolBridgeService.emitRefreshView("HiveModeView")})};$scope.convertSelectedToHive=function(){WT1.event("action-convert-to-hive",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});ImpalaService.convertToHive($scope.getSelectedTaggableObjectRefs()).then(onAction("action-convert-to-hive")).then(function(){ToolBridgeService.emitRefreshView("HiveModeView")})};$scope.convertSelectedToImpala=function(){WT1.event("action-convert-to-impala",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});HiveService.convertToImpala($scope.getSelectedTaggableObjectRefs()).then(onAction("action-convert-to-impala")).then(function(){ToolBridgeService.emitRefreshView("ImpalaWriteModeView")})};$scope.changePythonEnvSelection=function(){WT1.event("action-change-python-env",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});CodeEnvsService.startChangeCodeEnv($scope.getSelectedTaggableObjectRefs(),"PYTHON",$scope).then(onAction("action-change-python-env"))};$scope.changeREnvSelection=function(){WT1.event("action-change-r-env",{state:$state.current.name,items:$scope.getSelectedTaggableObjectRefs().length});CodeEnvsService.startChangeCodeEnv($scope.getSelectedTaggableObjectRefs(),"R",$scope).then(onAction("action-change-r-env"))};$scope.computeActionsUsability=function(){const usability={recipes:{python:{ok:true},r:{ok:true},shell:{ok:true},julia:{ok:true}},things:{},selectablePlugins:[]};if($scope.isAllEvaluationStores?.()||$scope.isAllModels?.()){usability.recipes.r.ok=false;usability.recipes.shell.ok=false;usability.recipes.julia.ok=false}function mergeUsability(itemUsability){const rus=usability.recipes;$.each(itemUsability.recipes,function(recipeType,ru){if(!rus[recipeType]){rus[recipeType]=angular.copy({ok:true,details:{enableStatus:"OK"}})}if(!rus[recipeType].ok){return}if(!ru.ok){rus[recipeType].ok=false;rus[recipeType].reason=ru.reason}});const tus=usability.things;$.each(itemUsability.things,function(thing,tu){if(!tus[thing]){tus[thing]=angular.copy({ok:true,details:{enableStatus:"OK"}})}if(!tus[thing].ok){return}if(!tu.ok){tus[thing].ok=false;tus[thing].reason=tu.reason}})}$scope.getSelectedTaggableObjectRefs().forEach(function(item){if(item.type=="DATASET"){const datasetRef={projectKey:item.projectKey,name:item.id,type:item.subType};mergeUsability(GlobalProjectActions.getAllStatusForDataset(datasetRef))}});return usability};$scope.startContinuous=function(item){WT1.event("start-continuous");CreateModalFromTemplate("/templates/continuous-activities/start-continuous-activity-modal.html",$scope,"StartContinuousActivityController",function(newScope){newScope.recipeId=item.name}).then(function(loopParams){DataikuAPI.continuousActivities.start($stateParams.projectKey,item.name,loopParams).success(function(data){onAction("action-build")}).error(setErrorInScope.bind($scope))})};$scope.stopContinuous=function(item){WT1.event("stop-continuous");DataikuAPI.continuousActivities.stop($stateParams.projectKey,item.name).success(function(data){onAction("action-build")}).error(setErrorInScope.bind($scope))};$scope.startAllContinuous=function(objects){WT1.event("start-continuous");CreateModalFromTemplate("/templates/continuous-activities/start-continuous-activity-modal.html",$scope,"StartContinuousActivityController",function(newScope){newScope.recipeId=objects[0].name}).then(function(loopParams){let promises=objects.map(function(object){return DataikuAPI.continuousActivities.start($stateParams.projectKey,object.name,loopParams)});$q.all(promises).then(function(values){onAction("action-build")})})};$scope.stopAllContinuous=function(objects){WT1.event("stop-continuous");let promises=objects.map(function(object){return DataikuAPI.continuousActivities.stop($stateParams.projectKey,object.name)});$q.all(promises).then(function(values){onAction("action-build")})};$scope.refreshAllContinuous=function(objects){DataikuAPI.continuousActivities.getStates($stateParams.projectKey).success(function(data){let states={};data.activities.forEach(function(activity){let beingBuilt=activity.desiredState=="STARTED";let continuousActivityDone=beingBuilt&&((activity.mainLoopState||{}).futureInfo||{}).hasResult;states[activity.recipeId]={beingBuilt:beingBuilt,continuousActivityDone:continuousActivityDone}});var changes=0;objects.forEach(function(o){let continuousActivityDone=(states[o.name]||{}).continuousActivityDone||false;if(o.continuousActivityDone!=continuousActivityDone){o.continuousActivityDone=continuousActivityDone;changes+=1}});if(changes>0){$rootScope.$broadcast("graphRendered")}}).error(setErrorInScope.bind($scope))};$scope.startAllCodeStudios=function(codeStudios){let refreshList=()=>onAction("action-code-studio-state-change")();const stoppedCodeStudios=codeStudios.filter(k=>k.uiState.state!=="RUNNING");if(stoppedCodeStudios.length>0){Promise.all(stoppedCodeStudios.map(async k=>$scope.restart(k.id))).then(refreshList,refreshList)}};$scope.stopAllCodeStudios=function(codeStudios){let refreshList=()=>onAction("action-code-studio-state-change")();const runningCodeStudios=codeStudios.filter(k=>k.uiState.state==="RUNNING");if(runningCodeStudios.length>0){Dialogs.confirmInfoMessages($scope,"Confirm "+runningCodeStudios.length+" Code Studios Shutdown",{},"You will disconnect current users of these Code Studios (if any).",false).then(()=>{Promise.all(runningCodeStudios.map(async k=>$scope.stop(k.id))).then(refreshList,refreshList)})}}});app.directive("contributorsList",function($state){return{templateUrl:"/templates/contributors-list.html",scope:{timeline:"=tl"},link:function(scope){scope.$state=$state}}});app.service("_SummaryHelper",function($stateParams,AI_EXPLANATION_MODAL_MODES,InterestsService,DataikuAPI,CreateModalFromTemplate,Dialogs,WT1,InterestWording,WatchInterestState,translate){const svc=this;this.addEditBehaviour=function($scope,element){$scope.state={currentEditing:null,name:{editing:false,newVal:null,selector:".name-edit-zone"},shortDesc:{editing:false,newVal:null,selector:".shortdesc-edit-zone"},description:{editing:false,newVal:null,selector:".desc-edit-zone"},remarks:{editing:false,newVal:null,selector:".desc-edit-zone"},comment:{editing:false,newVal:null,selector:".desc-edit-zone"},tags:{editing:false,newVal:null},projectStatus:{editing:false,newVal:null},checklistTitle:{editing:null,newVal:null}};function cancelAllEdits(){if($scope.state.checklistTitle.editing){$scope.cancelChecklistTitleEdit()}if($scope.state.currentEditing){$scope.cancelFieldEdit()}if($scope.state.tags.editing){$scope.cancelEditTags()}}$scope.startEditChecklistTitle=function(checklist){cancelAllEdits();checklist.editingTitle=true;$scope.state.checklistTitle.editing=checklist;$scope.state.checklistTitle.newVal=checklist.title;window.setTimeout(function(){$(".checklist-title",element).on("click.editField",function(e){e.stopPropagation()});$("html").on("click.editField",function(event){$scope.$apply(function(){$scope.cancelChecklistTitleEdit()})})},0)};$scope.validateChecklistTitleEdit=function(){$scope.state.checklistTitle.editing.title=$scope.state.checklistTitle.newVal;$scope.cancelChecklistTitleEdit();$scope.$emit("objectSummaryEdited")};$scope.cancelChecklistTitleEdit=function(){$scope.state.checklistTitle.editing.editingTitle=false;$scope.state.checklistTitle.editing=null;$(".checklist-title",element).off("click.editField");$("html").off("click.editField")};$scope.startFieldEdit=function(field,allowed){if(allowed===false)return;cancelAllEdits();const fstate=$scope.state[field];fstate.editing=true;if(fstate.newVal==null){fstate.newVal=$scope.object[field]}$scope.state.currentEditing=field;window.setTimeout(function(){fstate.suppressClick=false;$(fstate.selector,element).on("mousedown.editField",function(e){fstate.suppressClick=true});$("html").on("mouseup.editField",function(event){const filterCMHints=function(node){return node.className=="CodeMirror-hints"};const filterCMModal=function(node){return Array.prototype.indexOf.call(node.classList||[],"codemirror-editor-modal")>=0};const filterBSSelect=function(node){return Array.prototype.indexOf.call(node.classList||[],"bootstrap-select")>=0};const filterObjectSelector=function(node){return Array.prototype.indexOf.call(node.classList||[],"dss-object-selector-popover")>=0};const filterNGDropdownPanel=function(node){return Array.prototype.indexOf.call(node.classList||[],"ng-dropdown-panel")>=0};const path=event.originalEvent&&(event.originalEvent.path||event.originalEvent.composedPath&&event.originalEvent.composedPath());const isEventFromCMHints=path&&path.filter(filterCMHints).length>0;const isEventFromCMModal=path&&path.filter(filterCMModal).length>0;const isEventFromBSSelect=path&&path.filter(filterBSSelect).length>0;const isEventFromObjectSelector=path&&path.filter(filterObjectSelector).length>0;const isEventFromNGDropdownPanel=path&&path.filter(filterNGDropdownPanel).length>0;if(fstate.suppressClick||isEventFromCMHints||isEventFromCMModal||isEventFromBSSelect||isEventFromObjectSelector||isEventFromNGDropdownPanel){fstate.suppressClick=null}else{$scope.$apply(function(){$scope.cancelFieldEdit()})}});$scope.$broadcast("elastic:adjust")},0)};$scope.validateFieldEdit=function($event){if($event){$event.preventDefault()}$scope.object[$scope.state.currentEditing]=$scope.state[$scope.state.currentEditing].newVal;$scope.state[$scope.state.currentEditing].newVal=null;$scope.$emit("objectSummaryEdited",$scope.state.currentEditing);$scope.cancelFieldEdit()};$scope.validateFieldEditNotUndefined=function(){if($scope.state[$scope.state.currentEditing].newVal!=undefined){$scope.validateFieldEdit()}};$scope.cancelFieldEdit=function(){const field=$scope.state.currentEditing;if(field){const fstate=$scope.state[field];fstate.editing=false;fstate.newVal=null;$(fstate.selector,element).off("mousedown.editField");$("html").off("mouseup.editField")}};$scope.startEditTags=function(){cancelAllEdits();if($scope.state.tags.newVal==null){$scope.state.tags.newVal=angular.copy($scope.object.tags)}$scope.state.tags.editing=true};$scope.validateEditTags=function(){$scope.$broadcast("tagFieldAddTag",function(){$scope.object.tags=angular.copy($scope.state.tags.newVal);$scope.state.tags.newVal=null;$scope.state.tags.editing=false;$scope.$emit("objectSummaryEdited")})};$scope.cancelEditTags=function(){$scope.state.tags.newVal=null;$scope.state.tags.editing=false};$scope.addChecklist=function(index){WT1.event("add-checklist",{objectType:$scope.objectType});const nChecklists=$scope.object.checklists.checklists.length;const title=nChecklists?translate("SUMMARY_HELPER.ADD_CHECK_LIST.ITEM_NOT_FIRST.TITLE","Todo list ({{ nChecklists }})",{nChecklists:nChecklists+1}):translate("SUMMARY_HELPER.ADD_CHECK_LIST.ITEM_FIRST.TITLE","Todo list",{nChecklists:nChecklists+1});$scope.object.checklists.checklists.push({id:Math.floor(Math.random()*16777215).toString(16),title:title,items:[],$newlyCreated:true})};$scope.deleteChecklist=function(index){Dialogs.confirmSimple($scope,translate("SUMMARY_HELPER.DELETE_CHECKLIST.CONFIRM_MODAL.TITLE","Delete checklist")).then(function(){$scope.object.checklists.checklists.splice(index,1);$scope.$emit("objectSummaryEdited")})};$scope.$on("checklistEdited",function(){$scope.$emit("objectSummaryEdited")});$scope.editProjectStatus=function(projectStatus){$scope.state.projectStatus.newVal=projectStatus;$scope.validateFieldEdit()};$scope.generateDescriptionForObject=function(){return CreateModalFromTemplate("/static/dataiku/ai-explanations/explanation-modal/explanation-modal.html",$scope,"AIExplanationModalController",function(newScope){newScope.mode=AI_EXPLANATION_MODAL_MODES.GENERATE})}};this.addInterestsManagementBehaviour=function($scope){function getTaggableObjects(){return[{type:$scope.objectType,projectKey:$stateParams.projectKey,id:$scope.getObjectId(),workspaceKey:$stateParams.workspaceKey}]}$scope.toggleWatch=function(event){const currentState=$scope.data.interest.watching;const nextState=currentState===WatchInterestState.values.YES||currentState===WatchInterestState.values.SHALLOW?WatchInterestState.values.ENO:WatchInterestState.values.YES;$scope.watchObject(nextState,event)};$scope.watchObject=function(watch,event){return InterestsService.watch($scope,getTaggableObjects(),watch).success(function(){InterestsService.getInterest($scope,$scope.$root.appConfig.user,$scope.objectType,$stateParams.projectKey,$scope.getObjectId(),$stateParams.workspaceKey).success(function(newInterest){if($scope.objectInterest){$scope.objectInterest.nbWatching=newInterest.nbWatching;$scope.objectInterest.watching=newInterest.watching}if($scope.data?.interest){$scope.data.interest.watching=newInterest.watching;$scope.data.interest.nbWatching=newInterest.nbWatching}if(event)$scope.refreshTooltip(event)})})};$scope.starObject=function(star,event){return InterestsService.star($scope,getTaggableObjects(),star).success(function(){InterestsService.getInterest($scope,$scope.$root.appConfig.user,$scope.objectType,$stateParams.projectKey,$scope.getObjectId(),$stateParams.workspaceKey).success(function(newInterest){if($scope.objectInterest){$scope.objectInterest.nbStarred=newInterest.nbStarred;$scope.objectInterest.starred=newInterest.starred}if($scope.data?.interest){$scope.data.interest.starred=newInterest.starred;$scope.data.interest.nbStarred=newInterest.nbStarred}if(event)$scope.refreshTooltip(event)})})};$scope.isWatching=WatchInterestState.isWatching;$scope.actionLabels={...InterestWording.labels};$scope.showWatchingUsers=function(){WT1.event("list-interested-users",{type:"watches"});DataikuAPI.interests.listWatchingUsers($scope.objectType,$stateParams.projectKey,$scope.getObjectId(),$stateParams.workspaceKey).success(function(users){const modalScope=$scope.$new();modalScope.usersList=users;modalScope.icon="icon-eye-open";modalScope.title=users.length+(users.length>1?" users are ":" user is ")+"watching this object";CreateModalFromTemplate("/templates/interested-users.html",modalScope)}).error(setErrorInScope.bind($scope))};$scope.showUsersWithStar=function(){WT1.event("list-interested-users",{type:"stars"});DataikuAPI.interests.listUsersWithStar($scope.objectType,$stateParams.projectKey,$scope.getObjectId(),$stateParams.workspaceKey).success(function(users){const modalScope=$scope.$new();modalScope.usersList=users;modalScope.icon="icon-star";modalScope.title=users.length+" user"+(users.length>1?"s":"")+" starred this object";CreateModalFromTemplate("/templates/interested-users.html",modalScope)}).error(setErrorInScope.bind($scope))};$scope.refreshTooltip=function(event){const el=angular.element(event.currentTarget);el.tooltip("hide").attr("data-original-title",el.attr("title")).tooltip("show")}}});app.directive("editableSummary",function(DatasetsService,DataikuAPI,$stateParams,$rootScope,TopNav,Dialogs,_SummaryHelper){return{templateUrl:"/templates/editable-summary.html",scope:{object:"=",objectType:"@",getTags:"=",insightMode:"=",nameEditable:"=?",saveCallback:"=",editable:"=?",objectInterest:"=?",tagColor:"="},link:function($scope,element,attrs){$scope.appConfig=$rootScope.appConfig;if($scope.nameEditable==undefined)$scope.nameEditable=true;$scope.getObjectId=function(){if($scope.objectType=="PROJECT"){return $stateParams.projectKey}else if($scope.object){if($scope.objectType==="DATASET"||$scope.objectType==="DATASET_CONTENT"||$scope.objectType==="RECIPE"){return $scope.object.name}else{return $scope.object.id}}return null};$scope.typeBadgeList=$scope.object.typeBadges?Object.keys($scope.object.typeBadges):[];_SummaryHelper.addEditBehaviour($scope,element);_SummaryHelper.addInterestsManagementBehaviour($scope);$scope.image={};$scope.pattern=attrs["pattern"];$scope.$watch("object",function(nv,ov){if(!nv)return;if($scope.objectType=="PROJECT"||$scope.objectType=="INSIGHT"){$scope.display_image=true;$scope.totem={projectKey:$stateParams.projectKey,objectType:$scope.objectType,id:$scope.getObjectId()}}else{$scope.display_image=false}});$scope.saveCustomFields=function(customFields){$scope.$emit("customFieldsSummaryEdited",customFields)};const customFieldsSavedUnsubscribe=$rootScope.$on("customFieldsSaved",function(event,item,newCustomFields){if(TopNav.sameItem(TopNav.getItem(),item)){$scope.object.customFields=newCustomFields}});$scope.$on("$destroy",customFieldsSavedUnsubscribe)}}});app.directive("editableProjectSummary",function($rootScope,$stateParams,AI_EXPLANATION_MODAL_MODES,AIExplanationService,TopNav,_SummaryHelper){return{scope:false,link:function($scope,element,attrs){$scope.getObjectId=function(){return $scope.object&&$scope.object.projectKey};_SummaryHelper.addEditBehaviour($scope,element);_SummaryHelper.addInterestsManagementBehaviour($scope);$scope.$stateParams=$stateParams;$scope.currentBranch="master";$scope.$watch("projectSummary",function(nv){$scope.object=nv;$scope.objectType="PROJECT"});$scope.$watch("projectCurrentBranch",function(nv){$scope.currentBranch=nv?nv:"master"});$scope.saveCustomFields=function(customFields){$scope.$emit("customFieldsSummaryEdited",customFields)};const customFieldsSavedUnsubscribe=$rootScope.$on("customFieldsSaved",function(event,item,newCustomFields){if(TopNav.sameItem(TopNav.getItem(),item)){$scope.object.customFields=newCustomFields}});$scope.$on("$destroy",customFieldsSavedUnsubscribe);$scope.generateDescription=function(){$scope.generateDescriptionForObject().then(function(description){$scope.object.description=description;$scope.$emit("objectSummaryEdited")})}}}});app.controller("CustomFieldsEditModalController",function($scope,$rootScope,PluginConfigUtils){let customFieldsMapFlattenList=[];$scope.uiState={cfComponentIdx:0};function populateCustomFields(){$scope.uiState.customFields=angular.copy($scope.objectCustomFields);PluginConfigUtils.setDefaultValues(customFieldsMapFlattenList,$scope.uiState.customFields);$scope.uiState.cfComponentIdx=$scope.editingTabIndex===undefined||$scope.editingTabIndex===null?0:$scope.editingTabIndex}$scope.$watch("objectType",function(){if($scope.objectType){$scope.customFieldsMap=$rootScope.appConfig.customFieldsMap[$scope.objectType];customFieldsMapFlattenList=[];$scope.customFieldsMap.forEach(ref=>customFieldsMapFlattenList=customFieldsMapFlattenList.concat(ref.customFields));if($scope.objectCustomFields){populateCustomFields()}}});$scope.$watch("objectCustomFields",populateCustomFields);$scope.save=function(){$scope.resolveModal($scope.uiState.customFields)};populateCustomFields()});app.directive("customFieldsPopup",function(){return{templateUrl:"/templates/taggable-objects/custom-fields-popup.html",scope:{customFields:"=",customFieldsMap:"="}}});app.directive("customFieldsEditForm",function($rootScope){return{templateUrl:"/templates/taggable-objects/custom-fields-edit-form.html",scope:{customFields:"=",objectType:"=",componentIndex:"="},link:function($scope,element,attrs){$scope.$watch("componentIndex",function(){if($scope.componentIndex>=0){$scope.customFieldsMap=[$rootScope.appConfig.customFieldsMap[$scope.objectType][$scope.componentIndex]]}else{$scope.customFieldsMap=$rootScope.appConfig.customFieldsMap[$scope.objectType]}})}}});app.directive("customFieldsInSummary",function($rootScope,Logger,PluginConfigUtils){return{templateUrl:"/templates/taggable-objects/custom-fields-summary.html",scope:{customFields:"=",objectType:"=",saveFn:"="},link:function($scope,element,attrs){$scope.customFieldsMap=$rootScope.appConfig.customFieldsMap[$scope.objectType];let customFieldsMapFlattenList=[];$scope.customFieldsMap.forEach(ref=>customFieldsMapFlattenList=customFieldsMapFlattenList.concat(ref.customFields));$scope.ui={customFields:angular.copy($scope.customFields),editing:false};PluginConfigUtils.setDefaultValues(customFieldsMapFlattenList,$scope.ui.customFields);$scope.editCF=function(){if(!$scope.saveFn){Logger.warn("There is no save function attached to the custom fields editable summary");$scope.ui.editing=false}else{$scope.ui.editing=true}};$scope.discardCF=function(){if(!$scope.saveFn){Logger.warn("There is no save function attached to the custom fields editable summary");$scope.ui.editing=false}else{$scope.ui.customFields=angular.copy($scope.customFields);PluginConfigUtils.setDefaultValues(customFieldsMapFlattenList,$scope.ui.customFields);$scope.ui.editing=false}};$scope.saveCF=function(){if(!$scope.saveFn){Logger.warn("There is no save function attached to the custom fields editable summary");$scope.ui.editing=false}else{$scope.saveFn(angular.copy($scope.ui.customFields));$scope.ui.editing=false}};$scope.$watch("customFields",function(){$scope.ui.customFields=angular.copy($scope.customFields);PluginConfigUtils.setDefaultValues(customFieldsMapFlattenList,$scope.ui.customFields)})}}});app.directive("customFieldsInSidePanel",function($rootScope,Logger,PluginConfigUtils,TopNav){return{templateUrl:"/templates/taggable-objects/custom-fields-sidepanel.html",scope:{customFields:"=",objectType:"=",saveFn:"=",editCustomFields:"=",editable:"=",rightPanelTabName:"="},link:function($scope,element,attrs){$scope.customFieldsMap=$rootScope.appConfig.customFieldsMap[$scope.objectType];let customFieldsMapFlattenList=[];$scope.customFieldsMap.forEach(ref=>customFieldsMapFlattenList=customFieldsMapFlattenList.concat(ref.customFields));$scope.ui={customFields:angular.copy($scope.customFields)};PluginConfigUtils.setDefaultValues(customFieldsMapFlattenList,$scope.ui.customFields);$scope.canWriteProject=()=>$scope.editable;$scope.editCF=function(){if(!$scope.saveFn){Logger.warn("There is no save function attached to the custom fields editable summary")}};$scope.discardCF=function(){if(!$scope.saveFn){Logger.warn("There is no save function attached to the custom fields editable summary")}else{$scope.ui.customFields=angular.copy($scope.customFields);PluginConfigUtils.setDefaultValues(customFieldsMapFlattenList,$scope.ui.customFields)}};$scope.saveCF=function(){if(!$scope.saveFn){Logger.warn("There is no save function attached to the custom fields editable summary")}else{$scope.saveFn(angular.copy($scope.ui.customFields))}};$scope.tabLabelFilterFn=function(value,index,array){return $scope.rightPanelTabName===undefined||value&&value.rightPanelTabName===$scope.rightPanelTabName};$scope.$watch("customFields",function(){$scope.ui.customFields=angular.copy($scope.customFields);PluginConfigUtils.setDefaultValues(customFieldsMapFlattenList,$scope.ui.customFields)});const customFieldsSavedUnsubscribe=$rootScope.$on("customFieldsSaved",function(event,item,newCustomFields){if(TopNav.sameItem(TopNav.getItem(),item)){$scope.ui.customFields=newCustomFields}});$scope.$on("$destroy",customFieldsSavedUnsubscribe)}}})})();(function(){"use strict";const app=angular.module("dataiku.taggableobjects");app.service("TaggingService",function($rootScope,$stateParams,$timeout,$q,DataikuAPI,CreateModalFromTemplate,TaggableObjectsUtils){const svc=this;let projectTags={};let projectTagsList=undefined;let projectTagsUsageMap=undefined;let globalTagsCategories=undefined;let globalTags={};var setList=function(tagsObj){projectTagsList=[];Object.keys(tagsObj).forEach(function(tagTitle,index){projectTagsList.push({title:tagTitle,color:tagsObj[tagTitle].color})});return svc.sortTagList(projectTagsList)};this.getTagWithUsage=function(tag,items){tag.usage=0;items.forEach(i=>{if(i.tags&&i.tags.indexOf(tag.title)>=0)tag.usage++});tag.initialState=tag.newState=tag.usage==0?0:tag.usage==items.length?2:1;return tag};this.sortTagList=function(list){return list.sort((a,b)=>a.title.localeCompare(b.title))};this.getGlobalTags=function(objectType){if(!objectType||objectType==="TAGGABLE_OBJECT"){return globalTags}const globalTagsForType={};Object.keys(globalTags).forEach(key=>{if(svc.shouldGlobalTagApply(globalTags[key].appliesTo,objectType)){globalTagsForType[key]=globalTags[key]}});return globalTagsForType};const fetchGlobalTagsDeferred=$q.defer();this.fetchGlobalTags=function(forceFetch){if(globalTagsCategories&&!forceFetch){return fetchGlobalTagsDeferred.promise}globalTagsCategories=globalTagsCategories||{};DataikuAPI.globalTags.getGlobalTagsInfo().success(function(data){Object.keys(data.globalTags).forEach(function(k){let category=data.globalTags[k].globalTagsCategory;Object.assign(data.globalTags[k],{appliesTo:data.globalTagsCategories[category]})});globalTagsCategories=data.globalTagsCategories;globalTags=data.globalTags;fetchGlobalTagsDeferred.resolve()}).error(setErrorInScope.bind($rootScope));return fetchGlobalTagsDeferred.promise};this.setProjectTags=function(tags){projectTags=fillTagsMap(tags);projectTagsList=undefined};this.getProjectTags=function(){return projectTags};this.getProjectTagsList=function(objectType){if(projectTagsList==undefined)setList(Object.assign(this.getProjectTags(),globalTags));return projectTagsList};this.getProjectTagsUsageMap=function(){const deferred=$q.defer();DataikuAPI.taggableObjects.listTagsUsage($stateParams.projectKey,{},"nospinner").success(function(data){projectTagsUsageMap=data;deferred.resolve(projectTagsUsageMap)});return deferred.promise};this.startApplyTagging=function(selectedItems){return CreateModalFromTemplate("/templates/apply-tags-modal.html",$rootScope,"ApplyTaggingController",function(modalScope){modalScope.selectedItems=selectedItems;modalScope.itemsType=TaggableObjectsUtils.getCommonType(selectedItems,it=>it.type);modalScope.tagsSorted=svc.getTagsSorted([{...projectTags,...globalTags}],t=>svc.getTagWithUsage(t,selectedItems),modalScope.itemsType)})};this.applyTagging=function(request){return DataikuAPI.taggableObjects.applyTagging($stateParams.projectKey,request).success(function(){$rootScope.$broadcast("taggableObjectTagsChanged")}).error(setErrorInScope.bind($rootScope))};this.getTagColor=function(tag){return globalTags[tag]?globalTags[tag].color:projectTags[tag]?projectTags[tag].color:svc.getDefaultColor(tag)};this.getGlobalTagCategory=function(tag,objectType){if(globalTags[tag]){let category=globalTags[tag].globalTagsCategory;if(objectType=="TAGGABLE_OBJECT"||svc.shouldGlobalTagApply(globalTagsCategories[category],objectType)){return category}return false}return null};var pushTagsToList=function(tags,list){Object.keys(tags).forEach(function(tagTitle,index){const t=tags[tagTitle];const titleLower=tagTitle.toLowerCase();list.push({tag:t,title:tagTitle,titleLower:titleLower})})};this.shouldGlobalTagApply=function(appliesTo,objectType){return objectType==="TAGGABLE_OBJECT"||appliesTo.includes(objectType)};this.getTagsSorted=function(tagLists,fTagMapper,itemsType){const list=[];tagLists.forEach(l=>pushTagsToList(l,list));const titleLookup={};const filteredList=list.filter(it=>!it.tag.appliesTo||!itemsType||itemsType&&svc.shouldGlobalTagApply(it.tag.appliesTo,itemsType));let sortedList=filteredList.sort((a,b)=>!!a.tag.globalTagsCategory-!!b.tag.globalTagsCategory||a.title.localeCompare(b.title));sortedList.forEach((item,index)=>{titleLookup[item.titleLower]=index});if(fTagMapper)sortedList=sortedList.map(fTagMapper);return{list:sortedList,titleLookup:titleLookup}};this.applyManageTagsChangesToTagList=function(tagsList,newAllTags,keepOrphans){const newTags=[];tagsList.forEach(tag=>{if(newAllTags[tag]){if(newAllTags[tag].updatedTagName){newTags.push(newAllTags[tag].updatedTagName)}else{newTags.push(tag)}}else if(keepOrphans){newTags.push(tag)}});return newTags};const COLORS=["#1ac2ab","#0f6d82","#FFD83D","#de1ea5","#90a8b7","#28aadd","#00a55a","#94be8e","#d66b9b","#77bec2","#123883","#a088bd"];this.getDefaultColor=function(tag){const hash=tag.split("").reduce(function(a,b){a=(a<<5)-a+b.charCodeAt(0);return a&a},0);return COLORS[Math.abs(hash)%12]};function fillTagsMap(tags){for(let tag in tags){if(globalTags[tag]){tags[tag]=globalTags[tag]}if(!tags[tag].color){tags[tag].color=svc.getDefaultColor(tag)}const col=d3.rgb(tags[tag].color);tags[tag].fadedColor="rgba("+col.r+","+col.g+","+col.b+", 0.35)"}return tags}this.fillTagsMapFromArray=function(a){const tagMap={};a.map(tag=>tagMap[tag]={});return fillTagsMap(tagMap)};function argsForUpdateBcast(refreshFlowFilters,checkFilterQuery,updateGraphTags){const args={};args.refreshFlowFilters=refreshFlowFilters;args.checkFilterQuery=checkFilterQuery;args.updateGraphTags=updateGraphTags;return args}this.bcastTagUpdate=function(minReloadReqd,updateGraphTags){$rootScope.$broadcast("projectTagsUpdated",argsForUpdateBcast(!minReloadReqd,minReloadReqd,updateGraphTags))};this.update=function(minReloadReqd){return DataikuAPI.taggableObjects.listTags($stateParams.projectKey).success(function(response){svc.setProjectTags(response.tags);svc.bcastTagUpdate(minReloadReqd,false)})};this.saveToBackend=function(newTags){return DataikuAPI.taggableObjects.setTags($stateParams.projectKey,newTags).then(function(response){svc.setProjectTags(response.data.tags)})}});app.filter("tagToColor",function(TaggingService){return function(tag){return TaggingService.getTagColor(tag)}});const TRISTATES={OFF:0,PART:1,ON:2,ROTATE:3};app.controller("ApplyTaggingController",function($scope,WT1,TaggingService,translate,CreateModalFromTemplate,$timeout){var pushOperation=function(operations,allTags,mode){const reqdState=mode=="ADD"?TRISTATES.ON:TRISTATES.OFF;const tags=allTags.filter(t=>t.newState!=t.initialState&&t.newState==reqdState).map(t=>t.title);if(tags.length>0){WT1.event("tagging-apply",{tags:tags.length,elements:$scope.selectedItems.length,add:mode=="ADD"});operations.push({tags:tags,mode:mode})}};$scope.uiState={newTag:""};$scope.translate=translate;$scope.doSave;$scope.applyTagging=request=>{return TaggingService.applyTagging(request).then($scope.resolveModal).catch(setErrorInScope.bind($scope))};$scope.showManageTagsInProjectSettingsMessage=true;$scope.save=function(){const request={elements:$scope.selectedItems,operations:[]};["ADD","REMOVE"].forEach(mode=>pushOperation(request.operations,$scope.tagsSorted.list,mode));if(request.operations.length>0){$scope.applyTagging(request)}else{$scope.resolveModal()}};$scope.isChanged=function(tag){return tag.initialState!=tag.newState};$scope.createTagOnEnter=function(event){if(event.which===13){$scope.onAddTag()}};$scope.usageText=function(tag){switch(tag.newState){case TRISTATES.OFF:return"-";case TRISTATES.PART:return tag.usage+"/"+$scope.selectedItems.length;case TRISTATES.ON:return $scope.selectedItems.length+"/"+$scope.selectedItems.length;default:break}};$scope.hasTags=function(){return $scope.tagsSorted.filteredList.length>0};const addNewTagToList=function(title,newState,color){$scope.tagsSorted.list.push({title:title,tag:{color:color?color:TaggingService.getDefaultColor(title)},initialState:TRISTATES.OFF,newState:newState});$scope.tagsSorted.titleLookup[title.toLowerCase()]="new"};const isNewlyAdded=function(title){return $scope.tagsSorted.titleLookup[title.toLowerCase()]=="new"};$scope.onAddTag=function(){if($scope.canCreateTag()){addNewTagToList($scope.uiState.newTag,TRISTATES.ON);TaggingService.sortTagList($scope.tagsSorted.list);$scope.uiState.newTag=""}};function filterTagListByInput(input=$scope.uiState.newTag){if(!input)return $scope.tagsSorted.list;return $scope.tagsSorted.list.filter(tag=>tag.title.toLowerCase().startsWith(input.toLowerCase()))}$scope.$watch("uiState.newTag",nv=>{TaggingService.sortTagList($scope.tagsSorted.list);$scope.tagsSorted.filteredList=filterTagListByInput(nv)});$scope.canCreateTag=function(){const titleLower=$scope.uiState.newTag.toLowerCase();return titleLower&&!$scope.tagsSorted.titleLookup.hasOwnProperty(titleLower)};$scope.rotateCheckbox=function(item){item.newState=TRISTATES.ROTATE}});app.directive("checkboxTristate",function(){return{template:`<input type="checkbox" name="{{id}}" id="{{id}}" ng-click="rotate()" aria-label="{{alabel}}" > `,scope:{triState:"=ngModel",initialState:"=",id:"=",alabel:"="},link:function(scope,$element){const chkbx=$element.children()[0];scope.onSet=function(newState){scope.triState=newState;switch(newState){case TRISTATES.PART:{chkbx.checked=false;chkbx.indeterminate=true;break}default:{chkbx.checked=!!newState;chkbx.indeterminate=false;break}}};var incrementValue=function(v){let newState=(v+1)%3;if(newState==TRISTATES.PART&&scope.initialState!=TRISTATES.PART)newState=TRISTATES.ON;return newState};scope.rotate=function(event){const newState=incrementValue(scope.triState);scope.onSet(newState)};scope.$watch("triState",function(nv,ov){if(nv==TRISTATES.ROTATE){nv=incrementValue(ov)}scope.onSet(nv)});scope.onSet(scope.triState)}}});app.directive("addTagInput",function(){return{template:`<form class="common-styles-only tag-form noflex horizontal-flex" >
                        <input class="flex" type="text"
                        ng-model="newTag"
                        ng-class="{'has-error': !validator()}"
                        placeholder="Create new tag"
                        ng-keydown="onAddKeydown($event)"
                        aria-label="Create new tag" />

                    <button type="button"
                        class="btn btn--primary tags-settings-btn noflex"
                        ng-disabled="uiState.newTag.length == 0 || !validator()"
                        ng-click="addTag($event)">Add</button>
                </form>`,scope:{newTag:"=ngModel",validator:"&",onAddTag:"&"},link:function(scope,$element){function eatEvent(e){e.stopPropagation();e.preventDefault()}scope.onAddKeydown=function(e){if(e.keyCode==13){scope.onAddTag();eatEvent(e)}};scope.addTag=function(e){if(scope.validator())scope.onAddTag();eatEvent(e)}}}});app.directive("tagsList",function(translate,Assert,CreateModalFromTemplate,TaggingService){return{template:`<div class="tagsList">
            <ul class="tags vertical-flex">
                <li ng-repeat="tag in tags">
                    <span ng-if="isTagSelected(tag)" class="tag selected" ng-click="addTag(tag)" style="color:white; background-color:#{{tag.color.substring(1)}}" >
                        <span class="bullet" style="background-color:white;"> </span>
                        <span ui-global-tag="tag.title" object-type="objectType"/>
                    </span>
                    <span ng-if="!isTagSelected(tag)" class="tag" ng-click="addTag(tag)">
                        <span class="bullet" style="background-color:{{tag.color}};"> </span>
                        <span ui-global-tag="tag.title" object-type="objectType"/>
                    </span>
                </li>
                <li ng-if="noTagAvailable()">
                    <span class="tag disabled" translate="GLOBAL.TAGS.NO_TAGS_AVAILABLE">No tags available</span>
                </li>
            </ul>
            <button class="btn btn--contained btn--tag-list" ng-click="manageTags()" ng-if="$parent.canWriteProject()" translate="GLOBAL.TAGS.MANAGE_TAGS">Manage tags</button>
        </div>`,scope:{selected:"=tagsListSelected",objectType:"="},link:function(scope,element){scope.tags=TaggingService.getProjectTagsList(scope.objectType);Assert.trueish(scope.tags,"no tags list");scope.noTagAvailable=function(){return scope.tags.length==0};scope.$on("projectTagsUpdated",()=>{scope.tags=TaggingService.getProjectTagsList(scope.objectType)});scope.isTagSelected=function(tag){return scope.selected.indexOf(tag.title)>-1};scope.manageTags=function(){CreateModalFromTemplate("/templates/widgets/edit-tags-modal.html",scope,null,function(modalScope){modalScope.translate=translate;modalScope.tagsDirty=angular.copy(TaggingService.getProjectTags());modalScope.save=function(){scope.selected=TaggingService.applyManageTagsChangesToTagList(scope.selected,modalScope.tagsDirty);TaggingService.saveToBackend(modalScope.tagsDirty).then(modalScope.resolveModal).catch(setErrorInScope.bind(scope))};modalScope.cancel=function(){modalScope.dismiss()}})};scope.addTag=function(tag){scope.$emit("tagSelectedInList",tag.title)}}}});app.directive("tagsListEditor",function($timeout,TaggingService,translate){return{scope:{tags:"=tagsListEditor"},replace:true,template:`<div class="tags-settings vertical-flex h100" style="position:relative" >
        <div class="tag-edit-filter" ng-class="{'tag-edit-filter--focus': filterFocused}">
            <i class="icon-dku-search"></i>
            <input ng-model="uiState.newTag" name="tagEditorInput" type="search" ng-keydown="createTagOnEnter($event)" auto-focus="true" tabindex="0"
                ng-focus="filterFocused = true" ng-blur="filterFocused = false" autocomplete="off"
                placeholder="{{::translate('GLOBAL.TAGS.FILTER_OR_CREATE_TAGS', 'Filter tags or create a new tag')}}" class="tag-edit-filter__input" aria-label="Selected tags"/>
        </div>
        <div ng-if="hasTag()" class="tag-help-text">
            <span class="tag-help-text__name" translate="GLOBAL.TAGS.TAG_NAME">Tag name</span>
            <span ng-if="totalObjects > 0" class="tag-help-text__usage" translate="GLOBAL.TAGS.TAG_USAGE">Tag usage</span>
        </div>
        <div class="tags">
            <editable-list ng-if="hasTag()" ng-model="tagsSorted.list" class="tags" disable-create-on-enter="true" skip-to-next-focusable="true"
                transcope="{ uiState: uiState, canRenameTag: canRenameTag, updateTag: updateTag, onRemoveTag: onRemoveTag, onRestoreTag: onRestoreTag}"
                disable-remove="true" disable-add="true" full-width-list="true" has-divider="false">

                <div class="tag-row tag-row--editable-list horizontal-flex"
                    scroll-to-me="{{uiState.scrollToTagIdx==$index}}">

                    <div class="tag-row-item flex horizontal-flex">
                        <span class="tag-color noflex" style="background-color:{{it.tag.color}};" colorpicker colorpicker-with-input="true" ng-model="it.tag.color" aria-role="button" aria-label="Tag color">
                            <i class="icon-tint"></i>
                        </span>
                        <span ng-if="!it.tag.globalTagsCategory" class="tag-edit flex common-styles-only horizontal-flex">
                            <editable-list-input type="text" class="tag-input flex" ng-init="it.updatedTagName = it.tag.updatedTagName || it.title" ng-model="it.updatedTagName" on-key-up-callback="updateTag(it)" aria-label="Tag name" required="true" unique="true"/>
                        </span>
                        <span ng-if="it.tag.globalTagsCategory" class="tag-title flex">
                            <span ui-global-tag="it.tag.updatedTagName || it.title" object-type="'TAGGABLE_OBJECT'"></span>
                        </span>
                        <span ng-show="$parent.$parent.totalObjects > 0" class="tag-usage noflex">{{$parent.$parent.tagsUsage[it.title] || '-'}}</span>
                    </div>
                    <button ng-if="!it.tag.globalTagsCategory" class="noflex btn btn--text btn--danger btn--dku-icon btn--icon editable-list__delete m0" ng-click="onRemoveTag($event, it.title)"><i class="dku-icon-trash-16"></i></button>
                    <div ng-if="it.tag.globalTagsCategory" class="editable-list__icon">
                        <i class="noflex dku-icon-info-circle-fill-16" aria-role="button" aria-label="Restore tag: {{it.title}}"></i>
                    </div>
                </div>
            </editable-list>
            <div ng-if="canCreateTag()" class="tags">
                <div ng-if="canCreateTag()" class="tag-row horizontal-flex tags-settings__create" ng-click="onAddNewTag(e)" ng-keyup="$event.keyCode == 13 && onAddNewTag(e)" tabindex="0">
                    <i class="icon-plus flex-no-grow"></i>
                    <span class="flex" translate="GLOBAL.TAGS.CREATE_TAG" translate-values="{name:uiState.newTag}">Create &laquo;{{uiState.newTag}}&raquo;</span>
                    <code class="dku-tiny-text-sb text-weak tags-settings__create-shortcut" translate="GLOBAL.TAGS.CREATE_TAG.ENTER">Enter</code>
                    <span class="return flex-no-grow tags-settings-btn mright4">&crarr;</span>
                </div>
            </div>
        </div>
        <div ng-if="!hasTag() && !canCreateTag()" class="noflex no-tag-yet"><p translate="GLOBAL.TAGS.NO_TAGS_AVAILABLE">No tags available</p></div>

    </div>`,link:function(scope,element,attrs){scope.uiState={originalTagName:"",updatedTagName:"",editTagIdx:undefined,newTag:"",scrollToTagIdx:undefined};scope.totalObjects=0;scope.translate=translate;var ui=scope.uiState;var eatEvent=function(e){if(e){e.stopPropagation();e.preventDefault()}};scope.updateTag=function(item){if(item.title===item.updatedTagName&&!item.isEdited){return}ui.originalTagName=item.title;ui.updatedTagName=item.updatedTagName||"";const tag=scope.tags[ui.originalTagName];tag.updatedTagName=ui.updatedTagName;tag.isEdited=true};scope.createTagOnEnter=function(event){if(event.which===13){scope.onAddNewTag(event)}};scope.$watch("uiState.newTag",updateSortedTags);function filterTagsByInput(input){const allTags=Object.assign({},scope.tags,scope.globalTags);if(!input){return allTags}const filteredTags={};if(allTags){Object.keys(allTags).forEach(tagTitle=>{const lowerTitle=tagTitle.toLowerCase();if(lowerTitle.startsWith(input)){filteredTags[tagTitle]=allTags[tagTitle]}})}return filteredTags}function updateSortedTags(){const input=ui.newTag.toLowerCase();const filteredTags=filterTagsByInput(input);scope.tagsSorted=TaggingService.getTagsSorted([filteredTags])}var calcTagUsageForCurrentProject=function(){scope.tagsUsage={};TaggingService.getProjectTagsUsageMap().then(usageMap=>{const tagsUsage={};scope.totalObjects=0;Object.keys(usageMap).forEach(objName=>{scope.totalObjects++;const tags=usageMap[objName];tags.forEach(tagName=>{if(!tagsUsage[tagName])tagsUsage[tagName]=0;tagsUsage[tagName]++})});Object.keys(scope.tags).forEach(function(t){if(isNaN(tagsUsage[t]))tagsUsage[t]=0});scope.tagsUsage=angular.copy(tagsUsage)})};scope.$watch("tags",function(nv,ov){if(!angular.equals(nv,ov)){getGlobalTags();updateSortedTags();calcTagUsageForCurrentProject()}});function getGlobalTags(){scope.globalTags=TaggingService.getGlobalTags();scope.$parent.hasGlobalTags=Object.keys(scope.globalTags).length>0}getGlobalTags();scope.onAddNewTag=function(e){if(scope.canCreateTag()){scope.tags[ui.newTag]={color:TaggingService.getDefaultColor(ui.newTag),usage:0,isNew:true};updateSortedTags();ui.scrollToTagIdx=scope.tagsSorted.titleLookup[ui.newTag.toLowerCase()];ui.newTag=""}updateSortedTags();eatEvent(e)};scope.canCreateTag=function(){const titleLower=ui.newTag.toLowerCase();return titleLower&&!scope.tagsSorted.titleLookup.hasOwnProperty(titleLower)};scope.onRemoveTag=function(e,tag){ui.updatedTagName="";delete scope.tags[tag];updateSortedTags();eatEvent(e)};scope.canRenameTag=function(){const toLower=ui.updatedTagName.toLowerCase();if(ui.originalTagName.toLowerCase()==toLower)return true;return toLower&&!scope.tagsSorted.titleLookup.hasOwnProperty(toLower)};scope.hasTag=function(){return!$.isEmptyObject(scope.tags)||!$.isEmptyObject(scope.globalTags)};updateSortedTags();calcTagUsageForCurrentProject();element.find(".tag-edit-filter__input").focus()}}})})();(function(){"use strict";const app=angular.module("dataiku.collab.timeline",[]);app.directive("objectTimelineWithPost",function(DataikuAPI){return{templateUrl:"/templates/widgets/object-timeline-with-post.html",restrict:"A",scope:{objectType:"=",projectKey:"=",objectId:"=",initialTimeline:"=",initialFetch:"@",fetchTimelinePromiseFn:"=?"},link:function($scope){$scope.refreshTimeline=function(){if($scope.fetchTimelinePromiseFn){$scope.fetchTimelinePromiseFn().success(function(data){$scope.timeline=data}).error(setErrorInScope.bind($scope))}else{DataikuAPI.timelines.getForObject($scope.projectKey,$scope.objectType,$scope.objectId).success(function(data){$scope.timeline=data}).error(setErrorInScope.bind($scope))}};$scope.$watch("initialTimeline",function(nv,ov){if(nv)$scope.timeline=$scope.initialTimeline});$scope.$watch("objectId",(nv,ov)=>{if(nv===ov)return;$scope.refreshTimeline()});if($scope.initialFetch&&$scope.objectId){$scope.refreshTimeline()}}}});app.service("TimelineItemUtils",function($state){const svc=this;this.isAboutTags=function(evt){return evt.details.addedTags||evt.details.removedTags};this.isAboutTasks=function(evt){return evt.details.totalTasks!=null};this.isAboutDescriptions=function(evt){return evt.details.descriptionEdited||evt.details.shortDescEdited};this.isAboutTagsOnly=function(evt){return svc.isAboutTags(evt)&&!svc.isAboutTasks(evt)&&!svc.isAboutDescriptions(evt)};this.isAboutTasksOnly=function(evt){return!svc.isAboutTags(evt)&&svc.isAboutTasks(evt)&&!svc.isAboutDescriptions(evt)};this.isMoreComplex=function(evt){return!svc.isAboutTasksOnly(evt)&&!svc.isAboutTagsOnly(evt)};this.goToProjectRevisionPage=function(evt){$state.go("projects.project.version-control",{commitId:evt.details.revision,branch:evt.details.branchName})};this.goToMergeRequest=function(evt){$state.go("projects.project.version-control-merge",{mergeRequestId:evt.details.request_id})}});app.directive("timeline",function($filter,$state){return{templateUrl:"/templates/timeline.html",scope:{timeline:"=timeline",context:"@",reverse:"@",hook:"="},link:function(scope,element){function humanReadableObjectType(objectType){if(!objectType)return;switch(objectType){case"MANAGED_FOLDER":return"folder";case"SAVED_MODEL":return"model";case"MODEL_EVALUATION_STORE":return"evaluation store";case"LAMBDA_SERVICE":return"API service";default:return objectType.toLowerCase().replace("_"," ")}}let maxItems=15;function update(){if(!scope.timeline){return}angular.forEach(scope.timeline.items,function(item){item.day=$filter("friendlyDate")(item.time);item.humanReadableObjectType=scope.hook&&scope.hook.humanReadableObjectType?scope.hook.humanReadableObjectType(humanReadableObjectType)(item.objectType):humanReadableObjectType(item.objectType);item.details=item.details||{};item.details.objectDisplayName=item.details.objectDisplayName||item.objectId});const displayedItems=scope.timeline.items?scope.timeline.items.slice():[];scope.orderedItems=$filter("orderBy")(displayedItems,scope.reverse?"-time":"time");scope.orderedItems=scope.orderedItems.slice(0,maxItems);scope.orderedItemsWithDays=[];scope.orderedItems.forEach(function(x,i){if(i===0){scope.orderedItemsWithDays.push({isSeparator:true,day:x.day});scope.orderedItemsWithDays.push(x)}else if(x.day===scope.orderedItems[i-1].day){scope.orderedItemsWithDays.push(x)}else{scope.orderedItemsWithDays.push({isSeparator:true,day:x.day});scope.orderedItemsWithDays.push(x)}})}scope.$state=$state;scope.$watch("timeline",function(nv,ov){if(nv)update()});scope.scroll=function(){maxItems+=20;update()}}}});app.directive("timelineItem",function(TimelineItemUtils){return{templateUrl:"/templates/timeline-item.html",link:function(scope){scope.TimelineItemUtils=TimelineItemUtils}}});app.directive("discussionMentionItem",function(){return{templateUrl:"/templates/discussion-mention-item.html"}});app.directive("discussionReplyItem",function(){return{templateUrl:"/templates/discussion-reply-item.html"}});app.directive("discussionCloseItem",function(){return{templateUrl:"/templates/discussion-close-item.html"}});app.directive("commitMentionItem",function(){return{templateUrl:"/templates/commit-mention-item.html"}});app.directive("requestItem",function(){return{templateUrl:"/templates/request-item.html"}});app.directive("requestGrantedItem",function(){return{templateUrl:"/templates/request-granted-item.html"}});app.directive("timelineTaskItem",function(DataikuAPI){return{templateUrl:"/templates/task-notification-item.html",link:function(scope){scope.downloadExport=function(exportId){downloadURL(DataikuAPI.exports.getDownloadURL(exportId))}}}})})();(function(){"use strict";const app=angular.module("dataiku.collab.discussions",[]);app.controller("DiscussionsWidgetController",function($scope,$state,$location,$stateParams,$rootScope,$timeout,$filter,Assert,DataikuAPI,WT1,TopNav,Notification,Dialogs,ActivityIndicator,Debounce,translate){let currentItem;$scope.appConfig=$rootScope.appConfig;$scope.uiState={};$scope.discussionsContext=$stateParams.workspaceKey?"workspace":"project";$scope.topicInputPlaceholder=translate("WIDGET.DISCUSSION.TOPIC.PLACEHOLDER","Topic");$scope.getReadinessUserPictureTitle=function(convLogin){return translate("WIDGET.DISCUSSION.READINESS.USER_PICTURE.TITLE","{{ convLogin }} read the discussion up to this message",{convLogin:convLogin})};$scope.getMessageEditButtonTitle=function(){return!$scope.uiState.replyEditedText.length?translate("WIDGET.DISCUSSION.MESSAGE.EDIT.DISABLED_REASON.NOT_EMPTY","The message cannot be empty!"):$scope.uiState.replyEditedText.length>1e4?translate("WIDGET.DISCUSSION.MESSAGE.EDIT.DISABLED_REASON.10000_CHARACTERS","The message cannot be longer than 10000 characters!"):""};$scope.getDiscussionNewReplyPlaceholder=function(){return $scope.uiState.selectedConv?translate("WIDGET.DISCUSSION.REPLY.PLACEHOLDER","Reply discussion"):translate("WIDGET.DISCUSSION.MESSAGE.PLACEHOLDER","Message")};$scope.getEditTopicSaveButtonTitle=function(){return!$scope.uiState.newConvTopic.length?translate("WIDGET.DISCUSSION.TOPIC.EPIC.DISABLED_REASON.NOT_EMPTY","The topic cannot be empty!"):$scope.uiState.newConvTopic.length>200?translate("WIDGET.DISCUSSION.TOPIC.EPIC.DISABLED_REASON.200_CHARACTERS","The topic cannot be longer than 200 characters!"):""};$scope.getDiscussionReplyEditedPlaceholder=function(){return translate("WIDGET.DISCUSSION.REPLY.PLACEHOLDER","Reply discussion")};$scope.getDiscussionTopic=()=>$scope.uiState.selectedConv.topic||translate("WIDGET.DISCUSSION.TOPIC.UNNAMED","Unnamed discussion");$scope.discussionWidgetPage=function(){if(!$scope.discussions){return"LIST"}else if($scope.uiState.creatingNewConv){return"CREATION"}else if(!$scope.uiState.creatingNewConv&&!$scope.uiState.selectedConv){return"LIST"}else{return"DISCUSSION"}};$scope.onSearchBarEnter=function($event){$event.target.blur()};$scope.getNewRepliesLabel=function(){if(!$scope.uiState.selectedConv){return}const newRepliesCount=$scope.getNumberOfNewReplies($scope.uiState.selectedConv,$scope.uiState.cachedUserReadTime||0);return translate(newRepliesCount<=1?"WIDGET.DISCUSSION.NEW_REPLY.LABEL":"WIDGET.DISCUSSION.NEW_REPLIES.LABEL",newRepliesCount+" new repl"+(newRepliesCount>1?"ies":"y"))};$scope.getViewNewRepliesLabel=function(){if(!$scope.uiState.selectedConv){return}const newRepliesCount=$scope.getNumberOfNewReplies($scope.uiState.selectedConv,$scope.uiState.cachedUserReadTime||0);return translate(newRepliesCount<=1?"WIDGET.DISCUSSION.VIEW_NEW_REPLY.LABEL":"WIDGET.DISCUSSION.VIEW_NEW_REPLIES.LABEL",newRepliesCount+"View new repl"+(newRepliesCount>1?"ies":"y"))};$scope.getNumberOfNewReplies=function(discussion,fromTime){if(!discussion){return}return discussion.replies.filter(reply=>reply.time>fromTime).length};$scope.getDisabledReason=function(){if(!$scope.uiState.selectedConv&&!($scope.uiState.newConvTopic||"").length){return translate("WIDGET.DISCUSSION.TOPIC.EPIC.DISABLED_REASON.NOT_EMPTY","The topic cannot be empty!")}if(!$scope.uiState.selectedConv&&($scope.uiState.newConvTopic||"").length>200){return translate("WIDGET.DISCUSSION.TOPIC.EPIC.DISABLED_REASON.200_CHARACTERS","The topic cannot be longer than 200 characters!")}if(!($scope.uiState.newReply||"").length){return translate("WIDGET.DISCUSSION.MESSAGE.EDIT.DISABLED_REASON.NOT_EMPTY","The message cannot be empty!")}if(($scope.uiState.newReply||"").length>1e4){return translate("WIDGET.DISCUSSION.MESSAGE.EDIT.DISABLED_REASON.10000_CHARACTERS","The message cannot be longer than 10000 characters!")}return translate("WIDGET.DISCUSSION.MESSAGE.EDIT.DISABLED_REASON.ENTER_NEW_LINE","Press Enter to insert a new line. And press Ctrl+Enter to send your message.")};$scope.viewNewReplies=function(scrollToNewReplies){$scope.uiState.displayToastNewReplies=false;$scope.uiState.invalidateCachedUserReadTime=true;if(scrollToNewReplies){$timeout(function(){const el=$(".discussions-widget-list-replies");const newReplies=$(".discussions-widget-newreplies");if(!newReplies||!el.get(0)){return}const scrollPos=newReplies.length?el.scrollTop()+newReplies.position().top:el.get(0).scrollHeight;el.scrollTop(scrollPos)},200)}if($scope.uiState.selectedConv&&(($scope.uiState.selectedConv.users[$rootScope.appConfig.login]||{}).lastReadTime||0)<=$scope.uiState.selectedConv.lastReplyTime){DataikuAPI.discussions.ack(currentItem.projectKey,currentItem.type,currentItem.id,$scope.uiState.selectedConv.id,currentItem.workspaceKey).error(setErrorInScope.bind($scope))}};$scope.openDiscussion=function(discussion,userAction){$scope.uiState.selectedConv=discussion;if($scope.uiState.selectedConv){const newLastReadTime=($scope.uiState.selectedConv.users[$rootScope.appConfig.login]||{}).lastReadTime||0;const hasLastReadTimeChanged=newLastReadTime!=$scope.uiState.cachedUserReadTime;const hasNoPeerNewReplies=!$scope.uiState.selectedConv.replies.filter(reply=>reply.time>newLastReadTime&&reply.author!=$rootScope.appConfig.login).length;if($scope.uiState.invalidateCachedUserReadTime||userAction||hasNoPeerNewReplies){$scope.uiState.cachedUserReadTime=newLastReadTime;$scope.uiState.invalidateCachedUserReadTime=false}if(userAction||hasNoPeerNewReplies){$scope.viewNewReplies(userAction||hasLastReadTimeChanged)}else{$scope.uiState.displayToastNewReplies=true;const convListWidget=$(".discussions-widget-list-replies");const newRepliesLine=$(".discussions-widget-newreplies");if(convListWidget.size()&&newRepliesLine.size()){$scope.uiState.showToastNewReplies=newRepliesLine.offset().top>convListWidget.offset().top+convListWidget.height()-30}}}};$scope.resetInputs=function(){delete $scope.uiState.newConvTopic;delete $scope.uiState.newReply;delete $scope.uiState.editingTopic};$scope.getDiscussionParticipants=function(discussion){const MAX_PARTICIPANT_LIST_LENGTH=30;let participantListLength=0;const participants=[];const displayedParticipants=[];for(const login in discussion.users){if(discussion.users[login].lastReplyTime>0){participants.push(discussion.users[login])}}participants.sort((a,b)=>b.lastReplyTime-a.lastReplyTime);for(let i=0;i<participants.length;i++){const escapedDisplayName=$filter("escapeHtml")(participants[i].displayName||translate("WIDGET.DISCUSSION.PARTICIPANTS.UNKNOWN_USER","Unknown user"));if(participantListLength+escapedDisplayName.length+2<=MAX_PARTICIPANT_LIST_LENGTH){displayedParticipants.push(escapedDisplayName);participantListLength+=escapedDisplayName.length+2}else{break}}const othersCount=participants.length-displayedParticipants.length;let participantsListStr=displayedParticipants.join("<small>, </small>");if(othersCount>0){if(displayedParticipants.length==0){participantsListStr+=participants.length+"<small> participant"+(participants.length>1?"s":"")+"</small>"}else{const hiddenParticipantCount=participants.length-displayedParticipants.length;participantsListStr+="<small> and </small>"+hiddenParticipantCount+"<small> other"+(hiddenParticipantCount>1?"s":"")+"</small>"}}return participantsListStr};$scope.getDiscussionParticipantsList=function(discussion){const arr=[];angular.forEach(discussion.users,function(value,key){arr.push(angular.extend(value,{login:key}))});arr.sort((a,b)=>b.lastReplyTime-a.lastReplyTime);return arr};$scope.scrollChanged=function(userAction){$timeout(function(){const convListWidget=$(".discussions-widget-list-replies");const newRepliesLine=$(".discussions-widget-newreplies");if(convListWidget.size()&&newRepliesLine.size()){$scope.uiState.showToastNewReplies=newRepliesLine.offset().top>convListWidget.offset().top+convListWidget.height()-30;if(userAction&&!$scope.uiState.showToastNewReplies&&$scope.uiState.displayToastNewReplies){$scope.viewNewReplies(false)}}})};$scope.closeDiscussion=function(close){if(!$scope.uiState.selectedConv){return}DataikuAPI.discussions.close(currentItem.projectKey,currentItem.type,currentItem.id,$scope.uiState.selectedConv.id,close,currentItem.workspaceKey).success(function(){WT1.event("discussion-close",{close:close,state:$state.current.name});broadcastDiscussionCountChange()}).error(setErrorInScope.bind($scope))};$scope.editTopic=function(){if(!$scope.uiState.selectedConv||!$scope.uiState.newConvTopic){return}WT1.event("discussion-edit-topic",{state:$state.current.name});DataikuAPI.discussions.save(currentItem.projectKey,currentItem.type,currentItem.id,$scope.uiState.selectedConv.id,$scope.uiState.newConvTopic,currentItem.workspaceKey).success(()=>$scope.uiState.editingTopic=false).error(setErrorInScope.bind($scope));$scope.resetInputs()};$scope.resetEditing=function(){delete $scope.uiState.replyEditing;delete $scope.uiState.replyEditedText};$scope.editReply=function(){const validEditedText=($scope.uiState.replyEditedText||"").length>0&&($scope.uiState.replyEditedText||"").length<=1e4;if(!$scope.uiState.selectedConv||!($scope.uiState.selectedConv.replies[$scope.uiState.replyEditing]||{}).id||!validEditedText){return}WT1.event("discussion-edit-reply",{state:$state.current.name});DataikuAPI.discussions.reply(currentItem.projectKey,currentItem.type,currentItem.id,$scope.uiState.selectedConv.id,$scope.uiState.replyEditedText,$scope.uiState.selectedConv.replies[$scope.uiState.replyEditing].id,currentItem.workspaceKey).success(function(){$scope.resetEditing()}).error(setErrorInScope.bind($scope));$scope.resetInputs()};$scope.replyDiscussion=function(){const replyTopic=$scope.uiState.newConvTopic||"";const replyContent=$scope.uiState.newReply;if(!replyContent||!replyTopic&&!$scope.uiState.selectedConv){return}WT1.event("discussion-reply",{state:$state.current.name,number_of_discussions:$scope.discussions.length,number_of_replies:$scope.discussions.map(c=>c.replies.length).reduce((a,b)=>a+b,0)});if($scope.uiState.selectedConv){DataikuAPI.discussions.reply(currentItem.projectKey,currentItem.type,currentItem.id,$scope.uiState.selectedConv.id,replyContent,null,currentItem.workspaceKey).error(setErrorInScope.bind($scope))}else{DataikuAPI.discussions.create(currentItem.projectKey,currentItem.type,currentItem.id,replyTopic,replyContent,currentItem.workspaceKey).success(function(data){$scope.uiState.forceSelectedConvId=data.id;broadcastDiscussionCountChange()}).error(setErrorInScope.bind($scope))}$scope.resetInputs();$timeout(()=>{$("body > .tooltip").remove()})};$scope.deleteDiscussion=function(){if(!$scope.uiState.selectedConv){return}Dialogs.confirm($scope,"Delete discussion","Warning: deleting "+($scope.uiState.selectedConv.topic?'discussion "'+$scope.uiState.selectedConv.topic+'"':"this discussion")+" will erase permanently its whole content including all the replies. This operation is irreversible. Do you want to continue?").then(function(){DataikuAPI.discussions.delete(currentItem.projectKey,currentItem.type,currentItem.id,$scope.uiState.selectedConv.id,currentItem.workspaceKey).success(function(){WT1.event("discussion-delete",{state:$state.current.name});delete $scope.uiState.selectedConv;broadcastDiscussionCountChange()}).error(setErrorInScope.bind($scope))})};function getDiscussionById(id){Assert.inScope($scope,"discussions");return $scope.discussions.find(conv=>conv.id==id)||null}function refreshDiscussions(){const discussionIdFromStateParams=$stateParams.discussionId;if(discussionIdFromStateParams){$state.go(".",{"#":$location.hash(),discussionId:null},{notify:false,location:"replace"})}DataikuAPI.discussions.getForObject(currentItem.projectKey,currentItem.type,currentItem.id,currentItem.workspaceKey).success(function(data){$scope.discussions=data.discussions;if($scope.discussions&&$scope.discussions.length>0&&!$scope.discussions.find(discu=>discu.closedOn==0)){$scope.uiState.showClosed=true}const userActionWhenSingleDiscussion=$scope.discussionId&&!$scope.uiState.selectedConv;if($scope.discussionId){$scope.uiState.forceSelectedConvId=$scope.discussionId()}if($scope.uiState.forceSelectedConvId){$scope.uiState.creatingNewConv=false;$scope.uiState.selectedConv=getDiscussionById($scope.uiState.forceSelectedConvId);delete $scope.uiState.forceSelectedConvId}if($scope.uiState.selectedConv){$scope.openDiscussion(getDiscussionById($scope.uiState.selectedConv.id),userActionWhenSingleDiscussion)}else if(discussionIdFromStateParams&&!$scope.discussionId){const discussion=getDiscussionById(discussionIdFromStateParams);if(discussion){$scope.openDiscussion(discussion,true)}else{ActivityIndicator.error("Discussion "+discussionIdFromStateParams+" not found")}}$scope.scrollChanged(false)}).error(setErrorInScope.bind($scope))}function updateLastReadByUsers(evt,message){if(!$scope.discussions){return}if(!message||!(message.details||{}).time||!message.user){return}const conv=$scope.discussions.find(conv=>conv.id==message.discussionId);if(conv){if(!conv.users[message.user]){conv.users[message.user]={login:message.user,displayName:message.details.userDisplayName}}conv.users[message.user].lastReadTime=message.details.time}}function selectedItemUpdated(){const value=$scope.selectedItem();const hasSelectedItem=!!value;const hasSelectedItemChanged=hasSelectedItem&&!angular.equals(currentItem,value);const hasSingleDiscussionChanged=$scope.discussionId&&!angular.equals($scope.discussionId(),$scope.uiState.forceSelectedConvId);if(hasSelectedItem&&(hasSelectedItemChanged||hasSingleDiscussionChanged)){currentItem=value;$scope.uiState={forceSelectedConvId:$scope.uiState.forceSelectedConvId||($scope.uiState.selectedConv||{}).id};if((currentItem.projectKey||currentItem.workspaceKey)&&currentItem.type&&currentItem.id){refreshDiscussions()}}}function broadcastDiscussionCountChange(){if($state.is("projects.project.flow")){$rootScope.$broadcast("discussionCountChanged")}}if($scope.watchObject&&$scope.selectedItem){let debounceFn=Debounce().withDelay(20,200).withScope($scope).wrap(selectedItemUpdated);$scope.$watch("watchObject",debounceFn,true)}else{currentItem=angular.copy(TopNav.getItem());currentItem.projectKey=$stateParams.projectKey;currentItem.workspaceKey=$stateParams.workspaceKey;refreshDiscussions()}const replyListenerDestroyer=Notification.registerEvent("discussion-reply",refreshDiscussions);const deleteListenerDestroyer=Notification.registerEvent("discussion-delete",refreshDiscussions);const updateListenerDestroyer=Notification.registerEvent("discussion-update",refreshDiscussions);const closeListenerDestroyer=Notification.registerEvent("discussion-close",refreshDiscussions);const ackListenerDestroyer=Notification.registerEvent("discussion-ack",updateLastReadByUsers);$scope.$on("$destroy",function(){replyListenerDestroyer();deleteListenerDestroyer();updateListenerDestroyer();closeListenerDestroyer();ackListenerDestroyer()})});app.directive("discussionsWidget",function(translate){return{restrict:"AE",templateUrl:"/templates/widgets/discussions-widget-content.html",scope:{selectedItem:"&",watchObject:"="},link:function($scope){$scope.discussionSearchPlaceholder=translate("WIDGET.DISCUSSION.SEARCH.PLACEHOLDER","Search discussions…");$scope.showResolvedDiscussionTooltip=translate("WIDGET.DISCUSSION.SHOW_RESOLVED","Show resolved discussions");$scope.hideResolvedDiscussionTooltip=translate("WIDGET.DISCUSSION.HIDE_RESOLVED","Hide resolved discussions")}}});app.directive("discussionsWidgetSingle",function(){return{restrict:"AE",templateUrl:"/templates/widgets/discussions-widget-single.html",scope:{selectedItem:"&",discussionId:"&",watchObject:"="}}});app.directive("discussionsButton",function($rootScope,$compile,$templateRequest,$stateParams,Assert,DataikuAPI,TopNav,Notification,Debounce){return{restrict:"AE",templateUrl:"/templates/widgets/discussions-widget-button.html",scope:{selectedItem:"&",watchObject:"="},replace:true,link:function($scope,element,attrs){let currentItem;$scope.discussionCounts=null;$scope.uiState={};$scope.uiState.loadRequested=false;$scope.uiState.displayed=false;$scope.uiState.maximized=false;$scope.titleForNumberOfDiscussions=function(){let title;const counts=$scope.discussionCounts;if(!counts)return;if(counts.open){title=counts.open+(counts.unread==counts.open&&counts.unread>0?" unread":"")+" discussion"+(counts.open==1?"":"s")}else if(counts.total){title="No open discussion"}else{title="No discussion"}let objectTypeName=$scope.uiState.currentObjectType.replace("_"," ");if(objectTypeName=="project"){objectTypeName="project's home page"}title+=" on this "+objectTypeName;if(counts.unread!=counts.open&&counts.unread>0){title+=" ("+counts.unread+" unread)"}return title};function openDiscussionsWidget(){if(!$scope.uiState.loadRequested){loadWidget()}$scope.uiState.displayed=true;$scope.uiState.maximized=true}$scope.closeDiscussionsWidget=function(){$scope.uiState.displayed=false};$scope.toggleDiscussionsWidget=function(){if($scope.uiState.displayed&&$scope.uiState.maximized){$scope.closeDiscussionsWidget()}else{openDiscussionsWidget()}};$scope.toggleMaximized=function(){$scope.uiState.maximized=!$scope.uiState.maximized};function refreshCounts(){DataikuAPI.discussions.getCounts(currentItem.projectKey,currentItem.type,currentItem.id,currentItem.workspaceKey).success(function(data){$scope.discussionCounts=data;if(!$scope.uiState.displayed&&$scope.discussionCounts.unread>0){if(!$scope.uiState.loadRequested){loadWidget()}$scope.uiState.displayed=true;$scope.uiState.maximized=false}}).error(setErrorInScope.bind($scope))}function loadWidget(){Assert.trueish(!$scope.uiState.loadRequested,"loadWidget called twice");$scope.uiState.loadRequested=true;const location="/templates/widgets/discussions-widget-popover.html";$templateRequest(location).then(function(template){const selectedItem=$scope.watchObject&&$scope.selectedItem?$scope.selectedItem():TopNav.getItem();if(!TopNav.sameItem(currentItem,selectedItem))return;if(angular.isArray(template)){template=template[1]}else if(angular.isObject(template)){template=template.data}const widgetEl=$(template);$compile(widgetEl)($scope);$(".main-view").append(widgetEl);$scope.$on("$destroy",function(){widgetEl.remove()})})}function selectedItemUpdated(){const value=$scope.selectedItem();const hasSelectedItem=!!value;const hasSelectedItemChanged=hasSelectedItem&&!angular.equals(currentItem,value);const hasSingleDiscussionChanged=$scope.discussionId&&!angular.equals($scope.discussionId(),$scope.uiState.forceSelectedConvId);if(hasSelectedItem&&(hasSelectedItemChanged||hasSingleDiscussionChanged)){currentItem=value;$scope.uiState.currentObjectType=value.type.toLowerCase().replace("[^a-zA-Z]"," ");refreshCounts()}}if($scope.watchObject&&$scope.selectedItem){let debounceFn=Debounce().withDelay(20,200).withScope($scope).wrap(selectedItemUpdated);$scope.$watch("watchObject",debounceFn,true)}else{currentItem=angular.copy(TopNav.getItem());currentItem.projectKey=$stateParams.projectKey;currentItem.workspaceKey=$stateParams.workspaceKey;if(currentItem.type){$scope.uiState.currentObjectType=currentItem.type.toLowerCase().replace("[^a-zA-Z]"," ")}refreshCounts()}const replyListenerDestroyer=Notification.registerEvent("discussion-reply",refreshCounts);const deleteListenerDestroyer=Notification.registerEvent("discussion-delete",refreshCounts);const closeListenerDestroyer=Notification.registerEvent("discussion-close",refreshCounts);const ackListenerDestroyer=Notification.registerEvent("discussion-ack",function(evtType,message){if($scope.discussionCounts&&$scope.discussionCounts.unread&&message.user==$rootScope.appConfig.login){refreshCounts()}});$scope.$on("$destroy",function(){replyListenerDestroyer();deleteListenerDestroyer();closeListenerDestroyer();ackListenerDestroyer()});if($stateParams.discussionId){openDiscussionsWidget()}}}});app.service("Discussions",function($rootScope,Notification,MessengerUtils,StateUtils,UserImageUrl){function userAvatar(userLogin,size){if(!userLogin)return"";const imageUrl=UserImageUrl(userLogin,size);const sizeClass=size?"size-"+sanitize(size):"size-fit";return`<img class="user-avatar ${sizeClass}" src="${imageUrl}" />`}function userLink(userLogin,innerHTML){return'<a href="/profile/'+escape(userLogin)+'/" class="link-std">'+innerHTML+"</a>"}function dssObjectLink(event,innerHTML){const tor={type:event.objectType,id:event.objectId,projectKey:event.projectKey,workspaceKey:event.workspaceKey};const link=StateUtils.href.taggableObject(tor,{moveToTargetProject:false,discussionId:event.discussionId});return'<a href="'+link+'" class="link-std">'+innerHTML+"</a>"}function discussionIsOpen(id){const discussionScope=angular.element($(".discussions-widget-list-replies")).scope();return discussionScope&&discussionScope.uiState&&discussionScope.uiState.selectedConv.id==id}const replyListenerDestroyer=Notification.registerEvent("discussion-reply",function(evt,message){if(message.user==$rootScope.appConfig.login){return}if(!message.newReply){return}if(message.mentionedUsers&&message.mentionedUsers.includes($rootScope.appConfig.login)){return}if(discussionIsOpen(message.discussionId)){return}MessengerUtils.post({message:userLink(message.user,sanitize(message.details.userDisplayName||message.user))+(message.creation?" created a discussion on ":" added a reply on ")+dssObjectLink(message,sanitize(message.details.objectDisplayName))+":"+'<span class="messenger-comment">'+sanitize(message.text.substr(0,400))+(message.text.length>400?"[...]":"")+"</span>",icon:userAvatar(message.user),hideAfter:5,showCloseButton:true,id:message.user+"connected",type:"no-severity"})});const mentionListenerDestroyer=Notification.registerEvent("discussion-mention",function(evt,message){MessengerUtils.post({message:userLink(message.author,sanitize(message.details.authorDisplayName||message.author))+" mentioned you in a discussion on "+dssObjectLink(message,sanitize(message.details.objectDisplayName))+":"+'<span class="messenger-comment">'+sanitize(message.message.substr(0,400))+(message.message.length>400?"[...]":"")+"</span>",icon:userAvatar(message.author),type:"no-severity",showCloseButton:true})});const closeListenerDestroyer=Notification.registerEvent("discussion-close",function(evt,message){if(message.user==$rootScope.appConfig.login){return}MessengerUtils.post({message:userLink(message.user,sanitize(message.details.userDisplayName||message.user))+" has "+(message.details.closed?"resolved":"reopened")+" a discussion on "+dssObjectLink(message,sanitize(message.details.objectDisplayName)),icon:userAvatar(message.user),type:"no-severity",showCloseButton:true})});$rootScope.$on("$destroy",function(){replyListenerDestroyer();mentionListenerDestroyer();closeListenerDestroyer()})})})();(function(){"use strict";const app=angular.module("dataiku.collab.wikis",[]);app.constant("WIKI_TAXONOMY_KEY","dss.wiki.taxonomy");app.service("WikiUtilsService",function(){const svc=this;svc.getParentId=function(id,node,taxonomy){const children=node?node.children:taxonomy;if(!children){return null}const nodeId=node?node.id:"";for(const child of children){if(child.id===id){return nodeId}const foundParent=svc.getParentId(id,child);if(foundParent){return foundParent}}return null};svc.getArticleNodeById=function(articleId,node,taxonomy){const children=node&&node.children?node.children:taxonomy;for(const child of children){if(child.id===articleId){return child}const foundNode=svc.getArticleNodeById(articleId,child);if(foundNode){return foundNode}}return null};svc.addArticlesToList=function(nodes,articlesIds){nodes.forEach(function(node){articlesIds.push(node.id);svc.addArticlesToList(node.children,articlesIds)})}});app.controller("WikiController",function($scope,$controller,$state,$q,TaggingService,$stateParams,$rootScope,$timeout,WT1,TopNav,Dialogs,CreateModalFromTemplate,DataikuAPI,_SummaryHelper,WikiUtilsService,ActiveProjectKey,TaggableObjectsService,LocalStorage,WIKI_TAXONOMY_KEY){$controller("_WikiSearch",{$scope:$scope});TopNav.setLocation(TopNav.TOP_WIKI,"wiki",TopNav.TABS_NONE,null);$scope.wikiScope=$scope;WT1.event("wiki-visit",{});$scope.newArticle=function(newArticleId,parentArticleId){if(newArticleId){$scope.newNotFoundArticle={id:newArticleId}}CreateModalFromTemplate("/templates/wikis/new-article-modal.html",$scope,"NewArticleModalController",function(newScope){if(angular.isDefined(parentArticleId)){newScope.newArticle.parent=parentArticleId}}).then(function(article){WT1.event("article-create",{});$state.go("projects.project.wiki.article.edit",{articleId:article.id},{reload:false});$scope.updateWiki().then(function(){if(angular.isDefined($scope.wikiScope.treeViewHook)){$timeout(()=>$scope.wikiScope.treeViewHook.scrollToNodeFn(article.id))}})})};$scope.getParentId=function(id,node){return WikiUtilsService.getParentId(id,node,$scope.wiki.taxonomy)};$scope.getArticleNodeById=function(articleId,node){return WikiUtilsService.getArticleNodeById(articleId,node,$scope.wiki.taxonomy)};function addArticlesToList(nodes){return WikiUtilsService.addArticlesToList(nodes,$scope.articlesIds)}function retrieveUnfoldedNodeIDs(){let savedStates=LocalStorage.get(WIKI_TAXONOMY_KEY);if(savedStates){let unfoldedNodeIDs=savedStates[$stateParams.projectKey];if(unfoldedNodeIDs&&unfoldedNodeIDs.length>0){$scope.wiki.unfoldedNodeIds=unfoldedNodeIDs}}}function retrieveNodeIdsHavingChildren(nodes){nodes.forEach(function(node){if(node.children.length>0){$scope.wiki.nodeIdsHavingChildren.push(node.id);retrieveNodeIdsHavingChildren(node.children)}})}function initTaxonomy(){$scope.wiki.unfoldedNodeIds=[];$scope.wiki.nodeIdsHavingChildren=[];retrieveUnfoldedNodeIDs();retrieveNodeIdsHavingChildren($scope.wiki.taxonomy);if(typeof $scope.initNodes==="function"){$scope.initNodes($scope.wiki.taxonomy)}}$scope.getAllTagsForProject=function(){const deferred=$q.defer();deferred.resolve(TaggingService.getProjectTags());return getRewrappedPromise(deferred)};$scope.updateWiki=function(){return DataikuAPI.wikis.getWiki(ActiveProjectKey.get()).success(function(wikiSummary){if(angular.isDefined($scope.wiki)&&angular.isDefined($scope.wikiScope.saveFoldingState)){$scope.wikiScope.saveFoldingState()}$scope.wiki=wikiSummary.wiki;$scope.articleMapping=wikiSummary.articleMapping;$scope.wikiTimeline=wikiSummary.timeline;$scope.articlesIds=[];$scope.emptyWiki=!$scope.wiki.taxonomy||!$scope.wiki.taxonomy.length;if($scope.emptyWiki){return}initTaxonomy();addArticlesToList($scope.wiki.taxonomy);if($state.current.name=="projects.project.wiki"){const rootArticle=$scope.wiki.homeArticleId||$scope.wiki.taxonomy[0].id;$state.go("projects.project.wiki.article.view",{articleId:rootArticle},{reload:true,location:"replace"})}if($stateParams.articleId){$scope.articleNode=$scope.getArticleNodeById($stateParams.articleId)}}).error(setErrorInScope.bind($scope))};$timeout(()=>$scope.updateWiki());$scope.startChangeArticleParent=function(articleId){$scope.tempArticleID=articleId;CreateModalFromTemplate("/templates/wikis/change-article-parent-modal.html",$scope).then(function(){delete $scope.tempArticleID;$scope.updateWiki().then(_=>$timeout(_=>$scope.wikiScope.treeViewHook.scrollToNodeFn(articleId)))})};$scope.saveArticleLayout=function(layout){if(["WIKI_ARTICLE","FOLDER"].indexOf(layout)==-1){return}WT1.event("article-save-layout",{layout:layout});let article=angular.extend({},$scope.article,{layout:layout});return $scope.wikiScope.checkSaveArticle(article,$scope.uiState.editedPayload)};$scope.setHomeArticle=function(articleId){WT1.event("wiki-set-home",{});DataikuAPI.wikis.setHomeArticle($stateParams.projectKey,articleId).success(function(){$scope.updateWiki()}).error(setErrorInScope.bind($scope.wikiScope))};$scope.startCopyArticle=function(articleId){$scope.copyArticle={name:"Copy of "+$scope.articleMapping[articleId],parent:$scope.getParentId(articleId)||null,originalArticleId:articleId};function reallyStartCopy(){CreateModalFromTemplate("/templates/wikis/copy-article-modal.html",$scope,"CopyArticleModalController").then(function(article){$state.go("projects.project.wiki.article.edit",{articleId:article.id},{reload:false});$scope.updateWiki().then(function(){if(angular.isDefined($scope.wikiScope.treeViewHook)){$timeout(()=>$scope.wikiScope.treeViewHook.scrollToNodeFn(article.id))}})})}$scope.wikiScope.checkDirtiness(reallyStartCopy)};$scope.startRenameArticle=function(articleId){$scope.tempArticleID=articleId;function reallyStartRenaming(){CreateModalFromTemplate("/templates/wikis/rename-article-modal.html",$scope).then(function(articleId){delete $scope.tempArticleID;$scope.updateWiki();$state.go("projects.project.wiki.article.view",{articleId:articleId},{reload:true})})}$scope.wikiScope.checkDirtiness(reallyStartRenaming)};$scope.deleteArticles=function(articles){WT1.event("article-delete",{});return TaggableObjectsService.delete(articles.map(a=>({projectKey:a.projectKey,type:"ARTICLE",id:a.id,displayName:$scope.articleMapping[a.id]||a.id}))).then(function(data){WT1.event("article-delete",{number_of_articles:$scope.articlesIds&&$scope.articlesIds.length});$scope.updateWiki();$state.go("projects.project.wiki",{projectKey:$stateParams.projectKey},{reload:true})},setErrorInScope2.bind($scope))};$scope.shareArticleInWorkspace=article=>{CreateModalFromTemplate("/templates/dialogs/share-in-workspace.html",$scope,undefined,newScope=>{article.type="ARTICLE";newScope.init([{reference:article}],"article")})};$scope.uiState={};$scope.getObjectId=function(){return $scope.article&&$scope.article.id};$scope.objectType="ARTICLE";$scope.$watch("wiki.taxonomy",function(nv,ov){if(nv&&ov){return DataikuAPI.wikis.editTaxonomy(ActiveProjectKey.get(),$scope.wikiScope.wiki).error(setErrorInScope.bind($scope))}},true);_SummaryHelper.addInterestsManagementBehaviour($scope);const so=$scope.starObject;$scope.starObject=function(s){so(s).then(function(){$scope.interest.starred=s})};const wo=$scope.watchObject;$scope.watchObject=function(w){wo(w).then(function(){$scope.interest.watching=w})};$scope.hasAuthorizedAttachmentsList=false;DataikuAPI.wikis.getAuthorizedExtensions().success(list=>{if(list.authorizedExtensionsList){$scope.hasAuthorizedExtensionsList=true;$scope.authorizedExtensionsListFormatted=list.authorizedExtensionsList.sort().join(", ")}})});app.controller("ArticleController",function(Logger,$scope,$location,$anchorScroll,$state,$stateParams,$filter,$timeout,WT1,SmartId,TopNav,DataikuAPI,TaggingService,CreateModalFromTemplate,Dialogs,ActiveProjectKey,DKUtils,StateUtils,FullScreenService,executeWithInstantDigest,TaggableObjectsService){$scope.SmartId=SmartId;$scope.$state=$state;$scope.wikiScope.isLoaded=false;const filesToUpload={files:[],fileProperties:[]};$scope.markdownCallback=function(){$scope.articleContents=[];const container=$(".wiki-article-content div[from-markdown], .wiki-article-preview-content div[from-markdown]");if(container.length>0){const headersIndexes={};for(let i=1;i<=6;i++){headersIndexes[i]=0}$(container[0]).find(".dku-header-anchor").each(function(idx,headerTag){const aTag=$(headerTag).find("a[name]");if(aTag.length>0){const depth=Number($(headerTag).prop("tagName").substring(1));headersIndexes[depth]++;const indexes=[];for(let i=1;i<=depth;i++){indexes.push(headersIndexes[i])}$scope.articleContents.push({anchor:aTag.attr("name"),label:headerTag.innerText,depth:depth-1,indexes:indexes.join(".")});for(let i=depth+1;i<=6;i++){headersIndexes[i]=0}}})}$timeout(()=>{$anchorScroll()});$scope.wikiScope.isLoaded=true;TaggableObjectsService.checkAndUpdateThumbnailData({...$scope.article,type:"ARTICLE"},".wiki-article-content > .markdown-std")};$scope.$on("$destroy",()=>{$location.hash("")});$scope.anchorLink=function(anchor){return location.pathname+"#"+anchor};$scope.startEditTags=function(){TaggingService.startApplyTagging([angular.extend({},$scope.article,{type:"ARTICLE",displayName:$scope.article.name})]).then(getSummary)};$scope.getAttachmentIcon=function(item){if(item.attachmentType=="DSS_OBJECT"){let subtype=item.subtype;let classColor=$filter("subTypeToColor")(subtype,item.taggableType);if(item.taggableType==="SAVED_MODEL"){subtype=item.details.savedModelMLCategory;classColor=$filter("savedModelMLCategoryToClassColor")(item.details.savedModelMLCategory,true)}return $filter("subTypeToIcon")(subtype,item.taggableType,16)+" "+classColor}else{return $filter("mimeTypeToIcon")(item.details.mimeType)}};$scope.wikiScope.editCustomFields=function(editingTabIndex=0){if(!$scope.article){return}let oldCustomFields=angular.copy($scope.article.customFields);let modalScope=angular.extend($scope,{objectType:"ARTICLE",objectName:$scope.article.id,objectCustomFields:$scope.article.customFields,editingTabIndex:editingTabIndex});CreateModalFromTemplate("/templates/taggable-objects/custom-fields-edit-modal.html",modalScope).then(function(customFields){$scope.article.customFields=customFields;$scope.wikiScope.saveArticlePayload().then(null,function(){$scope.article.customFields=oldCustomFields})})};$scope.$on("objectSummaryEdited",function(){$scope.wikiScope.checkSaveArticle($scope.article,$scope.articlePayload)});$scope.wikiScope.checkDirtiness=cb=>{if(typeof cb!="function"){throw Error("Callback is not a function")}if($scope.isDirty()){Dialogs.confirm($scope,"Unsaved changes","There are unsaved changes that are about to be erased. Are you sure you want to continue?").then(()=>{$scope.uiState.editedPayload=angular.copy($scope.articlePayload);cb()})}else{cb()}};$scope.startExportArticle=function(articleId){$scope.tempArticleID=articleId;function reallyStartExporting(){CreateModalFromTemplate("/templates/wikis/export-article-modal.html",$scope)}$scope.wikiScope.checkDirtiness(reallyStartExporting)};$scope.wikiScope.saveAttachment=function(article,attachment){return DataikuAPI.wikis.addAttachment(article,attachment).success(function(data){setSummary(data,false)}).error(setErrorInScope.bind($scope.wikiScope))};$scope.wikiScope.uploadInText=function(files){$scope.wikiScope.uploadDirectly(files,true)};$scope.wikiScope.uploadDirectly=function(files,insertInText=false){filesToUpload.files.splice(0,filesToUpload.files.length);filesToUpload.fileProperties.splice(0,filesToUpload.fileProperties.length);$scope.wikiScope.drop(files);$scope.uploadFilesAfterDigest(insertInText)};$scope.wikiScope.drop=function(files){WT1.event("article-drop-files",{number_of_files:files.length});for(let i=0;i<files.length;i++){filesToUpload.files.push(files[i]);filesToUpload.fileProperties.push({path:files[i].name,length:files[i].size,progress:0,uploaded:false})}};$scope.uploadFilesAfterDigest=function(insertInText){$timeout(function(){uploadFiles(insertInText)})};function uploadFiles(insertInText){$scope.wikiScope.fileUploadProperties=filesToUpload.fileProperties;for(let idx=0;idx<filesToUpload.files.length;++idx){uploadOneFile(idx,insertInText)}}function uploadOneFile(idx,insertInText){const fileToUpload=filesToUpload.files[idx];DataikuAPI.wikis.upload(ActiveProjectKey.get(),$stateParams.articleId,fileToUpload,function(e){if(e.lengthComputable){executeWithInstantDigest(()=>{$scope.wikiScope.fileUploadProperties[idx].progress=Math.round(e.loaded*100/e.total)},$scope.wikiScope)}}).then(function(data){const articleWithRecentAttachment=angular.fromJson(data);$scope.wikiScope.article=articleWithRecentAttachment.article;if(insertInText){let item=articleWithRecentAttachment.articleAttachment;$scope.wikiScope.insertAttachment(item,false,item.details.mimeType.startsWith("image"))}},setErrorInScope2.bind($scope.wikiScope)).finally(function(){$scope.wikiScope.fileUploadProperties[idx].uploaded=true})}$scope.wikiScope.removeAttachment=function(article,attachment){return DataikuAPI.wikis.deleteAttachment(article,attachment).success(function(data){setSummary(data,false)}).error(setErrorInScope.bind($scope.wikiScope))};$scope.wikiScope.checkSaveArticle=function(article,payload,callback,commitMessage){function saveAfterConflictCheck(){return DataikuAPI.wikis.saveArticle(article,payload,commitMessage).success(function(data){setSummary(data);if(typeof callback=="function"){callback(data)}}).error(setErrorInScope.bind($scope.wikiScope))}return DataikuAPI.wikis.checkSaveConflict(article).success(function(conflictResult){if(!conflictResult.canBeSaved){Dialogs.openConflictDialog($scope,conflictResult).then(function(resolutionMethod){if(resolutionMethod=="erase"){return saveAfterConflictCheck()}else if(resolutionMethod=="ignore"){DKUtils.reloadState()}})}else{return saveAfterConflictCheck()}}).error(setErrorInScope.bind($scope.wikiScope))};$scope.wikiScope.saveArticlePayload=function(commitMessage,moveToView){const savedPayload=$scope.wikiScope.uiState.editedPayload;let cb=function(data){if(moveToView){StateUtils.go.article(data.object.id)}try{window.marked(savedPayload,function(...args){if(args.length>1&&args[0]){let usageReport=args[0];usageReport._payloadLength=savedPayload.length;usageReport._origin="article";usageReport._origin_hash=data.object.id.dkuHashCode();WT1.event("article-save",usageReport)}})}catch(e){Logger.error("Failed to compute markdown usage report",e)}};return $scope.wikiScope.checkSaveArticle($scope.article,savedPayload,cb,commitMessage)};function escapeLabel(label){return label.replace(/\]/g,"\\]").replace(/\[/g,"\\[")}$scope.wikiScope.startAddAttachments=function(){CreateModalFromTemplate("/templates/wikis/add-article-attachments-modal.html",$scope)};$scope.wikiScope.deleteAttachment=function(index){Dialogs.confirm($scope,"Delete attachment","Are you sure you want to delete this attachment?").then(function(){const articleAttachment=$scope.article.attachments[index];$scope.article.attachments.splice(index,1);WT1.event("article-remove-attachment",{number_of_attachments:$scope.article.attachments.length});$scope.wikiScope.removeAttachment($scope.article,articleAttachment)})};$scope.wikiScope.insertAttachment=function(attachment,clickOnInsert,image){const cms=$(".wiki-article-edit-body-main .CodeMirror");if(!cms.length){throw new Error("Cannot reach wiki article edition CodeMirror")}const cm=cms.get(0).CodeMirror;cm.editorActions.replaceInEditor(defineTypeOfInsertAttachment(attachment,clickOnInsert,image),false,"end")};function defineTypeOfInsertAttachment(attachment,clickOnInsert,image){return function(prevString){let label;let displayInEditor;if(image){WT1.event("article-insert-image",{});if(clickOnInsert){label=prevString||attachment.details.objectDisplayName;displayInEditor=`![${escapeLabel(label)}](${attachment.smartId})`}else{label=attachment.details.objectDisplayName;displayInEditor=`![${escapeLabel(label)}](${attachment.smartId})\r\n`}}else{WT1.event("article-insert-link",{});if(clickOnInsert){label=prevString||attachment.details.objectDisplayName;const filename=prevString||attachment.details.objectDisplayName.replace(/[^\w\-_.]+/g,"_");displayInEditor=`[${escapeLabel(label)}]{${filename}}(${attachment.smartId})`}else{label=attachment.details.objectDisplayName;const filename=attachment.details.objectDisplayName.replace(/[^\w\-_.]+/g,"_");displayInEditor=`[${escapeLabel(label)}]{${filename}}(${attachment.smartId})\r\n`}}return displayInEditor}}$scope.wikiScope.getUploadHref=function(attachment){try{const ref=SmartId.resolve(attachment.smartId);let sanitizedFilename=attachment.details.objectDisplayName.replace(/(((\.)+)?\/)/g,"_");return`/dip/api/projects/wikis/get-uploaded-file/${sanitizedFilename}?projectKey=${ref.projectKey}&uploadId=${ref.id}`}catch(e){console.error("Failed to resolve uploadId");return""}};const articleDisplayModes={view:"view",edit:"edit"};$scope.wikiScope.getArticleDisplayMode=function(){return $state.current.name=="projects.project.wiki.article.edit"?articleDisplayModes.edit:articleDisplayModes.view};$scope.wikiScope.getArticleProjectKey=function(){return ActiveProjectKey.get()};$scope.getAttachmentViewTarget=function(){return"_blank"};$scope.wikiScope.isDirty=function(){return $scope.wikiScope.uiState.editedPayload!=$scope.articlePayload};const allowedTransitions=["projects.project.wiki.article.view","projects.project.wiki.article.edit","projects.project.wiki.article.history"];function allowedTransitionsFn(data){return data.toState&&data.toParams&&data.fromState&&data.fromParams&&allowedTransitions.indexOf(data.fromState.name)>=0&&allowedTransitions.indexOf(data.toState.name)>=0&&data.fromParams.projectKey==data.toParams.projectKey&&data.fromParams.articleId==data.toParams.articleId}checkChangesBeforeLeaving($scope,$scope.isDirty,null,allowedTransitionsFn);function setSummary(data,refreshText=true){$scope.wikiScope.article=data.object;$scope.wikiScope.articlePayload=data.payload;$scope.wikiScope.timeline=data.timeline;$scope.wikiScope.interest=data.interest;$scope.wikiScope.articleEditionTags={lastModifiedBy:data.lastModifiedBy,lastModifiedOn:data.lastModifiedOn,createdBy:data.createdBy,createdOn:data.createdOn};if(refreshText){$scope.wikiScope.uiState.editedPayload=data.payload}if(!angular.equals(data,{})){if($stateParams.articleName!==data.object.name){$state.go(".",{articleId:data.object.id,articleName:data.object.name,"#":$location.$$hash},{location:"replace"});return}TopNav.setPageTitle(data.object.name+" - Wiki")}TopNav.setItem(TopNav.ITEM_ARTICLE,$stateParams.articleId,$scope.article);if(!$scope.article){return}$scope.wikiScope.articleNode=$scope.getArticleNodeById($scope.article.id);$scope.wikiScope.articleNotFound=null;if($scope.wikiScope.isFullScreen()){$scope.wikiScope.article.layout="WIKI_ARTICLE"}$timeout(()=>{$scope.wikiScope.isLoaded=$scope.wikiScope.isLoaded||!$scope.uiState.editedPayload})}function getSummary(){resetErrorInScope($scope.wikiScope);setSummary({});const articleId=!$stateParams.articleId&&!$stateParams.articleName?$scope.wiki.homeArticleId:$stateParams.articleId;if(!articleId){$state.go("projects.project.wiki",{projectKey:ActiveProjectKey.get()},{reload:true});return}return DataikuAPI.wikis.getArticleSummary(ActiveProjectKey.get(),articleId).success(setSummary).error(function(data,status,headers){if(status!=404){setErrorInScope.apply($scope.wikiScope,arguments)}else{$scope.wikiScope.articleNotFound=$stateParams.articleName?$stateParams.articleName:$stateParams.articleId}})}getSummary();$scope.$watch(()=>$state.current.name,function(nv){$scope.wikiScope.isLoaded=false;if(nv=="projects.project.wiki.article.edit"){$timeout(function(){$(".CodeMirror").each(function(idx,el){el.CodeMirror.refresh();el.CodeMirror.focus()})})}});$scope.wikiScope.wikiExportToolBox={checkLoading:function(){return!$scope.wikiScope.isLoaded},goToArticle:function(articleId){$scope.wikiScope.isLoaded=false;executeWithInstantDigest(_=>$location.url(StateUtils.href.article(articleId,$stateParams.projectKey)),$scope.wikiScope)}};$scope.wikiScope.isFullScreen=FullScreenService.isFullScreen});app.controller("WikiTaxonomyController",function($scope,$stateParams,$state,$timeout,LocalStorage,WIKI_TAXONOMY_KEY,StateUtils,ActiveProjectKey,openDkuPopin){$scope.uiState={activeTaxonomyTab:"articles"};$scope.nodeName=function(node){return $scope.articleMapping[node.id]};$scope.scrollToNode=function(nodeId){if(angular.isDefined(nodeId)){$scope.emptySearchBar();$timeout(()=>$scope.wikiScope.treeViewHook.scrollToNodeFn(nodeId))}};$scope.emptySearchBar=function(){$scope.query.queryString=""};$scope.openContextMenuSearch=function(item,$event){if(!$scope.isProjectAnalystRW()){return}item.$rightClicked=true;let node=item._source;let template=`<ul class="dropdown-menu" ng-click="popupDismiss()">`;template+=$scope.wikiScope.getRightClickMenuTemplate(node);template+=`</ul>`;let isElsewhere=function(elt,e){let result=$(e.target).parents(".dropdown-menu").length==0;if(result){delete item.$rightClicked}return result};$scope.popupDismiss=openDkuPopin($scope,$event,{template:template,isElsewhere:isElsewhere,popinPosition:"CLICK"})};$scope.onClick=function(node){StateUtils.go.article(node.id,undefined,{articleName:$scope.nodeName(node)})};$scope.$on("$stateChangeStart",function(event,toState,toParams,fromState,fromParams){if(!(toState.name.startsWith("projects.project.wiki")&&toParams.projectKey==$stateParams.projectKey)){$scope.wikiScope.saveFoldingState()}});const beforeUnloadEventHandler=function(){$scope.wikiScope.saveFoldingState()};window.addEventListener("beforeunload",beforeUnloadEventHandler);$scope.$on("$destroy",function(){window.removeEventListener("beforeunload",beforeUnloadEventHandler)});$scope.wikiScope.saveFoldingState=function(){let newFoldingState=buildNewFoldingState();LocalStorage.set(WIKI_TAXONOMY_KEY,newFoldingState)};function buildNewFoldingState(){let projectKey=ActiveProjectKey.get();let foldingState=LocalStorage.get(WIKI_TAXONOMY_KEY);if(!foldingState){foldingState={}}if(foldingState[projectKey]){delete foldingState[projectKey]}let unfoldedNodeIDs=getUnfoldedNodeIDs();if(unfoldedNodeIDs.length>0){foldingState[projectKey]=unfoldedNodeIDs}return foldingState}function getUnfoldedNodeIDs(nodes=$scope.wiki.taxonomy){let unfoldedNodeIDs=[];for(let i=0;i<nodes.length;i++){if(nodes[i].children.length>0&&!nodes[i].$reduced){unfoldedNodeIDs.push(nodes[i].id)}let nodeIDs=getUnfoldedNodeIDs(nodes[i].children);if(nodeIDs&&nodeIDs.length>0){unfoldedNodeIDs=unfoldedNodeIDs.concat(nodeIDs)}}return unfoldedNodeIDs}$scope.rightIconClass=function(node){return false};$scope.rightIconTitle=function(node){return false};$scope.iconClass=function(node){return node.id==$scope.wiki.homeArticleId?"dku-icon-home-16":""};$scope.iconTitle=function(node){return node.id==$scope.wiki.homeArticleId?"This is the home page for the wiki":""};$scope.nodeClass=function(node){return node.id==$stateParams.articleId?"tree-view-active-node":""};$scope.setUnfoldedNodeIdsFn=function(nodeIds){$scope.wiki.unfoldedNodeIds=nodeIds};$scope.getUnfoldedNodeIdsFn=function(){return $scope.wiki.unfoldedNodeIds};$scope.getNodeIdsHavingChildrenFn=function(){return $scope.wiki.nodeIdsHavingChildren};const EMPTY_FUNC=function(){};$scope.wikiScope.treeViewHook={scrollToNodeFn:EMPTY_FUNC,expandAllFn:EMPTY_FUNC,collapseAllFn:EMPTY_FUNC,getTaxonomyMassExpandCollapseStateFn:EMPTY_FUNC,setReduceFn:EMPTY_FUNC};$scope.contextMenuFns={startChangeArticleParent:$scope.wikiScope.startChangeArticleParent,setHomeArticle:$scope.wikiScope.setHomeArticle,startCopyArticle:$scope.wikiScope.startCopyArticle,startRenameArticle:$scope.wikiScope.startRenameArticle,deleteArticles:$scope.wikiScope.deleteArticles,startCreateChildArticle:parentNodeId=>$scope.wikiScope.newArticle(null,parentNodeId)};$scope.wikiScope.getRightClickMenuTemplate=function(node){let template=`<li>
            <a class="df aic" href="#" ng-click="contextMenuFns.startChangeArticleParent('`+node.id+`')">
                <i class="dku-icon-level-up-16 icon-fixed-width icon-flip-horizontal" /> Change parent article
            </a>
        </li>
        <li>
            <a class="df aic" href="#" ng-click="contextMenuFns.setHomeArticle('`+node.id+`');">
                <i class="dku-icon-home-16 icon-fixed-width" /> Set home article
            </a>
        </li>
        <li>
            <a class="df aic" href="#" ng-click="contextMenuFns.startCreateChildArticle('`+node.id+`');">
                <i class="dku-icon-plus-16 icon-fixed-width" /> Create article from here
            </a>
        </li>
        <li>
            <a class="df aic" href="#" ng-click="activateSortable();">
                <i class="dku-icon-arrow-double-vertical-16 icon-fixed-width" /> Move
            </a>
        </li>
        <li>
            <a class="df aic" href="#" ng-click="contextMenuFns.startCopyArticle('`+node.id+`')">
                <i class="dku-icon-copy-step-16 icon-fixed-width" /> Copy
            </a>
        </li>
        <li>
            <a class="df aic" href="#" ng-click="contextMenuFns.startRenameArticle('`+node.id+`')">
                <i class="dku-icon-edit-16 icon-fixed-width" /> Rename
            </a>
        </li>
        <li>
            <a href="#" ng-click="contextMenuFns.deleteArticles([{projectKey:'`+$stateParams.projectKey+`', id:'`+node.id+`'}])">
                <span class="df aic text-error">
                    <i class="dku-icon-trash-16 icon-fixed-width" /> Delete
                </span>
            </a>
        </li>`;return template};$scope.wikiScope.initNodes=function(nodes){nodes.forEach(function(node){let reduce=$scope.getUnfoldedNodeIdsFn().indexOf(node.id)==-1;$scope.wikiScope.treeViewHook.setReduceFn(node,reduce);if(node.children.length>0){$scope.wikiScope.initNodes(node.children)}})};let unwatch=$scope.$watch("wikiScope.treeViewHook.setReduceFn",function(nv,ov){if(nv&&typeof $scope.wikiScope.treeViewHook.setReduceFn==="function"&&$scope.wikiScope.treeViewHook.setReduceFn!=EMPTY_FUNC){$scope.wikiScope.initNodes($scope.wiki.taxonomy);$scope.wikiScope.treeViewHook.scrollToNodeFn($stateParams.articleId,0);unwatch()}})});app.controller("NewArticleModalController",function($scope,$stateParams,WT1,DataikuAPI,ActiveProjectKey){const parentArticleId=$stateParams.articleId?$scope.getParentId($stateParams.articleId):"";if(!$scope.newArticle){$scope.newArticle={}}$scope.newArticle.parent=parentArticleId;if($scope.newNotFoundArticle&&$scope.newNotFoundArticle.id){$scope.newArticle.id=$scope.newNotFoundArticle.id;delete $scope.newNotFoundArticle.id}else{delete $scope.newArticle.id}$scope.alreadyExistingArticleNames=[".",".."].concat(Object.values($scope.articleMapping));DataikuAPI.wikis.listTemplates().success(function(data){$scope.availableTemplates=data.templates;$scope.newArticle.template=$scope.availableTemplates[0]}).error(setErrorInScope.bind($scope));$scope.create=function(){WT1.event("article-create",{number_of_articles:$scope.articlesIds&&$scope.articlesIds.length});return DataikuAPI.wikis.createArticle(ActiveProjectKey.get(),$scope.newArticle.id,$scope.newArticle.parent,$scope.newArticle.template).success(function(article){$scope.resolveModal(article)}).error(setErrorInScope.bind($scope))}});app.controller("AddArticleAttachmentsModalController",function($scope,$stateParams,$timeout,WT1,DataikuAPI,TAGGABLE_TYPES,SmartId,ActiveProjectKey,executeWithInstantDigest){$scope.taggableTypes=TAGGABLE_TYPES;$scope.newAttachment={projectKey:ActiveProjectKey.get()};$scope.modalNav={tab:"DSS_OBJECT"};$scope.uiState={files:[],fileProperties:[]};$scope.addAttachment=function(){if($scope.newAttachment.taggableType=="PROJECT"){$scope.newAttachment.id=$scope.newAttachment.projectKey}const targetAttachment={};targetAttachment.smartId=SmartId.fromTor($scope.newAttachment,$stateParams.projectKey);targetAttachment.taggableType=$scope.newAttachment.taggableType;targetAttachment.attachmentType="DSS_OBJECT";if(targetAttachment.taggableType!=null){for(const att of $scope.article.attachments){if(targetAttachment.taggableType===att.taggableType&&targetAttachment.smartId===att.smartId){return $scope.resolveModal()}}$scope.article.attachments=$scope.article.attachments.concat([targetAttachment]);$scope.wikiScope.saveAttachment($scope.article,targetAttachment);WT1.event("article-add-attachment",{number_of_attachments:$scope.article.attachments.length,taggableType:targetAttachment.taggableType})}return $scope.resolveModal()};$scope.$watch("newAttachment.projectKey",function(nv){if(!nv)return;DataikuAPI.taggableObjects.listAccessibleObjects(nv).then(function(resp){const objList=resp.data;$scope.taggableTypesWithNoItems=TAGGABLE_TYPES.filter(t=>t!="PROJECT"&&!objList.find(obj=>obj.type==t))})});$scope.drop=function(files){WT1.event("article-drop-files",{number_of_files:files.length});for(let i=0;i<files.length;i++){$scope.uiState.files.push(files[i]);$scope.uiState.fileProperties.push({path:files[i].name,length:files[i].size,progress:0,uploaded:false})}};$scope.deleteFile=function(idx,e){e.preventDefault();e.stopPropagation();$scope.uiState.files.splice(idx,1);$scope.uiState.fileProperties.splice(idx,1)};$scope.uploadFilesAfterDigest=function(){$timeout(function(){uploadFiles()})};function uploadFiles(){$scope.wikiScope.fileUploadProperties=$scope.uiState.fileProperties;for(let idx=0;idx<$scope.uiState.files.length;++idx){uploadOneFile(idx)}}function uploadOneFile(idx){const fileToUpload=$scope.uiState.files[idx];DataikuAPI.wikis.upload(ActiveProjectKey.get(),$stateParams.articleId,fileToUpload,function(e){if(e.lengthComputable){executeWithInstantDigest(()=>{$scope.wikiScope.fileUploadProperties[idx].progress=Math.round(e.loaded*100/e.total)},$scope.wikiScope)}}).then(function(data){const articleWithRecentAttachment=angular.fromJson(data);$scope.wikiScope.article=articleWithRecentAttachment.article},setErrorInScope2.bind($scope.wikiScope)).finally(function(){$scope.wikiScope.fileUploadProperties[idx].uploaded=true});$scope.dismiss()}});app.controller("RenameArticleModalController",function($scope,$stateParams,WT1,DataikuAPI){DataikuAPI.wikis.getArticleSummary($stateParams.projectKey,$scope.tempArticleID).then(function(result){$scope.modifiedArticle=result.data.object},setErrorInScope.bind($scope));$scope.alreadyExistingArticleNames=[".",".."].concat(Object.values($scope.articleMapping));$scope.ok=function(){WT1.event("article-rename");return $scope.wikiScope.checkSaveArticle($scope.modifiedArticle,null,()=>$scope.resolveModal($scope.article.id))}});app.controller("ExportArticleModalController",function($scope,$stateParams,DataikuAPI,FutureProgressModal,ActivityIndicator,WT1){$scope.modalTitle="Export: "+$stateParams.articleName;$scope.params={exportType:"ARTICLE_AND_CHILDREN",exportFormat:{paperSize:"A4"},exportAttachments:false};$scope.doExportArticle=function(){const articleId=$scope.params.exportType==="WHOLE_WIKI"?null:$stateParams.articleId;const exportChildren=$scope.params.exportType==="ARTICLE_AND_CHILDREN";DataikuAPI.wikis.exportArticle($stateParams.projectKey,articleId,$scope.params.exportFormat,exportChildren,$scope.params.exportAttachments).error(setErrorInScope.bind($scope)).success(function(resp){WT1.event("wiki-export",{export:$scope.params.exportType,exportAttachments:$scope.params.exportAttachments});FutureProgressModal.show($scope,resp,"Wiki export").then(function(result){if(result){downloadURL(DataikuAPI.wikis.getExportURL(result.projectKey,result.exportId));ActivityIndicator.success("Wiki export downloaded!",5e3)}else{ActivityIndicator.error("Wiki export failed",5e3)}$scope.resolveModal()})})}});app.directive("wikiExportForm",function(GRAPHIC_EXPORT_OPTIONS){return{templateUrl:"/templates/wikis/wiki-export-form.html",scope:{params:"=",origin:"@"},link:function($scope){$scope.paperSizeMapPage=GRAPHIC_EXPORT_OPTIONS.paperSizeMapPage;$scope.params.exportFormat.paperSize="A4"}}});app.controller("CopyArticleModalController",function($scope,$stateParams,WT1,DataikuAPI,ActiveProjectKey){$scope.alreadyExistingArticleNames=[".",".."].concat(Object.values($scope.articleMapping));const copyArticleName=$scope.copyArticle.name;var i=0;while($scope.alreadyExistingArticleNames.includes($scope.copyArticle.name)){$scope.copyArticle.name=`${copyArticleName} ${++i}`}$scope.ok=function(){return DataikuAPI.wikis.copyArticle($stateParams.projectKey,$scope.copyArticle.name,$scope.copyArticle.parent,$scope.copyArticle.originalArticleId,!!$scope.withAttachments).success(function(article){$scope.resolveModal(article)}).error(setErrorInScope.bind($scope))}});app.controller("ChangeArticleParentModalController",function($scope,$stateParams,WT1,DataikuAPI,ActiveProjectKey){function getFilteredArticleList(siblings,id){let list=[];for(let i=0;i<siblings.length;i++){if(siblings[i].id!=id){list.push(siblings[i].id);list=list.concat(getFilteredArticleList(siblings[i].children||[],id))}}return list}const parentArticleId=$scope.tempArticleID?$scope.getParentId($scope.tempArticleID):"";$scope.newParent={id:parentArticleId,oldId:parentArticleId};$scope.filteredArticlesIds=$scope.tempArticleID?getFilteredArticleList($scope.wiki.taxonomy||[],$scope.tempArticleID):$scope.articlesIds;$scope.ok=function(parentId){WT1.event("article-change-parent");return DataikuAPI.wikis.changeArticleParent(ActiveProjectKey.get(),$scope.tempArticleID,parentId).success(function(){$scope.resolveModal()}).error(setErrorInScope.bind($scope))}});app.controller("_WikiSearch",function($scope,$stateParams,$controller,$q,DataikuAPI,ActiveProjectKey){const facets={scope:["dss"],"projectKey.raw":[ActiveProjectKey.get()],_type:["article"]};function searchEndpoint(queryString){if(!queryString){$scope.results=null;return}return DataikuAPI.catalog.search.call(this,queryString,facets).success(function(results){$scope.results=results})}$controller("_CatalogControllerBase",{$scope:$scope,searchEndpoint:searchEndpoint});$scope.linkToCatalog=function(){return`/search-dss-items/scope=dss&_type=Article&projectKey.raw=${ActiveProjectKey.get()}&q=${$scope.query.queryString}&_type=article`}});app.directive("articleRightColumnSummary",function($controller,$state,DataikuAPI){return{templateUrl:"/templates/wikis/article-right-column-summary.html",link:function(scope,element,attrs){$controller("_TaggableObjectsMassActions",{$scope:scope});$controller("_TaggableObjectsCapabilities",{$scope:scope});scope.refreshData=function(){DataikuAPI.wikis.getArticleSummary(scope.selection.selectedObject.projectKey,scope.selection.selectedObject.name).success(function(data){scope.articleData=data;scope.article=data.article}).error(setErrorInScope.bind(scope))};scope.$watch("selection.selectedObject",function(nv,ov){if(!nv)return;scope.articleData={article:nv,timeline:{}};if(scope.selection.confirmedItem!=scope.selection.selectedObject){scope.article=null}scope.articleHref=$state.href("projects.project.wiki.article.view",{projectKey:scope.selection.selectedObject.projectKey,articleId:scope.selection.selectedObject.name})});scope.$watch("selection.confirmedItem",function(nv,ov){if(!nv){return}scope.refreshData()})}}})})();(function(){"use strict";var app=angular.module("dataiku.services");app.factory("HistoryService",["$rootScope","$stateParams","LocalStorage","TopNav","Logger","TAGGABLE_TYPES","MLUtilsService",function($rootScope,$stateParams,LocalStorage,TopNav,Logger,TAGGABLE_TYPES,MLUtilsService){function getHistory(){var dssHistory=LocalStorage.get("dssHistory");if(dssHistory&&dssHistory.dss_history_version!=2){Logger.warn("flush old local dss history");dssHistory={dss_history_version:2};LocalStorage.set("dssHistory",dssHistory)}dssHistory=dssHistory||{};var user=$rootScope.appConfig.login;return dssHistory[user]||{}}function truncateUserHistoryList(userHistory){const maximumSize=60;const clearedSize=30;const keepProjDbdTarget=5;if(Object.keys(userHistory).length>maximumSize){let items=Object.keys(userHistory).map(function(key){return userHistory[key]});items=sortByLastView(items);userHistory={};let projectsCount=0;let dashboardsCount=0;let keptCount=0;items.forEach(function(item){let keep=keptCount<clearedSize;if(!keep&&item.type=="PROJECT")keep=++projectsCount<=keepProjDbdTarget;if(!keep&&item.type=="DASHBOARD")keep=++dashboardsCount<=keepProjDbdTarget;if(keep){keptCount++;userHistory[getKey(item)]=item}})}return userHistory}function clean(userHistory){if(userHistory.hasOwnProperty("undefined")){delete userHistory["undefined"]}}function cleanOldWikiArticles(userHistory,savedItem){if(savedItem.type!=="ARTICLE")return;Object.keys(userHistory).forEach(function(key){const item=userHistory[key];if(item.type==="ARTICLE"&&item.projectKey===savedItem.projectKey){delete userHistory[key]}})}function persist(userHistory){clean(userHistory);userHistory=truncateUserHistoryList(userHistory);var dssHistory=LocalStorage.get("dssHistory")||{};var user=$rootScope.appConfig.login;dssHistory[user]=userHistory;LocalStorage.set("dssHistory",dssHistory)}function doSave(item,incrementView,incrementUpdate,updateLastViewed){let key=getKey(item);if(String(key)==="undefined")return;let dssHistory=getHistory();let savedItem=dssHistory[key];let views=0;let data={};let updates=0;if(savedItem){views=savedItem.views;data=savedItem.data;updates=savedItem.updates}savedItem=$.extend(savedItem,item,{views:views+(incrementView?1:0),updates:updates+(incrementUpdate?1:0),lastViewed:!savedItem?Date.now():updateLastViewed?Date.now():savedItem.lastViewed,lastUpdated:!savedItem?0:incrementUpdate?Date.now():savedItem.lastUpdated});if(item.data.loading){savedItem.data=data}else{savedItem.data=$.extend({},data,savedItem.data)}savedItem.displayName=savedItem.data.name||savedItem.displayName;savedItem.subtype=getSubtype(item)||savedItem.subtype;if(!savedItem.projectKey)savedItem.projectKey=$stateParams.projectKey;cleanOldWikiArticles(dssHistory,savedItem);dssHistory[key]=savedItem;persist(dssHistory)}function saveItem(item){doSave(item,true,false,true)}function saveItemWithoutViewIncrement(item){doSave(item,false,false,true)}function getKey(item){var projectKey=item.projectKey||$stateParams.projectKey;var type=item.type?item.type:"";return projectKey+":"+type+":"+item.id}function getSubtype(item){if(!item||!item.data){return}if(["JUPYTER_NOTEBOOK","SQL_NOTEBOOK","SEARCH_NOTEBOOK","ANALYSIS"].includes(item.type)){return item.type}else if(item.type==="SAVED_MODEL"){return MLUtilsService.getMLCategory(item.data.taskType,item.data.backendType,item.data.predictionType,item.data.savedModelType,item.data.proxyModelProtocol||item.data.externalSavedModelType)}var data=item.data;return data.datasetType||data.recipeType||data.type}var trackedType=TAGGABLE_TYPES;function isTracked(item){if(item.data&&item.data.dummy){return false}return trackedType.indexOf(item.type)>=0}function hasUpdatedData(itemOld,itemNew){if(!itemNew.data||itemNew.data.loading){return false}else if(!itemOld.data){return true}else{return!angular.equals(itemOld.data,$.extend({},itemOld.data,itemNew.data))}}function onItemChange(item){if(item&&item.id&&(item.displayName||item.data&&item.data.name)&&isTracked(item)){if(!TopNav.sameItem(currentItem,item)){saveItem(item)}else if(hasUpdatedData(currentItem,item)){saveItemWithoutViewIncrement(item)}}currentItem=item}function sort(items,fn){function compare(a,b){var fa=fn(a),fb=fn(b);if(fa<fb)return 1;if(fa>fb)return-1;return 0}return items.sort(compare)}function sortByLastView(items){return sort(items,function(item){return item.lastViewed})}function sortByMostViewed(items){return sort(items,function(item){return item.views})}var currentItem=$rootScope.topNav.item;$rootScope.$watch("topNav.item",onItemChange,true);onItemChange(currentItem);function getRecentlyViewedItems(n,requestedType,requestedProject,includeCurrentItem){if(requestedType=="ANY"){requestedType=null}var dssHistory=getHistory();let items=Object.keys(dssHistory).map(function(key){return dssHistory[key]});items=sortByLastView(items);if($rootScope.topNav.item||requestedType){items=items.filter(function(item){if(!includeCurrentItem&&$rootScope.topNav.item&&getKey(item)==getKey($rootScope.topNav.item)){return false}if(requestedProject&&item.projectKey!=requestedProject){return false}item.key=getKey(item);return!requestedType||requestedType=="ANY"||requestedProject&&item.type=="PROJECT"||requestedType==item.type||requestedType=="NOTEBOOK"&&(item.type=="SQL_NOTEBOOK"||item.type=="JUPYTER_NOTEBOOK")})}return items.slice(0,n)}function notifyRenamed(oldItem,newName){if(!oldItem)return;var newType=oldItem.type;var newId=oldItem.id;var newProjectKey=oldItem.projectKey;if(!newId||!newType||!newProjectKey){return}var oldKey=getKey(oldItem);var dssHistory=getHistory();var savedItem=dssHistory[oldKey]||{};if(newType=="DATASET"||newType=="RECIPE"){newId=newName}savedItem.id=newId;savedItem.displayName=newName;var newKey=getKey({type:newType,id:newId,projectKey:newProjectKey});if(oldKey!=newKey){delete dssHistory[oldKey]}dssHistory[newKey]=savedItem;persist(dssHistory);if(TopNav.sameItem(oldItem,currentItem)){currentItem.id=newId;currentItem.displayName=newName}}function notifyRemoved(item,impact){var key=getKey(item);var dssHistory=getHistory();if(dssHistory.hasOwnProperty(key)){delete dssHistory[key]}if(impact){if(impact.deletedRecipes){impact.deletedRecipes.forEach(function(recipe){var key=getKey({type:"RECIPE",id:recipe.name,projectKey:recipe.projectKey});if(dssHistory.hasOwnProperty(key)){delete dssHistory[key]}})}if(impact.deletedAnalyses){impact.deletedAnalyses.forEach(function(analysis){var key=getKey({type:"ANALYSIS",id:analysis.id,projectKey:analysis.projectKey});if(dssHistory.hasOwnProperty(key)){delete dssHistory[key]}})}}persist(dssHistory)}function itemUpdated(method,data){const ignoredAction=["/get","pop-","/refresh","/prepare","/check","/search"].find(s=>method.indexOf(s)>=0);if(ignoredAction||!currentItem||!currentItem.hasOwnProperty("data")||currentItem.data==null||currentItem.id=="New dataset"){return}doSave(currentItem,false,true,true)}function itemEnriched(item){doSave(item,false,false,false)}function projectOpened(project){saveItem({projectKey:project.projectKey,id:project.projectKey,type:"PROJECT",data:project});if(currentItem&&currentItem.type==="PROJECT"&&currentItem.id===project.projectKey){currentItem.data=project}}return{getRecentlyViewedItems:getRecentlyViewedItems,notifyRenamed:notifyRenamed,notifyRemoved:notifyRemoved,recordItemPost:itemUpdated,recordProjectOpen:projectOpened,recordEnrichment:itemEnriched}}])})();(function(){"use strict";const app=angular.module("dataiku.widgets.tageditfield",["dataiku.services"]);app.service("TagEditService",function(TaggingService){const svc=this;let allTags={};let filteredTags={};let globalTagsCategory;let tags;this.setTags=function(tagsMap){tags=tagsMap};this.setActiveCategory=function(category){globalTagsCategory=category;return globalTagsCategory};this.unSelectedDropDownIdx=function(){return filteredTags.isExactMatch&&filteredTags.items.length&&filteredTags.items[0].isMatch?0:undefined};function adjustDropDownIndex(ui){if(!isNaN(ui.dropDownIndex)){if(filteredTags.length===0){ui.dropDownIndex=undefined}else if(ui.dropDownIndex>filteredTags.length-1){ui.dropDownIndex=Math.max(filteredTags.length-1,0)}}if(isNaN(ui.dropDownIndex)){ui.dropDownIndex=svc.unSelectedDropDownIdx(filteredTags)}return ui}function flagSelectedItems(){if(!tags)return;Object.keys(allTags).forEach((tagTitle,index)=>{allTags[tagTitle].selected=false});tags.forEach(tagTitle=>{const tagDetails=allTags[tagTitle];if(tagDetails){tagDetails.selected=true}});return allTags}this.updateDropListOnTagChange=function(uiState,objectType){allTags=flagSelectedItems(allTags);filteredTags=svc.filterTagListByInput(allTags,uiState.newTag,objectType);uiState=adjustDropDownIndex(filteredTags,uiState);return{allTags:allTags,filteredTags:filteredTags,uiState:uiState}};function isInputMatchingSelectedTag(input){const inputLower=input.toLowerCase();return!tags||!tags.every(tagTitle=>tagTitle.toLowerCase()!=inputLower)}this.filterTagListByInput=function(allTagsMap,newTag,objectType){allTags=allTagsMap;const list=[];const selectedList=[];const input=newTag.toLowerCase();const globalTagsCategories=[];const inputWithGlobalTagCat=globalTagsCategory?`${globalTagsCategory.toLowerCase()}:${input}`:input;let isExactMatch=false;if(allTags){Object.keys(allTags).forEach((tagTitle,index)=>{const tag=allTags[tagTitle];if(!tag.lowerTitle)tag.lowerTitle=tagTitle.toLowerCase();const isMatch=input===tag.lowerTitle;isExactMatch|=isMatch;const shouldGlobalTagBeListed=!globalTagsCategory||globalTagsCategory==tag.globalTagsCategory;if(tag.selected&&shouldGlobalTagBeListed&&(!input||tag.lowerTitle.startsWith(input)||tag.lowerTitle.startsWith(inputWithGlobalTagCat))){selectedList.push({title:tagTitle,color:tag.color,globalTagsCategory:tag.globalTagsCategory,match:isMatch})}if(!tag.selected&&shouldGlobalTagBeListed&&(!input||tag.lowerTitle.startsWith(input)||tag.lowerTitle.startsWith(inputWithGlobalTagCat))){list.push({title:tagTitle,color:tag.color,globalTagsCategory:tag.globalTagsCategory,match:isMatch})}if(!tag.selected&&tag.globalTagsCategory&&!globalTagsCategories.includes(tag.globalTagsCategory)&&TaggingService.shouldGlobalTagApply(tag.appliesTo,objectType)){globalTagsCategories.push(tag.globalTagsCategory)}})}const isSelectedTag=isInputMatchingSelectedTag(input);const canCreateItem=!!input&&!isExactMatch&&!isSelectedTag&&!globalTagsCategory;filteredTags={items:list.sort((a,b)=>a.title.localeCompare(b.title)),selectedItems:selectedList.sort((a,b)=>a.title.localeCompare(b.title)),createItem:canCreateItem?newTag:undefined,length:canCreateItem?list.length+1:list.length,isExactMatch:isExactMatch,isSelectedTag:isSelectedTag,globalTagsCategories:globalTagsCategories};return filteredTags};this.initUiState=function(){return{newTag:""}}});app.directive("tagField",function($timeout,$rootScope,translate,CreateModalFromTemplate,TaggingService,TagEditService){return{templateUrl:"/templates/taggable-objects/tag-edit-field.html",restrict:"E",scope:{getAllTags:"&?",tags:"=ngModel",objectType:"=?",savedTags:"=?",isEditing:"=?",onStartEdit:"&?",onCancelEdit:"&?",onSaveEdit:"&?",editable:"=?",saveBtnText:"@?",manageLink:"="},link:function(scope,element,attrs){scope.translate=translate;scope.allTags={};if(typeof scope.editable=="undefined"){scope.editable=true;scope.isEditing=false}if(typeof scope.saveBtnText=="undefined"){scope.saveBtnText=translate("GLOBAL.BUTTONS.SAVE","Save")}if(typeof scope.savedTags=="undefined"){scope.savedTags=angular.copy(scope.tags)}if(typeof scope.onStartEdit=="undefined"){scope.onStartEdit=function(){setTagIdxToLastTag();scope.isEditing=true};scope.onCancelEdit=function(){scope.tags=angular.copy(scope.savedTags);scope.isEditing=false};scope.onSaveEdit=function(){if(scope.isEditing){scope.savedTags=angular.copy(scope.tags);scope.isEditing=false}}}if($rootScope.activeProjectTagColor){scope.tagColor=$rootScope.activeProjectTagColor}else{scope.tagColor=function(){return"#999"}}scope.provideDropDown=scope.getAllTags!=undefined;scope.allowManageTags=scope.manageLink==undefined||scope.manageLink;scope.uiState=TagEditService.initUiState();function setTagIdxToLastTag(){scope.uiState.tagIndex=scope.tags?scope.tags.length-1:undefined}function reInitTagIndex(){if(scope.uiState.newTag){scope.uiState.tagIndex=undefined}else{if(isNaN(scope.uiState.tagIndex)){$timeout(setTagIdxToLastTag,1200)}}}function updateDropListOnTagChange(){if(!scope.provideDropDown)return;const data=TagEditService.updateDropListOnTagChange(scope.uiState,scope.objectType);scope.allTags=data.allTags;scope.filteredTags=data.filteredTags;scope.uiState=Object.assign(scope.uiState,data.uiState);reInitTagIndex()}var getInput=()=>element.find(".tag-editor-input");var setInputFocus=()=>getInput().focus();function eatEvent(e){e.stopPropagation();e.preventDefault()}function applyManageTagsChanges(existingList,newAllTags){const newTags=[];existingList.forEach(tag=>{if(newAllTags[tag]){if(newAllTags[tag].updatedTagName){newTags.push(newAllTags[tag].updatedTagName)}else{newTags.push(tag)}}else if(!scope.allTags[tag]){newTags.push(tag)}});return newTags}function handleManageTagsComplete(newAllTags){if(newAllTags){scope.tags=applyManageTagsChanges(scope.tags,newAllTags);scope.savedTags=applyManageTagsChanges(scope.savedTags,newAllTags)}setTagIdxToLastTag();$timeout(setInputFocus,100)}scope.cancelEdit=function(e){eatEvent(e);scope.onCancelEdit()};scope.saveEdit=function(e){eatEvent(e);scope.onSaveEdit()};scope.deleteTag=function(isBackspace,idx){let index=idx;if(index===null||index===undefined)index=scope.uiState.tagIndex;if(!isNaN(index)){scope.tags.splice(index,1);scope.uiState.tagIndex=Math.max(index-(isBackspace?1:0),0);setInputFocus()}updateDropListOnTagChange()};scope.isCreateTagSelected=function(idx){return scope.filteredTags.createItem&&idx==scope.filteredTags.length-1};scope.scrollToInput=function(){$timeout(()=>{const $div=getInput().parent();if($div.length>0)$div[0].scroll({top:0,left:1e4,behavior:"smooth"})},10)};scope.dropListLeft=function(){if(scope.elTags==undefined||!scope.elTags.width()){scope.elTags=$(element).find(".tags");scope.elInput=$(element).find(".tag-editor-input");scope.elDropList=$(element).find(".tag-pick-options");scope.elOuter=$(element).find(".tag-edit-field")}let left=Math.max(scope.elTags.width()-scope.elInput.width(),0);left=Math.min(left,scope.elOuter.width()-scope.elDropList.width()-scope.elTags.position().left);return left};scope.addTag=function(idx){let added=false;if(!isNaN(idx)){if(scope.isCreateTagSelected(idx)){scope.tags.push(scope.filteredTags.createItem)}else{scope.tags.push(scope.filteredTags.items[idx].title)}added=true;updateDropListOnTagChange();scope.uiState.newTag="";setTagIdxToLastTag();scope.scrollToInput()}return added};scope.$watch("uiState.newTag",function(nv,ov){scope.filteredTags=TagEditService.filterTagListByInput(scope.allTags,scope.uiState.newTag,scope.objectType);reInitTagIndex();scope.uiState.dropDownIndex=TagEditService.unSelectedDropDownIdx();if(nv!="")scope.uiState.tagIndex=undefined});scope.$watch("tags",function(nv,ov){if(!nv)return;if(!ov)setTagIdxToLastTag();TagEditService.setTags(scope.tags);updateDropListOnTagChange()});scope.$watch("allTags",function(nv,ov){scope.filteredTags=TagEditService.filterTagListByInput(scope.allTags,scope.uiState.newTag,scope.objectType);reInitTagIndex();if(scope.tags)updateDropListOnTagChange()});scope.$on("tagFieldAddTag",function(event,callback){if(callback)callback()});scope.onSelectTag=function(e,idx){scope.uiState.tagIndex=idx};scope.globalTags=TaggingService.getGlobalTags(scope.objectType);Object.assign(scope.allTags,scope.globalTags);scope.onStartTagEdit=function(e,category){TagEditService.initUiState();scope.globalTagsCategory=TagEditService.setActiveCategory(category);if(scope.getAllTags){scope.provideDropDown=false;scope.getAllTags().then(d=>{scope.provideDropDown=true;scope.allTags=Object.assign(d,scope.globalTags)})}scope.onStartEdit()};scope.onDropdownClick=function(e,idx){eatEvent(e);if(isNaN(idx))return;scope.addTag(idx);setInputFocus();scope.uiState.dropDownIndex=TagEditService.unSelectedDropDownIdx()};scope.onDropdownKeydown=function(e,idx){if(e.keyCode==13){scope.addTag(idx);setInputFocus();eatEvent(e)}};scope.manageTags=function(){CreateModalFromTemplate("/templates/widgets/edit-tags-modal.html",scope,null,function(modalScope){modalScope.translate=translate;modalScope.tagsDirty=angular.copy(scope.allTags);modalScope.save=function(){handleManageTagsComplete(modalScope.tagsDirty);TaggingService.saveToBackend(modalScope.tagsDirty).then(()=>{if(scope.getAllTags){scope.getAllTags().then(d=>scope.allTags=d)}modalScope.resolveModal()}).catch(setErrorInScope.bind(modalScope))};modalScope.cancel=function(){handleManageTagsComplete();modalScope.dismiss()}})};function onDownArrow(ui){if(isNaN(ui.dropDownIndex)){ui.dropDownIndex=0}else{ui.dropDownIndex=Math.min(ui.dropDownIndex+1,scope.filteredTags.length-1)}return true}function onUpArrow(ui){scope.uiState.dropDownIndex=isNaN(ui.dropDownIndex)||ui.dropDownIndex<=0?TagEditService.unSelectedDropDownIdx():ui.dropDownIndex-1;return true}function onLeftArrow(ui){let eventDone=true;if(!isNaN(ui.tagIndex)){ui.tagIndex=Math.max(ui.tagIndex-1,0)}else if(ui.newTag.length===0){ui.tagIndex=scope.tags.length-1}else{eventDone=false}return eventDone}function onRightArrow(ui){let eventDone=false;if(!isNaN(ui.tagIndex)){ui.tagIndex=ui.tagIndex+1;if(ui.tagIndex>=scope.tags.length){ui.tagIndex=scope.tags.length-1;scope.scrollToInput()}eventDone=true}return eventDone}function onDeleteKey(ui){let eventDone=false;if(ui.newTag.length==0){scope.deleteTag(true);eventDone=true}return eventDone}function onEnterKey(ui){let idx=ui.dropDownIndex;const tags=scope.filteredTags;if(isNaN(idx)&&tags.createItem!=undefined)idx=tags.length-1;if(isNaN(idx)&&tags.items.length>0&&tags.items[0].match)idx=0;if(isNaN(idx)){if(ui.newTag=="")scope.onSaveEdit()}else{scope.addTag(idx)}return true}scope.onInputKeydown=function(e){const ui=scope.uiState;let eventDone=false;switch(e.keyCode){case 40:eventDone=onDownArrow(ui);break;case 38:eventDone=onUpArrow(ui);break;case 37:eventDone=onLeftArrow(ui);break;case 39:eventDone=onRightArrow(ui);break;case 8:eventDone=onDeleteKey(ui);break;case 13:eventDone=onEnterKey(ui);break;default:break}if(eventDone)eatEvent(e)}}}});app.directive("tagEditPopover",function($timeout,$rootScope,translate,CreateModalFromTemplate,TaggingService,TagEditService){return{templateUrl:"/templates/taggable-objects/tag-edit-popover.html",restrict:"E",scope:{tags:"=ngModel",getAllTags:"&?",objectType:"=?",manageLink:"=",noTagIcon:"<",editable:"=?",responsive:"=?",tagsTooltip:"<"},link:function(scope,element,attrs){scope.translate=translate;scope.allTags={};if(typeof scope.editable=="undefined"){scope.editable=true}function onStartEdit(){setTagIdxToLastTag();scope.isEditing=true}function onSaveEdit(){scope.isEditing=false;if(scope.edited){scope.$emit("objectSummaryEdited");scope.edited=false}}if($rootScope.activeProjectTagColor){scope.tagColor=$rootScope.activeProjectTagColor}else{scope.tagColor=TaggingService.getTagColor}if(!scope.getAllTags){scope.tags.forEach(tag=>{scope.allTags[tag]={color:scope.tagColor(tag)}})}function initUiState(){scope.uiState={newTag:""}}scope.allowManageTags=scope.manageLink==undefined||scope.manageLink;initUiState();function setTagIdxToLastTag(){scope.uiState.tagIndex=scope.tags?scope.tags.length-1:undefined}function reInitTagIndex(){if(scope.uiState.newTag){scope.uiState.tagIndex=undefined}else{if(isNaN(scope.uiState.tagIndex)){$timeout(setTagIdxToLastTag,1200)}}}function updateDropListOnTagChange(){TagEditService.setTags(scope.tags);const data=TagEditService.updateDropListOnTagChange(scope.uiState,scope.objectType);scope.allTags=data.allTags;scope.filteredTags=data.filteredTags;scope.uiState=Object.assign(scope.uiState,data.uiState);reInitTagIndex()}var getInput=()=>element.find(".tag-edit-filter__input");var setInputFocus=()=>getInput().focus();function eatEvent(e){if(e){e.stopPropagation();e.preventDefault()}}function applyManageTagsChanges(existingList,newAllTags){const newTags=[];existingList.forEach(tag=>{if(newAllTags[tag]){if(newAllTags[tag].updatedTagName){newTags.push(newAllTags[tag].updatedTagName)}else{newTags.push(tag)}}else if(!scope.allTags[tag]){newTags.push(tag)}});return newTags}function handleManageTagsComplete(newAllTags){if(newAllTags){scope.tags=applyManageTagsChanges(scope.tags,newAllTags)}setTagIdxToLastTag();$timeout(setInputFocus,100)}scope.getTagTooltip=function(tagName){if(!scope.tagsTooltip){return""}if(!scope.tagsTooltip[tagName]){return""}return scope.tagsTooltip[tagName]};scope.saveEdit=function(e){$("html").off("click.tagEdit");eatEvent(e);onSaveEdit()};scope.deleteTag=function(isBackspace,index=scope.uiState.tagIndex,isSelected){if(!isNaN(index)){scope.tags.splice(index,1);scope.uiState.tagIndex=Math.max(index-(isBackspace?1:0),0);setInputFocus()}updateDropListOnTagChange();scope.edited=true;if(isSelected){scope.saveEdit(isBackspace)}};function isCreateTagSelected(idx){return scope.filteredTags.createItem&&idx==scope.filteredTags.length-1}scope.addTag=function(idx){let added=false;if(!isNaN(idx)){if(isCreateTagSelected(idx)){scope.tags.push(scope.filteredTags.createItem);scope.allTags[scope.filteredTags.createItem]={title:scope.filteredTags.createItem,color:TaggingService.getTagColor(scope.filteredTags.createItem)}}else{scope.tags.push(scope.filteredTags.items[idx].title)}scope.edited=true;added=true;updateDropListOnTagChange();scope.uiState.newTag="";setTagIdxToLastTag()}return added};scope.$watch("uiState.newTag",function(nv,ov){if(scope.editable){scope.filteredTags=TagEditService.filterTagListByInput(scope.allTags,scope.uiState.newTag,scope.objectType);reInitTagIndex();scope.uiState.dropDownIndex=TagEditService.unSelectedDropDownIdx();if(nv!==""){scope.uiState.tagIndex=undefined}}});scope.$watch("tags",function watchTags(nv,ov){if(scope.editable){if(!nv)return;if(!ov)setTagIdxToLastTag();TagEditService.setTags(scope.tags);updateDropListOnTagChange()}});scope.$watch("globalTagsCategory",function watchGlobalTagsCategory(nv,ov){if(scope.editable){if(nv==ov)return;updateDropListOnTagChange()}});scope.$watch("allTags",function watchallTags(nv,ov){if(scope.editable){scope.filteredTags=TagEditService.filterTagListByInput(scope.allTags,scope.uiState.newTag,scope.objectType);reInitTagIndex();if(scope.tags)updateDropListOnTagChange()}});function setAllTags(){if(scope.getAllTags){scope.getAllTags().then(data=>{scope.allTags=Object.assign(data,scope.globalTags)})}}setAllTags();scope.globalTags=TaggingService.getGlobalTags(scope.objectType);Object.assign(scope.allTags,scope.globalTags);scope.onStartTagEdit=function(e,category){if(!scope.editable||e.target.classList.contains("responsive-tags-list__tag-button")){return}initUiState();scope.globalTagsCategory=TagEditService.setActiveCategory(category);setAllTags();onStartEdit();setInputFocus();window.setTimeout(()=>{$("html").on("click.tagEdit",function(event){const filterTagPopover=function(node){return Array.prototype.indexOf.call(node.classList||[],"tag-edit-popover__popover")>=0};const filterManageTagsModal=function(node){return Array.prototype.indexOf.call(node.classList||[],"edit-tags-modal")>=0||Array.prototype.indexOf.call(node.classList||[],"modal-backdrop")>=0};const path=event.originalEvent&&(event.originalEvent.path||event.originalEvent.composedPath&&event.originalEvent.composedPath());const isEventFromTagPopover=path&&path.filter(filterTagPopover).length>0;const isEventFromManageTagsModal=path&&path.filter(filterManageTagsModal).length>0;if(isEventFromTagPopover||isEventFromManageTagsModal){return}scope.$apply(function(){scope.saveEdit(event)})})},0)};scope.onDropdownClick=function(e,idx,selected){eatEvent(e);if(isNaN(idx))return;if(selected){const idxUnfilteredTags=scope.tags.indexOf(scope.filteredTags.selectedItems[idx].title);scope.deleteTag(e,idxUnfilteredTags)}else{scope.addTag(idx)}setInputFocus();scope.uiState.dropDownIndex=TagEditService.unSelectedDropDownIdx()};scope.onDropdownKeydown=function(e,idx){if(e.keyCode==13){if(idx<scope.filteredTags.selectedItems.length){const idxUnfilteredTags=scope.tags.indexOf(scope.filteredTags.selectedItems[idx].title);scope.deleteTag(e,idxUnfilteredTags)}else{scope.addTag(idx-scope.filteredTags.selectedItems.length)}setInputFocus();eatEvent(e)}};scope.manageTags=function(){onSaveEdit();CreateModalFromTemplate("/templates/widgets/edit-tags-modal.html",scope,null,modalScope=>{modalScope.translate=translate;modalScope.tagsDirty=angular.copy(scope.allTags);modalScope.save=function(){handleManageTagsComplete(modalScope.tagsDirty);TaggingService.saveToBackend(modalScope.tagsDirty).then(()=>{if(scope.getAllTags){scope.getAllTags().then(d=>scope.allTags=d)}modalScope.resolveModal()}).catch(setErrorInScope.bind(modalScope))};modalScope.cancel=function(){handleManageTagsComplete();modalScope.dismiss()}})};function onDownArrow(ui){ui.dropDownIndex=isNaN(ui.dropDownIndex)?0:Math.min(ui.dropDownIndex+1,scope.filteredTags.length+scope.filteredTags.selectedItems.length-1);return true}function onUpArrow(ui){scope.uiState.dropDownIndex=isNaN(ui.dropDownIndex)||ui.dropDownIndex<=0?TagEditService.unSelectedDropDownIdx():ui.dropDownIndex-1;return true}function onDeleteKey(ui){let eventDone=false;if(ui.newTag.length==0){scope.deleteTag(true);eventDone=true}return eventDone}function onEnterKey(ui){let idx=ui.dropDownIndex;const tagsList=[...scope.filteredTags.selectedItems,...scope.filteredTags.items];if(isNaN(idx)&&scope.filteredTags.createItem!=undefined)idx=tagsList.length;if(isNaN(idx)&&tagsList.length>0)idx=tagsList.findIndex(tag=>tag.match);if(isNaN(idx)||idx<0){if(ui.newTag=="")scope.saveEdit()}else if(idx<scope.filteredTags.selectedItems.length){const idxUnfilteredTags=scope.tags.indexOf(scope.filteredTags.selectedItems[idx].title);scope.deleteTag(false,idxUnfilteredTags)}else{scope.addTag(idx-scope.filteredTags.selectedItems.length)}return true}scope.onInputKeydown=function(e){const ui=scope.uiState;let eventDone=false;switch(e.keyCode){case 40:eventDone=onDownArrow(ui);break;case 38:eventDone=onUpArrow(ui);break;case 8:eventDone=onDeleteKey(ui);break;case 13:eventDone=onEnterKey(ui);break;default:break}if(eventDone)eatEvent(e)};let saveOnDestroy=scope.$on("$destroy",e=>{scope.saveEdit()})}}})})();(function(){"use strict";const app=angular.module("dataiku.catalog",[]);app.service("CatalogUtils",function(){const svc=this;function escape(str){return str.replace(/\\/g,"\\\\").replace(/&/g,"\\&").replace(/\+/g,"\\+")}this.getHash=function(queryString,facets){const hash=[];if(queryString){hash.push("q="+escape(queryString))}for(const facet in facets){const filters=facets[facet].filter(f=>["string","number"].includes(typeof f)).map(String).filter(f=>f!=="").map(escape);if(filters.length===0){continue}hash.push(facet+"="+filters.join("+"))}return hash.join("&")};this.getLink=function(queryString,facets,projectKey){facets.projectKey=[projectKey];return"/catalog/#"+svc.getHash(queryString,facets)};this.parseHash=function($scope,hash){if(!hash)return;const params=hash.match(/(\\&|[^&])+/g);const result={};angular.forEach(params,function(param){const parts=param.split("=");if(parts.length<2)return;const key=parts[0];const value=parts.slice(1).join("").replace(/\\&/g,"&");result[key]=value;if(key=="q"){$scope.query.queryString=value.replace(/\\\+/g,"+")}else{const values=value.match(/(\\\+|[^+])+/g);$scope.query.facets[key]=values.map(str=>str.replace(/\\\+/,"+"))}});return result}});app.service("CatalogTypes",function(){this.getCatalogType=function(taggableType){if(!taggableType)return taggableType;const t=taggableType.toLowerCase();if(t.includes("notebook")){return"notebook"}return t}});app.controller("_CatalogControllerBase",function($state,$stateParams,$scope,searchEndpoint,$controller,$filter,Debounce,CatalogUtils,WT1,$timeout,TopNav,TaggingService){let justDone=false;$scope.loadMoreItems=function(){if(!justDone&&$scope.listItems&&$scope.maxItems<$scope.listItems.length){$scope.maxItems+=20;justDone=true;setTimeout(function(){justDone=false},300)}};$scope.filterSortAndLimitItems=function(){$scope.formatted_items=$filter("orderBy")($scope.listItems,$scope.sortOptions.column,$scope.sortOptions.reverse)};$scope.selection={};$scope.listItems=[];$scope.facetsCollapse={};$scope.facetsShowAll={};$scope.facetsFilters={};$scope.query={queryString:"",facets:{}};CatalogUtils.parseHash($scope,$stateParams.hash);$scope.sortOptions={column:"_score",reverse:true};$scope.canShowSearchResults=function(){return $scope.notReady||$scope.disabled||$scope.listItems===undefined||$scope.formatted_items===undefined||$scope.formatted_items.length!==0};let firstTimeRedirect=true;let displayedSearchEtag=0;let latestSearchEtag=0;$scope.search=function(){const searchEtag=++latestSearchEtag;$scope.facetsShowAll["_type"]=false;if($state.current.name.includes("catalog")){if(firstTimeRedirect){$state.go(".",{hash:CatalogUtils.getHash($scope.query.queryString,$scope.query.facets)},{notify:false,location:"replace"});firstTimeRedirect=false}else{$state.go(".",{hash:CatalogUtils.getHash($scope.query.queryString,$scope.query.facets)},{notify:false})}}delete $scope.formatted_items;const before=(new Date).getTime();const promise=searchEndpoint($scope.query.queryString,$scope.query.facets);if(!promise){return}promise.then(function(resp){let results;if(resp.data&&resp.data.results){results=resp.data.results}else{results=resp.data}$scope.notReady=false;$scope.disabled=false;if(searchEtag<=displayedSearchEtag){return}const after=(new Date).getTime();getDigestTime($scope,function(time){WT1.event("catalog-search-done",{searchTime:after-before,digestTime:time})});if(!results.aggregations){results.aggregations={}}addFacets(results.aggregations);$scope.error=false;$scope.results=results;$scope.listItems=results.hits.hits;$scope.filterSortAndLimitItems();displayedSearchEtag=searchEtag}).catch(function(error){if(error.status===503&&error.data.errorType==="NotReady"){$scope.notReady=true;$timeout($scope.search,5e3)}else if(error.status===503&&error.data.errorType==="Disabled"){$scope.notReady=false;$scope.disabled=true}else{$scope.notReady=false;$scope.error=true}})};function addFacets(aggs){for(const field in aggs){angular.forEach($scope.query.facets[field],function(value){if(!aggs[field].agg.buckets.filter(function(bucket){return bucket.key==value}).length){aggs[field].agg.buckets.push({key:value,doc_count:0})}});if(["partitioned","isInDataCollection"].includes(field)){aggs[field].agg.buckets.sort((bucket1,bucket2)=>bucket2.key-bucket1.key)}}if($scope.inboxPage){if(!aggs["closed"]){aggs["closed"]={agg:{buckets:[]}}}const statusFacetBuckets=aggs["closed"].agg.buckets;if(!statusFacetBuckets.find(bckt=>bckt.key===0)){statusFacetBuckets.push({key:0,doc_count:0})}if(!statusFacetBuckets.find(bckt=>bckt.key===1)){statusFacetBuckets.push({key:1,doc_count:0})}}}$scope.hasSearch=function(){return $scope.query.queryString!==""||$scope.hasFacets()};$scope.hasFacets=function(){for(const field in $scope.query.facets){for(let i=0;i<($scope.query.facets[field]||[]).length;i++){if(field!=="_type"||$scope.query.facets[field][i]!=="all")return true}}return false};$scope.resetSearch=function(){$scope.query.queryString="";$scope.query.facets={}};$scope.$watch("query.facets",function(nv,ov){if(ov._type&&ov._type.length&&(!nv._type||!nv._type.length)){delete nv.type_raw}Object.entries(nv).forEach(e=>$.isEmptyObject(e[1])&&delete nv[e[0]]);Object.entries(ov).forEach(e=>$.isEmptyObject(e[1])&&delete ov[e[0]]);if(!angular.equals(nv,ov)){$timeout($scope.search)}},true);$scope.$watch("query.queryString",Debounce().withDelay(100,200).wrap($scope.search));$scope.$watch("sortOptions.reverse",function(nv,ov){if(nv!==ov){$scope.filterSortAndLimitItems()}});$scope.$watch("sortOptions.column",function(nv,ov){if(nv!==ov){$scope.filterSortAndLimitItems()}});$scope.$watch("maxItems",function(nv,ov){if(nv!==ov){$scope.filterSortAndLimitItems()}});$scope.$watch("query",function(nv,ov){$scope.maxItems=20;$scope.filterSortAndLimitItems();$scope.$broadcast("clearMultiSelect")},true);$scope.selectInput=function(){$(".catalog-search-input").select()};$scope.itemToColor=function(item){if(!item)return;if(item._type=="insight"){return $filter("insightTypeToColor")(item._source.type_raw)+" insight-icon"}else if(item._type==="recipe"){return $filter("recipeTypeToColorClass")(item._source.type_raw)}else if(item._type==="saved_model"){return $filter("savedModelTypeToClassColor")(item._source.savedModelType)}else if(item._type==="chart"){return $filter("chartTypeToColor")(item._source.objectType)}else if(item._type==="agent"||item._type==="gen_ai_model"){return"llm-saved-model"}else{return item._type}};$scope.onFacetSearchKeyDown=function(e){if(e.keyCode===27){e.target.blur();angular.element(e.target).scope().$parent.showInput=false;angular.element(e.target).scope().$parent.facetValueSearch=""}};$scope.facetValueMatching=function(field){return function(search){search=(search||"").toLowerCase();return function(item){if(!search||!search.length)return true;return item.key.toLowerCase().indexOf(search)!=-1}}};$scope.facetValueNotMatching=function(field,search){return item=>!$scope.facetValueMatching(field)(search)(item)};if($state.includes("projects.project")){TopNav.setLocation(TopNav.TOP_FLOW,"catalog")}else{TopNav.setLocation(TopNav.DSS_HOME,"catalog")}TopNav.setNoItem();TaggingService.fetchGlobalTags()})})();(function(){"use strict";const app=angular.module("dataiku.catalog");const FACET_FIELDS_DISPLAY_NAMES=Object.freeze({projectName:"Project",type_raw:"Type",numColumns:"Columns",usedIn:"Used in",user:"Contributors",storedAs:"Stored as","projectKey.raw":"Project","tag.raw":"Tags","catalog.raw":"DB Catalog","connection.raw":"Connection","schema.raw":"DB Schema",partitioned:"Partitioned",isInDataCollection:"In Collection",closed:"Discussion status",dataSteward:"Data Steward",objectType:"On object of type",typeBadges:"AI Types"});const DISPLAY_NAMES=Object.freeze({recipeTypes:{shaker:"Prepare"},notebookTypes:{SQL_NOTEBOOK:"SQL",SEARCH_NOTEBOOK:"Search",JUPYTER_NOTEBOOK:"Jupyter",IPYTHON_NOTEBOOK:"Jupyter"},notebookLanguages:{ES_QUERY_STRING:"ElasticSearch Query String",SQL:"SQL",python2:"Python 2",python3:"Python 3",ir:"R",toree:"Scala"},genAiTypes:{RETRIEVAL_AUGMENTED_LLM:"Retrieval Augmented LLM",LLM_GENERIC:"Fine-tuned LLM"},agentTypes:{PYTHON_AGENT:"Code Agent",PLUGIN_AGENT:"Plugin Agent",TOOLS_USING_AGENT:"Visual Agent"},typeBadges:{AGENT:"Agent",LLM:"LLM",ML:"ML"}});app.service("CatalogItemService",function(StateUtils,$location,Navigator,$filter,$state,FLOW_COMPUTABLE_TYPES){const svc=this;svc.getLink=function(_type,_source,discussionId){if(!_type||!_source)return;switch(_type){case"article":return StateUtils.href.dssObject(_type.toUpperCase(),_source.name,_source.projectKey);case"dashboard":return StateUtils.href.dashboard(_source.id,_source.projectKey,{name:_source.name});case"column":return $state.href("projects.project.datasets.dataset.explore",{projectKey:_source.projectKey,datasetName:_source.dataset});case"comment":return StateUtils.href.dssObject(_source.objectType.toUpperCase(),_source.objectId,_source.projectKey,{moveToTargetProject:true});case"table":return $state.href("external-table",{connection:_source.virtualConnection?_source.virtualConnection:_source.connection,catalog:_source.catalog,schema:_source.schema,table:_source.name});case"discussion":{const obj={type:_source.tor.split(".")[1],id:_source.objectId,workspaceKey:_source.workspaceKey,projectKey:_source.projectKey};return StateUtils.href.taggableObject(obj,{moveToTargetProject:true,discussionId:_source.discussionId})}case"flow_zone":return StateUtils.href.flowZone(_source.id,_source.projectKey);case"data_collection":return StateUtils.href.dataCollection(_source.id);case"chart":return StateUtils.href.chart(_source.objectType,_source.projectKey,_source.objectId,_source.index);default:return StateUtils.href.dssObject(svc.indexableTypeToTaggableType(_type,_source.type_raw).toUpperCase(),_source.hasOwnProperty("id")?_source.id:_source.name,_source.projectKey,{moveToTargetProject:true})}};svc.indexableTypeToTaggableType=function(indexableType,rawType){if(!indexableType)return;switch(indexableType.toLowerCase()){case"notebook":return rawType;case"knowledge_bank":return"retrievable_knowledge";case"gen_ai_model":case"agent":return"saved_model";default:return indexableType}};svc.goToItem=function(_type,_source){_type=svc.indexableTypeToTaggableType(_type,_source.type_raw);$location.path(svc.getLink(_type,_source))};svc.hasNavigator=function(_type){return["dataset","recipe","saved_model","model_evaluation_store","managed_folder","streaming_endpoint","labeling_task","knowledge_bank"].indexOf(_type)>-1};svc.openNavigator=function(_type,_source){return function(){_type=svc.indexableTypeToTaggableType(_type,_source.type_raw);Navigator.show(_source.projectKey,_type.toUpperCase(),_source.id)}};svc.getFlowLink=function(_type,_source,_contextProjectKey){if(!_type||!_source)return;_type=svc.indexableTypeToTaggableType(_type,_source.type_raw);return StateUtils.href.flowLinkFromPropsNoZone(_type,_source.projectKey,_source.id,_contextProjectKey)};svc.hasFlowLink=function(_type,type_raw){const taggable_type=svc.indexableTypeToTaggableType(_type,type_raw);return FLOW_COMPUTABLE_TYPES.includes(taggable_type.toUpperCase())||taggable_type==="recipe"||taggable_type==="labeling_task"};svc.itemToIcon=function(_type,_source,inList,size){if(!_type||!_source){return}switch(_type){case"dataset":return inList?$filter("typeToIcon")(_source.type_raw,size):$filter("datasetTypeToIcon")(_source.type_raw,size);case"notebook":return $filter("typeToIcon")(_source.type_raw,size);case"web_app":return $filter("subTypeToIcon")(_source.subtype||_source.type_raw,_type,size);case"gen_ai_model":return $filter("savedModelSubtypeToIcon")(null,null,null,_source.type_raw,null,size);case"agent":return $filter("savedModelSubtypeToIcon")(null,null,null,_source.type?_source.type[0]:"",null,size);case"agent_tool":return $filter("agentToolTypeToIcon")(_source.type_raw||_source.agentToolType,size);case"saved_model":{return $filter("savedModelSubtypeToIcon")(_source.taskType,_source.backendType,_source.predictionType,_source.savedModelType,_source.proxyModelProtocol||_source.externalSavedModelType,size)}default:return $filter("subTypeToIcon")(_source.type_raw,_type,size)}};svc.itemToColor=function(_type,_source){if(!_type||!_source)return;if(_type=="insight"){return $filter("insightTypeToColor")(_source.type_raw)+" insight-icon"}else if(_type==="recipe"){return $filter("recipeTypeToColorClass")(_source.type_raw)}else if(_type==="saved_model"){return $filter("savedModelTypeToClassColor")(_source.savedModelType)}else if(_type==="chart"){return $filter("chartTypeToColor")(_source.objectType)}else if(_type==="agent"||_type==="gen_ai_model"){return"llm-saved-model"}else{return _type.toLowerCase()}}});app.controller("CatalogItemsController",function($controller,$scope,$state,$stateParams,$filter,DataikuAPI,CreateModalFromTemplate,StateUtils,CatalogUtils,DashboardUtils,CatalogItemService,TypeMappingService,TaggingService,AgentToolService){const overridenCatalogUtils={getHash:CatalogUtils.getHash,getLink:CatalogUtils.getLink,parseHash:function($scope,hash){CatalogUtils.parseHash($scope,hash);if(!$scope.query.facets["scope"]){$scope.query.facets["scope"]=$stateParams.scope?$stateParams.scope:["dss"]}if(!$scope.query.facets["_type"]&&$stateParams._type){$scope.query.facets["_type"]=$stateParams._type}}};$controller("_CatalogControllerBase",{$scope:$scope,searchEndpoint:DataikuAPI.catalog.search,CatalogUtils:overridenCatalogUtils});$scope.getCatalogScope=()=>$scope;$scope.tableComparator=function(one,other){return one&&other&&one._id===other._id};$scope.getNames=function(tables){return tables.map(el=>el._source.name)};$scope.getImportData=function(tables){const selectedTables=tables||$scope.selection.selectedObjects;const tableKeys=selectedTables.map(t=>({connectionName:t._source.connection,catalog:t._source.catalog,schema:t._source.schema,name:t._source.name}));return{wt1Context:{from:"search-dss"},workflowType:"KEYS",tableKeys:tableKeys}};$scope.importTables=function(tables,zoneId){const selectedTables=tables&&!angular.isArray(tables)?[tables]:tables;if($stateParams.projectKey){$state.go("projects.project.tablesimport",{projectKey:$stateParams.projectKey,importData:JSON.stringify($scope.getImportData(selectedTables)),zoneId:zoneId})}else{let newScope;if(selectedTables){newScope=$scope.$new();newScope.getImportData=()=>$scope.getImportData(selectedTables)}else{newScope=$scope}CreateModalFromTemplate("/templates/datasets/tables-import-project-selection-modal.html",newScope,"TablesImportProjectSelectionModalController")}};$scope.goToConnectionsExplorer=function(){if($state.includes("projects.project")){$state.go("projects.project.datacatalog.database-explorer")}else{$state.go("homeV2.data-catalog.database-explorer")}};$scope.hasUnindexedConnections=function(){const iau=$scope.indexedAndUnindexed;if(!iau){return}return(iau.possiblyUnscannedHive||iau.unindexedButIndexableConnections>0)&&($scope.query.facets.scope[0]==="external"||$scope.query.facets.scope[0]==="all")};const parentResetSearch=$scope.resetSearch;$scope.resetSearch=function(){const facetsScope=$scope.query.facets.scope;parentResetSearch();$scope.query.facets.scope=facetsScope||["dss"]};$scope.isItemSelectable=function(item){return item._type==="table"};$scope.clickShowSelected=function(){$scope.showSelectedOnly=!$scope.showSelectedOnly};$scope.isFunction=angular.isFunction;$scope.showSelectedOnly=false;$scope.showAllTypes=false;$scope.projectKey=$stateParams.projectKey;$scope.itemsPage=true;$scope.displayItemTypeFacet=!$state.current.name.includes("datacatalog");$scope.mapItemToIcon=function(item,size){if(item.key==="chart"){return"dku-icon-chart-"+size}return TypeMappingService.mapTypeToIcon(item.key,size)};$scope.locations=[{name:"DSS",id:"dss"},{name:"External tables",id:"external"}];$scope.sortBy=[{label:"Relevance",value:"_score"},{label:"Type",value:i=>i._type+i._source.type_raw},{label:"Creation",value:i=>i._source.createdOn},{label:"Last modification",value:i=>i._source.lastModifiedOn}];const projectNames={};$scope.types=[];$scope.tagMaps={};$scope.users={};$scope.projects={};$scope.$watch("selection.selectedObjects.length",function(nv,ov){if(ov>0&&nv===0){$scope.showSelectedOnly=false}});function init(){DataikuAPI.connections.countIndexedAndUnindexed().success(function(response){$scope.indexedAndUnindexed=response}).error(setErrorInScope.bind($scope));DataikuAPI.security.listUsers().success(function(response){angular.forEach(response,function(user){$scope.users[user.login]=user.displayName})}).error(setErrorInScope.bind($scope));DataikuAPI.projects.list(true).success(function(response){angular.forEach(response,function(project){projectNames[project.projectKey]=project.name;$scope.projects[project.projectKey]=project})}).error(setErrorInScope.bind($scope))}function addFacets(aggs){for(const field in aggs){angular.forEach($scope.query.facets[field],function(value){if(field=="_type"&&value=="all")return;if(!aggs[field].agg.buckets.filter(function(bucket){return bucket.key==value}).length){aggs[field].agg.buckets.push({key:value,doc_count:0})}})}}$scope.getTorFromSource=src=>({type:src.tor.split(".")[1],id:src.objectId,projectKey:src.projectKey,workspaceKey:src.workspaceKey});$scope.getLink=function(input,discussionId){if(!input)return;return CatalogItemService.getLink(input._type,input._source,discussionId)};$scope.goToItem=function(item){if(!item)return;return CatalogItemService.goToItem(item._type,item._source)};$scope.hasNavigator=function(item){if(!item)return;return CatalogItemService.hasNavigator(item._type)};$scope.openNavigator=function(item){if(!item)return;return CatalogItemService.openNavigator(item._type,item._source)};$scope.getFlowLink=function(input){if(!input)return;return CatalogItemService.getFlowLink(input._type,input._source)};$scope.hasFlowLink=function(input){if(!input)return;return CatalogItemService.hasFlowLink(input._type,input._source.type_raw)};$scope.formatFacetField=function(field){return FACET_FIELDS_DISPLAY_NAMES[field]||$filter("capitalize")(field)};$scope.formatFacetValue=function(value,facet){switch(facet){case"closed":return value?"Closed":"Open";case"projectKey.raw":return projectNames[value]||value;case"_type":case"objectType":return $filter("capitalize")(userFriendlyType(value));case"user":case"owner":case"dataSteward":return $scope.users[value]?`${$scope.users[value]} (${value})`:value;case"language":return DISPLAY_NAMES.notebookLanguages[value]||value;case"connection.raw":return $filter("connectionNameFormatter")(value);case"type_raw":if(!$scope.query.facets._type){return value}switch($scope.query.facets._type[0]){case"dataset":return $filter("capitalize")(value);case"recipe":return DISPLAY_NAMES.recipeTypes[value]||$filter("capitalize")(value.replace(/_/g," "));case"notebook":return DISPLAY_NAMES.notebookTypes[value];case"gen_ai_model":return DISPLAY_NAMES.genAiTypes[value];case"agent":return DISPLAY_NAMES.agentTypes[value]||value;case"agent_tool":return AgentToolService.getAgentToolTypesUiDataForType(value)?.label||value;case"saved_model":return $filter("capitalize")(value);case"model_evaluation_store":return $filter("capitalize")(value);case"labeling_task":return $filter("capitalizeWord")($filter("niceConst")(value));case"insight":return DashboardUtils.getInsightHandler(value).name||"Unknown";default:return value}case"partitioned":case"isInDataCollection":return value===0?"No":"Yes";case"typeBadges":return DISPLAY_NAMES.typeBadges[value]||value}return value};function userFriendlyType(indexableType){switch(indexableType){case"lambda_service":return"API Service";case"gen_ai_model":return"gen AI model";default:return indexableType.replace(/_/g," ")}}$scope.facetValueMatching=function(field){return function(search){search=(search||"").toLowerCase();return function(item){if(!search||!search.length){return true}if(item.key.toLowerCase().includes(search)){return true}else if(field==="projectKey.raw"){return(projectNames[item.key]||"").toLowerCase().includes(search)}else if(field==="user"||field==="owner"||field==="dataSteward"){return($scope.users[item.key]||"").toLowerCase().includes(search)}return false}}};$scope.itemToIcon=function(item,inList,size){if(!item)return;return CatalogItemService.itemToIcon(item._type,item._source,inList,size)};$scope.formatItemName=function(item,inList){if(item._type=="discussion"){const src=item._source;const topic=item.highlight&&item.highlight["discussions.topic"]?item.highlight["discussions.topic"][0]:$filter("escapeHtml")(src.discussions&&src.discussions.length&&src.discussions[0].topic?src.discussions[0].topic:"Unnamed discussion");const title=topic+" <small>on "+userFriendlyType(src.objectType)+"</small> "+$filter("escapeHtml")(src.objectName);return title}if(item._type=="chart"){const src=item._source;const name=$scope.encodeItemName(item)||"Untitled chart";const title=name+" <small>on "+userFriendlyType(src.objectType)+"</small> "+$scope.encodeItemObjectName(item);return title}return $scope.encodeItemName(item)};$scope.encodeItemName=function(item){if(item.highlight){if(item.highlight.name&&item.highlight.name.length){return sanitizeHighlighted(item.highlight.name[0])}if(item.highlight["name.raw"]&&item.highlight["name.raw"].length){return sanitizeHighlighted(item.highlight["name.raw"][0])}}return $filter("encodeHTML")(item._source.name)};$scope.encodeItemObjectName=function(item){if(item.highlight&&item.highlight["objectName"]&&item.highlight["objectName"].length){return sanitizeHighlighted(item.highlight["objectName"][0])}return $filter("encodeHTML")(item._source.objectName)};$scope.getCommentLink=function(item){const tor={type:item._source.objectType.toUpperCase(),id:item._source.objectId,projectKey:item._source.projectKey};return StateUtils.href.taggableObject(tor,{moveToTargetProject:false})};$scope.highlightedAttachmentsList=function(item){if(!item.hasOwnProperty("highlightedAttachments")){item.highlightedAttachments=[];let strippedAttachments=[];if(item.highlight&&item.highlight["attachments.displayName"]){strippedAttachments=item.highlight["attachments.displayName"].map(str=>str.replace(/<\/?em>/g,""))}angular.forEach(item._source.attachments,function(attachment){const index=strippedAttachments.indexOf(attachment.displayName);if(index==-1){item.highlightedAttachments.push(attachment)}else{item.highlightedAttachments.push({displayName:item.highlight["attachments.displayName"][index],type:attachment.type})}})}return item.highlightedAttachments};function getTagHighlights(highlight){if(!highlight){return[]}return[...highlight["tag.plaintext"]||[],...highlight.tag||[]]}$scope.highlightedTagList=function(item){if(!item.hasOwnProperty("highlightedTags")){item.highlightedTags=getTagHighlights(item.highlight).map(str=>str.replace(/<\/?em>/g,""));item.tagsMap=TaggingService.fillTagsMapFromArray(item._source.tag||[])}return item.highlightedTags};$scope.realHighlightedTagList=function(item){if(!item.hasOwnProperty("realHighlightedTag")){const htags=$scope.highlightedTagList(item);const withEmBlocks=getTagHighlights(item.highlight);const actuallyExistingTags=new Set(item._source.tag||[]);const realHighlightedTag=new Set;htags.forEach((candidate,idx)=>{if(actuallyExistingTags.has(candidate)){realHighlightedTag.add(withEmBlocks[idx])}});item.realHighlightedTag=[...realHighlightedTag]}return item.realHighlightedTag};$scope.itemCount=function(){let type="all";if($scope.query.facets._type&&$scope.query.facets._type.length){type=$scope.query.facets._type[0].replace("_"," ")}const plural=$scope.results&&$scope.results.hits.total>1;if(type=="analysis"){type=plural?"analyses":"analysis"}else if(type=="all"){type="item"+(plural?"s":"")}else{type+=plural?"s":""}return"<strong>"+($scope.results?$scope.results.hits.total:0)+"</strong> "+type};init()});app.service("CatalogRefreshUtils",function($state,StateUtils,SmartId){function breakFlowComputableNameIntoParts(name){const parts=name.split(".");if(parts.length===1)return{name:name};return{projectKey:parts[0],name:parts.slice(1).join(""),fullName:name}}function reformatNames(flowComputables){if(!flowComputables)return[];return flowComputables.map(e=>Object.assign(e,breakFlowComputableNameIntoParts(e["name"])))}function highlightedColumnList(item,columns){const highlightedColumns=[];let strippedCols=[];if(item.highlight&&item.highlight["column"]){strippedCols=item.highlight["column"].map(str=>str.replace(/<\/?em>/g,""))}angular.forEach(columns,function(column){const index=strippedCols.indexOf(column.name);if(index===-1){highlightedColumns.push(column)}else{highlightedColumns.push({name:item.highlight["column"][index],type:column.type})}});return highlightedColumns}function computeDatasetInputsOutputsByType(item){item.splitOutputs=reformatNames(item._source.recursiveOutputs);item.splitOutputsByType={};item.splitInputsByType={};const obt=item.splitOutputsByType;const ibt=item.splitInputsByType;reformatNames(item._source.recursiveOutputs).forEach(out=>{if(!obt[out.type]){obt[out.type]=[]}obt[out.type].push(out)});reformatNames(item._source.recursiveInputs).forEach(out=>{if(!ibt[out.type]){ibt[out.type]=[]}ibt[out.type].push(out)})}function getLinkForElement(currentProjectKey,element){const ref=SmartId.resolve(element.fullName||element.id||element.name,currentProjectKey);const smartId=SmartId.create(ref.id,ref.projectKey,currentProjectKey);switch(element.type){case"DATASET":return StateUtils.href.dataset(smartId,currentProjectKey);case"SAVED_MODEL":return StateUtils.href.savedModel(smartId,currentProjectKey);case"MODEL_EVALUATION_STORE":return StateUtils.href.modelEvaluationStore(smartId,currentProjectKey);case"MANAGED_FOLDER":return StateUtils.href.managedFolder(ref.id,ref.projectKey,currentProjectKey);case"STREAMING_ENDPOINT":return $state.href("projects.project.streaming-endpoints.streaming-endpoint.settings",{projectKey:ref.projectKey,streamingEndpointId:ref.id});case"RETRIEVABLE_KNOWLEDGE":return $state.href("projects.project.retrievableknowledges.retrievableknowledge.settings",{projectKey:ref.projectKey,retrievableKnowledgeId:ref.id,"#":"core-settings"});default:throw"Incorrect or missing flow computable type"}}return{breakFlowComputableNameIntoParts:breakFlowComputableNameIntoParts,reformatNames:reformatNames,highlightedColumnList:highlightedColumnList,computeDatasetInputsOutputsByType:computeDatasetInputsOutputsByType,getLinkForElement:getLinkForElement}});app.component("relatedByType",{template:`
        <div class="accordion" ng-repeat="(type, elements) in $ctrl.elementsByType">
            <h4 class="accordion-title" ng-click="show=!show">
                <i ng-class="{'dku-icon-chevron-up-16':show, 'dku-icon-chevron-down-16':!show}"></i>
                {{$ctrl.baseString}} {{type | niceTaggableType : elements.length}}<span ng-show="elements.length > 1"> ({{elements.length}})</span>
            </h4>

            <ul ng-show="show">
                <li ng-repeat="input in elements" class="mx-textellipsis horizontal-flex">
                    <span class="flex mx-textellipsis">
                        <a href="{{getLinkForElement($ctrl.baseItemProjectKey, input)}}">{{ input.name }}</a>
                    </span>
                    <span ng-if="input.projectKey != $ctrl.baseItemProjectKey" class="info noflex">{{input.projectKey}}</span>
                </li>
            </ul>
        </div>
        `,bindings:{elementsByType:"<",baseItemProjectKey:"<",baseString:"<"},controller:function($scope,CatalogRefreshUtils){$scope.getLinkForElement=CatalogRefreshUtils.getLinkForElement}});app.controller("CatalogRefreshController",function($scope,DataikuAPI,CachedAPICalls,CatalogItemService,Ng2ObjectsExpositionService,FLOW_COMPUTABLE_TYPES,CatalogRefreshUtils,SavedModelsService,AgentToolEnrichmentService){$scope.getLinkForElement=CatalogRefreshUtils.getLinkForElement;$scope.resolveObjectSmartId=resolveObjectSmartId;$scope.$watch("formatted_items",function(){if($scope.formatted_items&&$scope.selected&&$scope.selected.item){for(let i=0;i<$scope.formatted_items.length;i++){if($scope.formatted_items[i]._id==$scope.selected.item._id){$scope.selected.index=i;$scope.selected.item=$scope.formatted_items[i];return}}$scope.selected.index=null;$scope.selected.item=null}});$scope.$watch("selected.item",function(nv,ov){if(!$scope.selected||!$scope.selected.item)return;const item=$scope.selected.item;$scope.exposeDisabled=true;const related=nv._source.rawRelatedItems;if(related){nv.related={projects:[],datasets:[],recipes:[]};related.projects.forEach(p=>{nv.related.projects.push({key:p.key,name:p.name});p.datasets.forEach(d=>{nv.related.datasets.push($.extend({},{projectKey:p.key},d));d.recipes.forEach(r=>{nv.related.recipes.push($.extend({},{projectKey:p.key},r))})})})}if(item._type==="dataset"){CatalogRefreshUtils.computeDatasetInputsOutputsByType(item)}else if(item._type==="recipe"||item._type==="labeling_task"){item.splitOutputs=CatalogRefreshUtils.reformatNames(item._source.outputs);item.splitInputs=CatalogRefreshUtils.reformatNames(item._source.inputs)}else if(item._type==="gen_ai_model"||item._type==="agent"||item._type==="saved_model"){DataikuAPI.savedmodels.getFullInfo(item._source.projectKey,item._source.id).success(function(response){item.model=response.model;item.status=response.status;item.creatingRecipe=response.creatingRecipe;item.recipes=response.recipes;item.creatingContinuousRecipe=response.creatingContinuousRecipe;item.creatingLabelingTask=response.creatingLabelingTask;SavedModelsService.enrichSavedModelObject(item,undefined,$scope)}).error(setErrorInScope.bind($scope))}else if(item._type==="agent_tool"){DataikuAPI.agentTools.getFullInfo(item._source.projectKey,item._source.id).success(function(response){AgentToolEnrichmentService.enrichAgentToolObject(response.agentTool,$scope);item.summary=response.agentTool.summary}).error(setErrorInScope.bind($scope))}else if(item._type==="lambda_service"){DataikuAPI.lambda.services.getSummary(item._source.projectKey,item._source.id).success(function(response){item.object=response.object;item.packages=response.packages;SavedModelsService.listAPIServiceableModels(item._source.projectKey).then(function(serviceableModels){$scope.availableSavedModels=serviceableModels}).catch(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))}$scope.navigatorFn=CatalogItemService.hasNavigator(item._type)?CatalogItemService.openNavigator(item._type,item._source):false;const taggableType=(CatalogItemService.indexableTypeToTaggableType(item._type,item._source.type_raw)||"").toUpperCase();item.highlightedPartitionColumns=CatalogRefreshUtils.highlightedColumnList(item,item._source.partitioning);const exposable=FLOW_COMPUTABLE_TYPES.includes(taggableType);const selectedItemSource=item._source;const exposeObjectToProjectsFn=canManageExposedElements=>()=>Ng2ObjectsExpositionService.openSingleObjectUseModal(taggableType,selectedItemSource.id,selectedItemSource.name,selectedItemSource.projectKey,canManageExposedElements,{from:"search-dss"});const requestSharingFn=()=>Ng2ObjectsExpositionService.requestSharing(taggableType,selectedItemSource.id,selectedItemSource.name,selectedItemSource.projectKey,$scope.projectKey,{from:"search-dss"});$scope.exposeObjectFn=null;$scope.exposeLabel=null;$scope.importLbl="Use";$scope.exposeIcon="icon-dku-share";const checkObjectExposition=function(projectKey,objectType,objectId){DataikuAPI.projects.getObjectAuthorizations(projectKey,objectType,objectId).success(data=>{$scope.exposeObjectFn=exposeObjectToProjectsFn(data.canManageExposedElements);if(data.isQuicklyShareable){$scope.exposeDisabled=!data.canReadObject;if(data.canReadObject){$scope.exposeLabel="Use in another project"}else{$scope.exposeLabel="No permission to share object"}}else{$scope.exposeDisabled=!data.canManageExposedElements&&!data.isObjectSharingRequestEnabled;if(data.canManageExposedElements){$scope.exposeLabel="Use in another project"}else if(data.isObjectSharingRequestEnabled){$scope.exposeObjectFn=requestSharingFn;$scope.exposeIcon="icon-lock";$scope.exposeLabel="Request to use in another project";$scope.importLbl="Request"}else{$scope.exposeLabel="No permission to share object"}}}).error(function(response,status,headers){$scope.exposeDisabled=true;$scope.exposeLabel="No permission to share object";setErrorInScope.bind($scope.getCatalogScope())(response,status,headers)})};if(exposable){$scope.exposeObjectFn=exposeObjectToProjectsFn(false);checkObjectExposition(item._source.projectKey,taggableType,item._source.id)}if(item.splitOutputsByType){Object.keys(item.splitOutputsByType).forEach(key=>{let outputsByType=item.splitOutputsByType[key].filter(input=>{const targetProject=$scope.projects[input.projectKey];return targetProject&&targetProject.canReadProjectContent});if(outputsByType.length>0){item.splitOutputsByType[key]=outputsByType}else{delete item.splitOutputsByType[key]}})}if(item&&item._source){if(item._source.usedIn&&item._source.usedIn.length){const sourceProject=$scope.projects[item._source.projectKey];const canReadSourceProject=sourceProject&&sourceProject.canReadProjectContent;if(canReadSourceProject){item._source.usedInReadable=item._source.usedIn;item._source.usedInHiddenCount=0}else{item._source.usedInReadable=item._source.usedIn.filter(projectKey=>{const targetProject=$scope.projects[projectKey];return targetProject&&targetProject.canReadProjectContent});item._source.usedInHiddenCount=item._source.usedIn.length-item._source.usedInReadable.length}}else{item._source.usedInReadable=undefined;item._source.usedInHiddenCount=0}}});$scope.$watch("selected.item.highlight.description[0]",function(nv,ov){if(!nv)return;let description=nv.replace(/<em>/g,"((STARTEM))").replace(/<\/em>/g,"((ENDEM))");CachedAPICalls.emojisTable.then(function(emojisTable){marked.setOptions({emoji:function(emoji){return emoji in emojisTable?emojisTable[emoji]:":"+emoji+":"}});description=marked(description);$scope.selected.item.$highlightedDescription=description.replace(/\(\(STARTEM\)\)/g,'<em class="highlight">').replace(/\(\(ENDEM\)\)/g,"</em>")})});$scope.$watch("selected.item.highlight.shortDesc[0]",function(nv,ov){if(!nv)return;let shortDesc=nv.replace(/<em>/g,"((STARTEM))").replace(/<\/em>/g,"((ENDEM))");CachedAPICalls.emojisTable.then(function(emojisTable){marked.setOptions({emoji:function(emoji){return emoji in emojisTable?emojisTable[emoji]:":"+emoji+":"}});shortDesc=marked(shortDesc);$scope.selected.item.$highlightedShortDesc=shortDesc.replace(/\(\(STARTEM\)\)/g,'<em class="highlight">').replace(/\(\(ENDEM\)\)/g,"</em>")})})});app.directive("itemHighlight",function(){return{scope:{highlights:"=itemHighlight",label:"@",plural:"@"},template:`
        <p ng-if="highlights" >
            <span>{{label | plurify : highlights.length : plural}}:</span>
            <span ng-if="highlights.length > 4">
                <span>{{highlights.length}} matching</span>
            </span>
            <span ng-if="highlights.length < 5" ng-repeat="highlight in highlights track by $index">
                <span ng-bind-html="highlight | sanitizeHighlighted"></span>
                <span class="separator" ng-show="!$last"> • </span>
            </span>
        </p>`}})})();(function(){"use strict";const app=angular.module("dataiku.catalog");app.controller("CatalogMeaningsController",function($scope,$controller,TopNav,DataikuAPI,Dialogs,CreateModalFromTemplate,UDM_TYPES){$controller("_CatalogControllerBase",{$scope:$scope,searchEndpoint:DataikuAPI.catalog.searchMeanings});$controller("_MeaningsCatalogSupportController",{$scope:$scope});$scope.meaningsPage=true;$scope.udmTypes=UDM_TYPES;$scope.editUDM=function(item){CreateModalFromTemplate("/templates/meanings/edit-udm.html",$scope,null,function(newScope){newScope.initModal(item._source.id,$scope.search)})};$scope.goToItem=$scope.editUDM;$scope.deleteUDM=function(item){DataikuAPI.meanings.prepareDeleteUDM(item._id).success(function(data){Dialogs.confirmInfoMessages($scope,"Delete meaning",data,"Are you sure you want to delete this meaning?",false).then(function(){DataikuAPI.meanings.deleteUDM(item._id).success($scope.search).error(setErrorInScope.bind($scope))})}).error(setErrorInScope.bind($scope))};$scope.createUDM=function(item){CreateModalFromTemplate("/templates/meanings/edit-udm.html",$scope,null,function(newScope){newScope.initModal(null,$scope.search)})}});app.controller("_MeaningsCatalogSupportController",function($scope,$filter,UDM_TYPES){$scope.hasNavigator=item=>false;$scope.itemToIcon=item=>"icon-dku-meanings";$scope.getLink=input=>null;$scope.itemCount=function(){const hits=$scope.results&&$scope.results.hits?$scope.results.hits.total:0;return"<strong>"+hits+"</strong> meaning"+(hits>1?"s":"")};$scope.selectInput=function(){$(".catalog-search-input").select()};const NICE_FACET_FIELDS={udm_type:"Type"};$scope.formatFacetField=function(field){return NICE_FACET_FIELDS[field]||$filter("capitalize")(field)};$scope.formatFacetValue=function(value,facet){switch(facet){case"udm_type":return UDM_TYPES[value];break;default:return value}};$scope.formatItemName=function(item,inList){if(item.highlight&&item.highlight.label&&item.highlight.label.length){return item.highlight.label[0]}return $filter("encodeHTML")(item._source.label)};$scope.sortBy=[{label:"Relevance",value:"_score"},{label:"Type",value:i=>i._source.udm_type},{label:"Number of uses",value:i=>(i.inner_hits.column.hits.hits||[]).length}]});app.controller("MeaningRightColumnController",function($scope,UDM_TYPES){$scope.udmTypes=UDM_TYPES;$scope.highlightedDescription=function(){if($scope.selected.item.highlight&&$scope.selected.item.highlight.description){let description=$scope.selected.item.highlight.description[0].replace(/<em>/g,"((STARTEM))").replace(/<\/em>/g,"((ENDEM))");description=marked(description);description=description.replace(/\(\(STARTEM\)\)/g,'<em class="highlight">').replace(/\(\(ENDEM\)\)/g,"</em>");return description}return marked($scope.selected.item._source.description)}})})();(function(){"use strict";const app=angular.module("dataiku.catalog");app.controller("ExternalTableSchemaController",function($scope,$filter,_SummaryHelper,$element,$stateParams,DataikuAPI,Debounce){_SummaryHelper.addEditBehaviour($scope,$element);$scope.query={columnFilter:""};$scope.$watch("query.columnFilter",Debounce().withDelay(10,200).withScope($scope).wrap(function(nv){if($scope.summary){$scope.columnFiltered=$filter("filter")($scope.summary.table.columns,nv)}}));$scope.selectColumn=function(column){$scope.selectedColumn=column;$scope.selectedColumn.comment=$scope.selectedColumn.remarks;$scope.object=$scope.selectedColumn};function onColumnUpdated(){const updatedColumn=$scope.summary.table.columns.find(col=>col.name===$scope.selectedColumn.name);updatedColumn.remarks=$scope.selectedColumn.comment;$scope.$emit("summaryUpdated",$scope.summary)}$scope.$on("objectSummaryEdited",function(){$scope.saveExternalTable($scope.tableKey,{description:$scope.summary.table.description,tags:$scope.summary.table.tags},$scope.selectedColumn,$scope.summary.table.remarks,onColumnUpdated)});if($stateParams.selectedColumn&&$scope.summary){const selectedColumnName=$stateParams.selectedColumn;const selectedColumn=$scope.summary.table.columns.find(col=>col.name===selectedColumnName);if(selectedColumn){$scope.selectColumn(selectedColumn);$scope.startFieldEdit("comment")}}function refreshSummary(){DataikuAPI.externalTable.summary($scope.tableKey).success(function(data){$scope.summary=data;$scope.columnFiltered=$filter("filter")($scope.summary.table.columns,$scope.query.columnFilter)}).error(setErrorInScope.bind($scope))}refreshSummary()});app.controller("ExternalTableController",function($scope,$rootScope,$injector,$stateParams,$route,DataikuAPI,$location,$compile,$state,$q,CreateModalFromTemplate,$filter,WT1,$timeout,TopNav,DatasetsService,$controller,StateUtils,CatalogUtils,Navigator,DashboardUtils,ActivityIndicator,TaggingService){$rootScope.activeProjectTagColor=TaggingService.getTagColor;function emptyToNull(string){return string&&string.length?string:null}$scope.tableKey={connection:emptyToNull($stateParams.connection),catalog:emptyToNull($stateParams.catalog),schema:emptyToNull($stateParams.schema),table:emptyToNull($stateParams.table)};$scope.tableKeyJson=JSON.stringify($scope.tableKey);$scope.import=function(){CreateModalFromTemplate("/templates/datasets/tables-import-project-selection-modal.html",$scope,"TablesImportProjectSelectionModalController")};$scope.getImportData=function(){return{workflowType:"KEYS",tableKeys:[$scope.summary.table.key]}};$scope.saveExternalTable=function(tableKey,dssMetadata,updatedColumn,tableRemarks,refreshCallback){DataikuAPI.externalTable.save(tableKey,dssMetadata,updatedColumn,tableRemarks).success(function(data){if(data.error&&data.messages.length>0){ActivityIndicator.error(data.messages[0].message,5e3)}else{ActivityIndicator.success("Saved!")}refreshCallback()}).error(setErrorInScope.bind($scope))};$scope.$on("summaryUpdated",function(event,data){$scope.summary=data;$scope.object=$scope.summary.table;$scope.dataSchema=$scope.summary.table.columns});$scope.$on("objectSummaryEdited",function(){if($state.current.name==="external-table.schema"){return}$scope.saveExternalTable($scope.tableKey,{description:$scope.summary.table.description,tags:$scope.summary.table.tags},null,$scope.summary.table.remarks,()=>{})});$scope.reloadSample=function(){DataikuAPI.externalTable.sample($scope.tableKey).success(data=>{$scope.sample=data;$scope.sampleColumnsWidths=Array.from(Array($scope.sample.columns.length).fill(0));$scope.sample.rows.forEach((r,rownum)=>{r.forEach((e,i)=>{let l=Math.max($scope.sample.columns[i].name.length,e&&e.length||0)*8+10;$scope.sampleColumnsWidths[i]=Math.max($scope.sampleColumnsWidths[i],l)});return r});$scope.sampleColumnsWidths=$scope.sampleColumnsWidths.map(e=>e);$scope.schema={schema:$scope.sample.querySchema}}).error(setErrorInScope.bind($scope))};function refreshSummary(){DataikuAPI.externalTable.summary($scope.tableKey).success(function(data){$scope.summary=data;$scope.object=$scope.summary.table;$scope.dataSchema=$scope.summary.table.columns;$scope.grouppedDSSItems=[];if($scope.summary.dssItems){$scope.summary.dssItems.projects.forEach(function(project){project.datasets.forEach(function(dataset){$scope.grouppedDSSItems.push({dataset:dataset,project:project,recipes:dataset.recipes})})})}}).error(setErrorInScope.bind($scope))}TaggingService.fetchGlobalTags();TopNav.setLocation(TopNav.DSS_HOME,"catalog");refreshSummary()});app.directive("externalTableSummary",function(_SummaryHelper){return{link:function($scope,element,attrs){_SummaryHelper.addEditBehaviour($scope,element)},templateUrl:"/templates/catalog/external-table/summary.html"}})})();(function(){"use strict";const app=angular.module("dataiku.catalog");const FACET_FIELDS_DISPLAY_NAMES=Object.freeze({projectName:"Project",type_raw:"Type",numColumns:"Columns",usedIn:"Used in",user:"Contributors",storedAs:"Stored as","projectKey.raw":"Project",workspaceKey:"Workspace","tag.raw":"Tags","catalog.raw":"DB Catalog","connection.raw":"Connection","schema.raw":"DB Schema",objectType:"Object type",closed:"Status"});app.controller("DiscussionsInboxController",function($controller,$scope,$rootScope,DataikuAPI,TopNav,Notification){function searchWrapper(...args){return DataikuAPI.discussions.inbox.search.apply(this,args).success(function(data){$scope.unreadDiscussionFullIds=data.unreadDiscussionFullIds||[]})}$controller("_CatalogControllerBase",{$scope:$scope,searchEndpoint:searchWrapper});$controller("_InboxCatalogSupportController",{$scope:$scope});TopNav.setLocation(TopNav.DSS_HOME,"inbox.conversations","items",null);$scope.inboxPage=true;const projectNames={};$scope.users={};$scope.tagMaps={};$scope.unreadDiscussionFullIds=[];$scope.query.facets.closed=[0];$scope.unread=function(item){const fullId=item._source.projectKey+"."+item._source.discussionId;return $scope.unreadDiscussionFullIds.includes(fullId)};DataikuAPI.taggableObjects.listAllTags().success(function(data){$scope.tagMaps=data}).error(setErrorInScope.bind($scope));DataikuAPI.security.listUsers().success(function(data){angular.forEach(data,user=>$scope.users[user.login]=user.displayName)}).error(setErrorInScope.bind($scope));DataikuAPI.projects.list().success(function(data){angular.forEach(data,project=>projectNames[project.projectKey]=project.name)}).error(setErrorInScope.bind($scope));const ackListenerDestroyer=Notification.registerEvent("discussion-ack",function(evtType,message){if(message.user!=$rootScope.appConfig.login){return}const index=$scope.unreadDiscussionFullIds.indexOf(message.projectKey+"."+message.discussionId);if(index>-1){$scope.unreadDiscussionFullIds.splice(index,1)}});const replyListenerDestroyer=Notification.registerEvent("discussion-reply",function(evtType,message){if(message.user==$rootScope.appConfig.login){return}const index=$scope.unreadDiscussionFullIds.indexOf(message.projectKey+"."+message.discussionId);if(index==-1){$scope.unreadDiscussionFullIds.push(message.projectKey+"."+message.discussionId)}});$scope.$on("$destroy",function(){ackListenerDestroyer();replyListenerDestroyer()})});app.controller("_InboxCatalogSupportController",function($scope,$location,StateUtils,$filter,TypeMappingService){$scope.hasNavigator=item=>false;$scope.isItemSelectable=item=>false;$scope.getTorFromSource=src=>({type:src.tor.split(".")[1],id:src.objectId,projectKey:src.projectKey,workspaceKey:src.workspaceKey});$scope.getLink=function(item){const src=item._source;return StateUtils.href.taggableObject($scope.getTorFromSource(src),{discussionId:src.discussionId})};$scope.goToItem=function(item){$location.path($scope.getLink(item))};$scope.mapItemToIcon=function(item,size){if(item.key==="chart"){return"dku-icon-chart-"+size}return TypeMappingService.mapTypeToIcon(item.key,size)};$scope.sortBy=[{label:"Last reply",value:item=>item._source.lastReplyTime},{label:"Read",value:item=>$scope.unread(item)}];$scope.sortOptions={column:$scope.sortBy[0].value,reverse:true};$scope.formatFacetField=function(field){return FACET_FIELDS_DISPLAY_NAMES[field]||$filter("capitalize")(field)};$scope.formatFacetValue=function(value,facet){if(facet==="closed"){return value?"Resolved discussions":"Opened discussions"}else if(facet==="objectType"){return $filter("capitalize")(userFriendlyType(value))}return value};function userFriendlyType(indexableType){switch(indexableType){case"lambda_service":return"API Service";case"gen_ai_model":return"gen AI model";default:return indexableType.replace(/_/g," ")}}$scope.formatItemName=function(item,inList){const src=item._source;const topic=item.highlight&&item.highlight["discussions.topic"]?item.highlight["discussions.topic"][0]:$filter("escapeHtml")(src.discussions&&src.discussions.length&&src.discussions[0].topic?src.discussions[0].topic:"Unnamed discussion");const title=topic+" <small>on "+userFriendlyType(src.objectType)+"</small> "+$filter("escapeHtml")(src.objectName);return title};$scope.itemCount=function(){const hits=$scope.results&&$scope.results.hits?$scope.results.hits.total:0;return"<strong>"+hits+"</strong> discussion"+(hits>1?"s":"")};$scope.selectInput=function(){$(".catalog-search-input").select()};$scope.inboxFacetFilter=function(search){return item=>item.key!==undefined&&(!search||item.key.toLowerCase().includes(search.toLowerCase()))}})})();(function(){"use strict";const app=angular.module("dataiku.deployer",[]);app.controller("DeployerHomeController",function($scope,$rootScope,TopNav,DataikuAPI,$q){TopNav.setNoItem();TopNav.setLocation(TopNav.TOP_DEPLOYER,"");const MAX_STAGE_COUNT=5;function stageCounts(infrasOrEndpointScopes,stages){stages=stages.slice(0,MAX_STAGE_COUNT);const counts=stages.reduce((obj,stage)=>({...obj,[stage.id]:0}),{});infrasOrEndpointScopes.forEach(infraOrEndpointScope=>{let stageId=infraOrEndpointScope.stage;if(!stages.find(stage=>stage.id===stageId)){stageId="__OTHERS__"}if(!(stageId in counts)){counts[stageId]=0}counts[stageId]++});return counts}$scope.monitoredExternalEndpointsCount=null;$scope.managedApiDeploymentsCount=null;$scope.totalProjectsDeploymentsCount=null;$scope.managedApiDeploymentsPerStage=null;$scope.externalApiDeploymentsPerStage=null;$scope.isDeployerHomePageReady=function(){return $scope.monitoredExternalEndpointsCount!==null&&$scope.managedApiDeploymentsCount!==null&&$scope.totalProjectsDeploymentsCount!==null};function getTotalApiDeploymentsPerStage(){$scope.totalApiDeploymentsPerStage={};const stages=new Set([...Object.keys($scope.managedApiDeploymentsPerStage||{}),...Object.keys($scope.externalApiDeploymentsPerStage||{})]);stages.forEach(stage=>{$scope.totalApiDeploymentsPerStage[stage]=($scope.managedApiDeploymentsPerStage[stage]||0)+($scope.externalApiDeploymentsPerStage[stage]||0)})}DataikuAPI.projectdeployer.deployments.listLightStatus().success(function(deployments){$scope.totalProjectsDeploymentsCount=deployments.length;if(deployments.length){$scope.projectDeploymentsPerStage=stageCounts(deployments.map(deployment=>deployment.infraBasicInfo),$rootScope.appConfig.projectDeploymentStages)}}).error(setErrorInScope.bind($scope));const promises=[DataikuAPI.apideployer.deployments.listLightStatus().success(function(deployments){$scope.managedApiDeploymentsCount=deployments.length;let managedApiDeploymentsPerStage={};if(deployments.length){managedApiDeploymentsPerStage=stageCounts(deployments.map(deployment=>deployment.infraBasicInfo),$rootScope.appConfig.apiDeploymentStages)}$scope.managedApiDeploymentsPerStage=managedApiDeploymentsPerStage}).error(setErrorInScope.bind($scope)),DataikuAPI.unifiedMonitoring.deployer.apiEndpoints.list().success(function(apiEndpointsMonitoring){$scope.monitoredExternalEndpointsCount=apiEndpointsMonitoring.filter(e=>e.type==="EXTERNAL_API_ENDPOINT").length;let externalApiDeploymentsPerStage={};if(apiEndpointsMonitoring.length>0){externalApiDeploymentsPerStage=stageCounts(apiEndpointsMonitoring.filter(e=>e.type==="EXTERNAL_API_ENDPOINT").map(e=>e.externalEndpointsScope),$rootScope.appConfig.apiDeploymentStages)}$scope.externalApiDeploymentsPerStage=externalApiDeploymentsPerStage}).error(setErrorInScope.bind($scope))];$q.all(promises).then(()=>{getTotalApiDeploymentsPerStage()})});app.controller("_DeployerBaseController",function($rootScope,$scope,TaggingService,DataikuCloudService){const getLaunchpadExtensionsLink=function(){DataikuCloudService.getCloudInfo().then(cloudInfo=>{if(cloudInfo.isDataikuCloud&&cloudInfo.isSpaceAdmin){$scope.launchpadExtensionsUrl=DataikuCloudService.getLaunchpadUrl()+"/extensions"}})};TaggingService.fetchGlobalTags();$scope.isCloud=DataikuCloudService.isDataikuCloud();const appConfig=$rootScope.appConfig;$scope.onlyForDataikerAdminWhenInCloud=!$scope.isCloud||appConfig.canAccessCloudDataikerAdminCapabilities;$scope.isK8sInfraCreationDisabled=$scope.isCloud&&!appConfig.isCloudK8sInfraCreationEnabled;if($scope.isCloud){getLaunchpadExtensionsLink()}});app.service("DeployerUtils",function(){const svc=this;svc.DEPLOY_SOURCE={PACKAGE_PANEL:"PACKAGE_PANEL",PACKAGE:"PACKAGE"};svc.hasUrlSuffix=function(url){const pat=/https?:\/\/[^/]+(\/+[^/].*)/;return pat.test(url)};svc.enabledDeploymentCount=function(deployments,enabled){return deployments.filter(depl=>depl.enabled===!!enabled).length};svc.stageDetails=function(stages,stageId){const foundStage=stages.find(s=>s.id==stageId);return stageId+" - "+(foundStage?foundStage.desc:"Unknown stage")};svc.getParticipatingVersions=function(deploymentBasicInfo){const dbi=deploymentBasicInfo;if(!dbi.generationsMapping){return[]}else if(dbi.generationsMapping.mode=="SINGLE_GENERATION"){return[dbi.generationsMapping.generation]}else{return dbi.generationsMapping.entries.map(e=>e.generation)}};svc.getDeploymentsPerPackageAndStage=function(publishedItemStatus,allStages,displayedStages,packageType){const ret={};const infraStagesById=svc.getInfraStagesById(publishedItemStatus,allStages);displayedStages=displayedStages||allStages;if(displayedStages.some(stage=>stage.id==="__OTHERS__")){allStages=svc.addOthersStage(allStages)}(publishedItemStatus.packages||[]).forEach(function(pkg){ret[pkg.id]={count:0,perStage:allStages.reduce((obj,stage,idx)=>({...obj,[stage.id]:{idx:idx,deployments:[]}}),{})}});(publishedItemStatus.deployments||[]).forEach(function(deploymentBasicInfo){if(packageType==="bundle"){addCounts(ret,deploymentBasicInfo.bundleId,deploymentBasicInfo)}else{const participatingVersions=svc.getParticipatingVersions(deploymentBasicInfo);participatingVersions.forEach(function(version){addCounts(ret,version,deploymentBasicInfo)})}});return ret;function addCounts(item,packageId,deploymentBasicInfo){const packageInfo=item[packageId];if(!packageInfo)return;const stageId=infraStagesById[deploymentBasicInfo.infraId];const isOtherStage=!displayedStages.some(stage=>stage.id===stageId)||stageId==="__OTHERS__";packageInfo.count++;if(isOtherStage){packageInfo.others=packageInfo.others||{stageCounts:{},deployments:[]};addStage(stageId,packageInfo.others.stageCounts);packageInfo.others.deployments.push(deploymentBasicInfo)}packageInfo.perStage[stageId].deployments.push(deploymentBasicInfo)}};svc.getDeploymentCountsPerPublishedItemAndStage=function(publishedItemStatus,allStages,displayedStages){const infraStagesById=svc.getInfraStagesById(publishedItemStatus,allStages);displayedStages=displayedStages||allStages;if(displayedStages.some(stage=>stage.id==="__OTHERS__")){allStages=svc.addOthersStage(allStages)}const deployments={counts:allStages.reduce((obj,stage)=>({...obj,[stage.id]:0}),{})};publishedItemStatus.deployments.forEach(deployment=>{const originalStageId=infraStagesById[deployment.infraId];const isOtherStage=!displayedStages.some(stage=>stage.id===originalStageId)||originalStageId==="__OTHERS__";const newStageId=isOtherStage?"__OTHERS__":originalStageId;addStage(newStageId,deployments.counts);if(isOtherStage){deployments.others=deployments.others||{};addStage(originalStageId,deployments.others)}});return deployments};function addStage(stageId,countObj){countObj[stageId]=countObj[stageId]||0;countObj[stageId]++}svc.getInfraStagesById=function(publishedItemStatus,stages){const infraStagesById={};publishedItemStatus.infras.forEach(function(infra){let stageId=infra.stage;infraStagesById[infra.id]=!stages.some(stage=>stage.id===stageId)?"__OTHERS__":stageId});return infraStagesById};svc.getStagesToDisplay=function(publishedItemStatusList,stages,maxStageCount){const infraStagesByIdList=publishedItemStatusList.map(publishedItemStatus=>svc.getInfraStagesById(publishedItemStatus,stages));const hasUnknownStages=infraStagesByIdList.some(infraStagesById=>Object.values(infraStagesById).some(stage=>stage==="__OTHERS__"));if(hasUnknownStages||maxStageCount<stages.length){stages=svc.addOthersStage(stages.slice(0,maxStageCount))}return stages};svc.addOthersStage=function(stages){stages=angular.copy(stages);if(!stages.some(stage=>stage.id==="__OTHERS__")){stages.push({id:"__OTHERS__"})}return stages};svc.getStageCountColor=function(deployments,heavyStatusByDeploymentId,canBeDisabled){if(!deployments||!deployments.length){return"#ddd"}if(canBeDisabled&&!deployments.find(depl=>depl.enabled)){return"#ccc"}if(deployments.some(depl=>["ERROR","UNHEALTHY","LOADING_FAILED"].includes((heavyStatusByDeploymentId[depl.id]||{}).health))){return"#ce1329"}if(deployments.some(depl=>["WARNING","UNKNOWN","OUT_OF_SYNC"].includes((heavyStatusByDeploymentId[depl.id]||{}).health))){return"#f8931e"}return"#81c241"};svc.getCannotDeployReason=function(publishedItemStatusList,infraStatusList,publishedItemType,isSinglePublishedItem=true){if(!publishedItemStatusList||!publishedItemStatusList.length){return`There are no ${publishedItemType}s to deploy`}if(!canDeploy(publishedItemStatusList)){return`You do not have permission to deploy ${isSinglePublishedItem?"this":"any"} ${publishedItemType}`}if(!infraStatusList||!infraStatusList.length){return"There are no infras to deploy on"}if(!canDeploy(infraStatusList)){return"You do not have permission to deploy on any infra"}return""};svc.getCannotDeleteVersionReason=function(hasDeployments,publishedItemStatus,publishedItemType){if(publishedItemStatus&&!publishedItemStatus.canWrite){return`You do not have permission to modify this ${publishedItemType}`}if(hasDeployments){return"Cannot remove a version with deployments"}return""};svc.getCannotDeleteServiceReason=function(hasDeployments,publishedItemStatus,publishedItemType){if(publishedItemStatus&&!publishedItemStatus.isAdmin){return`You do not have permission to delete this ${publishedItemType}`}if(hasDeployments){return"Cannot remove a service with deployments"}return""};function canDeploy(statusList){return statusList&&statusList.some(status=>status&&status.canDeploy)}function canWrite(statusList){return statusList&&statusList.some(status=>status&&status.canWrite)}svc.getFailedHeavyStatusLoadMessage=function(errorDetails){return{maxSeverity:"ERROR",messages:[{details:errorDetails.detailedMessage,message:errorDetails.detailedMessage,severity:"ERROR",title:"Failed loading the deployment status"}]}};svc.getOriginInfo=function(designNodeInfo){const originInfo={};if(designNodeInfo){originInfo.projectKey=designNodeInfo.projectKey;if(designNodeInfo.url){originInfo.url=designNodeInfo.url;if(originInfo.url.substr(-1)!=="/"){originInfo.url+="/"}originInfo.url+="projects/"+originInfo.projectKey+"/"}}return originInfo}});app.controller("_DeployerPermissionsController",function($scope,DataikuAPI){let initialPermissions;let hasOwner;function makeNewPerm(){$scope.newPerm=angular.copy(initialPermissions)}function buildUnassignedGroups(item){if(!item||!$scope.allGroups)return;$scope.unassignedGroups=$scope.allGroups.filter(function(groupName){return item.permissions.every(perm=>perm.group!==groupName)})}function fixupPermissions(item){if(!item){return}item.permissions.forEach(function(p){const permissionTypes=Object.keys(initialPermissions);permissionTypes.forEach(type=>{p[`$${type}Disabled`]=false});if(p.admin){permissionTypes.filter(type=>type!=="admin").forEach(type=>{p[type]=true;p[`$${type}Disabled`]=true})}else if(p.write||p.deploy){p.read=true;p.$readDisabled=true}})}function setGroups(item){DataikuAPI.security.listGroups(false).success(function(allGroups){if(allGroups){allGroups.sort()}$scope.allGroups=allGroups;if(hasOwner){DataikuAPI.security.listUsers().success(function(data){$scope.allUsers=data.sort((a,b)=>a.displayName.localeCompare(b.displayName));$scope.allUsersLogin=data.map(user=>"@"+user.login)}).error(setErrorInScope.bind($scope))}buildUnassignedGroups(item)}).error(setErrorInScope.bind($scope))}$scope.addPermission=function(item){item.permissions.push($scope.newPerm);makeNewPerm()};$scope.onPermissionChange=function(item){buildUnassignedGroups(item);fixupPermissions(item)};$scope.initPermissions=function(item,permissions,showOwner){initialPermissions=permissions;hasOwner=showOwner;fixupPermissions(item);setGroups(item);makeNewPerm()}});app.component("multiNodeInfraApiKeyCreationModal",{bindings:{modalControl:"<",infraId:"<",isAdmin:"<",fromDeployment:"<"},templateUrl:"/templates/project-deployer/multi-node-api-key-creation-modal.html",controller:function($rootScope,$scope,DataikuAPI,CreateModalFromComponent,multiNodeInfraApiKeyResultModalDirective){const $ctrl=this;$ctrl.$onInit=function(){$ctrl.defaultUser=$rootScope.appConfig.login;$ctrl.defaultLabel=$ctrl.infraId+"-"+moment().format("YYYYMMDD-HHmmss");$ctrl.label=$ctrl.defaultLabel;$ctrl.description="";$ctrl.forUser=""};$ctrl.create=function(){DataikuAPI.projectdeployer.infras.generatePersonalAPIKey($ctrl.infraId,$ctrl.label,$ctrl.description,$ctrl.forUser).success(function(data){CreateModalFromComponent(multiNodeInfraApiKeyResultModalDirective,{user:data.user,nodesAndKeys:data.nodesAndKeys,secret:data.secret,error:data.error,nodesWhereUserDoesNotExist:data.nodesWhereUserDoesNotExist,nodesWhereUserIsDisabled:data.nodesWhereUserIsDisabled}).then(_=>$ctrl.modalControl.resolve())}).error(setErrorInScope.bind($scope))}}});app.component("multiNodeInfraApiKeyResultModal",{bindings:{modalControl:"<",user:"<",nodesAndKeys:"<",secret:"<",error:"<",nodesWhereUserDoesNotExist:"<",nodesWhereUserIsDisabled:"<"},templateUrl:"/templates/project-deployer/multi-node-api-key-creation-result-modal.html",controller:function(ClipboardUtils){const $ctrl=this;$ctrl.goBack=function(){$ctrl.modalControl.dismiss()};$ctrl.copyKeyToClipboardAndClose=function(){ClipboardUtils.copyToClipboard($ctrl.secret,"Copied to clipboard.");$ctrl.close()};$ctrl.close=function(){$ctrl.modalControl.resolve()}}})})();(function(){"use strict";const app=angular.module("dataiku.deployer");app.constant("GOVERN_CHECK_POLICIES",[{id:"PREVENT",label:"Prevent the deployment of unapproved packages"},{id:"WARN",label:"Warn and ask for a confirmation before deploying unapproved packages"},{id:"NO_CHECK",label:"Always deploy without checking",default:true}]);app.filter("infoMessageSeverityToIcon",function(){const dict={SUCCESS:"dku-icon-checkmark-circle-outline-20 text-success",INFO:"dku-icon-checkmark-circle-outline-20 text-success",WARNING:"dku-icon-warning-fill-20 text-warning",ERROR:"dku-icon-dismiss-circle-fill-20 text-error"};return function(severity){if(!severity){return dict.SUCCESS}return dict[severity]||""}});app.controller("_DeployerInfrasListController",function($scope,$controller,$state,TopNav,CreateModalFromTemplate,WT1,$rootScope,GOVERN_CHECK_POLICIES){$scope.GOVERN_CHECK_POLICIES=GOVERN_CHECK_POLICIES;$controller("_DeployerBaseController",{$scope:$scope});const navLocation=`TOP_${$scope.deployerType.toUpperCase()}_DEPLOYER`;TopNav.setNoItem();TopNav.setLocation(TopNav[navLocation],"infras");if($scope.isFeatureLocked)return;$scope.uiState={};$scope.canCreateInfras=function(){return $rootScope.appConfig.admin};$scope.startCreateInfra=function(){CreateModalFromTemplate(`/templates/${$scope.deployerType}-deployer/new-infra-modal.html`,$scope).then(function(newInfra){$state.go(`${$scope.deployerType}deployer.infras.infra.settings`,{infraId:newInfra.id});WT1.event(`${$scope.deployerType}-deployer-infra-setup`,{infraType:newInfra.type})})};$scope.refreshInfraStatusList=function(){$scope.deployerAPIBase.infras.listLightStatus().success(function(infraStatusList){$scope.infraStatusList=infraStatusList}).error(setErrorInScope.bind($scope))};$scope.refreshInfraStatusList()});app.controller("_DeployerInfraController",function($scope,$state,$controller,Dialogs,ActivityIndicator,WT1,CreateModalFromComponent,multiNodeInfraApiKeyCreationModalDirective,DataikuAPI,CreateModalFromTemplate){$controller("_DeployerBaseController",{$scope:$scope});$scope.refreshInfraStatus=function(){$scope.deployerAPIBase.infras.getLightStatus($state.params.infraId).success(infraStatus=>{$scope.infraStatus=infraStatus;$scope.isMultiAutomationNodeInfra=infraStatus&&infraStatus.infraBasicInfo.type==="MULTI_AUTOMATION_NODE"}).error(setErrorInScope.bind($scope))};$scope.deleteInfra=function(){if(!$scope.infraStatus){return}if($scope.infraStatus.deployments.length){Dialogs.error($scope,"Delete infra","You cannot delete this infra because it still has deployments!");return}Dialogs.confirm($scope,"Delete infra","Are you sure you want to delete this infra?").then(function(){WT1.event(`${$scope.deployerType}-deployer-infra-delete`,{infraType:$scope.infraStatus.infraBasicInfo.type});$scope.deployerAPIBase.infras.delete($scope.infraStatus.infraBasicInfo.id).success(()=>{ActivityIndicator.success(`Infra ${$scope.infraStatus.infraBasicInfo.id} successfully deleted.`);$state.go($scope.deployerType+"deployer.infras.list")}).error(setErrorInScope.bind($scope))})};$scope.generatePersonalAPIKey=function(){CreateModalFromComponent(multiNodeInfraApiKeyCreationModalDirective,{infraId:$scope.infraStatus.infraBasicInfo.id,isAdmin:$scope.infraStatus.isAdmin})};$scope.runConsistencyChecks=()=>{WT1.event(`multi-node-project-infra-run-consistency-checks`,{});DataikuAPI.projectdeployer.infras.runConsistencyChecks($scope.infraStatus.infraBasicInfo.id).then(result=>{CreateModalFromTemplate("/templates/project-deployer/consistency-check-report-modal.html",$scope,null,function(modalScope){modalScope.report=result.data;modalScope.automationNodes=(result.data.automationNodeIds||[]).join(", ");let nbOkConnections=0;let nbKoConnections=0;Object.values(modalScope.report.connectionsChecks).forEach(connection=>{if(connection.messages.length===0){connection.$reduced=true;nbOkConnections++}else{nbKoConnections++}});modalScope.nbKoConnections=nbKoConnections;modalScope.nbOkConnections=nbOkConnections})}).catch(setErrorInScope.bind($scope))};$scope.refreshInfraStatus()});app.controller("_DeployerInfraStatusController",function($scope,TopNav,DataikuCloudService){const navLocation=`TOP_${$scope.deployerType.toUpperCase()}_DEPLOYER`;$scope.isCloud=DataikuCloudService.isDataikuCloud();TopNav.setNoItem();TopNav.setLocation(TopNav[navLocation],"infras",null,"status")});app.controller("_DeployerInfraSetupModalController",function($scope,DeployerUtils,GOVERN_CHECK_POLICIES,DataikuCloudService){$scope.isCloud=DataikuCloudService.isDataikuCloud();$scope.newInfra={stage:(($scope.stages||[])[0]||{}).id,governCheckPolicy:GOVERN_CHECK_POLICIES.find(gcp=>gcp.default).id};$scope.hasUrlSuffix=DeployerUtils.hasUrlSuffix;$scope.ok=function(){$scope.deployerAPIBase.infras.create($scope.newInfra).success($scope.resolveModal).error(setErrorInScope.bind($scope))}});app.controller("_DeployerInfraHistoryController",function($scope,TopNav){const navLocation=`TOP_${$scope.deployerType.toUpperCase()}_DEPLOYER`;TopNav.setNoItem();TopNav.setLocation(TopNav[navLocation],"infras",null,"history")});app.controller("_DeployerInfraSettingsController",function($scope,$controller,$state,TopNav,ActivityIndicator,GOVERN_CHECK_POLICIES,DeployerUtils,WT1){$scope.GOVERN_CHECK_POLICIES=GOVERN_CHECK_POLICIES;let projectStandardsSeverities=[{id:1,label:"Lowest"},{id:2,label:"Low"},{id:3,label:"Medium"},{id:4,label:"High"},{id:5,label:"Critical"}];$scope.maxSeverityOptions=[{id:0,label:"No issues",default:true},...projectStandardsSeverities];$scope.checkErrorHandlingOptions=[{id:0,label:"Ignore check errors",default:true},...projectStandardsSeverities];const navLocation=`TOP_${$scope.deployerType.toUpperCase()}_DEPLOYER`;TopNav.setNoItem();TopNav.setLocation(TopNav[navLocation],"infras",null,"settings");$scope.uiState={settingsPane:"general",hooks:{selected:undefined,errorsAndWarnings:undefined,existingHookNames:[]}};$scope.hasUrlSuffix=DeployerUtils.hasUrlSuffix;$scope.deployerAndNodesDirectoryEnabled=$scope.appConfig.nodesDirectoryManagedDeployerServer||$scope.appConfig.nodesDirectoryManagedDeployerClient;$scope.invalidTabs=new Set;$scope.$watch("uiState.settingsPane",function(nv,ov){if(nv===ov)return;if($scope.infraSettingsForm.$invalid){$scope.invalidTabs.add(ov)}$scope.invalidTabs.delete(nv);$scope.setTagsValidity(true);$scope.setEnvVarsValidity(true);$scope.setLabelsValidity(true);$scope.setAnnotationsValidity(true)});$scope.referencedConnections=[];$scope.$watch("infra.remappedConnections",function(nv,ov){if(nv===ov)return;$scope.referencedConnections=Object.entries(nv||{}).filter(([name,connec])=>isConnectionFsLike(connec)).map(([name,connec])=>name)});function isConnectionFsLike(connection){switch(connection.type){case"Filesystem":case"Azure":case"EC2":case"GCS":return true;default:return false}}function isConnectionObjectStorage(connection){switch(connection.type){case"Azure":case"EC2":case"GCS":return true;default:return false}}let savedInfra;function refreshInfra(){$scope.deployerAPIBase.infras.getSettings($state.params.infraId).success(infra=>{$scope.infra=infra;$scope.isDockerBasedInfra=["SAGEMAKER","VERTEX_AI","AZURE_ML","K8S","SNOWPARK"].includes(infra.type);if(!$scope.infra.authConnection){$scope.infra.authConnection=null}if($scope.infra.type==="VERTEX_AI"&&!$scope.infra.machineConfig.acceleratorType){$scope.infra.machineConfig.acceleratorType="ACCELERATOR_TYPE_UNSPECIFIED"}$scope.updateExistingHookNames();savedInfra=angular.copy(infra)}).error(setErrorInScope.bind($scope))}$scope.infraIsDirty=function(){return!angular.equals(savedInfra,$scope.infra)};$scope.isInfraSettingsFormInvalid=function(){return $scope.infraSettingsForm.$invalid||$scope.invalidTabs.size};$scope.setTagsValidity=function(isValid){if(!$scope.infraSettingsForm)return;$scope.infraSettingsForm.$setValidity("tagsEditableList",isValid)};$scope.setEnvVarsValidity=function(isValid){if(!$scope.infraSettingsForm)return;$scope.infraSettingsForm.$setValidity("envVarsEditableList",isValid)};$scope.getUrlSuffixWarning=function(value){if($scope.hasUrlSuffix(value)){return"URL should be http[s]://host[:port]. A URL suffix is unexpected and will likely not work."}return null};$scope.setLabelsValidity=function(isValid){if(!$scope.infraSettingsForm)return;$scope.infraSettingsForm.$setValidity("labelsEditableList",isValid)};$scope.setAnnotationsValidity=function(isValid){if(!$scope.infraSettingsForm)return;$scope.infraSettingsForm.$setValidity("annotationsEditableList",isValid)};function getConnectionDetails(connectionName){if(!$scope.infra.remappedConnections){return null}return $scope.infra.remappedConnections[connectionName]}$scope.isAzureConnectionOAuth=function(connectionName){const connection=getConnectionDetails(connectionName);return!!connection&&connection.type=="Azure"&&connection.params.authType=="OAUTH2_APP"};function doesConnectionHaveABucket(connection){if(!connection||!connection.params){return false}return!!connection.params.chbucket||!!connection.params.chcontainer}$scope.doesFsLikeSettingsOverrideConnectionBucket=function(connectionName){const fsLikeSettings=$scope.infra.defaultApiNodeLogging.fsLikeSettings;const connection=getConnectionDetails(connectionName);return doesConnectionHaveABucket(connection)&&!!fsLikeSettings.bucket};$scope.doWeHaveAConnectionButNoBucketDefinedHereNorInFsLikeSettings=function(connectionName){const connection=getConnectionDetails(connectionName);if(!connection||!isConnectionObjectStorage(connection)){return false}const fsLikeSettings=$scope.infra.defaultApiNodeLogging.fsLikeSettings;return!doesConnectionHaveABucket(connection)&&!fsLikeSettings.bucket};$scope.auditLogStorageUrl=null;$scope.fetchAuditLogStorageUrl=function(){const fsLikeSettings=$scope.infra.defaultApiNodeLogging.fsLikeSettings;$scope.deployerAPIBase.infras.getAuditLogStorageUrl($state.params.infraId,fsLikeSettings.connectionName,fsLikeSettings.pathWithinConnection,fsLikeSettings.bucket).success(function(storageUrl){$scope.auditLogStorageUrl=storageUrl}).error(setErrorInScope.bind($scope))};$scope.$watch("infra.defaultApiNodeLogging.fsLikeSettings",function(nv,ov){if(nv===ov)return;$scope.fetchAuditLogStorageUrl()},true);$scope.saveInfra=function(createOrUpdateHook){if(!$scope.infra)return;if($scope.uiState.hooks.selected&&!createOrUpdateHook)return;WT1.event(`${$scope.deployerType}-deployer-infra-save`,{infraType:$scope.infra.type});$scope.deployerAPIBase.infras.save($scope.infra).success(function(result){if($scope.isInfraSettingsFormInvalid()){ActivityIndicator.warning("Saved with some invalid fields")}if(result&&result.maxSeverity&&result.maxSeverity!=="SUCCESS"){$scope.uiState.hooks.errorsAndWarnings=result}else{$scope.uiState.hooks.errorsAndWarnings=undefined}refreshInfra();$scope.refreshInfraStatus();if(createOrUpdateHook){$scope.updateExistingHookNames();$scope.uiState.hooks.selected=undefined}}).error(setErrorInScope.bind($scope))};$scope.updateExistingHookNames=function(){$scope.uiState.hooks.existingNames=$scope.infra.deploymentHookSettings?$scope.infra.deploymentHookSettings.preDeploymentHooks.map(h=>h.name).concat($scope.infra.deploymentHookSettings.postDeploymentHooks.map(h=>h.name)):[]};$scope.resetHookErrorsAndWarnings=function($event){$scope.uiState.hooks.errorsAndWarnings=undefined};$scope.updateHooksSettings=function($event){$scope.infra.deploymentHookSettings.hookCodeEnvName=$event.hookCodeEnvName;$scope.infra.deploymentHookSettings.runHooksAsUser=$event.runHooksAsUser;$scope.infra.deploymentHookSettings.maxHooksKernels=$event.maxHooksKernels};$scope.addOrUpdateHook=function($event){$scope.uiState.hooks.isPreDeployment=$event.isPreDeploymentHook;$scope.uiState.hooks.isNew=$event.isNew;$scope.uiState.hooks.selected=$event.hook};$scope.cancelAddOrUpdateHook=function($event){$scope.uiState.hooks.selected=undefined};$scope.confirmAddOrUpdateHook=function($event){if(!$scope.uiState.hooks.isNew&&$scope.uiState.hooks.isPreDeployment!==$event.isPreDeploymentHook){$scope.deleteHook({isPreDeploymentHook:$scope.uiState.hooks.isPreDeployment,hook:$scope.uiState.hooks.selected});const hooks=$event.isPreDeploymentHook?$scope.infra.deploymentHookSettings.preDeploymentHooks:$scope.infra.deploymentHookSettings.postDeploymentHooks;hooks.push($scope.uiState.hooks.selected)}else if($scope.uiState.hooks.isNew){const hooks=$event.isPreDeploymentHook?$scope.infra.deploymentHookSettings.preDeploymentHooks:$scope.infra.deploymentHookSettings.postDeploymentHooks;hooks.push($scope.uiState.hooks.selected)}$scope.uiState.hooks.selected.enabled=$event.hook.enabled;$scope.uiState.hooks.selected.name=$event.hook.name;$scope.uiState.hooks.selected.description=$event.hook.description;$scope.uiState.hooks.selected.code=$event.hook.code;$scope.$broadcast("tabSelect",($event.isPreDeploymentHook?"pre":"post")+"-deployment-hooks");if($event.save&&$scope.infraIsDirty()){$scope.saveInfra(true)}else{$scope.updateExistingHookNames();$scope.uiState.hooks.selected=undefined}};$scope.deleteHook=function($event){const hooks=$event.isPreDeploymentHook?$scope.infra.deploymentHookSettings.preDeploymentHooks:$scope.infra.deploymentHookSettings.postDeploymentHooks;const index=hooks.indexOf($event.hook);if(index>-1){hooks.splice(index,1)}$scope.updateExistingHookNames()};$controller("_DeployerPermissionsController",{$scope:$scope});const deregister=$scope.$watch("infra",function(nv,ov){if(!nv)return;$scope.initPermissions($scope.infra,{deploy:true,admin:false,read:false},false);deregister()},false);$scope.$watch("infra.permissions",function(nv,ov){if(!nv)return;$scope.onPermissionChange($scope.infra)},true);$scope.$watch("infra.permissions",function(nv,ov){if(!nv)return;$scope.onPermissionChange($scope.infra)},false);refreshInfra();checkChangesBeforeLeaving($scope,$scope.infraIsDirty)});app.filter("governCheckPolicyIdToLabel",function(GOVERN_CHECK_POLICIES){return function(governCheckPolicyId){if(!governCheckPolicyId){return}const governCheckPolicy=GOVERN_CHECK_POLICIES.find(policy=>policy.id===governCheckPolicyId);return governCheckPolicy?governCheckPolicy.label:governCheckPolicyId}});app.component("deploymentHooks",{bindings:{deploymentHookSettings:"<",infraType:"<",updateHooksSettings:"&",onAddOrUpdateHook:"&",onDeleteHook:"&"},template:`
<div class="flex w100">
    <div class="vertical-flex h100">
        <div>
            <div class="controls pull-right">
                <button data-qa-add-hook-btn class="btn btn--primary" ng-click="$ctrl.addHook()">Add new hook</button>
            </div>
            <span>Hooks are customized python code that executes automatically before or after every deployment made on this infrastructure.</span>

        </div>
        <div ng-if="$ctrl.infraType === 'MULTI_AUTOMATION_NODE'">
            <span class="text-warning">Each hook will be executed only once per deployment</span>
        </div>
        <div class="control-group mtop16">
            <label for="codeEnvName" class="control-label">Code-env</label>
            <div class="controls">
                <select dku-bs-select ng-model="$ctrl.deploymentHookSettings.hookCodeEnvName" ng-options="env.envName as env.envDesc for env in $ctrl.envNamesWithDescs" watch-model="$ctrl.envNamesWithDescs" ng-change="$ctrl.onSettingsChange()" data-live-search="true" id="codeEnvName"></select>
                <span class="help-inline">All hooks will be executed using this code environment</span>
            </div>
        </div>
        <div class="control-group mtop16">
            <label for="runAsUser" class="control-label">Run as user</label>
            <div class="controls">
                <ng2-typeahead [(value)]="$ctrl.deploymentHookSettings.runHooksAsUser" [suggestions]="$ctrl.usersForHookExecution" no-match-tooltip="No matching login" (value-change)="$ctrl.onSettingsChange()"
                               autocomplete-panel-width="600" placeholder="Deployer node login" style="display: inline-block"
                               disabled-if-message="!$ctrl.isAdmin ? 'Only an instance administrator can change the running user of hooks.' : null" ng-class="{'disabled-block': !$ctrl.isAdmin}">
                </ng2-typeahead>
                <span class="help-inline">All hooks will be executed impersonating this user. Leave empty to run hooks as the user requesting the deployment.</span>
            </div>
        </div>
        <div class="control-group mtop16">
            <label for="maxHooksKernels" class="control-label">Concurrent running hooks</label>
            <div class="controls">
                <input type="number" required min="1" ng-model="$ctrl.deploymentHookSettings.maxHooksKernels" ng-change="$ctrl.onSettingsChange()" class="editable-list__override-input-style" id="maxHooksKernels"/>
                <span class="help-inline">Limits the number of deployment hooks kernels running at the same time</span>
            </div>
        </div>
        <div class="alert alert-warning mtop16 mbot8" ng-if="$ctrl.deploymentHookSettings.maxHooksKernels > $ctrl.globalMaxKernels">
            <i class="icon-info-sign"></i> The global maximum number of hooks is {{$ctrl.globalMaxKernels}}, but you have set a higher value. The effective maximum concurrent kernels for this infrastructure will be capped by this global limit of {{globalMaxKernels}}.
        </div>
        <div class="mtop24 padding-none deployment-hooks-table">
            <tabs>
                <pane title="PRE-DEPLOYMENT HOOKS">
                    <deployment-hooks-list
                            hooks="$ctrl.deploymentHookSettings.preDeploymentHooks"
                            is-pre-deployment-hook="true"
                            show-hook-details="$ctrl.selectHook($event)"
                            delete-hook="$ctrl.deleteHook($event)"
                    ></deployment-hooks-list>
                </pane>
                <pane title="POST-DEPLOYMENT HOOKS">
                    <deployment-hooks-list
                            hooks="$ctrl.deploymentHookSettings.postDeploymentHooks"
                            is-pre-deployment-hook="false"
                            show-hook-details="$ctrl.selectHook($event)"
                            delete-hook="$ctrl.deleteHook($event)"
                    ></deployment-hooks-list>
                </pane>
            </tabs>
        </div>
    </div>
</div>
`,controller:function deploymentHooksController($rootScope,$scope,DataikuAPI,WT1,DataikuCloudService){const $ctrl=this;this.$onInit=function(){WT1.event("deployer-hooks-open",{infraType:$ctrl.infraType});$ctrl.isPreDeploymentHook=true;if($ctrl.infraType==="AUTOMATION_NODE"){$ctrl.infraClientParameter="automation_client, deploying_user, deployed_project_key, ";$ctrl.infraClientDoc=":param automation_client: an api client to connect to the automation node with the credentials defined in the infrastructure settings\n"+"    :type automation_client: A :class:`dataikuapi.dssclient.DSSClient`\n"+"    :param str deploying_user: identifier of the DSS user executing the deployment\n"+"    :param str deployed_project_key: key on the automation node of the deployed project\n"}else if($ctrl.infraType==="MULTI_AUTOMATION_NODE"){$ctrl.infraClientParameter="automation_clients, deploying_user, deployed_project_key, ";$ctrl.infraClientDoc=":param automation_clients: a dict of api clients to connect to the automation node with the credentials defined in the infrastructure settings, with node ids as keys\n"+"    :type automation_clients: dict[str, :class:`dataikuapi.dssclient.DSSClient]`\n"+"    :param str deploying_user: identifier of the DSS user executing the deployment\n"+"    :param str deployed_project_key: key on the automation node of the deployed project\n"}else{$ctrl.infraClientParameter="";$ctrl.infraClientDoc=""}$ctrl.isAdmin=$rootScope.appConfig.admin;const builtInEnv={envName:undefined,envDesc:"Use DSS builtin env"};$ctrl.envNamesWithDescs=[builtInEnv];$ctrl.usersForHookExecution=[];$ctrl.globalMaxKernels=$rootScope.appConfig.globalMaxDeploymentHooksKernels;DataikuAPI.codeenvs.listNames("PYTHON").then(function(result){const newEnvs=result.data.map(function(env){return{envName:env,envDesc:env}});$ctrl.envNamesWithDescs=[builtInEnv].concat(newEnvs)}).catch(setErrorInScope.bind($ctrl));DataikuAPI.security.listUsers().then(function(result){let users=result.data;if(DataikuCloudService.isDataikuCloud()){users=users.filter(user=>!user.login.includes("saas+admin@dataiku.com"))}$ctrl.usersForHookExecution=users.map(u=>u.login)}).catch(setErrorInScope.bind($ctrl))};$scope.$on("paneSelected",function(_,pane){$ctrl.isPreDeploymentHook=pane.slug==="pre-deployment-hooks"});$ctrl.onSettingsChange=function(){$ctrl.updateHooksSettings({$event:{hookCodeEnvName:$ctrl.deploymentHookSettings.hookCodeEnvName,runHooksAsUser:$ctrl.deploymentHookSettings.runHooksAsUser,maxHooksKernels:$ctrl.deploymentHookSettings.maxHooksKernels}})};$ctrl.addHook=function(){WT1.event("deployer-hooks-create");$ctrl.onAddOrUpdateHook({$event:{isPreDeploymentHook:$ctrl.isPreDeploymentHook,isNew:true,hook:{name:undefined,description:"",type:"inline",enabled:true,code:`def execute(requesting_user, deployment_id, deployment_report, deployer_client, ${$ctrl.infraClientParameter}**kwargs):
    """
    Custom hook function.

    :param str requesting_user: identifier of the DSS user requesting the deployment
    :param str deployment_id: id of the deployment in progress
    :param deployment_report: status of the deployment and messages related if any.
                              In case of a pre deployment hook, this parameter will be None
                              In case of a post deployment hook, it will be a dictionary with:
                                - "status" for the deployment status, can be "SUCCESS", "WARNING" or "ERROR"
                                - "messages" for the list of messages related to the deployment, as strings
    :type deployment_report: dict or None
    :param deployer_client: an api client to connect to the deployer node with the credentials of the user running hooks
    :type deployer_client: A :class:\`dataikuapi.dssclient.DSSClient\`
    ${$ctrl.infraClientDoc}
    :returns: The execution status of the hook and a message as string.
        Use \`HookResult.success(message)\`, \`HookResult.warning(message)\` or \`HookResult.error(message)\`
    """
    return HookResult.success("Ok")
    `}}})};$ctrl.selectHook=function($event){WT1.event("deployer-hooks-update");$ctrl.onAddOrUpdateHook({$event:{isPreDeploymentHook:$event.isPreDeploymentHook,isNew:false,hook:$event.hook}})};$ctrl.deleteHook=function($event){WT1.event("deployer-hooks-delete");$ctrl.onDeleteHook({$event:$event})}}});app.component("deploymentHooksList",{bindings:{hooks:"<",isPreDeploymentHook:"<",showHookDetails:"&",deleteHook:"&"},template:`
<div class="mtop30">
    <table ng-if="$ctrl.hooks.length > 0" class="table table-bordered table-fixed table-hover" aria-label="Deployment hooks list">
        <thead>
        <tr>
            <th class="hook-row-drag">&nbsp;</th>
            <th class="hook-row-name">Name</th>
            <th class="hook-row-description">Description</th>
            <th class="hook-row-status">Active</th>
            <th class="hook-row-delete">&nbsp;</th>
        </tr>
        </thead>
        <tbody ui-sortable="$ctrl.sortableOptions" ng-model="$ctrl.hooks">
        <tr ng-repeat="hook in $ctrl.hooks">
            <td class="hook-row-drag">
                <i class="sort-handle editable-list__drag-icon dku-icon-dots-multiple-16"/>
            </td>
            <td class="hook-row-name mx-textellipsis">
                    <span>
                        <a ng-click="$ctrl.showDetails(hook)">
                            {{hook.name}}
                        </a>
                    </span>
            </td>
            <td class="hook-row-description mx-textellipsis">
                <span>{{hook.description}}</span>
            </td>
            <td class="hook-row-status">
                <label class="dku-toggle dku-toggle--no-margin">
                    <input type="checkbox" ng-model="hook.enabled"/>
                    <span/>
                </label>
            </td>
            <td class="hook-row-delete">
                <div class="tac">
                    <span ng-click="$ctrl.delete(hook)"><i class="dku-icon-trash-16"></i></span>
                </div>
            </td>
        </tr>
        </tbody>
    </table>
    <div ng-if="$ctrl.hooks.length === 0" class="info-message-inline-display">No {{$ctrl.isPreDeploymentHook ? "pre" : "post"}} deployment hook defined</div>
</div>`,controller:function deploymentHooksListController($scope,Dialogs){const $ctrl=this;$ctrl.sortableOptions={axis:"y",cursor:"move",cancel:"",handle:".sort-handle"};$ctrl.delete=function(hook){Dialogs.confirm($scope,"Confirm deletion","Are you sure you want to delete the hook "+hook.name+"?").then(function(){$ctrl.deleteHook({$event:{isPreDeploymentHook:$ctrl.isPreDeploymentHook,hook:hook}})},function(){})};$ctrl.showDetails=function(hook){$ctrl.showHookDetails({$event:{isPreDeploymentHook:$ctrl.isPreDeploymentHook,hook:hook}})}}});app.component("deploymentHooksDetails",{bindings:{isPreDeploymentHook:"<",hook:"<",isNewHook:"<",existingHookNames:"<",hookCodeEnvName:"<",hookType:"<",backToList:"&",addOrUpdateHook:"&"},template:`
<div class="small-lr-padding page-top-padding padbot16 h100">
    <form name="$ctrl.hookDetailsForm" global-keydown="{'ctrl-s meta-s':'!$ctrl.disableAddOrUpdateButton() && $ctrl.addOrUpdate(true)'}" class="dkuform-horizontal-tight-pdeps generic-white-box h100 vertical-flex">
        <div class="noflex">
            <div class="btn-group pull-right">
                <button class="btn btn--secondary mright4" ng-click="$ctrl.cancel()">Cancel</button>
                <span ng-if="!$ctrl.disableAddOrUpdateButton()">
                    <button data-qa-create-btn class="btn btn--primary" ng-click="$ctrl.addOrUpdate(true)">{{$ctrl.addOrUpdateLabel}} and save</button>
                    <button class="btn btn--primary btn--icon dropdown-toggle manual-caret mleft0" data-toggle="dropdown">
                        <i class="icon-caret-down" />
                    </button>
                    <ul class="dropdown-menu pull-right">
                        <li>
                            <a ng-click="$ctrl.addOrUpdate(false)">
                                Only {{$ctrl.addOrUpdateLabel}}, don't save infrastructure settings
                            </a>
                        </li>
                    </ul>
                </span>
                <button ng-if="$ctrl.disableAddOrUpdateButton()" disabled class="btn btn--primary">{{$ctrl.addOrUpdateLabel}} and save</button>
            </div>
            <div class="control-group">
                <label for="hookId" class="control-label">Name</label>
                <div class="controls">
                    <input data-qa-hook-name-input type="text" ng-model="$ctrl.name" class="editable-list__override-input-style" id="hookId" ng-required="true" auto-focus="true"/>
                </div>
                <div class="alert alert-warning mtop8 mbot0" ng-if="$ctrl.isNameDuplicate()">
                    <div>
                        <i class="icon-dku-warning"></i> Another hook with the same name already exists.
                    </div>
                </div>
            </div>
        </div>
        <div class="control-group width-fit-content">
            <label class="control-label dku-toggle dku-toggle--no-margin">Set as</label>
            <div class="controls horizontal-flex">
                <label for="preDeployment">
                    <input type="radio" name="preOrPost" ng-model="$ctrl.isPreDeployment" ng-value="true" id="preDeployment"/>
                    &nbsp;Pre-deployment
                </label>
                <label for="postDeployment" class="mleft32">
                    <input type="radio" name="preOrPost" ng-model="$ctrl.isPreDeployment" ng-value="false" id="postDeployment"/>
                    &nbsp;Post-deployment
                </label>
            </div>
        </div>
        <div class="control-group">
            <label for="hookStatus" class="control-label dku-toggle dku-toggle--no-margin">Active</label>
            <div class="controls">
                <label class="dku-toggle dku-toggle--no-margin">
                    <input type="checkbox" ng-model="$ctrl.enabled" id="hookStatus"/>
                    <span/>
                </label>
            </div>
        </div>
        <div class="control-group">
            <label for="hookDescription" class="control-label">Description</label>
            <div class="controls">
                <textarea ng-model="$ctrl.description" class="w50" rows="3" id="hookDescription"/>
                <span class="help-inline">Describe what this hook is about</span>
            </div>
        </div>
        <div code-snippet-editor
             code="$ctrl.code"
             sample-type="'python'"
             categories="$ctrl.codeCategories"
             save-category="$ctrl.codeSaveCategory"
             editor-options="$ctrl.editorOptions"
             displayed
             class="mtop16">
        </div>
        <div class="mbot16 dku-border-left dku-border-bottom dku-border-right pad8">
            <div class="horizontal-flex aic">
                <div class="btn-group">
                    <button class="btn btn-default"
                        title="Only checks that the code compiles. Does not run it."
                        ng-click="$ctrl.validate()">
                        Validate
                    </button>
                </div>
                <div class="mleft8">
                    <div ng-show="$ctrl.validationDone && $ctrl.validationError" class="text-error">
                        <i class="icon-warning-sign"/>&nbsp;{{$ctrl.validationError.message}}
                        <a ng-click="$ctrl.gotoLine($ctrl.codeMirror, $ctrl.validationError.line, $ctrl.validationError.column)">{{$ctrl.errorPositionText}}</a>
                    </div>
                    <div class="text-success" ng-show="$ctrl.validationDone && !$ctrl.validationError">
                        <i class="icon-ok"/>&nbsp;Validation successful
                        <em class="smallgrey"> Hit Shift-Enter to run.</em>
                    </div>
                    <em class="smallgrey" ng-show="!$ctrl.validationDone">Hint: Hit Ctrl-Enter to validate, Shift-Enter to run</em>
                    </div>
            </div>
        </div>

    </form>
</div>`,controller:function deploymentHooksListController($scope,Dialogs,WT1,DataikuAPI,CodeMirrorSettingService){const $ctrl=this;this.$onChanges=function(changes){if(changes){$ctrl.isPreDeployment=changes.isPreDeploymentHook.currentValue;$ctrl.enabled=changes.hook.currentValue.enabled;$ctrl.name=changes.hook.currentValue.name;$ctrl.description=changes.hook.currentValue.description;$ctrl.code=changes.hook.currentValue.code;$ctrl.initialHook={isPreDeploymentHook:$ctrl.isPreDeployment,enabled:$ctrl.enabled,name:$ctrl.name,description:$ctrl.description,code:$ctrl.code};$ctrl.addOrUpdateLabel=$ctrl.isNewHook?"create":"update";$ctrl.codeCategories=[`py-${$ctrl.hookType}-deployer-hook`,`user-py-${$ctrl.hookType}-deployer-hook`];$ctrl.codeSaveCategory=`user-py-${$ctrl.hookType}-deployer-hook`;$ctrl.editorOptions=$ctrl.getEditorOptions()}};$ctrl.getEditorOptions=function(){const options=CodeMirrorSettingService.get("text/x-python",{onLoad:function(cm){$ctrl.codeMirror=cm}});options.extraKeys["Meta-Enter"]=function(cm){$ctrl.validate()};options.extraKeys["Ctrl-Enter"]=function(cm){$ctrl.validate()};return options};$ctrl.cancel=function(){WT1.event("deployer-hooks-edit-cancel");if($ctrl.noChange()){$ctrl.backToList({$event:{}})}else{Dialogs.confirm($scope,"Confirm cancellation","Are you sure you want to drop your changes?").then(function(){$ctrl.backToList({$event:{}})},function(){})}};$ctrl.addOrUpdate=function(save){WT1.event("deployer-hooks-add-or-update",{saveInfra:save,preHook:$ctrl.isPreDeployment});$ctrl.addOrUpdateHook({$event:{isPreDeploymentHook:$ctrl.isPreDeployment,save:save,hook:{enabled:$ctrl.enabled,name:$ctrl.name,description:$ctrl.description,code:$ctrl.code}}})};$ctrl.disableAddOrUpdateButton=function(){return $ctrl.noChange()||$ctrl.isInvalid()};$ctrl.noChange=function(){const currentHook={isPreDeploymentHook:$ctrl.isPreDeployment,enabled:$ctrl.enabled,name:$ctrl.name,description:$ctrl.description,code:$ctrl.code};return angular.equals(currentHook,$ctrl.initialHook)};$ctrl.isInvalid=function(){return $ctrl.hookDetailsForm.$invalid};$ctrl.isNameDuplicate=function(){return $ctrl.name&&$ctrl.name!==$ctrl.initialHook.name&&$ctrl.existingHookNames.includes($ctrl.name)};$ctrl.validate=function(){DataikuAPI.deployer.hooks.checkCodeCompiles($ctrl.code,$ctrl.hookCodeEnvName).success(function(data){$ctrl.validationDone=true;$ctrl.validationError=data.messages.length>0?data.messages[0]:undefined;$ctrl.errorPositionText=$ctrl.validationError?`(at line ${$ctrl.validationError.line}, character ${$ctrl.validationError.column})`:undefined}).error(setErrorInScope.bind($scope))};$ctrl.gotoLine=function(cm,line,column){if(cm&&line>0){const pos={ch:column,line:line-1};cm.scrollIntoView(pos);cm.setCursor(pos);cm.focus()}}}});app.component("deploymentHooksIssues",{bindings:{messages:"<",reset:"&"},template:`
<div class="generic-shadow-box mbot20 noflex">
    <div class="alert {{$ctrl.messages.maxSeverity|severityAlertClass}} df jcsb">
        <div class="df">
            <i class="{{$ctrl.messages.maxSeverity|deploymentHooksIssuesSeverityIcon}}"/>
            <h4 class="padleft16">Issues have been detected in some deployment hook settings.</h4>
        </div>
        <div>
            <a ng-click="$ctrl.resetHookErrors()">
                <i class="dku-icon-dismiss-16"></i>
            </a>
        </div>
    </div>
    <div info-messages-raw-list="$ctrl.messages"></div>
</div>`,controller:function deploymentHooksIssuesController(){const $ctrl=this;$ctrl.resetHookErrors=function(){$ctrl.reset({$event:{}})}}});app.filter("deploymentHooksIssuesSeverityIcon",function(){const dict={SUCCESS:"dku-icon-info-circle-outline-16",INFO:"dku-icon-info-circle-outline-16",WARNING:"dku-icon-warning-fill-16",ERROR:"dku-icon-dismiss-circle-fill-16"};return function(severity){if(!severity){return dict.SUCCESS}return dict[severity]||""}});app.component("deploymentHooksStates",{bindings:{hookExecutionStatus:"<",maxWidthPx:"<"},template:`
<div data-qa-deployment-hooks-status-container class="mtop8">
    <div ng-if="$ctrl.hookExecutionStatus.preHooks > 0">
        Executing {{$ctrl.hookExecutionStatus.preHooks}} {{'pre deployment hook' | plurify : $ctrl.hookExecutionStatus.preHooks}}
        <div ng-repeat="hookResult in $ctrl.hookExecutionStatus.preHookResults" class="horizontal-flex">
            <i class="{{hookResult.status | deploymentHookStatusToIcon}}"></i>
            <div class="vertical-flex padleft4">
                <span class="ellipsed">{{$ctrl.deploymentHookText(hookResult)}}</span>
                <show-ellipsed-text-and-copy ng-if="hookResult.message" class="height-fit-content horizontal-flex"
                    text="hookResult.message"
                    max-width-px="$ctrl.maxWidthPx"></show-ellipsed-text-and-copy>
            </div>
        </div>
    </div>
    <div ng-if="$ctrl.hookExecutionStatus.preHooks == 0">No pre deployment hook defined or enabled for this infrastructure</div>
    <div ng-if="$ctrl.hookExecutionStatus.deploymentStatus !== 'NOT_STARTED' && $ctrl.hookExecutionStatus.hasHooks" ng-class="{
            'text-warning': $ctrl.hookExecutionStatus.deploymentStatus === 'SKIPPED',
            'text-error': $ctrl.hookExecutionStatus.deploymentStatus === 'FAILED'
        }" class="mtop4 mbot4">{{$ctrl.hookExecutionStatus.deploymentStatusMessage}}</div>
    <div ng-if="$ctrl.hookExecutionStatus.postHooks > 0">
        Executing {{$ctrl.hookExecutionStatus.postHooks}} {{'post deployment hook' | plurify : $ctrl.hookExecutionStatus.postHooks}}
        <div ng-repeat="hookResult in $ctrl.hookExecutionStatus.postHookResults" class="horizontal-flex">
            <i class="{{hookResult.status | deploymentHookStatusToIcon}}"></i>
            <div class="vertical-flex padleft4">
                <span class="ellipsed">{{$ctrl.deploymentHookText(hookResult)}}</span>
                <show-ellipsed-text-and-copy ng-if="hookResult.message" class="height-fit-content horizontal-flex"
                    text="hookResult.message"
                    max-width-px="$ctrl.maxWidthPx"></show-ellipsed-text-and-copy>
            </div>
        </div>
    </div>
    <div ng-if="$ctrl.hookExecutionStatus.postHooks == 0">No post deployment hook defined or enabled for this infrastructure</div>
</div>`,controller:function deploymentHooksStatesController(){const $ctrl=this;$ctrl.deploymentHookText=function(hookResult){const withMessage=hookResult.message?", with message:":"";switch(hookResult.status){case"SUCCESS":return`Hook "${hookResult.name}" ended successfully${withMessage}`;case"WARNING":return`Hook "${hookResult.name}" returned a warning${withMessage}`;case"ERROR":return`Hook "${hookResult.name}" returned an error${withMessage}`;case"NOT_FINISHED":return`Executing hook "${hookResult.name}"...`;case"INTERRUPTED":return`Hook "${hookResult.name}" was interrupted`;case"TIMED_OUT":return`Hook "${hookResult.name}" timed out`;default:return`Unknown status "${hookResult.status}" for hook "${hookResult.name}"`}}}});app.filter("deploymentHookStatusToIcon",function(){const dict={SUCCESS:"dku-icon-checkmark-circle-fill-12 text-success dib",WARNING:"dku-icon-warning-fill-12 text-warning",ERROR:"dku-icon-error-circle-outline-12 text-error",NOT_FINISHED:"dku-icon-arrow-clockwise-dashes-12 icon-spin height-fit-content mtop4",INTERRUPTED:"dku-icon-cancel-12 text-error",TIMED_OUT:"dku-icon-clock-12 text-error"};return function(status){if(!status){return""}return dict[status]||""}})})();(function(){"use strict";const app=angular.module("dataiku.deployer");app.controller("_DeployerUploadPackageController",function($scope,$timeout){$scope.uiState=$scope.uiState||{};$scope.uiState.files=[];$scope.uiState.fileProperties=[];$scope.drop=function(files){angular.forEach(files,function(file){$scope.uiState.files.push(file);$scope.uiState.fileProperties.push({path:file.name,length:file.size})})};$scope.deleteFile=function(idx,e){e.preventDefault();e.stopPropagation();$scope.uiState.files.splice(idx,1);$scope.uiState.fileProperties.splice(idx,1)};$scope.uploadFilesAfterDigest=function(files){$timeout(function(){uploadFiles(files)})};function uploadFiles(files){files.forEach((file,idx)=>uploadOneFile(file,idx))}function uploadOneFile(fileToUpload,idx){const file={name:fileToUpload.name,size:fileToUpload.size,lastModified:fileToUpload.lastModified,progress:0};$scope.publishPackage(fileToUpload,function(e){if(e.lengthComputable){$scope.$apply(function(){file.progress=Math.round(e.loaded*100/e.total)})}}).then(function(response){$scope.uiState.fileProperties[idx].uploaded=true;if($scope.afterUploadCallback){$scope.afterUploadCallback(response)}},function(payload){setErrorInScope.call($scope,JSON.parse(payload.response||"{}"),payload.status,h=>payload.getResponseHeader(h))})}});app.service("DeployerPublishedItemsService",function($rootScope,$q,Dialogs){const svc=this;svc.DEPLOYMENT_METHOD_ID={NEW:"NEW",UPDATE:"UPDATE"};svc.deployPackage=function(publishedItemStatus,packageType){const deferred=$q.defer();const deploymentMethods=getDeploymentMethods(packageType);if(!publishedItemStatus.deployments.length){return $q.resolve(svc.DEPLOYMENT_METHOD_ID.NEW)}else{Dialogs.select($rootScope,`Deploy ${packageType}`,`Choose how to deploy this ${packageType}`,deploymentMethods,deploymentMethods[1]).then(function(item){deferred.resolve(item.id)});return deferred.promise}};svc.openDeploymentSelector=function(publishedItemStatus,includeInfraType){const infraTypeMap=includeInfraType?publishedItemStatus.infras.reduce((obj,infra)=>({...obj,[infra.id]:infra.type}),{}):{};const deployments=publishedItemStatus.deployments.map(depl=>{const type=infraTypeMap[depl.infraId];return{id:depl.id,title:depl.id,...type&&{type:type},desc:`Infra: ${depl.infraId} ${type?` (${type})`:""}`}});return Dialogs.select($rootScope,"Choose the deployment","Choose which deployment you want to edit",deployments,deployments[0])};function getDeploymentMethods(packageType){return[{id:svc.DEPLOYMENT_METHOD_ID.NEW,title:"Create",desc:`Create a new deployment based on this ${packageType}`},{id:svc.DEPLOYMENT_METHOD_ID.UPDATE,title:"Update",desc:`Change the ${packageType} used in an existing deployment`}]}})})();(function(){"use strict";const app=angular.module("dataiku.deployer");app.factory("deploymentHealthIcon",function(){const deploymentHealthIcons={HEALTHY:"dku-icon-checkmark-circle-outline-",WARNING:"dku-icon-warning-fill-",OUT_OF_SYNC:"dku-icon-arrow-circular-strike-",UNHEALTHY:"dku-icon-dismiss-circle-fill-",ERROR:"dku-icon-dismiss-circle-fill-",UNKNOWN:"dku-icon-empty-",LOADING:"icon-spin dku-icon-arrow-circular-",DISABLED:"dku-icon-line-",LOADING_FAILED:"dku-icon-dismiss-circle-fill-"};return{build:(health,classes,iconSize)=>{if(!health){return classes+deploymentHealthIcons.LOADING+iconSize}if(deploymentHealthIcons[health]){return classes+deploymentHealthIcons[health]+iconSize}return""}}});app.filter("deploymentHealthToIcon",function(deploymentHealthIcon){return function(health,iconSize){return deploymentHealthIcon.build(health,"deployer-deployment-status-icon ",iconSize||"20")}});app.filter("deploymentHealthToRoundedIcon",function(deploymentHealthIcon){return function(health){return deploymentHealthIcon.build(health,"deployer-deployment-status-icon-round ","24")}});app.filter("healthStatusToFriendly",function(){return function(healthStatus){if(!healthStatus)return;return healthStatus.charAt(0).toUpperCase()+healthStatus.substr(1).toLowerCase().replaceAll("_"," ")}});app.filter("deploymentUpdateStateToIconClasses",function(){return state=>{const classes={RUNNING:"dku-icon-arrow-circular-16 icon-spin",SUCCESS:"dku-icon-checkmark-circle-outline-16 success",INFO:"dku-icon-checkmark-circle-fill-16 success",WARNING:"dku-icon-warning-fill-16 warning",ERROR:"dku-icon-dismiss-circle-fill-16 failed",ABORTED:"dku-icon-cancel-16 aborted"}[state];const defaultClasses="dku-icon-line-16 aborted";return classes||defaultClasses}});app.service("DeployerDeploymentTileService",function($filter){const deploymentHeavyStatusToHealthMessage=function(heavyStatus){const displayedHealth=$filter("healthStatusToFriendly")(heavyStatus.health);if(heavyStatus.health==="HEALTHY"){return displayedHealth}let severityMessage=heavyStatus.healthMessages.messages.find(msg=>msg.severity==heavyStatus.healthMessages.maxSeverity);let message=displayedHealth;if(severityMessage){message+=" - "+severityMessage.message}return message};return{getDeploymentHealth:function(heavyStatus){var currentState="LOADING";var message="";if(heavyStatus){currentState=heavyStatus.health;message=deploymentHeavyStatusToHealthMessage(heavyStatus)}return{currentState:currentState,message:message}},getDeploymentHealthMap:function(deployments,heavyStatusMap){if(!deployments||!heavyStatusMap)return;const healthMap={};deployments.forEach(deployment=>{healthMap[deployment.id]=this.getDeploymentHealth(heavyStatusMap[deployment.id])});return healthMap}}});app.controller("_DeployerDeploymentDashboardController",function($scope,$controller,$filter,TopNav,TaggingService,openDkuPopin){$controller("_DeployerBaseController",{$scope:$scope});const navLocation=`TOP_${$scope.deployerType.toUpperCase()}_DEPLOYER`;TopNav.setNoItem();TopNav.setLocation(TopNav[navLocation],"deployments");if($scope.isFeatureLocked)return;$scope.uiState=$scope.uiState||{};$scope.uiState.query={q:"",tags:[]};$scope.uiState.query[`${$scope.publishedItemType}s`]=[];$scope.orderByExpression=[];$scope.rowHeaderHeight=45;$scope.deployerAPIBase.deployments.listTags().success(tags=>{TaggingService.setProjectTags(TaggingService.fillTagsMapFromArray(tags))}).error(setErrorInScope.bind($scope));$scope.deployerHasPublishedPackages=function(itemList){return(itemList||[]).some(item=>!!item.packages.length)};$scope.displayedStages=angular.copy($scope.stages);const getDeploymentsPerStage=function(lightStatusList){const deploymentsPerStage=$scope.displayedStages.reduce((obj,stage)=>({...obj,[stage.id]:[]}),{});lightStatusList.forEach(function(lightStatus){let stageId=lightStatus.infraBasicInfo.stage;if(!$scope.displayedStages.find(stage=>stage.id===stageId)){stageId="__OTHERS__"}if(!(stageId in deploymentsPerStage)){deploymentsPerStage[stageId]=[];$scope.displayedStages.push({id:stageId})}deploymentsPerStage[stageId].push(lightStatus)});return deploymentsPerStage};$scope.refreshForFilter=function(filteredDeploymentStatusList){$scope.deploymentsPerStage=getDeploymentsPerStage(filteredDeploymentStatusList);$scope.deploymentsByRow=[];$scope.deploymentHeaders=$scope.deploymentHeaders||Object.keys($scope.deploymentsPerStage);$scope.columnWidths=$scope.columnWidths||$scope.deploymentHeaders.map(_=>330);const rowCount=Math.max.apply(null,Object.values($scope.deploymentsPerStage).map(d=>d.length));if(rowCount>0){for(let row=0;row<rowCount;row++){const rowData=[];for(let stage in $scope.deploymentsPerStage){rowData.push(($scope.deploymentsPerStage[stage]||[])[row])}$scope.deploymentsByRow.push(rowData)}}};$scope.filterDeployments=function(){const filteredDeploymentStatusList=$filter("orderBy")($scope.deploymentsStatusList.filter(lightStatus=>$scope.deploymentIsInUI(lightStatus)),$scope.orderByExpression);$scope.refreshForFilter(filteredDeploymentStatusList)};$scope.selectAndFilterDeployments=function(item){item.$selected=!item.$selected;$scope.filterDeployments()};$scope.$watch("uiState.query",(nv,ov)=>{if(nv!==ov){$scope.filterDeployments()}},true);$scope.$on("tagSelectedInList",function(e,tag){let index=$scope.uiState.query.tags.indexOf(tag);if(index>=0){$scope.uiState.query.tags.splice(index,1)}else{$scope.uiState.query.tags.push(tag)}e.stopPropagation()});$scope.refreshAllDeployments=function(){$scope.heavyStatusPerDeploymentId={};$scope.globalLightStatusLoaded=false;$scope.deployerAPIBase.globalLightStatus().success(gls=>{$scope.globalLightStatusLoaded=true;$scope.deploymentsStatusList=gls.deploymentsStatus;$scope.infraStatusList=gls.infrasStatus;$scope[`${$scope.publishedItemType}StatusList`]=gls[`${$scope.publishedItemType}sStatus`];$scope.refreshForFilter($scope.deploymentsStatusList)}).error(setErrorInScope.bind($scope))};$scope.refreshAllDeployments();$scope.deployerHasPublishedPackages=function(itemList){return(itemList||[]).some(item=>!!item.packages.length)};$scope.countSelectedItems=function(itemList){return(itemList||[]).filter(item=>item.$selected).length};$scope.clearSelectedItems=function(itemList){return(itemList||[]).forEach(item=>item.$selected=false)};$scope.clearAndRefreshFilter=function(itemList){$scope.clearSelectedItems(itemList);$scope.filterDeployments()};$scope.countSelectedHealthStatuses=function(){return $scope.countSelectedItems($scope.uiState.query.healthStatusMap)};$scope.countSelectedTypeBadges=function(){return $scope.countSelectedItems($scope.uiState.query.typeBadgesMap)};$scope.showOpenInANewTabMenu=function($event,url){const template=`<ul class="dropdown-menu">
                <li><a ng-click="openInNewTab('${url}')">Open in a new tab...</a></li>
            </ul>`;const isElsewhere=(_,e)=>$(e.target).parents(".dropdown-menu").length==0;$scope.lockForPopup();const dkuPopinOptions={template:template,isElsewhere:isElsewhere,popinPosition:"CLICK",onDismiss:$scope.unlockAfterPopup};$scope.popupDismiss=openDkuPopin($scope,$event,dkuPopinOptions)};$scope.openInNewTab=url=>{if($scope.isPopupActive){if($scope.popupDismiss){$scope.popupDismiss();$scope.popupDismiss=undefined}}window.open(url,"_blank")};$scope.lockForPopup=()=>$scope.isPopupActive=true;$scope.unlockAfterPopup=()=>$scope.isPopupActive=false});app.controller("_DeployerPackagesPanelController",function($scope,$stateParams){$scope.DEPLOYED_STATE={ALL:$scope.deployerType==="api"?"All versions":"All bundles",DEPLOYED:"Deployed",NOT_DEPLOYED:"Not deployed"};$scope.uiState={query:{search:"",deploy:$scope.DEPLOYED_STATE.ALL},noSelectedItem:true};function filterPublishedItemList(){$scope.uiState.noSelectedItem=itemList.every(item=>!item.$selected);itemList.forEach(item=>{let someVersionsAreShown=false;item.packages.forEach(pkg=>{pkg.$show=$scope.uiState.query.deploy===$scope.DEPLOYED_STATE.ALL||$scope.uiState.query.deploy===$scope.DEPLOYED_STATE.DEPLOYED&&pkg.$deployed||$scope.uiState.query.deploy===$scope.DEPLOYED_STATE.NOT_DEPLOYED&&!pkg.$deployed;const query=$scope.uiState.query.search.toLowerCase();if(!item[`${$scope.publishedItemType}BasicInfo`].id.toLowerCase().includes(query)&&!item[`${$scope.publishedItemType}BasicInfo`].name.toLowerCase().includes(query)){pkg.$show=pkg.$show&&(pkg.id.toLowerCase().includes(query)||pkg.$deployments.some(d=>d.toLowerCase().includes(query)))}someVersionsAreShown=pkg.$show||someVersionsAreShown});item.$show=($scope.uiState.noSelectedItem||item.$selected)&&someVersionsAreShown})}let itemList;$scope.computeFullList=function(statusList){itemList=statusList.filter(item=>{return item.packages.length}).map(item=>{item.$show=true;item.packages.forEach(pkg=>{pkg.$show=true;let deploymentsInfo=$scope.getPackageDeployments(item.deployments,pkg.id);pkg.$deployments=deploymentsInfo.map(d=>d.id);pkg.$deployed=deploymentsInfo.some(d=>{if(d.deploymentTag){return d.deploymentTag.lastModifiedOn>0}else{return!!d.id}})});item.$latestPackage=item.packages.slice(-1).pop();return item});return itemList};$scope.select=function(item){item.$selected=!item.$selected;filterPublishedItemList()};$scope.clearItemFilter=function(){$scope.clearSelectedItems(itemList);filterPublishedItemList()};$scope.setDeployFilter=function(deploy){$scope.uiState.query.deploy=deploy;filterPublishedItemList()};$scope.clearFilters=function(){$scope.uiState.query.search="";$scope.uiState.query.deploy=$scope.DEPLOYED_STATE.ALL;$scope.clearItemFilter()};$scope.getFilteredPackageCount=function(item){return item.packages.filter(pkg=>pkg.$show).length};$scope.deployerHasMatchingPublishedPackages=function(){return(itemList||[]).some(item=>item.$show&&!!$scope.getFilteredPackageCount(item))};$scope.isNewPackage=function(pck){return!pck.$deployed&&pck.publishedOn>=(new Date).getTime()-24*3600*1e3};$scope.hasActiveFilters=function(){return $scope.uiState.query.search||$scope.uiState.query.deploy!==$scope.DEPLOYED_STATE.ALL||(itemList||[]).some(item=>item.$selected)};$scope.$watch("uiState.query.search",function(nv,ov){if(nv===ov)return;filterPublishedItemList()})});app.controller("_DeployerDeploymentController",function($controller,$scope,$state,Dialogs,Assert,$rootScope,TaggingService,$filter,$interval,ActivityIndicator,WT1,SharedLastDeploymentAction){$controller("_DeployerBaseController",{$scope:$scope});$scope.savedDeploymentSettings;$rootScope.activeProjectTagColor=TaggingService.getTagColor;$scope.getLightStatus=function(){return $scope.deployerAPIBase.deployments.getLightStatus($state.params.deploymentId).success(lightStatus=>{$scope.lightStatus=lightStatus}).error(setErrorInScope.bind($scope))};$scope.getHeavyStatus=function(noSpinner=false){Assert.trueish($scope.lightStatus);return $scope.deployerAPIBase.deployments.getHeavyStatus($scope.lightStatus.deploymentBasicInfo.id,true,noSpinner).success(function(data){$scope.heavyStatus=data})};$scope.refreshLightAndHeavy=function(){$scope.getLightStatus();$scope.refreshLastDeploymentAction()};$scope.getDeploymentSettings=function(){return $scope.deployerAPIBase.deployments.getSettings($state.params.deploymentId).success(function(data){$scope.savedDeploymentSettings=angular.copy(data);$scope.deploymentSettings=data;if($scope.deploymentSettings==="VERTEX_AI"&&!$scope.deploymentSettings.machineConfig.acceleratorType){$scope.deploymentSettings.machineConfig.acceleratorType="ACCELERATOR_TYPE_UNSPECIFIED"}}).error(setErrorInScope.bind($scope))};$scope.deploymentIsDirty=function(){return $scope.deploymentSettings&&!angular.equals($scope.savedDeploymentSettings,$scope.deploymentSettings)};$scope.isDeploymentSettingsInvalid=function(){return $scope.deploymentSettingsForm.$invalid};$scope.setTagsValidity=function(isValid){if(!$scope.deploymentSettingsForm)return;$scope.deploymentSettingsForm.$setValidity("tagsEditableList",isValid)};$scope.setEnvVarsValidity=function(isValid){if(!$scope.deploymentSettingsForm)return;$scope.deploymentSettingsForm.$setValidity("envVarsEditableList",isValid)};$scope.setLabelsValidity=function(isValid){if(!$scope.deploymentSettingsForm)return;$scope.deploymentSettingsForm.$setValidity("labelsEditableList",isValid)};$scope.setAnnotationsValidity=function(isValid){if(!$scope.deploymentSettingsForm)return;$scope.deploymentSettingsForm.$setValidity("annotationsEditableList",isValid)};$scope.saveDeployment=function(){Assert.trueish($scope.deploymentSettings);if(!$scope.deploymentIsDirty()||$scope.isDeploymentSettingsInvalid())return;return $scope.deployerAPIBase.deployments.save($scope.deploymentSettings).success(function(data){$scope.getLightStatus();$scope.savedDeploymentSettings=angular.copy(data);$scope.deploymentSettings=data}).error(setErrorInScope.bind($scope))};$scope.reallyDeleteDeployment=function(){WT1.event(`${$scope.deployerType}-deployer-deployment-delete`,{deploymentType:$scope.lightStatus.deploymentBasicInfo.type});$scope.stopFetchLastDeploymentAction();$scope.deployerAPIBase.deployments.delete($scope.lightStatus.deploymentBasicInfo.id).success(_=>$state.go(`${$scope.deployerType}deployer.deployments.dashboard`)).error(function(data,status,headers,config,statusText,xhrStatus){$scope.fetchLastDeploymentActionRepeat();if(data&&data.code){Dialogs.confirmAlert($scope,data.title,"Do you want to delete the deployment anyway?",data.detailedMessage,"ERROR").then(function(){$scope.deployerAPIBase.deployments.delete($scope.lightStatus.deploymentBasicInfo.id,true).success(_=>$state.go(`${$scope.deployerType}deployer.deployments.dashboard`)).error(setErrorInScope.bind($scope))})}else{setErrorInScope(data,status,headers,config,statusText,xhrStatus)}})};$scope.deleteDeployment=function(){if(!$scope.lightStatus){return}Dialogs.confirmAlert($scope,"Delete deployment","Are you sure you want to delete this deployment?",$scope.deleteWarning,"WARNING").then($scope.reallyDeleteDeployment)};$scope.lastDeploymentAction=null;$scope.cancelFetchLastDeploymentAction=null;function lastDeploymentActionChanged(deploymentAction){if(deploymentAction===null)return $scope.lastDeploymentAction!==null;else{if($scope.lastDeploymentAction===null)return true;return $scope.lastDeploymentAction.type!==deploymentAction.type||$scope.lastDeploymentAction.inProgress!==deploymentAction.inProgress}}function deploymentUpdateFinished(deploymentAction){return $scope.lastDeploymentAction?.inProgress&&$scope.lastDeploymentAction.type==="UPDATE"&&deploymentAction?.type==="UPDATE"&&!deploymentAction.inProgress}$scope.fetchLastDeploymentActionUntilCanceled=function(){$scope.deployerAPIBase.deployments.getLastDeploymentAction($state.params.deploymentId).success(lastDeploymentAction=>{SharedLastDeploymentAction.setData(lastDeploymentAction);if(lastDeploymentActionChanged(lastDeploymentAction)){if(deploymentUpdateFinished(lastDeploymentAction)){if(lastDeploymentAction.status==="SUCCESS"||lastDeploymentAction.status==="WARNING"||lastDeploymentAction.status==="INFO"){let message="Deployment updated successfully"+(lastDeploymentAction.status==="WARNING"?" (with warnings)":"");ActivityIndicator.success(message)}else{ActivityIndicator.error("Deployment update failed")}$scope.onUpdateFinished()}$scope.stopFetchLastDeploymentAction()}$scope.lastDeploymentAction=lastDeploymentAction;if($scope.cancelFetchLastDeploymentAction==null){$scope.fetchLastDeploymentActionRepeat()}}).error(function(a,b,c){$scope.stopFetchLastDeploymentAction();setErrorInScope.bind($scope)(a,b,c)})};$scope.fetchLastDeploymentActionRepeat=function(){let interval;if($scope.lastDeploymentAction===null||!$scope.lastDeploymentAction.inProgress){interval=10}else{interval=1}$scope.cancelFetchLastDeploymentAction=$interval(function(){$scope.fetchLastDeploymentActionUntilCanceled()},interval*1e3)};$scope.stopFetchLastDeploymentAction=function(){if($scope.cancelFetchLastDeploymentAction){$interval.cancel($scope.cancelFetchLastDeploymentAction)}$scope.cancelFetchLastDeploymentAction=null};$scope.refreshLastDeploymentAction=function(){$scope.stopFetchLastDeploymentAction();$scope.fetchLastDeploymentActionUntilCanceled()};$scope.$on("$destroy",function(){$scope.stopFetchLastDeploymentAction()});$scope.onPeekingUpdateStarted=function(){$scope.stopFetchLastDeploymentAction();$scope.deployerAPIBase.deployments.getLastDeploymentAction($state.params.deploymentId).success(lastDeploymentAction=>{SharedLastDeploymentAction.setData(lastDeploymentAction);$scope.lastDeploymentAction=lastDeploymentAction;if(lastDeploymentAction&&!lastDeploymentAction.inProgress){$scope.onUpdateFinished()}}).error(setErrorInScope.bind($scope))};$scope.otherActionInProgressMessage=function(){if($scope.lastDeploymentAction?.inProgress){return $filter("capitalize")($scope.lastDeploymentAction.type.toLowerCase())+" in progress"}else{return null}};$scope.showProgress=function(){if($scope.lastDeploymentAction){$scope.openProgressModal()}};$scope.insufficientPermissionsMessage=function(){return $scope.lightStatus&&$scope.lightStatus.hasFullDeployPermissions?"":"You don't have enough permissions on this deployment"};$scope.getLightStatus();$scope.fetchLastDeploymentActionUntilCanceled()});app.component("deploymentAction",{bindings:{action:"<",show:"&"},template:`
        <div class="horizontal-flex mx-center-children-vertically">
            <i class="dku-icon-arrow-circular-16 icon-spin mright16"></i>
            <div>
                {{ $ctrl.action.type | lowercase | capitalize }} in progress since <em>{{ $ctrl.action.startTimestamp | date:'yyyy-MM-dd HH:mm:ss' }}</em>
                , by <em>{{ $ctrl.action.requester.displayName || $ctrl.action.requester.login }}</em>. Thank you for your patience while the content is loading...
            </div>
            <div class="mleftauto mright8">
                <a ng-click="$ctrl.show()">
                    Show progress
                </a>
            </div>
        </div>
        `,controller:function(){const $ctrl=this}});app.component("deploymentUpdates",{bindings:{listUpdateHeads:"<",getUpdate:"&",getSettingsDiff:"&",deployerType:"<"},templateUrl:"/templates/deployer/deployment-updates.html",controller:function($scope,CreateModalFromTemplate,DiffFormatter,$filter,SharedLastDeploymentAction,StateUtils){const $ctrl=this;$ctrl.$onInit=function(){$ctrl.isProjectDeployer=$ctrl.deployerType==="project";$ctrl.emptyStateImage=`static/dataiku/images/deployer/empty-state-last-updates-${$ctrl.deployerType}-deployer.svg`;$ctrl.refreshUpdatesList()};$ctrl.refreshUpdatesList=function(reloadSelectedUpdate=false){$ctrl.listUpdateHeads().success(function(data){$ctrl.updateHeads=data||[];if($ctrl.updateHeads.length===0)return;if(!$ctrl.selectedUpdate){$ctrl.selectUpdate(data[0])}else if(reloadSelectedUpdate){const refreshedUpdate=data.find(d=>d.startTimestamp===$ctrl.selectedUpdate.startTimestamp);if(refreshedUpdate?.startTimestamp)loadUpdate(refreshedUpdate)}}).error(setErrorInScope.bind($scope))};$ctrl.selectUpdate=function(update){if($ctrl.selectedUpdate?.startTimestamp===update.startTimestamp){return}loadUpdate(update);loadSettingsDiff(update)};function setDeploymentStatus(heavyStatus){if(!heavyStatus){$ctrl.deploymentStatusIcon="dku-icon-empty-16";$ctrl.deploymentStatusTooltipText="Unknown";return}$ctrl.deploymentStatusIcon=$filter("deploymentHealthToIcon")(heavyStatus.health,16);$ctrl.deploymentStatusTooltipText=$filter("healthStatusToFriendly")(heavyStatus.health);const description=heavyStatus.healthMessages.messages.find(msg=>msg.severity===heavyStatus.healthMessages.maxSeverity);if(description){$ctrl.deploymentStatusTooltipText+=` - ${description.message}`}}function setPublishedItemValues(update){const{publishedItemIds:ids,deployment}=update;$ctrl.publishedItemValues={text:ids.join(", "),url:$ctrl.isProjectDeployer?StateUtils.href.projectDeployer.bundle(deployment.publishedProjectKey,ids[0]):StateUtils.href.apiDeployer.serviceVersions(deployment.publishedServiceId,ids)}}function loadUpdate(update){$ctrl.getUpdate({startTimestamp:update.startTimestamp}).success(function(data){if(!data)return;$ctrl.selectedUpdate=data;$ctrl.selectedUpdate.status=update.status;setDeploymentStatus(data.heavyStatus);setDeployedAs();setPublishedItemValues(data)}).error(setErrorInScope.bind($scope))}function loadSettingsDiff(update){$ctrl.getSettingsDiff({startTimestamp:update.startTimestamp}).success(function(diff){const allChanges=Array.isArray(diff.items)?diff.items:[];const changesToDisplay=allChanges.filter(c=>c?.fileChange?.addedLines>0||c?.fileChange?.removedLines>0);const hasPreviousUpdate=allChanges.length>0;const hasVisibleChanges=changesToDisplay.length>0;const displaysInfraWarning=shouldDisplayInfraWarning(allChanges,$ctrl.selectedUpdate,diff.hasInfraChange);const hasDataToDisplay=hasVisibleChanges||displaysInfraWarning;$ctrl.changesToDisplay=changesToDisplay;$ctrl.displaysInfraWarning=displaysInfraWarning;$ctrl.isViewChangesBtnEnabled=displaysInfraWarning||hasPreviousUpdate&&hasDataToDisplay;$ctrl.changesBtnTooltipText=getViewChangesTooltip(hasPreviousUpdate,hasDataToDisplay)}).error(setErrorInScope.bind($scope))}function getViewChangesTooltip(hasPreviousUpdate,hasDataToDisplay){if(!hasPreviousUpdate)return"No prior update available to compare changes";if(!hasDataToDisplay)return"No known changes for this update";return null}function shouldDisplayInfraWarning(changes,selectedUpdate,isInfraSettingsChanged){const isUpdateNotSuccessful=selectedUpdate?.status!=="SUCCESS";const isInfraSettingsDiffMissing=!changes.some(update=>update.id?.toLowerCase?.()==="infrastructure");return isUpdateNotSuccessful&&isInfraSettingsDiffMissing&&isInfraSettingsChanged}$ctrl.openUpdateChangesModal=function(){const templateUrl="/templates/deployer/update-changes-modal.html";CreateModalFromTemplate(templateUrl,$scope,null,function(modalScope){modalScope.toggle=update=>update.shown=!update.shown;modalScope.displaysInfraWarning=$ctrl.displaysInfraWarning;modalScope.displayedChanges=$ctrl.changesToDisplay.map(update=>({...update,shown:true,rendered:DiffFormatter.formatChange(update.fileChange)}))},true)};function setDeployedAs(){const{infra,deployment}=$ctrl.selectedUpdate||{};$ctrl.deployedAsItems=[];if(!$ctrl.isProjectDeployer||!infra.setDeployAsUser)return;const perProjectUser=infra.perProjectDeployAsUser?.find(item=>item.key===deployment?.deployedProjectKey)?.value;const automationUser=perProjectUser||infra.deployAsUser;if(!automationUser)return;if(infra.automationNodes?.length>0){infra.automationNodes.map(node=>{$ctrl.deployedAsItems.push({name:`${automationUser} (${node.automationNodeId})`,URL:`${node.automationNodeUrl}/profile/${automationUser}/`})})}else{$ctrl.deployedAsItems.push({name:`${automationUser}`,URL:`${infra.automationNodeUrl}/profile/${automationUser}/`})}}$scope.$watch(function(){return SharedLastDeploymentAction.data},function(nv,ov){if(nv&&nv!==ov){$ctrl.refreshUpdatesList(true)}},true)}});app.factory("SharedLastDeploymentAction",function(){var service={data:null,setData:function(data){service.data=angular.copy(data)}};return service})})();(function(){"use strict";const app=angular.module("dataiku.deployer");app.controller("GovernanceAbstractDeployerModalController",function($scope,DataikuAPI){$scope.governanceMessages={};$scope.governanceStatusLoaded=false;$scope.publishedItemId=null;$scope.infraId=null;$scope.packageId=null;$scope.deploymentId=null;$scope.deployment=null;$scope.ignoreWarnings=false;$scope.hasErrors=true;$scope.confirm=function(){$scope.resolveModal()};$scope.setIgnoreWarnings=function(value){$scope.ignoreWarnings=value};$scope.cancel=function(){$scope.dismiss()};function callGovernanceStatusApi($scope,deployerType){if(deployerType=="apiDeployer"){if($scope.publishedItemId&&$scope.infraId){return DataikuAPI.apideployer.deployments.getGovernanceStatusNewDeployment($scope.publishedItemId,$scope.infraId,$scope.packageId)}else if($scope.deployment){return DataikuAPI.apideployer.deployments.getGovernanceStatusDeployment($scope.deployment)}else{return DataikuAPI.apideployer.deployments.getGovernanceStatusDeploymentId($scope.deploymentId,$scope.infraId,$scope.packageId)}}else if(deployerType=="projectDeployer"){if($scope.publishedItemId&&$scope.infraId){return DataikuAPI.projectdeployer.deployments.getGovernanceStatusNewDeployment($scope.publishedItemId,$scope.infraId,$scope.packageId)}else if($scope.deployment){return DataikuAPI.projectdeployer.deployments.getGovernanceStatusDeployment($scope.deployment)}else{return DataikuAPI.projectdeployer.deployments.getGovernanceStatusDeploymentId($scope.deploymentId,$scope.infraId,$scope.packageId)}}}$scope.refreshGovernanceStatuses=function(deployerType){$scope.governanceMessages={};$scope.governanceStatusLoaded=false;callGovernanceStatusApi($scope,deployerType).success(governanceMessages=>{$scope.governanceStatusLoaded=true;$scope.governanceMessages=governanceMessages;$scope.hasErrors=governanceMessages.error;if(!governanceMessages.error&&!governanceMessages.warning){$scope.confirm();return}}).error(setErrorInScope.bind($scope))}})})();(function(){"use strict";const app=angular.module("dataiku.apideployer",["dataiku.lambda"]);app.controller("APIDeployerController",function($scope,$rootScope,DeployerUtils,DataikuAPI){$scope.DeployerUtils=DeployerUtils;$scope.deployerType="api";$scope.publishedItemType="service";$scope.deployerAPIBase=DataikuAPI.apideployer;$scope.stages=[].concat($rootScope.appConfig.apiDeploymentStages);$scope.defaultTitle="API Deployer";$scope.deployerObjectBar={title:$scope.defaultTitle};$scope.isFeatureLocked=!($rootScope.appConfig.licensedFeatures.apiNodeAllowed||$rootScope.appConfig.licensing.ceEntrepriseTrial)})})();(function(){"use strict";const app=angular.module("dataiku.apideployer");app.constant("INFRA_TYPES",{STATIC:"static",K8S:"Kubernetes",DATABRICKS:"Databricks",SAGEMAKER:"Amazon SageMaker",SNOWPARK:"Snowflake Snowpark",VERTEX_AI:"Google Vertex AI",AZURE_ML:"Azure Machine Learning"});app.controller("APIDeployerInfrasListController",function($scope,$controller,DataikuAPI,DeployerUtils){$controller("_DeployerInfrasListController",{$scope:$scope});if($scope.isFeatureLocked)return;$scope.$watch("infraStatusList",function(nv){if(!nv)return;nv.forEach(function(infraStatus){const infraId=infraStatus.infraBasicInfo.id;infraStatus.enabledDeploymentCount=DeployerUtils.enabledDeploymentCount(infraStatus.deployments,true);DataikuAPI.apideployer.infras.checkStatus(infraId).success(function(healthStatus){infraStatus.infraHealthError=healthStatus.messages.find(function(msg){return msg.severity===healthStatus.maxSeverity})||{}}).error(setErrorInScope.bind($scope))})})});app.controller("APIDeployerInfraController",function($controller,$scope,$rootScope){$controller("_DeployerInfraController",{$scope:$scope});$scope.uiState={};const deregisterInfra=$scope.$watch("infraStatus",function(nv,ov){if(!nv)return;let canDeleteInfraWhenInCloud;if(!$scope.isCloud){canDeleteInfraWhenInCloud=true}else{canDeleteInfraWhenInCloud=nv.infraBasicInfo.type!=="STATIC"||$rootScope.appConfig.canAccessCloudDataikerAdminCapabilities}$scope.uiState.canDeleteInfraWhenInCloud=canDeleteInfraWhenInCloud;deregisterInfra()},false)});app.controller("APIDeployerInfraSetupModalController",function($scope,$controller,$rootScope){$controller("_DeployerInfraSetupModalController",{$scope:$scope});$scope.newInfra.type="STATIC";$scope.appConfig=$rootScope.appConfig});app.controller("APIDeployerInfraStatusController",function($scope,$controller,DataikuAPI,APIDeployerAsyncHeavyStatusLoader,DeployerDeploymentTileService){$controller("_DeployerInfraStatusController",{$scope:$scope});let loader;$scope.$watch("infraStatus",function(nv){if(nv){let infraId=$scope.infraStatus.infraBasicInfo.id;DataikuAPI.apideployer.infras.checkStatus(infraId).success(function(healthStatus){$scope.infraHealthError=healthStatus.messages.find(function(msg){return msg.severity===healthStatus.maxSeverity})||{}}).error(setErrorInScope.bind($scope));$scope.healthMap={};const heavyStatusByDeploymentId={};loader=APIDeployerAsyncHeavyStatusLoader.newLoader(heavyStatusByDeploymentId);loader.loadFromInfraLightStatus(nv);const deregister=$scope.$watch(function(){return loader.stillRefreshing()},function(nv,ov){if(nv||ov===nv)return;$scope.healthMap=DeployerDeploymentTileService.getDeploymentHealthMap($scope.infraStatus.deployments,heavyStatusByDeploymentId);deregister()});$scope.$on("$destroy",function(){loader&&loader.stopLoading()})}})});app.controller("APIDeployerInfraHistoryController",function($scope,$controller){$controller("_DeployerInfraHistoryController",{$scope:$scope})});app.controller("APIDeployerInfraSettingsController",function($scope,$controller,$rootScope,DataikuAPI,ClipboardUtils,ActivityIndicator,APIDeploymentInfraHelper,FutureWatcher){$controller("_DeployerInfraSettingsController",{$scope:$scope});$scope.uiState.showInstanceTypeList=false;let inlineContainerConfig={name:"inline",type:"KUBERNETES",baseImageType:"EXEC",properties:[]};$scope.getInlineContainerConfig=function(){if($scope.infra){inlineContainerConfig.kubernetesNamespace=$scope.infra.k8sNamespace;inlineContainerConfig.kubeCtlContext=$scope.infra.k8sContext;inlineContainerConfig.kubeConfigPath=$scope.infra.k8sConfigPath;inlineContainerConfig.properties=$scope.infra.k8sProperties;inlineContainerConfig.baseImage=$scope.infra.baseImageTag;inlineContainerConfig.repositoryURL=$scope.infra.registryHost;inlineContainerConfig.pullRepositoryURL=$scope.infra.pullRegistryHost;inlineContainerConfig.prePushMode=$scope.infra.prePushMode;inlineContainerConfig.prePushScript=$scope.infra.prePushScript}return inlineContainerConfig};if($rootScope.appConfig.admin){DataikuAPI.admin.connections.list().success(function(allConnections){$scope.allConnections=allConnections}).error(setErrorInScope.bind($scope))}$scope.autoFillEventServer=function(){$scope.deployerAPIBase.infras.getDkuEventServerUrlAndKeys($scope.infra.type==="K8S").success(function(urlAndKeys){if(urlAndKeys&&urlAndKeys.isLocalEventServerEnabled){$scope.infra.defaultApiNodeLogging.eventServerURL=urlAndKeys.eventServerExtUrl?urlAndKeys.eventServerExtUrl:urlWithProtocolAndHost();$scope.infra.defaultApiNodeLogging.eventServerAuthKey=urlAndKeys.authKeys&&urlAndKeys.authKeys.length?urlAndKeys.authKeys[0].key:""}else{ActivityIndicator.warning("No local event server configured")}}).error(setErrorInScope.bind($scope))};DataikuAPI.admin.clusters.listAccessible("KUBERNETES").success(function(data){$scope.k8sClusterIds=data.map(function(c){return c.id})}).error(setErrorInScope.bind($scope));$scope.onLocalConnectionChanged=function(){if($scope.uiState.selectedLocalConnectionName){ClipboardUtils.copyToClipboard(JSON.stringify($scope.allConnections[$scope.uiState.selectedLocalConnectionName],null,2))}};$scope.deleteRemappedConnection=function(pckConId){if($scope.infra&&$scope.infra.remappedConnections){delete $scope.infra.remappedConnections[pckConId]}};$scope.hasRemappedConnections=function(){return $scope.infra&&Object.keys($scope.infra.remappedConnections).length};const requestSageMakerInstanceTypes=function(){$scope.deployerAPIBase.infras.getSageMakerInstanceTypes().success(function(data){$scope.instanceTypes=data}).error(setErrorInScope.bind($scope))};$scope.requestAzureMLInstanceTypes=function(infraId,authConnection,azWorkspace,azResourceGroup,azSubscription){$scope.deployerAPIBase.infras.getAzureMLInstanceTypes(infraId,authConnection,azWorkspace,azResourceGroup,azSubscription).success(function(data){$scope.instanceTypes=data;$scope.uiState.showInstanceTypeList=true}).error(setErrorInScope.bind($scope))};$scope.requestVertexAIInstanceTypes=function(infraId,authConnection,gcpProjectId,gcpRegion){$scope.deployerAPIBase.infras.getVertexAIInstanceTypes(infraId,authConnection,gcpProjectId,gcpRegion).success(function(data){$scope.instanceTypes=data;$scope.uiState.showInstanceTypeList=true}).error(setErrorInScope.bind($scope))};const requestVertexAIAcceleratorTypes=function(){$scope.deployerAPIBase.infras.getVertexAIAcceleratorTypes().success(function(data){$scope.acceleratorTypes=data.map(d=>{return{value:d,name:d==="ACCELERATOR_TYPE_UNSPECIFIED"?"None":d}})}).error(setErrorInScope.bind($scope))};const requestDatabricksWorkloadTypes=function(){$scope.deployerAPIBase.infras.getDatabricksWorkloadTypes().success(function(data){$scope.workloadTypes=data}).error(setErrorInScope.bind($scope))};const requestDatabricksWorkloadSizeTypes=function(){$scope.deployerAPIBase.infras.getDatabricksWorkloadSizeTypes().success(function(data){$scope.workloadSizeTypes=data}).error(setErrorInScope.bind($scope))};$scope.requestDatabricksExperimentLocationSuggestions=function(){if($scope.uiState.isExperimentLocationsLoadingInProgress){return}$scope.deployerAPIBase.infras.getDatabricksExperimentLocationSuggestions($scope.infra.authConnection).success(function(futureResp){$scope.uiState.isExperimentLocationsLoadingInProgress=true;FutureWatcher.watchJobId(futureResp.jobId).success(function(resp){$scope.experimentLocationSuggestions=resp.result.map(s=>s.path)}).error(setErrorInScope.bind($scope)).finally(()=>{$scope.uiState.isExperimentLocationsLoadingInProgress=false})}).error(setErrorInScope.bind($scope))};$scope.removeDatabricksExperimentLocationSuggestions=function(){$scope.experimentLocationSuggestions=null};const canAccessStaticCloudManagedSettings=function(infraType){if(infraType!=="STATIC"){return false}return $scope.onlyForDataikerAdminWhenInCloud};const canAccessAuditing=function(infraType){if(infraType==="DATABRICKS"){return false}return $scope.onlyForDataikerAdminWhenInCloud};const showWhenDataikerAdminOrNonStaticWhenInCloud=function(infraType){if(!$scope.isCloud){return true}return infraType!=="STATIC"||$rootScope.appConfig.canAccessCloudDataikerAdminCapabilities};const deregisterInfra=$scope.$watch("infra",function(nv){if(!nv)return;$scope.uiState.showApiNodesTab=canAccessStaticCloudManagedSettings(nv.type);$scope.uiState.showAuditingTab=canAccessAuditing(nv.type);$scope.uiState.showPermissionsTab=showWhenDataikerAdminOrNonStaticWhenInCloud(nv.type);$scope.uiState.showLifecycleField=showWhenDataikerAdminOrNonStaticWhenInCloud(nv.type);$scope.uiState.showTrustAllCertificates=canAccessStaticCloudManagedSettings(nv.type);if(nv.type==="K8S"){if($scope.appConfig.areReportingToGraphiteSettingsDisplayed){$scope.uiState.showReportingToGraphiteSettings=true}}if(["K8S","STATIC"].includes(nv.type)){if($scope.appConfig.areMetricsChartingServerSettingsDisplayed){$scope.uiState.showMetricsChartingServerSettings=true}}if(APIDeploymentInfraHelper.isFullyManagedInfra(nv.type)){let connectionType;let cloudStorageConnectionType;if(nv.type==="SAGEMAKER"){connectionType="SageMaker";cloudStorageConnectionType="EC2";requestSageMakerInstanceTypes()}else if(nv.type==="SNOWPARK"){connectionType="Snowflake"}else if(nv.type==="AZURE_ML"){connectionType="AzureML"}else if(nv.type==="DATABRICKS"){connectionType="DatabricksModelDeployment";requestDatabricksWorkloadTypes();requestDatabricksWorkloadSizeTypes();$scope.experimentLocationSuggestions=null}else if(nv.type==="VERTEX_AI"){connectionType="VertexAIModelDeployment";requestVertexAIAcceleratorTypes()}if(connectionType){DataikuAPI.connections.getNames(connectionType).success(function(data){$scope.connections=data.map(n=>{return{name:n,label:n}});$scope.connectionsWithEnvironment=$scope.isCloud?$scope.connections:[{name:null,label:"Environment"}].concat($scope.connections)}).error(setErrorInScope.bind($scope))}if(cloudStorageConnectionType){DataikuAPI.connections.getNames(cloudStorageConnectionType).success(function(data){$scope.cloudStorageConnections=data}).error(setErrorInScope.bind($scope))}}deregisterInfra()},false)});app.filter("infraTypeToName",function(INFRA_TYPES){return function(type){if(!type){return}return INFRA_TYPES[type]||type}});app.filter("infraTypeToIcon",function(){return function(infraType,size){if(!size){size=16}if(!infraType){return}if(infraType==="SAGEMAKER"){return"dku-icon-amazon-sagemaker-"+size}else if(infraType==="AZURE_ML"){return"dku-icon-microsoft-azure-ml-"+size}else if(infraType==="VERTEX_AI"){return"dku-icon-google-vertex-"+size}else if(infraType==="SNOWPARK"){return"dku-icon-snowflake-brand-"+size}else if(infraType==="DATABRICKS"){return"dku-icon-databricks-"+size}else{return"dku-icon-dataiku-"+size}}});app.component("activityMonitoringSettings",{bindings:{activityMonitoringSettings:"=",infra:"<"},template:`
    <div class="activity-monitoring-settings">
        <h2 class="settings-section-title mtop0">Activity server</h2>
        <div class="alert alert--warning mtop4 mbot4"
             ng-if="$ctrl.infra.endpointType === 'SERVERLESS' && $ctrl.activityMonitoringSettings.mode === 'PUSH_TO_DEPLOYER'">
            Pushing Activity Metrics to Deployer is not supported in SERVERLESS mode.
        </div>

        <div class="alert alert-info" ng-if="['SAGEMAKER', 'VERTEX_AI', 'AZURE_ML', 'DATABRICKS'].includes($ctrl.infra.type)">
            These settings control how the activity statistics are collected.
        </div>
        <div class="alert alert-info" ng-if="['STATIC', 'K8S'].includes($ctrl.infra.type)">
            These settings control the activity server to which the API nodes will send statistics for monitoring. Usually, this is the Deployer.
        </div>
        <div class="alert" ng-if="['STATIC', 'K8S'].includes($ctrl.infra.type)">
            Changing these settings requires updating the deployments handled by this infrastructure.
        </div>

        <div class="control-group">
            <label class="control-label">Mode</label>
            <div class="controls"
                toggle="tooltip-left">
                <select dku-bs-select
                        class="form-control"
                        ng-model="$ctrl.activityMonitoringSettings.mode"
                        layout="list"
                        options-descriptions="modeDescriptions">
                    <option value="PULL_FROM_API_NODES" ng-if="$ctrl.infra.type=='STATIC'">Deployer pulls activity from API nodes</option>
                    <option value="PULL_FROM_API_NODES" ng-if="$ctrl.infra.type=='SAGEMAKER'">Pull activity from CloudWatch</option>
                    <option value="PULL_FROM_API_NODES" ng-if="$ctrl.infra.type=='VERTEX_AI'">Pull activity from Google Cloud Monitoring</option>
                    <option value="PULL_FROM_API_NODES" ng-if="$ctrl.infra.type=='AZURE_ML'">Pull activity from Azure Monitor</option>
                    <option value="PULL_FROM_API_NODES" ng-if="$ctrl.infra.type=='DATABRICKS'">Pull activity from Databricks</option>
                    <option value="PUSH_TO_DEPLOYER" ng-if="$ctrl.infra.type != 'DATABRICKS' && onlyForDataikerAdminWhenInCloud">API nodes push activity to Deployer</option>
                    <option value="PUSH_TO_DEPLOYER_AUTO" ng-if="deployerAndNodesDirectoryEnabled && $ctrl.infra.type != 'DATABRICKS' && !isCloud">API nodes push activity to Deployer - Auto</option>
                    <option value="DISABLED">Don't get activity</option>
                </select>
                <span class="help-inline"
                        ng-if="$ctrl.activityMonitoringSettings.mode=='PULL_FROM_API_NODES' && $ctrl.infra.type === 'SAGEMAKER'">
                    CloudWatch will be queried using the credentials defined in the Basic parameters tab.
                </span>
                <span class="help-inline"
                        ng-if="$ctrl.activityMonitoringSettings.mode=='PULL_FROM_API_NODES' && $ctrl.infra.type === 'VERTEX_AI'">
                    Google Cloud Monitoring will be queried using the credentials defined in the Basic parameters tab.
                </span>
                <span class="help-inline"
                        ng-if="$ctrl.activityMonitoringSettings.mode=='PULL_FROM_API_NODES' && $ctrl.infra.type=='AZURE_ML'">
                    Azure Monitor will be queried using the credentials defined in the Basic parameters tab.
                </span>
                <span class="help-inline"
                        ng-if="$ctrl.activityMonitoringSettings.mode=='PULL_FROM_API_NODES' && $ctrl.infra.type=='DATABRICKS'">
                    Databricks will be queried using the credentials defined in the Basic parameters tab.
                </span>
            </div>
        </div>
        <div class="control-group" ng-if="$ctrl.activityMonitoringSettings.mode === 'PUSH_TO_DEPLOYER'">
            <label for="endpoint" class="control-label">Deployer activity server endpoint *</label>
            <div class="controls"
                toggle="tooltip-left">
                <input id="endpoint"
                    type="text"
                    ng-model="$ctrl.activityMonitoringSettings.activityServerAPIURL"
                    placeholder="http://host:port/public/api/admin/monitoring/activity-metrics"/>
                <button class="btn btn--secondary"
                        title="Use current URL"
                        ng-click="autofillDeployerActivityEndpointUrl()">
                    <i class="icon-magic" ></i>
                </button>
                <span class="help-inline">URL (http:// form) of the activity server endpoint (usually, this Deployer). Make sure it is reachable from the API nodes.</span>
            </div>
        </div>
        <div class="control-group" ng-if="$ctrl.activityMonitoringSettings.mode === 'PUSH_TO_DEPLOYER'">
            <label for="apikey" class="control-label">Deployer API key *</label>
            <div class="controls">
                <global-api-key-input
                    api-key="$ctrl.activityMonitoringSettings.apiKey",
                    new-key-label="newKeyLabel",
                    new-key-description="newKeyDescription">
                </global-api-key-input>
                <span class="help-inline">An admin API key valid on the remote Activity server (usually, this Deployer)</span>
            </div>
        </div>
        <div class="control-group" ng-if="$ctrl.activityMonitoringSettings.mode === 'PUSH_TO_DEPLOYER'">
            <label for="allSsl" class="control-label">Trust all certificates</label>
            <div class="controls"
                toggle="tooltip-left">
                <input id="allSsl" type="checkbox"
                    ng-model="$ctrl.activityMonitoringSettings.trustAllSSLCertificates"/>
            </div>
        </div>
    </div>
    `,controller:function($scope,$controller,$rootScope,DataikuAPI,INFRA_TYPES){const $ctrl=this;angular.extend($ctrl,$controller("_DeployerBaseController",{$scope:$scope}));$scope.deployerAndNodesDirectoryEnabled=$rootScope.appConfig.nodesDirectoryManagedDeployerServer||$rootScope.appConfig.nodesDirectoryManagedDeployerClient;$ctrl.$onInit=function(){$scope.modeDescriptions=getModeDescriptions($ctrl.infra.type,$scope.deployerAndNodesDirectoryEnabled,$scope.isCloud);$scope.newKeyLabel="Monitoring-"+$ctrl.infra.id;$scope.newKeyDescription="Used by "+INFRA_TYPES[$ctrl.infra.type]+" nodes of infrastructure "+$ctrl.infra.id+" to send activity metrics to this Deployer"};const getModeDescriptions=function(infraType,deployerAndNodesDirectoryEnabled,isCloud){const modeDescriptions=[];if(infraType=="STATIC"){modeDescriptions.push("The Deployer directly queries the API nodes")}else if(["SAGEMAKER","VERTEX_AI","AZURE_ML","DATABRICKS"].includes(infraType)){modeDescriptions.push("The Deployer directly fetches the clouds metrics")}if(infraType!="DATABRICKS"&&!isCloud){modeDescriptions.push("The API nodes send metrics to the deployer. Manual configuration of the deployer's address and access");if(deployerAndNodesDirectoryEnabled){modeDescriptions.push("The API nodes send metrics to the deployer. Deployer's address and access auto-configured by Fleet Manager")}}modeDescriptions.push("Activity won't be available for this infrastructure's deployments");return modeDescriptions};$scope.autofillDeployerActivityEndpointUrl=function(){DataikuAPI.apideployer.infras.getDkuBackendExtUrl($ctrl.infra.type==="K8S").success(function(url){const urlBase=url?url:urlWithProtocolAndHost();$ctrl.activityMonitoringSettings.activityServerAPIURL=urlBase+"/public/api/admin/monitoring/activity-metrics"}).error(setErrorInScope.bind($scope))}}})})();(function(){"use strict";const app=angular.module("dataiku.apideployer");app.controller("APIDeployerServicesListController",function($scope,$controller,$state,TopNav,DataikuAPI,CreateModalFromTemplate,WT1,DeployerUtils){$controller("_DeployerBaseController",{$scope:$scope});TopNav.setNoItem();TopNav.setLocation(TopNav.TOP_API_DEPLOYER,"services");if($scope.isFeatureLocked)return;$scope.uiState={};$scope.canCreateServices=function(){return $scope.appConfig.globalPermissions&&$scope.appConfig.globalPermissions.mayCreatePublishedAPIServices};$scope.startCreateService=function(){CreateModalFromTemplate("/templates/api-deployer/new-published-service-modal.html",$scope).then(function(newService){$state.go("apideployer.services.service.status",{serviceId:newService.id});WT1.event("api-deployer-service-create")})};function getLastUpdatedTime(serviceStatus){const publishedOn=(serviceStatus.packages[0]||{}).publishedOn||0;const settingsLastModified=(serviceStatus.serviceBasicInfo.versionTag||{}).lastModifiedOn||0;return Math.max(publishedOn,settingsLastModified)}DataikuAPI.apideployer.publishedAPIServices.listLightStatus().success(function(serviceStatusList){$scope.serviceStatusList=serviceStatusList;serviceStatusList.forEach(function(serviceStatus){serviceStatus.enabledDeploymentCount=DeployerUtils.enabledDeploymentCount(serviceStatus.deployments,true);serviceStatus.lastUpdated=getLastUpdatedTime(serviceStatus);const enabledDeploymentTypeBadges=serviceStatus.deployments.filter(d=>d.enabled).flatMap(d=>d.typeBadges);serviceStatus.typeBadges=[...new Set(enabledDeploymentTypeBadges)]})}).error(setErrorInScope.bind($scope))});app.controller("APIDeployerServiceCreationModalController",function($scope,DataikuAPI){$scope.newService=$scope.newService||{};$scope.$watch("newService.name",function(nv,ov){if(!nv)return;$scope.newService.id=nv.replace(/\W+/g,"")});$scope.ok=function(){DataikuAPI.apideployer.publishedAPIServices.create($scope.newService.id,$scope.newService.name).success($scope.resolveModal).error(setErrorInScope.bind($scope))}});app.controller("APIDeployerServiceController",function($scope,$controller,$state,DataikuAPI,Dialogs,CreateModalFromTemplate,DeployerUtils){$controller("_DeployerBaseController",{$scope:$scope});$scope.refreshServiceStatus=function(){return DataikuAPI.apideployer.publishedAPIServices.getLightStatus($state.params.serviceId).success(serviceStatus=>{$scope.serviceStatus=serviceStatus}).error(setErrorInScope.bind($scope))};$scope.DeployerUtils=DeployerUtils;$scope.refreshServiceStatus();$scope.ui={};let savedService;$scope.refreshServiceSettings=function(){return DataikuAPI.apideployer.publishedAPIServices.getSettings($state.params.serviceId).success(service=>{$scope.service=service;$scope.ui.ownerLogin=service.owner;savedService=angular.copy(service)}).error(setErrorInScope.bind($scope))};$scope.serviceIsDirty=function(){return!angular.equals(savedService,$scope.service)};$scope.saveService=function(){if(!$scope.service||!$scope.serviceIsDirty())return;DataikuAPI.apideployer.publishedAPIServices.save($scope.service).success(function(){$scope.refreshServiceSettings();$scope.refreshServiceStatus()}).error(setErrorInScope.bind($scope))};$scope.deleteService=function(){if(!$scope.serviceStatus){return}if($scope.serviceStatus.deployments.length){Dialogs.error($scope,"Delete service","You cannot delete this service because it has deployments!");return}Dialogs.confirm($scope,"Delete service","Are you sure you want to delete this service?").then(function(){DataikuAPI.apideployer.publishedAPIServices.delete($scope.serviceStatus.serviceBasicInfo.id).success(()=>{$state.go("apideployer.services.list")}).error(setErrorInScope.bind($scope))})};$scope.startUploadPackages=function(){CreateModalFromTemplate("/templates/api-deployer/published-service-upload-packages-modal.html",$scope)}});app.controller("APIDeployerServiceUploadPackagesController",function($scope,$controller,DataikuAPI,WT1){$controller("_DeployerUploadPackageController",{$scope:$scope});$scope.publishPackage=(fileToUpload,callback)=>{return DataikuAPI.apideployer.publishedAPIServices.publishVersion($scope.serviceStatus.serviceBasicInfo.id,fileToUpload,callback)};$scope.afterUploadCallback=function(){if($scope.serviceStatus&&$scope.serviceStatus.isAdmin){$scope.refreshServiceSettings()}$scope.refreshServiceStatus();if($scope.uiState.fileProperties.filter(f=>!f.uploaded).length==0){$scope.dismiss();WT1.event("api-deployer-upload-package")}}});app.controller("APIDeployerServiceStatusController",function($scope,$stateParams,TopNav,Dialogs,DataikuAPI,WT1,APIDeployerServicesService,APIDeployerAsyncHeavyStatusLoader,DeployerDeploymentTileService,DeployerUtils,APIDeployerDeploymentUtils,CreateModalFromTemplate){TopNav.setNoItem();TopNav.setLocation(TopNav.TOP_API_DEPLOYER,"services",null,"status");$scope.heavyStatusByDeploymentId={};$scope.deployVersion=function(versionId){APIDeployerServicesService.deployVersion($scope.serviceStatus,versionId,DeployerUtils.DEPLOY_SOURCE.PACKAGE)};$scope.deleteVersion=function(serviceId,versionId){Dialogs.confirm($scope,"Delete version "+versionId,"Are you sure you want to delete this version?").then(function(){DataikuAPI.apideployer.publishedAPIServices.deletePackage(serviceId,versionId).success($scope.refreshServiceStatus).error(setErrorInScope.bind($scope));WT1.event("api-deployer-packages-delete")})};DataikuAPI.apideployer.infras.listLightStatus().success(function(infraStatusList){$scope.infraStatusList=infraStatusList}).error(setErrorInScope.bind($scope));let showOthersStage=false;$scope.showEmptyOthersStage=function(stage,pkg){return stage==="__OTHERS__"&&showOthersStage&&!$scope.deploymentsPerVersionAndStage[pkg.id].others};$scope.showReleaseNotes=(packageId,releaseNotes)=>{CreateModalFromTemplate("/templates/api-deployer/published-service-release-notes.html",$scope,null,modalScope=>{modalScope.packageId=packageId;modalScope.releaseNotes=releaseNotes})};$scope.$watch("serviceStatus",function(){if(!$scope.serviceStatus)return;if($stateParams.versions){$scope.serviceStatus.packages.forEach(function(p){if($stateParams.versions.includes(p.id)){p.$expanded=true}})}const MAX_STAGE_COUNT=3;$scope.currentStages=DeployerUtils.getStagesToDisplay([$scope.serviceStatus],$scope.stages,MAX_STAGE_COUNT);$scope.deploymentsPerVersionAndStage=DeployerUtils.getDeploymentsPerPackageAndStage($scope.serviceStatus,$scope.stages,$scope.currentStages,"version");$scope.SMVersionsPerPackageAndId=APIDeployerDeploymentUtils.getSMVersionsPerPackageAndId($scope.serviceStatus);$scope.originInfoPerPackage=APIDeployerDeploymentUtils.getOriginInfoPerPackage($scope.serviceStatus);showOthersStage=$scope.serviceStatus.packages.some(pkg=>$scope.deploymentsPerVersionAndStage[pkg.id].others);const heavyStatusByDeploymentId={};let loader=APIDeployerAsyncHeavyStatusLoader.newLoader(heavyStatusByDeploymentId);loader.loadFromServiceStatus($scope.serviceStatus);const deregister=$scope.$watch(function(){return loader.stillRefreshing()},function(nv,ov){if(nv||ov===nv)return;$scope.heavyStatusByDeploymentId=heavyStatusByDeploymentId;$scope.healthMap=DeployerDeploymentTileService.getDeploymentHealthMap($scope.serviceStatus.deployments,heavyStatusByDeploymentId);deregister()});$scope.$on("$destroy",function(){loader&&loader.stopLoading()})})});app.controller("APIDeployerServiceHistoryController",function($scope,TopNav){TopNav.setNoItem();TopNav.setLocation(TopNav.TOP_API_DEPLOYER,"services",null,"history");$scope.refreshServiceSettings()});app.controller("APIDeployerServiceSettingsController",function($controller,$scope,TopNav){TopNav.setNoItem();TopNav.setLocation(TopNav.TOP_API_DEPLOYER,"services",null,"settings");$scope.uiState={active:"general"};$controller("_APIDeployerServicePermissionsController",{$scope:$scope});$scope.refreshServiceSettings();checkChangesBeforeLeaving($scope,$scope.serviceIsDirty)});app.controller("_APIDeployerServicePermissionsController",function($scope,$controller,PermissionsService){$controller("_DeployerPermissionsController",{$scope:$scope});const deregister=$scope.$watch("service",function(nv,ov){if(!nv)return;$scope.initPermissions($scope.service,{read:true,write:false,deploy:false,admin:false},true);deregister()},false);$scope.$watch("ui.ownerLogin",function(){PermissionsService.transferOwnership($scope,$scope.service,"service")});$scope.$watch("service.permissions",function(nv,ov){if(!nv)return;$scope.onPermissionChange($scope.service)},true);$scope.$watch("service.permissions",function(nv,ov){if(!nv)return;$scope.onPermissionChange($scope.service)},false)});app.service("APIDeployerServicesService",function($state,DataikuAPI,Assert,WT1,DeployerPublishedItemsService,APIDeployerDeploymentService){this.deployVersion=function(serviceStatus,versionId,source){Assert.trueish(serviceStatus,"serviceStatus not provided");Assert.trueish(serviceStatus.deployments,"no deployments in serviceStatus");return DeployerPublishedItemsService.deployPackage(serviceStatus,"version").then(deploymentMethodId=>{if(deploymentMethodId==DeployerPublishedItemsService.DEPLOYMENT_METHOD_ID.NEW){return deployVersionInNewDeployment(serviceStatus,versionId,source)}else{return deployVersionInExistingDeployment(serviceStatus,versionId,source)}})};function deployVersionInNewDeployment(serviceStatus,versionId,source){return APIDeployerDeploymentService.startCreateDeployment(serviceStatus.serviceBasicInfo.id,versionId).then(function(newDeployment){$state.go("apideployer.deployments.deployment.status",{deploymentId:newDeployment.id});WT1.event("api-deployer-deploy-version-in-new-deployment",{deploymentType:newDeployment.type,source:source})})}function deployVersionInExistingDeployment(serviceStatus,versionId,source){return DeployerPublishedItemsService.openDeploymentSelector(serviceStatus,true).then(function(depl){return APIDeployerDeploymentService.openGovernanceStatusDeploymentId(depl.id,undefined,versionId).then(function(){return DataikuAPI.apideployer.deployments.switchVersion(depl.id,versionId).success(function(){WT1.event("api-deployer-deploy-version-in-existing-deployment",{deploymentType:depl.type,source:source});$state.go("apideployer.deployments.deployment.settings",{deploymentId:depl.id})})})})}})})();(function(){"use strict";const app=angular.module("dataiku.apideployer");app.service("APIDeployerAsyncHeavyStatusLoader",function(DataikuAPI,Logger,DeployerUtils){return{newLoader:function(heavyStatusPerDeployment){const loader={};const oneByOneDeploymentIdList=[];const perInfraList=[];let canLoadStatus=true;loader.stopLoading=function(){canLoadStatus=false};let loadingOneByOne=true;let loadingPerInfra=true;loader.isLoading=()=>loadingOneByOne||loadingPerInfra;loader.stillRefreshing=()=>loader.isLoading();loader.loadFromInfraLightStatus=function(infraLightStatus){if(infraLightStatus.infraBasicInfo.canListHeavyStatus){perInfraList.push(infraLightStatus)}else{oneByOneDeploymentIdList.push(...infraLightStatus.deployments.map(_=>_.id))}this._loadAll()};loader.loadFromDeploymentLightStatusList=function(deploymentLightStatusList){const perInfraDeployments=new Map;deploymentLightStatusList.forEach(deploymentLightStatus=>{if(deploymentLightStatus.infraBasicInfo.canListHeavyStatus){const infraId=deploymentLightStatus.infraBasicInfo.id;if(perInfraDeployments.has(infraId)){perInfraDeployments.get(infraId).deployments.push(deploymentLightStatus.deploymentBasicInfo)}else{perInfraDeployments.set(infraId,{infraBasicInfo:deploymentLightStatus.infraBasicInfo,deployments:[deploymentLightStatus.deploymentBasicInfo]})}}else{oneByOneDeploymentIdList.push(deploymentLightStatus.deploymentBasicInfo.id)}});if(perInfraDeployments.size){perInfraList.push(...perInfraDeployments.values())}this._loadAll()};loader.loadFromServiceStatus=function(serviceStatus){const perInfraDeployments=new Map;serviceStatus.infras.forEach(infraBasicInfo=>{if(infraBasicInfo.canListHeavyStatus){perInfraDeployments.set(infraBasicInfo.id,{infraBasicInfo:infraBasicInfo,deployments:[]})}});serviceStatus.deployments.forEach(deploymentBasicInfo=>{if(perInfraDeployments.has(deploymentBasicInfo.infraId)){perInfraDeployments.get(deploymentBasicInfo.infraId).deployments.push(deploymentBasicInfo)}else{oneByOneDeploymentIdList.push(deploymentBasicInfo.id)}});if(perInfraDeployments.size){perInfraList.push(...perInfraDeployments.values())}this._loadAll()};loader._loadAll=function(){this._loadPerInfra();this._loadOneByOne()};const nbSimultaneousInfraLoading=2;let runningInfraQueries=0;loader._loadPerInfra=function(){if(!perInfraList.length&&!runningInfraQueries||!canLoadStatus){loadingPerInfra=false;return}const infraStatusToLoad=perInfraList.splice(0,nbSimultaneousInfraLoading-runningInfraQueries);runningInfraQueries+=infraStatusToLoad.length;for(let infraStatus of infraStatusToLoad){const infraId=infraStatus.infraBasicInfo.id;const deploymentIds=new Set(infraStatus.deployments.map(_=>_.id));Logger.info("Sending heavy status list request for deployments of infra "+infraId);DataikuAPI.apideployer.deployments.listHeavyStatus(infraId,false).success(function(heavyStatusList){Logger.info("Got heavy status list for infra "+infraId);heavyStatusList.forEach(heavyStatus=>{heavyStatusPerDeployment[heavyStatus.deploymentId]=heavyStatus});runningInfraQueries-=1;loader._loadPerInfra()}).error(function(a,b,c){Logger.warn("Failed to load heavy status list for infra "+infraId);deploymentIds.forEach(deploymentId=>{heavyStatusPerDeployment[deploymentId]={health:"LOADING_FAILED",healthMessages:DeployerUtils.getFailedHeavyStatusLoadMessage(getErrorDetails(a,b,c))}});runningInfraQueries-=1;loader._loadPerInfra()})}};const nbSimultaneousLoading=2;let running=0;loader._loadOneByOne=function(){const noSpinner=true;if(!oneByOneDeploymentIdList.length&&!running||!canLoadStatus){loadingOneByOne=false;return}const idListForStatusLoad=oneByOneDeploymentIdList.splice(0,nbSimultaneousLoading-running);running+=idListForStatusLoad.length;for(let deploymentId of idListForStatusLoad){Logger.info("Sending heavy status request for "+deploymentId);DataikuAPI.apideployer.deployments.getHeavyStatus(deploymentId,false,noSpinner).success(function(heavyStatus){Logger.info("Got heavy status for "+deploymentId+"; health: "+heavyStatus.health);heavyStatusPerDeployment[deploymentId]=heavyStatus;running-=1;loader._loadOneByOne()}).error(function(a,b,c){Logger.warn("Failed to load heavy status for "+deploymentId);heavyStatusPerDeployment[deploymentId]={health:"LOADING_FAILED",healthMessages:DeployerUtils.getFailedHeavyStatusLoadMessage(getErrorDetails(a,b,c))};running-=1;loader._loadOneByOne()})}};return loader}}});app.component("apiDeployerMonitoringModelStatus",{bindings:{monitoring:"<",lightStatus:"<",overallModelStatusIcon:"<",overallModelStatusLabel:"<"},templateUrl:"/templates/api-deployer/api-deployer-monitoring-model-status.html",controller:function($scope,UnifiedMonitoringService){const $ctrl=this;$ctrl.uiState={};$ctrl.getStatusIcon=function(status){return UnifiedMonitoringService.getStatusIcon(status)};$ctrl.$onChanges=function(){if($ctrl.monitoring){$ctrl.uiState.modelMonitoring=[];if($ctrl.monitoring.modelStatus){const smvElements={smvSmartId:$ctrl.monitoring.modelStatus.smvSmartId,savedModelId:$ctrl.monitoring.modelStatus.savedModelId,savedModelName:$ctrl.monitoring.modelStatus.savedModelName};$ctrl.monitoring.modelStatus.mesMonitoringStatuses.forEach((mes,mesIdx)=>{const mesChecks=UnifiedMonitoringService.mesMonitoringStatusToChecks(mes);const mesElements={mesName:mes.mesName,mesId:mes.id,mesRowSpan:mesChecks.length};mesChecks.forEach((check,checkIdx)=>{let resElem={...check};if(mesIdx===0&&checkIdx===0){resElem={...resElem,...smvElements}}if(checkIdx===0){resElem={...resElem,...mesElements}}$ctrl.uiState.modelMonitoring.push(resElem)})})}}};$ctrl.hasModelStatus=function(){return $ctrl.uiState.modelMonitoring&&$ctrl.uiState.modelMonitoring.length>0};$ctrl.buildSmvUrl=function(monitoring){if($ctrl.lightStatus&&$ctrl.lightStatus.packages.length>0){const currentPackage=$ctrl.lightStatus.packages[$ctrl.lightStatus.packages.length-1];if(currentPackage.designNodeInfo){return currentPackage.designNodeInfo.url+"/projects/"+currentPackage.designNodeInfo.projectKey+"/"+"savedmodels/"+monitoring.savedModelId+"/p/"+monitoring.smvSmartId+"/tabular-summary"}}};$ctrl.buildMesUrl=function(mesId){if($ctrl.lightStatus&&$ctrl.lightStatus.packages.length>0){const currentPackage=$ctrl.lightStatus.packages[$ctrl.lightStatus.packages.length-1];if(currentPackage.designNodeInfo){return currentPackage.designNodeInfo.url+"/projects/"+currentPackage.designNodeInfo.projectKey+"/"+"modelevaluationstores/"+mesId+"/evaluations/"}}}}});app.component("apiDeployerMonitoringGovernStatus",{bindings:{monitoring:"<",governStatusIcon:"<",governStatusLabel:"<"},templateUrl:"/templates/api-deployer/api-deployer-monitoring-govern-status.html",controller:function($rootScope,UnifiedMonitoringService){const $ctrl=this;$ctrl.uiState={};$ctrl.$onChanges=function(){if($ctrl.monitoring&&$ctrl.monitoring.governanceStatus){$ctrl.uiState.governProjectUrl=`${$rootScope.appConfig.governURL}/artifact/${$ctrl.monitoring.governanceStatus.governArtifactId}`;$ctrl.uiState.governStatusIcon=UnifiedMonitoringService.getStatusIcon($ctrl.monitoring.umGovernanceStatus);$ctrl.uiState.governStatusLabel=UnifiedMonitoringService.getGovernStatusLabel($ctrl.monitoring.governanceStatus.validationStatus);$ctrl.uiState.governPolicyLabel=UnifiedMonitoringService.getGovernPolicyLabel($ctrl.monitoring.governCheckPolicy)}$ctrl.uiState.hasGovernStatus=!!$ctrl.monitoring.governanceStatus}}});app.component("deployerCopiableElement",{transclude:true,bindings:{text:"<",tooltipDirection:"@"},template:`
    <div class='deployer-copiable-element df' ng-click="$ctrl.copyToClipboard()">
        <div ng-if="!$ctrl.transcludePresent" show-tooltip-on-text-overflow text-tooltip="$ctrl.text" tooltip-direction="$ctrl.tooltipDirection"></div>
        <div ng-if="$ctrl.transcludePresent">
            <ng-transclude></ng-transclude>
        </div>
        &nbsp;
        <i class="dku-icon-copy-step-16"></i>
    </div>`,controller:function($transclude,ClipboardUtils){const $ctrl=this;$ctrl.transcludePresent=false;$ctrl.$onInit=function(){$ctrl.tooltipDirection=$ctrl.tooltipDirection||"tooltip-bottom";$transclude(content=>$ctrl.transcludePresent=content.length>0)};$ctrl.copyToClipboard=function(){ClipboardUtils.copyToClipboard($ctrl.text,"Copied to clipboard")}}});app.component("deployerExternalLinkElement",{bindings:{tooltipDirection:"@",text:"<",link:"<"},template:`
    <a class="link df" href="{{$ctrl.link}}" target="_blank">
        <div show-tooltip-on-text-overflow text-tooltip="$ctrl.text" tooltip-direction="$ctrl.tooltipDirection">
            {{$ctrl.text}}
        </div>
        &nbsp;
        <i class="dku-icon-arrow-external-link-16"></i>
    </a>`,controller:function(){const $ctrl=this;$ctrl.$onInit=function(){$ctrl.tooltipDirection=$ctrl.tooltipDirection||"tooltip-bottom"}}});app.component("displayCodeModal",{bindings:{modalControl:"<",title:"<",text:"<"},template:`
    <dku-modal-header-with-totem modal-title="{{$ctrl.title}}" modal-totem="dku-icon-code-24">
    </dku-modal-header-with-totem>
    <form class="dkuform-modal-horizontal dkuform-modal-wrapper" name="displayText">
        <div class="modal-body oh">
            <pre class="scroll">{{$ctrl.text}}</pre>
        </div>
        <div class="modal-footer modal-footer-std-buttons">
            <button type="button" class="btn btn--secondary" ng-click="$ctrl.copyToClipboard()">Copy</button>
            <button type="button" class="btn btn--primary" ng-click="$ctrl.modalControl.dismiss()">Close</button>
        </div>
    </form>`,controller:function(ClipboardUtils){const $ctrl=this;$ctrl.copyToClipboard=function(){ClipboardUtils.copyToClipboard($ctrl.text);$ctrl.modalControl.dismiss()}}});app.component("displayOpenAPIModal",{bindings:{modalControl:"<",title:"<",enabledInfo:"<",text:"<"},template:`
    <dku-modal-header-with-totem modal-title="{{$ctrl.title}}" modal-totem="dku-icon-code-24">
    </dku-modal-header-with-totem>
    <form class="dkuform-modal-horizontal dkuform-modal-wrapper" name="displayText">
        <div class="modal-body oh">
            <div ng-if="$ctrl.enabledInfo">
                <div class="alert alert-info mbot16">
                    <strong><i class="icon-info-sign"></i></strong> OpenAPI documentation file is not served on a dedicated URI for kubernetes clusters of API nodes. You can access it from the Deployer Python API, <doclink-wrapper page="apinode/api-documentation#publishing-openapi-documentation">see Documentation</doclink-wrapper> for more details.
                </div>
            </div>
            <pre class="scroll">{{$ctrl.text}}</pre>
        </div>
        <div class="modal-footer modal-footer-std-buttons">
            <button type="button" class="btn btn--secondary" ng-click="$ctrl.copyToClipboard()">Copy</button>
            <button type="button" class="btn btn--primary" ng-click="$ctrl.modalControl.dismiss()">Close</button>
        </div>
    </form>`,controller:function(ClipboardUtils){const $ctrl=this;$ctrl.copyToClipboard=function(){ClipboardUtils.copyToClipboard($ctrl.text);$ctrl.modalControl.dismiss()}}});app.directive("apiDeploymentCard",function($state,DataikuAPI,TaggingService,DeployerUtils,APIDeployerDeploymentUtils,DeployerDeploymentTileService,ClipboardUtils,CreateModalFromComponent,displayOpenAPIModalDirective,$filter){return{scope:{lightStatus:"=",heavyStatus:"=",showMonitoring:"=",onRightClick:"&",customRightClick:"@"},templateUrl:"/templates/api-deployer/deployment-card.html",replace:true,link:function(scope,elem,attrs){scope.dashboardTile=attrs.hasOwnProperty("deploymentDashboardTile");scope.TaggingService=TaggingService;scope.participatingVersions=DeployerUtils.getParticipatingVersions(scope.lightStatus.deploymentBasicInfo);const originInfoPerPackage=APIDeployerDeploymentUtils.getOriginInfoPerPackage(scope.lightStatus);const relatedInfoPerProject={};scope.relatedInfoPerProject=[];scope.infraSupportOpenAPIURI=APIDeployerDeploymentUtils.infraSupportOpenAPIURI(scope.lightStatus.infraBasicInfo.type);scope.openAPIUrls=APIDeployerDeploymentUtils.computeSimpleOpenAPIURLs(scope.lightStatus);if(!scope.dashboardTile){DataikuAPI.apideployer.deployments.getDeploymentOpenAPI(scope.lightStatus.deploymentBasicInfo.id).success(function(data){scope.openAPIDocContent=data}).error(setErrorInScope.bind(scope))}scope.participatingVersions.forEach(function(version){const originInfo=originInfoPerPackage[version]||{};if(originInfo.projectKey&&originInfo.projectKey in relatedInfoPerProject&&originInfo.url===relatedInfoPerProject[originInfo.projectKey].url){return}else if(originInfo.projectKey){relatedInfoPerProject[originInfo.projectKey]=originInfo;scope.relatedInfoPerProject.push(originInfo)}});let loadingSparkline;function loadSparkline(){if((scope.deploymentStatus.currentState=="HEALTHY"||scope.deploymentStatus.currentState=="WARNING")&&!loadingSparkline&&!scope.lightStatus.failedToLoadSparkline&&!scope.heavyStatus.sparkline&&scope.lightStatus.infraBasicInfo.carbonAPIEnabled){loadingSparkline=true;DataikuAPI.apideployer.deployments.getChartData(scope.lightStatus.deploymentBasicInfo.id,null,"OVERALL_QPS_COMBINED","SIX_HOURS").success(function(spkData){let datapoints;if(spkData[0]&&spkData[0].datapoints){datapoints=spkData[0].datapoints}else{datapoints=APIDeployerDeploymentUtils.buildZeroDatapoints("SIX_HOURS")}loadingSparkline=false;scope.heavyStatus.sparkline=datapoints.map(x=>x[0])}).error(function(a,b,c){loadingSparkline=false;scope.lightStatus.failedToLoadSparkline=getErrorDetails(a,b,c)})}}scope.redirect=function(){if(attrs.hasOwnProperty("redirectToDeploymentPage")){$state.go("apideployer.deployments.deployment.status",{deploymentId:scope.lightStatus.deploymentBasicInfo.id})}};scope.showOpenAPIJson=function(){let text;try{text=$filter("prettyjson")(scope.openAPIDocContent)}catch(e){text=scope.openAPIDocContent}CreateModalFromComponent(displayOpenAPIModalDirective,{title:"OpenAPI Documentation",enabledInfo:!scope.infraSupportOpenAPIURI,text:text},["modal-wide"])};scope.copyInputToClipboard=function(){ClipboardUtils.copyToClipboard(scope.openAPIUrls)};scope.handleRightClick=function(event){scope.onRightClick({$event:event})};scope.shouldHandleRightClick=function(){return scope.customRightClick?"true":"false"};scope.$watch("heavyStatus",function(){scope.deploymentStatus=DeployerDeploymentTileService.getDeploymentHealth(scope.heavyStatus);if(scope.lightStatus&&scope.heavyStatus){loadSparkline()}});scope.$watch("lightStatus",function(){if(scope.lightStatus&&scope.heavyStatus){loadSparkline()}},true)}}});app.component("apiInlineDeploymentCard",{bindings:{projectName:"=",lightStatus:"<",heavyStatus:"<",lastDeploymentAction:"<",showLastAction:"<",refresh:"<"},templateUrl:"/templates/api-deployer/inline-deployment-card.html",controller:function(DeployerUtils,APIDeployerDeploymentUtils,DeployerDeploymentTileService,CreateModalFromComponent,displayOpenAPIModalDirective,$filter,DataikuAPI,$state,WT1){const $ctrl=this;$ctrl.uiState={openDetails:false};$ctrl.showOpenAPIJson=function(){let text;try{text=$filter("prettyjson")($ctrl.openAPIDocContent)}catch(e){text=$ctrl.openAPIDocContent}CreateModalFromComponent(displayOpenAPIModalDirective,{title:"OpenAPI Documentation",enabledInfo:!$ctrl.infraSupportOpenAPIURI,text:text},["modal-wide"])};$ctrl.$onChanges=function(changes){if(changes.heavyStatus&&$ctrl.heavyStatus){$ctrl.deploymentStatus=DeployerDeploymentTileService.getDeploymentHealth($ctrl.heavyStatus)}if(changes.lightStatus&&$ctrl.lightStatus){DataikuAPI.apideployer.deployments.getDeploymentOpenAPI($ctrl.lightStatus.deploymentBasicInfo.id).success(function(data){$ctrl.openAPIDocContent=data});$ctrl.uiState.infraHref=$state.href("apideployer.infras.infra.status",{infraId:$ctrl.lightStatus.infraBasicInfo.id});$ctrl.participatingVersions=DeployerUtils.getParticipatingVersions($ctrl.lightStatus.deploymentBasicInfo);const originInfoPerPackage=APIDeployerDeploymentUtils.getOriginInfoPerPackage($ctrl.lightStatus);$ctrl.relatedInfoPerProject=[];$ctrl.infraSupportOpenAPIURI=APIDeployerDeploymentUtils.infraSupportOpenAPIURI($ctrl.lightStatus.infraBasicInfo.type);$ctrl.openAPIUrls=APIDeployerDeploymentUtils.computeSimpleOpenAPIURLs($ctrl.lightStatus);$ctrl.participatingVersions.forEach(function(version){const originInfo=originInfoPerPackage[version]||{};if(originInfo.projectKey&&originInfo.projectKey in $ctrl.relatedInfoPerProject&&originInfo.url===$ctrl.relatedInfoPerProject[originInfo.projectKey].url){return}else if(originInfo.projectKey){$ctrl.relatedInfoPerProject[originInfo.projectKey]=originInfo;$ctrl.relatedInfoPerProject.push(originInfo)}})}};$ctrl.toggleDetails=function(){$ctrl.uiState.openDetails=!$ctrl.uiState.openDetails;WT1.event("api-deployer-deployment-details-toggle",{deploymentType:$ctrl.lightStatus.infraBasicInfo.type,state:$ctrl.uiState.openDetails?"opened":"closed"})};$ctrl.lastUpdateCompleted=function(){return $ctrl.lastDeploymentAction?.type==="UPDATE"&&!$ctrl.lastDeploymentAction.inProgress};$ctrl.lastActionStatus=function(){if($ctrl.lastDeploymentAction&&!$ctrl.lastDeploymentAction.inProgress){switch($ctrl.lastDeploymentAction.status){case"SUCCESS":case"INFO":return"Succeeded";case"WARNING":return"Succeeded with warning";case"ERROR":return"Failed"}}return""}}});app.directive("apiDeploymentsListWidget",function($state,TaggingService){return{scope:{deployments:"=apiDeploymentsListWidget",statusPage:"=",healthMap:"="},templateUrl:"/templates/api-deployer/deployment-list.html",replace:true,link:function(scope){scope.TaggingService=TaggingService;scope.redirect=function(deployment){$state.go("apideployer.deployments.deployment.status",{deploymentId:deployment.id})}}}});app.controller("APIDeployerPackagesPanelController",function($scope,$controller,APIDeployerServicesService,DeployerUtils,TaggingService){$controller("_DeployerPackagesPanelController",{$scope:$scope});$scope.TaggingService=TaggingService;$scope.getPackageDeployments=function(deployments,versionId){return deployments.filter(d=>DeployerUtils.getParticipatingVersions(d).includes(versionId))};$scope.deployVersion=function(serviceStatus,versionId){APIDeployerServicesService.deployVersion(serviceStatus,versionId,DeployerUtils.DEPLOY_SOURCE.PACKAGE_PANEL).catch(setErrorInScope.bind($scope.$parent))};$scope.$watch("serviceStatusList",function(nv){if(!nv)return;$scope.uiState.fullServiceList=$scope.computeFullList(nv)})});app.controller("APIDeployerDeploymentCopyModalController",function($scope,DataikuAPI,Assert,APIDeployerDeploymentService,DeploymentUtils,APIDeployerDeploymentUtils,APIDeploymentInfraHelper){$scope.newDepl=$scope.newDepl||{};$scope.isEndpointCompatibleWithDeployAnywhere=APIDeployerDeploymentUtils.isEndpointCompatibleWithDeployAnywhere;$scope.isEndpointCompatibleWithDeployAnywhereDatabricks=APIDeployerDeploymentUtils.isEndpointCompatibleWithDeployAnywhereDatabricks;if($scope.oldDepl.endpointId){$scope.newDepl.endpointId=$scope.oldDepl.endpointId}function fetchStagesThenSortInfras(infraBasicInfoList){DataikuAPI.apideployer.listStages().success(stages=>{$scope.infraBasicInfoList=APIDeployerDeploymentUtils.sortedInfrasByStages(infraBasicInfoList,stages)}).error(setErrorInScope.bind($scope))}DataikuAPI.apideployer.infras.listBasicInfo().success(infraBasicInfoList=>{$scope.infraBasicInfoList=infraBasicInfoList.infras;if($scope.infraBasicInfoList.length==1){$scope.newDepl.infraId=$scope.infraBasicInfoList[0].id}fetchStagesThenSortInfras(infraBasicInfoList.infras)}).error(setErrorInScope.bind($scope));DataikuAPI.apideployer.publishedAPIServices.listLightStatus().success(function(serviceStatusList){$scope.serviceStatusList=serviceStatusList}).error(setErrorInScope.bind($scope));DataikuAPI.apideployer.deployments.listBasicInfo().success(deploymentBasicInfoList=>{$scope.deploymentIdList=deploymentBasicInfoList.deployments.map(depl=>depl.id)}).error(setErrorInScope.bind($scope));function autoSetDeploymentId(){if(!$scope.newDepl.publishedServiceId||!$scope.newDepl.infraId){return}let newDeplId=DeploymentUtils.sanitizeForK8S($scope.newDepl.publishedServiceId+"-on-"+$scope.newDepl.infraId);let counter=0;while(($scope.deploymentIdList||[]).indexOf(newDeplId+(counter?"-"+counter:""))>=0){counter++}$scope.newDepl.id=newDeplId+(counter?"-"+counter:"")}$scope.$watch("newDepl.infraId",autoSetDeploymentId);function setupEndpoints(){if(!$scope.newDepl.publishedServiceId||!$scope.serviceStatusList||!$scope.oldDepl.generationsMapping||$scope.oldDepl.generationsMapping.mode!="SINGLE_GENERATION"){return}const selectedInfra=$scope.infraBasicInfoList.find(e=>e.id===$scope.newDepl.infraId);$scope.selectedInfraType=typeof selectedInfra==="undefined"?null:selectedInfra.type;$scope.endpoints=[];for(let status of $scope.serviceStatusList){if(status.serviceBasicInfo.id==$scope.newDepl.publishedServiceId){for(let pkg of status.packages){if(pkg.id===$scope.oldDepl.generationsMapping.generation){$scope.endpoints=pkg.endpoints;break}}break}}if(APIDeploymentInfraHelper.isFullyManagedInfra($scope.selectedInfraType)){if($scope.selectedInfraType==="DATABRICKS"){$scope.compatibleEndpoints=$scope.endpoints.filter(e=>$scope.isEndpointCompatibleWithDeployAnywhereDatabricks(e.type))}else{$scope.compatibleEndpoints=$scope.endpoints.filter(e=>$scope.isEndpointCompatibleWithDeployAnywhere(e.type))}if($scope.compatibleEndpoints.length){if(!$scope.compatibleEndpoints.map(e=>e.id).includes($scope.newDepl.endpointId)){$scope.newDepl.endpointId=$scope.compatibleEndpoints[0].id}}else{$scope.newDepl.endpointId=null}}}$scope.$watch("serviceStatusList",setupEndpoints);$scope.$watch("newDepl.infraId",setupEndpoints);$scope.ok=function(){return APIDeployerDeploymentService.openGovernanceStatusDeploymentId($scope.oldDepl.id,$scope.newDepl.infraId,undefined).then(function(){return DataikuAPI.apideployer.deployments.copy($scope.oldDepl.id,$scope.newDepl.id,$scope.newDepl.infraId,$scope.newDepl.endpointId).success($scope.resolveModal).error(setErrorInScope.bind($scope))})}});app.controller("APIDeployerDeploymentCreationModalController",function($scope,DataikuAPI,APIDeployerDeploymentService,Assert,DeploymentUtils,APIDeployerDeploymentUtils,APIDeploymentInfraHelper){$scope.newDepl=$scope.newDepl||{};$scope.isEndpointCompatibleWithDeployAnywhere=APIDeployerDeploymentUtils.isEndpointCompatibleWithDeployAnywhere;$scope.isEndpointCompatibleWithDeployAnywhereDatabricks=APIDeployerDeploymentUtils.isEndpointCompatibleWithDeployAnywhereDatabricks;function fetchStagesThenSortInfras(infraBasicInfoList){DataikuAPI.apideployer.listStages().success(stages=>{$scope.infraBasicInfoList=APIDeployerDeploymentUtils.sortedInfrasByStages(infraBasicInfoList,stages)}).error(setErrorInScope.bind($scope))}DataikuAPI.apideployer.infras.listBasicInfo().success(infraBasicInfoList=>{$scope.infraBasicInfoList=infraBasicInfoList.infras;if($scope.infraBasicInfoList.length==1){$scope.newDepl.infraId=$scope.infraBasicInfoList[0].id}fetchStagesThenSortInfras(infraBasicInfoList.infras)}).error(setErrorInScope.bind($scope));DataikuAPI.apideployer.publishedAPIServices.listBasicInfo().success(serviceBasicInfoList=>{$scope.serviceBasicInfoList=serviceBasicInfoList.services}).error(setErrorInScope.bind($scope));DataikuAPI.apideployer.publishedAPIServices.listLightStatus().success(function(serviceStatusList){$scope.serviceStatusList=serviceStatusList}).error(setErrorInScope.bind($scope));DataikuAPI.apideployer.deployments.listBasicInfo().success(deploymentBasicInfoList=>{$scope.deploymentIdList=deploymentBasicInfoList.deployments.map(depl=>depl.id)}).error(setErrorInScope.bind($scope));function setupVersionsIds(){if(!$scope.newDepl.publishedServiceId||!$scope.serviceBasicInfoList){return}$scope.versionsIds=[];for(let sbi of $scope.serviceBasicInfoList){if(sbi.id==$scope.newDepl.publishedServiceId){$scope.versionsIds=sbi.versionsIds;break}}if(!$scope.versionsIds.includes($scope.newDepl.versionId)){if($scope.versionsIds.length){$scope.newDepl.versionId=$scope.versionsIds[0]}else{delete $scope.newDepl.versionId}}}$scope.$watch("newDepl.publishedServiceId",setupVersionsIds);$scope.$watch("serviceBasicInfoList",setupVersionsIds);function autoSetDeploymentId(){if(!$scope.newDepl.publishedServiceId||!$scope.newDepl.infraId){return}let newDeplId=DeploymentUtils.sanitizeForK8S($scope.newDepl.publishedServiceId+"-on-"+$scope.newDepl.infraId);let counter=0;while(($scope.deploymentIdList||[]).indexOf(newDeplId+(counter?"-"+counter:""))>=0){counter++}$scope.newDepl.id=newDeplId+(counter?"-"+counter:"")}$scope.$watch("newDepl.publishedServiceId",autoSetDeploymentId);$scope.$watch("newDepl.infraId",autoSetDeploymentId);function setupEndpoints(){if(!$scope.newDepl.publishedServiceId||!$scope.newDepl.versionId||!$scope.serviceStatusList){return}const selectedInfra=$scope.infraBasicInfoList.find(e=>e.id===$scope.newDepl.infraId);$scope.selectedInfraType=typeof selectedInfra==="undefined"?null:selectedInfra.type;$scope.endpoints=[];for(let status of $scope.serviceStatusList){if(status.serviceBasicInfo.id==$scope.newDepl.publishedServiceId){for(let pkg of status.packages){if(pkg.id===$scope.newDepl.versionId){$scope.endpoints=pkg.endpoints;break}}break}}if(APIDeploymentInfraHelper.isFullyManagedInfra($scope.selectedInfraType)){if($scope.selectedInfraType==="DATABRICKS"){$scope.compatibleEndpoints=$scope.endpoints.filter(e=>$scope.isEndpointCompatibleWithDeployAnywhereDatabricks(e.type))}else{$scope.compatibleEndpoints=$scope.endpoints.filter(e=>$scope.isEndpointCompatibleWithDeployAnywhere(e.type))}if($scope.compatibleEndpoints.length){if(!$scope.compatibleEndpoints.map(e=>e.id).includes($scope.newDepl.endpointId)){$scope.newDepl.endpointId=$scope.compatibleEndpoints[0].id}}else{$scope.newDepl.endpointId=null}}}$scope.$watch("newDepl.publishedServiceId",setupEndpoints);$scope.$watch("newDepl.versionId",setupEndpoints);$scope.$watch("newDepl.infraId",setupEndpoints);$scope.$watch("serviceStatusList",setupEndpoints);$scope.ok=function(){return APIDeployerDeploymentService.openGovernanceStatusNewDeployment($scope.newDepl.publishedServiceId,$scope.newDepl.infraId,$scope.newDepl.versionId).then(function(){return DataikuAPI.apideployer.deployments.create($scope.newDepl.id,$scope.newDepl.publishedServiceId,$scope.newDepl.infraId,$scope.newDepl.versionId,$scope.newDepl.endpointId).success($scope.resolveModal).error(setErrorInScope.bind($scope))})}});app.controller("APIDeployerDeploymentController",function($controller,$scope,$state,WT1,DataikuAPI,Assert,CreateModalFromComponent,apiDeploymentModalDirective,CreateModalFromTemplate,FutureProgressModal,APIDeploymentInfraHelper,Ng2EndpointMetricsRefreshService,StaticApiDeploymentSyncHelper,APIDeployerDeploymentService,ActivityIndicator,STATIC_REFRESH_MODES,apiDeploymentDeletionDeleteServiceModalDirective){$controller("_DeployerDeploymentController",{$scope:$scope});$scope.unsavedTestQueries={};$scope.uiState=$scope.uiState||{};$scope.$watch("savedDeploymentSettings",()=>{if($scope.savedDeploymentSettings&&["STATIC","K8S"].includes($scope.savedDeploymentSettings.type)){if(!$scope.baseDeleteDeployment){$scope.baseDeleteDeployment=$scope.deleteDeployment}$scope.deleteDeployment=function(){if(!$scope.lightStatus){return}if($scope.savedDeploymentSettings.enabled){CreateModalFromComponent(apiDeploymentDeletionDeleteServiceModalDirective,null,["modal-medium"]).then(disableFirst=>{if(disableFirst){$scope.deploymentSettings.enabled=false;$scope.deployerAPIBase.deployments.save($scope.deploymentSettings).success(()=>{$scope.savedDeploymentSettings.enabled=false;const syncFunc=$scope.savedDeploymentSettings.type==="K8S"?DataikuAPI.apideployer.deployments.executeSyncDockerBased:deploymentId=>DataikuAPI.apideployer.deployments.executeSyncStatic(deploymentId,true);syncFunc($scope.lightStatus.deploymentBasicInfo.id).success(initialResponse=>{FutureProgressModal.show($scope,initialResponse,"Delete deployment").then($scope.reallyDeleteDeployment).error(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))}).error(setErrorInScope.bind($scope))}else{$scope.reallyDeleteDeployment()}})}else{$scope.baseDeleteDeployment()}}}else{if($scope.baseDeleteDeployment){$scope.deleteDeployment=$scope.baseDeleteDeployment}}});$scope.triggerMetricsRefresh=function(){Ng2EndpointMetricsRefreshService.triggerRefresh()};$scope.deployAPIDeployment=function(forceRebuild,skipGovernance){$scope.uiState.askMode=false;$scope.uiState.refreshMode=STATIC_REFRESH_MODES.FULL;$scope.uiState.rebuildCodeEnv=forceRebuild;$scope.uiState.skipGovernanceCheck=skipGovernance;$scope.deployOrUpdate()};$scope.updateAPIDeployment=function(forceRebuild,skipGovernance,isSaveAndUpdate=false){$scope.uiState.askMode=true;$scope.uiState.refreshMode=STATIC_REFRESH_MODES.LIGHT;$scope.uiState.rebuildCodeEnv=forceRebuild;$scope.uiState.skipGovernanceCheck=skipGovernance;$scope.deployOrUpdate(isSaveAndUpdate)};$scope.deployStatic=function(withPrepare=true){$scope.uiState.nextStep="DEPLOY";DataikuAPI.apideployer.deployments.executeSyncStatic($scope.lightStatus.deploymentBasicInfo.id,$scope.uiState.refreshMode==="FULL",withPrepare).success(function(data){$scope.openProgressModal(data.jobId)}).error(setErrorInScope.bind($scope))};$scope.onUpdateFinished=function(){$scope.getLightStatus();$scope.lightStatus.neverEverDeployed=false};$scope.openProgressModal=function(jobId){CreateModalFromComponent(apiDeploymentModalDirective,{deploymentId:$scope.lightStatus.deploymentBasicInfo.id,jobId:jobId,insufficientPermissionsMessage:$scope.insufficientPermissionsMessage(),lastDeploymentAction:$scope.lastDeploymentAction,deploymentType:$scope.savedDeploymentSettings.type,peekingUpdateStarted:$scope.onPeekingUpdateStarted,peekingUpdateEnded:$scope.fetchLastDeploymentActionUntilCanceled,deploy:APIDeploymentInfraHelper.isStaticInfra($scope.savedDeploymentSettings.type)?$scope.deployStatic:$scope.deployOrUpdate},["modal-w800","future-progress-modal"])};$scope.deployOrUpdate=function(isSaveAndUpdate=false){Assert.trueish($scope.lightStatus);const actionFn=()=>{if(APIDeploymentInfraHelper.isStaticInfra($scope.savedDeploymentSettings.type)){if($scope.uiState.askMode){StaticApiDeploymentSyncHelper.askMode($scope)}else{$scope.deployStatic()}}else{DataikuAPI.apideployer.deployments.executeSyncDockerBased($scope.lightStatus.deploymentBasicInfo.id,$scope.uiState.rebuildCodeEnv).success(function(data){$scope.openProgressModal(data.jobId)}).error(setErrorInScope.bind($scope))}};if($scope.uiState.skipGovernanceCheck){actionFn()}else{APIDeployerDeploymentService.openGovernanceStatusDeploymentId($scope.lightStatus.deploymentBasicInfo.id).then(actionFn)}if(!!$scope.lightStatus&&$scope.lightStatus.neverEverDeployed){WT1.event("api-deployer-deployment-deploy",{deploymentType:$scope.lightStatus.infraBasicInfo.type})}else if(isSaveAndUpdate){WT1.event("api-deployer-deployment-save-and-update",{deploymentType:$scope.lightStatus.infraBasicInfo.type,isDeploymentDisabled:!$scope.deploymentSettings.enabled})}else{WT1.event("api-deployer-deployment-update",{deploymentType:$scope.lightStatus.infraBasicInfo.type})}};$scope.diagnoseDeployment=function(){if(!$scope.lightStatus||!$scope.lightStatus.deploymentBasicInfo||!$scope.lightStatus.deploymentBasicInfo.id||!$scope.lightStatus.infraBasicInfo||$scope.lightStatus.infraBasicInfo.type=="STATIC"){return}DataikuAPI.apideployer.deployments.startDiagnosis($scope.lightStatus.deploymentBasicInfo.id).success(function(data){FutureProgressModal.show($scope,data,"Generating diagnostic").then(function(result){downloadURL(DataikuAPI.apideployer.deployments.getDiagnosisURL($scope.lightStatus.deploymentBasicInfo.id,result))})}).error(setErrorInScope.bind($scope))};$scope.getFullCheckReport=function(){if(!$scope.lightStatus||!$scope.heavyStatus||!$scope.lightStatus.deploymentBasicInfo||!$scope.lightStatus.deploymentBasicInfo.id||!["SAGEMAKER","SNOWPARK","AZURE_ML","DATABRICKS","VERTEX_AI"].includes($scope.lightStatus.infraBasicInfo.type)){return}$scope.uiState.loadingFullCheckReport=true;DataikuAPI.apideployer.deployments.getFullCheckReport($scope.lightStatus.deploymentBasicInfo.id).success(function(statusReport){$scope.uiState.loadingFullCheckReport=false;$scope.fullCheckReport=statusReport;ActivityIndicator.success("Deployment full check report retrieved successfully.")}).error(setErrorInScope.bind($scope)).error(function(){$scope.uiState.loadingFullCheckReport=false})};$scope.copyDeployment=function(){if(!$scope.lightStatus||!$scope.lightStatus.deploymentBasicInfo||!$scope.lightStatus.deploymentBasicInfo.id||!$scope.lightStatus.serviceBasicInfo||!$scope.lightStatus.serviceBasicInfo.id){return}return CreateModalFromTemplate("/templates/api-deployer/copy-deployment-modal.html",angular.extend($scope,{oldDepl:{id:$scope.lightStatus.deploymentBasicInfo.id,infraType:$scope.lightStatus.infraBasicInfo.type,endpointId:$scope.lightStatus.deploymentBasicInfo.endpointId,generationsMapping:$scope.lightStatus.deploymentBasicInfo.generationsMapping},newDepl:{publishedServiceId:$scope.lightStatus.serviceBasicInfo.id}})).then(function(newDeployment){$state.go("apideployer.deployments.deployment.status",{deploymentId:newDeployment.id});WT1.event("api-deployer-deployment-copy",{deploymentType:newDeployment.type})})};$scope.saveAndUpdateApiDeployment=function(forceRebuildCodeEnv){APIDeployerDeploymentService.openGovernanceStatusDeployment($scope.deploymentSettings).then(function(){$scope.saveDeployment().then(function(){$scope.updateAPIDeployment(forceRebuildCodeEnv,true,true)})})};$scope.saveApiDeployment=function(){WT1.event("api-deployer-deployment-save",{deploymentType:$scope.deploymentSettings.type,isDeploymentDisabled:!$scope.deploymentSettings.enabled});APIDeployerDeploymentService.openGovernanceStatusDeployment($scope.deploymentSettings).then(function(){$scope.saveDeployment()})};const allowedTransitions=["apideployer.deployments.deployment.status","apideployer.deployments.deployment.history","apideployer.deployments.deployment.settings"];checkChangesBeforeLeaving($scope,$scope.deploymentIsDirty,null,allowedTransitions);if(!$scope.deploymentSettings){$scope.getDeploymentSettings()}});app.controller("APIDeployerDeploymentStatusController",function($scope,$state,$filter,TopNav,DataikuAPI,DeployerUtils,DeployerDeploymentTileService,DataikuCloudService,UnifiedMonitoringService,CreateModalFromComponent,displayCodeModalDirective){$scope.refresh=function(){try{$scope.refreshLightAndHeavy()}finally{$scope.triggerMetricsRefresh()}};TopNav.setNoItem();TopNav.setLocation(TopNav.TOP_API_DEPLOYER,"deployments",null,"status");$scope.isCloud=DataikuCloudService.isDataikuCloud();$scope.chartURL=DataikuAPI.apideployer.deployments.chartURL;$scope.uiState={};$scope.setCurrentEndpoint=function(endpoint){$scope.currentEndpoint=endpoint};$scope.setCurrentEndpointId=function(endpointId){if($scope.heavyStatus&&$scope.heavyStatus.endpoints){const endpoint=$scope.heavyStatus.endpoints.find(e=>e.id===endpointId);$scope.setCurrentEndpoint(endpoint)}};$scope.goToSettings=function(){$state.go("apideployer.infras.infra.settings",{infraId:$scope.lightStatus.deploymentBasicInfo.infraId})};$scope.getModelOverallStatusIcon=function(monitoring){const status=monitoring?monitoring.umModelStatus:"NO_STATUS";return UnifiedMonitoringService.getStatusIcon(status)};$scope.getModelOverallStatusLabel=function(monitoring){const status=monitoring?monitoring.umModelStatus:"NO_STATUS";return UnifiedMonitoringService.getUMStatusDisplayLabels(status)};$scope.getGovernStatusIcon=function(monitoring){const status=monitoring?monitoring.umGovernanceStatus:"NO_STATUS";return UnifiedMonitoringService.getStatusIcon(status)};$scope.getGovernStatusLabel=function(monitoring){if(monitoring&&monitoring.governanceStatus&&monitoring.governanceStatus.validationStatus){return UnifiedMonitoringService.getGovernStatusLabel(monitoring.governanceStatus.validationStatus)}return"No governance status"};$scope.isEntryEndpoint=function(endpointId){return!!$scope.deploymentSettings&&!!$scope.deploymentSettings.endpointId&&endpointId===$scope.deploymentSettings.endpointId};$scope.isSampleCodeCompatibleEndpoint=function(endpointId){return!(["SAGEMAKER","AZURE_ML","VERTEX_AI","DATABRICKS"].includes($scope.lightStatus.infraBasicInfo.type)&&!$scope.isEntryEndpoint(endpointId))};$scope.isQueriesCompatibleEndpoint=function(endpointId){return!(["SAGEMAKER","AZURE_ML","VERTEX_AI","DATABRICKS","SNOWPARK"].includes($scope.lightStatus.infraBasicInfo.type)&&!$scope.isEntryEndpoint(endpointId))};$scope.isSampleCodeFullySupportedEndpoint=function(endpointId,language){return!(["SNOWPARK"].includes($scope.lightStatus.infraBasicInfo.type)&&!$scope.isEntryEndpoint(endpointId)&&language!=="PYTHON")};$scope.showEndpointCode=function(endpoint){CreateModalFromComponent(displayCodeModalDirective,{title:endpoint.id+" code details",text:endpoint.code},["modal-wide"])};$scope.$watch("lightStatus",function(nv){if(!nv||nv.neverEverDeployed){return}const entryEndpointId=nv.deploymentBasicInfo.endpointId;$scope.getHeavyStatus().then(function(data){$scope.heavyStatus=data.data;$scope.heavyStatus.endpoints=$scope.heavyStatus.endpoints.map(e=>{return{...e,t