(function() {
    'use strict';

    function buildDateDisplay(mainDateFormat, dateFormat, dateFilterOption, dateFilterOptionTimezone = 'UTC') {
        return {
            mainDateFormat,
            dateFormat,
            dateFilterOption,
            dateFilterOptionTimezone,
            formatDateFn: function(timestamp, formatToApply) {
                return d3.time.format.utc(formatToApply)(new Date(timestamp));
            }
        };
    }

    const CHART_DATES_LABELS = {
        DATE_DISPLAY_UNIT_DEFAULT: buildDateDisplay(undefined, '%Y-%m-%d', 'MMM d, y'),
        DATE_DISPLAY_UNIT_DAY_AND_MINUTES: buildDateDisplay(undefined, '%Y-%m-%d %H:%M', 'MMM d, y HH:mm'),
        DATE_DISPLAY_UNIT_MINUTES: buildDateDisplay('%Y-%m-%d', '%H:%M', 'HH:mm'),
        DATE_DISPLAY_UNIT_SECONDS: buildDateDisplay('%Y-%m-%d', '%H:%M:%S', 'HH:mm:ss'),
        DATE_DISPLAY_UNIT_MILLISECONDS: buildDateDisplay('%Y-%m-%d', '%H:%M:%S:%L', 'HH:mm:ss:sss')
    };

    const CHART_LABELS = {
        SUBTOTAL_BIN_LABEL: '___dku_total_value___',
        NO_RECORDS: 'No records'
    };

    angular.module('dataiku.charts')
        .constant('CHART_DATES_LABELS', CHART_DATES_LABELS)
        .constant('CHART_LABELS', CHART_LABELS);

}());
