(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    app.controller('ScatterMultiplePairsChartController', function($scope, ChartTypeChangeHandler, ChartUADimension, ChartAxesUtils, ChartsStaticData, translate) {
        $scope.dimensionPairs = _.clone($scope.chart.def.uaDimensionPair);
        const lastPair = $scope.dimensionPairs[$scope.dimensionPairs.length - 1];
        generateEmptyPlaceholder(lastPair);

        $scope.$watch('dimensionPairs', function(newValue) {
            let lastPair = newValue[newValue.length - 1];
            generateEmptyPlaceholder(lastPair);

            newValue.forEach((pair, i) => {
                autocompletePair(pair);
                if (ChartUADimension.isPairEmpty(pair) && !isLastPair(i)) {
                    $scope.dimensionPairs.splice(i, 1);
                }
            });

            const lastIndex = $scope.dimensionPairs.length - 1;
            lastPair = $scope.dimensionPairs[lastIndex];
            const newDimensionPairs = ChartUADimension.isPairEmpty(lastPair) ? $scope.dimensionPairs.slice(0, lastIndex) : $scope.dimensionPairs;
            const yAxesFormatting = [];
            const pairIds = ChartUADimension.createUaDimPairIds(newDimensionPairs);
            newDimensionPairs.forEach((pair, index) => {
                pair.id = pairIds[index];
                if (pair.id) {
                    let formatting = $scope.chart.def.yAxesFormatting.find(v => v.id === pair.id);
                    if (!formatting) {
                        formatting = ChartAxesUtils.initYAxesFormatting(pair.id);
                    }
                    yAxesFormatting.push(formatting);
                }
            });
            const basicChartsFormatting = $scope.chart.def.yAxesFormatting.filter(v => v.id === ChartsStaticData.LEFT_AXIS_ID || v.id === ChartsStaticData.RIGHT_AXIS_ID);
            $scope.chart.def.uaDimensionPair = [...newDimensionPairs];
            $scope.chart.def.yAxesFormatting = [...basicChartsFormatting, ...yAxesFormatting];
        }, true);

        $scope.scatterAcceptUaXDrop = function(data, pairIndex) {
            return ChartTypeChangeHandler.scatterMPAccept(data, $scope.chart.def, 'x', pairIndex);
        };

        $scope.scatterAcceptUaYDrop = function(data, pairIndex) {
            return ChartTypeChangeHandler.scatterMPAccept(data, $scope.chart.def, 'y', pairIndex);
        };

        $scope.getXDropzonePlaceholder = function(pairIndex) {
            const pair = $scope.dimensionPairs[pairIndex];
            if (pair.uaYDimension && pair.uaYDimension.length) {
                const uaXDimension = ChartUADimension.getPairUaXDimension($scope.dimensionPairs, pair);
                if (uaXDimension && uaXDimension.length) {
                    return uaXDimension[0].column;
                }
            }
            return translate('CHARTS.DEFINITION.SHARED.X_AXIS', 'Drop to set the X axis');
        };

        $scope.sortableOptions = {
            handle: '.handle'
        };

        function generateEmptyPlaceholder(lastPair) {
            if ((!lastPair || !ChartUADimension.isPairEmpty(lastPair)) && $scope.dimensionPairs.length < 5) {
                $scope.dimensionPairs.push({ uaXDimension: [], uaYDimension: [] });
            }
        };

        function autocompletePair(pair) {
            if (pair.uaXDimension.length) {
                ChartTypeChangeHandler.autocompleteUA(pair.uaXDimension[0]);
            }
            if (pair.uaYDimension.length) {
                ChartTypeChangeHandler.autocompleteUA(pair.uaYDimension[0]);
            }
        }

        $scope.removePair = function(index) {
            $scope.dimensionPairs.splice(index, 1);
        };

        $scope.isEmptyPlaceholder = index => ChartUADimension.isPairEmpty($scope.dimensionPairs[index]);

        function isLastPair(index) {
            return index === $scope.dimensionPairs.length - 1;
        }
    });
})();
