(function(){
'use strict';

    angular.module("dataiku.nestedFilters").directive('filterCondition', function (Expressions) {
        return {
            restrict:'A',
            link: function($scope, element, attrs) {
                if($scope.c){
                    $scope.c.$showList = false;
                }

                /*
                 * When changing filter condition's column (c.input), looking for an equivalent operator (c.operator)
                 * based on the current operator meaning or the current operator approximate equivalent meanings (as a fallback).
                 * Otherwise resetting it to default.
                 * example:
                 * - filter rule used to be 'DATE_COLUMN' is defined
                 * - user changes 'DATE_COLUMN' to 'STRING_COLUMN'
                 * - if we can find an operator with the same meaning as 'is defined' for string columns, then we update c.operator to it.
                 */
                $scope.$watch('c.input', function(nv, ov) {
                    if (nv && ov && nv !== ov) {
                        if (!$scope.$parent.fromPrepare) {
                            let newType = $scope.getColumnGenericType(nv)
                            let newOperators = $scope.getOperators(newType);
                            let oldOperator = $scope.getOperators($scope.getColumnGenericType(ov)).find(o => o.name === $scope.c.operator);
                            $scope.c.operator = Expressions.getDefaultOperator(newType); // setting first as default in case we don't find an equivalence
                            if (oldOperator) {
                                let equivalentOperator;
                                //looking for exact equivalence
                                if (oldOperator.meaning) {
                                    equivalentOperator = newOperators.find(o => o.meaning === oldOperator.meaning);
                                }
                                //looking for approximate equivalence
                                if (!equivalentOperator && oldOperator.approximateEquivalences) {
                                    for (let i=0; i<oldOperator.approximateEquivalences.length; i++) {
                                        let approximateEquivalence = oldOperator.approximateEquivalences[i];
                                        equivalentOperator = newOperators.find(o => o.meaning === approximateEquivalence);
                                        if (typeof(equivalentOperator) !== 'undefined') {
                                            break;
                                        }
                                    }
                                }
                                if (equivalentOperator) {
                                    $scope.c.operator = equivalentOperator.name;
                                }
                            }
                        }
                        else {
                            let newType = $scope.getColumnGenericType(nv);
                            let changedColType = newType !== $scope.getColumnGenericType(ov);
                            if (changedColType) {
                                let newOperatorName = Expressions.getDefaultOperator(newType);
                                $scope.c.$label = Expressions.getOperatorsPrepareRecipe().find(elt => elt.name === newOperatorName).label;
                            }
                        }
                    }
                });

                $scope.$watch('c.operator', () => {
                    $scope.populateWithDefaults($scope.c); // make sure that if we use a date operator, we have a valid condition
                })

                $scope.prioritizeAppliesTo = function(possibleAppliesTo) {
                    if (possibleAppliesTo.includes("none")) {
                        return "none";
                    } else if (possibleAppliesTo.includes("value")) {
                        return "value";
                    } else {
                        return "column";
                    }
                }

                $scope.$watch('c.$label', function(nv, ov) {
                    /**
                    When a user selects a new label :
                    - Find the possible corresponding operators depending on what they apply to (column, value..)
                    - If the previous appliesTo is possible with the new label, keep it. Otherwise select with priority none > value > column
                    - Given the label and the appliesTo, find the operator
                    **/
                    if($scope.$parent.fromPrepare && nv != ov) {
                        let possibleOperators = Expressions.getOperatorsPrepareRecipe().filter(op => op.label == $scope.c.$label);
                        let possibleAppliesTo = Expressions.getOperatorLabelAppliesTo($scope.c.$label);
                        if (!possibleAppliesTo.includes($scope.c.$appliesTo)) {
                            $scope.c.$appliesTo = $scope.prioritizeAppliesTo(possibleAppliesTo);
                        }
                        $scope.c.operator = Expressions.findOperator($scope.c.$label, $scope.c.$appliesTo).name;
                    }
                })

                $scope.$watch('c.$appliesTo', function(nv, ov) {
                    /**
                    When a user selects a new appliesTo :
                    Find the new operator based on the label and the applies to
                    **/
                    if($scope.$parent.fromPrepare && nv != ov) {
                        $scope.c.operator = Expressions.findOperator($scope.c.$label, $scope.c.$appliesTo).name;
                    }
                })

            }
        }
    });
})();
