/* global describe, beforeEach, module, inject, it, expect */

describe('ChartDataUtils', function() {
    beforeEach(() => {
        module('dataiku.charts');
        module(function($provide) { // Get rid of dependencies not needed for now
            $provide.value('ChartDimension', {});
            $provide.value('ChartMeasure', {});
            $provide.value('ChartUADimension', {});
            $provide.value('Fn', {});
            $provide.value('ChartsStaticData', {});
            $provide.value('CHART_TYPES', {});
            $provide.value('ChartLabels', {});
            $provide.value('$filter', () => {});
            $provide.value('translate', () => {});
        });
    });

    describe('computeDateDisplayUnit', function() {
        function checkDefaultValues(res) {
            expect(res.formattedMainDate).toBe(undefined);
            expect(res.dateFormat).toBe('%Y-%m-%d');
            expect(res.dateFilterOption).toBe('MMM d, y');
        }

        function checkDaysAndMinutes(res) {
            expect(res.formattedMainDate).toBe(undefined);
            expect(res.dateFormat).toBe('%Y-%m-%d %H:%M');
            expect(res.dateFilterOption).toBe('MMM d, y HH:mm');
        }

        function checkMinutes(res, expectedFormattedDate) {
            expect(res.formattedMainDate).toBe(expectedFormattedDate);
            expect(res.dateFormat).toBe('%H:%M');
            expect(res.dateFilterOption).toBe('HH:mm');
        }

        function checkSeconds(res, expectedFormattedDate) {
            expect(res.formattedMainDate).toBe(expectedFormattedDate);
            expect(res.dateFormat).toBe('%H:%M:%S');
            expect(res.dateFilterOption).toBe('HH:mm:ss');
        }

        function checkMilliSeconds(res, expectedFormattedDate) {
            expect(res.formattedMainDate).toBe(expectedFormattedDate);
            expect(res.dateFormat).toBe('%H:%M:%S:%L');
            expect(res.dateFilterOption).toBe('HH:mm:ss:sss');
        }

        it('computeDateDisplayUnit handles undefined timestamps', function() {
            inject(function(ChartDataUtils) {
                let result = ChartDataUtils.computeDateDisplayUnit();
                checkDefaultValues(result);
                const timestamp = Date.UTC(2013, 3, 10);
                result = ChartDataUtils.computeDateDisplayUnit(timestamp);
                checkDefaultValues(result);
                result = ChartDataUtils.computeDateDisplayUnit(undefined, timestamp);
                checkDefaultValues(result);
            });
        });

        it('computeDateDisplayUnit returns correct format', function() {
            inject(function(ChartDataUtils) {
                let timestampMin = Date.UTC(2013, 3, 10, 22, 25);
                let timestampMax = Date.UTC(2013, 3, 11, 22, 30);
                let result = ChartDataUtils.computeDateDisplayUnit(timestampMin, timestampMax);
                checkDefaultValues(result);
                timestampMin = Date.UTC(2013, 3, 10, 22, 25);
                timestampMax = Date.UTC(2013, 3, 11, 22, 15);
                result = ChartDataUtils.computeDateDisplayUnit(timestampMin, timestampMax);
                checkDaysAndMinutes(result);
                timestampMin = Date.UTC(2013, 3, 11, 0, 5);
                timestampMax = Date.UTC(2013, 3, 11, 22, 15);
                result = ChartDataUtils.computeDateDisplayUnit(timestampMin, timestampMax);
                const formattedExpectedDate = '2013-04-11';
                checkMinutes(result, formattedExpectedDate);
                timestampMin = Date.UTC(2013, 3, 11, 22, 12, 50);
                timestampMax = Date.UTC(2013, 3, 11, 22, 15);
                result = ChartDataUtils.computeDateDisplayUnit(timestampMin, timestampMax);
                checkMinutes(result, formattedExpectedDate);
                timestampMin = Date.UTC(2013, 3, 11, 22, 13, 10);
                timestampMax = Date.UTC(2013, 3, 11, 22, 15);
                result = ChartDataUtils.computeDateDisplayUnit(timestampMin, timestampMax);
                checkSeconds(result, formattedExpectedDate);
                timestampMin = Date.UTC(2013, 3, 11, 22, 13, 10);
                timestampMax = Date.UTC(2013, 3, 11, 22, 13, 12, 2);
                result = ChartDataUtils.computeDateDisplayUnit(timestampMin, timestampMax);
                checkSeconds(result, formattedExpectedDate);
                timestampMin = Date.UTC(2013, 3, 11, 22, 13, 10, 4);
                timestampMax = Date.UTC(2013, 3, 11, 22, 13, 12, 2);
                result = ChartDataUtils.computeDateDisplayUnit(timestampMin, timestampMax);
                checkMilliSeconds(result, formattedExpectedDate);
            });
        });
    });
});
